# vim:smartindent cinwords=if,elif,else,for,while,try,except,finally,def,class:ts=4:sts=4:sta:et:ai:shiftwidth=4
# Copyright (C) 2005 Canonical Limited
#       Authors: Robert Collins <robert.collins@canonical.com>
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.

# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.

# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

import sys

from twisted.application import internet, service
from twisted.internet import protocol, reactor, defer
from twisted.protocols import basic
from twisted.web import resource, server, static
import cgi

import arch_pqm
import logging

class QueueResource(resource.Resource):
    """A resource that shows a PQM queue."""

    def __init__(self, queue):
        self.queue = queue
        resource.Resource.__init__(self)

    def getChild(self, path, request):
        """Get a child of the queue"""
        if path:
            return static.Data("<h1>Please visit the root</h1>", 'text/html')
        text = "<h1>PQM Queue: %d commands</h1><ol>" % len(self.queue.messages)
        for message in self.queue.messages:
            text += "<li><p>%s: %s, '%s', %s </p></li>" % (
                message.filename,
                message.getSender(),
                message.getSubject(),
                message.getLines()[0])
        text += "</ol>"
        return static.Data(text, 'text/html')

class PQMService(service.Service):

    def __init__(self, filenames):
        self.filenames = filenames
        self.call = reactor.callLater(0, self._read)

    def _read(self):
        configp = arch_pqm.ConfigParser()
        configp.read(self.filenames)
        queuedir = arch_pqm.get_queuedir(configp, logging, [])
        self.messages = arch_pqm.find_patches(queuedir, logging, False)
        self.call = reactor.callLater(30, self._read)

    def getResource(self):
        r = QueueResource(self)
        return r
    
application = None
def main(argv):
    global application
    application = service.Application('pqm')
    f = PQMService(arch_pqm.configfile_names)
    serviceCollection = service.IServiceCollection(application)
    internet.TCPServer(8000, server.Site(f.getResource())).setServiceParent(serviceCollection)
    
if __name__ == '__builtin__':
    main(sys.argv)
