/* An error class that captures all of the necessary data.

   Copyright 2003 Walter Landry

   This program is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public License as
   published by the Free Software Foundation; either version 2 of the
   License, or (at your option) any later version.

   This program is distributed in the hope that it will be useful, but
   WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
   USA */

#ifndef ARX_ARX_ERROR_HPP
#define ARX_ARX_ERROR_HPP

#include <string>
#include <stdexcept>
#include "Command_Info.hpp"

class arx_error: public std::runtime_error
{
public:
  int error_code;
  arx_error(const std::string &message,
            const int &code=1):
    std::runtime_error(message), error_code(code) {}
};

#endif
