package ASD::Statistics;

#     This file is part of asd.
    
#     asd is free software; you can redistribute it and/or modify
#     it under the terms of the GNU General Public License as published by
#     the Free Software Foundation; either version 2 of the License, or
#     (at your option) any later version.

#     This program is distributed in the hope that it will be useful,
#     but WITHOUT ANY WARRANTY; without even the implied warranty of
#     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#     GNU General Public License for more details.

#     You should have received a copy of the GNU General Public License
#     along with this program; if not, write to the Free Software
#     Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

#     asd 0.2 Copyright 2004 Antonini Daniele <arpeda@gmail.com>

use strict;
use warnings;
use File::stat;

require Exporter;
require 5.005;

our @ISA = qw(Exporter);

# Items to export into callers namespace by default. Note: do not export
# names by default without a very good reason. Use EXPORT_OK instead.
# Do not simply export all your public functions/methods/constants.

# This allows declaration	use ASD::Function ':all';
# If you do not need this, moving things directly into @EXPORT or @EXPORT_OK
# will save memory.
our %EXPORT_TAGS = ( 'all' => [ qw( stat_man_page_to_analize
				    print_initial_statistics
				    print_updated_statistics
				    print_end_statistics ) ] );

our @EXPORT_OK = ( @{ $EXPORT_TAGS{'all'} } );

our @EXPORT = qw();

our $VERSION = '0.01';

my %color = ( 'green' => "\033[0;40;32m",
	      'normal' => "\033[0m",
	      'bold' => "\033[1m" );

#return an array with number man_page_to_analize and total size 
sub stat_man_page_to_analize {
    my $ref_manpath_dir = shift;
    my $dir_get_opt = shift;
    my $ref_file_get_opt = shift;

    my $size_total = 0;
    my $num_man_page = 0;

    my @statistics = ();

    print " $color{'green'}*$color{'normal'} Calculating size ...";

    foreach my $man_page_dir ( @$ref_manpath_dir ) {
	next if ( -l $man_page_dir );

	my @man_page_section = `ls $man_page_dir 2>/dev/null | grep man`;
	foreach my $section ( @man_page_section ) {

	    my $current_dir = undef;
	    my @man_page_to_examine = ();

	    chop($section);
	    $current_dir = $man_page_dir."/".$section;
	    $current_dir = $dir_get_opt if ( $dir_get_opt );
	    next if ( -l $current_dir );

	    @man_page_to_examine = `ls -1 $current_dir 2>/dev/null`;
	    if ( @$ref_file_get_opt ) {
		
		my @tmp;
		
		@man_page_to_examine = ();
		for my $i ( 0.. $#$ref_file_get_opt ) {
		    
		    @tmp = split( /\//, $ref_file_get_opt->[$i] );
		    $man_page_to_examine[$i] = pop @tmp;
		}
		
		$current_dir = join('/', @tmp );
	    }

	    foreach my $current_man_page ( @man_page_to_examine ) {

		my $st = undef;

		chop($current_man_page) unless ( @$ref_file_get_opt );
		next if ( -l $current_dir."/".$current_man_page );
		
		$st = stat( $current_dir."/".$current_man_page ) or die "$current_dir/$current_man_page";
		$size_total += ($st->size);
		$num_man_page ++;
	    }
	    last if ( @$ref_file_get_opt );
	    
	}
	last if ( @$ref_file_get_opt || $dir_get_opt );
    }

    print " done\n";
    push @statistics, $num_man_page;
    push @statistics, $size_total;

    return @statistics;
}

# updated statistics
sub print_updated_statistics {
    my $num_man_pages = shift;

    my $string_num_man_page = sprintf "%\ 6d",$$num_man_pages;

    syswrite STDOUT,"\b\b\b\b\b\b";
    syswrite STDOUT,"$string_num_man_page";
}

# print some statistics and return text 
sub print_initial_statistics {
    my $ref_statistics = shift;

    my $string_num_man_page = sprintf "%\ 6d",$ref_statistics->[0];
    my $string_size_total = sprintf "%\ 8d",($ref_statistics->[1]/1024);

    my $text =" compressed files for $color{'bold'}$string_size_total Kb$color{'normal'}";
    my $text_no_color=" compressed files for $string_size_total Kb";
    
    syswrite STDOUT,"$color{'green'} *$color{'normal'} indexing: $string_num_man_page".$text;
    
    for my $i (0..length( $text_no_color )-1){
	syswrite STDOUT,"\b";
    }

    return $text;
}

sub print_end_statistics {
    
    my $num_man_pages = shift;
    my $index_file = shift;
    my $duplicate = shift;
    my $empty = shift;
    my $true_man_pages = shift;
    my $occurrence_get_opt = shift;
    
    print " $color{'green'}*$color{'normal'} indexed $color{'bold'}$num_man_pages $color{'normal'}files:\n";
    print " \tman pages: $color{'bold'}$true_man_pages $color{'normal'}\n";
    print " \tduplicated man pages: $color{'bold'}$duplicate $color{'normal'}\n" if ( $duplicate );
    print " \tempty man pages: $color{'bold'}$empty $color{'normal'}\n" if ( $empty );    

    _print_stat_with_occurrence( $index_file ) if ( $occurrence_get_opt);
    _print_stat_without_occurrence( $index_file ) unless ( $occurrence_get_opt);
}

sub _print_stat_without_occurrence {
    my $ref = shift;
    my $size = 0;
    my $st;
    
    print " $color{'green'}*$color{'normal'} size of asd-index:\n";

    $st = stat( $ref->{'man_page_title'} );
    $size = ($st->size)/1024;
    print "\tman_page_title: $color{'bold'}".sprintf("%.0f",$size)." Kb$color{'normal'}\n";
    
    $st = stat( $ref->{'lessico'} );
    $size = ($st->size)/1024;
    print "\tlessico: $color{'bold'}".sprintf("%.0f", $size)." Kb$color{'normal'}\n";

    $st = stat( $ref->{'document'} );
    $size = ($st->size)/1024;
    print "\tinverted list: $color{'bold'}".sprintf("%.0f",$size)." Kb$color{'normal'}\n";
}

sub _print_stat_with_occurrence {
    my $ref = shift;

    my $size = 0;
    my $st;

    _print_stat_without_occurrence( $ref );

    $st = stat( $ref->{'occurrence'} );
    $size = ($st->size)/1024;
    print "\toccurrence: $color{'bold'}".sprintf("%.0f",$size)." Kb$color{'normal'}\n";
}
