<?php

class XSLT {
	
	var $Extension;
	var $encoding;
	var $XML_str;
	var $XSL_str;
	var $XSL_parameters;
	
	// Debug
	var $DEBUG_mod = true;
	
	// Transformation en ligne de commande
	// Avec xsltproc , sablotron ou xalan
	//
	var $SABLOTRON_url = '/usr/bin/sabcmd';
	var $XSLTPROC_url='/usr/bin/xsltproc';
	var $XALAN_url = '/usr/bin/testXSLT';
	
	function XSLT($extension = '') {
		if($extension) {
			switch(strtolower($extension)) {
				case 'dom' :
				case 'domxml' :
				$this->Extension = 'domxml';
				break;				
				default :
				$this->Extension = 'xslt';
				break;
			}
			
			if(!extension_loaded($this->Extension))
			die('Install ' . $this->Extension . ' extension');
		}
		
		$this->encoding = 'ISO-8859-1';
		$this->XML_str = '';
		$this->XSL_str = '';
		$this->XSL_parameters = array();
	}
	
	function Load_XML_from_file($file){
		$this->XML_str = trim(file_get_contents($file));
	}
	
	function Load_XML_from_str($str) {
		$this->XML_str = trim($str);
	}
	
	function Load_XSL_from_file($file) {
		$this->XSL_str = trim(file_get_contents($file));
	}
	
	function Load_XSL_from_str($str) {
		$this->XSL_str = trim($str);
	}
	
	function Set_encoding($encoding) {
		$this->encoding = $encoding;
	}
	
	function Add_XSL_parameter($key, $val) {
		$this->XSL_parameters[$key] = $val;
	}
	
	//
	function Output() {
		if($this->Extension === 'xslt') {
			
			$arguments = array(
			'/_xml' => $this->XML_str,
			'/_xsl' => $this->XSL_str
			);
			
			$xsltproc = xslt_create();		
			xslt_set_encoding ($xsltproc, $this->encoding);	
			$html = xslt_process(
			$xsltproc,
			'arg:/_xml',
			'arg:/_xsl',
			NULL,
			$arguments,
			$this->XSL_parameters
			);
			
			if (!$html)
			die('XSLT processing error: '.xslt_error($xsltproc));
			
			xslt_free($xsltproc);
		}
		else {
			$xmldoc = domxml_open_mem($this->XML_str);
			$xsldoc = domxml_xslt_stylesheet ($this->XSL_str);
			$result = $xsldoc->process($xmldoc, $this->XSL_parameters);
			$html = $xsldoc->result_dump_mem($result);
			if (!$html)
			die('DOMXML - XSLT processing error');
		}
		
		return $html;
		
		
	}
	
	function XSLTPROC_shell_transform($xsl_file, $xml_file, $params=null) {
		$options = '';
		if(is_array($params))
		foreach($params as $key => $val) {
			$options .= " --param $key \"'".addslashes($val)."'\" ";
		}
		$command = $this->XSLTPROC_url.$options.' '.$xsl_file.' '.$xml_file;
		//echo $command;
		exec($command, $T, $return);
		if(!$return)
		return implode('', $T);
		else
		return 'XSLTPROC processing error !';
	}
	
	function SABLOTRON_shell_transform($xsl_file, $xml_file, $params=null) {
		// Type >> $ sabcmd --help in a console (as ROOT) to vIew options
		$options = '';
		if(is_array($params))
		foreach($params as $key => $val) {
			$options .= ' \'$'.$key.'='.addslashes($val).'\'';
		}
		
		$command = $this->SABLOTRON_url.' '.$xsl_file.' '.$xml_file.$options;
		//echo $command;
		@exec($command, $T, $return);
		if(!$return)
		return implode('', $T);
		else
		return '<strong>SABLOTRON processing error ! </strong><br/>';
	}
	
	function XALAN_shell_transform($xsl_file, $xml_file, $params=null) {
		$options = '';
		if(is_array($params))
		foreach($params as $key => $val) {
			$options .= ' -PARAM '.$key.' "\''.addslashes($val).'\'"';
		}
		
		$command = $this->XALAN_url.' -IN '.$xml_file.' -XSL '.$xsl_file.$options;
		//echo $command;
		@exec($command, $T, $return);
		if(!$return)
		return implode('', $T);
		else
		return '<strong>XALAN processing error ! </strong><br/>';
	}
	
	
}// end class

?>
