<?xml version="1.0" encoding="ISO-8859-1"?>

<xsl:stylesheet version="1.0" 
xmlns:xsl="http://www.w3.org/1999/XSL/Transform">

<xsl:output method="xml" version="1.0"  indent="yes" omit-xml-declaration="yes"
 media-type="text/html" />
 
 <!-- Inclusion de la template contenant les dates en toutes lettres -->
<xsl:include href="./ex.XSLT.8.php.src"/>
	
<xsl:param name="limit"/> 
<!-- Les 2 couleurs pour l alternance -->
<xsl:variable name="Color-1">yellow</xsl:variable>
<xsl:variable name="Color-2">grey</xsl:variable>

<xsl:template name="display-item">
	<xsl:param name="color"/>
	<li style="background-color:{$color};">
			<xsl:variable name="annee" select="substring-before(@date, '-')"/>
			<xsl:variable name="temp" select="substring-after(@date, '-')"/>
			<xsl:variable name="mois" select="substring-before($temp, '-')"/>
			<xsl:variable name="jour" select="substring-after($temp, '-')"/>
			<xsl:variable name="mois-lettres" select="$lesmois[@m=$mois]/@nom"/>
			<!-- 
			Jour en toutes lettres
			trouv chez O'reilly
			-->
			<xsl:variable name="a" select="floor((14 - $mois) div 12)"/>
			<xsl:variable name="y" select="$annee - $a"/>
			<xsl:variable name="m" select="$mois + 12 * $a - 2"/>
			<xsl:variable name="jour-lettres" select="$lesjours[@j=($jour + $y + floor($y div 4) - floor($y div 100)
			 + floor($y div 400) + floor((31 * $m) div 12)) mod 7]/@nom"/>

			<strong>
				<xsl:value-of select="concat($jour-lettres,' ',$jour,' ',$mois-lettres,' ',$annee)"/>
			</strong>	
			<xsl:text>:::</xsl:text>
			<xsl:value-of select="text()"/>			
	</li>
</xsl:template>

<xsl:template match="/">
<xsl:value-of select="$lesmois[@m=01]/@nom"/>
	<xsl:variable name="url" select="root/url"/>
	<xsl:variable name="language" select="root/language"/>
	<h1>
		<a href="{$url}" hreflang="{$language}">
			<xsl:value-of select="root/title"/>
		</a>
	</h1>
	<ul style="width:30%;" >
		<xsl:for-each select="root/item[ position() &lt;= $limit ]">
			<xsl:sort select="@date" data-type="text" order="ascending"/>
	
			<!-- Test sur le modulo et appel de la template avec le bon parametre -->
			<xsl:choose>
				<xsl:when test="position() mod 2 = 0">
					<xsl:call-template name="display-item">
						<xsl:with-param name="color" select="$Color-1"/>
					</xsl:call-template>
				</xsl:when>
				<xsl:otherwise>
					<xsl:call-template name="display-item">
						<xsl:with-param name="color" select="$Color-2"/>
					</xsl:call-template>
				</xsl:otherwise>
			</xsl:choose>
			
		</xsl:for-each>
	</ul>
</xsl:template>

</xsl:stylesheet>