<?xml version="1.0"?>

<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">

<xsl:output method="xml" version="1.0"  indent="yes" omit-xml-declaration="yes"
 media-type="text/html" />

<xsl:param name="limit"/>

<xsl:template match="/">

	<xsl:variable name="url" select="root/url"/>
	<xsl:variable name="language" select="root/language"/>
	<h1>
		<a href="{$url}" hreflang="{$language}">
			<xsl:value-of select="root/title"/>
		</a>
	</h1>
	<ul>
		<xsl:for-each select="root/item[ position() &lt;= $limit ]">
		<xsl:sort select="@date" data-type="text" order="ascending"/>
			<li>
				<strong><xsl:value-of select="@date"/></strong>
				<xsl:text>:::</xsl:text>
				<xsl:value-of select="text()"/>
			</li>
		</xsl:for-each>
	</ul>
</xsl:template>

</xsl:stylesheet>