<?xml version="1.0" encoding="ISO-8859-1"?>

<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
<xsl:output method="xml" version="1.0"  indent="yes" omit-xml-declaration="yes"
 media-type="text/html" />
 
 <!-- Inclusion de la template contenant les dates en toutes lettres -->
<xsl:include href="ex.XSLT.8.php.src"/>

<xsl:param name="limit"/>

<xsl:template match="/">

	<xsl:variable name="url" select="root/url"/>
	<xsl:variable name="language" select="root/language"/>
	<h1>
		<a href="{$url}" hreflang="{$language}">
			<xsl:value-of select="root/title"/>
		</a>
	</h1>
	<ul>
		<xsl:for-each select="root/item[ position() &lt;= $limit ]">
			<xsl:sort select="@date" data-type="text" order="ascending"/>
	
			<!-- Anne -->
			<xsl:variable name="annee" select="substring-before(@date, '-')"/>
			<!-- variable temporaire -->
			<xsl:variable name="temp" select="substring-after(@date, '-')"/>
			<!-- Mois -->
			<xsl:variable name="mois" select="substring-before($temp, '-')"/>
			<!-- Jour -->
			<xsl:variable name="jour" select="substring-after($temp, '-')"/>
			<!-- Mois en toutes lettres -->
			<xsl:variable name="mois-lettres" select="$lesmois[@m=$mois]/@nom"/>
			<!-- 
			Jour en toutes lettres
			trouv chez O'reilly
			-->
			<xsl:variable name="a" select="floor((14 - $mois) div 12)"/>
			<xsl:variable name="y" select="$annee - $a"/>
			<xsl:variable name="m" select="$mois + 12 * $a - 2"/>
			<xsl:variable name="jour-lettres" select="$lesjours[@j=($jour + $y + floor($y div 4) - floor($y div 100)
			 + floor($y div 400) + floor((31 * $m) div 12)) mod 7]/@nom"/>
				<!-- Voila, on a tout, on recompose la chaine -->	
			<li>		
				<strong>
					<xsl:value-of select="concat($jour-lettres,' ',$jour,' ',$mois-lettres,' ',$annee)"/>
				</strong>	
				<xsl:text>:::</xsl:text>
				<xsl:value-of select="text()"/>
			</li>
		</xsl:for-each>
	</ul>
</xsl:template>

</xsl:stylesheet>