--
-- PostgreSQL database dump
--

-- Started on 2009-02-08 16:28:55 CET

SET client_encoding = 'UTF8';
SET check_function_bodies = false;
SET client_min_messages = warning;

--
-- TOC entry 5 (class 2615 OID 2595582)
-- Name: contraintes; Type: SCHEMA; Schema: -; Owner: pgsql
--

CREATE SCHEMA contraintes;


ALTER SCHEMA contraintes OWNER TO pgsql;

--
-- TOC entry 7195 (class 0 OID 0)
-- Dependencies: 6
-- Name: SCHEMA public; Type: COMMENT; Schema: -; Owner: postgres
--

COMMENT ON SCHEMA public IS 'Standard public schema';


--
-- TOC entry 7 (class 2615 OID 2595583)
-- Name: v2; Type: SCHEMA; Schema: -; Owner: pgsql
--

CREATE SCHEMA v2;


ALTER SCHEMA v2 OWNER TO pgsql;

--
-- TOC entry 2983 (class 2612 OID 2595584)
-- Name: plpgsql; Type: PROCEDURAL LANGUAGE; Schema: -; Owner: 
--

CREATE PROCEDURAL LANGUAGE plpgsql;


SET search_path = contraintes, pg_catalog;

--
-- TOC entry 2150 (class 1247 OID 2595586)
-- Dependencies: 3917
-- Name: evolution; Type: TYPE; Schema: contraintes; Owner: pgsql
--

CREATE TYPE evolution AS (
	fait integer,
	total integer
);


ALTER TYPE contraintes.evolution OWNER TO pgsql;

--
-- TOC entry 2151 (class 1247 OID 2595588)
-- Dependencies: 3918
-- Name: fw_organisme_type_individu; Type: TYPE; Schema: contraintes; Owner: pgsql
--

CREATE TYPE fw_organisme_type_individu AS (
	id integer,
	nom character varying,
	prenom character varying,
	organisme integer,
	types integer[]
);


ALTER TYPE contraintes.fw_organisme_type_individu OWNER TO pgsql;

--
-- TOC entry 2152 (class 1247 OID 2595590)
-- Dependencies: 3919
-- Name: intkey_boolvalue; Type: TYPE; Schema: contraintes; Owner: pgsql
--

CREATE TYPE intkey_boolvalue AS (
	"key" integer,
	bool boolean
);


ALTER TYPE contraintes.intkey_boolvalue OWNER TO pgsql;

--
-- TOC entry 2153 (class 1247 OID 2595592)
-- Dependencies: 3920
-- Name: organisme_type_individu; Type: TYPE; Schema: contraintes; Owner: pgsql
--

CREATE TYPE organisme_type_individu AS (
	id integer,
	nom character varying,
	prenom character varying,
	organisme integer,
	types integer[]
);


ALTER TYPE contraintes.organisme_type_individu OWNER TO pgsql;

--
-- TOC entry 2154 (class 1247 OID 2595594)
-- Dependencies: 3921
-- Name: parents; Type: TYPE; Schema: contraintes; Owner: postgres
--

CREATE TYPE parents AS (
	id integer,
	pere integer,
	ind integer
);


ALTER TYPE contraintes.parents OWNER TO postgres;

--
-- TOC entry 2155 (class 1247 OID 2595596)
-- Dependencies: 3922
-- Name: type_element; Type: TYPE; Schema: contraintes; Owner: pgsql
--

CREATE TYPE type_element AS (
	id character varying,
	libelle character varying
);


ALTER TYPE contraintes.type_element OWNER TO pgsql;

SET search_path = v2, pg_catalog;

--
-- TOC entry 2156 (class 1247 OID 2595598)
-- Dependencies: 3923
-- Name: intkey_boolvalue; Type: TYPE; Schema: v2; Owner: pgsql
--

CREATE TYPE intkey_boolvalue AS (
	"key" integer,
	bool boolean
);


ALTER TYPE v2.intkey_boolvalue OWNER TO pgsql;

--
-- TOC entry 2157 (class 1247 OID 2595600)
-- Dependencies: 3924
-- Name: organisme_type_individu; Type: TYPE; Schema: v2; Owner: pgsql
--

CREATE TYPE organisme_type_individu AS (
	id integer,
	nom character varying,
	prenom character varying,
	organisme integer,
	types integer[]
);


ALTER TYPE v2.organisme_type_individu OWNER TO pgsql;

--
-- TOC entry 2158 (class 1247 OID 2595602)
-- Dependencies: 3925
-- Name: parents; Type: TYPE; Schema: v2; Owner: postgres
--

CREATE TYPE parents AS (
	id integer,
	pere integer,
	ind integer
);


ALTER TYPE v2.parents OWNER TO postgres;

--
-- TOC entry 2159 (class 1247 OID 2595604)
-- Dependencies: 3926
-- Name: type_element; Type: TYPE; Schema: v2; Owner: pgsql
--

CREATE TYPE type_element AS (
	id character varying,
	libelle character varying
);


ALTER TYPE v2.type_element OWNER TO pgsql;

SET search_path = contraintes, pg_catalog;

--
-- TOC entry 828 (class 1255 OID 2595605)
-- Dependencies: 2983 5
-- Name: af_check_formation_evenement(integer, date, time without time zone, time without time zone, time without time zone, character varying, integer); Type: FUNCTION; Schema: contraintes; Owner: pgsql
--

CREATE FUNCTION af_check_formation_evenement(integer, date, time without time zone, time without time zone, time without time zone, character varying, integer) RETURNS integer[]
    AS $_$-- $1 : numero formation
-- $2 : date
-- $3 : debut
-- $4 : fin
-- $5 : ancien debut
-- $6 : mode ('add' ou 'edit')
-- $7 : copie
declare
rec record;
classe int4;
tab_conflit _int4;
i int4:=0;
begin
    -- Teste sur les heures debut et fin
    if $6='edit' and $7 is null then
	perform * from contraintes.af_get_evenements_dates($2,$3,$4) 
	as (formation int4,libelle varchar,date timestamp,duree interval,modalite int4,intervention int4,intervenant int4,salle int4)
	where formation=$1 
	and cast(date as time)!=$5;
    else
	perform * from contraintes.af_get_evenements_dates($2,$3,$4) 
	as (formation int4,libelle varchar,date timestamp,duree interval,modalite int4,intervention int4,intervenant int4,salle int4)
	where formation=$1; 
    end if;
    if found then
	tab_conflit[i]:=1;
	i:=i+1;
    end if;
	
    -- teste si le groupe n'est pas pris à ces heures dans d'autres formations
    -- recup du numero de classe
    select into rec * from contraintes.af_get_formation_classes($1) as(id int4,libelle varchar, pere int4,min int4,max int4);
    classe=rec.id;
    perform * from contraintes.af_get_evenements_dates($2,$3,$4) 
    as (ed_formation int4,ed_libelle varchar,ed_date timestamp,ed_duree interval,ed_modalite int4,ed_intervention int4,ed_intervenant int4,ed_salle int4) ,
    contraintes.formation_participants fp
    where (ed_formation=fp.formation and classe=fp.classe)

    and ed_formation!=$1
    and cast(ed_date as time)!=$5;
	
    if found then
	tab_conflit[i]:=2;
	i:=i+1;
    end if;

    -- teste si la salle est libre

    perform * from contraintes.af_get_evenements_dates($2,$3,$4) 
    as (ed_formation int4,ed_libelle varchar,ed_date timestamp,ed_duree interval,ed_modalite int4,ed_intervention int4,ed_intervenant int4,ed_salle int4) ,
    contraintes.af_get_evenements() 
    as (ef_formation int4,ef_libelle varchar,ef_date timestamp,ef_duree interval,ef_modalite int4,ef_intervention int4,ef_intervenant int4,ef_salle int4)
    where ed_salle=ef_salle
    and not (cast(ed_date as time)=$5 and ed_formation=$1); 
    if found then
	tab_conflit[i]:=3;
	i:=i+1;
    end if;

    -- teste si l'intervenant est libre
    perform * from contraintes.af_get_evenements_dates($2,$3,$4) 
    as (ed_formation int4,ed_libelle varchar,ed_date timestamp,ed_duree interval,ed_modalite int4,ed_intervention int4,ed_intervenant int4,ed_salle int4) ,
    contraintes.af_get_evenements() 
    as (ef_formation int4,ef_libelle varchar,ef_date timestamp,ef_duree interval,ef_modalite int4,ef_intervention int4,ef_intervenant int4,ef_salle int4)
    where ed_intervenant=ef_intervenant
    and not (cast(ed_date as time)=$5 and ed_formation=$1); 
    if found then
	tab_conflit[i]:=4;
	i:=i+1;
    end if;
    --raise notice '%,%',tab_conflit[0],tab_conflit[1];
    return tab_conflit;
end;$_$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_check_formation_evenement(integer, date, time without time zone, time without time zone, time without time zone, character varying, integer) OWNER TO pgsql;

--
-- TOC entry 7198 (class 0 OID 0)
-- Dependencies: 828
-- Name: FUNCTION af_check_formation_evenement(integer, date, time without time zone, time without time zone, time without time zone, character varying, integer); Type: COMMENT; Schema: contraintes; Owner: pgsql
--

COMMENT ON FUNCTION af_check_formation_evenement(integer, date, time without time zone, time without time zone, time without time zone, character varying, integer) IS 'retourne un tableau de conflits pour un evenement de formation';


--
-- TOC entry 829 (class 1255 OID 2595606)
-- Dependencies: 2983 5
-- Name: af_del_alerte(integer); Type: FUNCTION; Schema: contraintes; Owner: pgsql
--

CREATE FUNCTION af_del_alerte(integer) RETURNS boolean
    AS $_$-- $1 : numero alerte
begin
    delete from contraintes.alerte where id=$1;
    return found;
end;$_$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_del_alerte(integer) OWNER TO pgsql;

--
-- TOC entry 7200 (class 0 OID 0)
-- Dependencies: 829
-- Name: FUNCTION af_del_alerte(integer); Type: COMMENT; Schema: contraintes; Owner: pgsql
--

COMMENT ON FUNCTION af_del_alerte(integer) IS 'supprime une alerte';


--
-- TOC entry 830 (class 1255 OID 2595607)
-- Dependencies: 2983 5
-- Name: af_del_bareme(integer); Type: FUNCTION; Schema: contraintes; Owner: pgsql
--

CREATE FUNCTION af_del_bareme(integer) RETURNS boolean
    AS $_$-- $1 : numero bareme
begin
    delete from contraintes.bareme where id=$1;
    return found;
end;$_$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_del_bareme(integer) OWNER TO pgsql;

--
-- TOC entry 7202 (class 0 OID 0)
-- Dependencies: 830
-- Name: FUNCTION af_del_bareme(integer); Type: COMMENT; Schema: contraintes; Owner: pgsql
--

COMMENT ON FUNCTION af_del_bareme(integer) IS 'supprime un bareme';


--
-- TOC entry 831 (class 1255 OID 2595608)
-- Dependencies: 2983 5
-- Name: af_del_capacite(integer); Type: FUNCTION; Schema: contraintes; Owner: pgsql
--

CREATE FUNCTION af_del_capacite(integer) RETURNS boolean
    AS $_$-- $1 : numero capacite
begin
    delete from contraintes.capacite where id=$1;
    return found;
end;$_$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_del_capacite(integer) OWNER TO pgsql;

--
-- TOC entry 7204 (class 0 OID 0)
-- Dependencies: 831
-- Name: FUNCTION af_del_capacite(integer); Type: COMMENT; Schema: contraintes; Owner: pgsql
--

COMMENT ON FUNCTION af_del_capacite(integer) IS 'supprime une capacite';


--
-- TOC entry 832 (class 1255 OID 2595609)
-- Dependencies: 2983 5
-- Name: af_del_capacite_titre(integer); Type: FUNCTION; Schema: contraintes; Owner: pgsql
--

CREATE FUNCTION af_del_capacite_titre(integer) RETURNS boolean
    AS $_$-- $1 : numero capacite_titre
begin
    delete from contraintes.capacite_titre where id=$1;
    return found;
end;$_$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_del_capacite_titre(integer) OWNER TO pgsql;

--
-- TOC entry 7206 (class 0 OID 0)
-- Dependencies: 832
-- Name: FUNCTION af_del_capacite_titre(integer); Type: COMMENT; Schema: contraintes; Owner: pgsql
--

COMMENT ON FUNCTION af_del_capacite_titre(integer) IS 'supprime un titre de capacite';


--
-- TOC entry 833 (class 1255 OID 2595610)
-- Dependencies: 2983 5
-- Name: af_del_capacite_titre_capacite(integer, integer); Type: FUNCTION; Schema: contraintes; Owner: pgsql
--

CREATE FUNCTION af_del_capacite_titre_capacite(integer, integer) RETURNS boolean
    AS $_$-- $1 : numero capacite_titre
-- $2 : numero capacite
begin
    delete from contraintes.capacite_titre_capacites where capacite_titre=$1 and capacite=$2;
    return found;
end;$_$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_del_capacite_titre_capacite(integer, integer) OWNER TO pgsql;

--
-- TOC entry 7208 (class 0 OID 0)
-- Dependencies: 833
-- Name: FUNCTION af_del_capacite_titre_capacite(integer, integer); Type: COMMENT; Schema: contraintes; Owner: pgsql
--

COMMENT ON FUNCTION af_del_capacite_titre_capacite(integer, integer) IS 'supprime le couple capacite_titre / capacite';


--
-- TOC entry 834 (class 1255 OID 2595611)
-- Dependencies: 2983 5
-- Name: af_del_categorie(integer); Type: FUNCTION; Schema: contraintes; Owner: postgres
--

CREATE FUNCTION af_del_categorie(integer) RETURNS boolean
    AS $_$
DECLARE
nom_table varchar;
req_del text;
BEGIN
	--SELECTIONE LE NOM DE LA TABLE ASSOCIEE
	SELECT  INTO nom_table table_cible FROM contraintes.categorie WHERE id=$1;
	
	--SUPPRIME LA TABLE PERMETTANT DE GERER LES CONTRAINTES SUR LE CHAMP ID DE LA TABLE THEME_CATEGORIES
	IF (nom_table IS NOT NULL) THEN	
		req_del:='DELETE TABLE contraintes.categorie_'|| nom_table  ||'';
		EXECUTE req_del;
	END IF;
	
	--SUPPRIME LES ENREGISTREMENTS DE LA TABLE THEME_CATEGORIES
	--INUTILE CAR DELETE CASCADE DELETE FROM contraintes.theme_categories where categorie=$1;
	
	--SUPPRIME L'ENREGISTREMENT DANS LA TABLE CATEGORIE
	DELETE FROM contraintes.categorie WHERE id=$1;

	RETURN FOUND;
END;$_$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_del_categorie(integer) OWNER TO postgres;

--
-- TOC entry 7210 (class 0 OID 0)
-- Dependencies: 834
-- Name: FUNCTION af_del_categorie(integer); Type: COMMENT; Schema: contraintes; Owner: postgres
--

COMMENT ON FUNCTION af_del_categorie(integer) IS 'Fonction qui supprime  une  catÃ©gorie ainsi que les tables associÃ©es';


--
-- TOC entry 835 (class 1255 OID 2595612)
-- Dependencies: 2983 5
-- Name: af_del_categorie_element(integer, integer); Type: FUNCTION; Schema: contraintes; Owner: pgsql
--

CREATE FUNCTION af_del_categorie_element(integer, integer) RETURNS boolean
    AS $_$DECLARE
--$1 categorie
--$2 id de l'element a supprimer
req varchar;
table_ci varchar;
BEGIN

	--recupere la table cible du fichier
	SELECT INTO table_ci table_cible FROM contraintes.categorie C 
	WHERE C.id=$1;

	IF table_ci IS NULL THEN
		RAISE EXCEPTION 'Erreur lors de la recupÃ©ration des informations pour la suppression de l''Ã©lÃ©ment %',$1;
	END IF;
	req:='DELETE FROM contraintes.categorie_'||table_ci||' WHERE id='||$2;
	RAISE NOTICE 'req=%',req;
	EXECUTE req;

	RETURN FOUND;
END$_$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_del_categorie_element(integer, integer) OWNER TO pgsql;

--
-- TOC entry 7212 (class 0 OID 0)
-- Dependencies: 835
-- Name: FUNCTION af_del_categorie_element(integer, integer); Type: COMMENT; Schema: contraintes; Owner: pgsql
--

COMMENT ON FUNCTION af_del_categorie_element(integer, integer) IS 'Supprime un élément d''une catégorie';


--
-- TOC entry 836 (class 1255 OID 2595613)
-- Dependencies: 2983 5
-- Name: af_del_classe(integer); Type: FUNCTION; Schema: contraintes; Owner: pgsql
--

CREATE FUNCTION af_del_classe(integer) RETURNS boolean
    AS $_$declare
rec record;
num int4;
begin
    num:=$1;
    delete from contraintes.classe where id=num;
    -- recup des classes filles
    for rec in
	select * from contraintes.classe where pere=num
    loop
	num:=rec.id;
	perform contraintes.af_del_classe(num);
    end loop;
    return found;
end;$_$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_del_classe(integer) OWNER TO pgsql;

--
-- TOC entry 7214 (class 0 OID 0)
-- Dependencies: 836
-- Name: FUNCTION af_del_classe(integer); Type: COMMENT; Schema: contraintes; Owner: pgsql
--

COMMENT ON FUNCTION af_del_classe(integer) IS 'Supprime une classe (et ses classes filles si necessaire)';


--
-- TOC entry 837 (class 1255 OID 2595614)
-- Dependencies: 2983 5
-- Name: af_del_classe_droit(integer, integer); Type: FUNCTION; Schema: contraintes; Owner: pgsql
--

CREATE FUNCTION af_del_classe_droit(integer, integer) RETURNS boolean
    AS $_$-- $1 : numero classe
-- $2 : numero droit
begin
    delete from contraintes.individu_droits where classe=$1 and droit=$2;
    return found;
end;$_$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_del_classe_droit(integer, integer) OWNER TO pgsql;

--
-- TOC entry 7216 (class 0 OID 0)
-- Dependencies: 837
-- Name: FUNCTION af_del_classe_droit(integer, integer); Type: COMMENT; Schema: contraintes; Owner: pgsql
--

COMMENT ON FUNCTION af_del_classe_droit(integer, integer) IS 'Supprime un droit à une classe';


--
-- TOC entry 838 (class 1255 OID 2595615)
-- Dependencies: 2983 5
-- Name: af_del_classe_individu(integer, integer); Type: FUNCTION; Schema: contraintes; Owner: pgsql
--

CREATE FUNCTION af_del_classe_individu(integer, integer) RETURNS boolean
    AS $_$-- $1 : numero classe
-- $2 : numero individu
-- $3 : numero formation
declare

begin
    -- supprime l'individu de la classe
    delete from contraintes.classe_individus where classe=$1 and individu=$2;
    return found;
end;$_$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_del_classe_individu(integer, integer) OWNER TO pgsql;

--
-- TOC entry 7218 (class 0 OID 0)
-- Dependencies: 838
-- Name: FUNCTION af_del_classe_individu(integer, integer); Type: COMMENT; Schema: contraintes; Owner: pgsql
--

COMMENT ON FUNCTION af_del_classe_individu(integer, integer) IS 'supprime un individu d''une classe';


--
-- TOC entry 839 (class 1255 OID 2595616)
-- Dependencies: 2983 5
-- Name: af_del_commentaire(integer, integer, integer); Type: FUNCTION; Schema: contraintes; Owner: pgsql
--

CREATE FUNCTION af_del_commentaire(integer, integer, integer) RETURNS boolean
    AS $_$-- $1 : numero etape
-- $2 : min
-- $3 : max
begin
    delete from contraintes.commentaire_etape 
    where etape=$1 and min=$2 and max=$3;
    return found;
end;$_$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_del_commentaire(integer, integer, integer) OWNER TO pgsql;

--
-- TOC entry 7220 (class 0 OID 0)
-- Dependencies: 839
-- Name: FUNCTION af_del_commentaire(integer, integer, integer); Type: COMMENT; Schema: contraintes; Owner: pgsql
--

COMMENT ON FUNCTION af_del_commentaire(integer, integer, integer) IS 'supprime un commentaire';


--
-- TOC entry 840 (class 1255 OID 2595617)
-- Dependencies: 2983 5
-- Name: af_del_critere(integer); Type: FUNCTION; Schema: contraintes; Owner: pgsql
--

CREATE FUNCTION af_del_critere(integer) RETURNS boolean
    AS $_$-- $1 : numero critere
begin
    delete from contraintes.critere where id=$1;
    return found;
end;$_$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_del_critere(integer) OWNER TO pgsql;

--
-- TOC entry 7222 (class 0 OID 0)
-- Dependencies: 840
-- Name: FUNCTION af_del_critere(integer); Type: COMMENT; Schema: contraintes; Owner: pgsql
--

COMMENT ON FUNCTION af_del_critere(integer) IS 'supprime un critere';


--
-- TOC entry 841 (class 1255 OID 2595618)
-- Dependencies: 2983 5
-- Name: af_del_espace(integer); Type: FUNCTION; Schema: contraintes; Owner: pgsql
--

CREATE FUNCTION af_del_espace(integer) RETURNS boolean
    AS $_$-- $1 : numero espace
begin
    delete from contraintes.espace 
    where id=$1;
    return found;
end;$_$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_del_espace(integer) OWNER TO pgsql;

--
-- TOC entry 7224 (class 0 OID 0)
-- Dependencies: 841
-- Name: FUNCTION af_del_espace(integer); Type: COMMENT; Schema: contraintes; Owner: pgsql
--

COMMENT ON FUNCTION af_del_espace(integer) IS 'supprime un espace';


--
-- TOC entry 842 (class 1255 OID 2595619)
-- Dependencies: 2983 5
-- Name: af_del_etape(integer); Type: FUNCTION; Schema: contraintes; Owner: pgsql
--

CREATE FUNCTION af_del_etape(integer) RETURNS boolean
    AS $_$begin
    delete from contraintes.etape where id=$1;
    return found;
end;$_$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_del_etape(integer) OWNER TO pgsql;

--
-- TOC entry 7226 (class 0 OID 0)
-- Dependencies: 842
-- Name: FUNCTION af_del_etape(integer); Type: COMMENT; Schema: contraintes; Owner: pgsql
--

COMMENT ON FUNCTION af_del_etape(integer) IS 'supprime une etape';


--
-- TOC entry 843 (class 1255 OID 2595620)
-- Dependencies: 2983 5
-- Name: af_del_etape_resultat_individu(integer, integer, integer[], integer[]); Type: FUNCTION; Schema: contraintes; Owner: pgsql
--

CREATE FUNCTION af_del_etape_resultat_individu(integer, integer, integer[], integer[]) RETURNS boolean
    AS $_$-- $1 : formation
-- $2 : individu
-- $3 : tableau d'etapes
-- $4 : tableau de parcours
declare
i integer;
begin
    for i in array_lower($3,1)..array_upper($3,1)
    loop
	delete from contraintes.resultat where formation=$1 and stagiaire=$2 and etape=$3[i] and parcours=$4[i];
	-- si etape serie aleatoire (# mode 1) alors supprimer dans serie_aleatoire_evaluations A Suivre ....
	--Voir avec Rémi si utilité trigger
	delete from contraintes.resultat_tentative 
	where formation=$1 and stagiaire=$2 and parcours=$4[i] and etape=$3[i];
   
    end loop;
    return true;

end;$_$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_del_etape_resultat_individu(integer, integer, integer[], integer[]) OWNER TO pgsql;

--
-- TOC entry 7228 (class 0 OID 0)
-- Dependencies: 843
-- Name: FUNCTION af_del_etape_resultat_individu(integer, integer, integer[], integer[]); Type: COMMENT; Schema: contraintes; Owner: pgsql
--

COMMENT ON FUNCTION af_del_etape_resultat_individu(integer, integer, integer[], integer[]) IS 'raz des resultat des etapes pour un individu (une formation)';


--
-- TOC entry 844 (class 1255 OID 2595621)
-- Dependencies: 2983 5
-- Name: af_del_etape_resultat_tentative_individu(integer, integer, integer[], integer); Type: FUNCTION; Schema: contraintes; Owner: pgsql
--

CREATE FUNCTION af_del_etape_resultat_tentative_individu(integer, integer, integer[], integer) RETURNS boolean
    AS $_$-- $1 : formation
-- $2 : individu
-- $3 : tableau d'etapes
-- $4 : parcours
declare
i integer;
begin
    for i in array_lower($3,1)..array_upper($3,1)
    loop
	delete from contraintes.resultat_tentative where formation=$1 and stagiaire=$2 and etape=$3[i] and parcours=$4;
    end loop;
    return true;

end;$_$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_del_etape_resultat_tentative_individu(integer, integer, integer[], integer) OWNER TO pgsql;

--
-- TOC entry 7230 (class 0 OID 0)
-- Dependencies: 844
-- Name: FUNCTION af_del_etape_resultat_tentative_individu(integer, integer, integer[], integer); Type: COMMENT; Schema: contraintes; Owner: pgsql
--

COMMENT ON FUNCTION af_del_etape_resultat_tentative_individu(integer, integer, integer[], integer) IS 'raz des resultats (tentative) des etapes pour un individu (une formation)';


--
-- TOC entry 845 (class 1255 OID 2595622)
-- Dependencies: 2983 5
-- Name: af_del_evaluation(integer); Type: FUNCTION; Schema: contraintes; Owner: pgsql
--

CREATE FUNCTION af_del_evaluation(integer) RETURNS boolean
    AS $_$BEGIN

	DELETE FROM contraintes.evaluation WHERE  id=$1;

	RETURN FOUND;
END$_$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_del_evaluation(integer) OWNER TO pgsql;

--
-- TOC entry 7232 (class 0 OID 0)
-- Dependencies: 845
-- Name: FUNCTION af_del_evaluation(integer); Type: COMMENT; Schema: contraintes; Owner: pgsql
--

COMMENT ON FUNCTION af_del_evaluation(integer) IS 'Supprime une évaluation.';


--
-- TOC entry 1825 (class 1255 OID 2595623)
-- Dependencies: 2983 5
-- Name: af_del_evaluation_resultat_individu(bigint, integer[]); Type: FUNCTION; Schema: contraintes; Owner: pgsql
--

CREATE FUNCTION af_del_evaluation_resultat_individu(bigint, integer[]) RETURNS boolean
    AS $_$-- $1 : id resultat
-- $2 : tableau d'evaluations
declare
i integer;
begin
    -- supprime la durée dans la table resultat
    update contraintes.resultat set duree=null where id=$1;
    for i in array_lower($2,1)..array_upper($2,1)
    loop
	delete from contraintes.resultat_serie where id=$1 and evaluation=$2[i] ;
    end loop;
    return true;
end;$_$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_del_evaluation_resultat_individu(bigint, integer[]) OWNER TO pgsql;

--
-- TOC entry 7234 (class 0 OID 0)
-- Dependencies: 1825
-- Name: FUNCTION af_del_evaluation_resultat_individu(bigint, integer[]); Type: COMMENT; Schema: contraintes; Owner: pgsql
--

COMMENT ON FUNCTION af_del_evaluation_resultat_individu(bigint, integer[]) IS 'Supprime des resultats d''evaluation pour un individu';


--
-- TOC entry 846 (class 1255 OID 2595624)
-- Dependencies: 2983 5
-- Name: af_del_evaluation_resultat_tentative_individu(bigint, integer[]); Type: FUNCTION; Schema: contraintes; Owner: pgsql
--

CREATE FUNCTION af_del_evaluation_resultat_tentative_individu(bigint, integer[]) RETURNS boolean
    AS $_$-- $1 : id resultat
-- $2 : tableau d'evaluations
declare
i integer;
begin
    for i in array_lower($2,1)..array_upper($2,1)
    loop
	delete from contraintes.resultat_serie_tentative where id=$1 and evaluation=$2[i] ;
    end loop;
    return true;
end;$_$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_del_evaluation_resultat_tentative_individu(bigint, integer[]) OWNER TO pgsql;

--
-- TOC entry 7236 (class 0 OID 0)
-- Dependencies: 846
-- Name: FUNCTION af_del_evaluation_resultat_tentative_individu(bigint, integer[]); Type: COMMENT; Schema: contraintes; Owner: pgsql
--

COMMENT ON FUNCTION af_del_evaluation_resultat_tentative_individu(bigint, integer[]) IS 'Supprime des resultats tentative d''evaluation pour un individu';


--
-- TOC entry 847 (class 1255 OID 2595625)
-- Dependencies: 2983 5
-- Name: af_del_evaluations(integer[]); Type: FUNCTION; Schema: contraintes; Owner: pgsql
--

CREATE FUNCTION af_del_evaluations(integer[]) RETURNS boolean
    AS $_$
DECLARE 
i int4;
ok int4:=0;
BEGIN

	FOR i IN array_lower($1,1)..array_upper($1,1)
	LOOP
		DELETE FROM contraintes.evaluation WHERE  id=$1[i];
		IF FOUND THEN 
			ok:=ok+1;
		END IF;
	END LOOP;
	RETURN ok=i;
END$_$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_del_evaluations(integer[]) OWNER TO pgsql;

--
-- TOC entry 7238 (class 0 OID 0)
-- Dependencies: 847
-- Name: FUNCTION af_del_evaluations(integer[]); Type: COMMENT; Schema: contraintes; Owner: pgsql
--

COMMENT ON FUNCTION af_del_evaluations(integer[]) IS 'Supprime des évaluations.';


--
-- TOC entry 848 (class 1255 OID 2595626)
-- Dependencies: 2983 5
-- Name: af_del_exotlc_fichiers(integer); Type: FUNCTION; Schema: contraintes; Owner: pgsql
--

CREATE FUNCTION af_del_exotlc_fichiers(integer) RETURNS boolean
    AS $_$-- $1 : numero exotlc
declare
ok bool;
begin
    -- suppression des fichiers
    delete from contraintes.exotlc_fichiers where exotlc=$1;
    ok:=found;
    -- suppression fichiers correction
    delete from contraintes.exotlc_corrections where exotlc=$1;
    return (ok and found);
end;$_$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_del_exotlc_fichiers(integer) OWNER TO pgsql;

--
-- TOC entry 7240 (class 0 OID 0)
-- Dependencies: 848
-- Name: FUNCTION af_del_exotlc_fichiers(integer); Type: COMMENT; Schema: contraintes; Owner: pgsql
--

COMMENT ON FUNCTION af_del_exotlc_fichiers(integer) IS 'supprime les fichiers et fichiers correction d''un exotlc';


--
-- TOC entry 849 (class 1255 OID 2595627)
-- Dependencies: 2983 5
-- Name: af_del_fichier(integer); Type: FUNCTION; Schema: contraintes; Owner: pgsql
--

CREATE FUNCTION af_del_fichier(integer) RETURNS boolean
    AS $_$DECLARE
table_cible_fic VARCHAR;
req VARCHAR;
BEGIN
	

	DELETE FROM contraintes.fichier WHERE id=$1;
	
	RETURN FOUND;
END$_$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_del_fichier(integer) OWNER TO pgsql;

--
-- TOC entry 7242 (class 0 OID 0)
-- Dependencies: 849
-- Name: FUNCTION af_del_fichier(integer); Type: COMMENT; Schema: contraintes; Owner: pgsql
--

COMMENT ON FUNCTION af_del_fichier(integer) IS 'Supprime un fichier.';


--
-- TOC entry 850 (class 1255 OID 2595628)
-- Dependencies: 2983 5
-- Name: af_del_fichier_scenario_dynamique_bloc(integer, integer); Type: FUNCTION; Schema: contraintes; Owner: pgsql
--

CREATE FUNCTION af_del_fichier_scenario_dynamique_bloc(integer, integer) RETURNS boolean
    AS $_$DECLARE
--$1 fichier scenario dynamique
--$2 bloc ordre
rec RECORD;
BEGIN
	DELETE FROM contraintes.fichier_scenario_dynamique_blocs
	WHERE id=$1
	AND ordre=$2;
	

	FOR rec IN
		SELECT id, ordre
		FROM contraintes.fichier_scenario_dynamique_blocs
		WHERE id=$1
		AND ordre > $2 
		ORDER BY ordre ASC
	LOOP		
		
		--on décale tous les successeurs
		UPDATE contraintes.fichier_scenario_dynamique_blocs
		SET ordre=ordre-1
		WHERE id=rec.id
		AND ordre=rec.ordre;
		--RAISE NOTICE 'decale successeurs';
		
	END LOOP;
	RETURN FOUND;
END$_$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_del_fichier_scenario_dynamique_bloc(integer, integer) OWNER TO pgsql;

--
-- TOC entry 851 (class 1255 OID 2595629)
-- Dependencies: 2983 5
-- Name: af_del_fichier_texte(integer); Type: FUNCTION; Schema: contraintes; Owner: pgsql
--

CREATE FUNCTION af_del_fichier_texte(integer) RETURNS boolean
    AS $_$DECLARE
req VARCHAR;
BEGIN
	--SUPPRESSION
	DELETE FROM contraintes.fichier_texte WHERE id=$1;
	
	RETURN FOUND;
END$_$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_del_fichier_texte(integer) OWNER TO pgsql;

--
-- TOC entry 7245 (class 0 OID 0)
-- Dependencies: 851
-- Name: FUNCTION af_del_fichier_texte(integer); Type: COMMENT; Schema: contraintes; Owner: pgsql
--

COMMENT ON FUNCTION af_del_fichier_texte(integer) IS 'Supprime un fichier_texte.';


--
-- TOC entry 852 (class 1255 OID 2595630)
-- Dependencies: 2983 5
-- Name: af_del_fichiers_scenarios_dynamiques(integer[]); Type: FUNCTION; Schema: contraintes; Owner: pgsql
--

CREATE FUNCTION af_del_fichiers_scenarios_dynamiques(integer[]) RETURNS boolean
    AS $_$-- $1 : tableau de numero de fichiers scenarios
declare
i integer;
begin
    for i in array_lower($1,1)..array_upper($1,1)
    loop
	PERFORM * from contraintes.af_del_fichier($1[i]);
    end loop;
    return true;
end;$_$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_del_fichiers_scenarios_dynamiques(integer[]) OWNER TO pgsql;

--
-- TOC entry 853 (class 1255 OID 2595631)
-- Dependencies: 2983 5
-- Name: af_del_filiere(integer); Type: FUNCTION; Schema: contraintes; Owner: pgsql
--

CREATE FUNCTION af_del_filiere(integer) RETURNS boolean
    AS $_$DECLARE
--$1 filiere
BEGIN
	DELETE FROM contraintes.filiere WHERE id=$1;

	RETURN FOUND;
END;$_$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_del_filiere(integer) OWNER TO pgsql;

--
-- TOC entry 1826 (class 1255 OID 2960161)
-- Dependencies: 2983 5
-- Name: af_del_formation(integer); Type: FUNCTION; Schema: contraintes; Owner: www
--

CREATE FUNCTION af_del_formation(integer) RETURNS boolean
    AS $_$BEGIN
	DELETE FROM contraintes.formation
	WHERE id=$1;

	RETURN FOUND;
END;$_$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_del_formation(integer) OWNER TO www;

--
-- TOC entry 854 (class 1255 OID 2595632)
-- Dependencies: 2983 5
-- Name: af_del_formation_droit(integer, integer); Type: FUNCTION; Schema: contraintes; Owner: pgsql
--

CREATE FUNCTION af_del_formation_droit(integer, integer) RETURNS boolean
    AS $_$-- $1 : numero formation
-- $2 : numero droit
begin
    delete from contraintes.formateur_droits where formation=$1 and droit=$2;
    return found;
end;$_$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_del_formation_droit(integer, integer) OWNER TO pgsql;

--
-- TOC entry 7250 (class 0 OID 0)
-- Dependencies: 854
-- Name: FUNCTION af_del_formation_droit(integer, integer); Type: COMMENT; Schema: contraintes; Owner: pgsql
--

COMMENT ON FUNCTION af_del_formation_droit(integer, integer) IS 'supprime un droit à une formation';


--
-- TOC entry 855 (class 1255 OID 2595633)
-- Dependencies: 2983 5
-- Name: af_del_formation_espace(integer, integer); Type: FUNCTION; Schema: contraintes; Owner: pgsql
--

CREATE FUNCTION af_del_formation_espace(integer, integer) RETURNS boolean
    AS $_$-- $1 : formation
-- $2 : espace
begin
    delete from contraintes.formation_ressources 
    where formation=$1 and espace=$2;
    return found;
end;$_$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_del_formation_espace(integer, integer) OWNER TO pgsql;

--
-- TOC entry 7252 (class 0 OID 0)
-- Dependencies: 855
-- Name: FUNCTION af_del_formation_espace(integer, integer); Type: COMMENT; Schema: contraintes; Owner: pgsql
--

COMMENT ON FUNCTION af_del_formation_espace(integer, integer) IS 'supprime un espace (ressource) de la formation';


--
-- TOC entry 856 (class 1255 OID 2595634)
-- Dependencies: 2983 5
-- Name: af_del_formation_espace_section(integer, integer, integer); Type: FUNCTION; Schema: contraintes; Owner: pgsql
--

CREATE FUNCTION af_del_formation_espace_section(integer, integer, integer) RETURNS boolean
    AS $_$-- $1 : formation
-- $2 : espace
-- $3 : section
begin
    delete from contraintes.formation_ressources 
    where formation=$1 and espace=$2 and section=$3;
    return found;
end;$_$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_del_formation_espace_section(integer, integer, integer) OWNER TO pgsql;

--
-- TOC entry 7254 (class 0 OID 0)
-- Dependencies: 856
-- Name: FUNCTION af_del_formation_espace_section(integer, integer, integer); Type: COMMENT; Schema: contraintes; Owner: pgsql
--

COMMENT ON FUNCTION af_del_formation_espace_section(integer, integer, integer) IS 'supprime une section d''un espace (ressource) d''une formation';


--
-- TOC entry 857 (class 1255 OID 2595635)
-- Dependencies: 2983 5
-- Name: af_del_formation_evenement(integer, timestamp without time zone); Type: FUNCTION; Schema: contraintes; Owner: pgsql
--

CREATE FUNCTION af_del_formation_evenement(integer, timestamp without time zone) RETURNS boolean
    AS $_$-- $1 : formation
-- $2 : date
-- $3 : debut
begin
    delete from contraintes.evenement 
    where formation=$1 and date=$2;
    return found;
end;$_$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_del_formation_evenement(integer, timestamp without time zone) OWNER TO pgsql;

--
-- TOC entry 7256 (class 0 OID 0)
-- Dependencies: 857
-- Name: FUNCTION af_del_formation_evenement(integer, timestamp without time zone); Type: COMMENT; Schema: contraintes; Owner: pgsql
--

COMMENT ON FUNCTION af_del_formation_evenement(integer, timestamp without time zone) IS 'Supprime un evenement d''une journee de formation';


--
-- TOC entry 858 (class 1255 OID 2595636)
-- Dependencies: 2983 5
-- Name: af_del_formation_evenements(integer, date); Type: FUNCTION; Schema: contraintes; Owner: pgsql
--

CREATE FUNCTION af_del_formation_evenements(integer, date) RETURNS boolean
    AS $_$-- $1 : formation
-- $2 : date
begin
    delete from contraintes.evenement 
    where formation=$1 and cast(date as date)=$2;
    return found;
end;$_$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_del_formation_evenements(integer, date) OWNER TO pgsql;

--
-- TOC entry 7258 (class 0 OID 0)
-- Dependencies: 858
-- Name: FUNCTION af_del_formation_evenements(integer, date); Type: COMMENT; Schema: contraintes; Owner: pgsql
--

COMMENT ON FUNCTION af_del_formation_evenements(integer, date) IS 'Supprime les evenements d''une journee de formation';


--
-- TOC entry 859 (class 1255 OID 2595637)
-- Dependencies: 2983 5
-- Name: af_del_formation_forum(integer, integer); Type: FUNCTION; Schema: contraintes; Owner: pgsql
--

CREATE FUNCTION af_del_formation_forum(integer, integer) RETURNS boolean
    AS $_$-- $1 : formation
-- $2 : forum
begin
    delete from contraintes.formation_forums where formation=$1 and forum=$2;
    return found;
end;$_$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_del_formation_forum(integer, integer) OWNER TO pgsql;

--
-- TOC entry 7260 (class 0 OID 0)
-- Dependencies: 859
-- Name: FUNCTION af_del_formation_forum(integer, integer); Type: COMMENT; Schema: contraintes; Owner: pgsql
--

COMMENT ON FUNCTION af_del_formation_forum(integer, integer) IS 'Supprime une association formation / forum';


--
-- TOC entry 860 (class 1255 OID 2595638)
-- Dependencies: 2983 5
-- Name: af_del_formation_langue(integer, integer); Type: FUNCTION; Schema: contraintes; Owner: pgsql
--

CREATE FUNCTION af_del_formation_langue(integer, integer) RETURNS boolean
    AS $_$-- $1 : formation
-- $2 : n° langue
begin
    delete from contraintes.formation_langues where formation=$1 and langue=$2;
    return found;
end;$_$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_del_formation_langue(integer, integer) OWNER TO pgsql;

--
-- TOC entry 7262 (class 0 OID 0)
-- Dependencies: 860
-- Name: FUNCTION af_del_formation_langue(integer, integer); Type: COMMENT; Schema: contraintes; Owner: pgsql
--

COMMENT ON FUNCTION af_del_formation_langue(integer, integer) IS 'Supprime une langue dispo d''une formation';


--
-- TOC entry 861 (class 1255 OID 2595639)
-- Dependencies: 2983 5
-- Name: af_del_formation_ressource(integer, integer, integer, integer); Type: FUNCTION; Schema: contraintes; Owner: pgsql
--

CREATE FUNCTION af_del_formation_ressource(integer, integer, integer, integer) RETURNS boolean
    AS $_$-- $1 : formation
-- $2 : ressource
-- $3 : espace
-- $4 : section
begin
    delete from contraintes.formation_ressources 
    where formation=$1 and fichier_ressource=$2 and espace=$3 and (section=$4 or section is null);
    return found;
end;$_$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_del_formation_ressource(integer, integer, integer, integer) OWNER TO pgsql;

--
-- TOC entry 7264 (class 0 OID 0)
-- Dependencies: 861
-- Name: FUNCTION af_del_formation_ressource(integer, integer, integer, integer); Type: COMMENT; Schema: contraintes; Owner: pgsql
--

COMMENT ON FUNCTION af_del_formation_ressource(integer, integer, integer, integer) IS 'supprime une ressource d''une formation';


--
-- TOC entry 862 (class 1255 OID 2595640)
-- Dependencies: 2983 5
-- Name: af_del_formation_resultat_individu(integer, integer); Type: FUNCTION; Schema: contraintes; Owner: pgsql
--

CREATE FUNCTION af_del_formation_resultat_individu(integer, integer) RETURNS boolean
    AS $_$-- $1 : formation
-- $2 : individu

begin
    delete from contraintes.resultat where formation=$1 and stagiaire=$2;
    delete from contraintes.resultat_tentative where formation=$1 and stagiaire=$2;
    return found;
end;$_$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_del_formation_resultat_individu(integer, integer) OWNER TO pgsql;

--
-- TOC entry 7266 (class 0 OID 0)
-- Dependencies: 862
-- Name: FUNCTION af_del_formation_resultat_individu(integer, integer); Type: COMMENT; Schema: contraintes; Owner: pgsql
--

COMMENT ON FUNCTION af_del_formation_resultat_individu(integer, integer) IS 'raz parcours d''un individu (pour une formation)';


--
-- TOC entry 863 (class 1255 OID 2595641)
-- Dependencies: 2983 5
-- Name: af_del_formation_session(integer); Type: FUNCTION; Schema: contraintes; Owner: pgsql
--

CREATE FUNCTION af_del_formation_session(integer) RETURNS boolean
    AS $_$-- $1 : formation
begin
    delete from contraintes.formation_session where formation=$1;
    return true;
end;$_$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_del_formation_session(integer) OWNER TO pgsql;

--
-- TOC entry 7268 (class 0 OID 0)
-- Dependencies: 863
-- Name: FUNCTION af_del_formation_session(integer); Type: COMMENT; Schema: contraintes; Owner: pgsql
--

COMMENT ON FUNCTION af_del_formation_session(integer) IS 'supprime les temps de session pour une formation';


--
-- TOC entry 864 (class 1255 OID 2595642)
-- Dependencies: 2983 5
-- Name: af_del_forum(integer); Type: FUNCTION; Schema: contraintes; Owner: pgsql
--

CREATE FUNCTION af_del_forum(integer) RETURNS boolean
    AS $_$-- $1 : forum
declare

begin
    --supprime dans forum_environnements
    delete from contraintes.forum_environnements where forum=$1;
    delete from contraintes.forum where id=$1;
    return found;
end;$_$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_del_forum(integer) OWNER TO pgsql;

--
-- TOC entry 7270 (class 0 OID 0)
-- Dependencies: 864
-- Name: FUNCTION af_del_forum(integer); Type: COMMENT; Schema: contraintes; Owner: pgsql
--

COMMENT ON FUNCTION af_del_forum(integer) IS 'supprime un forum';


--
-- TOC entry 865 (class 1255 OID 2595643)
-- Dependencies: 2983 5
-- Name: af_del_grille(integer); Type: FUNCTION; Schema: contraintes; Owner: pgsql
--

CREATE FUNCTION af_del_grille(integer) RETURNS boolean
    AS $_$-- $1 : numero grille
begin  
    delete from contraintes.grille where id=$1;
    return found;
end;$_$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_del_grille(integer) OWNER TO pgsql;

--
-- TOC entry 7272 (class 0 OID 0)
-- Dependencies: 865
-- Name: FUNCTION af_del_grille(integer); Type: COMMENT; Schema: contraintes; Owner: pgsql
--

COMMENT ON FUNCTION af_del_grille(integer) IS 'supprime une grille';


--
-- TOC entry 866 (class 1255 OID 2595644)
-- Dependencies: 2983 5
-- Name: af_del_grille_capacite_titre(integer, integer); Type: FUNCTION; Schema: contraintes; Owner: pgsql
--

CREATE FUNCTION af_del_grille_capacite_titre(integer, integer) RETURNS boolean
    AS $_$-- $1 : numero grille
-- $2 : numero capacite_titre
begin
    delete from contraintes.grille_capacites_titres where grille=$1 and capacite_titre=$2;
    return found;
end;$_$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_del_grille_capacite_titre(integer, integer) OWNER TO pgsql;

--
-- TOC entry 7274 (class 0 OID 0)
-- Dependencies: 866
-- Name: FUNCTION af_del_grille_capacite_titre(integer, integer); Type: COMMENT; Schema: contraintes; Owner: pgsql
--

COMMENT ON FUNCTION af_del_grille_capacite_titre(integer, integer) IS 'supprime le couple grille / capacite_titre';


--
-- TOC entry 867 (class 1255 OID 2595645)
-- Dependencies: 2983 5
-- Name: af_del_individu(integer); Type: FUNCTION; Schema: contraintes; Owner: pgsql
--

CREATE FUNCTION af_del_individu(integer) RETURNS boolean
    AS $_$begin
    delete from contraintes.fw_individu where id=$1;
    return found;
end;$_$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_del_individu(integer) OWNER TO pgsql;

--
-- TOC entry 7276 (class 0 OID 0)
-- Dependencies: 867
-- Name: FUNCTION af_del_individu(integer); Type: COMMENT; Schema: contraintes; Owner: pgsql
--

COMMENT ON FUNCTION af_del_individu(integer) IS 'supprime un individu';


--
-- TOC entry 868 (class 1255 OID 2595646)
-- Dependencies: 2983 5
-- Name: af_del_individu_droit_classe(integer, integer, integer); Type: FUNCTION; Schema: contraintes; Owner: pgsql
--

CREATE FUNCTION af_del_individu_droit_classe(integer, integer, integer) RETURNS boolean
    AS $_$-- $1 : numero individu
-- $2 : numero classe
-- $3 : numero droit
begin
    delete from contraintes.individu_droits where individu=$1 and classe=$2 and droit=$3;
    return found;
end;$_$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_del_individu_droit_classe(integer, integer, integer) OWNER TO pgsql;

--
-- TOC entry 7278 (class 0 OID 0)
-- Dependencies: 868
-- Name: FUNCTION af_del_individu_droit_classe(integer, integer, integer); Type: COMMENT; Schema: contraintes; Owner: pgsql
--

COMMENT ON FUNCTION af_del_individu_droit_classe(integer, integer, integer) IS 'Supprime un droit pour un individu et une classe';


--
-- TOC entry 869 (class 1255 OID 2595647)
-- Dependencies: 2983 5
-- Name: af_del_individu_session(integer); Type: FUNCTION; Schema: contraintes; Owner: pgsql
--

CREATE FUNCTION af_del_individu_session(integer) RETURNS boolean
    AS $_$-- $1 : individu
begin
    delete from contraintes.session where individu=$1;
    return found;
end;$_$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_del_individu_session(integer) OWNER TO pgsql;

--
-- TOC entry 7280 (class 0 OID 0)
-- Dependencies: 869
-- Name: FUNCTION af_del_individu_session(integer); Type: COMMENT; Schema: contraintes; Owner: pgsql
--

COMMENT ON FUNCTION af_del_individu_session(integer) IS 'supprime la session d''un individu';


--
-- TOC entry 870 (class 1255 OID 2595648)
-- Dependencies: 2983 5
-- Name: af_del_individu_type(integer, integer); Type: FUNCTION; Schema: contraintes; Owner: pgsql
--

CREATE FUNCTION af_del_individu_type(integer, integer) RETURNS boolean
    AS $_$begin
    delete from contraintes.fw_individu_types 
    where individu=$1 and type=$2;
    return found;
end;$_$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_del_individu_type(integer, integer) OWNER TO pgsql;

--
-- TOC entry 7282 (class 0 OID 0)
-- Dependencies: 870
-- Name: FUNCTION af_del_individu_type(integer, integer); Type: COMMENT; Schema: contraintes; Owner: pgsql
--

COMMENT ON FUNCTION af_del_individu_type(integer, integer) IS 'supprime un type à un individu';


--
-- TOC entry 871 (class 1255 OID 2595649)
-- Dependencies: 2983 5
-- Name: af_del_inscription(integer); Type: FUNCTION; Schema: contraintes; Owner: pgsql
--

CREATE FUNCTION af_del_inscription(integer) RETURNS boolean
    AS $_$begin
    delete from contraintes.inscription where id=$1;
    return found;
end;$_$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_del_inscription(integer) OWNER TO pgsql;

--
-- TOC entry 7284 (class 0 OID 0)
-- Dependencies: 871
-- Name: FUNCTION af_del_inscription(integer); Type: COMMENT; Schema: contraintes; Owner: pgsql
--

COMMENT ON FUNCTION af_del_inscription(integer) IS 'supprime un individu inscrit';


--
-- TOC entry 872 (class 1255 OID 2595650)
-- Dependencies: 2983 5
-- Name: af_del_intervention(integer); Type: FUNCTION; Schema: contraintes; Owner: pgsql
--

CREATE FUNCTION af_del_intervention(integer) RETURNS boolean
    AS $_$-- $1 : numero intervention
begin
    delete from contraintes.intervention where id=$1;
    return found;
end;$_$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_del_intervention(integer) OWNER TO pgsql;

--
-- TOC entry 7286 (class 0 OID 0)
-- Dependencies: 872
-- Name: FUNCTION af_del_intervention(integer); Type: COMMENT; Schema: contraintes; Owner: pgsql
--

COMMENT ON FUNCTION af_del_intervention(integer) IS 'supprime une intervention';


--
-- TOC entry 873 (class 1255 OID 2595651)
-- Dependencies: 2983 5
-- Name: af_del_langue_message(integer, integer); Type: FUNCTION; Schema: contraintes; Owner: pgsql
--

CREATE FUNCTION af_del_langue_message(integer, integer) RETURNS boolean
    AS $_$-- $1 : type de message
-- $2 : numero de message
-- Attention : supprime dans toutes les langues
begin
    delete from contraintes.langue_message where type=$1 and id=$2;
    return found;
end;$_$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_del_langue_message(integer, integer) OWNER TO pgsql;

--
-- TOC entry 7288 (class 0 OID 0)
-- Dependencies: 873
-- Name: FUNCTION af_del_langue_message(integer, integer); Type: COMMENT; Schema: contraintes; Owner: pgsql
--

COMMENT ON FUNCTION af_del_langue_message(integer, integer) IS 'Supprime un message de langue';


--
-- TOC entry 874 (class 1255 OID 2595652)
-- Dependencies: 2983 5
-- Name: af_del_langue_messages(integer, integer[]); Type: FUNCTION; Schema: contraintes; Owner: pgsql
--

CREATE FUNCTION af_del_langue_messages(integer, integer[]) RETURNS boolean
    AS $_$-- $1 : type de message
-- $2 : tableau de numero de message
declare
i integer;
begin
    for i in array_lower($2,1)..array_upper($2,1)
    loop
	delete from contraintes.langue_message where type=$1 and id=$2[i];
    end loop;
    return true;
end;$_$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_del_langue_messages(integer, integer[]) OWNER TO pgsql;

--
-- TOC entry 7290 (class 0 OID 0)
-- Dependencies: 874
-- Name: FUNCTION af_del_langue_messages(integer, integer[]); Type: COMMENT; Schema: contraintes; Owner: pgsql
--

COMMENT ON FUNCTION af_del_langue_messages(integer, integer[]) IS 'Supprime des messages de langue';


--
-- TOC entry 875 (class 1255 OID 2595653)
-- Dependencies: 2983 5
-- Name: af_del_organisme(integer); Type: FUNCTION; Schema: contraintes; Owner: pgsql
--

CREATE FUNCTION af_del_organisme(integer) RETURNS boolean
    AS $_$begin
    delete from contraintes.organisme
    where id=$1;
    return found;
end;$_$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_del_organisme(integer) OWNER TO pgsql;

--
-- TOC entry 7292 (class 0 OID 0)
-- Dependencies: 875
-- Name: FUNCTION af_del_organisme(integer); Type: COMMENT; Schema: contraintes; Owner: pgsql
--

COMMENT ON FUNCTION af_del_organisme(integer) IS 'supprime un organisme';


--
-- TOC entry 876 (class 1255 OID 2595654)
-- Dependencies: 2983 5
-- Name: af_del_page_annuaire_configuration(integer, integer, integer); Type: FUNCTION; Schema: contraintes; Owner: pgsql
--

CREATE FUNCTION af_del_page_annuaire_configuration(integer, integer, integer) RETURNS boolean
    AS $_$-- $1 : formation
-- $2 : page
-- $3 : type individu
begin
    delete from contraintes.page_annuaire_configuration 
    where formation=$1 and page=$2 and individu_type=$3;
    return found;
end;$_$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_del_page_annuaire_configuration(integer, integer, integer) OWNER TO pgsql;

--
-- TOC entry 7294 (class 0 OID 0)
-- Dependencies: 876
-- Name: FUNCTION af_del_page_annuaire_configuration(integer, integer, integer); Type: COMMENT; Schema: contraintes; Owner: pgsql
--

COMMENT ON FUNCTION af_del_page_annuaire_configuration(integer, integer, integer) IS 'Supprime la configuration de la page d''annuaire';


--
-- TOC entry 877 (class 1255 OID 2595655)
-- Dependencies: 2983 5
-- Name: af_del_page_liste_configuration(integer, integer, integer, integer); Type: FUNCTION; Schema: contraintes; Owner: pgsql
--

CREATE FUNCTION af_del_page_liste_configuration(integer, integer, integer, integer) RETURNS boolean
    AS $_$-- $1 : formation
-- $2 : parcours
-- $3 : liste
-- $4 : page
begin
    delete from contraintes.page_liste_configuration 
    where formation=$1 and parcours=$2 and liste=$3 and page=$4;
    delete from contraintes.page_liste 
    where formation=$1 and parcours=$2 and liste=$3 and page=$4;
    return found;
end;$_$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_del_page_liste_configuration(integer, integer, integer, integer) OWNER TO pgsql;

--
-- TOC entry 7296 (class 0 OID 0)
-- Dependencies: 877
-- Name: FUNCTION af_del_page_liste_configuration(integer, integer, integer, integer); Type: COMMENT; Schema: contraintes; Owner: pgsql
--

COMMENT ON FUNCTION af_del_page_liste_configuration(integer, integer, integer, integer) IS 'Supprile la configuration d''une page de liste';


--
-- TOC entry 878 (class 1255 OID 2595656)
-- Dependencies: 2983 5
-- Name: af_del_parcours_etape(integer, integer); Type: FUNCTION; Schema: contraintes; Owner: pgsql
--

CREATE FUNCTION af_del_parcours_etape(integer, integer) RETURNS boolean
    AS $_$DECLARE
--$1 parcours
--$2 etape
res int4;
type_etape int4;
BEGIN
	SELECT INTO res * FROM contraintes.af_gen_del_element('contraintes.parcours_etapes','etape',$2,'AND parcours='||$1);
	
	--traitement particulier pour les etapes titres: on les supprimme systematiquement
	SELECT INTO type_etape type FROM contraintes.af_get_etape($2) AS (id int4, libelle varchar, type int4,date_creation timestamp);
	IF type_etape=9 THEN
		PERFORM contraintes.af_del_etape($2);
	END IF;

	RETURN res>0;
END;$_$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_del_parcours_etape(integer, integer) OWNER TO pgsql;

--
-- TOC entry 879 (class 1255 OID 2595657)
-- Dependencies: 2983 5
-- Name: af_del_positionnement(integer); Type: FUNCTION; Schema: contraintes; Owner: pgsql
--

CREATE FUNCTION af_del_positionnement(integer) RETURNS boolean
    AS $_$BEGIN
	DELETE FROM contraintes.positionnement
	WHERE id=$1;

	RETURN FOUND;
END$_$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_del_positionnement(integer) OWNER TO pgsql;

--
-- TOC entry 880 (class 1255 OID 2595658)
-- Dependencies: 2983 5
-- Name: af_del_positionnement_choix(integer, integer); Type: FUNCTION; Schema: contraintes; Owner: pgsql
--

CREATE FUNCTION af_del_positionnement_choix(integer, integer) RETURNS boolean
    AS $_$DECLARE
qr int4;
nb_del int4:=0;
BEGIN
	--on selectionne le question-reponse associé au positionnement
	--SELECT INTO qr question_reponse FROM contraintes.positionnement where id=$1;

	SELECT INTO nb_del * FROM contraintes.af_gen_del_element('contraintes.choix', 'id', $2, ' AND positionnement='||$1);

	RETURN nb_del>0;

END$_$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_del_positionnement_choix(integer, integer) OWNER TO pgsql;

--
-- TOC entry 881 (class 1255 OID 2595659)
-- Dependencies: 2983 5
-- Name: af_del_positionnement_evaluations_a_generer(integer, integer, integer); Type: FUNCTION; Schema: contraintes; Owner: pgsql
--

CREATE FUNCTION af_del_positionnement_evaluations_a_generer(integer, integer, integer) RETURNS boolean
    AS $_$DECLARE
--$1 positionnement
--$2 question de positionnement
--$3 choix
--$4 evaluation
qr int4;
BEGIN
	--on selectionne le question-reponse associé au positionnement
	SELECT INTO qr question_reponse FROM contraintes.positionnement where id=$1;

	DELETE FROM contraintes.positionnement_evaluations
	WHERE question_reponse=qr
	AND question=$2
	AND choix=$3;

	RETURN FOUND;
END$_$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_del_positionnement_evaluations_a_generer(integer, integer, integer) OWNER TO pgsql;

--
-- TOC entry 882 (class 1255 OID 2595660)
-- Dependencies: 2983 5
-- Name: af_del_positionnement_question(integer, integer); Type: FUNCTION; Schema: contraintes; Owner: pgsql
--

CREATE FUNCTION af_del_positionnement_question(integer, integer) RETURNS boolean
    AS $_$DECLARE
qr int4;
BEGIN
	--on selectionne le question-reponse associé au positionnement
	SELECT INTO qr question_reponse FROM contraintes.positionnement where id=$1;

	PERFORM * FROM contraintes.af_gen_del_element('contraintes.question_reponse_elements', 'question', $2, ' AND question_reponse='||qr);

	RETURN TRUE;

END$_$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_del_positionnement_question(integer, integer) OWNER TO pgsql;

--
-- TOC entry 883 (class 1255 OID 2595661)
-- Dependencies: 2983 5
-- Name: af_del_presentiel_note_individu_date(integer, integer, integer, integer, integer, timestamp without time zone); Type: FUNCTION; Schema: contraintes; Owner: pgsql
--

CREATE FUNCTION af_del_presentiel_note_individu_date(integer, integer, integer, integer, integer, timestamp without time zone) RETURNS boolean
    AS $_$-- $1 : formation
-- $2 : stagiaire
-- $3 : grille
-- $4 : titre capacite
-- $5 : capacite
-- $6 : date
begin
    delete from contraintes.grille_resultats 
    where formation=$1 and stagiaire=$2 and grille=$3 and capacite_titre=$4 and capacite=$5 and date=$6;
    return found;	
end;$_$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_del_presentiel_note_individu_date(integer, integer, integer, integer, integer, timestamp without time zone) OWNER TO pgsql;

--
-- TOC entry 7303 (class 0 OID 0)
-- Dependencies: 883
-- Name: FUNCTION af_del_presentiel_note_individu_date(integer, integer, integer, integer, integer, timestamp without time zone); Type: COMMENT; Schema: contraintes; Owner: pgsql
--

COMMENT ON FUNCTION af_del_presentiel_note_individu_date(integer, integer, integer, integer, integer, timestamp without time zone) IS 'Supprime un carton pour une capacite à une date';


--
-- TOC entry 884 (class 1255 OID 2595662)
-- Dependencies: 2983 5
-- Name: af_del_qsrc_question(integer, integer); Type: FUNCTION; Schema: contraintes; Owner: pgsql
--

CREATE FUNCTION af_del_qsrc_question(integer, integer) RETURNS boolean
    AS $_$DECLARE
BEGIN
	PERFORM * FROM contraintes.af_gen_del_element('contraintes.question_reponse_elements', 'question', $2, ' AND question_reponse='||$1);

	RETURN TRUE;

END$_$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_del_qsrc_question(integer, integer) OWNER TO pgsql;

--
-- TOC entry 885 (class 1255 OID 2595663)
-- Dependencies: 2983 5
-- Name: af_del_question_reponse_association_element(integer, integer); Type: FUNCTION; Schema: contraintes; Owner: pgsql
--

CREATE FUNCTION af_del_question_reponse_association_element(integer, integer) RETURNS boolean
    AS $_$DECLARE
--$1 numero de question_reponse
--$2 numero de question_reponse_element
val_reponse varchar;
cond varchar;
res integer;
BEGIN
    --les questions
    /*
    DELETE FROM contraintes.question_reponse_elements 
    WHERE question_reponse=$1
    AND question=$2;
    IF $1 IS NULL THEN
        cond:=' AND question_reponse IS NULL';
    ELSE
	cond:=' AND question_reponse='||$1;
    END IF;
    */

    -- question ou reponse ?
    perform * from contraintes.af_get_question_reponse_element($2) 
    as (id integer,libelle varchar,interpretation_html boolean, "type" integer, reponse boolean ) 
    where reponse is false;
    if found then 
	--raise notice 'question';
	val_reponse:=' is false ';
     else
	--raise notice 'reponse';
	val_reponse:=' is true ';
    end if;
    cond:=' AND question_reponse='||$1||' and question_reponse_element in (select id from contraintes.question_reponse_element where reponse '||val_reponse||') ';
   
	--le question_reponse_element
	SELECT INTO res * FROM contraintes.af_gen_del_element(varchar 'contraintes.question_reponse_elements',varchar 'question_reponse_element', $2, cond);

	RETURN res>1;
END$_$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_del_question_reponse_association_element(integer, integer) OWNER TO pgsql;

--
-- TOC entry 7306 (class 0 OID 0)
-- Dependencies: 885
-- Name: FUNCTION af_del_question_reponse_association_element(integer, integer); Type: COMMENT; Schema: contraintes; Owner: pgsql
--

COMMENT ON FUNCTION af_del_question_reponse_association_element(integer, integer) IS 'Supprime un élément d''un question réponse.';


--
-- TOC entry 886 (class 1255 OID 2595664)
-- Dependencies: 2983 5
-- Name: af_del_question_reponse_choix(integer, integer); Type: FUNCTION; Schema: contraintes; Owner: pgsql
--

CREATE FUNCTION af_del_question_reponse_choix(integer, integer) RETURNS boolean
    AS $_$DECLARE
nb_del int4:=0;
BEGIN


	SELECT INTO nb_del * FROM contraintes.af_gen_del_element('contraintes.choix', 'id', $2, ' AND question_reponse='||$1);

	RETURN nb_del>0;

END$_$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_del_question_reponse_choix(integer, integer) OWNER TO pgsql;

--
-- TOC entry 887 (class 1255 OID 2595665)
-- Dependencies: 2983 5
-- Name: af_del_question_reponse_element(integer); Type: FUNCTION; Schema: contraintes; Owner: pgsql
--

CREATE FUNCTION af_del_question_reponse_element(integer) RETURNS boolean
    AS $_$BEGIN
	DELETE FROM contraintes.question_reponse_element
	WHERE id=$1;
	
	RETURN FOUND;
END$_$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_del_question_reponse_element(integer) OWNER TO pgsql;

--
-- TOC entry 7309 (class 0 OID 0)
-- Dependencies: 887
-- Name: FUNCTION af_del_question_reponse_element(integer); Type: COMMENT; Schema: contraintes; Owner: pgsql
--

COMMENT ON FUNCTION af_del_question_reponse_element(integer) IS 'Supprime un question_reponse_element.';


--
-- TOC entry 888 (class 1255 OID 2595666)
-- Dependencies: 2983 5
-- Name: af_del_question_reponse_element_media(integer, integer); Type: FUNCTION; Schema: contraintes; Owner: pgsql
--

CREATE FUNCTION af_del_question_reponse_element_media(integer, integer) RETURNS boolean
    AS $_$BEGIN
	DELETE FROM contraintes.media_question_reponse_element
	WHERE question_reponse=$1
	AND question_reponse_element=$2;

	RETURN FOUND;
END$_$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_del_question_reponse_element_media(integer, integer) OWNER TO pgsql;

--
-- TOC entry 7311 (class 0 OID 0)
-- Dependencies: 888
-- Name: FUNCTION af_del_question_reponse_element_media(integer, integer); Type: COMMENT; Schema: contraintes; Owner: pgsql
--

COMMENT ON FUNCTION af_del_question_reponse_element_media(integer, integer) IS 'Supprime un média d''un question_reponse_element.';


--
-- TOC entry 889 (class 1255 OID 2595667)
-- Dependencies: 2983 5
-- Name: af_del_question_reponse_media(integer); Type: FUNCTION; Schema: contraintes; Owner: pgsql
--

CREATE FUNCTION af_del_question_reponse_media(integer) RETURNS boolean
    AS $_$BEGIN
	DELETE FROM contraintes.media_question_reponse
	WHERE question_reponse=$1;

	RETURN FOUND;
END$_$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_del_question_reponse_media(integer) OWNER TO pgsql;

--
-- TOC entry 7313 (class 0 OID 0)
-- Dependencies: 889
-- Name: FUNCTION af_del_question_reponse_media(integer); Type: COMMENT; Schema: contraintes; Owner: pgsql
--

COMMENT ON FUNCTION af_del_question_reponse_media(integer) IS 'Supprime un média d''un question_reponse.';


--
-- TOC entry 890 (class 1255 OID 2595668)
-- Dependencies: 2983 5
-- Name: af_del_resultat_exotlc(integer); Type: FUNCTION; Schema: contraintes; Owner: pgsql
--

CREATE FUNCTION af_del_resultat_exotlc(integer) RETURNS boolean
    AS $_$-- $1 : id resultat
begin
    delete from contraintes.resultat_exotlc where id=$1;
    -- mise à jour de la table resultat
    --update contraintes.resultat set duree=null where id=$1;
    return found;
end;$_$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_del_resultat_exotlc(integer) OWNER TO pgsql;

--
-- TOC entry 7315 (class 0 OID 0)
-- Dependencies: 890
-- Name: FUNCTION af_del_resultat_exotlc(integer); Type: COMMENT; Schema: contraintes; Owner: pgsql
--

COMMENT ON FUNCTION af_del_resultat_exotlc(integer) IS 'Supprime les resultats pour un identifiant de resultat';


--
-- TOC entry 891 (class 1255 OID 2595669)
-- Dependencies: 2983 5
-- Name: af_del_resultat_exotlc_fichier_rendu(integer); Type: FUNCTION; Schema: contraintes; Owner: pgsql
--

CREATE FUNCTION af_del_resultat_exotlc_fichier_rendu(integer) RETURNS boolean
    AS $_$DECLARE
--$1 id resultat
BEGIN
	UPDATE contraintes.resultat_exotlc
	SET fichier_rendu = NULL
	WHERE id=$1;

	RETURN FOUND;
END;$_$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_del_resultat_exotlc_fichier_rendu(integer) OWNER TO pgsql;

--
-- TOC entry 892 (class 1255 OID 2595670)
-- Dependencies: 2983 5
-- Name: af_del_resultat_fin(integer); Type: FUNCTION; Schema: contraintes; Owner: pgsql
--

CREATE FUNCTION af_del_resultat_fin(integer) RETURNS boolean
    AS $_$DECLARE
--$1 resultat
duree_init interval;
BEGIN
	
	UPDATE contraintes.resultat
	SET duree=NULL
	WHERE id=$1;

	RETURN FOUND;
		

END;$_$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_del_resultat_fin(integer) OWNER TO pgsql;

--
-- TOC entry 893 (class 1255 OID 2595671)
-- Dependencies: 2983 5
-- Name: af_del_salle(integer); Type: FUNCTION; Schema: contraintes; Owner: pgsql
--

CREATE FUNCTION af_del_salle(integer) RETURNS boolean
    AS $_$-- $1 : numero salle
begin
    delete from contraintes.salle where id=$1;
    return found;
end;$_$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_del_salle(integer) OWNER TO pgsql;

--
-- TOC entry 7319 (class 0 OID 0)
-- Dependencies: 893
-- Name: FUNCTION af_del_salle(integer); Type: COMMENT; Schema: contraintes; Owner: pgsql
--

COMMENT ON FUNCTION af_del_salle(integer) IS 'supprime une salle';


--
-- TOC entry 894 (class 1255 OID 2595672)
-- Dependencies: 2983 5
-- Name: af_del_section(integer); Type: FUNCTION; Schema: contraintes; Owner: pgsql
--

CREATE FUNCTION af_del_section(integer) RETURNS boolean
    AS $_$-- $1 : numero section
begin
    delete from contraintes.section 
    where id=$1;
    return found;
end;$_$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_del_section(integer) OWNER TO pgsql;

--
-- TOC entry 7321 (class 0 OID 0)
-- Dependencies: 894
-- Name: FUNCTION af_del_section(integer); Type: COMMENT; Schema: contraintes; Owner: pgsql
--

COMMENT ON FUNCTION af_del_section(integer) IS 'supprime une section';


--
-- TOC entry 895 (class 1255 OID 2595673)
-- Dependencies: 2983 5
-- Name: af_del_serie_aleatoire_configuration(integer, integer); Type: FUNCTION; Schema: contraintes; Owner: pgsql
--

CREATE FUNCTION af_del_serie_aleatoire_configuration(integer, integer) RETURNS boolean
    AS $_$declare

begin
    if $2=2 then
	delete from contraintes.serie_aleatoire_multiserie where serie=$1;
    else
	if $2=3 then
	    delete from contraintes.serie_aleatoire_multitheme where serie=$1;
	else
	    raise exception 'Mode invalide';
	end if;
     end if;
     return found;
end;$_$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_del_serie_aleatoire_configuration(integer, integer) OWNER TO pgsql;

--
-- TOC entry 7323 (class 0 OID 0)
-- Dependencies: 895
-- Name: FUNCTION af_del_serie_aleatoire_configuration(integer, integer); Type: COMMENT; Schema: contraintes; Owner: pgsql
--

COMMENT ON FUNCTION af_del_serie_aleatoire_configuration(integer, integer) IS 'Supprime la configuration d''une serie aleatoire multiserie ou multitheme';


--
-- TOC entry 896 (class 1255 OID 2595674)
-- Dependencies: 2983 5
-- Name: af_del_serie_aleatoire_melangee(integer, integer, integer); Type: FUNCTION; Schema: contraintes; Owner: pgsql
--

CREATE FUNCTION af_del_serie_aleatoire_melangee(integer, integer, integer) RETURNS boolean
    AS $_$-- $1 : serie
-- $2 : formation
-- $3 : parcours
begin
    -- suppression dans serie aleatoire
    
    delete from contraintes.serie_aleatoire_melangee 
    where serie=$1 and formation=$2 and parcours=$3;

    -- suppression dans serie aleatoire (si 
    delete from contraintes.serie_aleatoire where id=$1 and type=1;
    return found;
end;$_$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_del_serie_aleatoire_melangee(integer, integer, integer) OWNER TO pgsql;

--
-- TOC entry 7325 (class 0 OID 0)
-- Dependencies: 896
-- Name: FUNCTION af_del_serie_aleatoire_melangee(integer, integer, integer); Type: COMMENT; Schema: contraintes; Owner: pgsql
--

COMMENT ON FUNCTION af_del_serie_aleatoire_melangee(integer, integer, integer) IS 'Supprime le mode aleatoire pour une serie existante';


--
-- TOC entry 897 (class 1255 OID 2595675)
-- Dependencies: 2983 5
-- Name: af_del_serie_bloquante_configuration(integer, integer, integer); Type: FUNCTION; Schema: contraintes; Owner: pgsql
--

CREATE FUNCTION af_del_serie_bloquante_configuration(integer, integer, integer) RETURNS boolean
    AS $_$-- $1 : serie
-- $2 : formation
-- $3 : parcours
begin
    delete from contraintes.serie_bloquante 
    where serie=$1 and formation=$2 and parcours=$3;
    return found;
end;$_$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_del_serie_bloquante_configuration(integer, integer, integer) OWNER TO pgsql;

--
-- TOC entry 7327 (class 0 OID 0)
-- Dependencies: 897
-- Name: FUNCTION af_del_serie_bloquante_configuration(integer, integer, integer); Type: COMMENT; Schema: contraintes; Owner: pgsql
--

COMMENT ON FUNCTION af_del_serie_bloquante_configuration(integer, integer, integer) IS 'Supprime la configuration d''une serie bloquante';


--
-- TOC entry 898 (class 1255 OID 2595676)
-- Dependencies: 2983 5
-- Name: af_del_serie_evaluation(integer, integer); Type: FUNCTION; Schema: contraintes; Owner: pgsql
--

CREATE FUNCTION af_del_serie_evaluation(integer, integer) RETURNS boolean
    AS $_$DECLARE
--$1 la serie
--$2 l'evaluation a supprimer de l'assoc
ok bool;
BEGIN

	SELECT INTO ok contraintes.af_gen_del_element('contraintes.serie_evaluations', 'evaluation', $2, ' AND serie='||$1); 
	RETURN ok;
END$_$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_del_serie_evaluation(integer, integer) OWNER TO pgsql;

--
-- TOC entry 899 (class 1255 OID 2595677)
-- Dependencies: 2983 5
-- Name: af_del_serie_evaluation_ordre(integer, integer); Type: FUNCTION; Schema: contraintes; Owner: pgsql
--

CREATE FUNCTION af_del_serie_evaluation_ordre(integer, integer) RETURNS boolean
    AS $_$DECLARE
req varchar;
cond varchar;
BEGIN

	IF $2 IS NULL THEN
		cond:=' IS NULL';
	ELSE
		cond:=' ='||$3;

	END IF;

	req:='DELETE FROM contraintes.serie_evaluations 
	WHERE id=$1 AND pere '||cond;

	EXECUTE req;

	RETURN FOUND;
END;$_$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_del_serie_evaluation_ordre(integer, integer) OWNER TO pgsql;

--
-- TOC entry 7330 (class 0 OID 0)
-- Dependencies: 899
-- Name: FUNCTION af_del_serie_evaluation_ordre(integer, integer); Type: COMMENT; Schema: contraintes; Owner: pgsql
--

COMMENT ON FUNCTION af_del_serie_evaluation_ordre(integer, integer) IS 'Supprime une évaluation d''une série en fonction du numero du père.';


--
-- TOC entry 900 (class 1255 OID 2595678)
-- Dependencies: 2983 5
-- Name: af_del_template(integer); Type: FUNCTION; Schema: contraintes; Owner: pgsql
--

CREATE FUNCTION af_del_template(integer) RETURNS boolean
    AS $_$-- $1 : numero modele
begin
    delete from contraintes.modele_correction where id=$1;
    return found;
end;$_$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_del_template(integer) OWNER TO pgsql;

--
-- TOC entry 7332 (class 0 OID 0)
-- Dependencies: 900
-- Name: FUNCTION af_del_template(integer); Type: COMMENT; Schema: contraintes; Owner: pgsql
--

COMMENT ON FUNCTION af_del_template(integer) IS 'supprime un modele de correction';


--
-- TOC entry 901 (class 1255 OID 2595679)
-- Dependencies: 2983 5
-- Name: af_del_test_positionnement(integer, integer); Type: FUNCTION; Schema: contraintes; Owner: pgsql
--

CREATE FUNCTION af_del_test_positionnement(integer, integer) RETURNS boolean
    AS $_$DECLARE
--$1 test
--$2 positionnement
BEGIN
	PERFORM * FROM contraintes.af_gen_del_element('contraintes.test_positionnements', 'positionnement', $2, ' AND test='||$1);
	RETURN FOUND;
END;$_$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_del_test_positionnement(integer, integer) OWNER TO pgsql;

--
-- TOC entry 902 (class 1255 OID 2595680)
-- Dependencies: 2983 5
-- Name: af_del_tests(integer[]); Type: FUNCTION; Schema: contraintes; Owner: pgsql
--

CREATE FUNCTION af_del_tests(tests integer[]) RETURNS integer
    AS $_$DECLARE
---$1 tests
i int4;
nb int4:=0;
BEGIN

	FOR i IN array_lower($1, 1) .. array_upper($1, 1) 
	LOOP
		nb:=nb+1;
		DELETE FROM contraintes.test WHERE id=$1[i];
	END LOOP; 

	raise notice 'nb supprime= %',nb;
	RETURN nb;
END$_$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_del_tests(tests integer[]) OWNER TO pgsql;

--
-- TOC entry 903 (class 1255 OID 2595681)
-- Dependencies: 2983 5
-- Name: af_del_theme(integer); Type: FUNCTION; Schema: contraintes; Owner: postgres
--

CREATE FUNCTION af_del_theme(integer) RETURNS boolean
    AS $_$
BEGIN

	DELETE  FROM contraintes.theme WHERE id=$1;
	
	RETURN FOUND;
END;$_$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_del_theme(integer) OWNER TO postgres;

--
-- TOC entry 7336 (class 0 OID 0)
-- Dependencies: 903
-- Name: FUNCTION af_del_theme(integer); Type: COMMENT; Schema: contraintes; Owner: postgres
--

COMMENT ON FUNCTION af_del_theme(integer) IS 'Supprimer le theme dont l''identifiant est passÃ© en paramettre';


--
-- TOC entry 1827 (class 1255 OID 2595682)
-- Dependencies: 2983 5
-- Name: af_fk_finder(character varying, character varying, integer); Type: FUNCTION; Schema: contraintes; Owner: pgsql
--

CREATE FUNCTION af_fk_finder(character varying, character varying, integer) RETURNS boolean
    AS $_$DECLARE
--$1 nom de la table
--$2 nom de la colonne
--$3 valeur de la colonne
start_oid_values _int4;
rec RECORD;
i int4:=0;
req varchar;
nb_referenced_records int4;
BEGIN 

	--(A) on selection les oid du shema, de la table et le numero de la colonne
	SELECT INTO start_oid_values * FROM contraintes.af_fk_finder_oid($1,$2);
	--RAISE NOTICE '% % %',start_oid_values[1], start_oid_values[2],start_oid_values[3]; 
	
	--(B)on selectionne les noms du shema, des tables et des colonnes des tables ayant une rÃ©fÃ©rence vers (B)
	FOR rec IN 
		SELECT * FROM contraintes.af_fk_finder_tree(start_oid_values[1], start_oid_values[2], start_oid_values[3]) AS fkeys_infos
	LOOP
		--RAISE NOTICE '%: % %',i, rec.fkeys_infos[1],rec.fkeys_infos[2];
		i:=i+1;
		--(C) pour chacunes de ces tables on execute une requete pour avoir le nombre d'enregistrements refÃ©renÃ§ant la colonne de (A) avec l'identifiant voulu
		--cela en ignorant les tables de categories (car tout y est forcement!)
		IF rec.fkeys_infos[2]NOT LIKE '%categorie_%' THEN
	
			req:='SELECT '||rec.fkeys_infos[1]||' FROM contraintes.'||rec.fkeys_infos[2]||' WHERE '||rec.fkeys_infos[1]||'= '||$3;
			--RAISE NOTICE 'req=%',req;
			EXECUTE req; 

			GET DIAGNOSTICS nb_referenced_records = ROW_COUNT;

			IF nb_referenced_records>0 THEN
				--RAISE NOTICE 'nombre de liens trouvÃ©:%',nb_referenced_records;
				RETURN TRUE;
			ELSE
				CONTINUE;
			END IF;
		END IF;
	END LOOP;

	RETURN FALSE;
END$_$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_fk_finder(character varying, character varying, integer) OWNER TO pgsql;

--
-- TOC entry 7338 (class 0 OID 0)
-- Dependencies: 1827
-- Name: FUNCTION af_fk_finder(character varying, character varying, integer); Type: COMMENT; Schema: contraintes; Owner: pgsql
--

COMMENT ON FUNCTION af_fk_finder(character varying, character varying, integer) IS 'Savoir si un Ã©lÃ©ment est vÃ©rouillÃ©.
Retourne TRUE si l''element $3 de la table $2 et du shema $1 est prÃ©sent dans une table avec laquelle il serait liÃ© par une clÃ© Ã©trangÃ¨re.';


--
-- TOC entry 1828 (class 1255 OID 2595683)
-- Dependencies: 2983 5
-- Name: af_fk_finder_oid(character varying, character varying); Type: FUNCTION; Schema: contraintes; Owner: pgsql
--

CREATE FUNCTION af_fk_finder_oid(character varying, character varying) RETURNS oid[]
    AS $_$DECLARE
--$1 nom de la table
--$2 nom de la colonne
nom_shema varchar:='contraintes';
tmp1 oid;
tmp2 oid;
tmp3 int4; --attention, ce n'est pas un oid, mais le numÃ©ro de la colonne! (nb: de 1 Ã  n)
BEGIN

	--recupere l'oid du schema
	SELECT INTO tmp1 oid FROM pg_catalog.pg_namespace WHERE nspname LIKE nom_shema;
	--raise notice 'oid schema=%',tmp1;
	
	--recupere l'oid de la table
	SELECT INTO tmp2 oid FROM pg_catalog.pg_class WHERE relname LIKE $1
	AND relnamespace=tmp1;
	
	--recupere l'oid de la colonne
	SELECT INTO tmp3 attnum FROM pg_catalog.pg_attribute WHERE attname LIKE $2 AND attrelid=tmp2;
	
	RETURN ARRAY[tmp1,tmp2,tmp3];
END$_$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_fk_finder_oid(character varying, character varying) OWNER TO pgsql;

--
-- TOC entry 7340 (class 0 OID 0)
-- Dependencies: 1828
-- Name: FUNCTION af_fk_finder_oid(character varying, character varying); Type: COMMENT; Schema: contraintes; Owner: pgsql
--

COMMENT ON FUNCTION af_fk_finder_oid(character varying, character varying) IS 'FONCTION PRIVEE
Composante de la fonction af_fk_finder.

Retourne un tableau de 2 Ã©lÃ©ments contenant, dans l''ordre:
-l''oid du shema contraintes
-l''oid de la table passÃ© en 1er paramatre
-le numero de la colonne passÃ© en 2Ã¨me parametre';


--
-- TOC entry 904 (class 1255 OID 2595684)
-- Dependencies: 2983 5
-- Name: af_fk_finder_tree(oid, oid, integer); Type: FUNCTION; Schema: contraintes; Owner: pgsql
--

CREATE FUNCTION af_fk_finder_tree(oid, oid, integer) RETURNS SETOF character varying[]
    AS $_$DECLARE
--$1 oid du schema
--$2 oid de la table
--$3 numero de la colonne
nb int4:=0;
rec RECORD;
BEGIN

FOR rec IN
	SELECT DISTINCT
	--fka.attrelid AS FKTABLE_OID,
	--fka.attnum AS FKCOL_OID
	fka.attname AS FKTABLE_NAME,
	fkc.relname AS FKCOL_NAME
	FROM
		pg_constraint AS fkcon
	JOIN
		pg_constraint AS pkcon ON fkcon.confrelid=pkcon.conrelid
			AND fkcon.confkey=pkcon.conkey
	JOIN
		pg_class fkc ON fkc.oid=fkcon.conrelid
	JOIN
		pg_class pkc ON pkc.oid=fkcon.confrelid
	JOIN
		pg_attribute fka ON  fka.attrelid=fkc.oid  AND fka.attnum=fkcon.conkey[1]
	JOIN
		pg_attribute pka ON pka.attrelid=pkc.oid  AND pka.attnum=pkcon.conkey[1]
	WHERE pkcon.connamespace=$1
	AND pkc.oid=$2
	AND pka.attnum=$3
LOOP
	RETURN NEXT ARRAY[rec.FKTABLE_NAME, rec.FKCOL_NAME];
	RAISE NOTICE '% % %',$1, rec.FKTABLE_NAME,rec.FKCOL_NAME; 
	nb:=nb+1;
END LOOP;
	RAISE NOTICE 'Nombre de table liÃ©es trouvÃ©es:%',nb;
RETURN;

END$_$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_fk_finder_tree(oid, oid, integer) OWNER TO pgsql;

--
-- TOC entry 7342 (class 0 OID 0)
-- Dependencies: 904
-- Name: FUNCTION af_fk_finder_tree(oid, oid, integer); Type: COMMENT; Schema: contraintes; Owner: pgsql
--

COMMENT ON FUNCTION af_fk_finder_tree(oid, oid, integer) IS 'FONCTION PRIVEE
Composante de la fonction af_fk_finder.

Retourne le nom des tables et de leurs colonnes liées aux parametres de la fonction.';


--
-- TOC entry 905 (class 1255 OID 2595685)
-- Dependencies: 2983 5
-- Name: af_gen_del_element(character varying, character varying, integer, text); Type: FUNCTION; Schema: contraintes; Owner: postgres
--

CREATE FUNCTION af_gen_del_element(character varying, character varying, integer, text) RETURNS integer
    AS $_$DECLARE
	-- nom de la table sur laquelle executer la requete
	nom_table ALIAS FOR $1;
	-- nom du champ lie au champ pere ( le champ id )
	nom_id ALIAS FOR $2;
	-- numero de l'element (id) que l'on veut supprimer
	indice ALIAS FOR $3;
	-- condition de selection d'une ligne
	cond ALIAS FOR  $4;
	-- variable ou l'on stock une ligne du resultat de la 1ere requete
	rec1 record;
	-- variable ou l'on stock une ligne du resultat de la 2eme requete
	rec2 record;
	-- variable dans laquelle on stock la chaine de la 1ere requete pour sa contruction
	req1 text;
	-- variable dans laquelle on stock la chaine de la 2eme  requete pour sa contruction
	req2 text;
	-- variable dans laquelle on stock la chaine de la 3eme  requete pour sa contruction
	req3 text;
	-- variable dans laquelle on stock la chaine de la 4eme requete pour sa contruction
	req4 text;
	--permet de stocker le nombre de lignes supprimees
	nb_del int4;
	--variable tmp
	rec1_pere varchar;
	--variable temporaire
	tmp_id RECORD;
	fait bool:=FALSE;
BEGIN
	--RAISE NOTICE 'p1:% p2:% p3:% p4:%',$1,$2,$3,$4;
	
	--SELECTION DES LIGNES QUI SONT PERES DES ENREGISTREMENTS A SUPPRIMER
	--on construit la requete
	req1:='SELECT  pere  FROM '|| nom_table;
	req1:=req1   ||' WHERE '||nom_id||'='|| indice ||' '|| cond ||' ;';

	--chaque ligne du resultat est stockee temporairement dans rec1
	FOR rec1 IN 
		EXECUTE req1
			LOOP
				--SELECTION DES LIGNES QUI SONT FILLES DES ENREGISTREMENTS A SUPPRIMER
				--on construit la requete
				req2:='SELECT  '||nom_id||' AS id  FROM '|| nom_table;
				req2:=req2   ||' WHERE pere ='|| indice ||' '|| cond ||' ;';
			
				--chaque ligne du resultat est stockee temporairement dans rec2
				FOR rec2 IN 
					EXECUTE req2
						LOOP
							IF rec1.pere IS NULL THEN
								rec1_pere:='=NULL ';
							ELSE
								rec1_pere:='= '||rec1.pere;
							END IF;

							--ASTUCE: ON RECUPERE L'id DU DERNIER POUR LE METTRE TEMPORAIREMENT COMME PERE, AU LIEU DE rec1_pere
							--(pour respecter les contraintes)
							FOR tmp_id IN
								SELECT * FROM contraintes.af_gen_get_last_element(nom_table, nom_id, cond)
							LOOP
							END LOOP;

							--RAISE NOTICE 'rec1.pere:% rec2.id % ',rec1.pere,rec2.id;
							--EFFECTUE L'UPDATE DES FILS AVEC LA VALEUR TEMPORAIRE
							req3='UPDATE  '||nom_table ||' SET pere ='|| tmp_id.id ||' WHERE '||nom_id||'='|| rec2.id ||' '|| cond ||' ;';
							--RAISE NOTICE 'req3=%',req3;
							EXECUTE req3;

							--SUPPRIME LES ENREGISTREMENTS VOULUS
							req4='DELETE FROM  '||nom_table ||'  WHERE '||nom_id||'='|| indice ||' '|| cond ||' ;';
							EXECUTE req4;
							--recupere le nombre de lignes modifiees par la derniere requete (ici le delete)
							GET DIAGNOSTICS nb_del = ROW_COUNT;

							--EFFECTUE L'UPDATE DES FILS AVEC LE NOUVEAU PERE 
							req3='UPDATE  '||nom_table ||' SET pere '|| rec1_pere ||' WHERE '||nom_id||'='|| rec2.id ||' '|| cond ||' ;';
							EXECUTE req3;
						
							fait:=TRUE;
						END LOOP;	
			END LOOP;
	--CAS OU L'ELEMENT A SUPPRIMER EST LE DERNIER
	IF fait IS FALSE THEN
		--SUPPRIME LES ENREGISTREMENTS VOULUS
		req4='DELETE FROM  '||nom_table ||'  WHERE '||nom_id||'='|| indice ||' '|| cond ||' ;';
		EXECUTE req4;
		--recupere le nombre de lignes modifiees par la derniere requete (ici le delete)
		GET DIAGNOSTICS nb_del = ROW_COUNT;
	END IF;
	RETURN  nb_del;
END;$_$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_gen_del_element(character varying, character varying, integer, text) OWNER TO postgres;

--
-- TOC entry 7344 (class 0 OID 0)
-- Dependencies: 905
-- Name: FUNCTION af_gen_del_element(character varying, character varying, integer, text); Type: COMMENT; Schema: contraintes; Owner: postgres
--

COMMENT ON FUNCTION af_gen_del_element(character varying, character varying, integer, text) IS 'Supprimer un element dans une table avec une notion de parentalitÃ©.

param1:
Le nom de la table

param2:
Le nom du champ liÃ© au champ pere (id)

param3:
Le numero du champ param2 (id) Ã  supprimer

param4:
La condition de selection de l''element Ã  supprimer.

retourne le nombre d''Ã©lÃ©ments supprimÃ©s dans la table.';


--
-- TOC entry 906 (class 1255 OID 2595686)
-- Dependencies: 2983 5
-- Name: af_gen_get_element_niveau(character varying, character varying, integer, text, integer); Type: FUNCTION; Schema: contraintes; Owner: postgres
--

CREATE FUNCTION af_gen_get_element_niveau(character varying, character varying, integer, text, integer) RETURNS integer
    AS $_$declare
	--stock le resultat de la requete
	rec record;
	-- variable dans laquelle on stock la chaine de la requete pour sa contruction
	req text;
	--1er parametre : nom de la table sur laquelle on fait la requete
	nom_table ALIAS FOR  $1;
	--2eme parametre :nom du champ liÃÂ© au champ pÃÅ¡re ( le champ id )
	nom_id ALIAS FOR $2;
	--3eme parametre : numero de l'element dont on cherche le niveau
	id ALIAS FOR  $3;
	--5eme parametre :condition de selection d'une ligne 
	cond ALIAS FOR  $4;
	-- l'indice 
	ind ALIAS FOR $5;
	--variable  permettant l'incrÃÂ©mentation de l'indice 
	indice int4;
	--nombre de lignes trouvÃÂ©es par la requete
	trouve int4;
begin

	--si l'id est null on retourne l'indice
	if(id is null) then
		--raise notice 'detection de la fin, ind=%', ind;
		return ind;
		exit;
	end if;

	--on incrÃÂ©mente l'indice 
	indice:=ind+1;

	--on construit la requete
	req:='SELECT  '||nom_id||' AS id, pere, '||indice ||' AS ind  FROM ';
	req:=req || nom_table|| ' where id= ' || id;
	--fin de la construction de la requete
	req:=req ||' ' || cond ||' ;';

	for rec in
		execute req
	loop
		if( rec.id is not null) then
			--raise notice 'appel recursif, indice=%',indice;
			select into indice contraintes.af_gen_get_element_niveau(nom_table,nom_id,  rec.pere, cond, indice);
		end if;
	end loop;
	--on recupere le nombre de lignes trouvÃÂ©es par le execute 
	GET DIAGNOSTICS trouve = ROW_COUNT;
	if(trouve =0 )then 
		--met l'indice a 0 pour faire la distinction entre le niveau 1 et pas de niveau
		indice := null;
	end if;
	--retourne le niveau
	return indice ;
end$_$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_gen_get_element_niveau(character varying, character varying, integer, text, integer) OWNER TO postgres;

--
-- TOC entry 7346 (class 0 OID 0)
-- Dependencies: 906
-- Name: FUNCTION af_gen_get_element_niveau(character varying, character varying, integer, text, integer); Type: COMMENT; Schema: contraintes; Owner: postgres
--

COMMENT ON FUNCTION af_gen_get_element_niveau(character varying, character varying, integer, text, integer) IS 'fonction gÃ©nÃ©rique permettant d''obtenir le niveau d''un element dans une table ayant une notion de parentalitÃ© (commence Ã  1)';


--
-- TOC entry 907 (class 1255 OID 2595687)
-- Dependencies: 2154 2983 5
-- Name: af_gen_get_elements(character varying, character varying, integer, text, integer); Type: FUNCTION; Schema: contraintes; Owner: postgres
--

CREATE FUNCTION af_gen_get_elements(character varying, character varying, integer, text, integer) RETURNS SETOF parents
    AS $_$DECLARE
	--permet de stocker le resultat de la requete
	rec contraintes.parents;
	--permet de stocker le resultat de la fonction appelÃÂ©e recursivement
	rec_tmp contraintes.parents;
	-- variable dans laquelle on stock la chaine de la requete pour sa contruction
	req text;
	--1er parametre : nom de la table sur laquelle on fait la requete
	nom_table ALIAS FOR  $1;
	--2eme parametre :nom du champ liÃÂ© au champ pÃÅ¡re ( le champ id )
	nom_id ALIAS FOR $2;
	--3eme parametre : numero de l'element (id) ÃÂ  partir duquel ont veut les elements (valeur du champ pere)
	id_pere ALIAS FOR  $3;
	--4eme parametre :condition de selection d'une ligne 
	cond ALIAS FOR  $4;
	--variable locale permettant l'incrÃÂ©mentation de l'indice pour le tris 
	ind int4;
BEGIN
	--on incrÃÂ©mente l'indice (5eme paramettre)
	ind:=$5 +1;
	--on construit la requete
	req:='SELECT  DISTINCT '||nom_id||' AS id, pere, '||ind ||' AS ind  FROM ';
	req:=req || nom_table ;	
	
	--on test la variable id_pere qui peut etre NULL et construit la requete en fonction
	IF id_pere IS NOT NULL THEN
		req:=req || ' where pere= ' || id_pere;
	ELSE 
		req:= req || ' where pere IS NULL ';
	END IF;

	--fin de la construction de la requete
	req:=req ||' ' || cond ||' ;';

	--chaque ligne du resultat est stockÃÂ©e temporairement dans rec
	FOR rec IN 
		--execution de la requete construite
		EXECUTE req
			--pour chaque ligne de resultat (rec)
			LOOP
				--on retourne le resultat (setof contraintes.parents) de la fonction si fin de la recursivite
				IF rec.id IS NULL THEN
					RETURN ;
				ELSE 
					--sinon :
					--chaque ligne du resultat de la requete recursive est stockÃÂ©e temporairement dans rec_tmp
					FOR rec_tmp IN
						---on rappelle la fonction recursivement avec un nouveau id_pere
						SELECT * FROM contraintes.af_gen_get_elements( nom_table, nom_id, rec.id, cond, ind) 
					LOOP
						--on ajoute les elements voulus de la ligne de resultat temporaire (rec_tmp) au retour de la fonction ( setof parents )
						RETURN NEXT rec_tmp ;
					END LOOP;
						--on ajoute les elements voulus de la ligne de resultat temporaire (rec) au retour de la fonction ( setof parents )
					RETURN NEXT rec;
				END IF;
			END LOOP;
	-- retourne le resultat de la fonction (setof parents)
	RETURN;
END;$_$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_gen_get_elements(character varying, character varying, integer, text, integer) OWNER TO postgres;

--
-- TOC entry 7348 (class 0 OID 0)
-- Dependencies: 907
-- Name: FUNCTION af_gen_get_elements(character varying, character varying, integer, text, integer); Type: COMMENT; Schema: contraintes; Owner: postgres
--

COMMENT ON FUNCTION af_gen_get_elements(character varying, character varying, integer, text, integer) IS 'FONCTION PRIVEE:
est appellee par la fonction contraintes.af_gen_get_elements(varchar, varchar, int4, text)

Fonction gÃ©nÃ©rique permettant d''obtenir les elements d''une table ayant une notion de parentalitÃ© .

Le 1er parametre indique le nom de la table, le 2eme indique le nom du champ liÃ© au champ pÃ¨re (celui que l''on veut recuperer), le 3eme le numero du champ 2 Ã  partir duquel on veut les enregistrements,  le 4eme une chaine permetant de preciser la condition d''une ligne ( ex: ''AND toto= 8'') et le 5 eme l''indice du prÃ©cÃ©dent appel de fonction.
';


--
-- TOC entry 908 (class 1255 OID 2595688)
-- Dependencies: 2983 5
-- Name: af_gen_get_elements(character varying, character varying, integer, text); Type: FUNCTION; Schema: contraintes; Owner: postgres
--

CREATE FUNCTION af_gen_get_elements(character varying, character varying, integer, text) RETURNS SETOF integer
    AS $_$DECLARE
	-- nom de la table sur laquelle executer la requete
	nom_table ALIAS FOR $1;
	-- nom du champ liÃÂ© au champ pÃÅ¡re ( le champ id )
	nom_id ALIAS FOR $2;
	-- numero de l'element (id) ÃÂ  partir duquel ont veut les elements
	debut ALIAS FOR $3;
	-- condition de selection d'une ligne
	cond ALIAS FOR  $4;
	-- variable ou l'on stock une ligne du resultat de la requete
	rec record;
	--variable locale permettant l'initialisation de l'indice pour le tris dans l'odre ÃÂ  partir du 1er element (sans pere)
	ind_init int4;
BEGIN
	--initialisation de l'indice
	ind_init:=0;

	--chaque ligne du resultat est stockÃÂ©e temporairement dans rec
	FOR rec IN 
		-- la requete ordonnÃÂ© par l'indice
		SELECT id, ind FROM contraintes.af_gen_get_elements(nom_table, nom_id, debut,cond, ind_init) 
		ORDER BY ind 
			
			LOOP
				--on ajoute les elements voulus de la ligne de resultat temporaire (rec) au retour de la fonction ( setof int4 )
				RETURN NEXT rec.id;
			END LOOP;
	-- retourne le resultat de la fonction (setof int4)
	RETURN ;
END;$_$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_gen_get_elements(character varying, character varying, integer, text) OWNER TO postgres;

--
-- TOC entry 7350 (class 0 OID 0)
-- Dependencies: 908
-- Name: FUNCTION af_gen_get_elements(character varying, character varying, integer, text); Type: COMMENT; Schema: contraintes; Owner: postgres
--

COMMENT ON FUNCTION af_gen_get_elements(character varying, character varying, integer, text) IS 'Fonction gÃ©nÃ©rique permettant d''obtenir les elements d''une table ayant une notion de parentalitÃ© dans l''ordre.

Le 1er parametre indique le nom de la table, le 2eme indique le nom du champ liÃ© au champ pÃ¨re (celui que l''on veut recuperer), le 3eme le numero du champ 2 Ã  partir duquel on veut les enregistrements et le 4eme une chaine permetant de preciser la condition d''une ligne ( ex: ''AND toto= 8'')

exemple d''appel: 
select * from contraintes.af_gen_get_elements(varchar ''contraintes.parcours_etapes'', varchar ''etape'' , NULL ,text ''AND parcours=1'');';


--
-- TOC entry 909 (class 1255 OID 2595689)
-- Dependencies: 2154 2983 5
-- Name: af_gen_get_elements(character varying, character varying, integer, text, integer, integer[]); Type: FUNCTION; Schema: contraintes; Owner: postgres
--

CREATE FUNCTION af_gen_get_elements(character varying, character varying, integer, text, integer, integer[]) RETURNS SETOF parents
    AS $_$DECLARE
	--permet de stocker le resultat de la requete
	rec contraintes.parents;
	--permet de stocker le resultat de la fonction appelÃÂ©e recursivement
	rec_tmp contraintes.parents;
	-- variable dans laquelle on stock la chaine de la requete pour sa contruction
	req text;
	--1er parametre : nom de la table sur laquelle on fait la requete
	nom_table ALIAS FOR  $1;
	--2eme parametre :nom du champ liÃÂ© au champ pÃÅ¡re ( le champ id )
	nom_id ALIAS FOR $2;
	--3eme parametre : numero de l'element (id) ÃÂ  partir duquel ont veut les elements (valeur du champ pere)
	id_pere ALIAS FOR  $3;
	--4eme parametre :condition de selection d'une ligne 
	cond ALIAS FOR  $4;
	--variable locale permettant l'incrÃÂ©mentation de l'indice pour le tris 
	ind int4;
BEGIN
	--on incrÃÂ©mente l'indice (5eme paramettre)
	ind:=$5 +1;
	--on construit la requete
	req:='SELECT  DISTINCT '||nom_id||' AS id, pere, '||ind ||' AS ind  FROM ';
	req:=req || nom_table ;	
	
	--on test la variable id_pere qui peut etre NULL et construit la requete en fonction
	IF id_pere IS NOT NULL THEN
		req:=req || ' where pere= ' || id_pere;
	ELSE 
		req:= req || ' where pere IS NULL ';
	END IF;

	--fin de la construction de la requete
	req:=req ||' ' || cond ||' and '||nom_id||' in ('||array_to_string($6,',')||');';

	--chaque ligne du resultat est stockÃÂ©e temporairement dans rec
	FOR rec IN 
		--execution de la requete construite
		EXECUTE req
			--pour chaque ligne de resultat (rec)
			LOOP
				--on retourne le resultat (setof contraintes.parents) de la fonction si fin de la recursivite
				IF rec.id IS NULL THEN
					RETURN ;
				ELSE 
					--sinon :
					--chaque ligne du resultat de la requete recursive est stockÃÂ©e temporairement dans rec_tmp
					FOR rec_tmp IN
						---on rappelle la fonction recursivement avec un nouveau id_pere
						SELECT * FROM contraintes.af_gen_get_elements( nom_table, nom_id, rec.id, cond, ind) 
					LOOP
						--on ajoute les elements voulus de la ligne de resultat temporaire (rec_tmp) au retour de la fonction ( setof parents )
						RETURN NEXT rec_tmp ;
					END LOOP;
						--on ajoute les elements voulus de la ligne de resultat temporaire (rec) au retour de la fonction ( setof parents )
					RETURN NEXT rec;
				END IF;
			END LOOP;
	-- retourne le resultat de la fonction (setof parents)
	RETURN;
END;$_$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_gen_get_elements(character varying, character varying, integer, text, integer, integer[]) OWNER TO postgres;

--
-- TOC entry 7352 (class 0 OID 0)
-- Dependencies: 909
-- Name: FUNCTION af_gen_get_elements(character varying, character varying, integer, text, integer, integer[]); Type: COMMENT; Schema: contraintes; Owner: postgres
--

COMMENT ON FUNCTION af_gen_get_elements(character varying, character varying, integer, text, integer, integer[]) IS 'FONCTION PRIVEE:
est appellee par la fonction contraintes.af_gen_get_elements(varchar, varchar, int4, text)

Fonction gÃ©nÃ©rique permettant d''obtenir les elements d''une table ayant une notion de parentalitÃ© .

Le 1er parametre indique le nom de la table, le 2eme indique le nom du champ liÃ© au champ pÃ¨re (celui que l''on veut recuperer), le 3eme le numero du champ 2 Ã  partir duquel on veut les enregistrements,  le 4eme une chaine permetant de preciser la condition d''une ligne ( ex: ''AND toto= 8'') et le 5 eme l''indice du prÃ©cÃ©dent appel de fonction.
';


--
-- TOC entry 1829 (class 1255 OID 2595690)
-- Dependencies: 2983 5
-- Name: af_gen_get_int_values(integer, integer); Type: FUNCTION; Schema: contraintes; Owner: pgsql
--

CREATE FUNCTION af_gen_get_int_values(integer, integer) RETURNS SETOF record
    AS $_$-- $1 : pas
-- $2 : max
declare
rec record;
pas integer;
max integer;
val integer;
i integer;
begin
    -- Init
    if $1 is null then
	pas:=10;
    else
	pas:=$1;
    end if;
    if $2 is null then
	max:=100;
    else
	max:=$2;
    end if;
    val:=pas;
    i:=1;
    loop
	if val<=max then
	    for rec in
		--select i,val
		select val,val
	    loop
		return next rec;
	    end loop;
	    val:=val+pas;
	    i:=i+1;
	else
	    exit;
	end if;
    end loop;
end;$_$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_gen_get_int_values(integer, integer) OWNER TO pgsql;

--
-- TOC entry 7354 (class 0 OID 0)
-- Dependencies: 1829
-- Name: FUNCTION af_gen_get_int_values(integer, integer); Type: COMMENT; Schema: contraintes; Owner: pgsql
--

COMMENT ON FUNCTION af_gen_get_int_values(integer, integer) IS 'genere des entiers avec un pas et un max';


--
-- TOC entry 910 (class 1255 OID 2595691)
-- Dependencies: 2154 2983 5
-- Name: af_gen_get_last_element(character varying, character varying, text); Type: FUNCTION; Schema: contraintes; Owner: postgres
--

CREATE FUNCTION af_gen_get_last_element(character varying, character varying, text) RETURNS SETOF parents
    AS $_$DECLARE
	-- nom de la table sur laquelle executer la requete
	nom_table ALIAS FOR $1;
	-- nom du champ liÃÂ© au champ pÃÅ¡re ( le champ id )
	nom_id ALIAS FOR $2;
	-- condition de selection d'une ligne
	cond ALIAS FOR  $3;
	-- variable ou l'on stock une ligne du resultat de la requete
	rec record;
	--variable locale permettant l'initialisation de l'indice pour le tris dans l'odre ÃÂ  partir du 1er element (sans pere)
	ind_init int4;
	--variable pour stocker l'indice maximal
	ind_max int4;
	--varable pour afficher le nombre de ligne retournÃÂ©es
	nb_lignes int4;
BEGIN
	--initialisations 
	ind_init:=0;
	nb_lignes:=0;
	-- On recupere l'indice maximal
	SELECT  MAX (ind) INTO ind_max FROM contraintes.af_gen_get_elements(nom_table, nom_id, NULL,cond, ind_init) ;
	
	--chaque ligne du resultat est stockÃÂ©e temporairement dans rec
	FOR rec IN 
		-- la requete ordonnÃÂ© par l'indice
		SELECT  id, pere, ind  FROM contraintes.af_gen_get_elements(nom_table, nom_id, NULL,cond, ind_init) 
		WHERE ind = ind_max
			LOOP
				--on ajoute les elements voulus de la ligne de resultat temporaire (rec) au retour de la fonction ( setof int4 )
				RETURN NEXT rec;
			END LOOP;
	GET DIAGNOSTICS nb_lignes = ROW_COUNT;
	--RAISE NOTICE 'nombre de lignes: %', nb_lignes;
	-- retourne le resultat de la fonction (setof contraintes.parents)
	RETURN ;
END;$_$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_gen_get_last_element(character varying, character varying, text) OWNER TO postgres;

--
-- TOC entry 7356 (class 0 OID 0)
-- Dependencies: 910
-- Name: FUNCTION af_gen_get_last_element(character varying, character varying, text); Type: COMMENT; Schema: contraintes; Owner: postgres
--

COMMENT ON FUNCTION af_gen_get_last_element(character varying, character varying, text) IS 'Retourne le dernier element d''une table ayant une notion de parentalitÃ© 

param1:
Nom de la table

param 2:
Nom du champ liÃ© au champ pere (id)

param3:
condition supplÃ©mÃ©ntaire la selection des enregistrements

exemple d''appel:
select * from contraintes.af_gen_get_last_element(varchar ''contraintes.parcours_etapes'', varchar ''etape'' ,text ''AND parcours=1'');
 ';


--
-- TOC entry 911 (class 1255 OID 2595692)
-- Dependencies: 2154 2983 5
-- Name: af_gen_get_last_element(character varying, character varying, integer[], text); Type: FUNCTION; Schema: contraintes; Owner: postgres
--

CREATE FUNCTION af_gen_get_last_element(character varying, character varying, integer[], text) RETURNS SETOF parents
    AS $_$DECLARE
	-- nom de la table sur laquelle executer la requete
	nom_table ALIAS FOR $1;
	-- nom du champ liÃÂ© au champ pÃÅ¡re ( le champ id )
	nom_id ALIAS FOR $2;
	-- tableau des valeurs pour le champ nom_id
	val_id alias for $3;
	-- condition de selection d'une ligne
	cond ALIAS FOR  $4;
	-- variable ou l'on stock une ligne du resultat de la requete
	rec record;
	--variable locale permettant l'initialisation de l'indice pour le tris dans l'odre ÃÂ  partir du 1er element (sans pere)
	ind_init int4;
	--variable pour stocker l'indice maximal
	ind_max int4;
	--varable pour afficher le nombre de ligne retournÃÂ©es
	nb_lignes int4;
BEGIN
	--initialisations 
	ind_init:=0;
	nb_lignes:=0;
	-- On recupere l'indice maximal
	SELECT  MAX (ind) INTO ind_max FROM contraintes.af_gen_get_elements(nom_table, nom_id, NULL,cond, ind_init,val_id) ;
	
	--chaque ligne du resultat est stockÃÂ©e temporairement dans rec
	FOR rec IN 
		-- la requete ordonnÃÂ© par l'indice
		SELECT  id, pere, ind  FROM contraintes.af_gen_get_elements(nom_table, nom_id, NULL,cond, ind_init,val_id) 
		WHERE ind = ind_max
			LOOP
				--on ajoute les elements voulus de la ligne de resultat temporaire (rec) au retour de la fonction ( setof int4 )
				RETURN NEXT rec;
			END LOOP;
	GET DIAGNOSTICS nb_lignes = ROW_COUNT;
	RAISE NOTICE 'nombre de lignes: %', nb_lignes;
	-- retourne le resultat de la fonction (setof contraintes.parents)
	RETURN ;
END;$_$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_gen_get_last_element(character varying, character varying, integer[], text) OWNER TO postgres;

--
-- TOC entry 7358 (class 0 OID 0)
-- Dependencies: 911
-- Name: FUNCTION af_gen_get_last_element(character varying, character varying, integer[], text); Type: COMMENT; Schema: contraintes; Owner: postgres
--

COMMENT ON FUNCTION af_gen_get_last_element(character varying, character varying, integer[], text) IS 'Retourne le dernier element d''une table ayant une notion de parentalitÃ© 

param1:
Nom de la table

param 2:
Nom du champ liÃ© au champ pere (id)

param3:
condition supplÃ©mÃ©ntaire la selection des enregistrements

exemple d''appel:
select * from contraintes.af_gen_get_last_element(varchar ''contraintes.parcours_etapes'', varchar ''etape'' ,text ''AND parcours=1'');
 ';


--
-- TOC entry 912 (class 1255 OID 2595693)
-- Dependencies: 2983 5
-- Name: af_gen_invert_elements(character varying, character varying, integer, integer, text); Type: FUNCTION; Schema: contraintes; Owner: postgres
--

CREATE FUNCTION af_gen_invert_elements(character varying, character varying, integer, integer, text) RETURNS boolean
    AS $_$DECLARE
	-- variable dans laquelle on stock la chaine de la 1ere requete pour sa contruction (1ere select)
	req1 text;
	-- variable dans laquelle on stock la chaine de la 2eme requete pour sa contruction (2eme select)
	req2 text;
	req3 text;
	-- variable dans laquelle on stock la chaine de la 3eme requete pour sa contruction(1er update)
	req1U text;
	-- variable dans laquelle on stock la chaine de la 3eme requete pour sa contruction(2eme update)
	req2U text;
	-- variable dans laquelle on stock la chaine de la 3eme requete pour sa contruction(3eme update)
	req3U text;
	-- variable dans laquelle on stock la chaine de la 3eme requete pour sa contruction(4eme update)
	req4U text;
	--resultat du premier select
	rec1 record; 
	--resultat du second select
	rec2 record;
	--1er parametre : nom de la table sur laquelle on fait la requete
	nom_table ALIAS FOR  $1;
	--2eme parametre :nom du champ liÃÂ© au champ pÃÅ¡re ( le champ id )
	nom_id ALIAS FOR $2;
	--numero d'un des 2 enregistrements que l'on veut inverser
	numero1 ALIAS FOR $3;
	--numero de l'autre enregistrement que l'on veut inverser
	numero2 ALIAS FOR $4;
	--condition de selection d'une ligne pour SELECT et UPDATE
	cond ALIAS FOR  $5;
	--boolÃÂ©en pour savoir si une l'inversion ÃÂ  eut lieu
	inverse boolean;
	--variable pour socker le nombre de ligne modifiÃÂ©es pour le premier update
	nb1 int4;
	--variable pour socker le nombre de ligne modifiÃÂ©es pour le deuxieme update
	nb2 int4;
	p1 varchar;
	p2 varchar;
	id int4;
BEGIN
	--initialisations
	inverse:=FALSE;
	nb1:=0;
	nb2:=0;

	--ON VERIFIE QUE LES 2 ELEMENTS A INVERSER NE SONT PAS NULL
	IF((numero1 IS NOT NULL  ) AND (numero2 IS NOT NULL)) THEN
	
		--ON RECUPERE LE PERE DU PREMIER ENREGISTREMENT
		req1:='SELECT   pere FROM '|| nom_table ||' WHERE '|| nom_id ||'='||numero1||' '||cond ||';';
		RAISE NOTICE 'req1=%',req1;
		--ON RECUPERE LE PERE DU SECOND ENREGISTREMENT
		req2:='SELECT   pere FROM '|| nom_table ||' WHERE '|| nom_id ||'='||numero2||' '||cond ||';';
		RAISE NOTICE 'req2=%',req2;
		--ON RECUPERE L'ID DU PERE DU PREMIER ENREGISTREMENT
		req3:='SELECT '|| nom_id ||' FROM '|| nom_table ||' WHERE  pere ='||numero1||' '||cond ||';';
		RAISE NOTICE 'req3=%',req3;
	
		EXECUTE req3 INTO id;
		
		FOR rec1 IN		
			EXECUTE req1
		LOOP
			IF rec1.pere IS NULL THEN
				p1:=' NULL';
			ELSE
				p1:=rec1.pere;
			END IF;

			FOR rec2 IN
				EXECUTE req2
			LOOP
				IF rec2.pere IS NULL THEN
					p2:=' NULL';
				ELSE
					p2:=rec2.pere;
				END IF;	


				--celui qui a B pour pere reçoit A
				req1U:= 'UPDATE '||nom_table ||' SET pere='||numero1||' WHERE  pere  =' || numero2 ||' '|| cond ||';';
				RAISE NOTICE 'req1U=%',req1U;
				EXECUTE req1U;

				--celui qui a A pour pere reçoit B (cad id reçoit B )
				IF numero2!=id THEN
					req2U:= 'UPDATE '||nom_table ||' SET pere='||numero2||' WHERE '|| nom_id|| ' =' ||id ||' '|| cond ||';';
					RAISE NOTICE 'req2U=%',req2U;
					EXECUTE req2U;
				END IF;

				--A reçoit le pere de B (ou B)
				IF numero1!=p2 THEN 
					req3U:= 'UPDATE '||nom_table ||' SET pere='||p2 ||' WHERE '|| nom_id|| ' =' || numero1 ||' '|| cond ||';';
					RAISE NOTICE '1req3U=%',req3U;
					EXECUTE req3U;
				ELSE
					req3U:= 'UPDATE '||nom_table ||' SET pere='||numero2||' WHERE '|| nom_id|| ' =' || numero1 ||' '|| cond ||';';
					RAISE NOTICE '2req3U=%',req3U;
					EXECUTE req3U;
				END IF;
		
				--B reçoit le pere de A (ou A)
				IF numero2!=p1 THEN 
					req4U:= 'UPDATE '||nom_table ||' SET pere='||p1||' WHERE '|| nom_id|| ' =' || numero2 ||' '|| cond ||';';
					RAISE NOTICE '1req4U=%',req4U;
					EXECUTE req4U;
				ELSE
					req4U:= 'UPDATE '||nom_table ||' SET pere='||numero1||' WHERE '|| nom_id|| ' =' || numero2 ||' '|| cond ||';';
					RAISE NOTICE '2req4U=%',req4U;
					EXECUTE req4U;
				END IF;


				-- OBTIENT LE NOMBRE DE LIGNES UPDATEE POUR LE PREMIER NUMERO
				--GET DIAGNOSTICS nb1 = ROW_COUNT;
		
				-- OBTIENT LE NOMBRE DE LIGNES UPDATEE  POUR LE DEUXIEME NUMERO
				--GET DIAGNOSTICS nb2= ROW_COUNT;
				--IF ( (nb1>0)AND( nb2>0) )THEN
					inverse:=TRUE;
				--END IF;
			END LOOP;
		END LOOP;
	
	ELSE
			RAISE EXCEPTION 'Les numeros des elements ÃÂ  inverser ne peuvent etre NULL';
	END IF;
	

	--RETOURNE TRUE SI AU MOINS 2*1 LIGNE A ETE UPDATEE
	RETURN inverse;
END;$_$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_gen_invert_elements(character varying, character varying, integer, integer, text) OWNER TO postgres;

--
-- TOC entry 7360 (class 0 OID 0)
-- Dependencies: 912
-- Name: FUNCTION af_gen_invert_elements(character varying, character varying, integer, integer, text); Type: COMMENT; Schema: contraintes; Owner: postgres
--

COMMENT ON FUNCTION af_gen_invert_elements(character varying, character varying, integer, integer, text) IS 'Fonction gÃ©nÃ©rÃ©ique pour inverser deux elements dans une table avec une notion de parentalitÃ©.

Param1:
nom de la table

Param2:
Nom du champ liÃ© au pere (id)

Param3:
Numero du premier element Ã  inverser

Param4:
Numero du second element Ã  inverser

Param5:
Condition de selection d''une ligne

Exemple d''execution:
select contraintes.af_gen_invert_elements(varchar ''contraintes.parcours_etapes'', varchar ''etape'' ,2, 9 ,text ''AND parcours=1'');

Retourne TRUE si l''invertion s''est bien passÃ©e.';


--
-- TOC entry 1831 (class 1255 OID 2595694)
-- Dependencies: 2983 5
-- Name: af_gen_set_element(character varying, character varying, integer, integer, text, text, text); Type: FUNCTION; Schema: contraintes; Owner: postgres
--

CREATE FUNCTION af_gen_set_element(character varying, character varying, integer, integer, text, text, text) RETURNS boolean
    AS $_$DECLARE
	--permet de stocker le resultat de la requete
	rec1 contraintes.parents;
	rec1_pere varchar;
	--permet de stocker le resultat de la fonction appelÃÂ©e recursivement
	rec_tmp contraintes.parents;
	-- variable dans laquelle on stock la chaine de la 1ere requete pour sa contruction
	req1 text;
	-- variable dans laquelle on stock la chaine de la 2eme requete pour sa contruction
	req2 text;
	-- variable dans laquelle on stock la chaine de la 3eme requete pour sa contruction
	req3 text;
	--1er parametre : nom de la table sur laquelle on fait la requete
	nom_table ALIAS FOR  $1;
	--2eme parametre :nom du champ liÃÂ© au champ pÃÅ¡re ( le champ id )
	nom_id ALIAS FOR $2;
	--numero de l'enregistrement pour lequel on veut inserer avant
	indice ALIAS FOR $3;
	--numero de l'enregistrement ÃÂ  inserer
	nouveau ALIAS FOR $4;
	--chaine des champs supplÃÂ©mÃÂ©ntaires pour l'insertion
	champs ALIAS FOR  $5;
	--chaine des valeurs des champs pour l'insertion
	champs_values ALIAS FOR  $6;
	--condition de selection d'une ligne pour SELECT et UPDATE
	cond ALIAS FOR  $7;
	--boolÃÂ©en pour savoir si une insertion ÃÂ  eut lieu
	insere boolean;
	--nombre de lignes inserees
	nb int4 :=0;
BEGIN
	--initialisation
	insere:=FALSE;

	--SI ON INSERE AU DEBUT OU AU MILIEU
	--raise notice 'on insere avant %=%',nom_id, indice;
	IF (indice IS NOT NULL) THEN
		--ON RECUPERE LE PERE DE LA LIGNE OU L'ON INSERE AVANT
		req1:='SELECT '|| nom_id ||' AS id, pere, NULL FROM '|| nom_table ||' WHERE '|| nom_id ;
		IF (indice IS NULL) THEN
			req1:=req1 ||' IS NULL' ;
		ELSE
			req1:=req1 ||' =' || indice ;
		END IF;
		req1:=req1 ||' '|| cond ||';';
	--SI ON INSERE A LA FIN
	ELSE
		req1:='select pere, id, ind from contraintes.af_gen_get_last_element(varchar '''|| nom_table ||''', varchar '''|| nom_id ||'''  ,text '''||cond||''');';
	END IF; 
	--chaque ligne du resultat est stockÃÂ©e temporairement dans rec
	raise notice 'req1=%',req1;
	FOR rec1 IN 
		--execution de la requete construite
		EXECUTE req1
	--pour chaque ligne de resultat (rec)
	LOOP
		nb:= nb+1;
		IF rec1.pere IS NULL THEN
			rec1_pere := 'NULL';
		ELSE
			rec1_pere :=rec1.pere ;
		END IF;
		--ON INSERE LE NOUVEL ELEMENT
		req2:='INSERT INTO  '||nom_table||' ( ' || nom_id || ', pere '|| champs ||')  VALUES ( '|| nouveau  ||', '|| rec1_pere  || champs_values  ||') ;';		
		raise notice 'req2a=% ', req2;
		EXECUTE req2;
		-- OBTIENT LE NOMBRE DE LIGNES INSEREES
		--GET DIAGNOSTICS nb := ROW_COUNT;
		IF  nb>0 THEN
			--raise notice 'insere';
			insere:=TRUE;
		END IF;
	END LOOP;
	
	IF (nb = 0) AND (insere IS FALSE) THEN
		req2:='INSERT INTO  '||nom_table||' ( ' || nom_id || ', pere '|| champs ||')  VALUES ( '|| nouveau  ||', NULL '|| champs_values  ||') ;';		
		raise notice 'req2b=% ', req2;
		EXECUTE req2;
		RETURN FOUND;
	END IF;
	--UPDATE DES LIGNES POUR LEQUELLES IL FAUT CHANGER LE PERE
	req3:= 'UPDATE '||nom_table ||' SET pere='||nouveau ||' WHERE '|| nom_id ;
	IF indice IS NULL THEN
		req3:=req3 ||' IS NULL' ;
	ELSE
		req3:=req3 ||' =' || indice ;
	END IF;
	req3:=req3 ||' '|| cond ||';';
	raise notice 'req3=%',req3;
	EXECUTE req3;

	--RETOURNE TRUE SI AU MOINS UNE LIGNE INSEREE
	RETURN insere;
END;$_$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_gen_set_element(character varying, character varying, integer, integer, text, text, text) OWNER TO postgres;

--
-- TOC entry 7362 (class 0 OID 0)
-- Dependencies: 1831
-- Name: FUNCTION af_gen_set_element(character varying, character varying, integer, integer, text, text, text); Type: COMMENT; Schema: contraintes; Owner: postgres
--

COMMENT ON FUNCTION af_gen_set_element(character varying, character varying, integer, integer, text, text, text) IS 'Fonction gÃ©nÃ©rÃ©ique pour inserer un nouvel element dans une table avec une notion de parentalitÃ© AVANT un champ spÃ©cifiÃ©.

Param1:
nom de la table

Param2:
Nom du champ liÃ© au pere (id)

Param3:
Numero de l''Ã©lÃ©ment(id) avant lequel on insere. NULL pour inserer Ã  la fin.

Param4:
Numero du nouvel Ã©lÃ©ment

Param5:
champs suplÃ©mentaires pour l''insertion.

Param6:
valeurs des champs supplÃ©mentaires pour l''insertion 

Param7:
Condition de selection d''une ligne pour l''update

Exemple d''execution:
select contraintes.af_gen_insert_element(varchar ''contraintes.parcours_etapes'', varchar ''etape'' , 5, 9 , varchar '', parcours'',varchar '',1'',text ''AND parcours=1'');

Retourne TRUE si l''insertion c''est bien passÃ©e.';


--
-- TOC entry 1832 (class 1255 OID 2595695)
-- Dependencies: 2983 5
-- Name: af_get_alerte(integer); Type: FUNCTION; Schema: contraintes; Owner: pgsql
--

CREATE FUNCTION af_get_alerte(integer) RETURNS record
    AS $_$-- $1 : numero alerte
declare
rec record;
begin
    select into rec id,libelle,formation,date,jours,texte from contraintes.alerte where id=$1;
    return rec;
end;$_$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_get_alerte(integer) OWNER TO pgsql;

--
-- TOC entry 7364 (class 0 OID 0)
-- Dependencies: 1832
-- Name: FUNCTION af_get_alerte(integer); Type: COMMENT; Schema: contraintes; Owner: pgsql
--

COMMENT ON FUNCTION af_get_alerte(integer) IS 'retourne les infos d''une alerte';


--
-- TOC entry 1833 (class 1255 OID 2595696)
-- Dependencies: 2983 5
-- Name: af_get_alerte_periode_max(integer, date); Type: FUNCTION; Schema: contraintes; Owner: pgsql
--

CREATE FUNCTION af_get_alerte_periode_max(integer, date) RETURNS integer
    AS $_$-- $1 : numero formation
-- $2 : date
declare
my_date date;
periode int4;

begin
    -- recup la date suivante
    select into my_date min(date) from contraintes.alerte 
    where date>$2 and formation=$1;
    if my_date is not null then
	periode:=my_date - $2;
    else
	periode:=15;
    end if;
    return periode;

end;$_$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_get_alerte_periode_max(integer, date) OWNER TO pgsql;

--
-- TOC entry 7366 (class 0 OID 0)
-- Dependencies: 1833
-- Name: FUNCTION af_get_alerte_periode_max(integer, date); Type: COMMENT; Schema: contraintes; Owner: pgsql
--

COMMENT ON FUNCTION af_get_alerte_periode_max(integer, date) IS 'retourne la periode maxi pour une alerte de formation';


--
-- TOC entry 913 (class 1255 OID 2595697)
-- Dependencies: 2983 5
-- Name: af_get_alertes(); Type: FUNCTION; Schema: contraintes; Owner: pgsql
--

CREATE FUNCTION af_get_alertes() RETURNS SETOF record
    AS $$declare
rec record;
begin
    for rec in 
	select id,libelle,formation,date,jours,texte from contraintes.alerte
    loop
	return next rec;
    end loop;
end;$$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_get_alertes() OWNER TO pgsql;

--
-- TOC entry 7368 (class 0 OID 0)
-- Dependencies: 913
-- Name: FUNCTION af_get_alertes(); Type: COMMENT; Schema: contraintes; Owner: pgsql
--

COMMENT ON FUNCTION af_get_alertes() IS 'retourne les alertes de la plateforme';


--
-- TOC entry 914 (class 1255 OID 2595698)
-- Dependencies: 2983 5
-- Name: af_get_alertes_liees(integer); Type: FUNCTION; Schema: contraintes; Owner: pgsql
--

CREATE FUNCTION af_get_alertes_liees(integer) RETURNS SETOF record
    AS $_$-- $1 : individu
declare
rec record;
begin
    if contraintes.fw_is_root($1) then
    for rec in 
	select id,libelle,formation,date,jours,texte from contraintes.alerte where formation is not null
    loop
	return next rec;
    end loop;
    else
    for rec in 
	select id,libelle,a.formation,date,jours,texte from contraintes.alerte a,contraintes.formation_participants fp 
	where a.formation is not null and a.formation=fp.formation and fp.formateur=$1 
    loop
	return next rec;
    end loop;
    end if;
    return;
end;$_$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_get_alertes_liees(integer) OWNER TO pgsql;

--
-- TOC entry 7370 (class 0 OID 0)
-- Dependencies: 914
-- Name: FUNCTION af_get_alertes_liees(integer); Type: COMMENT; Schema: contraintes; Owner: pgsql
--

COMMENT ON FUNCTION af_get_alertes_liees(integer) IS 'retourne les alertes de la plateforme qui sont liees à une formation pour le root ou le formateur';


--
-- TOC entry 915 (class 1255 OID 2595699)
-- Dependencies: 2983 5
-- Name: af_get_alertes_non_liees(); Type: FUNCTION; Schema: contraintes; Owner: pgsql
--

CREATE FUNCTION af_get_alertes_non_liees() RETURNS SETOF record
    AS $$declare
rec record;
begin
    for rec in 
	select id,libelle,formation,date,jours,texte from contraintes.alerte where formation is null
    loop
	return next rec;
    end loop;
    return;
end;$$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_get_alertes_non_liees() OWNER TO pgsql;

--
-- TOC entry 7372 (class 0 OID 0)
-- Dependencies: 915
-- Name: FUNCTION af_get_alertes_non_liees(); Type: COMMENT; Schema: contraintes; Owner: pgsql
--

COMMENT ON FUNCTION af_get_alertes_non_liees() IS 'retourne les alertes non liees à une formation';


--
-- TOC entry 916 (class 1255 OID 2595700)
-- Dependencies: 2983 5
-- Name: af_get_all_themes(); Type: FUNCTION; Schema: contraintes; Owner: postgres
--

CREATE FUNCTION af_get_all_themes() RETURNS SETOF record
    AS $$DECLARE
rec RECORD;
BEGIN
   
	FOR rec IN
	--pour la conversion du int4 en varchar, on utilise un masque de 9999999999 car les valeurs d'un int4
	--vont de -2147483648 Ã  +2147483647, il faut ensuite supprimer les blancs du dÃ©but de la chaine du aux '9' inutiles par rapport aux
	--nombres de chiffres rÃ©els du nombre 

		SELECT id, libelle, trim(leading ' ' from (CAST(to_char(id, '9999999999') AS varchar))) FROM contraintes.theme ORDER BY libelle
	LOOP
		RETURN NEXT rec;
	END LOOP;
    
	RETURN;
END;$$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_get_all_themes() OWNER TO postgres;

--
-- TOC entry 917 (class 1255 OID 2595701)
-- Dependencies: 2983 5
-- Name: af_get_bareme(integer); Type: FUNCTION; Schema: contraintes; Owner: pgsql
--

CREATE FUNCTION af_get_bareme(integer) RETURNS record
    AS $_$DECLARE
rec RECORD;
BEGIN

	SELECT into rec * FROM contraintes.af_get_baremes() as (id int4, libelle varchar, juste int4, fausse int4, manquantes int4, toutes int4) 
	WHERE id=$1;

	RETURN rec;
END$_$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_get_bareme(integer) OWNER TO pgsql;

--
-- TOC entry 7375 (class 0 OID 0)
-- Dependencies: 917
-- Name: FUNCTION af_get_bareme(integer); Type: COMMENT; Schema: contraintes; Owner: pgsql
--

COMMENT ON FUNCTION af_get_bareme(integer) IS 'Obtenir les informations d''un bareme.';


--
-- TOC entry 918 (class 1255 OID 2595702)
-- Dependencies: 2983 5
-- Name: af_get_baremes(); Type: FUNCTION; Schema: contraintes; Owner: pgsql
--

CREATE FUNCTION af_get_baremes() RETURNS SETOF record
    AS $$DECLARE
rec record;
BEGIN
	FOR  rec IN
		SELECT * FROM contraintes.bareme
	LOOP
		RETURN NEXT rec;
	END LOOP;

	RETURN;
END;$$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_get_baremes() OWNER TO pgsql;

--
-- TOC entry 919 (class 1255 OID 2595703)
-- Dependencies: 2983 5
-- Name: af_get_capacite(integer); Type: FUNCTION; Schema: contraintes; Owner: pgsql
--

CREATE FUNCTION af_get_capacite(integer) RETURNS record
    AS $_$-- $1 : numero capacite
declare
rec record;
begin
    select into rec id,libelle from contraintes.capacite where id=$1;
    return rec;
end;$_$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_get_capacite(integer) OWNER TO pgsql;

--
-- TOC entry 7378 (class 0 OID 0)
-- Dependencies: 919
-- Name: FUNCTION af_get_capacite(integer); Type: COMMENT; Schema: contraintes; Owner: pgsql
--

COMMENT ON FUNCTION af_get_capacite(integer) IS 'retourne les infos d''une capacite';


--
-- TOC entry 920 (class 1255 OID 2595704)
-- Dependencies: 2983 5
-- Name: af_get_capacite_titre(integer); Type: FUNCTION; Schema: contraintes; Owner: pgsql
--

CREATE FUNCTION af_get_capacite_titre(integer) RETURNS record
    AS $_$-- $1 : numro capacite_titre
declare
rec record;
begin
    select into rec id,libelle from contraintes.capacite_titre where id=$1;
    return rec;
end;$_$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_get_capacite_titre(integer) OWNER TO pgsql;

--
-- TOC entry 7380 (class 0 OID 0)
-- Dependencies: 920
-- Name: FUNCTION af_get_capacite_titre(integer); Type: COMMENT; Schema: contraintes; Owner: pgsql
--

COMMENT ON FUNCTION af_get_capacite_titre(integer) IS 'retourne les infos d''un titre de capacite';


--
-- TOC entry 921 (class 1255 OID 2595705)
-- Dependencies: 2983 5
-- Name: af_get_capacite_titre_capacite_themes(integer); Type: FUNCTION; Schema: contraintes; Owner: pgsql
--

CREATE FUNCTION af_get_capacite_titre_capacite_themes(integer) RETURNS SETOF record
    AS $_$-- $1 : individu
declare
rec record;
begin
    if contraintes.fw_is_root($1) then
    for rec in 
	select distinct t.id,t.libelle from
	(contraintes.theme t
	left outer join
	--(contraintes.af_get_categorie_themes(11) as (ct_id int4,ct_libelle varchar)
	contraintes.categorie_capacite_titre cct
	on t.id=cct.theme
	left outer join 
	contraintes.capacite_titre_capacites ctc
	on ctc.capacite_titre=cct.id)
	where cct.theme is not null and ctc.capacite_titre is not null 
	
	
	
     loop
	return next rec;
     end loop;
    else
    for rec in 
	select distinct t.id,t.libelle from
	(contraintes.theme t
	left outer join
	--(contraintes.af_get_categorie_themes(11) as (ct_id int4,ct_libelle varchar)
	contraintes.categorie_capacite_titre cct
	on( t.id=cct.theme and ( t.individu=$1 OR t.individu IS NULL) )
 
	left outer join 
	contraintes.capacite_titre_capacites ctc
	on ctc.capacite_titre=cct.id)
	where cct.theme is not null and ctc.capacite_titre is not null 
	
	
	
     loop
	return next rec;
     end loop;
    end if;
     return;
end;$_$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_get_capacite_titre_capacite_themes(integer) OWNER TO pgsql;

--
-- TOC entry 7382 (class 0 OID 0)
-- Dependencies: 921
-- Name: FUNCTION af_get_capacite_titre_capacite_themes(integer); Type: COMMENT; Schema: contraintes; Owner: pgsql
--

COMMENT ON FUNCTION af_get_capacite_titre_capacite_themes(integer) IS 'retourne les themes des couples capacite_titre / capacite pour un un individu';


--
-- TOC entry 922 (class 1255 OID 2595706)
-- Dependencies: 2983 5
-- Name: af_get_capacite_titre_capacites(integer); Type: FUNCTION; Schema: contraintes; Owner: pgsql
--

CREATE FUNCTION af_get_capacite_titre_capacites(integer) RETURNS SETOF record
    AS $_$-- $1 : numero capacite_titre
declare
rec record;
begin
    for rec in 
	select c.id,c.libelle,ctc.capacite_titre from contraintes.capacite c,contraintes.capacite_titre_capacites ctc
	where ctc.capacite_titre=$1 and c.id=ctc.capacite
    loop
	return next rec;
    end loop;
    return;
end$_$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_get_capacite_titre_capacites(integer) OWNER TO pgsql;

--
-- TOC entry 7384 (class 0 OID 0)
-- Dependencies: 922
-- Name: FUNCTION af_get_capacite_titre_capacites(integer); Type: COMMENT; Schema: contraintes; Owner: pgsql
--

COMMENT ON FUNCTION af_get_capacite_titre_capacites(integer) IS 'retourne les capacites pour un titre de capacite';


--
-- TOC entry 923 (class 1255 OID 2595707)
-- Dependencies: 2983 5
-- Name: af_get_capacite_titre_capacites_disponibles(integer, integer); Type: FUNCTION; Schema: contraintes; Owner: pgsql
--

CREATE FUNCTION af_get_capacite_titre_capacites_disponibles(integer, integer) RETURNS SETOF record
    AS $_$-- $1 : numero capacite_titre
-- $2 : numero theme
declare
rec record;
begin
    for rec in 
	
	select distinct c.id,c.libelle,$1 as capacite_titre from
	(contraintes.capacite c
	left outer join
	contraintes.capacite_titre_capacites ctc
	on c.id=ctc.capacite and ctc.capacite_titre=$1),

	contraintes.af_get_categorie_elements_theme(10,$2) et 
	
	
	where 
	ctc.capacite is null and 
	c.id=et
	
	
    loop
	return next rec;
    end loop;
    return;
end;$_$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_get_capacite_titre_capacites_disponibles(integer, integer) OWNER TO pgsql;

--
-- TOC entry 7386 (class 0 OID 0)
-- Dependencies: 923
-- Name: FUNCTION af_get_capacite_titre_capacites_disponibles(integer, integer); Type: COMMENT; Schema: contraintes; Owner: pgsql
--

COMMENT ON FUNCTION af_get_capacite_titre_capacites_disponibles(integer, integer) IS 'retourne les capacites disponible pour un titre de capacite et un theme';


--
-- TOC entry 924 (class 1255 OID 2595708)
-- Dependencies: 2983 5
-- Name: af_get_categorie(integer); Type: FUNCTION; Schema: contraintes; Owner: postgres
--

CREATE FUNCTION af_get_categorie(integer) RETURNS record
    AS $_$DECLARE
rec RECORD;

BEGIN
	SELECT INTO rec * FROM contraintes.af_get_categories() AS ( id int4 ,  libelle varchar, table_cible varchar,  gestionnaire_contenu bool , code varchar)
	WHERE id=$1;

	RETURN rec;
END$_$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_get_categorie(integer) OWNER TO postgres;

--
-- TOC entry 7388 (class 0 OID 0)
-- Dependencies: 924
-- Name: FUNCTION af_get_categorie(integer); Type: COMMENT; Schema: contraintes; Owner: postgres
--

COMMENT ON FUNCTION af_get_categorie(integer) IS 'Obtenir les informations d''une categorie.';


--
-- TOC entry 925 (class 1255 OID 2595709)
-- Dependencies: 2983 5
-- Name: af_get_categorie_elements(integer); Type: FUNCTION; Schema: contraintes; Owner: pgsql
--

CREATE FUNCTION af_get_categorie_elements(integer) RETURNS SETOF record
    AS $_$declare
rec record;
begin
	for rec in
	select id,theme,categorie from contraintes.theme_categories
	where categorie=$1
	loop
	return next rec;
	end loop;
	return;

end;$_$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_get_categorie_elements(integer) OWNER TO pgsql;

--
-- TOC entry 7390 (class 0 OID 0)
-- Dependencies: 925
-- Name: FUNCTION af_get_categorie_elements(integer); Type: COMMENT; Schema: contraintes; Owner: pgsql
--

COMMENT ON FUNCTION af_get_categorie_elements(integer) IS 'retourne les elements d''une categorie';


--
-- TOC entry 926 (class 1255 OID 2595710)
-- Dependencies: 2983 5
-- Name: af_get_categorie_elements_all_theme(integer, integer); Type: FUNCTION; Schema: contraintes; Owner: postgres
--

CREATE FUNCTION af_get_categorie_elements_all_theme(integer, integer) RETURNS SETOF integer
    AS $_$DECLARE
--$1 categorie
--$2 theme
rec RECORD;
req varchar;
table_cible varchar;
BEGIN

	--recupere la table correspondant Ã  la categorie
	SELECT INTO table_cible  C_table_cible FROM contraintes.af_get_categorie($1)AS ( C_id int4 ,  C_libelle varchar, C_table_cible varchar,  C_gestionnaire_contenu bool, code varchar);

	req:='SELECT TC.id FROM contraintes.theme_categories TC, contraintes.categorie_'||table_cible||' CI
		WHERE TC.categorie='||$1||'
		AND TC.theme='||$2||'
		AND CI.id=TC.id';
	--RAISE NOTICE 'req: %',req;
	
	FOR rec IN
		EXECUTE req
	LOOP
		RETURN NEXT rec.id; 
	END LOOP;

	RETURN;
		 
END$_$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_get_categorie_elements_all_theme(integer, integer) OWNER TO postgres;

--
-- TOC entry 7392 (class 0 OID 0)
-- Dependencies: 926
-- Name: FUNCTION af_get_categorie_elements_all_theme(integer, integer); Type: COMMENT; Schema: contraintes; Owner: postgres
--

COMMENT ON FUNCTION af_get_categorie_elements_all_theme(integer, integer) IS 'Obtenir tous les éléments d''un theme pour une categorie, y compris les fichiers non connectés.

Il faur donc utiliser:
af_get_categorie_elements_theme
dans la plate-forme';


--
-- TOC entry 927 (class 1255 OID 2595711)
-- Dependencies: 2983 5
-- Name: af_get_categorie_elements_theme(integer, integer); Type: FUNCTION; Schema: contraintes; Owner: postgres
--

CREATE FUNCTION af_get_categorie_elements_theme(integer, integer) RETURNS SETOF integer
    AS $_$DECLARE
--$1 categorie
--$2 theme
rec RECORD;
req varchar;
table_cible varchar;
BEGIN

	--recupere la table correspondant Ã  la categorie
	SELECT INTO table_cible  C_table_cible FROM contraintes.af_get_categorie($1)AS ( C_id int4 ,  C_libelle varchar, C_table_cible varchar,  C_gestionnaire_contenu bool, code varchar);

	req:='SELECT distinct TC.id FROM contraintes.theme_categories TC, contraintes.af_get_theme_elements('||$2||') AS (T_id int4,T_categorie int4), contraintes.categorie_'||table_cible||' CI
		WHERE TC.categorie='||$1||'
		AND TC.theme='||$2||'
		AND CI.id=TC.id
		AND T_id=TC.id';
	--RAISE NOTICE 'req: %',req;
	
	FOR rec IN
		EXECUTE req
	LOOP
		RETURN NEXT rec.id; 
	END LOOP;

	RETURN;
		 
END$_$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_get_categorie_elements_theme(integer, integer) OWNER TO postgres;

--
-- TOC entry 7394 (class 0 OID 0)
-- Dependencies: 927
-- Name: FUNCTION af_get_categorie_elements_theme(integer, integer); Type: COMMENT; Schema: contraintes; Owner: postgres
--

COMMENT ON FUNCTION af_get_categorie_elements_theme(integer, integer) IS 'Obtenir tous les éléments d''un theme pour une categorie qui sont utilisables dans la plate-forme. (les fichiers non-connectés n''aparaissent pas).';


--
-- TOC entry 928 (class 1255 OID 2595712)
-- Dependencies: 2983 5
-- Name: af_get_categorie_fichiers_all_theme(integer, integer); Type: FUNCTION; Schema: contraintes; Owner: postgres
--

CREATE FUNCTION af_get_categorie_fichiers_all_theme(integer, integer) RETURNS SETOF record
    AS $_$DECLARE
--$1 categorie
--$2 theme
rec RECORD;
req varchar;
type_categorie int4;
BEGIN

	--recupere le type de fichier correspondant Ã  la categorie
	SELECT INTO type_categorie id FROM contraintes.fichier_type
	WHERE categorie = $1;

	IF type_categorie IS NULL THEN
		RAISE EXCEPTION 'La categorie % n''a pas de type de fichier associÃ©',$1;
	END IF;


		--req:='SELECT id, libelle,"type",connecte FROM contraintes.af_get_fichiers_type('||type_categorie||') AS (id int4, libelle varchar, "type" int4, connecte bool),
		--	contraintes.af_get_categorie_elements_all_theme('||$1||','||$2||') E_id
		--	WHERE id=E_id ORDER BY libelle';
	
	FOR rec IN
		SELECT id, libelle,"type",connecte FROM contraintes.af_get_fichiers_type(type_categorie) AS (id int4, libelle varchar, "type" int4, connecte bool),
		contraintes.af_get_categorie_elements_all_theme($1,$2) E_id
		WHERE id=E_id ORDER BY libelle
	LOOP
		RETURN NEXT rec;
	END LOOP;

END$_$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_get_categorie_fichiers_all_theme(integer, integer) OWNER TO postgres;

--
-- TOC entry 7396 (class 0 OID 0)
-- Dependencies: 928
-- Name: FUNCTION af_get_categorie_fichiers_all_theme(integer, integer); Type: COMMENT; Schema: contraintes; Owner: postgres
--

COMMENT ON FUNCTION af_get_categorie_fichiers_all_theme(integer, integer) IS 'Obtenir tous les fichiers d''un theme pour une categorie.';


--
-- TOC entry 1834 (class 1255 OID 2595713)
-- Dependencies: 2983 5
-- Name: af_get_categorie_fichiers_scenario_theme(integer, integer); Type: FUNCTION; Schema: contraintes; Owner: pgsql
--

CREATE FUNCTION af_get_categorie_fichiers_scenario_theme(integer, integer) RETURNS SETOF record
    AS $_$DECLARE
--$1 categorie
--$2 theme
rec RECORD;
req varchar;
type_categorie int4;
BEGIN

	--recupere le type de fichier correspondant Ã  la categorie
	SELECT INTO type_categorie id FROM contraintes.fichier_type
	WHERE categorie = $1;

	IF type_categorie IS NULL THEN
		RAISE EXCEPTION 'La categorie % n''a pas de type de fichier associÃ©',$1;
	END IF;


		--req:='SELECT id, libelle,"type",connecte FROM contraintes.af_get_fichiers_type('||type_categorie||') AS (id int4, libelle varchar, "type" int4, connecte bool),
		--	contraintes.af_get_categorie_elements_all_theme('||$1||','||$2||') E_id
		--	WHERE id=E_id ORDER BY libelle';
	
	FOR rec IN
		SELECT id, libelle,"type",connecte FROM contraintes.af_get_fichiers_type(type_categorie) AS (id int4, libelle varchar, "type" int4, connecte bool),
		contraintes.af_get_categorie_elements_theme($1,$2) E_id
		WHERE id=E_id ORDER BY libelle
	LOOP
		RETURN NEXT rec;
	END LOOP;
	RETURN;
END$_$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_get_categorie_fichiers_scenario_theme(integer, integer) OWNER TO pgsql;

--
-- TOC entry 7398 (class 0 OID 0)
-- Dependencies: 1834
-- Name: FUNCTION af_get_categorie_fichiers_scenario_theme(integer, integer); Type: COMMENT; Schema: contraintes; Owner: pgsql
--

COMMENT ON FUNCTION af_get_categorie_fichiers_scenario_theme(integer, integer) IS 'Obtenir les fichiers connectés d''un theme pour un scenario.';


--
-- TOC entry 929 (class 1255 OID 2595714)
-- Dependencies: 2983 5
-- Name: af_get_categorie_fichiers_textes_all_theme(integer, integer); Type: FUNCTION; Schema: contraintes; Owner: postgres
--

CREATE FUNCTION af_get_categorie_fichiers_textes_all_theme(integer, integer) RETURNS SETOF record
    AS $_$DECLARE
--$1 categorie
--$2 theme
rec RECORD;
req varchar;
type_categorie int4;
BEGIN

	--recupere le type de fichier correspondant Ã  la categorie
	SELECT INTO type_categorie id FROM contraintes.fichier_type
	WHERE categorie = $1;

	IF type_categorie IS NULL THEN
		RAISE EXCEPTION 'La categorie % n''a pas de type de fichier associÃ©',$1;
	END IF;

	--req:='SELECT T_id, T_libelle,"type",connecte, T.libelle, T.adresse, T.description, T.mise_en_forme, TO_CHAR(T.date_modification,''DD/MM/YYYY'') FROM contraintes.af_get_fichiers_type('||type_categorie||') AS (T_id int4, T_libelle varchar, "type" int4, connecte bool),
	--		contraintes.af_get_categorie_elements_all_theme('||$1||','||$2||') E_id, contraintes.fichier_texte T
	--		WHERE T_id=E_id
	--		AND T_id=T.id  ORDER BY T_libelle';
	

	RAISE NOTICE 'req: %',req;

	FOR rec IN
		SELECT T_id, T_libelle,"type",connecte, T.libelle, T.adresse, T.description, T.mise_en_forme, TO_CHAR(T.date_modification,'DD/MM/YYYY') FROM contraintes.af_get_fichiers_type(type_categorie) AS (T_id int4, T_libelle varchar, "type" int4, connecte bool),
		contraintes.af_get_categorie_elements_all_theme($1,$2) E_id, contraintes.fichier_ressource_texte T
		WHERE T_id=E_id
		AND T_id=T.id  ORDER BY T_libelle
	
	LOOP
		RETURN NEXT rec;
	END LOOP;

END$_$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_get_categorie_fichiers_textes_all_theme(integer, integer) OWNER TO postgres;

--
-- TOC entry 7400 (class 0 OID 0)
-- Dependencies: 929
-- Name: FUNCTION af_get_categorie_fichiers_textes_all_theme(integer, integer); Type: COMMENT; Schema: contraintes; Owner: postgres
--

COMMENT ON FUNCTION af_get_categorie_fichiers_textes_all_theme(integer, integer) IS 'Obtenir tous les fichiers textes d''un theme pour une categorie.';


--
-- TOC entry 930 (class 1255 OID 2595715)
-- Dependencies: 2983 5
-- Name: af_get_categorie_fichiers_textes_theme(integer, integer); Type: FUNCTION; Schema: contraintes; Owner: postgres
--

CREATE FUNCTION af_get_categorie_fichiers_textes_theme(integer, integer) RETURNS SETOF record
    AS $_$DECLARE
--$1 categorie
--$2 theme
rec RECORD;
req varchar;
type_categorie int4;
BEGIN

	--recupere le type de fichier correspondant Ã  la categorie
	SELECT INTO type_categorie id FROM contraintes.fichier_type
	WHERE categorie = $1;

	IF type_categorie IS NULL THEN
		RAISE EXCEPTION 'La categorie % n''a pas de type de fichier associÃ©',$1;
	END IF;

	--req:='SELECT T_id, T_libelle,"type",connecte, T.libelle, T.adresse, T.description, T.mise_en_forme, TO_CHAR(T.date_modification,''DD/MM/YYYY'') FROM contraintes.af_get_fichiers_type('||type_categorie||') AS (T_id int4, T_libelle varchar, "type" int4, connecte bool),
	--		contraintes.af_get_categorie_elements_all_theme('||$1||','||$2||') E_id, contraintes.fichier_texte T
	--		WHERE T_id=E_id
	--		AND T_id=T.id  ORDER BY T_libelle';
	

	RAISE NOTICE 'req: %',req;

	FOR rec IN
		SELECT T_id, T_libelle,"type",connecte, T.libelle, T.adresse, T.description, T.mise_en_forme, TO_CHAR(T.date_modification,'DD/MM/YYYY') FROM contraintes.af_get_fichiers_type(type_categorie) AS (T_id int4, T_libelle varchar, "type" int4, connecte bool),
		contraintes.af_get_categorie_elements_theme($1,$2) E_id, contraintes.fichier_ressource_texte T
		WHERE T_id=E_id
		AND T_id=T.id  ORDER BY T_libelle
	
	LOOP
		RETURN NEXT rec;
	END LOOP;

END$_$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_get_categorie_fichiers_textes_theme(integer, integer) OWNER TO postgres;

--
-- TOC entry 7402 (class 0 OID 0)
-- Dependencies: 930
-- Name: FUNCTION af_get_categorie_fichiers_textes_theme(integer, integer); Type: COMMENT; Schema: contraintes; Owner: postgres
--

COMMENT ON FUNCTION af_get_categorie_fichiers_textes_theme(integer, integer) IS 'Obtenir les fichiers textes connectés d''un theme pour une categorie.';


--
-- TOC entry 931 (class 1255 OID 2595716)
-- Dependencies: 2983 5
-- Name: af_get_categorie_fichiers_theme(integer, integer); Type: FUNCTION; Schema: contraintes; Owner: postgres
--

CREATE FUNCTION af_get_categorie_fichiers_theme(integer, integer) RETURNS SETOF record
    AS $_$DECLARE
--$1 categorie
--$2 theme
rec RECORD;
req varchar;
type_categorie int4;
BEGIN

	--recupere le type de fichier correspondant Ã  la categorie
	SELECT INTO type_categorie id FROM contraintes.fichier_type
	WHERE categorie = $1;

	IF type_categorie IS NULL THEN
		RAISE EXCEPTION 'La categorie % n''a pas de type de fichier associÃ©',$1;
	END IF;


		--req:='SELECT id, libelle,"type",connecte FROM contraintes.af_get_fichiers_type('||type_categorie||') AS (id int4, libelle varchar, "type" int4, connecte bool),
		--	contraintes.af_get_categorie_elements_all_theme('||$1||','||$2||') E_id
		--	WHERE id=E_id ORDER BY libelle';
	
	FOR rec IN
		SELECT id, libelle,"type",connecte FROM contraintes.af_get_fichiers_type(type_categorie) AS (id int4, libelle varchar, "type" int4, connecte bool),
		contraintes.af_get_categorie_elements_theme($1,$2) E_id
		WHERE id=E_id ORDER BY libelle
	LOOP
		RETURN NEXT rec;
	END LOOP;
	RETURN;
END$_$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_get_categorie_fichiers_theme(integer, integer) OWNER TO postgres;

--
-- TOC entry 7404 (class 0 OID 0)
-- Dependencies: 931
-- Name: FUNCTION af_get_categorie_fichiers_theme(integer, integer); Type: COMMENT; Schema: contraintes; Owner: postgres
--

COMMENT ON FUNCTION af_get_categorie_fichiers_theme(integer, integer) IS 'Obtenir les fichiers connectés d''un theme pour une categorie.';


--
-- TOC entry 932 (class 1255 OID 2595717)
-- Dependencies: 2983 5
-- Name: af_get_categorie_fichiers_themes(integer, integer, integer); Type: FUNCTION; Schema: contraintes; Owner: pgsql
--

CREATE FUNCTION af_get_categorie_fichiers_themes(integer, integer, integer) RETURNS SETOF record
    AS $_$-- $1 : numero categorie
-- $2 : theme
-- $3 : theme modele
declare
rec record;
type_categorie int4;
begin
    for rec in
	select distinct * from
	(select * from contraintes.af_get_categorie_fichiers_theme($1,$2) as (id int4,libelle varchar,type int4,connecte bool) 
	union
	select * from contraintes.af_get_categorie_fichiers_theme($1,$3) as (id int4,libelle varchar,type int4,connecte bool)) CF
    loop
	return next rec;
    end loop;
    return;
end;$_$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_get_categorie_fichiers_themes(integer, integer, integer) OWNER TO pgsql;

--
-- TOC entry 7406 (class 0 OID 0)
-- Dependencies: 932
-- Name: FUNCTION af_get_categorie_fichiers_themes(integer, integer, integer); Type: COMMENT; Schema: contraintes; Owner: pgsql
--

COMMENT ON FUNCTION af_get_categorie_fichiers_themes(integer, integer, integer) IS 'retourne les fichiers pour une categorie et deux themes';


--
-- TOC entry 933 (class 1255 OID 2595718)
-- Dependencies: 2983 5
-- Name: af_get_categorie_themes(integer, integer); Type: FUNCTION; Schema: contraintes; Owner: pgsql
--

CREATE FUNCTION af_get_categorie_themes(integer, integer) RETURNS SETOF record
    AS $_$-- $1 : categorie
-- $2 : individu
declare
rec record;
begin
    if contraintes.fw_is_root($2) then
    for rec in
	select DISTINCT t.id,t.libelle from contraintes.theme_categories c,contraintes.theme t 
	where c.categorie=$1
	and c.theme=t.id

    loop
	return next rec;
    end loop;
    else
    for rec in
	select DISTINCT t.id,t.libelle from contraintes.theme_categories c,contraintes.theme t 
	where c.categorie=$1
	and c.theme=t.id and (t.individu=$2 OR t.individu IS NULL)

    loop
	return next rec;
    end loop;
    end if;
    return;

end$_$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_get_categorie_themes(integer, integer) OWNER TO pgsql;

--
-- TOC entry 7408 (class 0 OID 0)
-- Dependencies: 933
-- Name: FUNCTION af_get_categorie_themes(integer, integer); Type: COMMENT; Schema: contraintes; Owner: pgsql
--

COMMENT ON FUNCTION af_get_categorie_themes(integer, integer) IS 'retourne les themes d''une categorie
pour un individu';


--
-- TOC entry 934 (class 1255 OID 2595719)
-- Dependencies: 2983 5
-- Name: af_get_categorie_themes_element_infos(integer, integer); Type: FUNCTION; Schema: contraintes; Owner: pgsql
--

CREATE FUNCTION af_get_categorie_themes_element_infos(integer, integer) RETURNS SETOF record
    AS $_$DECLARE
--$1 categorie
--$2 element
rec RECORD;
BEGIN
	FOR rec IN
		SELECT T.id, T.libelle FROM contraintes.theme T, contraintes.theme_categories TC
		WHERE TC.id=$2
		AND TC.categorie=$1
		AND TC.theme=T.id
	LOOP
		RETURN NEXT rec;
	END LOOP;

	RETURN;
	
END$_$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_get_categorie_themes_element_infos(integer, integer) OWNER TO pgsql;

--
-- TOC entry 7410 (class 0 OID 0)
-- Dependencies: 934
-- Name: FUNCTION af_get_categorie_themes_element_infos(integer, integer); Type: COMMENT; Schema: contraintes; Owner: pgsql
--

COMMENT ON FUNCTION af_get_categorie_themes_element_infos(integer, integer) IS 'Obtenir les informations sur les themes d''un element pour une categorie.';


--
-- TOC entry 935 (class 1255 OID 2595720)
-- Dependencies: 2983 5
-- Name: af_get_categorie_themes_type_evaluation(integer, integer, integer); Type: FUNCTION; Schema: contraintes; Owner: pgsql
--

CREATE FUNCTION af_get_categorie_themes_type_evaluation(integer, integer, integer) RETURNS SETOF record
    AS $_$-- $1 : categorie
-- $2 : type
-- $3 : individu
declare
rec record;
begin
    
    for rec in
        select distinct ct_id,ct_libelle from contraintes.af_get_categorie_themes($1,$3) as (ct_id int4,ct_libelle varchar),
	contraintes.af_get_categorie_elements($1) as (c_id int4,c_theme int4,c_categorie int4),
	contraintes.evaluation e 
	where e.type=$2 and c_theme=ct_id 
	and e.id=c_id
    loop
	return next rec;
    end loop;
    

    return;
	
end;$_$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_get_categorie_themes_type_evaluation(integer, integer, integer) OWNER TO pgsql;

--
-- TOC entry 7412 (class 0 OID 0)
-- Dependencies: 935
-- Name: FUNCTION af_get_categorie_themes_type_evaluation(integer, integer, integer); Type: COMMENT; Schema: contraintes; Owner: pgsql
--

COMMENT ON FUNCTION af_get_categorie_themes_type_evaluation(integer, integer, integer) IS 'retourne les themes pour une categorie et un type d''evaluation et un individu';


--
-- TOC entry 936 (class 1255 OID 2595721)
-- Dependencies: 2983 5
-- Name: af_get_categories(); Type: FUNCTION; Schema: contraintes; Owner: postgres
--

CREATE FUNCTION af_get_categories() RETURNS SETOF record
    AS $$DECLARE
rec RECORD;
BEGIN
	FOR rec IN
		SELECT * FROM contraintes.categorie ORDER BY gestionnaire_contenu, libelle
	LOOP
		RETURN NEXT rec;
	END LOOP;

	RETURN;
END;$$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_get_categories() OWNER TO postgres;

--
-- TOC entry 7414 (class 0 OID 0)
-- Dependencies: 936
-- Name: FUNCTION af_get_categories(); Type: COMMENT; Schema: contraintes; Owner: postgres
--

COMMENT ON FUNCTION af_get_categories() IS 'Obtenir toutes les categories de la plate-forme';


--
-- TOC entry 937 (class 1255 OID 2595722)
-- Dependencies: 2983 5
-- Name: af_get_categories(boolean); Type: FUNCTION; Schema: contraintes; Owner: postgres
--

CREATE FUNCTION af_get_categories(boolean) RETURNS SETOF record
    AS $_$DECLARE
rec RECORD;
BEGIN
	FOR rec IN
		SELECT * FROM contraintes.af_get_categories()AS (id integer, libelle varchar, table_cible varchar, gestionnaire_contenus boolean, code varchar)
		WHERE gestionnaire_contenus = $1
		ORDER BY libelle
	LOOP
		RETURN NEXT rec;
	END LOOP;

	RETURN;
END;$_$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_get_categories(boolean) OWNER TO postgres;

--
-- TOC entry 7416 (class 0 OID 0)
-- Dependencies: 937
-- Name: FUNCTION af_get_categories(boolean); Type: COMMENT; Schema: contraintes; Owner: postgres
--

COMMENT ON FUNCTION af_get_categories(boolean) IS 'Obtenir les categories de la plate-formeen fonction de gestionnaire_contenu';


--
-- TOC entry 938 (class 1255 OID 2595723)
-- Dependencies: 2983 5
-- Name: af_get_classe(integer); Type: FUNCTION; Schema: contraintes; Owner: pgsql
--

CREATE FUNCTION af_get_classe(integer) RETURNS record
    AS $_$declare
rec record;

begin
    select into rec * from 
    contraintes.af_get_classes() as(id int4,libelle varchar,pere int4,min int4,max int4) 
    where id=$1;
    return rec;
end;$_$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_get_classe(integer) OWNER TO pgsql;

--
-- TOC entry 7418 (class 0 OID 0)
-- Dependencies: 938
-- Name: FUNCTION af_get_classe(integer); Type: COMMENT; Schema: contraintes; Owner: pgsql
--

COMMENT ON FUNCTION af_get_classe(integer) IS 'retourne les infos d''une classe';


--
-- TOC entry 939 (class 1255 OID 2595724)
-- Dependencies: 2983 5
-- Name: af_get_classe_droits_communs(integer, integer); Type: FUNCTION; Schema: contraintes; Owner: pgsql
--

CREATE FUNCTION af_get_classe_droits_communs(integer, integer) RETURNS SETOF record
    AS $_$-- $1 : numero classe
-- $2 : nombre d'individu ds la classe
declare
rec record;
begin
    for rec in
	select droit from contraintes.individu_droits where classe=$1 
	group by droit having count(*)=$2
    loop
	return next rec;
    end loop;
    return;
end;$_$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_get_classe_droits_communs(integer, integer) OWNER TO pgsql;

--
-- TOC entry 7420 (class 0 OID 0)
-- Dependencies: 939
-- Name: FUNCTION af_get_classe_droits_communs(integer, integer); Type: COMMENT; Schema: contraintes; Owner: pgsql
--

COMMENT ON FUNCTION af_get_classe_droits_communs(integer, integer) IS 'retourne les droits communs pour les individus d''une classe';


--
-- TOC entry 940 (class 1255 OID 2595725)
-- Dependencies: 2983 5
-- Name: af_get_classe_droits_non_affilies(integer); Type: FUNCTION; Schema: contraintes; Owner: pgsql
--

CREATE FUNCTION af_get_classe_droits_non_affilies(integer) RETURNS SETOF record
    AS $_$-- $1 : numero classe
declare
rec record;
begin
    for rec in 
	select distinct d.id from contraintes.droit d
	left outer join
	contraintes.individu_droits id  
	on d.id=id.droit and id.classe=$1 and d.type=2
	where  id.droit is null  
    loop
	return next rec;
    end loop;
    return;
end;$_$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_get_classe_droits_non_affilies(integer) OWNER TO pgsql;

--
-- TOC entry 7422 (class 0 OID 0)
-- Dependencies: 940
-- Name: FUNCTION af_get_classe_droits_non_affilies(integer); Type: COMMENT; Schema: contraintes; Owner: pgsql
--

COMMENT ON FUNCTION af_get_classe_droits_non_affilies(integer) IS 'retourne les droits non affilies pour une classe (droit que personne ne possede)';


--
-- TOC entry 941 (class 1255 OID 2595726)
-- Dependencies: 2983 5
-- Name: af_get_classe_evenements(integer, date); Type: FUNCTION; Schema: contraintes; Owner: pgsql
--

CREATE FUNCTION af_get_classe_evenements(integer, date) RETURNS SETOF record
    AS $_$-- $1 : classe
-- $2 : date
declare
rec record;
begin
    for rec in
	select e.formation,e.libelle,e.date,e.duree,e.modalite,e.intervention,e.intervenant,e.salle 
	from contraintes.evenement e,contraintes.formation_participants fp 
	where e.formation=fp.formation and fp.classe=$1 and cast(e.date as date)=$2
    loop
	return next rec;
    end loop;
end;$_$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_get_classe_evenements(integer, date) OWNER TO pgsql;

--
-- TOC entry 7424 (class 0 OID 0)
-- Dependencies: 941
-- Name: FUNCTION af_get_classe_evenements(integer, date); Type: COMMENT; Schema: contraintes; Owner: pgsql
--

COMMENT ON FUNCTION af_get_classe_evenements(integer, date) IS 'retourne les evenements d''une classe pour un jour de formation';


--
-- TOC entry 942 (class 1255 OID 2595727)
-- Dependencies: 2983 5
-- Name: af_get_classe_fils(integer); Type: FUNCTION; Schema: contraintes; Owner: pgsql
--

CREATE FUNCTION af_get_classe_fils(integer) RETURNS SETOF record
    AS $_$-- $1 : classe
declare
rec record;
begin
    for rec in
	select * from contraintes.af_gen_get_elements('contraintes.classe','id',$1,'')
    loop
	return next rec;
    end loop;
end$_$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_get_classe_fils(integer) OWNER TO pgsql;

--
-- TOC entry 7426 (class 0 OID 0)
-- Dependencies: 942
-- Name: FUNCTION af_get_classe_fils(integer); Type: COMMENT; Schema: contraintes; Owner: pgsql
--

COMMENT ON FUNCTION af_get_classe_fils(integer) IS 'retourne tous les fils d''une classe';


--
-- TOC entry 943 (class 1255 OID 2595728)
-- Dependencies: 2983 5
-- Name: af_get_classe_formations(integer, character varying, character varying, integer, integer); Type: FUNCTION; Schema: contraintes; Owner: pgsql
--

CREATE FUNCTION af_get_classe_formations(integer, character varying, character varying, integer, integer) RETURNS SETOF record
    AS $_$-- $1 numero de la classe
-- $2 ordre pour classement ('asc' ou 'desc')
-- $3 'date_debut' ou 'libelle' (orderby)
-- $4 periode (1 : passées, 2 : présentes, 3 : futures, 0 : toutes)
-- $5 individu
declare
rec record;
begin
    if contraintes.fw_is_root($5) then    
    for rec in 
	select id,libelle,parcours,date_debut,date_fin,langue,fp.classe
	from contraintes.af_get_formations($2,$3,$4) 
	as (id int4,libelle varchar,parcours int4,date_debut date,date_fin date,langue int4,ressources_fusionnees boolean),
	contraintes.formation_participants fp 
	where fp.classe=$1 and fp.formation=id
    loop
	return next rec;
    end loop;
    else
    for rec in 
	select id,libelle,parcours,date_debut,date_fin,langue,fp.classe
	from contraintes.af_get_formations($2,$3,$4) 
	as (id int4,libelle varchar,parcours int4,date_debut date,date_fin date,langue int4,ressources_fusionnees boolean),
	contraintes.formation_participants fp 
	where fp.classe=$1 and fp.formation=id 
	--and fp.formateur=$5
    loop
	return next rec;
    end loop;	
    end if;
    
    return;

end;$_$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_get_classe_formations(integer, character varying, character varying, integer, integer) OWNER TO pgsql;

--
-- TOC entry 7428 (class 0 OID 0)
-- Dependencies: 943
-- Name: FUNCTION af_get_classe_formations(integer, character varying, character varying, integer, integer); Type: COMMENT; Schema: contraintes; Owner: pgsql
--

COMMENT ON FUNCTION af_get_classe_formations(integer, character varying, character varying, integer, integer) IS 'retourne les formations d''une classe pour le root ou formateur
';


--
-- TOC entry 1835 (class 1255 OID 2595729)
-- Dependencies: 2153 2983 5
-- Name: af_get_classe_individus(integer, integer, character varying, boolean); Type: FUNCTION; Schema: contraintes; Owner: pgsql
--

CREATE FUNCTION af_get_classe_individus(integer, integer, character varying, boolean) RETURNS SETOF organisme_type_individu
    AS $_$-- Parametres :
-- 1. Identifiant de la classe
-- 2. Type : 0=tous, 1=formateurs & 2=stagiaires
-- 3. ASC ou DESC = affichage dans l'ordre croissant ou decroissant
-- 4. exclusif : si VRAI alors que les 'u' ou les 'f'
declare
rec record;
rec2 contraintes.organisme_type_individu;
req varchar;
begin
    
    for rec in 
	select id,nom,prenom,organisme 
	from contraintes.fw_get_individus($2,$3,$4) as (id int4,nom varchar,prenom varchar,organisme int4),contraintes.classe_individus CI 
	where CI.classe=$1 and CI.individu=id
	order by nom, prenom
    loop
	rec2.id:=rec.id;
	rec2.nom:=rec.nom;
	rec2.prenom:=rec.prenom;
	rec2.organisme:=rec.organisme;
	rec2.types:=NULL;
	return next rec2;
	--return next rec;
    end loop;
    return;
end;$_$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_get_classe_individus(integer, integer, character varying, boolean) OWNER TO pgsql;

--
-- TOC entry 7430 (class 0 OID 0)
-- Dependencies: 1835
-- Name: FUNCTION af_get_classe_individus(integer, integer, character varying, boolean); Type: COMMENT; Schema: contraintes; Owner: pgsql
--

COMMENT ON FUNCTION af_get_classe_individus(integer, integer, character varying, boolean) IS 'retourne les n°,nom prenom et tabtype des individu d''une classe';


--
-- TOC entry 944 (class 1255 OID 2595730)
-- Dependencies: 2983 5
-- Name: af_get_classe_individus_affiliables(integer); Type: FUNCTION; Schema: contraintes; Owner: pgsql
--

CREATE FUNCTION af_get_classe_individus_affiliables(integer) RETURNS SETOF record
    AS $_$declare
nb_individu int4;
org int4;
rec record;
req varchar;
begin
    -- test si la classe est vide
    perform * from contraintes.af_get_classe_individus($1,0,'asc',false) ;
    if not found then
	-- on renvoie tous les individus
	for rec in
	    select * from contraintes.fw_get_individus(0,'asc',false) as (id int4,nom varchar,prenom varchar,organisme int4)
		ORDER BY organisme, nom,prenom
	loop
	    return next rec;
	end loop;

    else
	-- on renvoie les individus qui ne sont pas affiliés à la classe
	-- et ayant un organisme communs aux individus de la classe ou (multi organisme)
	-- recup de l'organisme des individus de la classe
	--select into org * from contraintes.af_get_classe_organisme($1);
	--raise notice 'org =%',org;
	--if org is null then
	-- Modif du 06/01/08 (mutlti org correspond à null au lieu de 0)
	--if org is not null then	
	--raise notice 'org =%',org;
	    for rec in 
	    /*
	    select distinct I_id,I_nom,I_prenom,I_organisme 
	    from contraintes.fw_get_individus(0,'asc',false)  as (I_id int4,I_nom varchar,I_prenom varchar,I_organisme int4) ,
	    contraintes.af_get_classe_individus($1,0,'asc',false) CI 
	    --where I_id!=CI.id and I_organisme=org 
	    where I_organisme=org and I_id!=CI.id 
	    */

	    select distinct I_id,I_nom,I_prenom,I_organisme 
	    from contraintes.fw_get_individus(0,'asc',false)  as (I_id int4,I_nom varchar,I_prenom varchar,I_organisme int4) 
	    
	    where I_id not in (select CI.id from contraintes.af_get_classe_individus($1,0,'asc',false) CI) 
	   -- and I_organisme=org  
		ORDER BY I_organisme, I_nom,I_prenom
	    
	    

	    
	    loop
		--raise notice 'I_id=% ',rec.I_id;	
		return next rec;
	    end loop;
	/*else
	    --raise notice 'org is null';
	    for rec in 
	    
	    select distinct I_id,I_nom,I_prenom,I_organisme 
	    from contraintes.fw_get_individus(0,'asc',false) as (I_id int4,I_nom varchar,I_prenom varchar,I_organisme int4)
	    where I_id not in (select CI.id from contraintes.af_get_classe_individus($1,0,'asc',false) CI)
	   -and (I_organisme =org or I_organisme is null)
	    --and (I_organisme =org)	
	    
	    loop
		return next rec;
	    end loop;
	end if;*/
	
	
	

    end if;
    return;
end;$_$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_get_classe_individus_affiliables(integer) OWNER TO pgsql;

--
-- TOC entry 7432 (class 0 OID 0)
-- Dependencies: 944
-- Name: FUNCTION af_get_classe_individus_affiliables(integer); Type: COMMENT; Schema: contraintes; Owner: pgsql
--

COMMENT ON FUNCTION af_get_classe_individus_affiliables(integer) IS 'retourne les individus affiliables à une classe';


--
-- TOC entry 945 (class 1255 OID 2595731)
-- Dependencies: 2153 2983 5
-- Name: af_get_classe_individus_except_individus_types(integer, integer[], character varying, boolean); Type: FUNCTION; Schema: contraintes; Owner: pgsql
--

CREATE FUNCTION af_get_classe_individus_except_individus_types(integer, integer[], character varying, boolean) RETURNS SETOF organisme_type_individu
    AS $_$-- Parametres :
-- 1. Identifiant de la classe
-- 2. Type : 0=tous, 1=formateurs & 2=stagiaires
-- 3. ASC ou DESC = affichage dans l'ordre croissant ou decroissant
-- 4. exclusif : si VRAI alors que les 'u' ou les 'f'
declare
rec record;
rec2 contraintes.organisme_type_individu;
req varchar;
begin
    
    for rec in 
	select id,nom,prenom,organisme 
	from contraintes.fw_get_individus_except_individus_types($2,$3,$4) as (id int4,nom varchar,prenom varchar,organisme int4),contraintes.classe_individus CI 
	
	where CI.classe=$1 and CI.individu=id
	order by nom, prenom
    loop
	rec2.id:=rec.id;
	rec2.nom:=rec.nom;
	rec2.prenom:=rec.prenom;
	rec2.organisme:=rec.organisme;
	rec2.types:=NULL;
	return next rec2;
	--return next rec;
    end loop;
    return;
end;$_$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_get_classe_individus_except_individus_types(integer, integer[], character varying, boolean) OWNER TO pgsql;

--
-- TOC entry 7434 (class 0 OID 0)
-- Dependencies: 945
-- Name: FUNCTION af_get_classe_individus_except_individus_types(integer, integer[], character varying, boolean); Type: COMMENT; Schema: contraintes; Owner: pgsql
--

COMMENT ON FUNCTION af_get_classe_individus_except_individus_types(integer, integer[], character varying, boolean) IS 'retourne les n°,nom prenom et organisme des individus d''une classe qui ne sont pas de certains types';


--
-- TOC entry 1836 (class 1255 OID 2595732)
-- Dependencies: 2983 5
-- Name: af_get_classe_individus_infos(integer, integer, character varying, boolean); Type: FUNCTION; Schema: contraintes; Owner: pgsql
--

CREATE FUNCTION af_get_classe_individus_infos(integer, integer, character varying, boolean) RETURNS SETOF record
    AS $_$-- $1 : classe
-- $2 : type d'individu (0=tous, 1=formateurs & 2=stagiaires)
-- 3. ASC ou DESC = affichage dans l'ordre croissant ou decroissant
-- 4. exclusif : si VRAI alors que les 'u' ou les 'f'
declare
rec record;
begin
    for rec in
	select id ,identifiant_md5 ,login,password,nom ,prenom ,adresse ,code ,ville ,email ,tel_fixe ,tel_port ,langue ,organisme ,photo  
	from contraintes.fw_get_individus_infos($2,$3,$4)as (id int4,identifiant_md5 varchar,login varchar,password varchar,nom varchar,prenom varchar,adresse varchar,code varchar,ville varchar,email varchar,tel_fixe varchar,tel_port varchar,langue int4,organisme int4,photo int4),
	--from contraintes.af_get_individus_infos($2,$3,$4)as (id int4,identifiant_md5 varchar,login varchar,password varchar,nom varchar,prenom varchar,adresse varchar,code varchar,ville varchar,email varchar,tel_fixe varchar,tel_port varchar,langue int4,organisme int4,photo int4),
	
	contraintes.classe_individus CI 
	where CI.classe=$1 and CI.individu=id
    loop
	return next rec;
    end loop;
    return;
end;$_$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_get_classe_individus_infos(integer, integer, character varying, boolean) OWNER TO pgsql;

--
-- TOC entry 7436 (class 0 OID 0)
-- Dependencies: 1836
-- Name: FUNCTION af_get_classe_individus_infos(integer, integer, character varying, boolean); Type: COMMENT; Schema: contraintes; Owner: pgsql
--

COMMENT ON FUNCTION af_get_classe_individus_infos(integer, integer, character varying, boolean) IS 'Retourne les infos individu d''une classe';


--
-- TOC entry 946 (class 1255 OID 2595733)
-- Dependencies: 2983 5
-- Name: af_get_classe_nom_entier(integer); Type: FUNCTION; Schema: contraintes; Owner: pgsql
--

CREATE FUNCTION af_get_classe_nom_entier(integer) RETURNS character varying
    AS $_$declare
parent int4;
nom_classe varchar;
rec record;
begin
    parent=$1;
    while(parent is not null)
    loop
    select * into rec from contraintes.classe where id=parent;
    if nom_classe is null then
	nom_classe:=rec.libelle;
    else
	nom_classe:=rec.libelle || '/' || nom_classe;
    end if;
    parent:=rec.pere;
    end loop;
    return nom_classe;
end;$_$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_get_classe_nom_entier(integer) OWNER TO pgsql;

--
-- TOC entry 7438 (class 0 OID 0)
-- Dependencies: 946
-- Name: FUNCTION af_get_classe_nom_entier(integer); Type: COMMENT; Schema: contraintes; Owner: pgsql
--

COMMENT ON FUNCTION af_get_classe_nom_entier(integer) IS 'retourne le nom entier de la classe';


--
-- TOC entry 947 (class 1255 OID 2595734)
-- Dependencies: 2983 5
-- Name: af_get_classe_organisme(integer); Type: FUNCTION; Schema: contraintes; Owner: pgsql
--

CREATE FUNCTION af_get_classe_organisme(integer) RETURNS integer
    AS $_$-- $1 : numero organisme
declare
res int4;
nb_res int4;
begin
    -- recup organisme nom null des individus de la classe
    select into res distinct organisme 
    from contraintes.af_get_classe_individus($1,0,'asc',false); 
    --where organisme is not null;
    if found then
	
	GET DIAGNOSTICS nb_res:=ROW_COUNT;
	if nb_res=1 then
		
	    return res;
	end if;
    else
	return NULL;
    end if;
end;$_$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_get_classe_organisme(integer) OWNER TO pgsql;

--
-- TOC entry 7440 (class 0 OID 0)
-- Dependencies: 947
-- Name: FUNCTION af_get_classe_organisme(integer); Type: COMMENT; Schema: contraintes; Owner: pgsql
--

COMMENT ON FUNCTION af_get_classe_organisme(integer) IS 'retourn l''organisme d''une classe';


--
-- TOC entry 948 (class 1255 OID 2595735)
-- Dependencies: 2983 5
-- Name: af_get_classe_pere(integer); Type: FUNCTION; Schema: contraintes; Owner: postgres
--

CREATE FUNCTION af_get_classe_pere(integer) RETURNS SETOF record
    AS $_$declare
	id_pere alias for $1;
	req text;
	rec record;

begin
	
	if (id_pere is null) then
		for rec in
		select * from contraintes.classe where pere is null
		loop
			return next rec;
		end loop;
	else
		for rec in
		select * from contraintes.classe where pere = id_pere
		loop
			return next rec;
		end loop;
		
	end if;
	
	return;

end;$_$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_get_classe_pere(integer) OWNER TO postgres;

--
-- TOC entry 7442 (class 0 OID 0)
-- Dependencies: 948
-- Name: FUNCTION af_get_classe_pere(integer); Type: COMMENT; Schema: contraintes; Owner: postgres
--

COMMENT ON FUNCTION af_get_classe_pere(integer) IS 'Renvoie les classes associÃ©es Ã  un pere.';


--
-- TOC entry 949 (class 1255 OID 2595736)
-- Dependencies: 2983 5
-- Name: af_get_classe_peres_fils(); Type: FUNCTION; Schema: contraintes; Owner: pgsql
--

CREATE FUNCTION af_get_classe_peres_fils() RETURNS SETOF record
    AS $$declare
rec record;
rec2 record;
begin
    for rec in 
	select * from contraintes.af_get_classes() as (gc_id int4,gc_nom varchar,gc_id_pere int4,gc_min int4,gc_max int4)
    loop
	/*
	for rec2 in
	    select * from contraintes.af_get_classe_pere(rec.gc_id) as (id int4,nom varchar,id_pere int4,min int4,max int4)
	loop
		
		return next rec2;
	end loop;
	*/
		return next rec;
    end loop;
end;$$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_get_classe_peres_fils() OWNER TO pgsql;

--
-- TOC entry 7444 (class 0 OID 0)
-- Dependencies: 949
-- Name: FUNCTION af_get_classe_peres_fils(); Type: COMMENT; Schema: contraintes; Owner: pgsql
--

COMMENT ON FUNCTION af_get_classe_peres_fils() IS 'retourne toutes les clases (pere fils)';


--
-- TOC entry 950 (class 1255 OID 2595737)
-- Dependencies: 2983 5
-- Name: af_get_classes(); Type: FUNCTION; Schema: contraintes; Owner: pgsql
--

CREATE FUNCTION af_get_classes() RETURNS SETOF record
    AS $$declare
rec record;

begin
    for rec in 
	select id,libelle,pere,min,max from contraintes.classe
    loop
    return next rec;
    end loop;
    return; 
end;$$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_get_classes() OWNER TO pgsql;

--
-- TOC entry 7446 (class 0 OID 0)
-- Dependencies: 950
-- Name: FUNCTION af_get_classes(); Type: COMMENT; Schema: contraintes; Owner: pgsql
--

COMMENT ON FUNCTION af_get_classes() IS 'retourne les classes de la plateforme';


--
-- TOC entry 951 (class 1255 OID 2595738)
-- Dependencies: 2983 5
-- Name: af_get_classes_exotlcs_corriges(); Type: FUNCTION; Schema: contraintes; Owner: pgsql
--

CREATE FUNCTION af_get_classes_exotlcs_corriges() RETURNS SETOF record
    AS $$declare
rec record;
begin
    for rec in
	select distinct c_id,libelle from contraintes.af_get_classes() as (c_id int4,libelle varchar,pere int4,min int4,max int4),
	contraintes.classe_individus CI,
	contraintes.af_get_individus_exotlcs_corriges() as (id int4,nom varchar,prenom varchar) 
	where c_id=CI.classe and CI.individu=id 
    loop
	return next rec;
    end loop;
end;$$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_get_classes_exotlcs_corriges() OWNER TO pgsql;

--
-- TOC entry 7448 (class 0 OID 0)
-- Dependencies: 951
-- Name: FUNCTION af_get_classes_exotlcs_corriges(); Type: COMMENT; Schema: contraintes; Owner: pgsql
--

COMMENT ON FUNCTION af_get_classes_exotlcs_corriges() IS 'retourne les classes qui ont des exotlcs corriges';


--
-- TOC entry 952 (class 1255 OID 2595739)
-- Dependencies: 2983 5
-- Name: af_get_classes_formation(); Type: FUNCTION; Schema: contraintes; Owner: pgsql
--

CREATE FUNCTION af_get_classes_formation() RETURNS SETOF record
    AS $$declare
rec record;
begin
    for rec in 
	select distinct c.id,c.libelle,c.pere 
	from contraintes.classe c,contraintes.formation_participants fp
	where c.id=fp.classe
    loop
	return next rec;
    end loop;
	
end;$$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_get_classes_formation() OWNER TO pgsql;

--
-- TOC entry 7450 (class 0 OID 0)
-- Dependencies: 952
-- Name: FUNCTION af_get_classes_formation(); Type: COMMENT; Schema: contraintes; Owner: pgsql
--

COMMENT ON FUNCTION af_get_classes_formation() IS 'retourne les classes des fromations de la plateforme';


--
-- TOC entry 953 (class 1255 OID 2595740)
-- Dependencies: 2983 5
-- Name: af_get_classes_individu(); Type: FUNCTION; Schema: contraintes; Owner: pgsql
--

CREATE FUNCTION af_get_classes_individu() RETURNS SETOF record
    AS $$declare
rec record;
begin
    for rec in 
	select distinct id,libelle,pere,max,min from contraintes.af_get_classes() as (id int4,libelle varchar,pere int4,max int4,min int4),
	contraintes.classe_individus CI where id=CI.classe
    loop
	return next rec;
    end loop;
    return;
end;$$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_get_classes_individu() OWNER TO pgsql;

--
-- TOC entry 7452 (class 0 OID 0)
-- Dependencies: 953
-- Name: FUNCTION af_get_classes_individu(); Type: COMMENT; Schema: contraintes; Owner: pgsql
--

COMMENT ON FUNCTION af_get_classes_individu() IS 'retourne les classes avec individu de la plateforme';


--
-- TOC entry 954 (class 1255 OID 2595741)
-- Dependencies: 2983 5
-- Name: af_get_commentaire(integer, integer, integer); Type: FUNCTION; Schema: contraintes; Owner: pgsql
--

CREATE FUNCTION af_get_commentaire(integer, integer, integer) RETURNS record
    AS $_$-- $1 : numero etape
-- $2 : min
-- $3 : max
declare
rec record;
begin
    select into rec etape,min,max,commentaire 
    from contraintes.commentaire_etape 
    where etape=$1 and min=$2 and max=$3;
    return rec;
end;$_$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_get_commentaire(integer, integer, integer) OWNER TO pgsql;

--
-- TOC entry 7454 (class 0 OID 0)
-- Dependencies: 954
-- Name: FUNCTION af_get_commentaire(integer, integer, integer); Type: COMMENT; Schema: contraintes; Owner: pgsql
--

COMMENT ON FUNCTION af_get_commentaire(integer, integer, integer) IS 'retourne un commentaire';


--
-- TOC entry 955 (class 1255 OID 2595742)
-- Dependencies: 2983 5
-- Name: af_get_connexion_dates_max(integer); Type: FUNCTION; Schema: contraintes; Owner: pgsql
--

CREATE FUNCTION af_get_connexion_dates_max(integer) RETURNS record
    AS $_$-- $1 : individu
declare
rec record;
begin
    select into rec max(c1.connexion),max(c2.deconnexion) 
    from contraintes.connexion c1,contraintes.connexion c2 where c1.individu=$1 and c2.individu=$1;
    return rec;
end;$_$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_get_connexion_dates_max(integer) OWNER TO pgsql;

--
-- TOC entry 7456 (class 0 OID 0)
-- Dependencies: 955
-- Name: FUNCTION af_get_connexion_dates_max(integer); Type: COMMENT; Schema: contraintes; Owner: pgsql
--

COMMENT ON FUNCTION af_get_connexion_dates_max(integer) IS 'retourne les dates max de connexion et deconnexion pour un individu';


--
-- TOC entry 956 (class 1255 OID 2595743)
-- Dependencies: 2983 5
-- Name: af_get_connexion_individus(); Type: FUNCTION; Schema: contraintes; Owner: pgsql
--

CREATE FUNCTION af_get_connexion_individus() RETURNS SETOF record
    AS $$declare
rec record;
begin
    for rec in
	select distinct(individu),max(connexion) as maxdate,ip 
	from contraintes.connexion 
	group by individu,ip order by maxdate
    loop
	return next rec;
    end loop;

end;$$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_get_connexion_individus() OWNER TO pgsql;

--
-- TOC entry 7458 (class 0 OID 0)
-- Dependencies: 956
-- Name: FUNCTION af_get_connexion_individus(); Type: COMMENT; Schema: contraintes; Owner: pgsql
--

COMMENT ON FUNCTION af_get_connexion_individus() IS 'retourne les dates de connexions des individus';


--
-- TOC entry 957 (class 1255 OID 2595744)
-- Dependencies: 2983 5
-- Name: af_get_critere(integer); Type: FUNCTION; Schema: contraintes; Owner: pgsql
--

CREATE FUNCTION af_get_critere(integer) RETURNS record
    AS $_$-- $1 : numero critere
declare
rec record;
begin
    select into rec c_id,c_libelle,cc.theme,c_pere 
    from contraintes.af_get_criteres() as (c_id int4,c_libelle varchar,c_pere int4),contraintes.categorie_critere cc 
    where c_id=$1 and cc.id=c_id;
    return rec; 	
end;$_$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_get_critere(integer) OWNER TO pgsql;

--
-- TOC entry 7460 (class 0 OID 0)
-- Dependencies: 957
-- Name: FUNCTION af_get_critere(integer); Type: COMMENT; Schema: contraintes; Owner: pgsql
--

COMMENT ON FUNCTION af_get_critere(integer) IS 'retourne l''id,le libelle et le theme d''un critere';


--
-- TOC entry 958 (class 1255 OID 2595745)
-- Dependencies: 2983 5
-- Name: af_get_critere_sous_criteres(integer); Type: FUNCTION; Schema: contraintes; Owner: pgsql
--

CREATE FUNCTION af_get_critere_sous_criteres(integer) RETURNS SETOF record
    AS $_$-- $1 : numero critere
declare
rec record;
begin
    for rec in 
	select c_id,c_libelle,cc.theme,c_pere from contraintes.af_get_criteres() as (c_id int4,c_libelle varchar,c_pere int4),
	contraintes.categorie_critere cc
	where c_pere=$1 and c_id=cc.id
    loop
	return next rec;
    end loop;
    return;
end;$_$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_get_critere_sous_criteres(integer) OWNER TO pgsql;

--
-- TOC entry 7462 (class 0 OID 0)
-- Dependencies: 958
-- Name: FUNCTION af_get_critere_sous_criteres(integer); Type: COMMENT; Schema: contraintes; Owner: pgsql
--

COMMENT ON FUNCTION af_get_critere_sous_criteres(integer) IS 'retourne les sous criteres d''un critere';


--
-- TOC entry 959 (class 1255 OID 2595746)
-- Dependencies: 2983 5
-- Name: af_get_criteres(); Type: FUNCTION; Schema: contraintes; Owner: pgsql
--

CREATE FUNCTION af_get_criteres() RETURNS SETOF record
    AS $$declare
rec record;
begin
    for rec in 
	select id,libelle,pere from contraintes.critere 
    loop
	return next rec;
    end loop;
    return;
end;$$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_get_criteres() OWNER TO pgsql;

--
-- TOC entry 7464 (class 0 OID 0)
-- Dependencies: 959
-- Name: FUNCTION af_get_criteres(); Type: COMMENT; Schema: contraintes; Owner: pgsql
--

COMMENT ON FUNCTION af_get_criteres() IS 'retourne tous les criteres de la plateforme';


--
-- TOC entry 960 (class 1255 OID 2595747)
-- Dependencies: 2983 5
-- Name: af_get_droit(integer); Type: FUNCTION; Schema: contraintes; Owner: pgsql
--

CREATE FUNCTION af_get_droit(integer) RETURNS record
    AS $_$-- $1 : numero droit
declare
rec record;
begin
    select into rec id,libelle,type,defaut from contraintes.droit where id=$1;
    return rec;
end;$_$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_get_droit(integer) OWNER TO pgsql;

--
-- TOC entry 7466 (class 0 OID 0)
-- Dependencies: 960
-- Name: FUNCTION af_get_droit(integer); Type: COMMENT; Schema: contraintes; Owner: pgsql
--

COMMENT ON FUNCTION af_get_droit(integer) IS 'retourne les info d''un droit';


--
-- TOC entry 961 (class 1255 OID 2595748)
-- Dependencies: 2983 5
-- Name: af_get_droits(integer); Type: FUNCTION; Schema: contraintes; Owner: pgsql
--

CREATE FUNCTION af_get_droits(integer) RETURNS SETOF record
    AS $_$-- $1 : type individu (0=tous,1=formateur,2=utilisateur,3=intervenant
declare
rec record;
req varchar;
begin
    if $1=0 then
	req:='select id,libelle,type,defaut from contraintes.droit';
    else
	req:='select id,libelle,type,defaut from contraintes.droit where type='||$1;
    end if;
    for rec in
	execute req
    loop
	return next rec;
    end loop;
    return;
end$_$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_get_droits(integer) OWNER TO pgsql;

--
-- TOC entry 7468 (class 0 OID 0)
-- Dependencies: 961
-- Name: FUNCTION af_get_droits(integer); Type: COMMENT; Schema: contraintes; Owner: pgsql
--

COMMENT ON FUNCTION af_get_droits(integer) IS 'retourne tous les droits de la plateforme
pour un type d''individu';


--
-- TOC entry 962 (class 1255 OID 2595749)
-- Dependencies: 2983 5
-- Name: af_get_droits_defaut(integer); Type: FUNCTION; Schema: contraintes; Owner: pgsql
--

CREATE FUNCTION af_get_droits_defaut(integer) RETURNS SETOF record
    AS $_$-- $1 type d'individu (1 : formateur, 2 : utilisateur, 3 : intervenant)
declare
rec record;
begin
    for rec in 
	select id,libelle,type from contraintes.droit where defaut is true and type=$1
    loop
	return next rec;
    end loop;
    return;
end;$_$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_get_droits_defaut(integer) OWNER TO pgsql;

--
-- TOC entry 7470 (class 0 OID 0)
-- Dependencies: 962
-- Name: FUNCTION af_get_droits_defaut(integer); Type: COMMENT; Schema: contraintes; Owner: pgsql
--

COMMENT ON FUNCTION af_get_droits_defaut(integer) IS 'retourne les droits par defaut';


--
-- TOC entry 963 (class 1255 OID 2595750)
-- Dependencies: 2983 5
-- Name: af_get_element_themes_categorie(integer, integer); Type: FUNCTION; Schema: contraintes; Owner: postgres
--

CREATE FUNCTION af_get_element_themes_categorie(integer, integer) RETURNS SETOF record
    AS $_$
--$1 l element dont on veut le theme
--$2 la categorie

DECLARE
	rec RECORD;
BEGIN

	FOR rec IN
		SELECT T.id, T.libelle FROM contraintes.theme_categories TC, contraintes.theme T 
		WHERE TC.categorie=$2 
		AND TC.id=$1
		AND TC.theme=T.id
	LOOP
		RETURN NEXT rec;
	END LOOP;
	RETURN;
END;$_$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_get_element_themes_categorie(integer, integer) OWNER TO postgres;

--
-- TOC entry 7472 (class 0 OID 0)
-- Dependencies: 963
-- Name: FUNCTION af_get_element_themes_categorie(integer, integer); Type: COMMENT; Schema: contraintes; Owner: postgres
--

COMMENT ON FUNCTION af_get_element_themes_categorie(integer, integer) IS 'Obtenir les themes d''un element de la base

Param1:
NumÃ©ro de la catÃ©gorie

Param2
NumÃ©ro de l''Ã©lÃ©ment

Retourne;
Les numÃ©ros de thÃ¨mes (setof int4)';


--
-- TOC entry 964 (class 1255 OID 2595751)
-- Dependencies: 2983 5
-- Name: af_get_espace(integer); Type: FUNCTION; Schema: contraintes; Owner: pgsql
--

CREATE FUNCTION af_get_espace(integer) RETURNS record
    AS $_$-- $1 : numero espace
declare
rec record;
begin
    select into rec * from contraintes.af_get_espaces() as (id int4,libelle varchar) 
    where id=$1;
    return rec;
end;$_$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_get_espace(integer) OWNER TO pgsql;

--
-- TOC entry 7474 (class 0 OID 0)
-- Dependencies: 964
-- Name: FUNCTION af_get_espace(integer); Type: COMMENT; Schema: contraintes; Owner: pgsql
--

COMMENT ON FUNCTION af_get_espace(integer) IS 'retourne un espace';


--
-- TOC entry 965 (class 1255 OID 2595752)
-- Dependencies: 2983 5
-- Name: af_get_espaces(); Type: FUNCTION; Schema: contraintes; Owner: pgsql
--

CREATE FUNCTION af_get_espaces() RETURNS SETOF record
    AS $$declare
rec record;
begin
    for rec in 
	select * from contraintes.espace 
    loop
	return next rec;
    end loop;
    return;
end;$$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_get_espaces() OWNER TO pgsql;

--
-- TOC entry 7476 (class 0 OID 0)
-- Dependencies: 965
-- Name: FUNCTION af_get_espaces(); Type: COMMENT; Schema: contraintes; Owner: pgsql
--

COMMENT ON FUNCTION af_get_espaces() IS 'retourne les espaces de la plateforme';


--
-- TOC entry 966 (class 1255 OID 2595753)
-- Dependencies: 2983 5
-- Name: af_get_etape(integer); Type: FUNCTION; Schema: contraintes; Owner: pgsql
--

CREATE FUNCTION af_get_etape(integer) RETURNS record
    AS $_$DECLARE
rec RECORD;
BEGIN
	SELECT INTO rec id, libelle, "type", date_creation FROM contraintes.etape
	WHERE id=$1;

	RETURN rec;
END$_$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_get_etape(integer) OWNER TO pgsql;

--
-- TOC entry 7478 (class 0 OID 0)
-- Dependencies: 966
-- Name: FUNCTION af_get_etape(integer); Type: COMMENT; Schema: contraintes; Owner: pgsql
--

COMMENT ON FUNCTION af_get_etape(integer) IS 'Obtenir les informations d''une etape.';


--
-- TOC entry 967 (class 1255 OID 2595754)
-- Dependencies: 2983 5
-- Name: af_get_etape_classes(integer); Type: FUNCTION; Schema: contraintes; Owner: pgsql
--

CREATE FUNCTION af_get_etape_classes(integer) RETURNS SETOF record
    AS $_$DECLARE
rec1 RECORD;
rec2 RECORD;
BEGIN
	FOR rec1 IN
		--on selectionne les parcours de l'étape
		SELECT id
		FROM contraintes.af_get_etape_parcourss($1) AS (id int4, libelle varchar, filiere int4, duree bool, etape int, date_creation timestamp) 

	LOOP
		raise notice 'etape % parcours % trouvé', $1, rec1.id;
		--pour chacun des parcours, on recupere ses formations et leurs classes
		FOR rec2 IN
			SELECT DISTINCT id ,libelle ,pere ,min ,max ,  rec1.id AS parcours
			FROM contraintes.af_get_parcours_formations(rec1.id)  AS (P_id int4, P_libelle varchar, P_parcours int4, P_date_debut date, P_date_fin date, P_langue_defaut int4,ressources_fusionnees boolean),
			contraintes.af_get_formations_classes() AS (id int4,libelle varchar,pere int4,min int4,max int4, formation int4)
			WHERE formation=P_id
		LOOP
			raise notice 'la';
			RETURN NEXT rec2;
		END LOOP;
	END LOOP;
	
	RETURN;
END;$_$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_get_etape_classes(integer) OWNER TO pgsql;

--
-- TOC entry 968 (class 1255 OID 2595755)
-- Dependencies: 2983 5
-- Name: af_get_etape_filieres(integer); Type: FUNCTION; Schema: contraintes; Owner: pgsql
--

CREATE FUNCTION af_get_etape_filieres(integer) RETURNS SETOF record
    AS $_$DECLARE
rec RECORD;
BEGIN
	FOR rec IN
		SELECT F_id, F_libelle, F_pere, id
		FROM contraintes.af_get_etape_parcourss($1) AS (id int4,libelle varchar, filiere int4, duree bool, etape int4, date_creation timestamp)
		LEFT OUTER JOIN 
		contraintes.af_get_filieres() AS (F_id int4, F_libelle varchar, F_pere int4, niveau int4)
		ON (filiere=F_id)
		ORDER BY F_libelle
	LOOP
		RETURN NEXT rec;
	END LOOP;

	RETURN;
END;$_$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_get_etape_filieres(integer) OWNER TO pgsql;

--
-- TOC entry 969 (class 1255 OID 2595756)
-- Dependencies: 2983 5
-- Name: af_get_etape_formations(integer); Type: FUNCTION; Schema: contraintes; Owner: pgsql
--

CREATE FUNCTION af_get_etape_formations(integer) RETURNS SETOF record
    AS $_$DECLARE
rec1 RECORD;
rec2 RECORD;
BEGIN
	FOR rec1 IN
		--on selectionne les parcours de l'étape
		SELECT id
		FROM contraintes.af_get_etape_parcourss($1) AS (id int4, libelle varchar, filiere int4, duree bool, etape int, date_creation timestamp) 

	LOOP
		--pour chacun des parcours, on recupere ses formations
		FOR rec2 IN
			SELECT  *
			FROM contraintes.af_get_parcours_formations(rec1.id)  AS (id int4, libelle varchar, parcours int4, date_debut date, date_fin date, langue_defaut int4,ressources_fusionnees bool)
			ORDER BY libelle
		LOOP
			RETURN NEXT rec2;
		END LOOP;
	END LOOP;
	
	RETURN;
END;$_$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_get_etape_formations(integer) OWNER TO pgsql;

--
-- TOC entry 970 (class 1255 OID 2595757)
-- Dependencies: 2983 5
-- Name: af_get_etape_formations_classe(integer, integer); Type: FUNCTION; Schema: contraintes; Owner: pgsql
--

CREATE FUNCTION af_get_etape_formations_classe(integer, integer) RETURNS SETOF record
    AS $_$DECLARE
rec1 RECORD;
rec2 RECORD;
BEGIN
	FOR rec1 IN
		--on selectionne les parcours de l'étape
		SELECT id
		FROM contraintes.af_get_etape_parcourss($1) AS (id int4, libelle varchar, filiere int4, duree bool, etape int, date_creation timestamp) 

	LOOP
		--pour chacun des parcours, on recupere ses formations
		FOR rec2 IN
			SELECT  id , libelle , parcours , date_debut , date_fin , langue_defaut , classe
			FROM contraintes.af_get_parcours_formations(rec1.id)  AS (id int4, libelle varchar, parcours int4, date_debut date, date_fin date, langue_defaut int4,ressources_fusionnees boolean),
			contraintes.formation_participants
			WHERE classe=$2 
			AND id=formation
		LOOP
			RETURN NEXT rec2;
		END LOOP;
	END LOOP;
	
	RETURN;
END;$_$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_get_etape_formations_classe(integer, integer) OWNER TO pgsql;

--
-- TOC entry 971 (class 1255 OID 2595758)
-- Dependencies: 2983 5
-- Name: af_get_etape_forum(integer); Type: FUNCTION; Schema: contraintes; Owner: pgsql
--

CREATE FUNCTION af_get_etape_forum(integer) RETURNS record
    AS $_$-- $1 : etape
declare
rec record;
begin
    select into rec * from contraintes.af_get_etapes_forum() 
    as (id int4,libelle_etape varchar,forum int4,libelle varchar,description varchar,moderation bool,moderateur_pwd varchar,fils int4,messages int4,upload bool,theme varchar,configuration int4,date_creation timestamp)
    where id=$1;
    return rec;
end;$_$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_get_etape_forum(integer) OWNER TO pgsql;

--
-- TOC entry 7484 (class 0 OID 0)
-- Dependencies: 971
-- Name: FUNCTION af_get_etape_forum(integer); Type: COMMENT; Schema: contraintes; Owner: pgsql
--

COMMENT ON FUNCTION af_get_etape_forum(integer) IS 'retourne les données d''une etape forum';


--
-- TOC entry 972 (class 1255 OID 2595759)
-- Dependencies: 2983 5
-- Name: af_get_etape_parcours_oriente_configuration(integer); Type: FUNCTION; Schema: contraintes; Owner: pgsql
--

CREATE FUNCTION af_get_etape_parcours_oriente_configuration(integer) RETURNS SETOF record
    AS $_$DECLARE
--$1 etape
rec RECORD;
BEGIN
	FOR rec IN
		SELECT id, type, seuil, sous_parcours
		FROM contraintes.parcours_oriente PO
		WHERE PO.id=$1
	LOOP
		RETURN NEXT rec;
	END LOOP;

	RETURN;
END;$_$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_get_etape_parcours_oriente_configuration(integer) OWNER TO pgsql;

--
-- TOC entry 973 (class 1255 OID 2595760)
-- Dependencies: 2983 5
-- Name: af_get_etape_parcourss(integer); Type: FUNCTION; Schema: contraintes; Owner: pgsql
--

CREATE FUNCTION af_get_etape_parcourss(integer) RETURNS SETOF record
    AS $_$DECLARE
rec RECORD;
BEGIN

	FOR rec IN
		SELECT DISTINCT parcours ,libelle , filiere , duree, etape , date_creation 
		FROM contraintes.parcours_etapes LEFT OUTER JOIN 
		contraintes.af_get_parcours() AS (id int4, libelle varchar, filiere int4, duree bool, date_creation timestamp) 
		ON (parcours=id)
		WHERE etape=$1
		ORDER BY libelle
	LOOP
		RETURN NEXT rec;
	END LOOP;

	RETURN;
END$_$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_get_etape_parcourss(integer) OWNER TO pgsql;

--
-- TOC entry 7487 (class 0 OID 0)
-- Dependencies: 973
-- Name: FUNCTION af_get_etape_parcourss(integer); Type: COMMENT; Schema: contraintes; Owner: pgsql
--

COMMENT ON FUNCTION af_get_etape_parcourss(integer) IS 'Obtenir les numero des parcours qui contiennent une Ã©tape donnÃ©e';


--
-- TOC entry 974 (class 1255 OID 2595761)
-- Dependencies: 2983 5
-- Name: af_get_etape_ressource(integer); Type: FUNCTION; Schema: contraintes; Owner: pgsql
--

CREATE FUNCTION af_get_etape_ressource(integer) RETURNS record
    AS $_$DECLARE
-- $1 : id de l'étape
rec record;
BEGIN
	SELECT INTO rec er.id,e.libelle,er.espace,er.section,F.id,F.type,fm.mots_cles, e.date_creation 
	FROM contraintes.etape e,  contraintes.etape_ressource er LEFT OUTER JOIN (
		contraintes.fichier F LEFT OUTER JOIN contraintes.fichier_metadata fm ON (F.id=fm.id)
		)ON (er.fichier=F.id)
	WHERE e.id=er.id
	AND er.id=$1;
	
	RETURN rec;
END;$_$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_get_etape_ressource(integer) OWNER TO pgsql;

--
-- TOC entry 975 (class 1255 OID 2595762)
-- Dependencies: 2983 5
-- Name: af_get_etape_ressource_infos(integer, integer, integer); Type: FUNCTION; Schema: contraintes; Owner: postgres
--

CREATE FUNCTION af_get_etape_ressource_infos(integer, integer, integer) RETURNS SETOF record
    AS $_$-- $1 : espace
-- $2 : section
-- $3 : ressource
declare
rec record;
begin
    select into rec
    
	FR.ressource,R.fichier,FR.espace,E.libelle, FR.section,S.libelle,ET.libelle,FR.formation,FI.type,R.mots_cles, 
	cast(FR.debut_disponibilite as timestamp), cast(FR.fin_disponibilite as timestamp), FR.duree_nouveaute, S.icone
	FROM 
	contraintes.formation_ressources FR,
	contraintes.fichier_ressource FR,
	contraintes.etape ET,
	contraintes.etape_ressource ER,
	contraintes.fichier FI,
	contraintes.espace E,
	contraintes.section S
	WHERE 
	ER.espace=$1 and ER.section=$2 and ER.ressource=$3  
	and ER.ressource=R.id 
	and ER.espace=E.id 
	and ER.section=S.id 
	and R.fichier=FI.id 
	and ER.id=ET.id and ER.ressource=FR.ressource;
    
	return next rec;
    
end;$_$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_get_etape_ressource_infos(integer, integer, integer) OWNER TO postgres;

--
-- TOC entry 7490 (class 0 OID 0)
-- Dependencies: 975
-- Name: FUNCTION af_get_etape_ressource_infos(integer, integer, integer); Type: COMMENT; Schema: contraintes; Owner: postgres
--

COMMENT ON FUNCTION af_get_etape_ressource_infos(integer, integer, integer) IS 'Retourne les infos d''une ressource';


--
-- TOC entry 976 (class 1255 OID 2595763)
-- Dependencies: 2983 5
-- Name: af_get_etape_resultats(integer); Type: FUNCTION; Schema: contraintes; Owner: pgsql
--

CREATE FUNCTION af_get_etape_resultats(integer) RETURNS SETOF record
    AS $_$DECLARE
rec RECORD;
BEGIN
	FOR rec IN
		SELECT id, formation, stagiaire, parcours,  etape, date_debut, duree
		FROM contraintes.resultat
		WHERE etape=$1
	LOOP 
		RETURN NEXT rec;
	END LOOP;

	RETURN;
END;$_$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_get_etape_resultats(integer) OWNER TO pgsql;

--
-- TOC entry 977 (class 1255 OID 2595764)
-- Dependencies: 2983 5
-- Name: af_get_etape_scorm_fichier(integer); Type: FUNCTION; Schema: contraintes; Owner: pgsql
--

CREATE FUNCTION af_get_etape_scorm_fichier(integer) RETURNS integer
    AS $_$DECLARE
--$1 le numero du fichier
etape_scorm_id int4;
BEGIN

	SELECT INTO etape_scorm_id id FROM contraintes.etape_scorm
	WHERE fichier=$1;

	RETURN etape_scorm_id;

END$_$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_get_etape_scorm_fichier(integer) OWNER TO pgsql;

--
-- TOC entry 7493 (class 0 OID 0)
-- Dependencies: 977
-- Name: FUNCTION af_get_etape_scorm_fichier(integer); Type: COMMENT; Schema: contraintes; Owner: pgsql
--

COMMENT ON FUNCTION af_get_etape_scorm_fichier(integer) IS 'Obtenir l''identifiant d''une etape scorm a partir de son numero de fichier.';


--
-- TOC entry 1837 (class 1255 OID 2595765)
-- Dependencies: 2155 2983 5
-- Name: af_get_etape_type_sous_type(integer, integer, character varying); Type: FUNCTION; Schema: contraintes; Owner: pgsql
--

CREATE FUNCTION af_get_etape_type_sous_type(integer, integer, character varying) RETURNS type_element
    AS $_$DECLARE
--$1 identifiant d'etape
--$2 type d'etape
--$3 libelle du type d'etape
rec_spe_1 RECORD;
serie_aleatoire bool;
retour contraintes.type_element;
retour_serie contraintes.type_element;
BEGIN

--AFFECTE LE TYPE ETAPE (ORIGINAL)
retour.id:=$2;
retour.libelle:=$3;

--type liste
IF $2=4 THEN
	SELECT INTO rec_spe_1 libelle, L_type AS type
	FROM contraintes.af_get_liste($1) AS  (L_id int4,L_libelle varchar, L_type int4, date_creation timestamp),
	contraintes.liste_type T
	WHERE L_type=T.id;
	
	--AFFECTE LE TYPE LISTE
	retour.id:=retour.id||'_'||rec_spe_1.type;
	retour.libelle:=rec_spe_1.libelle;

	--type serie
	IF rec_spe_1.type=1 THEN

		--serie aléatoire ?
		SELECT INTO serie_aleatoire * FROM contraintes.af_is_serie_aleatoire($1);		
		IF serie_aleatoire THEN
			SELECT INTO retour_serie * FROM contraintes.af_get_serie_aleatoire_type($1);
			--si la serie est mono evaluation on l'indique, sinon on laisse le sous type tel quel
			IF retour_serie.id IS NOT NULL THEN
				--AFFECTE LE TYPE (D'EVALUATION)DE SERIE
				retour.libelle:='''   - ''.'||retour_serie.libelle;
				retour.id:=retour.id||'_'||retour_serie.id;
			END IF;
		ELSE
			SELECT INTO retour_serie * FROM contraintes.af_get_serie_simple_type($1);
			--si la serie est mono evaluation on l'indique, sinon on laisse le sous type tel quel
			IF retour_serie.id IS NOT NULL THEN
				--AFFECTE LE TYPE (D'EVALUATION)DE SERIE
				retour.libelle:='''   - ''.'||retour.libelle||'.'' (''.'||retour_serie.libelle||'.'')''';
				retour.id:=retour.id||'_0_'||retour_serie.id;
			END IF;
		END IF;
	--type test
	ELSE
		retour.libelle:=rec_spe_1.libelle;
	END IF;
END IF;

RETURN retour;

END;$_$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_get_etape_type_sous_type(integer, integer, character varying) OWNER TO pgsql;

--
-- TOC entry 978 (class 1255 OID 2595766)
-- Dependencies: 2983 5
-- Name: af_get_etapes(); Type: FUNCTION; Schema: contraintes; Owner: pgsql
--

CREATE FUNCTION af_get_etapes() RETURNS SETOF record
    AS $$DECLARE
rec RECORD;
BEGIN
	FOR rec IN
		SELECT id, libelle, "type",date_creation  FROM contraintes.etape
	LOOP
		RETURN NEXT rec;
	END LOOP;

	RETURN;
END;$$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_get_etapes() OWNER TO pgsql;

--
-- TOC entry 1838 (class 1255 OID 2595767)
-- Dependencies: 2983 5
-- Name: af_get_etapes_chats(); Type: FUNCTION; Schema: contraintes; Owner: pgsql
--

CREATE FUNCTION af_get_etapes_chats() RETURNS SETOF record
    AS $$declare
rec record;
begin
    for rec in
	select ec.id,e.libelle,e.type,e.date_creation 
	from contraintes.etape e , contraintes.etape_chat ec  
	where e.id=ec.id
    loop
	return next rec;
    end loop;
end;$$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_get_etapes_chats() OWNER TO pgsql;

--
-- TOC entry 7497 (class 0 OID 0)
-- Dependencies: 1838
-- Name: FUNCTION af_get_etapes_chats(); Type: COMMENT; Schema: contraintes; Owner: pgsql
--

COMMENT ON FUNCTION af_get_etapes_chats() IS 'retourne les etapes chat de la plateforme';


--
-- TOC entry 979 (class 1255 OID 2595768)
-- Dependencies: 2983 5
-- Name: af_get_etapes_fichiers(integer[], character varying); Type: FUNCTION; Schema: contraintes; Owner: pgsql
--

CREATE FUNCTION af_get_etapes_fichiers(integer[], character varying) RETURNS SETOF record
    AS $_$DECLARE
--$1 les numeros de fichier
--$2 la table de correspondance fichier/etape
rec RECORD;
req varchar;
BEGIN

	req:='SELECT DISTINCT E.id, E.libelle, E.type, T.fichier, E.date_creation  FROM contraintes.'||$2||' T, contraintes.etape E
	WHERE T.fichier IN ('||array_to_string ($1, ',')||')
	AND E.id=T.id;';
	--RAISE NOTICE 'req=%', req;

	FOR rec IN 
		EXECUTE req
	LOOP
		RETURN NEXT rec;
	END LOOP; 

	RETURN;

END$_$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_get_etapes_fichiers(integer[], character varying) OWNER TO pgsql;

--
-- TOC entry 7499 (class 0 OID 0)
-- Dependencies: 979
-- Name: FUNCTION af_get_etapes_fichiers(integer[], character varying); Type: COMMENT; Schema: contraintes; Owner: pgsql
--

COMMENT ON FUNCTION af_get_etapes_fichiers(integer[], character varying) IS 'Obtenir les informations sur les etapes d''un ensemble de fichiers d''apres leurs numeros.';


--
-- TOC entry 980 (class 1255 OID 2595769)
-- Dependencies: 2983 5
-- Name: af_get_etapes_forum(); Type: FUNCTION; Schema: contraintes; Owner: pgsql
--

CREATE FUNCTION af_get_etapes_forum() RETURNS SETOF record
    AS $$declare
rec record;
begin
    for rec in 
	select ef.id,e.libelle,f.id,f.libelle,f.description,f.moderation,f.moderateur_pwd,f.fils,f.messages,f.upload,f.theme,fe.environnement,date_creation 
	from contraintes.etape e , contraintes.etape_forum ef  left outer join contraintes.forum f on (f.id=ef.forum)
	left outer join contraintes.forum_environnements fe ON (fe.forum=f.id) 
	where e.id=ef.id
	
    loop
	return next rec;
    end loop;
end;$$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_get_etapes_forum() OWNER TO pgsql;

--
-- TOC entry 7501 (class 0 OID 0)
-- Dependencies: 980
-- Name: FUNCTION af_get_etapes_forum(); Type: COMMENT; Schema: contraintes; Owner: pgsql
--

COMMENT ON FUNCTION af_get_etapes_forum() IS 'retourne les etapes forum de la plateforme';


--
-- TOC entry 981 (class 1255 OID 2595770)
-- Dependencies: 2983 5
-- Name: af_get_evaluation(integer); Type: FUNCTION; Schema: contraintes; Owner: pgsql
--

CREATE FUNCTION af_get_evaluation(integer) RETURNS record
    AS $_$DECLARE
--$1 identifiant de l'evaluation
rec RECORD;
BEGIN
	SELECT INTO rec id, libelle, type, date_creation
	FROM contraintes.evaluation
	WHERE id=$1;

	RETURN rec;
END;$_$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_get_evaluation(integer) OWNER TO pgsql;

--
-- TOC entry 1839 (class 1255 OID 2595771)
-- Dependencies: 2983 5
-- Name: af_get_evaluation_bareme(integer, integer); Type: FUNCTION; Schema: contraintes; Owner: pgsql
--

CREATE FUNCTION af_get_evaluation_bareme(integer, integer) RETURNS integer
    AS $_$-- $1 : serie
-- $2 : evaluation
declare
rec record;
rec_serie record;
aleatoire boolean;
begin
    -- si serie aleatoire monotheme ou multitheme
/*
    select into aleatoire * from contraintes.af_is_serie_aleatoire($1);
    if aleatoire is true then
	select into rec * from contraintes.af_get_serie_aleatoire($1) 
	as (id int4,libelle varchar,bareme int4,chrono int4,type int4,date_creation timestamp);
	
    else
	-- recup bareme de l'evaluation
	select into rec * from contraintes.af_get_serie_evaluation($1,$2) as (evaluation int4, libelle varchar, serie int4, pere int4, commentaire varchar, bareme int4, chrono int4, points int4, type int4 );    
	if rec.bareme is null then
	    select into rec * from contraintes.af_get_serie($1) as (id int4, libelle varchar, bareme int4, chrono int4, date_creation timestamp);
	
        end if;
    end if;
*/

    -- recup bareme evaluation

    select into rec * from contraintes.af_get_serie_evaluation($1,$2) as (evaluation int4, libelle varchar, serie int4, pere int4, commentaire varchar, bareme int4, chrono int4, points int4, type int4 );    
    if rec.bareme is null then
	-- recup bareme serie
	select into rec * from contraintes.af_get_serie($1) as (id int4, libelle varchar, bareme int4, chrono int4, date_creation timestamp);
	if rec.bareme is null then
	    -- si serie aleatoire monotheme ou multitheme
	    select into aleatoire * from contraintes.af_is_serie_aleatoire($1);
	    if aleatoire is true then
		select into rec * from contraintes.af_get_serie_aleatoire($1) 
		as (id int4,libelle varchar,bareme int4,chrono int4,type int4,date_creation timestamp);
	    end if;
	end if;
    end if;

    --raise notice 'bareme=%',rec.bareme;
    return rec.bareme;
end;$_$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_get_evaluation_bareme(integer, integer) OWNER TO pgsql;

--
-- TOC entry 7504 (class 0 OID 0)
-- Dependencies: 1839
-- Name: FUNCTION af_get_evaluation_bareme(integer, integer); Type: COMMENT; Schema: contraintes; Owner: pgsql
--

COMMENT ON FUNCTION af_get_evaluation_bareme(integer, integer) IS 'retourne le n° de bareme d''une evaluation de serie';


--
-- TOC entry 1840 (class 1255 OID 2595772)
-- Dependencies: 2983 5
-- Name: af_get_evaluation_point(integer, integer); Type: FUNCTION; Schema: contraintes; Owner: pgsql
--

CREATE FUNCTION af_get_evaluation_point(integer, integer) RETURNS integer
    AS $_$-- $1 : serie
-- $2 : evaluation
declare
rec record;
aleatoire boolean;
rec_aleatoire record;
val_type integer;
begin
    val_type:=0;
    -- si serie aleatoire on retourne 1
    select into aleatoire * from contraintes.af_is_serie_aleatoire($1);
    if aleatoire is true then
	-- recup type aleatoire
	select into rec_aleatoire * from contraintes.af_get_serie_aleatoire($1)
	as (id int4,libelle varchar,bareme int4,chrono int4,type int4,date_creation timestamp);
	val_type:=rec_aleatoire.type;
    end if;
    if aleatoire is true and (val_type=2 or val_type=3) then
	return 1;
    end if;
    select into rec * from contraintes.af_get_serie_evaluation($1,$2) as (evaluation int4, libelle varchar, serie int4, pere int4, commentaire varchar, bareme int4, chrono int4, points int4, type int4 );  
    return rec.points;
end;$_$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_get_evaluation_point(integer, integer) OWNER TO pgsql;

--
-- TOC entry 7506 (class 0 OID 0)
-- Dependencies: 1840
-- Name: FUNCTION af_get_evaluation_point(integer, integer); Type: COMMENT; Schema: contraintes; Owner: pgsql
--

COMMENT ON FUNCTION af_get_evaluation_point(integer, integer) IS 'retourne la valeur du point pour une evaluation de serie';


--
-- TOC entry 982 (class 1255 OID 2595773)
-- Dependencies: 2983 5
-- Name: af_get_evaluation_resultats(integer); Type: FUNCTION; Schema: contraintes; Owner: pgsql
--

CREATE FUNCTION af_get_evaluation_resultats(integer) RETURNS SETOF record
    AS $_$-- $1 : evaluation
declare
rec record;
begin
    for rec in
	select * from contraintes.resultat_serie where evaluation=$1
    loop
	return next rec;
    end loop;
end;$_$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_get_evaluation_resultats(integer) OWNER TO pgsql;

--
-- TOC entry 7508 (class 0 OID 0)
-- Dependencies: 982
-- Name: FUNCTION af_get_evaluation_resultats(integer); Type: COMMENT; Schema: contraintes; Owner: pgsql
--

COMMENT ON FUNCTION af_get_evaluation_resultats(integer) IS 'retourne les identifiants de resultat pour une evaluation';


--
-- TOC entry 983 (class 1255 OID 2595774)
-- Dependencies: 2983 5
-- Name: af_get_evaluation_series(integer); Type: FUNCTION; Schema: contraintes; Owner: postgres
--

CREATE FUNCTION af_get_evaluation_series(integer) RETURNS SETOF record
    AS $_$declare
rec record;

begin
	
	for rec in
		select serie, E.libelle, evaluation from contraintes.serie_evaluations, contraintes.etape E where evaluation=$1
		AND serie= E.id order by E.libelle
	loop
		return next rec;
	end loop;
	return;
	
end;$_$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_get_evaluation_series(integer) OWNER TO postgres;

--
-- TOC entry 7510 (class 0 OID 0)
-- Dependencies: 983
-- Name: FUNCTION af_get_evaluation_series(integer); Type: COMMENT; Schema: contraintes; Owner: postgres
--

COMMENT ON FUNCTION af_get_evaluation_series(integer) IS 'Obtenir les sÃ©ries pour une evaluation donnÃ©e (auteur : Said)';


--
-- TOC entry 984 (class 1255 OID 2595775)
-- Dependencies: 2983 5
-- Name: af_get_evaluation_type(integer); Type: FUNCTION; Schema: contraintes; Owner: pgsql
--

CREATE FUNCTION af_get_evaluation_type(integer) RETURNS record
    AS $_$DECLARE
rec RECORD;
BEGIN

	
	SELECT INTO rec id, libelle, code, couleur FROM contraintes.evaluation_type
	WHERE id=$1;

	RETURN rec ;
END$_$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_get_evaluation_type(integer) OWNER TO pgsql;

--
-- TOC entry 985 (class 1255 OID 2595776)
-- Dependencies: 2983 5
-- Name: af_get_evaluation_types(); Type: FUNCTION; Schema: contraintes; Owner: pgsql
--

CREATE FUNCTION af_get_evaluation_types() RETURNS SETOF record
    AS $$DECLARE
rec RECORD;
BEGIN

	FOR rec IN
		SELECT * FROM contraintes.evaluation_type
	LOOP
		RETURN NEXT rec;
	END LOOP;

	RETURN;
END$$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_get_evaluation_types() OWNER TO pgsql;

--
-- TOC entry 986 (class 1255 OID 2595777)
-- Dependencies: 2983 5
-- Name: af_get_evenement_intervenants(integer); Type: FUNCTION; Schema: contraintes; Owner: pgsql
--

CREATE FUNCTION af_get_evenement_intervenants(integer) RETURNS SETOF record
    AS $_$-- $1 : modalite (si <> 0)
declare
rec record;
req varchar;
begin
    if $1!=0 then
	req :='select distinct id,nom,prenom from contraintes.fw_individu,contraintes.evenement where id=intervenant and modalite='||$1;	
    else
	req :='select distinct id,nom,prenom from contraintes.fw_individu,contraintes.evenement where id=intervenant';
    end if;
    for rec in
	execute req
    loop
	return next rec;
    end loop;
end;$_$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_get_evenement_intervenants(integer) OWNER TO pgsql;

--
-- TOC entry 7514 (class 0 OID 0)
-- Dependencies: 986
-- Name: FUNCTION af_get_evenement_intervenants(integer); Type: COMMENT; Schema: contraintes; Owner: pgsql
--

COMMENT ON FUNCTION af_get_evenement_intervenants(integer) IS 'retourne les intervenants d''evenement';


--
-- TOC entry 987 (class 1255 OID 2595778)
-- Dependencies: 2983 5
-- Name: af_get_evenements(); Type: FUNCTION; Schema: contraintes; Owner: pgsql
--

CREATE FUNCTION af_get_evenements() RETURNS SETOF record
    AS $$declare
rec record;
begin
    for rec in
	select formation,libelle,date,duree,modalite,intervention,intervenant,salle 
	from contraintes.evenement 
    loop
	return next rec;
    end loop;
end;$$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_get_evenements() OWNER TO pgsql;

--
-- TOC entry 7516 (class 0 OID 0)
-- Dependencies: 987
-- Name: FUNCTION af_get_evenements(); Type: COMMENT; Schema: contraintes; Owner: pgsql
--

COMMENT ON FUNCTION af_get_evenements() IS 'retourne les evenements de la plateforme';


--
-- TOC entry 988 (class 1255 OID 2595779)
-- Dependencies: 2983 5
-- Name: af_get_evenements_dates(date, time without time zone, time without time zone); Type: FUNCTION; Schema: contraintes; Owner: pgsql
--

CREATE FUNCTION af_get_evenements_dates(date, time without time zone, time without time zone) RETURNS SETOF record
    AS $_$-- $1 : date de l'evenement
-- $2 : heure debut
-- $3 : heure fin
declare
rec record;
begin
    for rec in
	select formation,libelle,date,duree,modalite,intervention,intervenant,salle 
	from contraintes.evenement 
	where cast(date as date) =$1
	and ((
	    cast(date as time)>=$2 and cast(date as time)<=$3
	)
	or (
	    cast(date as time)<=$2 and 	cast(date as time) +  duree >=$2)
	)
    loop
	return next rec;
    end loop;
	return;
end;$_$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_get_evenements_dates(date, time without time zone, time without time zone) OWNER TO pgsql;

--
-- TOC entry 7518 (class 0 OID 0)
-- Dependencies: 988
-- Name: FUNCTION af_get_evenements_dates(date, time without time zone, time without time zone); Type: COMMENT; Schema: contraintes; Owner: pgsql
--

COMMENT ON FUNCTION af_get_evenements_dates(date, time without time zone, time without time zone) IS 'retourne les evenements en fonction des dates,debut et fin';


--
-- TOC entry 989 (class 1255 OID 2595780)
-- Dependencies: 2983 5
-- Name: af_get_exotlc(integer, integer); Type: FUNCTION; Schema: contraintes; Owner: pgsql
--

CREATE FUNCTION af_get_exotlc(integer, integer) RETURNS record
    AS $_$-- $1 : numero exotlc
-- $2 : type exo (1=plateforme,2=mail)
declare
rec record;
begin
    if $2=1 then
	select into rec 
	E.id,ET.libelle,EP.fichier_rendu,E.commentaire,E.texte,E.enonce,E.remarque,E.type, ET.date_creation ,autocorrection
	from contraintes.etape ET,contraintes.exotlc E,contraintes.exotlc_plate_forme EP 
	where E.id=$1 and ET.id=$1 and EP.id=$1;
    elseif $2=2 then
	select into rec 
	E.id,ET.libelle, EM.formateur,E.commentaire,E.texte,E.enonce,E.remarque,E.type , ET.date_creation 
	from contraintes.etape ET,contraintes.exotlc E,contraintes.exotlc_mail EM
	where E.id=$1 and ET.id=$1 and EM.id=$1;
    ELSE
	RAISE EXCEPTION 'Le type d''exotlc % n''est pas connu.', $2;
    end if;
    return rec;
end;$_$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_get_exotlc(integer, integer) OWNER TO pgsql;

--
-- TOC entry 7520 (class 0 OID 0)
-- Dependencies: 989
-- Name: FUNCTION af_get_exotlc(integer, integer); Type: COMMENT; Schema: contraintes; Owner: pgsql
--

COMMENT ON FUNCTION af_get_exotlc(integer, integer) IS 'retourne les infos d''un exotlc';


--
-- TOC entry 990 (class 1255 OID 2595781)
-- Dependencies: 2983 5
-- Name: af_get_exotlc_fichier(integer); Type: FUNCTION; Schema: contraintes; Owner: pgsql
--

CREATE FUNCTION af_get_exotlc_fichier(integer) RETURNS integer
    AS $_$DECLARE
--$1 le numero du fichier
exotlc_id int4;
BEGIN

	SELECT INTO exotlc_id id FROM contraintes.exotlc_fichiers
	WHERE fichier=$1;

	RETURN exotlc_id;

END$_$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_get_exotlc_fichier(integer) OWNER TO pgsql;

--
-- TOC entry 7522 (class 0 OID 0)
-- Dependencies: 990
-- Name: FUNCTION af_get_exotlc_fichier(integer); Type: COMMENT; Schema: contraintes; Owner: pgsql
--

COMMENT ON FUNCTION af_get_exotlc_fichier(integer) IS 'Obtenir l''identifiant d''un exotcl a partir de son numero de fichier.';


--
-- TOC entry 991 (class 1255 OID 2595782)
-- Dependencies: 2983 5
-- Name: af_get_exotlc_fichiers(integer); Type: FUNCTION; Schema: contraintes; Owner: pgsql
--

CREATE FUNCTION af_get_exotlc_fichiers(integer) RETURNS SETOF record
    AS $_$-- $1 numero exotlc
declare
rec record;
begin
    for rec in
	select F.id,F.libelle from contraintes.fichier F,contraintes.exotlc_fichiers EF 
	where EF.exotlc=$1 and F.id=EF.fichier
    loop
	return next rec;
    end loop;
    return;
end;$_$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_get_exotlc_fichiers(integer) OWNER TO pgsql;

--
-- TOC entry 7524 (class 0 OID 0)
-- Dependencies: 991
-- Name: FUNCTION af_get_exotlc_fichiers(integer); Type: COMMENT; Schema: contraintes; Owner: pgsql
--

COMMENT ON FUNCTION af_get_exotlc_fichiers(integer) IS 'retourne les fichiers d''un exotlc';


--
-- TOC entry 992 (class 1255 OID 2595783)
-- Dependencies: 2983 5
-- Name: af_get_exotlc_fichiers_correction(integer); Type: FUNCTION; Schema: contraintes; Owner: pgsql
--

CREATE FUNCTION af_get_exotlc_fichiers_correction(integer) RETURNS SETOF record
    AS $_$-- $1 : numero exotlc
declare
rec record;
begin
    for rec in 
	select F.id,F.libelle from contraintes.fichier F,contraintes.exotlc_corrections EC 
	where EC.exotlc=$1 and F.id=EC.correction
    loop
	return next rec;
    end loop;
    return;
end;$_$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_get_exotlc_fichiers_correction(integer) OWNER TO pgsql;

--
-- TOC entry 7526 (class 0 OID 0)
-- Dependencies: 992
-- Name: FUNCTION af_get_exotlc_fichiers_correction(integer); Type: COMMENT; Schema: contraintes; Owner: pgsql
--

COMMENT ON FUNCTION af_get_exotlc_fichiers_correction(integer) IS 'Obtenir les fichiers de correction d''un exotlc';


--
-- TOC entry 993 (class 1255 OID 2595784)
-- Dependencies: 2983 5
-- Name: af_get_exotlc_mail(integer); Type: FUNCTION; Schema: contraintes; Owner: pgsql
--

CREATE FUNCTION af_get_exotlc_mail(integer) RETURNS record
    AS $_$-- $1 : numero exotlc
declare
rec record;
begin
    select into rec 
	id,libelle, formateur ,commentaire,texte,enonce,remarque,type, date_creation 
	from contraintes.af_get_exotlc($1,2) AS (id integer,libelle character varying,formateur integer,commentaire text,texte text,enonce text,remarque text,type integer,date_creation timestamp);
    return rec;
end;$_$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_get_exotlc_mail(integer) OWNER TO pgsql;

--
-- TOC entry 7528 (class 0 OID 0)
-- Dependencies: 993
-- Name: FUNCTION af_get_exotlc_mail(integer); Type: COMMENT; Schema: contraintes; Owner: pgsql
--

COMMENT ON FUNCTION af_get_exotlc_mail(integer) IS 'retourne les infos d''un exotlc mail';


--
-- TOC entry 994 (class 1255 OID 2595785)
-- Dependencies: 2983 5
-- Name: af_get_exotlc_modele_correction(integer); Type: FUNCTION; Schema: contraintes; Owner: pgsql
--

CREATE FUNCTION af_get_exotlc_modele_correction(integer) RETURNS record
    AS $_$DECLARE
--$1 exotlc
id_modele integer;
rec RECORD;
BEGIN
	SELECT INTO id_modele modele_correction FROM contraintes.exotlc_modele_correction
	WHERE id=$1;

	IF id_modele IS NOT NULL THEN
		SELECT INTO rec * from contraintes.af_get_template(id_modele) as (id int4,libelle varchar);
		RETURN rec;
	ELSE
		RETURN NULL;
	END IF;
	
END;$_$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_get_exotlc_modele_correction(integer) OWNER TO pgsql;

--
-- TOC entry 995 (class 1255 OID 2595786)
-- Dependencies: 2983 5
-- Name: af_get_exotlc_plate_forme(integer); Type: FUNCTION; Schema: contraintes; Owner: pgsql
--

CREATE FUNCTION af_get_exotlc_plate_forme(integer) RETURNS record
    AS $_$-- $1 : numero exotlc
declare
rec record;
begin
    select into rec 
	id,libelle, fichier_rendu ,commentaire,texte,enonce,remarque,type, date_creation , autocorrection
	from contraintes.af_get_exotlc($1,1) AS (id integer,libelle character varying,fichier_rendu character varying,commentaire text,texte text,enonce text,remarque text,type integer,date_creation timestamp,autocorrection boolean);
    return rec;
end;$_$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_get_exotlc_plate_forme(integer) OWNER TO pgsql;

--
-- TOC entry 7531 (class 0 OID 0)
-- Dependencies: 995
-- Name: FUNCTION af_get_exotlc_plate_forme(integer); Type: COMMENT; Schema: contraintes; Owner: pgsql
--

COMMENT ON FUNCTION af_get_exotlc_plate_forme(integer) IS 'retourne les infos d''un exotlc plateforme';


--
-- TOC entry 996 (class 1255 OID 2595787)
-- Dependencies: 2983 5
-- Name: af_get_exotlc_stagiaires_corriges_formation(integer, integer, integer, boolean); Type: FUNCTION; Schema: contraintes; Owner: pgsql
--

CREATE FUNCTION af_get_exotlc_stagiaires_corriges_formation(integer, integer, integer, boolean) RETURNS SETOF record
    AS $_$-- $1 : exotlc (etape)
-- $2 : parcours
-- $3 : formation
-- $4 : bool (true -> corrige, false -> non corrige)
declare
rec record;
begin
    for rec in 
	select I.id,I.nom,I.prenom
	
	from contraintes.fw_individu I,
	contraintes.af_get_etape_resultats($1) as (ger_id int8, formation int4,   stagiaire int4, parcours int4,  etape int4, date_debut timestamp, duree interval)
	left outer join 
	contraintes.resultat_exotlc re on (ger_id=re.id)
	where I.id=stagiaire and formation=$3 and parcours=$2 
	group by I.id,I.nom,I.prenom ,re.date_correction
	having (CAST(case when re.date_correction is null then false else true end AS boolean)=cast($4 as boolean ))

	
    loop
	return next rec;
    end loop;
    return;
end;$_$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_get_exotlc_stagiaires_corriges_formation(integer, integer, integer, boolean) OWNER TO pgsql;

--
-- TOC entry 7533 (class 0 OID 0)
-- Dependencies: 996
-- Name: FUNCTION af_get_exotlc_stagiaires_corriges_formation(integer, integer, integer, boolean); Type: COMMENT; Schema: contraintes; Owner: pgsql
--

COMMENT ON FUNCTION af_get_exotlc_stagiaires_corriges_formation(integer, integer, integer, boolean) IS 'retourne les stagiaires corriges ou non corriges pour un exotlc et une formation';


--
-- TOC entry 997 (class 1255 OID 2595788)
-- Dependencies: 2983 5
-- Name: af_get_exotlc_stagiaires_fichier_rendu(integer, integer, integer); Type: FUNCTION; Schema: contraintes; Owner: pgsql
--

CREATE FUNCTION af_get_exotlc_stagiaires_fichier_rendu(integer, integer, integer) RETURNS SETOF record
    AS $_$-- $1 : formation
-- $2 : parcours
-- $3 : exotlc
declare
rec record;
begin
    for rec in 
	select i.id,nom,prenom,re.fichier_rendu from contraintes.fw_individu i,contraintes.resultat r,contraintes.resultat_exotlc re  
	where i.id=r.stagiaire and r.formation=$1 and r.parcours=$2 and r.etape=$3 and r.id=re.id 
    loop
	return next rec;
    end loop;
end;$_$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_get_exotlc_stagiaires_fichier_rendu(integer, integer, integer) OWNER TO pgsql;

--
-- TOC entry 7535 (class 0 OID 0)
-- Dependencies: 997
-- Name: FUNCTION af_get_exotlc_stagiaires_fichier_rendu(integer, integer, integer); Type: COMMENT; Schema: contraintes; Owner: pgsql
--

COMMENT ON FUNCTION af_get_exotlc_stagiaires_fichier_rendu(integer, integer, integer) IS 'retourne les stagiaires qui ont rendu leur fichier pour un exotlc';


--
-- TOC entry 998 (class 1255 OID 2595789)
-- Dependencies: 2983 5
-- Name: af_get_exotlc_type(integer); Type: FUNCTION; Schema: contraintes; Owner: pgsql
--

CREATE FUNCTION af_get_exotlc_type(integer) RETURNS integer
    AS $_$-- $1 : numero exotlc
declare
res int4;
begin
    select into res type from contraintes.exotlc where id=$1;
    return res;
end;  $_$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_get_exotlc_type(integer) OWNER TO pgsql;

--
-- TOC entry 7537 (class 0 OID 0)
-- Dependencies: 998
-- Name: FUNCTION af_get_exotlc_type(integer); Type: COMMENT; Schema: contraintes; Owner: pgsql
--

COMMENT ON FUNCTION af_get_exotlc_type(integer) IS 'retourne le type d''un exotlc';


--
-- TOC entry 999 (class 1255 OID 2595790)
-- Dependencies: 2983 5
-- Name: af_get_exotlcs(); Type: FUNCTION; Schema: contraintes; Owner: pgsql
--

CREATE FUNCTION af_get_exotlcs() RETURNS SETOF record
    AS $$declare
rec record;
begin
    for rec in 
	select id,commentaire,texte,enonce,remarque,type
	from contraintes.exotlc
    loop
	return next rec;
    end loop;
    return;
end;$$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_get_exotlcs() OWNER TO pgsql;

--
-- TOC entry 7539 (class 0 OID 0)
-- Dependencies: 999
-- Name: FUNCTION af_get_exotlcs(); Type: COMMENT; Schema: contraintes; Owner: pgsql
--

COMMENT ON FUNCTION af_get_exotlcs() IS 'retourne les exo tlc de la plateforme';


--
-- TOC entry 1000 (class 1255 OID 2595791)
-- Dependencies: 2983 5
-- Name: af_get_fichier(integer); Type: FUNCTION; Schema: contraintes; Owner: postgres
--

CREATE FUNCTION af_get_fichier(integer) RETURNS record
    AS $_$DECLARE
rec RECORD;
BEGIN

	SELECT into rec * FROM contraintes.af_get_fichiers() AS ( id int4, libelle varchar, "type" int4, connecte bool)
	WHERE id=$1;

	RETURN rec;
END$_$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_get_fichier(integer) OWNER TO postgres;

--
-- TOC entry 7541 (class 0 OID 0)
-- Dependencies: 1000
-- Name: FUNCTION af_get_fichier(integer); Type: COMMENT; Schema: contraintes; Owner: postgres
--

COMMENT ON FUNCTION af_get_fichier(integer) IS 'Obtenir les informations d''un fichier.';


--
-- TOC entry 1001 (class 1255 OID 2595792)
-- Dependencies: 2983 5
-- Name: af_get_fichier_glossaire(integer); Type: FUNCTION; Schema: contraintes; Owner: pgsql
--

CREATE FUNCTION af_get_fichier_glossaire(integer) RETURNS record
    AS $_$DECLARE
--$1 identifiant du fichier
rec RECORD;
BEGIN
	SELECT into rec F_id, F_libelle, F_type , F_connecte,  FG.date_modification, G.libelle, G.id
	FROM contraintes.af_get_fichier($1) AS ( F_id int4, F_libelle varchar, F_type int4, F_connecte bool),
	contraintes.fichier_glossaire FG,
	contraintes.glossaire G
	WHERE FG.id=$1
	AND FG.id=F_id
	AND G.fichier=F_id;
	
	
	RETURN rec;
END$_$
    LANGUAGE plpgsql STRICT;


ALTER FUNCTION contraintes.af_get_fichier_glossaire(integer) OWNER TO pgsql;

--
-- TOC entry 7543 (class 0 OID 0)
-- Dependencies: 1001
-- Name: FUNCTION af_get_fichier_glossaire(integer); Type: COMMENT; Schema: contraintes; Owner: pgsql
--

COMMENT ON FUNCTION af_get_fichier_glossaire(integer) IS 'obtenir les informations d''un fichier de glossaire.';


--
-- TOC entry 1830 (class 1255 OID 2962559)
-- Dependencies: 2983 5
-- Name: af_get_fichier_metadata(integer); Type: FUNCTION; Schema: contraintes; Owner: www
--

CREATE FUNCTION af_get_fichier_metadata(integer) RETURNS record
    AS $_$DECLARE
rec RECORD;
BEGIN
	SELECT into rec  F_id , libelle ,  type, mots_cles, individu, connecte
	FROM contraintes.af_get_fichiers() AS ( F_id int4, libelle varchar, "type" int4, connecte bool),
	contraintes.fichier_metadata FM
	WHERE F_id=$1
	AND F_id=FM.id;

	RETURN rec;

END$_$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_get_fichier_metadata(integer) OWNER TO www;

--
-- TOC entry 1002 (class 1255 OID 2595793)
-- Dependencies: 2983 5
-- Name: af_get_fichier_scenario_dynamique(integer); Type: FUNCTION; Schema: contraintes; Owner: pgsql
--

CREATE FUNCTION af_get_fichier_scenario_dynamique(integer) RETURNS record
    AS $_$DECLARE
--$1 identifiant du fichier
rec RECORD;
BEGIN
	SELECT into rec F_id, F_libelle, F_type , F_connecte, SD.style, SD.date_modification
	FROM contraintes.af_get_fichier($1) AS ( F_id int4, F_libelle varchar, F_type int4, F_connecte bool),
	contraintes.fichier_scenario_dynamique SD
	WHERE SD.id=$1
	AND SD.id=F_id;
	
	RETURN rec;
END$_$
    LANGUAGE plpgsql STRICT;


ALTER FUNCTION contraintes.af_get_fichier_scenario_dynamique(integer) OWNER TO pgsql;

--
-- TOC entry 7546 (class 0 OID 0)
-- Dependencies: 1002
-- Name: FUNCTION af_get_fichier_scenario_dynamique(integer); Type: COMMENT; Schema: contraintes; Owner: pgsql
--

COMMENT ON FUNCTION af_get_fichier_scenario_dynamique(integer) IS 'obtenir les informations d''un fichier de scenario dynamique.';


--
-- TOC entry 1003 (class 1255 OID 2595794)
-- Dependencies: 2983 5
-- Name: af_get_fichier_scenario_dynamique_bloc(integer, integer); Type: FUNCTION; Schema: contraintes; Owner: pgsql
--

CREATE FUNCTION af_get_fichier_scenario_dynamique_bloc(integer, integer) RETURNS record
    AS $_$DECLARE
rec RECORD;
BEGIN
	SELECT INTO rec * FROM contraintes.af_get_fichier_scenario_dynamique_blocs($1) 
	AS (id integer,libelle varchar, ordre integer, var_keys text[], var_values text, scenario integer)
	WHERE ordre=$2;

	RETURN rec;
END;$_$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_get_fichier_scenario_dynamique_bloc(integer, integer) OWNER TO pgsql;

--
-- TOC entry 1004 (class 1255 OID 2595795)
-- Dependencies: 2983 5
-- Name: af_get_fichier_scenario_dynamique_blocs(integer); Type: FUNCTION; Schema: contraintes; Owner: pgsql
--

CREATE FUNCTION af_get_fichier_scenario_dynamique_blocs(integer) RETURNS SETOF record
    AS $_$DECLARE
rec RECORD;
BEGIN
	FOR rec IN
		SELECT FBS.id,F.libelle, FSDB.ordre, FSDB.bloc_vars_keys,FSDB.bloc_vars_values, FSDB.id
		FROM contraintes.fichier_scenario_dynamique_blocs FSDB,
		contraintes.fichier_bloc_scenario FBS,
		contraintes.fichier F
		WHERE FSDB.id=$1
		AND FSDB.fichier_bloc_scenario=FBS.id
		AND FBS.id=F.id
		ORDER BY FSDB.ordre
	LOOP
		RETURN NEXT rec;
	END LOOP;

	RETURN;
END;$_$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_get_fichier_scenario_dynamique_blocs(integer) OWNER TO pgsql;

--
-- TOC entry 1005 (class 1255 OID 2595796)
-- Dependencies: 2983 5
-- Name: af_get_fichier_scenario_dynamique_blocs_type(integer); Type: FUNCTION; Schema: contraintes; Owner: pgsql
--

CREATE FUNCTION af_get_fichier_scenario_dynamique_blocs_type(integer) RETURNS integer
    AS $_$DECLARE
rec RECORD;
BEGIN

	FOR rec IN 
		SELECT COUNT(DISTINCT F.type) AS nb, F.type AS typ
		FROM contraintes.fichier_scenario_dynamique_blocs FSDB,
		contraintes.fichier F
		WHERE FSDB.id=$1
		AND FSDB.fichier_bloc_scenario=F.id
		GROUP BY F.type
	LOOP
		RAISE NOTICE '% > %',rec.nb,rec.typ;
		IF rec.nb>1 THEN
			RAISE EXCEPTION 'Le fichier scenario dynamique est corrompu: type de bloc differents';
		ELSEIF rec.nb = 0 THEN
			RETURN NULL;
		ELSE 
			RETURN rec.typ;
		END IF;

		RETURN NULL;
	END LOOP;
	RETURN NULL;
END;$_$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_get_fichier_scenario_dynamique_blocs_type(integer) OWNER TO pgsql;

--
-- TOC entry 1006 (class 1255 OID 2595797)
-- Dependencies: 2983 5
-- Name: af_get_fichier_scenario_dynamique_slide(integer, integer); Type: FUNCTION; Schema: contraintes; Owner: pgsql
--

CREATE FUNCTION af_get_fichier_scenario_dynamique_slide(integer, integer) RETURNS record
    AS $_$DECLARE
rec RECORD;
BEGIN
	SELECT INTO rec * FROM contraintes.af_get_fichier_scenario_dynamique_slides($1) 
	AS (id integer,libelle varchar, ordre integer, var_keys text[], var_values text, scenario integer)
	WHERE ordre=$2;

	RETURN rec;
END;$_$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_get_fichier_scenario_dynamique_slide(integer, integer) OWNER TO pgsql;

--
-- TOC entry 1007 (class 1255 OID 2595798)
-- Dependencies: 2983 5
-- Name: af_get_fichier_scenario_dynamique_slides(integer); Type: FUNCTION; Schema: contraintes; Owner: pgsql
--

CREATE FUNCTION af_get_fichier_scenario_dynamique_slides(integer) RETURNS SETOF record
    AS $_$DECLARE
rec RECORD;
BEGIN
	FOR rec IN
		SELECT FBS.id,F.libelle, FSDB.ordre, FSDB.bloc_vars_keys,FSDB.bloc_vars_values, FSDB.id
		FROM contraintes.fichier_scenario_dynamique_blocs FSDB,
		contraintes.fichier_slide_scenario FBS,
		contraintes.fichier F
		WHERE FSDB.id=$1
		AND FSDB.fichier_bloc_scenario=FBS.id
		AND FBS.id=F.id
		ORDER BY FSDB.ordre
	LOOP
		RETURN NEXT rec;
	END LOOP;

	RETURN;
END;$_$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_get_fichier_scenario_dynamique_slides(integer) OWNER TO pgsql;

--
-- TOC entry 1008 (class 1255 OID 2595799)
-- Dependencies: 2983 5
-- Name: af_get_fichier_texte(integer); Type: FUNCTION; Schema: contraintes; Owner: pgsql
--

CREATE FUNCTION af_get_fichier_texte(integer) RETURNS record
    AS $_$DECLARE
--$1 identifiant du fichier
rec RECORD;
BEGIN
	SELECT into rec F_id, F_libelle, F_type , F_connecte, libelle, adresse, description, mise_en_forme, TO_CHAR(date_modification,'DD/MM/YYYY') FROM contraintes.af_get_fichiers() AS ( F_id int4, F_libelle varchar, F_type int4, F_connecte bool),
	contraintes.fichier_ressource_texte
	WHERE F_id=$1
	AND F_id=id;
	
	RETURN rec;
END$_$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_get_fichier_texte(integer) OWNER TO pgsql;

--
-- TOC entry 7553 (class 0 OID 0)
-- Dependencies: 1008
-- Name: FUNCTION af_get_fichier_texte(integer); Type: COMMENT; Schema: contraintes; Owner: pgsql
--

COMMENT ON FUNCTION af_get_fichier_texte(integer) IS 'obtenir les informations d''un fichier texte.';


--
-- TOC entry 19 (class 1255 OID 2595800)
-- Dependencies: 2983 5
-- Name: af_get_fichier_type(integer); Type: FUNCTION; Schema: contraintes; Owner: postgres
--

CREATE FUNCTION af_get_fichier_type(integer) RETURNS record
    AS $_$-- $1 : type
declare
rec record;
begin
    select into rec id,libelle,code,categorie from contraintes.fichier_type where id=$1;
    return rec;
end;$_$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_get_fichier_type(integer) OWNER TO postgres;

--
-- TOC entry 7555 (class 0 OID 0)
-- Dependencies: 19
-- Name: FUNCTION af_get_fichier_type(integer); Type: COMMENT; Schema: contraintes; Owner: postgres
--

COMMENT ON FUNCTION af_get_fichier_type(integer) IS 'retourne les infos d''un type de fichier';


--
-- TOC entry 1009 (class 1255 OID 2595801)
-- Dependencies: 2983 5
-- Name: af_get_fichiers(); Type: FUNCTION; Schema: contraintes; Owner: postgres
--

CREATE FUNCTION af_get_fichiers() RETURNS SETOF record
    AS $$DECLARE
rec record;
BEGIN

	for rec in
		select * from contraintes.fichier
	loop
		return next rec;
	end loop;

	return;
END;$$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_get_fichiers() OWNER TO postgres;

--
-- TOC entry 7557 (class 0 OID 0)
-- Dependencies: 1009
-- Name: FUNCTION af_get_fichiers(); Type: COMMENT; Schema: contraintes; Owner: postgres
--

COMMENT ON FUNCTION af_get_fichiers() IS 'Obtenirs tous les fichiers de la plate-forme.';


--
-- TOC entry 1010 (class 1255 OID 2595802)
-- Dependencies: 2983 5
-- Name: af_get_fichiers_type(integer); Type: FUNCTION; Schema: contraintes; Owner: postgres
--

CREATE FUNCTION af_get_fichiers_type(integer) RETURNS SETOF record
    AS $_$--$1 le typo de fichier voulu
DECLARE
rec record;
BEGIN
	
	FOR rec IN
		select * from contraintes.af_get_fichiers()AS ( id int4, libelle varchar, "type" int4, connecte bool) where "type" = $1
	LOOP
		RETURN NEXT rec;
	END LOOP;
	
	RETURN;
END$_$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_get_fichiers_type(integer) OWNER TO postgres;

--
-- TOC entry 7559 (class 0 OID 0)
-- Dependencies: 1010
-- Name: FUNCTION af_get_fichiers_type(integer); Type: COMMENT; Schema: contraintes; Owner: postgres
--

COMMENT ON FUNCTION af_get_fichiers_type(integer) IS 'Obtenir tous les fichiers d''un type particulier.
';


--
-- TOC entry 1011 (class 1255 OID 2595803)
-- Dependencies: 2983 5
-- Name: af_get_filiere(integer); Type: FUNCTION; Schema: contraintes; Owner: pgsql
--

CREATE FUNCTION af_get_filiere(integer) RETURNS record
    AS $_$DECLARE
--$1 filiere
rec RECORD;
BEGIN
	SELECT INTO rec id, libelle, pere FROM contraintes.filiere
	WHERE id=$1;

	RETURN rec;
END;$_$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_get_filiere(integer) OWNER TO pgsql;

--
-- TOC entry 1012 (class 1255 OID 2595804)
-- Dependencies: 2983 5
-- Name: af_get_filiere_etapes_disponibles_theme(integer, integer); Type: FUNCTION; Schema: contraintes; Owner: pgsql
--

CREATE FUNCTION af_get_filiere_etapes_disponibles_theme(integer, integer) RETURNS SETOF record
    AS $_$DECLARE
--$1 filiere
--$2 theme
rec RECORD;
sous_type contraintes.type_element;
rec_spe RECORD;
rec_ss_parcours RECORD;
BEGIN
	FOR rec IN 
		SELECT I_D AS id,  E.libelle AS libelle,CAST(E.type AS varchar) AS type, T.libelle  AS libelle_type
		FROM contraintes.etape E 
		LEFT OUTER JOIN contraintes.af_get_categorie_elements_theme(29 ,$2) I_D
		ON E.id=I_D,contraintes.etape_type T
		WHERE I_D IS NOT NULL
		AND E.type=T.id
		ORDER BY E.type

	LOOP
		--Cas speciaux: les types ayant des sous types
		SELECT INTO sous_type * FROM contraintes.af_get_etape_type_sous_type(rec.id, CAST(rec.type AS int4), rec.libelle_type)
		ORDER BY sous_type.id;
		rec.type:=sous_type.id;
		rec.libelle_type:=sous_type.libelle;
		RETURN NEXT rec;
	END LOOP;

	----------------------------------
	--      ETAPES SANS THEMES      --
	----------------------------------

	--les types d'étapes spéciales: forum (2), chat(8) et etape titre(9)
	FOR rec_spe IN 
		SELECT CAST(NULL AS int4) AS id,  CAST(NULL AS varchar) AS  libelle, CAST(id AS varchar) AS type, libelle  AS libelle_type
		FROM contraintes.etape_type T
		WHERE id IN (8,9)
	LOOP
		RETURN NEXT rec_spe;
	END LOOP;

	--les types d'étapes forum (2)
	
	FOR rec_spe IN 
		SELECT P_id,  P_libelle_etape, cast('2' as varchar), T.libelle  AS libelle_type
		FROM contraintes.etape_type T,contraintes.af_get_etapes_forum() as
		(P_id int4,P_libelle_etape varchar,forum int4,libelle varchar,description varchar,moderation bool,moderateur_pwd varchar,fils int4,messages int4,upload bool,theme varchar,configuration int4,date_creation timestamp)
 
		WHERE T.id=2 
	LOOP
		RETURN NEXT rec_spe;
	END LOOP;

	-- type chat(8)

	FOR rec_spe IN 
		SELECT P_id,  P_libelle_etape, cast('8' as varchar), T.libelle  AS libelle_type
		FROM contraintes.etape_type T,contraintes.af_get_etapes_chats() as
		(P_id int4,P_libelle_etape varchar,chat int4,date_creation timestamp)
 
		WHERE T.id=8 
	LOOP
		RETURN NEXT rec_spe;
	END LOOP;
	

	FOR rec_ss_parcours IN 
		SELECT P_id,  P_libelle, CAST('1'AS varchar) AS type, libelle  AS libelle_type
		FROM contraintes.af_get_filiere_sous_parcourss_disponibles($1) AS (P_id int4, P_libelle varchar, filiere int4, duree bool),
		contraintes.etape_type T
		WHERE 1=T.id
	LOOP
		RETURN NEXT rec_ss_parcours;
	END LOOP;

	RETURN;
END;$_$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_get_filiere_etapes_disponibles_theme(integer, integer) OWNER TO pgsql;

--
-- TOC entry 1013 (class 1255 OID 2595805)
-- Dependencies: 2983 5
-- Name: af_get_filiere_formations(integer, character varying, boolean, integer); Type: FUNCTION; Schema: contraintes; Owner: pgsql
--

CREATE FUNCTION af_get_filiere_formations(integer, character varying, boolean, integer) RETURNS SETOF record
    AS $_$DECLARE
--$1 filiere
--$2 ASC(ou n'importe quoi) ou DESC pour le classement du resultat
--$3 TRUE, classement par date de début, ou FALSE classement par libelle
req varchar;
rec record;
BEGIN
	if contraintes.fw_is_root($4) then
	req:='SELECT F.id, F.libelle, F.parcours, F.date_debut, F.date_fin, F.langue, P.filiere FROM contraintes.formation F , contraintes.parcours P
		WHERE P.filiere='||$1||' AND F.parcours=P.id ';
	else
	req:='SELECT F.id, F.libelle, F.parcours, F.date_debut, F.date_fin, F.langue, P.filiere FROM contraintes.formation F , contraintes.parcours P,contraintes.formation_participants fp
		WHERE P.filiere='||$1||' AND F.parcours=P.id and F.id=fp.formation and fp.formateur='||$4;
	end if;

	IF $3 IS TRUE THEN
		req:=req||' ORDER BY F.date_debut';
	ELSE 
		req:=req||' ORDER BY F.libelle';
	END IF;

	IF $2 LIKE 'DESC' THEN
		req:=req||' DESC';
	END IF;
	FOR rec IN
	    EXECUTE req
	LOOP
	    RETURN next rec;
	END LOOP;

		
END;$_$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_get_filiere_formations(integer, character varying, boolean, integer) OWNER TO pgsql;

--
-- TOC entry 7563 (class 0 OID 0)
-- Dependencies: 1013
-- Name: FUNCTION af_get_filiere_formations(integer, character varying, boolean, integer); Type: COMMENT; Schema: contraintes; Owner: pgsql
--

COMMENT ON FUNCTION af_get_filiere_formations(integer, character varying, boolean, integer) IS 'retourne les formations d''une filiere pour le root ou formateur';


--
-- TOC entry 1841 (class 1255 OID 2595806)
-- Dependencies: 2983 5
-- Name: af_get_filiere_libelle_complet(integer); Type: FUNCTION; Schema: contraintes; Owner: pgsql
--

CREATE FUNCTION af_get_filiere_libelle_complet(integer) RETURNS character varying
    AS $_$DECLARE
--$1 filiere
rec_pere RECORD;
libelle_complet varchar;
libelle_part varchar;
BEGIN
	IF $1 IS NULL THEN
		RETURN NULL;
	ELSE
		--selectionne le libelle et le pere de la filiere
		SELECT INTO rec_pere libelle, pere FROM contraintes.filiere
		WHERE id=$1;
		
		--recupere le libelle complet du pere
		SELECT INTO libelle_part * FROM contraintes.af_get_filiere_libelle_complet(rec_pere.pere);
	
		--ajoute le libellé complet du pêre à la filiere pour former le libellé complet de la filiere
		IF libelle_part IS NOT NULL THEN			
			libelle_complet:=libelle_part||'/'||rec_pere.libelle;
		ELSE
			libelle_complet:=rec_pere.libelle;
		END IF;

		RETURN libelle_complet;
	END IF;
END;$_$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_get_filiere_libelle_complet(integer) OWNER TO pgsql;

--
-- TOC entry 1014 (class 1255 OID 2595807)
-- Dependencies: 2983 5
-- Name: af_get_filiere_parcourss(integer); Type: FUNCTION; Schema: contraintes; Owner: pgsql
--

CREATE FUNCTION af_get_filiere_parcourss(integer) RETURNS SETOF record
    AS $_$DECLARE
--$1 filiere
rec RECORD;
BEGIN
	FOR rec IN 
		SELECT E.id, E.libelle, P.filiere, P.duree FROM contraintes.parcours P, contraintes.etape E 
		WHERE P.id=E.id
		AND P.filiere=$1
	LOOP
		RETURN NEXT rec;
	END LOOP;
		
	RETURN;
END$_$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_get_filiere_parcourss(integer) OWNER TO pgsql;

--
-- TOC entry 1015 (class 1255 OID 2595808)
-- Dependencies: 2983 5
-- Name: af_get_filiere_pere(integer); Type: FUNCTION; Schema: contraintes; Owner: postgres
--

CREATE FUNCTION af_get_filiere_pere(integer) RETURNS SETOF record
    AS $_$declare
	id_pere alias for $1;
	req text;
	rec record;
begin
	req:='select * from contraintes.filiere where pere ';
	if (id_pere is null) then
		req:=req||' is null';
	else
		req:=req||'='||id_pere;
	end if;
	for rec in
		execute req
		loop
			return next rec;
		end loop;
	return;
end;$_$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_get_filiere_pere(integer) OWNER TO postgres;

--
-- TOC entry 7567 (class 0 OID 0)
-- Dependencies: 1015
-- Name: FUNCTION af_get_filiere_pere(integer); Type: COMMENT; Schema: contraintes; Owner: postgres
--

COMMENT ON FUNCTION af_get_filiere_pere(integer) IS 'Renvoie les filiÃ¨res associÃ©es Ã  un pÃ¨re.';


--
-- TOC entry 1016 (class 1255 OID 2595809)
-- Dependencies: 2983 5
-- Name: af_get_filiere_sous_filieres(integer); Type: FUNCTION; Schema: contraintes; Owner: pgsql
--

CREATE FUNCTION af_get_filiere_sous_filieres(integer) RETURNS SETOF record
    AS $_$DECLARE
--$1 filiere
rec RECORD;
BEGIN

	IF $1 IS NOT NULL THEN
		FOR rec IN
			SELECT id, libelle, pere FROM contraintes.filiere
			WHERE pere=$1 ORDER BY libelle
		LOOP
			RETURN NEXT rec;
		END LOOP;
	ELSE
		FOR rec IN
			SELECT id, libelle, pere FROM contraintes.filiere
			WHERE pere IS NULL ORDER BY libelle
		LOOP
			RETURN NEXT rec;
		END LOOP;
	END IF;
	RETURN;
END;$_$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_get_filiere_sous_filieres(integer) OWNER TO pgsql;

--
-- TOC entry 1017 (class 1255 OID 2595810)
-- Dependencies: 2983 5
-- Name: af_get_filiere_sous_parcourss_disponibles(integer); Type: FUNCTION; Schema: contraintes; Owner: pgsql
--

CREATE FUNCTION af_get_filiere_sous_parcourss_disponibles(integer) RETURNS SETOF record
    AS $_$DECLARE
--$1 filiere
ss_filieres RECORD;
parcourss RECORD;
BEGIN
	--selection des sous filieres de la filiere
	FOR ss_filieres IN
		SELECT id FROM contraintes.af_get_filiere_sous_filieres($1) AS (id int4, libelle varchar, pere int4)
	LOOP
		--selection des parcours de chacunes des filieres
		FOR parcourss IN
			SELECT * FROM contraintes.af_get_filiere_parcourss(ss_filieres.id) AS (P_id int4, P_libelle varchar, P_filiere int4, P_duree bool)
		LOOP
			RETURN NEXT parcourss;
			
		END LOOP;
		
	END LOOP;
	RETURN;
END;$_$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_get_filiere_sous_parcourss_disponibles(integer) OWNER TO pgsql;

--
-- TOC entry 1018 (class 1255 OID 2595811)
-- Dependencies: 2983 5
-- Name: af_get_filieres(); Type: FUNCTION; Schema: contraintes; Owner: pgsql
--

CREATE FUNCTION af_get_filieres() RETURNS SETOF record
    AS $$DECLARE
rec RECORD;
BEGIN
	FOR rec IN
		SELECT F.id, F.libelle, F.pere, F_ID.ind FROM contraintes.filiere F,
		contraintes.af_gen_get_elements('contraintes.filiere', 'id', NULL, ' ', 0) F_ID
		WHERE F.id=F_ID.id
	LOOP
		RETURN NEXT rec;
	END LOOP;

	RETURN;
END;$$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_get_filieres() OWNER TO pgsql;

--
-- TOC entry 1019 (class 1255 OID 2595812)
-- Dependencies: 2983 5
-- Name: af_get_filieres_formation(); Type: FUNCTION; Schema: contraintes; Owner: pgsql
--

CREATE FUNCTION af_get_filieres_formation() RETURNS SETOF record
    AS $$declare
rec record;
begin
    for rec in 
	select distinct fi.id,fi.libelle,fi.pere 
	from contraintes.filiere fi,contraintes.formation fo,contraintes.parcours p
	where fi.id=p.filiere and p.id=fo.parcours

    loop
	return next rec;
    end loop;
end;$$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_get_filieres_formation() OWNER TO pgsql;

--
-- TOC entry 7572 (class 0 OID 0)
-- Dependencies: 1019
-- Name: FUNCTION af_get_filieres_formation(); Type: COMMENT; Schema: contraintes; Owner: pgsql
--

COMMENT ON FUNCTION af_get_filieres_formation() IS 'retourne les filieres des formation de la plateforme';


--
-- TOC entry 1020 (class 1255 OID 2595813)
-- Dependencies: 2983 5
-- Name: af_get_filieres_parcours(); Type: FUNCTION; Schema: contraintes; Owner: pgsql
--

CREATE FUNCTION af_get_filieres_parcours() RETURNS SETOF record
    AS $_$DECLARE
--$1 idendifiant de la filiere de depart 

--Il doit etre à NULL pour obtenir toutes les filieres et sous filieres ayant des parcours,
--dans l'ordre (une filiere et ses sous filieres, puis une autre filiere et ses sous filieres, etc...
rec RECORD;
BEGIN
	FOR rec IN
		--on recupere toutes les filieres principales
		SELECT id, libelle, pere 
		FROM contraintes.af_get_filieres_sous_filieres(NULL) AS (id int4, libelle varchar, pere int4)
		
	LOOP
		--si la filiere principale a des parcours, on la retourne
		PERFORM P_filiere
		FROM contraintes.af_get_parcours() AS (P_id int4, P_libelle varchar, P_filiere int4, P_duree bool)
		WHERE P_filiere=rec.id;
		
		IF FOUND THEN
			RETURN NEXT rec;
		END IF;

		--FOR rec1 IN
		--	SELECT contraintes.af_get_filieres_parcours()
		--on recupere les sous filieres de la filiere principale en cours
		SELECT DISTINCT id, libelle, pere 
		FROM contraintes.af_get_filieres_sous_filieres(rec.id) AS (id int4, libelle varchar, pere int4)
		LEFT OUTER JOIN
		contraintes.af_get_parcours() AS (P_id int4, P_libelle varchar, P_filiere int4, P_duree bool)
		ON (id=P_filiere)
		WHERE P_id IS NOT NULL;
	
		RETURN NEXT rec;
	END LOOP;

	RETURN;
END;$_$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_get_filieres_parcours() OWNER TO pgsql;

--
-- TOC entry 7574 (class 0 OID 0)
-- Dependencies: 1020
-- Name: FUNCTION af_get_filieres_parcours(); Type: COMMENT; Schema: contraintes; Owner: pgsql
--

COMMENT ON FUNCTION af_get_filieres_parcours() IS 'Obtenir les filieres ayant des parcours.
$1 doit etre à NULL pour obtenir toutes les filieres et sous filieres ayant des parcours, dans l''ordre (une filiere et ses sous filieres, puis une autre filiere et ses sous filieres, etc...';


--
-- TOC entry 1021 (class 1255 OID 2595814)
-- Dependencies: 2983 5
-- Name: af_get_filieres_parcours(integer); Type: FUNCTION; Schema: contraintes; Owner: pgsql
--

CREATE FUNCTION af_get_filieres_parcours(integer) RETURNS SETOF record
    AS $_$DECLARE
--$1 idendifiant de la filiere de depart 

--Il doit etre à NULL pour obtenir toutes les filieres et sous filieres ayant des parcours,
--dans l'ordre (une filiere et ses sous filieres, puis une autre filiere et ses sous filieres, etc...
rec RECORD;
rec1 RECORD;
BEGIN
	FOR rec IN
		--on recupere toutes les filieres principales
		SELECT id, libelle, pere 
		FROM contraintes.af_get_filiere_sous_filieres($1) AS (id int4, libelle varchar, pere int4)
		ORDER BY libelle
		
	LOOP
		--si la filiere principale a des parcours, on la retourne
		PERFORM P_filiere
		FROM contraintes.af_get_parcours() AS (P_id int4, P_libelle varchar, P_filiere int4, P_duree bool,date_creation timestamp)
		WHERE P_filiere=rec.id ;
		
		IF TRUE THEN
			RETURN NEXT rec;
		END IF;

		FOR rec1 IN
			SELECT * FROM contraintes.af_get_filieres_parcours(rec.id) AS (id int4, libelle varchar, pere int4)
		LOOP
			RETURN NEXT rec1;
		END LOOP;
	END LOOP;

	RETURN;
END;$_$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_get_filieres_parcours(integer) OWNER TO pgsql;

--
-- TOC entry 7576 (class 0 OID 0)
-- Dependencies: 1021
-- Name: FUNCTION af_get_filieres_parcours(integer); Type: COMMENT; Schema: contraintes; Owner: pgsql
--

COMMENT ON FUNCTION af_get_filieres_parcours(integer) IS 'Obtenir les filieres ayant des parcours.
$1 doit etre à NULL pour obtenir toutes les filieres et sous filieres ayant des parcours, dans l''ordre (une filiere et ses sous filieres, puis une autre filiere et ses sous filieres, etc...';


--
-- TOC entry 1022 (class 1255 OID 2595815)
-- Dependencies: 2983 5
-- Name: af_get_formateur_classes(integer); Type: FUNCTION; Schema: contraintes; Owner: pgsql
--

CREATE FUNCTION af_get_formateur_classes(integer) RETURNS SETOF record
    AS $_$-- $1 : numero formateur
declare
rec record;

begin
    for rec in 
	select distinct c.id,c.libelle,c.pere,c.min,c.max from contraintes.classe c ,
	contraintes.formation_participants pf
	where c.id=pf.classe and pf.formateur=$1
    loop
	return next rec;
    end loop;
end;$_$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_get_formateur_classes(integer) OWNER TO pgsql;

--
-- TOC entry 7578 (class 0 OID 0)
-- Dependencies: 1022
-- Name: FUNCTION af_get_formateur_classes(integer); Type: COMMENT; Schema: contraintes; Owner: pgsql
--

COMMENT ON FUNCTION af_get_formateur_classes(integer) IS 'retourne les classes d''un formateur';


--
-- TOC entry 1023 (class 1255 OID 2595816)
-- Dependencies: 2983 5
-- Name: af_get_formateur_droits(integer, integer); Type: FUNCTION; Schema: contraintes; Owner: pgsql
--

CREATE FUNCTION af_get_formateur_droits(integer, integer) RETURNS SETOF record
    AS $_$-- $1 : formateur
-- $2 : classe
declare
rec record;
begin
    for rec in 
	(select * from contraintes.af_get_formation_droits($1) as (id int4,libelle varchar))
	union
	(select id,libelle from contraintes.droit,contraintes.individu_droits where 
	id=droit and classe=$2)
    loop
	return next rec;
    end loop;
end;$_$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_get_formateur_droits(integer, integer) OWNER TO pgsql;

--
-- TOC entry 7580 (class 0 OID 0)
-- Dependencies: 1023
-- Name: FUNCTION af_get_formateur_droits(integer, integer); Type: COMMENT; Schema: contraintes; Owner: pgsql
--

COMMENT ON FUNCTION af_get_formateur_droits(integer, integer) IS 'retourne les droits du formateur';


--
-- TOC entry 1024 (class 1255 OID 2595817)
-- Dependencies: 2983 5
-- Name: af_get_formateur_formations(integer, character varying, character varying, integer); Type: FUNCTION; Schema: contraintes; Owner: pgsql
--

CREATE FUNCTION af_get_formateur_formations(integer, character varying, character varying, integer) RETURNS SETOF record
    AS $_$-- $1 : numero formateur
-- $2 : classement (asc ou desc)
-- $3 : order by (libelle ou date debut)
-- $4 : periode (1 : passées, 2 : présentes, 3 : futures, 0 toutes)
declare
rec record;
req varchar;
begin

IF contraintes.fw_is_root($1) THEN
    for rec in
	select f_id,f_libelle,f_parcours,f_date_debut,f_date_fin,f_langue,fp.formateur
	from contraintes.af_get_formations($2,$3,$4) as (f_id int4,f_libelle varchar,f_parcours int4,f_date_debut date,f_date_fin date,f_langue int4,ressources_fusionnees boolean),
	contraintes.formation_participants fp
	where f_id=fp.formation 
    loop
	return next rec;
    end loop;
ELSE
    for rec in
	select f_id,f_libelle,f_parcours,f_date_debut,f_date_fin,f_langue,fp.formateur
	from contraintes.af_get_formations($2,$3,$4) as (f_id int4,f_libelle varchar,f_parcours int4,f_date_debut date,f_date_fin date,f_langue int4,ressources_fusionnees boolean),
	contraintes.formation_participants fp
	where f_id=fp.formation and fp.formateur=$1
    loop
	return next rec;
    end loop;

END IF;

end;$_$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_get_formateur_formations(integer, character varying, character varying, integer) OWNER TO pgsql;

--
-- TOC entry 7582 (class 0 OID 0)
-- Dependencies: 1024
-- Name: FUNCTION af_get_formateur_formations(integer, character varying, character varying, integer); Type: COMMENT; Schema: contraintes; Owner: pgsql
--

COMMENT ON FUNCTION af_get_formateur_formations(integer, character varying, character varying, integer) IS 'retourne les formation d''un formateur';


--
-- TOC entry 1025 (class 1255 OID 2595818)
-- Dependencies: 2983 5
-- Name: af_get_formateur_individu_formations(integer, character varying, character varying, integer); Type: FUNCTION; Schema: contraintes; Owner: pgsql
--

CREATE FUNCTION af_get_formateur_individu_formations(integer, character varying, character varying, integer) RETURNS SETOF record
    AS $_$-- $1 : numero formateur
-- $2 : classement (asc ou desc)
-- $3 : order by (libelle ou date debut)
-- $4 : periode (1 : passées, 2 : présentes, 3 : futures, 0 toutes)
declare
rec record;
begin
    for rec in
	(select distinct id ,libelle ,parcours ,date_debut ,date_fin ,langue ,formateur, 1
	from contraintes.af_get_formateur_formations($1,$2,$3,$4) 
	as (id int4,libelle varchar,parcours int4,date_debut date,date_fin date,langue int4,formateur int4))
	union
	(select distinct id ,libelle ,parcours ,date_debut ,date_fin ,langue ,formateur, 2
	from contraintes.af_get_individu_formations($1,$2,$3,$4) 
	as (id int4,libelle varchar,parcours int4,date_debut date,date_fin date,langue int4,formateur int4))
    loop
	return next rec;
    end loop;
end;$_$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_get_formateur_individu_formations(integer, character varying, character varying, integer) OWNER TO pgsql;

--
-- TOC entry 7584 (class 0 OID 0)
-- Dependencies: 1025
-- Name: FUNCTION af_get_formateur_individu_formations(integer, character varying, character varying, integer); Type: COMMENT; Schema: contraintes; Owner: pgsql
--

COMMENT ON FUNCTION af_get_formateur_individu_formations(integer, character varying, character varying, integer) IS 'retourne les formations pour un formateur en tant que formateur et individu';


--
-- TOC entry 1026 (class 1255 OID 2595819)
-- Dependencies: 2983 5
-- Name: af_get_formateurs(integer); Type: FUNCTION; Schema: contraintes; Owner: pgsql
--

CREATE FUNCTION af_get_formateurs(integer) RETURNS SETOF record
    AS $_$-- $1 : individu
declare
rec record;
begin
    if contraintes.fw_is_root($1) then
    for rec in
	select DISTINCT I.id,textcat(textcat(I.nom,text ' '),I.prenom)
	from contraintes.fw_individu I,  contraintes.fw_individu_types T
	WHERE I.id=T.individu
	AND T.type=2
    loop
	return next rec;
    end loop;
    else
    for rec in
	select DISTINCT I.id,textcat(textcat(I.nom,text ' '),I.prenom)
	from contraintes.fw_individu I,  contraintes.fw_individu_types T
	WHERE I.id=T.individu
	AND T.type=2
	--AND I.id=$1
    loop
	return next rec;
    end loop;
    end if;
end;$_$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_get_formateurs(integer) OWNER TO pgsql;

--
-- TOC entry 7586 (class 0 OID 0)
-- Dependencies: 1026
-- Name: FUNCTION af_get_formateurs(integer); Type: COMMENT; Schema: contraintes; Owner: pgsql
--

COMMENT ON FUNCTION af_get_formateurs(integer) IS 'retourne les formateurs de la plateforme
si root';


--
-- TOC entry 1027 (class 1255 OID 2595820)
-- Dependencies: 2983 5
-- Name: af_get_formation(integer); Type: FUNCTION; Schema: contraintes; Owner: pgsql
--

CREATE FUNCTION af_get_formation(integer) RETURNS record
    AS $_$DECLARE
--$1 formation
rec RECORD;
BEGIN 
	SELECT INTO rec id, libelle, parcours, date_debut, date_fin, langue,ressources_fusionnees 
	FROM contraintes.formation
	WHERE id=$1;

	RETURN rec;
END;$_$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_get_formation(integer) OWNER TO pgsql;

--
-- TOC entry 1028 (class 1255 OID 2595821)
-- Dependencies: 2983 5
-- Name: af_get_formation_alerte(integer, date); Type: FUNCTION; Schema: contraintes; Owner: pgsql
--

CREATE FUNCTION af_get_formation_alerte(integer, date) RETURNS record
    AS $_$-- $1 : numero formation
-- $2 : date (timestamp)
declare
rec record;
begin
    select into rec id,libelle,formation,date,jours,texte 
    from contraintes.alerte 
    where formation=$1 and date=$2;
    return rec;
end;$_$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_get_formation_alerte(integer, date) OWNER TO pgsql;

--
-- TOC entry 7589 (class 0 OID 0)
-- Dependencies: 1028
-- Name: FUNCTION af_get_formation_alerte(integer, date); Type: COMMENT; Schema: contraintes; Owner: pgsql
--

COMMENT ON FUNCTION af_get_formation_alerte(integer, date) IS 'retourne l''alerte d''une date de formation';


--
-- TOC entry 1842 (class 1255 OID 2595822)
-- Dependencies: 2983 5
-- Name: af_get_formation_alertes(integer); Type: FUNCTION; Schema: contraintes; Owner: pgsql
--

CREATE FUNCTION af_get_formation_alertes(integer) RETURNS SETOF record
    AS $_$-- $1 : numero formation
declare
rec record;
begin
    for rec in 
	select id,libelle,formation,date,jours,texte 
        from contraintes.alerte where formation=$1
    loop
	return next rec;
    end loop;
    return;
end;$_$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_get_formation_alertes(integer) OWNER TO pgsql;

--
-- TOC entry 7591 (class 0 OID 0)
-- Dependencies: 1842
-- Name: FUNCTION af_get_formation_alertes(integer); Type: COMMENT; Schema: contraintes; Owner: pgsql
--

COMMENT ON FUNCTION af_get_formation_alertes(integer) IS 'retourne les alertes d''une formation';


--
-- TOC entry 1029 (class 1255 OID 2595823)
-- Dependencies: 2983 5
-- Name: af_get_formation_alertes_periode(integer, timestamp without time zone, timestamp without time zone); Type: FUNCTION; Schema: contraintes; Owner: pgsql
--

CREATE FUNCTION af_get_formation_alertes_periode(integer, timestamp without time zone, timestamp without time zone) RETURNS SETOF record
    AS $_$-- $1 : numero formation
-- $2 : debut periode
-- $3 : fin periode
declare
rec record;
begin
    for rec in
	select id,libelle,formation,date,jours,texte
	from contraintes.alerte
	where formation=$1
	and date between $2 and $3
    loop
	return next rec;
    end loop;
end;$_$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_get_formation_alertes_periode(integer, timestamp without time zone, timestamp without time zone) OWNER TO pgsql;

--
-- TOC entry 7593 (class 0 OID 0)
-- Dependencies: 1029
-- Name: FUNCTION af_get_formation_alertes_periode(integer, timestamp without time zone, timestamp without time zone); Type: COMMENT; Schema: contraintes; Owner: pgsql
--

COMMENT ON FUNCTION af_get_formation_alertes_periode(integer, timestamp without time zone, timestamp without time zone) IS 'retourne les alertes d''une formation pour une periode (debut,fin)';


--
-- TOC entry 1030 (class 1255 OID 2595824)
-- Dependencies: 2983 5
-- Name: af_get_formation_all_ressources_individu(integer, boolean, integer); Type: FUNCTION; Schema: contraintes; Owner: pgsql
--

CREATE FUNCTION af_get_formation_all_ressources_individu(integer, boolean, integer) RETURNS SETOF record
    AS $_$-- $1 : formation
-- $2 : booleen (pour affichage ancienne ressource)
-- $3 : individu
declare
rec record;
begin
    for rec in
	(select * from contraintes.af_get_formation_ressources($1,$2) 
	as(ressource int4,fichier int4,espace int4,libelle_espace varchar,section int4,libelle_section varchar,titre varchar,formation int4,type int4,mots_cles text,debut timestamp,fin timestamp,nouveau interval,icone int4) )
	union
	--(select * from contraintes.af_get_formation_parcourss_ressources($1)
	(select * from contraintes.af_get_formation_etapes_ressources_avancement_individu($1,$3)
	as(ressource int4,fichier int4,espace int4,libelle_espace varchar,section int4,libelle_section varchar,titre varchar,formation int4,type int4,mots_cles text,debut timestamp,fin timestamp,nouveau interval,icone int4) )
	order by libelle_espace,libelle_section
	
    loop
	return next rec;
    end loop;
end;$_$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_get_formation_all_ressources_individu(integer, boolean, integer) OWNER TO pgsql;

--
-- TOC entry 7595 (class 0 OID 0)
-- Dependencies: 1030
-- Name: FUNCTION af_get_formation_all_ressources_individu(integer, boolean, integer); Type: COMMENT; Schema: contraintes; Owner: pgsql
--

COMMENT ON FUNCTION af_get_formation_all_ressources_individu(integer, boolean, integer) IS 'retourne toutes les ressources pour une formation et un individu(parcours compris)';


--
-- TOC entry 1031 (class 1255 OID 2595825)
-- Dependencies: 2983 5
-- Name: af_get_formation_avancement(integer); Type: FUNCTION; Schema: contraintes; Owner: pgsql
--

CREATE FUNCTION af_get_formation_avancement(integer) RETURNS SETOF record
    AS $_$DECLARE
--$1 formation
id_parcours int4;
rec RECORD;
rec_p RECORD;
BEGIN
	--on récupère le parcours de la formation
	SELECT INTO id_parcours parcours FROM contraintes.af_get_formation($1) 
	AS (id int4, libelle varchar, parcours int4, date_debut date, date_fin date, langue int4,ressources_fusionnees boolean);
	if id_parcours is null then
		raise exception 'Pas de parcours principal pour la formation';
	end if;
	raise notice 'p=%',id_parcours;
	FOR rec IN
		SELECT F_parcours, F_etape, F_formation, F_stagiaire, F_type FROM contraintes.af_get_formation_avancement_parcours($1, id_parcours) AS (F_parcours int4, F_etape int4, F_formation int4, F_stagiaire int4, F_type varchar)
	LOOP
		IF rec.F_type=1 THEN
		
			FOR rec_p IN
				SELECT * FROM contraintes.af_get_formation_avancement_parcours($1,rec.F_etape) AS (parcours int4, etape int4, formation int4,  stagiaire int4, type varchar)
			LOOP
				RETURN NEXT rec_p;
			END LOOP;
		ELSE
			RETURN NEXT rec;
		END IF;
		
	END LOOP;

	RETURN;
END;$_$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_get_formation_avancement(integer) OWNER TO pgsql;

--
-- TOC entry 1032 (class 1255 OID 2595826)
-- Dependencies: 2983 5
-- Name: af_get_formation_avancement_individu(integer, integer); Type: FUNCTION; Schema: contraintes; Owner: pgsql
--

CREATE FUNCTION af_get_formation_avancement_individu(integer, integer) RETURNS SETOF record
    AS $_$-- $1 : formation
-- $2 : individu

declare
rec record;
begin
    for rec in
	select * from contraintes.af_get_formation_avancement($1) 
	as (parcours int4, etape int4, formation int4, stagiaire int4, type varchar)
	where stagiaire=$2 
    loop
	return next rec;
    end loop;
end;$_$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_get_formation_avancement_individu(integer, integer) OWNER TO pgsql;

--
-- TOC entry 7598 (class 0 OID 0)
-- Dependencies: 1032
-- Name: FUNCTION af_get_formation_avancement_individu(integer, integer); Type: COMMENT; Schema: contraintes; Owner: pgsql
--

COMMENT ON FUNCTION af_get_formation_avancement_individu(integer, integer) IS 'retourne les etapes réalisées pour une formation et un individu';


--
-- TOC entry 1033 (class 1255 OID 2595827)
-- Dependencies: 2983 5
-- Name: af_get_formation_avancement_max(integer, integer); Type: FUNCTION; Schema: contraintes; Owner: pgsql
--

CREATE FUNCTION af_get_formation_avancement_max(integer, integer) RETURNS record
    AS $_$DECLARE
--$1 formation
--$2 individu
id_parcours int4;
rec RECORD;
rec_p RECORD;
BEGIN
	--on récupère le parcours de la formation
	SELECT INTO id_parcours parcours FROM contraintes.af_get_formation($1) 
	AS (id int4, libelle varchar, parcours int4, date_debut date, date_fin date, langue int4,ressources_fusionnees boolean);
	
	RAISE NOTICE 'Parcours principal pour la formation: %', id_parcours;
	IF id_parcours IS NULL THEN
		RAISE EXCEPTION 'Pas de parcours principal pour la formation';
	END IF;

	
	SELECT INTO rec * FROM contraintes.af_get_formation_avancement_max_parcours($1, id_parcours, $2) AS (parcours int4, etape int4, type int4,formation int4, individu int4, date_debut timestamp);
	
	IF rec.type=1 THEN
	
		SELECT INTO rec_p * FROM contraintes.af_get_formation_avancement_max_parcours($1,rec.etape, $2) AS (parcours int4, etape int4,type int4, formation int4, individu int4, date_debut timestamp);
		RETURN rec_p;
		
	ELSE
		RETURN rec;
	END IF;

END;$_$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_get_formation_avancement_max(integer, integer) OWNER TO pgsql;

--
-- TOC entry 1034 (class 1255 OID 2595828)
-- Dependencies: 2983 5
-- Name: af_get_formation_avancement_max_parcours(integer, integer, integer); Type: FUNCTION; Schema: contraintes; Owner: pgsql
--

CREATE FUNCTION af_get_formation_avancement_max_parcours(integer, integer, integer) RETURNS record
    AS $_$
DECLARE
--$1 formation
--$2 parcours
--$3 individu 
mini integer;
rec RECORD; 
BEGIN
	SELECT INTO mini MIN(elt2.ind) FROM ( contraintes.af_gen_get_elements('contraintes.parcours_etapes', 'etape', NULL, 'AND parcours='||$2,0) elt2 
	INNER JOIN contraintes.parcours_etapes PE ON (PE.parcours = $2 AND elt2.id=PE.etape AND obligatoire IS TRUE)
	)LEFT OUTER JOIN contraintes.resultat R2 ON (R2.parcours = $2 AND elt2.id=R2.etape AND R2.formation=$1 AND R2.stagiaire=$3)
	WHERE R2.duree IS NULL;


	RAISE NOTICE 'min=%',mini;
	SELECT INTO rec $2, E.id, E.type , $1, $3, R1.date_debut, R1.duree
	FROM contraintes.etape E,contraintes.af_gen_get_elements('contraintes.parcours_etapes', 'etape', NULL, 'AND parcours='||$2,0) elt
	LEFT OUTER JOIN contraintes.resultat R1 ON (R1.parcours = $2 AND elt.id=R1.etape AND R1.formation=$1 AND R1.stagiaire=$3)
	WHERE E.id=elt.id
	AND elt.ind = mini;

	RETURN rec;
END;
$_$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_get_formation_avancement_max_parcours(integer, integer, integer) OWNER TO pgsql;

--
-- TOC entry 1035 (class 1255 OID 2595829)
-- Dependencies: 2983 5
-- Name: af_get_formation_avancement_parcours(integer, integer); Type: FUNCTION; Schema: contraintes; Owner: pgsql
--

CREATE FUNCTION af_get_formation_avancement_parcours(integer, integer) RETURNS SETOF record
    AS $_$DECLARE
--$1 formation
--$2 parcours
rec RECORD;
BEGIN
	

	--on recupere les etapes du parcours
	FOR rec IN
		SELECT * FROM contraintes.af_get_parcours_avancement($2) 
		AS (parcours int4,etape int4, formation int4, stagiaire int4, type varchar)
		WHERE formation=$1
	LOOP
		RETURN NEXT rec;
	END LOOP;

	RETURN;
END;$_$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_get_formation_avancement_parcours(integer, integer) OWNER TO pgsql;

--
-- TOC entry 1036 (class 1255 OID 2595830)
-- Dependencies: 2983 5
-- Name: af_get_formation_avancement_parcours_individu(integer, integer, integer); Type: FUNCTION; Schema: contraintes; Owner: pgsql
--

CREATE FUNCTION af_get_formation_avancement_parcours_individu(integer, integer, integer) RETURNS SETOF record
    AS $_$-- $1 : formation
-- $2 : individu
-- $3 : parcours
declare
rec record;
begin
    for rec in
	select * from contraintes.af_get_formation_avancement($1) 
	as (parcours int4, etape int4, formation int4, stagiaire int4, type varchar)
	where stagiaire=$2 and parcours=$3 
    loop
	return next rec;
    end loop;
end;$_$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_get_formation_avancement_parcours_individu(integer, integer, integer) OWNER TO pgsql;

--
-- TOC entry 7603 (class 0 OID 0)
-- Dependencies: 1036
-- Name: FUNCTION af_get_formation_avancement_parcours_individu(integer, integer, integer); Type: COMMENT; Schema: contraintes; Owner: pgsql
--

COMMENT ON FUNCTION af_get_formation_avancement_parcours_individu(integer, integer, integer) IS 'retourne les etapes réalisées pour une formation,un parcours et un individu';


--
-- TOC entry 1037 (class 1255 OID 2595831)
-- Dependencies: 2983 5
-- Name: af_get_formation_avancement_reel_individu(integer, integer); Type: FUNCTION; Schema: contraintes; Owner: pgsql
--

CREATE FUNCTION af_get_formation_avancement_reel_individu(integer, integer) RETURNS SETOF record
    AS $_$-- $1 : formation
-- $2 : individu

declare
rec record;
etape_courante integer:=0 ;
begin
    for rec in
	select * from contraintes.af_get_formation_avancement_individu($1,$2)
	as (parcours int4, etape int4, formation int4, stagiaire int4, type varchar)
	where type not in ('9','10')
	
    loop
	
	if rec.etape != etape_courante then 
	    return next rec;
	    etape_courante:=rec.etape;
	end if;
    end loop;
end;$_$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_get_formation_avancement_reel_individu(integer, integer) OWNER TO pgsql;

--
-- TOC entry 7605 (class 0 OID 0)
-- Dependencies: 1037
-- Name: FUNCTION af_get_formation_avancement_reel_individu(integer, integer); Type: COMMENT; Schema: contraintes; Owner: pgsql
--

COMMENT ON FUNCTION af_get_formation_avancement_reel_individu(integer, integer) IS 'retourn l''avacement réel d''un individu pour une formation (cad : les etapes réellement faites (ex : pas les etapes titre))';


--
-- TOC entry 1038 (class 1255 OID 2595832)
-- Dependencies: 2983 5
-- Name: af_get_formation_classes(integer); Type: FUNCTION; Schema: contraintes; Owner: pgsql
--

CREATE FUNCTION af_get_formation_classes(integer) RETURNS record
    AS $_$declare
rec record;
begin
    select into rec id,libelle,pere,min,max 
    from contraintes.af_get_classes() as(id int4,libelle varchar, pere int4,min int4,max int4) ,
    contraintes.formation_participants ft 
    where ft.formation=$1 and ft.classe=id;
    return rec; 
end$_$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_get_formation_classes(integer) OWNER TO pgsql;

--
-- TOC entry 7607 (class 0 OID 0)
-- Dependencies: 1038
-- Name: FUNCTION af_get_formation_classes(integer); Type: COMMENT; Schema: contraintes; Owner: pgsql
--

COMMENT ON FUNCTION af_get_formation_classes(integer) IS 'retourne la classe d''une formation';


--
-- TOC entry 1039 (class 1255 OID 2595833)
-- Dependencies: 2983 5
-- Name: af_get_formation_droits(integer); Type: FUNCTION; Schema: contraintes; Owner: pgsql
--

CREATE FUNCTION af_get_formation_droits(integer) RETURNS SETOF record
    AS $_$-- $1 : numero formation
declare
rec record;
begin
    for rec in
	select d.id,d.libelle from contraintes.droit d,contraintes.formateur_droits fd
	where d.id=fd.droit and fd.formation=$1
    loop
	return next rec;
    end loop;
end;$_$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_get_formation_droits(integer) OWNER TO pgsql;

--
-- TOC entry 7609 (class 0 OID 0)
-- Dependencies: 1039
-- Name: FUNCTION af_get_formation_droits(integer); Type: COMMENT; Schema: contraintes; Owner: pgsql
--

COMMENT ON FUNCTION af_get_formation_droits(integer) IS 'retourne les droits (du formateur) d''une formation';


--
-- TOC entry 1040 (class 1255 OID 2595834)
-- Dependencies: 2983 5
-- Name: af_get_formation_espace_ressources(integer, integer); Type: FUNCTION; Schema: contraintes; Owner: pgsql
--

CREATE FUNCTION af_get_formation_espace_ressources(integer, integer) RETURNS SETOF record
    AS $_$-- $1 : formation
-- $2 : espace
declare
rec record;
begin
    for rec in 
	select 
	FR.ressource,R.fichier,FR.espace,E.libelle, FR.section,S.libelle,ET.libelle,FR.formation,FI.type,R.mots_cles, 
	cast(FR.debut_disponibilite as date), cast(FR.fin_disponibilite as date), FR.duree_nouveaute,S.icone
	FROM 
	contraintes.formation_ressources FR,
	contraintes.ressource R,
	contraintes.etape ET,
	contraintes.etape_ressource ER,
	contraintes.fichier FI,
	contraintes.espace E,
	contraintes.section S
	WHERE 
	FR.formation=$1 and FR.espace=$2 
	and FR.ressource=R.id 
	and FR.espace=E.id 
	and FR.section=S.id 
	and R.fichier=FI.id 
	and ET.id=ER.id and ER.ressource=FR.ressource
    loop
	return next rec;
    end loop;
end;$_$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_get_formation_espace_ressources(integer, integer) OWNER TO pgsql;

--
-- TOC entry 7611 (class 0 OID 0)
-- Dependencies: 1040
-- Name: FUNCTION af_get_formation_espace_ressources(integer, integer); Type: COMMENT; Schema: contraintes; Owner: pgsql
--

COMMENT ON FUNCTION af_get_formation_espace_ressources(integer, integer) IS 'retourne les ressources d''une formation pour un espace';


--
-- TOC entry 1041 (class 1255 OID 2595835)
-- Dependencies: 2983 5
-- Name: af_get_formation_espace_section_all_ressources_individu(integer, integer, integer, integer); Type: FUNCTION; Schema: contraintes; Owner: pgsql
--

CREATE FUNCTION af_get_formation_espace_section_all_ressources_individu(integer, integer, integer, integer) RETURNS SETOF record
    AS $_$-- $1 : formation
-- $2 : espace
-- $3 : section
-- $4 : individu
declare
rec record;
begin
    for rec in
	(select * from contraintes.af_get_formation_espace_section_ressources($1,$2,$3)
	as (ressource int4,fichier int4,espace int4,libelle_espace varchar,section int4,libelle_section varchar,titre varchar,formation int4,type int4,mots_cles text,debut date,fin date,nouveau interval,icone int4))
	union
	(select * from contraintes.af_get_formation_espace_section_etapes_ressources_avancement_individu($1,$2,$3,$4)
	as (ressource int4,fichier int4,espace int4,libelle_espace varchar,section int4,libelle_section varchar,titre varchar,formation int4,type int4,mots_cles text,debut date,fin date,nouveau interval,icone int4))
	order by libelle_espace,libelle_section

    loop
	return next rec;
    end loop;
end;$_$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_get_formation_espace_section_all_ressources_individu(integer, integer, integer, integer) OWNER TO pgsql;

--
-- TOC entry 7613 (class 0 OID 0)
-- Dependencies: 1041
-- Name: FUNCTION af_get_formation_espace_section_all_ressources_individu(integer, integer, integer, integer); Type: COMMENT; Schema: contraintes; Owner: pgsql
--

COMMENT ON FUNCTION af_get_formation_espace_section_all_ressources_individu(integer, integer, integer, integer) IS 'retourne les ressources pour un espace,une section d''une formation fusionnées aves celles des etapes faites par l''individu';


--
-- TOC entry 1042 (class 1255 OID 2595836)
-- Dependencies: 2983 5
-- Name: af_get_formation_espace_section_etapes_ressources_avancement_in(integer, integer, integer, integer); Type: FUNCTION; Schema: contraintes; Owner: pgsql
--

CREATE FUNCTION af_get_formation_espace_section_etapes_ressources_avancement_in(integer, integer, integer, integer) RETURNS SETOF record
    AS $_$-- $1 : formation
-- $2 : espace
-- $3 : section
-- $4 : individu
declare
rec record;
begin
    for rec in
	
	select ET.fichier,ET.fichier,ET.espace,E.libelle,ET.section,S.libelle,FI.libelle,
	$1,FI.type,FM.mots_cles,CAST(NULL AS date),cast(NULL as date),cast(NULL as interval),S.icone
	from (contraintes.fichier FI left outer join contraintes.fichier_metadata FM on (FI.id=FM.id)),
	contraintes.etape_ressource ET,
	contraintes.espace E,
	contraintes.section S 
	where ET.fichier=FI.id
	and ET.espace=$2
	and ET.section=$3
	and ET.espace=E.id  
	and ET.section=S.id
	and ET.id in 
	--and ET.id in 
	(select etape from contraintes.af_get_formation_avancement_individu($1,$4) as 
	(parcours int4, etape int4, formation int4, stagiaire int4, type varchar) where type=7)
    loop
	return next rec;
    end loop;
end;$_$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_get_formation_espace_section_etapes_ressources_avancement_in(integer, integer, integer, integer) OWNER TO pgsql;

--
-- TOC entry 7615 (class 0 OID 0)
-- Dependencies: 1042
-- Name: FUNCTION af_get_formation_espace_section_etapes_ressources_avancement_in(integer, integer, integer, integer); Type: COMMENT; Schema: contraintes; Owner: pgsql
--

COMMENT ON FUNCTION af_get_formation_espace_section_etapes_ressources_avancement_in(integer, integer, integer, integer) IS 'retourne les ressources (pour un espace et une section) issues des etapes ressources faites par l''individu';


--
-- TOC entry 1843 (class 1255 OID 2595837)
-- Dependencies: 2983 5
-- Name: af_get_formation_espace_section_ressources(integer, integer, integer); Type: FUNCTION; Schema: contraintes; Owner: pgsql
--

CREATE FUNCTION af_get_formation_espace_section_ressources(integer, integer, integer) RETURNS SETOF record
    AS $_$-- $1 : formation
-- $2 : espace
-- $3 : section
declare
rec record;
begin
    for rec in
    select 
	FR.fichier_ressource,FR.fichier_ressource,FR.espace,E.libelle, FR.section,S.libelle,FI.libelle,FR.formation,FI.type,FM.mots_cles, 
	cast(FR.debut_disponibilite as date), cast(FR.fin_disponibilite as date), FR.duree_nouveaute,S.icone
	FROM 
	(contraintes.fichier FI LEFT OUTER JOIN
	contraintes.fichier_metadata FM ON (FI.id=FM.id )),
	contraintes.formation_ressources FR,
	contraintes.espace E,
	contraintes.section S
	WHERE 
	FR.formation=$1 and FR.espace=$2 and FR.section=$3 
	and FR.fichier_ressource=FI.id 
	and FR.section=S.id 
	and FR.espace=E.id
	AND now() BETWEEN debut_disponibilite AND (fin_disponibilite + '1 day')
    loop
	return next rec;
    end loop;
end;$_$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_get_formation_espace_section_ressources(integer, integer, integer) OWNER TO pgsql;

--
-- TOC entry 7617 (class 0 OID 0)
-- Dependencies: 1843
-- Name: FUNCTION af_get_formation_espace_section_ressources(integer, integer, integer); Type: COMMENT; Schema: contraintes; Owner: pgsql
--

COMMENT ON FUNCTION af_get_formation_espace_section_ressources(integer, integer, integer) IS 'retourne les ressources pour une formation,un espace et une section';


--
-- TOC entry 1043 (class 1255 OID 2595838)
-- Dependencies: 2983 5
-- Name: af_get_formation_espace_section_ressources_no_date(integer, integer, integer); Type: FUNCTION; Schema: contraintes; Owner: pgsql
--

CREATE FUNCTION af_get_formation_espace_section_ressources_no_date(integer, integer, integer) RETURNS SETOF record
    AS $_$-- $1 : formation
-- $2 : espace
-- $3 : section
declare
rec record;
begin
    for rec in
    select 
	FR.fichier_ressource,FR.fichier_ressource,FR.espace,E.libelle, FR.section,S.libelle,FI.libelle,FR.formation,FI.type,FM.mots_cles, 
	cast(NULL as date), cast(NULL as date), cast(NULL as interval),S.icone
	FROM 
	(contraintes.fichier FI LEFT OUTER JOIN
	contraintes.fichier_metadata FM ON (FI.id=FM.id )),
	contraintes.formation_ressources FR,
	contraintes.espace E,
	contraintes.section S
	WHERE 
	FR.formation=$1 and FR.espace=$2 and FR.section=$3 
	and FR.fichier_ressource=FI.id 
	and FR.section=S.id 
	and FR.espace=E.id
	--AND (now() BETWEEN debut_disponibilite AND (fin_disponibilite + '1 day') or FR.debut_disponibilite is null)
    loop
	return next rec;
    end loop;
end;$_$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_get_formation_espace_section_ressources_no_date(integer, integer, integer) OWNER TO pgsql;

--
-- TOC entry 7619 (class 0 OID 0)
-- Dependencies: 1043
-- Name: FUNCTION af_get_formation_espace_section_ressources_no_date(integer, integer, integer); Type: COMMENT; Schema: contraintes; Owner: pgsql
--

COMMENT ON FUNCTION af_get_formation_espace_section_ressources_no_date(integer, integer, integer) IS 'retourne les ressources pour une formation,un espace et une section';


--
-- TOC entry 1044 (class 1255 OID 2595839)
-- Dependencies: 2983 5
-- Name: af_get_formation_espace_sections(integer, integer); Type: FUNCTION; Schema: contraintes; Owner: postgres
--

CREATE FUNCTION af_get_formation_espace_sections(integer, integer) RETURNS SETOF record
    AS $_$DECLARE
--$1 formation
--$2 espace
rec RECORD;
BEGIN
    FOR rec IN
	/*SELECT FR.espace,E.libelle, FR.section,S.libelle,S.icone,FR.formation,FR.ressource
	FROM 
	contraintes.formation_ressources FR,
	contraintes.espace E,
	contraintes.section S
	WHERE 
	FR.formation=$1 and FR.espace=$2
	and FR.espace=E.id 
	and FR.section=S.id*/
--espace, libelle_espace, section ,libelle_section ,icone ,formation ,ressource
		select *  from contraintes.af_get_formation_ressources($1, FALSE) 
		as(ressource int4,fichier int4,espace int4,libelle_espace varchar,section int4,libelle_section varchar,titre varchar,formation int4,type int4,mots_cles text,debut timestamp,fin timestamp,nouveau interval,icone int4) 
		WHERE espace=$2
	LOOP
		RETURN NEXT rec;
	END LOOP;

	RETURN;
END;
$_$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_get_formation_espace_sections(integer, integer) OWNER TO postgres;

--
-- TOC entry 7621 (class 0 OID 0)
-- Dependencies: 1044
-- Name: FUNCTION af_get_formation_espace_sections(integer, integer); Type: COMMENT; Schema: contraintes; Owner: postgres
--

COMMENT ON FUNCTION af_get_formation_espace_sections(integer, integer) IS 'Retourne toutes les sections d''un espace';


--
-- TOC entry 1045 (class 1255 OID 2595840)
-- Dependencies: 2983 5
-- Name: af_get_formation_etape_individu_encadrants(integer, integer, integer, integer); Type: FUNCTION; Schema: contraintes; Owner: pgsql
--

CREATE FUNCTION af_get_formation_etape_individu_encadrants(integer, integer, integer, integer) RETURNS SETOF record
    AS $_$DECLARE 
--$1 formation
--$2 Individu
--$3 Parcours
--$4 Etape
ligne_vide RECORD;
rec RECORD;
indice integer;
nb_ligne integer;
ligne_suivant boolean:= false ;
ligne_precedent boolean:= false;

v_ligne_suivant RECORD;
v_ligne_precedent RECORD;


BEGIN
	--selection l'indice
	select INTO indice B_indice 
	from contraintes.af_get_formation_etapes_individu($1,$2)
	as(id int4, libelle_pour_parcours varchar, libelle_etape  varchar,libelle_type_etape  varchar, type varchar,  pere int4, parcours int4, obligatoire bool, chrono int4, fin bool,libelle_type_original varchar, modifiable bool, B_indice int4)
	WHERE parcours=$3
	AND id=$4;

	
	FOR rec IN

		select id , libelle_pour_parcours , libelle_etape  ,libelle_type_etape  , type ,  pere , parcours , obligatoire , chrono , fin ,libelle_type_original , modifiable , I_indice 
		from contraintes.af_get_formation_etapes_individu($1,$2) 
		as(id int4, libelle_pour_parcours varchar, libelle_etape  varchar,libelle_type_etape  varchar, type varchar,  pere int4, parcours int4, obligatoire bool, chrono int4, fin bool,libelle_type_original varchar, modifiable bool, I_indice int4)
		WHERE (I_indice = indice+1
		OR I_indice=indice-1) ORDER BY indice
		
		
	LOOP 
		RAISE NOTICE '---------------------------indice=%   < rec.I_indice=%',indice,rec.I_indice;
		
		IF indice<rec.I_indice THEN
			ligne_suivant:=true;
			v_ligne_suivant:=rec;
		ELSE
			ligne_precedent:=true;
			v_ligne_precedent:=rec;
		END IF;

		
	END LOOP;

	IF  ligne_precedent=true AND ligne_suivant=true THEN
		RETURN NEXT v_ligne_precedent;
		RETURN NEXT v_ligne_suivant;
	ELSE
		ligne_vide:= rec;
		ligne_vide.id:=NULL;
		ligne_vide.libelle_pour_parcours:=NULL;
		ligne_vide.libelle_etape:=NULL;
		ligne_vide.libelle_type_etape:=NULL;
		ligne_vide.type:=NULL;
		ligne_vide.pere:=NULL;
		ligne_vide.parcours:=NULL;
		ligne_vide.obligatoire:=NULL;
		ligne_vide.chrono:=NULL;
		ligne_vide.fin:=NULL;
		ligne_vide.libelle_type_original:=NULL;
		ligne_vide.modifiable:=NULL;	
		ligne_vide.I_indice:= NULL;

		IF ligne_precedent=false THEN
		
				RETURN NEXT ligne_vide;
				RETURN NEXT rec;
		END IF;

		IF ligne_suivant=false THEN
				RETURN NEXT rec;
				RETURN NEXT ligne_vide;	
		END IF;	
	END IF;

	IF  ligne_precedent=false AND ligne_suivant=false THEN
		RETURN NEXT ligne_vide;
		RETURN NEXT ligne_vide;
	END IF;	
	
END;
$_$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_get_formation_etape_individu_encadrants(integer, integer, integer, integer) OWNER TO pgsql;

--
-- TOC entry 1046 (class 1255 OID 2595841)
-- Dependencies: 2983 5
-- Name: af_get_formation_etapes(integer); Type: FUNCTION; Schema: contraintes; Owner: pgsql
--

CREATE FUNCTION af_get_formation_etapes(integer) RETURNS SETOF record
    AS $_$DECLARE
--$1 formation
id_parcours int4;
rec RECORD;
rec_p RECORD;
indice integer:=0;
BEGIN
	--on récupère le parcours de la formation
	SELECT INTO id_parcours parcours FROM contraintes.af_get_formation($1) 
	AS (id int4, libelle varchar, parcours int4, date_debut date, date_fin date, langue int4,ressources_fusionnees boolean);
	--raise notice 'parc=%',id_parcours;
	--on recupere les etapes du parcours
	FOR rec IN
		--SELECT * FROM contraintes.af_get_parcours_etapes_deroulees(id_parcours) AS (id int4, libelle_pour_parcours varchar, libelle_etape  varchar, type int4,  pere int4, parcours int4, obligatoire bool, chrono int4, fin bool)
		-- Modif said 17/11/06
		SELECT *,indice AS indic FROM contraintes.af_get_parcours_etapes_deroulees(id_parcours) AS (id int4, libelle_alias varchar, libelle varchar, libelle_type_etape  varchar, type varchar,  pere int4, parcours int4, obligatoire bool, chrono int4, fin bool, libelle_type_original varchar, modifiable bool)
	
	LOOP
		IF rec.type=1 THEN
			FOR rec_p IN
				--SELECT * FROM contraintes.af_get_parcours_etapes_deroulees(rec.id) AS (id int4, libelle_pour_parcours varchar, libelle_etape  varchar, type int4,  pere int4, parcours int4, obligatoire bool, chrono int4, fin bool)
				-- Modif said 17/11/06
				SELECT *,indice AS indic FROM contraintes.af_get_parcours_etapes_deroulees(rec.id) AS (id int4, libelle_alias varchar, libelle varchar, libelle_type_etape  varchar, type varchar,  pere int4, parcours int4, obligatoire bool, chrono int4, fin bool, libelle_type_original varchar, modifiable bool)
			
			LOOP
				rec_p.indic:=indice;
				RETURN NEXT rec_p;
				indice:=indice+1;
			END LOOP;
		ELSE 
			rec.indic:=indice;
			RETURN NEXT rec;
			indice:=indice+1;
		END IF;
	END LOOP;

	RETURN;
END;$_$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_get_formation_etapes(integer) OWNER TO pgsql;

--
-- TOC entry 1047 (class 1255 OID 2595842)
-- Dependencies: 2983 5
-- Name: af_get_formation_etapes_individu(integer, integer); Type: FUNCTION; Schema: contraintes; Owner: pgsql
--

CREATE FUNCTION af_get_formation_etapes_individu(integer, integer) RETURNS SETOF record
    AS $_$DECLARE
--$1 formation
--$2 individu
id_parcours int4;
sous_parcours integer;
rec_resultat record;
rec RECORD;
rec_p RECORD;
indice integer:=0;
BEGIN
    --on récupère le parcours de la formation
    SELECT INTO id_parcours parcours FROM contraintes.af_get_formation($1) 
    AS (id int4, libelle varchar, parcours int4, date_debut date, date_fin date, langue int4,ressources_fusionnees boolean);
    raise notice 'parc=%',id_parcours;
    --on recupere les etapes du parcours
    FOR rec IN
	--SELECT * FROM contraintes.af_get_parcours_etapes_deroulees(id_parcours) AS (id int4, libelle_pour_parcours varchar, libelle_etape  varchar, type int4,  pere int4, parcours int4, obligatoire bool, chrono int4, fin bool)
	-- Modif said 17/11/06
	SELECT *,indice AS indic FROM contraintes.af_get_parcours_etapes_deroulees(id_parcours) AS (id int4, libelle_alias varchar, libelle varchar, libelle_type_etape  varchar, type varchar,  pere int4, parcours int4, obligatoire bool, chrono int4, fin bool, libelle_type_original varchar, modifiable bool)
	
	LOOP
	    IF rec.type=1 THEN
		FOR rec_p IN
		    --SELECT * FROM contraintes.af_get_parcours_etapes_deroulees(rec.id) AS (id int4, libelle_pour_parcours varchar, libelle_etape  varchar, type int4,  pere int4, parcours int4, obligatoire bool, chrono int4, fin bool)
		    -- Modif said 17/11/06
		    SELECT *,indice AS indic FROM contraintes.af_get_parcours_etapes_deroulees_formation_individu($1,$2,rec.id) AS (id int4, libelle_alias varchar, libelle varchar, libelle_type_etape  varchar, type varchar,  pere int4, parcours int4, obligatoire bool, chrono int4, fin bool, libelle_type_original varchar, modifiable bool)
			
		    LOOP
			rec_p.indic:=indice;
			RETURN NEXT rec_p;
			indice:=indice+1;
		    END LOOP;
	    ELSE 
		rec.indic:=indice;
		RETURN NEXT rec;
		indice:=indice+1;
		-- traitement spécial (sous parcours issu d'etape "parcours orienté")
		raise notice 'type=%',rec.type;
		if rec.type=10 then
		    -- test si l'etape a été faite
		    select into rec_resultat * from contraintes.af_get_resultat($1,$2,rec.parcours,rec.id) 
		    as (id bigint,formation int4, stagiaire int4, parcours int4, etape int4, date_debut timestamp, duree interval);
		    if rec_resultat.id is not null then
			raise notice 'rec_resultat.id=%',rec_resultat.id;
		        -- recup sous-parcours 
		        select into sous_parcours * from contraintes.af_get_resultat_parcours_parcours_oriente(rec_resultat.id);
		        
		        for rec_p in 
			    SELECT *,indice AS indic FROM contraintes.af_get_parcours_etapes_deroulees_formation_individu($1,$2,sous_parcours) AS (id int4, libelle_alias varchar, libelle varchar, libelle_type_etape  varchar, type varchar,  pere int4, parcours int4, obligatoire bool, chrono int4, fin bool, libelle_type_original varchar, modifiable bool)
		        loop
			    rec_p.indic:=indice;
			    RETURN NEXT rec_p;
			    indice:=indice+1;
		        end loop;
		    end if;
		end if;--else
		    
		
	    END IF;
	END LOOP;

	RETURN;
END;$_$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_get_formation_etapes_individu(integer, integer) OWNER TO pgsql;

--
-- TOC entry 7625 (class 0 OID 0)
-- Dependencies: 1047
-- Name: FUNCTION af_get_formation_etapes_individu(integer, integer); Type: COMMENT; Schema: contraintes; Owner: pgsql
--

COMMENT ON FUNCTION af_get_formation_etapes_individu(integer, integer) IS 'deroule les etapes d''une formation pour un individu y compris les etapes de sous-parcours issus d''etape parcours oriente
(suivant les resultats de l''individu)';


--
-- TOC entry 1048 (class 1255 OID 2595843)
-- Dependencies: 2983 5
-- Name: af_get_formation_etapes_reelles_individu(integer, integer); Type: FUNCTION; Schema: contraintes; Owner: pgsql
--

CREATE FUNCTION af_get_formation_etapes_reelles_individu(integer, integer) RETURNS SETOF record
    AS $_$-- $1 : formation
-- $2 : individu
declare
rec record;
begin
    for rec in
	select * from contraintes.af_get_formation_etapes_individu($1,$2)
	as (id int4, libelle_pour_parcours varchar, libelle_etape  varchar,libelle_type_etape  varchar, type varchar,  pere int4, parcours int4, obligatoire bool, chrono int4, fin bool,libelle_type_original varchar, modifiable bool, indice int4)
	where type not in ('9','10') 
	--and obligatoire is true

    loop
	return next rec;
    end loop;
end;$_$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_get_formation_etapes_reelles_individu(integer, integer) OWNER TO pgsql;

--
-- TOC entry 7627 (class 0 OID 0)
-- Dependencies: 1048
-- Name: FUNCTION af_get_formation_etapes_reelles_individu(integer, integer); Type: COMMENT; Schema: contraintes; Owner: pgsql
--

COMMENT ON FUNCTION af_get_formation_etapes_reelles_individu(integer, integer) IS 'retour les etapes d''une formation à faire réellement pour un individu';


--
-- TOC entry 1049 (class 1255 OID 2595844)
-- Dependencies: 2983 5
-- Name: af_get_formation_etapes_ressources_avancement_individu(integer, integer); Type: FUNCTION; Schema: contraintes; Owner: pgsql
--

CREATE FUNCTION af_get_formation_etapes_ressources_avancement_individu(integer, integer) RETURNS SETOF record
    AS $_$-- $1 : formation
-- $2 : individu
declare
rec record;
begin
    for rec in
	select ET.fichier,ET.fichier,ET.espace,E.libelle,ET.section,S.libelle,FI.libelle,
	--select ET.id,ET.fichier_ressource,ET.espace,E.libelle,ET.section,S.libelle,FI.libelle,
	--as(ressource int4,fichier int4,espace int4,libelle_espace varchar,section int4,libelle_section varchar,titre varchar,
	--formation int4,type int4,mots_cles text,debut timestamp,fin timestamp,nouveau interval,icone int4) )
	
	$1,FI.type,FM.mots_cles,CAST(NULL AS timestamp),cast(NULL as timestamp),cast(NULL as interval),S.icone
	from (contraintes.fichier FI left outer join contraintes.fichier_metadata FM on (FI.id=FM.id)),
	contraintes.etape_ressource ET,
	contraintes.espace E,
	contraintes.section S 
	where ET.fichier=FI.id
	and ET.espace=E.id 
	and ET.section=S.id
	and ET.id in 
	--and ET.id in 
	(select etape from contraintes.af_get_formation_avancement_individu($1,$2) as 
	(parcours int4, etape int4, formation int4, stagiaire int4, type varchar) where type=7)
    loop
	return next rec;
    end loop;
end;$_$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_get_formation_etapes_ressources_avancement_individu(integer, integer) OWNER TO pgsql;

--
-- TOC entry 7629 (class 0 OID 0)
-- Dependencies: 1049
-- Name: FUNCTION af_get_formation_etapes_ressources_avancement_individu(integer, integer); Type: COMMENT; Schema: contraintes; Owner: pgsql
--

COMMENT ON FUNCTION af_get_formation_etapes_ressources_avancement_individu(integer, integer) IS 'Retourne les ressouces des etapes des parcours faites par l''individu';


--
-- TOC entry 1050 (class 1255 OID 2595845)
-- Dependencies: 2983 5
-- Name: af_get_formation_etapes_series(integer); Type: FUNCTION; Schema: contraintes; Owner: pgsql
--

CREATE FUNCTION af_get_formation_etapes_series(integer) RETURNS SETOF record
    AS $_$-- $1 : formation
declare
rec record;
begin
    for rec in
	select fe_id , libelle_alias , libelle, libelle_type_etape,fe_type,  pere , parcours, obligatoire, chrono , fin,libelle_type_original,modifiable
	from 
	contraintes.af_get_formation_etapes_type($1,'4_1%') AS (fe_id int4, libelle_alias varchar, libelle varchar, libelle_type_etape  varchar, fe_type varchar,  pere int4, parcours int4, obligatoire bool, chrono int4, fin bool, libelle_type_original varchar, modifiable bool,indice int4)
    loop
	return next rec;
    end loop;
end;$_$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_get_formation_etapes_series(integer) OWNER TO pgsql;

--
-- TOC entry 7631 (class 0 OID 0)
-- Dependencies: 1050
-- Name: FUNCTION af_get_formation_etapes_series(integer); Type: COMMENT; Schema: contraintes; Owner: pgsql
--

COMMENT ON FUNCTION af_get_formation_etapes_series(integer) IS 'retourne les series d''une formation';


--
-- TOC entry 1051 (class 1255 OID 2595846)
-- Dependencies: 2983 5
-- Name: af_get_formation_etapes_type(integer, character varying); Type: FUNCTION; Schema: contraintes; Owner: pgsql
--

CREATE FUNCTION af_get_formation_etapes_type(integer, character varying) RETURNS SETOF record
    AS $_$-- $1 : formation
-- $2 : type
declare
rec record;
begin
    for rec in 
	select * from contraintes.af_get_formation_etapes($1) AS (id int4, libelle_alias varchar, libelle varchar, libelle_type_etape  varchar, type varchar,  pere int4, parcours int4, obligatoire bool, chrono int4, fin bool, libelle_type_original varchar, modifiable bool,indice int4)
	where type LIKE $2
    loop 
	return next rec;
    end loop;
end;$_$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_get_formation_etapes_type(integer, character varying) OWNER TO pgsql;

--
-- TOC entry 7633 (class 0 OID 0)
-- Dependencies: 1051
-- Name: FUNCTION af_get_formation_etapes_type(integer, character varying); Type: COMMENT; Schema: contraintes; Owner: pgsql
--

COMMENT ON FUNCTION af_get_formation_etapes_type(integer, character varying) IS 'Retourne les etapes d''un type pour une formation';


--
-- TOC entry 1052 (class 1255 OID 2595847)
-- Dependencies: 2983 5
-- Name: af_get_formation_evenement(integer, timestamp without time zone); Type: FUNCTION; Schema: contraintes; Owner: pgsql
--

CREATE FUNCTION af_get_formation_evenement(integer, timestamp without time zone) RETURNS record
    AS $_$-- $1 numero formation
-- $2 date (timestamp)
declare
rec record;
begin
    select into rec formation,libelle,date,duree,modalite,intervention,intervenant,salle 
    from contraintes.evenement where formation=$1 and date=$2;
    return rec;
end;$_$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_get_formation_evenement(integer, timestamp without time zone) OWNER TO pgsql;

--
-- TOC entry 7635 (class 0 OID 0)
-- Dependencies: 1052
-- Name: FUNCTION af_get_formation_evenement(integer, timestamp without time zone); Type: COMMENT; Schema: contraintes; Owner: pgsql
--

COMMENT ON FUNCTION af_get_formation_evenement(integer, timestamp without time zone) IS 'retourne un evenement d''une formation';


--
-- TOC entry 1053 (class 1255 OID 2595848)
-- Dependencies: 2983 5
-- Name: af_get_formation_evenements(integer); Type: FUNCTION; Schema: contraintes; Owner: pgsql
--

CREATE FUNCTION af_get_formation_evenements(integer) RETURNS SETOF record
    AS $_$-- $1 : formation
declare
rec record;
begin
    for rec in
	select * from contraintes.evenement 
	where formation=$1 order by date
    loop
	return next rec;
    end loop;
end;$_$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_get_formation_evenements(integer) OWNER TO pgsql;

--
-- TOC entry 7637 (class 0 OID 0)
-- Dependencies: 1053
-- Name: FUNCTION af_get_formation_evenements(integer); Type: COMMENT; Schema: contraintes; Owner: pgsql
--

COMMENT ON FUNCTION af_get_formation_evenements(integer) IS 'retourne tous les evenements d''une formation';


--
-- TOC entry 1054 (class 1255 OID 2595849)
-- Dependencies: 2983 5
-- Name: af_get_formation_evenements_periode(integer, timestamp without time zone, timestamp without time zone); Type: FUNCTION; Schema: contraintes; Owner: pgsql
--

CREATE FUNCTION af_get_formation_evenements_periode(integer, timestamp without time zone, timestamp without time zone) RETURNS SETOF record
    AS $_$-- $1 : numero formation
-- $2 : debut
-- $3 : fin
declare
rec record;
req varchar;
begin
    /*	
    for rec in
	select formation,libelle,date,duree,modalite,intervention,intervenant,salle
	from contraintes.evenement
	where formation=$1
	and date between $2 and $3
    loop
	return next rec;
    end loop;
   */ 

    req:='select formation,libelle,date,duree,modalite,intervention,intervenant,salle 
		from contraintes.evenement where formation='||$1;
    if $2!=$3 then
	req:=req||' and date between '''||$2||''' and '''||$3||'''';
    else
	req:=req||' and date='''||$2||'''';
    end if;

    -- order by
    req:=req||'order by (date + duree)';  
    
    --RAISE NOTICE 'req: %',req;
    for rec in
	execute req
    loop
	return next rec;
    end loop;

end;$_$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_get_formation_evenements_periode(integer, timestamp without time zone, timestamp without time zone) OWNER TO pgsql;

--
-- TOC entry 7639 (class 0 OID 0)
-- Dependencies: 1054
-- Name: FUNCTION af_get_formation_evenements_periode(integer, timestamp without time zone, timestamp without time zone); Type: COMMENT; Schema: contraintes; Owner: pgsql
--

COMMENT ON FUNCTION af_get_formation_evenements_periode(integer, timestamp without time zone, timestamp without time zone) IS 'retourne les evenements d''une formation pour une periode donnée';


--
-- TOC entry 1055 (class 1255 OID 2595850)
-- Dependencies: 2983 5
-- Name: af_get_formation_evenements_presentiels(integer); Type: FUNCTION; Schema: contraintes; Owner: pgsql
--

CREATE FUNCTION af_get_formation_evenements_presentiels(integer) RETURNS SETOF record
    AS $_$-- $1 : formation
declare
rec record;
begin
    for rec in
	select formation,libelle,date,duree,modalite,intervention,intervenant,salle 
	from contraintes.evenement 
	where formation=$1 and modalite=3
    loop
	return next rec;
    end loop;
end;$_$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_get_formation_evenements_presentiels(integer) OWNER TO pgsql;

--
-- TOC entry 7641 (class 0 OID 0)
-- Dependencies: 1055
-- Name: FUNCTION af_get_formation_evenements_presentiels(integer); Type: COMMENT; Schema: contraintes; Owner: pgsql
--

COMMENT ON FUNCTION af_get_formation_evenements_presentiels(integer) IS 'retourne les evenements presentiels d''une formation';


--
-- TOC entry 20 (class 1255 OID 2595851)
-- Dependencies: 2150 2983 5
-- Name: af_get_formation_evolution_reelle_individu(integer, integer); Type: FUNCTION; Schema: contraintes; Owner: pgsql
--

CREATE FUNCTION af_get_formation_evolution_reelle_individu(integer, integer) RETURNS evolution
    AS $_$-- $1 : formation
-- $2 : individu
declare 
nb_etapes_reelles_faites integer;
nb_etapes_total integer;
evolution contraintes.evolution;
begin
    -- total
    select count(*) into nb_etapes_total 
    from contraintes.af_get_formation_etapes_reelles_individu($1,$2)
    as(id int4, libelle_pour_parcours varchar, libelle_etape  varchar,libelle_type_etape  varchar, type varchar,  pere int4, parcours int4, obligatoire bool, chrono int4, fin bool,libelle_type_original varchar, modifiable bool, indice int4);
    -- nb etaptes reelles faites
    select count(*) into nb_etapes_reelles_faites 
    from contraintes.resultat
    where formation=$1 and stagiaire=$2 and duree is not null and etape 
    in (select id from contraintes.etape where type not in ('1','9','10'));
    evolution.fait=nb_etapes_reelles_faites;
    evolution.total=nb_etapes_total;
    return evolution; 
    	
end;$_$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_get_formation_evolution_reelle_individu(integer, integer) OWNER TO pgsql;

--
-- TOC entry 7643 (class 0 OID 0)
-- Dependencies: 20
-- Name: FUNCTION af_get_formation_evolution_reelle_individu(integer, integer); Type: COMMENT; Schema: contraintes; Owner: pgsql
--

COMMENT ON FUNCTION af_get_formation_evolution_reelle_individu(integer, integer) IS 'retourne le nb d''etapes reelles effectuées et le nombres d''etapes total pour un individu et une formation';


--
-- TOC entry 1844 (class 1255 OID 2595852)
-- Dependencies: 2983 5
-- Name: af_get_formation_exostlc_fichier_rendu(integer); Type: FUNCTION; Schema: contraintes; Owner: pgsql
--

CREATE FUNCTION af_get_formation_exostlc_fichier_rendu(integer) RETURNS SETOF record
    AS $_$-- $1 : formation
declare
rec record;
begin
    for rec in 
	select distinct g_id,e.libelle,r.formation,r.parcours from contraintes.af_get_exotlcs() 
	as (g_id int4,g_commentaire varchar,texte varchar,enonce varchar,remarque varchar,type int4),
	contraintes.etape e,
	contraintes.resultat r,contraintes.resultat_exotlc re 
	where g_id=r.etape and g_id=e.id and r.formation=$1 and r.id=re.id and fichier_rendu is not null
    loop
	return next rec;
    end loop;
end;$_$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_get_formation_exostlc_fichier_rendu(integer) OWNER TO pgsql;

--
-- TOC entry 7645 (class 0 OID 0)
-- Dependencies: 1844
-- Name: FUNCTION af_get_formation_exostlc_fichier_rendu(integer); Type: COMMENT; Schema: contraintes; Owner: pgsql
--

COMMENT ON FUNCTION af_get_formation_exostlc_fichier_rendu(integer) IS 'retourne les exotlc dont le fichier est rendu pour une formation donnee';


--
-- TOC entry 1056 (class 1255 OID 2595853)
-- Dependencies: 2983 5
-- Name: af_get_formation_formateur(integer); Type: FUNCTION; Schema: contraintes; Owner: pgsql
--

CREATE FUNCTION af_get_formation_formateur(integer) RETURNS record
    AS $_$DECLARE
--$1 formation
rec RECORD;
BEGIN
	
	SELECT INTO rec I.id,  I.nom ||' '|| I.prenom, PF.formation
	FROM contraintes.formation_participants PF, contraintes.fw_individu I
	WHERE formation=$1
	AND PF.formateur=I.id;

	RETURN rec;

END;$_$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_get_formation_formateur(integer) OWNER TO pgsql;

--
-- TOC entry 1057 (class 1255 OID 2595854)
-- Dependencies: 2983 5
-- Name: af_get_formation_forums(integer); Type: FUNCTION; Schema: contraintes; Owner: pgsql
--

CREATE FUNCTION af_get_formation_forums(integer) RETURNS SETOF record
    AS $_$-- $1 : formation
declare
rec record;
begin
    for rec in 
	select id,libelle,description,moderation,moderateur_pwd,fils,messages,upload,theme from contraintes.forum,contraintes.formation_forums 
	where id=forum and formation=$1
    loop
	return next rec;
    end loop;
end;$_$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_get_formation_forums(integer) OWNER TO pgsql;

--
-- TOC entry 7648 (class 0 OID 0)
-- Dependencies: 1057
-- Name: FUNCTION af_get_formation_forums(integer); Type: COMMENT; Schema: contraintes; Owner: pgsql
--

COMMENT ON FUNCTION af_get_formation_forums(integer) IS 'retourne les forums d''une formation';


--
-- TOC entry 1058 (class 1255 OID 2595855)
-- Dependencies: 2983 5
-- Name: af_get_formation_forums_disponibles(integer); Type: FUNCTION; Schema: contraintes; Owner: pgsql
--

CREATE FUNCTION af_get_formation_forums_disponibles(integer) RETURNS SETOF record
    AS $_$-- $1 : formation
declare
rec record;
begin
    for rec in 
	select id,libelle from contraintes.forum 
	where id not in (select forum from contraintes.formation_forums where formation=$1)
    loop
	return next rec;
    end loop;
end;$_$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_get_formation_forums_disponibles(integer) OWNER TO pgsql;

--
-- TOC entry 7650 (class 0 OID 0)
-- Dependencies: 1058
-- Name: FUNCTION af_get_formation_forums_disponibles(integer); Type: COMMENT; Schema: contraintes; Owner: pgsql
--

COMMENT ON FUNCTION af_get_formation_forums_disponibles(integer) IS 'retourne les forums dispo pour une formation';


--
-- TOC entry 1059 (class 1255 OID 2595856)
-- Dependencies: 2983 5
-- Name: af_get_formation_grilles(integer); Type: FUNCTION; Schema: contraintes; Owner: pgsql
--

CREATE FUNCTION af_get_formation_grilles(integer) RETURNS SETOF record
    AS $_$-- $1 : formation
declare
rec record;
begin
    for rec in
	select distinct id,libelle from 
	contraintes.grille,
	contraintes.grille_resultats gr 
	where gr.formation=$1 and id=gr.grille
    loop
	return next rec;
    end loop;
end;$_$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_get_formation_grilles(integer) OWNER TO pgsql;

--
-- TOC entry 7652 (class 0 OID 0)
-- Dependencies: 1059
-- Name: FUNCTION af_get_formation_grilles(integer); Type: COMMENT; Schema: contraintes; Owner: pgsql
--

COMMENT ON FUNCTION af_get_formation_grilles(integer) IS 'retourne les grilles presentielles pour une formation';


--
-- TOC entry 1060 (class 1255 OID 2595857)
-- Dependencies: 2983 5
-- Name: af_get_formation_individu_parcours_exotlcs_score(integer, integer, integer); Type: FUNCTION; Schema: contraintes; Owner: pgsql
--

CREATE FUNCTION af_get_formation_individu_parcours_exotlcs_score(integer, integer, integer) RETURNS real
    AS $_$-- $1 : formation
-- $2 : individu
-- $3 : parcours
declare
rec record;
rec_resultat record;
id_resultat bigint;
total real;
res real;
nb integer;
begin
    -- boucle sur les series du parcours
    nb:=0;
    total:=0;
    for rec in
	select * from contraintes.af_get_parcours_etapes_type($3,'5') 
	AS (id int4, libelle_alias varchar, libelle varchar, libelle_type_etape  varchar, type varchar,  pere int4, parcours int4, obligatoire bool, chrono int4, fin bool, libelle_type_original varchar, modifiable bool, indice int4)
    loop
	if rec.obligatoire is true then
	    -- recup id resultat
	    select into rec_resultat * from contraintes.af_get_resultat($1,$2,$3,rec.id) 
	    AS (id bigint,formation int4, stagiaire int4, parcours int4, etape int4, date_debut timestamp, duree interval);
	    raise notice 'rec=%',rec_resultat.id;
	    select into res * from contraintes.af_get_resultat_exotlc_moyenne(rec_resultat.id);
	    raise notice 'res=%',res;
	    total:=total+res;
	    nb:=nb+1;
	end if;
    end loop;
    if nb=0 then
	return null;
    else
	return total/nb;
    end if;
end;$_$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_get_formation_individu_parcours_exotlcs_score(integer, integer, integer) OWNER TO pgsql;

--
-- TOC entry 7654 (class 0 OID 0)
-- Dependencies: 1060
-- Name: FUNCTION af_get_formation_individu_parcours_exotlcs_score(integer, integer, integer); Type: COMMENT; Schema: contraintes; Owner: pgsql
--

COMMENT ON FUNCTION af_get_formation_individu_parcours_exotlcs_score(integer, integer, integer) IS 'retoune la note sur 20 pour les exotlcs d''un parcours (pour un individu,une formation)';


--
-- TOC entry 1061 (class 1255 OID 2595858)
-- Dependencies: 2983 5
-- Name: af_get_formation_individu_parcours_score(integer, integer, integer); Type: FUNCTION; Schema: contraintes; Owner: pgsql
--

CREATE FUNCTION af_get_formation_individu_parcours_score(integer, integer, integer) RETURNS real
    AS $_$-- $1 : formation
-- $2 : individu
-- $3 : parcours
declare
score_series real;
score_exotlcs real;
total real;
nb integer;
begin
    nb:=0;
    total:=0;
    select into score_series * from contraintes.af_get_formation_individu_parcours_series_score($1,$2,$3);
    if score_series is not null then
	total:=total+score_series;
	nb:=nb+1;
    end if;
    select into score_exotlcs * from contraintes.af_get_formation_individu_parcours_exotlcs_score($1,$2,$3);
    if score_exotlcs is not null then
	total:=total+score_exotlcs;
	nb:=nb+1;
    end if;
    if nb=0 then
	return false;
    else
	return total/nb;
    end if;
    

end;$_$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_get_formation_individu_parcours_score(integer, integer, integer) OWNER TO pgsql;

--
-- TOC entry 7656 (class 0 OID 0)
-- Dependencies: 1061
-- Name: FUNCTION af_get_formation_individu_parcours_score(integer, integer, integer); Type: COMMENT; Schema: contraintes; Owner: pgsql
--

COMMENT ON FUNCTION af_get_formation_individu_parcours_score(integer, integer, integer) IS 'retourne le score pour un parcours,un individu et une formation';


--
-- TOC entry 1062 (class 1255 OID 2595859)
-- Dependencies: 2983 5
-- Name: af_get_formation_individu_parcours_series_score(integer, integer, integer); Type: FUNCTION; Schema: contraintes; Owner: pgsql
--

CREATE FUNCTION af_get_formation_individu_parcours_series_score(integer, integer, integer) RETURNS real
    AS $_$-- $1 : formation
-- $2 : individu
-- $3 : parcours
declare
rec record;
rec_resultat record;
id_resultat bigint;
total real;
res real;
nb integer;
begin
    -- boucle sur les series du parcours
    nb:=0;
    total:=0;
    for rec in
	select * from contraintes.af_get_parcours_etapes_type($3,'4') 
	AS (id int4, libelle_alias varchar, libelle varchar, libelle_type_etape  varchar, type varchar,  pere int4, parcours int4, obligatoire bool, chrono int4, fin bool, libelle_type_original varchar, modifiable bool, indice int4)
    loop
	if rec.type<>'4_1_0_2' and rec.obligatoire is true then
	    -- recup id resultat
	    select into rec_resultat * from contraintes.af_get_resultat($1,$2,$3,rec.id) 
	    AS (id bigint,formation int4, stagiaire int4, parcours int4, etape int4, date_debut timestamp, duree interval);
	    raise notice 'rec=%',rec_resultat.id;
	    select into res * from contraintes.af_get_resultat_serie_score(rec_resultat.id);
	    raise notice 'res=%',res;
	    total:=total+res;
	    nb:=nb+1;
	end if;
    end loop;
    if nb=0 then
	return null;
    else
        return total/nb;
    end if;
end;$_$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_get_formation_individu_parcours_series_score(integer, integer, integer) OWNER TO pgsql;

--
-- TOC entry 7658 (class 0 OID 0)
-- Dependencies: 1062
-- Name: FUNCTION af_get_formation_individu_parcours_series_score(integer, integer, integer); Type: COMMENT; Schema: contraintes; Owner: pgsql
--

COMMENT ON FUNCTION af_get_formation_individu_parcours_series_score(integer, integer, integer) IS 'retoune la note sur 20 pour les series d''un parcours (pour un individu,une formation)';


--
-- TOC entry 1063 (class 1255 OID 2595860)
-- Dependencies: 2983 5
-- Name: af_get_formation_individus(integer); Type: FUNCTION; Schema: contraintes; Owner: pgsql
--

CREATE FUNCTION af_get_formation_individus(integer) RETURNS SETOF record
    AS $_$-- $1 : formation
declare
rec record;
rec2 record;
begin
    -- Boucle sur les classes de la formation
    for rec in
	select id,libelle,pere,min,max from contraintes.af_get_formation_classes($1)  as (id int4,libelle varchar, pere int4,min int4,max int4)
    loop
	for rec2 in
	    select distinct id,nom,prenom,organisme 
	    from contraintes.af_get_classe_individus(rec.id,0,'asc',false)  
        loop
	    return next rec2;
        end loop;
    end loop;
end;$_$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_get_formation_individus(integer) OWNER TO pgsql;

--
-- TOC entry 7660 (class 0 OID 0)
-- Dependencies: 1063
-- Name: FUNCTION af_get_formation_individus(integer); Type: COMMENT; Schema: contraintes; Owner: pgsql
--

COMMENT ON FUNCTION af_get_formation_individus(integer) IS 'retourne les individus d''une formation 
(ceux qui sont dans la classe)';


--
-- TOC entry 1064 (class 1255 OID 2595861)
-- Dependencies: 2983 5
-- Name: af_get_formation_individus(integer, integer); Type: FUNCTION; Schema: contraintes; Owner: pgsql
--

CREATE FUNCTION af_get_formation_individus(integer, integer) RETURNS SETOF record
    AS $_$-- $1 : formation
-- $2 : classe
declare
rec record;
rec2 record;
begin
    -- Boucle sur les classes de la formation
    for rec in
	select id,libelle,pere,min,max from contraintes.af_get_formation_classes($1)
    loop
	for rec2 in
	    select distinct id,nom,prenom,organisme 
	    from contraintes.af_get_classe_individus(rec.id,0,'asc',false) 
        loop
	    return next rec2;
        end loop;
    end loop;
end;$_$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_get_formation_individus(integer, integer) OWNER TO pgsql;

--
-- TOC entry 1065 (class 1255 OID 2595862)
-- Dependencies: 2983 5
-- Name: af_get_formation_individus_except_individus_types(integer, integer[]); Type: FUNCTION; Schema: contraintes; Owner: pgsql
--

CREATE FUNCTION af_get_formation_individus_except_individus_types(integer, integer[]) RETURNS SETOF record
    AS $_$-- $1 : formation
-- $2 : types d'individus à exclure
declare
rec record;
rec2 record;
begin
    -- Boucle sur les classes de la formation
    for rec in
	select id,libelle,pere,min,max from contraintes.af_get_formation_classes($1)  as (id int4,libelle varchar, pere int4,min int4,max int4)
    loop
	for rec2 in
	    select distinct id,nom,prenom,organisme 
	    from contraintes.af_get_classe_individus_except_individus_types(rec.id,$2,'asc',false)
	    --from contraintes.af_get_classe_individus_except_individus_types(rec.id,$2,'asc',true) 
	    	
        loop
	    return next rec2;
        end loop;
    end loop;
end;$_$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_get_formation_individus_except_individus_types(integer, integer[]) OWNER TO pgsql;

--
-- TOC entry 7663 (class 0 OID 0)
-- Dependencies: 1065
-- Name: FUNCTION af_get_formation_individus_except_individus_types(integer, integer[]); Type: COMMENT; Schema: contraintes; Owner: pgsql
--

COMMENT ON FUNCTION af_get_formation_individus_except_individus_types(integer, integer[]) IS 'retourne les individus d''une formation 
(ceux qui sont dans les classes) et qui ne sont pas de certains types';


--
-- TOC entry 1066 (class 1255 OID 2595863)
-- Dependencies: 2983 5
-- Name: af_get_formation_intervenants(integer); Type: FUNCTION; Schema: contraintes; Owner: pgsql
--

CREATE FUNCTION af_get_formation_intervenants(integer) RETURNS SETOF record
    AS $_$-- $1 : formation
declare
rec record;
begin
    for rec in
	select distinct id,nom,prenom from contraintes.fw_individu i ,contraintes.evenement 
	where id=intervenant and formation=$1
    loop
	return next rec;
    end loop;
end;$_$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_get_formation_intervenants(integer) OWNER TO pgsql;

--
-- TOC entry 7665 (class 0 OID 0)
-- Dependencies: 1066
-- Name: FUNCTION af_get_formation_intervenants(integer); Type: COMMENT; Schema: contraintes; Owner: pgsql
--

COMMENT ON FUNCTION af_get_formation_intervenants(integer) IS 'retourne les intervenants de la formation';


--
-- TOC entry 1067 (class 1255 OID 2595864)
-- Dependencies: 2983 5
-- Name: af_get_formation_langues(integer); Type: FUNCTION; Schema: contraintes; Owner: pgsql
--

CREATE FUNCTION af_get_formation_langues(integer) RETURNS SETOF record
    AS $_$DECLARE
--$1 formation
rec RECORD;
BEGIN
	FOR rec IN
		SELECT id, libelle , code , locale , formation 
		FROM contraintes.formation_langues, contraintes.af_get_langues() AS (id int4,libelle varchar, code varchar, locale varchar) 
		WHERE formation=$1
		AND langue=id
	LOOP
		RETURN NEXT rec;
	END LOOP;

	RETURN;
END;$_$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_get_formation_langues(integer) OWNER TO pgsql;

--
-- TOC entry 1068 (class 1255 OID 2595865)
-- Dependencies: 2983 5
-- Name: af_get_formation_parcourss_ressources(integer); Type: FUNCTION; Schema: contraintes; Owner: pgsql
--

CREATE FUNCTION af_get_formation_parcourss_ressources(integer) RETURNS SETOF record
    AS $_$-- $1 : formation
declare
rec record;
rec_etape record;
rec_ress record;
begin
    -- Boucle sur les etapes ressources de la formation
    for rec in
	select * from contraintes.af_get_formation_etapes_type($1,'7') 
	as (id int4, libelle_pour_parcours varchar, libelle_etape  varchar,libelle_type_etape  varchar, type varchar,  pere int4, parcours int4, obligatoire bool, chrono int4, fin bool,libelle_type_original varchar, modifiable bool,indice int4)
    loop
	-- Filtre sur espace,section et ressource
	select into rec_etape * from contraintes.af_get_etape_ressource(rec.id) 
	as (id int4,libelle varchar,espace int4, section int4, ressource int4, fichier int4,mots_cles text,date_creation timestamp);
	raise notice 'esp=% section=% ress=%',rec_etape.espace,rec_etape.section,rec_etape.ressource;
	if rec_etape.espace is not null and rec_etape.section is not null and rec_etape.ressource is not null then
	    for rec_ress in 
	        select * from contraintes.af_get_etape_ressource_infos(rec_etape.espace,rec_etape.section,rec_etape.ressource) 
		as(r_ressource int4,r_fichier int4,r_espace int4,r_libelle_espace varchar,r_section int4,r_libelle_section varchar,r_titre varchar,r_formation int4,r_type int4,r_mots_cles text,r_debut timestamp,r_fin timestamp,r_nouveau interval,r_icone int4)
	    loop
		--raise notice 'ress=% fic=%'rec_ress.r_ressource,rec_ress.r_fichier;
		return next rec_ress;
	    end loop;
	end if;

    end loop;
end;$_$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_get_formation_parcourss_ressources(integer) OWNER TO pgsql;

--
-- TOC entry 7668 (class 0 OID 0)
-- Dependencies: 1068
-- Name: FUNCTION af_get_formation_parcourss_ressources(integer); Type: COMMENT; Schema: contraintes; Owner: pgsql
--

COMMENT ON FUNCTION af_get_formation_parcourss_ressources(integer) IS 'retourne les ressources (affichables) des parcours d''ine formation';


--
-- TOC entry 1845 (class 1255 OID 2595866)
-- Dependencies: 2983 5
-- Name: af_get_formation_participants(integer); Type: FUNCTION; Schema: contraintes; Owner: pgsql
--

CREATE FUNCTION af_get_formation_participants(integer) RETURNS SETOF record
    AS $_$DECLARE
--$1 formation
rec RECORD;
BEGIN
	FOR rec IN
		SELECT formation, formateur, classe
		FROM contraintes.formation_participants
		WHERE formation=$1
	LOOP
		RETURN NEXT rec;
	END LOOP;

	RETURN;
END$_$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_get_formation_participants(integer) OWNER TO pgsql;

--
-- TOC entry 1069 (class 1255 OID 2595867)
-- Dependencies: 2983 5
-- Name: af_get_formation_ressource(integer, integer, integer, integer); Type: FUNCTION; Schema: contraintes; Owner: pgsql
--

CREATE FUNCTION af_get_formation_ressource(integer, integer, integer, integer) RETURNS record
    AS $_$-- $1 : formation
-- $2 : espace
-- $3 : section
-- $4 : fichier_ressource
declare
rec record;
begin
    select into rec * FROM
	contraintes.af_get_formation_ressources($1,TRUE) 
	as(fichier_ressource int4,fichier_ressource_bis int4,espace int4,libelle_espace varchar,section int4,libelle_section varchar,titre varchar,formation int4,type int4,mots_cles text,debut timestamp,fin timestamp,nouveau interval,icone int4)
	WHERE 
	formation=$1 and espace=$2 and (section=$3 or section is null) and fichier_ressource=$4;  

	return rec;
end;$_$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_get_formation_ressource(integer, integer, integer, integer) OWNER TO pgsql;

--
-- TOC entry 7671 (class 0 OID 0)
-- Dependencies: 1069
-- Name: FUNCTION af_get_formation_ressource(integer, integer, integer, integer); Type: COMMENT; Schema: contraintes; Owner: pgsql
--

COMMENT ON FUNCTION af_get_formation_ressource(integer, integer, integer, integer) IS 'retourne les info d''une ressource de formation';


--
-- TOC entry 1070 (class 1255 OID 2595868)
-- Dependencies: 2983 5
-- Name: af_get_formation_ressource_nouveaute(integer, integer, integer, integer); Type: FUNCTION; Schema: contraintes; Owner: pgsql
--

CREATE FUNCTION af_get_formation_ressource_nouveaute(integer, integer, integer, integer) RETURNS boolean
    AS $_$DECLARE
--$1 = numero de formation
--$2 = numero d'espace
--$3 = numero de section
--$4 = numero de ressource
rec record;
date_total TIMESTAMP;
BEGIN
	FOR rec IN
	select *  
	from contraintes.af_get_formation_ressource($1,$2,$3,$4) 
	as(ressource int4,fichier int4,espace int4,libelle_espace varchar,section int4,libelle_section varchar,titre varchar,formation int4,type int4,mots_cles text,debut timestamp,fin timestamp,nouveau interval,icone int4) 
	LOOP
		date_total:= rec.debut + rec.nouveau;
		IF date_total >= now() THEN
			return true;
		END IF;
	END LOOP;
	return false;
END;
$_$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_get_formation_ressource_nouveaute(integer, integer, integer, integer) OWNER TO pgsql;

--
-- TOC entry 7673 (class 0 OID 0)
-- Dependencies: 1070
-- Name: FUNCTION af_get_formation_ressource_nouveaute(integer, integer, integer, integer); Type: COMMENT; Schema: contraintes; Owner: pgsql
--

COMMENT ON FUNCTION af_get_formation_ressource_nouveaute(integer, integer, integer, integer) IS 'Fonction qui retourne un boolean pour une ressource, cela confirm si elle est nouvelle ou non.';


--
-- TOC entry 1071 (class 1255 OID 2595869)
-- Dependencies: 2983 5
-- Name: af_get_formation_ressources(integer); Type: FUNCTION; Schema: contraintes; Owner: pgsql
--

CREATE FUNCTION af_get_formation_ressources(integer) RETURNS SETOF record
    AS $_$DECLARE
--$1 formation
rec RECORD;
BEGIN
    FOR rec IN
	SELECT FR.fichier_ressource,FR.fichier_ressource,FR.espace,E.libelle, FR.section,S.libelle,FI.libelle,FR.formation,FI.type,FM.mots_cles, FR.debut_disponibilite, FR.fin_disponibilite, FR.duree_nouveaute,S.icone
	FROM 
	((contraintes.fichier FI LEFT OUTER JOIN contraintes.fichier_metadata FM 
	ON (FI.id=FM.id))inner join 
	contraintes.formation_ressources FR on (FR.fichier_ressource=FI.id )inner join  
	contraintes.espace E on (FR.espace=E.id )) 
	left outer join contraintes.section S on (FR.section=S.id )  
	WHERE 
	FR.formation=$1 
	
	
		
	LOOP
		RETURN NEXT rec;
	END LOOP;

	RETURN;
END;$_$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_get_formation_ressources(integer) OWNER TO pgsql;

--
-- TOC entry 1846 (class 1255 OID 2595870)
-- Dependencies: 2983 5
-- Name: af_get_formation_ressources(integer, boolean); Type: FUNCTION; Schema: contraintes; Owner: pgsql
--

CREATE FUNCTION af_get_formation_ressources(integer, boolean) RETURNS SETOF record
    AS $_$DECLARE
--$1 formations
--$2 booléen, si true retourne toutes les ressources indépendament de leurs dates, si false, retourne uniquement les ressources dont les dates sont ok
rec RECORD;
BEGIN

	IF $2 IS TRUE THEN 
		FOR rec IN
			select * from contraintes.af_get_formation_ressources($1) 
			as(ressource int4,fichier int4,espace int4,libelle_espace varchar,section int4,libelle_section varchar,titre varchar,formation int4,type int4,mots_cles text,debut_disponibilite timestamp,fin_disponibilite timestamp,nouveau interval,icone int4)
		LOOP
			RETURN NEXT rec;
		END LOOP;
	ELSE
		FOR rec IN
			select * from contraintes.af_get_formation_ressources($1) 
			as(ressource int4,fichier int4,espace int4,libelle_espace varchar,section int4,libelle_section varchar,titre varchar,formation int4,type int4,mots_cles text,debut_disponibilite timestamp,fin_disponibilite timestamp,nouveau interval,icone int4)
			WHERE now() BETWEEN debut_disponibilite AND (fin_disponibilite + '1 day')
		LOOP
			RETURN NEXT rec;
		END LOOP;
	END IF;
	RETURN;
END;$_$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_get_formation_ressources(integer, boolean) OWNER TO pgsql;

--
-- TOC entry 1072 (class 1255 OID 2595871)
-- Dependencies: 2983 5
-- Name: af_get_formation_ressources_nouveaute(integer); Type: FUNCTION; Schema: contraintes; Owner: pgsql
--

CREATE FUNCTION af_get_formation_ressources_nouveaute(integer) RETURNS boolean
    AS $_$DECLARE
--$1 = numero de formation
rec record;
date_total TIMESTAMP;
BEGIN
	FOR rec IN
	select *  
	from contraintes.af_get_formation_ressources($1,FALSE) 
	as(ressource int4,fichier int4,espace int4,libelle_espace varchar,section int4,libelle_section varchar,titre varchar,formation int4,type int4,mots_cles text,debut timestamp,fin timestamp,nouveau interval,icone int4) 
	LOOP
		date_total:= rec.debut + rec.nouveau;
		IF date_total >= now() THEN
			return true;
		END IF;
	END LOOP;
	return false;

END;
$_$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_get_formation_ressources_nouveaute(integer) OWNER TO pgsql;

--
-- TOC entry 7677 (class 0 OID 0)
-- Dependencies: 1072
-- Name: FUNCTION af_get_formation_ressources_nouveaute(integer); Type: COMMENT; Schema: contraintes; Owner: pgsql
--

COMMENT ON FUNCTION af_get_formation_ressources_nouveaute(integer) IS 'Fonction qui retourne true ou false si une des ressources est nouvelle.';


--
-- TOC entry 1073 (class 1255 OID 2595872)
-- Dependencies: 2983 5
-- Name: af_get_formation_salles(integer); Type: FUNCTION; Schema: contraintes; Owner: pgsql
--

CREATE FUNCTION af_get_formation_salles(integer) RETURNS SETOF record
    AS $_$-- $1 : formation
declare 
rec record;
begin
    for rec in
	select distinct s_id,s_libelle from contraintes.af_get_salles() as (s_id int4,s_libelle varchar),contraintes.evenement 
	where s_id=salle and formation=$1
    loop
	return next rec;
    end loop;
end;$_$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_get_formation_salles(integer) OWNER TO pgsql;

--
-- TOC entry 7679 (class 0 OID 0)
-- Dependencies: 1073
-- Name: FUNCTION af_get_formation_salles(integer); Type: COMMENT; Schema: contraintes; Owner: pgsql
--

COMMENT ON FUNCTION af_get_formation_salles(integer) IS 'retourne les salles de la formation';


--
-- TOC entry 1074 (class 1255 OID 2595873)
-- Dependencies: 2983 5
-- Name: af_get_formation_sections(integer); Type: FUNCTION; Schema: contraintes; Owner: pgsql
--

CREATE FUNCTION af_get_formation_sections(integer) RETURNS SETOF record
    AS $_$DECLARE
--$1 formation
rec RECORD;
BEGIN
    FOR rec IN
	SELECT FR.espace,E.libelle, FR.section,S.libelle,S.icone,FR.formation
	FROM 
	contraintes.formation_ressources FR,
	contraintes.espace E,
	contraintes.section S
	WHERE 
	FR.formation=$1 
	and FR.espace=E.id 
	and FR.section=S.id 
	LOOP
		RETURN NEXT rec;
	END LOOP;

	RETURN;
END;$_$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_get_formation_sections(integer) OWNER TO pgsql;

--
-- TOC entry 1075 (class 1255 OID 2595874)
-- Dependencies: 2983 5
-- Name: af_get_formation_session(integer); Type: FUNCTION; Schema: contraintes; Owner: pgsql
--

CREATE FUNCTION af_get_formation_session(integer) RETURNS record
    AS $_$-- $1 : formation
declare
rec record;
begin
    select into rec * from contraintes.formation_session where formation=$1;
    return rec;
end;$_$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_get_formation_session(integer) OWNER TO pgsql;

--
-- TOC entry 7682 (class 0 OID 0)
-- Dependencies: 1075
-- Name: FUNCTION af_get_formation_session(integer); Type: COMMENT; Schema: contraintes; Owner: pgsql
--

COMMENT ON FUNCTION af_get_formation_session(integer) IS 'retourne les temps d''inactivité et de session pour une formation';


--
-- TOC entry 1076 (class 1255 OID 2595875)
-- Dependencies: 2983 5
-- Name: af_get_formation_stagiaires_correction(integer, integer, integer); Type: FUNCTION; Schema: contraintes; Owner: pgsql
--

CREATE FUNCTION af_get_formation_stagiaires_correction(integer, integer, integer) RETURNS SETOF record
    AS $_$-- $1 : formation
-- $2 : exotlc
-- $3 : classe
declare
rec record;
begin
    for rec in 
	select id,stagiaires_non_corriges.nom,stagiaires_non_corriges.prenom,date_correction
	from
	--(
	    --(
		(
		select ci1.id,nom,prenom 
		from contraintes.af_get_classe_individus($3,0,'asc',false) ci1 
		) as stagiaires_non_corriges 
		
		left outer join
		(
		select ci2.id,nom,prenom,date_correction 
		from contraintes.af_get_classe_individus($3,0,'asc',false) ci2,
		contraintes.resultat r,contraintes.resultat_exotlc re 
		where r.formation=$1 and r.etape=$2 and r.id=re.id and ci2.id=r.stagiaire
		) as stagiaires_corriges 
		using (id)
		
	    --)
	--)
	
		
    loop
	return next rec;
    end loop;
end;$_$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_get_formation_stagiaires_correction(integer, integer, integer) OWNER TO pgsql;

--
-- TOC entry 7684 (class 0 OID 0)
-- Dependencies: 1076
-- Name: FUNCTION af_get_formation_stagiaires_correction(integer, integer, integer); Type: COMMENT; Schema: contraintes; Owner: pgsql
--

COMMENT ON FUNCTION af_get_formation_stagiaires_correction(integer, integer, integer) IS 'retourne les stagiaires de la formation et leur etat de correction';


--
-- TOC entry 1077 (class 1255 OID 2595876)
-- Dependencies: 2983 5
-- Name: af_get_formations(); Type: FUNCTION; Schema: contraintes; Owner: pgsql
--

CREATE FUNCTION af_get_formations() RETURNS SETOF record
    AS $$declare
rec record;
begin
    for rec in 
	select id,libelle,parcours,date_debut,date_fin,langue,ressources_fusionnees from contraintes.formation
    loop
    return next rec;
    end loop;
    return;
end;$$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_get_formations() OWNER TO pgsql;

--
-- TOC entry 7686 (class 0 OID 0)
-- Dependencies: 1077
-- Name: FUNCTION af_get_formations(); Type: COMMENT; Schema: contraintes; Owner: pgsql
--

COMMENT ON FUNCTION af_get_formations() IS 'retourne toutes les formations de la plateforme';


--
-- TOC entry 1078 (class 1255 OID 2595877)
-- Dependencies: 2983 5
-- Name: af_get_formations(character varying, character varying, integer); Type: FUNCTION; Schema: contraintes; Owner: pgsql
--

CREATE FUNCTION af_get_formations(character varying, character varying, integer) RETURNS SETOF record
    AS $_$-- $1 ordre de classement ('asc' ou 'desc')
-- $2 'libelle' ou 'date_debut' (order by)
-- $3 période (1 : passées, 2 : présentes, 3 : futures, 0 toutes)
declare
rec record;
req varchar;
condition_periode varchar;
begin
    -- traitement periode
    if $3=1 then
	condition_periode:='  date_fin<current_date ';
    else
	if $3=2 then
	    condition_periode:='  not(date_debut>current_date or date_fin<current_date) ';
	else
	    if $3=3 then
		condition_periode:='  date_debut>current_date ';
	    end if;
	end if;
    end if;
    req:='select id,libelle,parcours,date_debut,date_fin,langue,ressources_fusionnees from contraintes.af_get_formations() as (id int4,libelle varchar,parcours int4,date_debut date,date_fin date,langue int4,ressources_fusionnees bool)';
    if $3 !=0 then
	req:=req || 'where '||condition_periode;
    end if;
    req:=req || 'order by '||$2||' '||$1;
    raise notice 'req=%',req;
    for rec in 
	execute req
    loop
	return next rec;
    end loop;
    return;
end;$_$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_get_formations(character varying, character varying, integer) OWNER TO pgsql;

--
-- TOC entry 7688 (class 0 OID 0)
-- Dependencies: 1078
-- Name: FUNCTION af_get_formations(character varying, character varying, integer); Type: COMMENT; Schema: contraintes; Owner: pgsql
--

COMMENT ON FUNCTION af_get_formations(character varying, character varying, integer) IS 'retourne les formations (avec critères de classement)';


--
-- TOC entry 1079 (class 1255 OID 2595878)
-- Dependencies: 2983 5
-- Name: af_get_formations_classes(); Type: FUNCTION; Schema: contraintes; Owner: pgsql
--

CREATE FUNCTION af_get_formations_classes() RETURNS SETOF record
    AS $$declare
rec record;
begin
	FOR rec IN 
	    select id,libelle,pere,min,max, ft.formation 
	    from contraintes.af_get_classes() as(id int4,libelle varchar, pere int4,min int4,max int4) ,
	    contraintes.formation_participants ft 
	    where  ft.classe=id
	    ORDER BY formation
	LOOP
		RETURN NEXT rec;
	END LOOP;
	
	RETURN;
end$$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_get_formations_classes() OWNER TO pgsql;

--
-- TOC entry 7690 (class 0 OID 0)
-- Dependencies: 1079
-- Name: FUNCTION af_get_formations_classes(); Type: COMMENT; Schema: contraintes; Owner: pgsql
--

COMMENT ON FUNCTION af_get_formations_classes() IS 'retourne les classes des formations';


--
-- TOC entry 1080 (class 1255 OID 2595879)
-- Dependencies: 2983 5
-- Name: af_get_formations_dates(date, date, boolean, boolean, boolean); Type: FUNCTION; Schema: contraintes; Owner: pgsql
--

CREATE FUNCTION af_get_formations_dates(date, date, boolean, boolean, boolean) RETURNS SETOF record
    AS $_$-- $1 : date debut
-- $2 : date fin
-- $3 : -> les formations commençant et finissant dans l'intervalle [debut - fin]
-- $4 : -> les formations commençant dans l'intervalle [debut - fin]
-- $5 : -> les formations finissant dans l'intervalle [debut - fin]
declare
rec record;
req varchar;

begin
    req:='select * from contraintes.af_get_formations() as (id int4, libelle varchar, parcours int4, date_debut date, date_fin date, langue_defaut int4,ressources_fusionnees bool )';
    if $3 or $4 or $5 then
	req:=req ||' where ';
	if $3 then
	    req:=req || ' (date_debut >='''||$1||''' and date_fin <='''||$2||''')'; 
	end if;
	if $4 then
	    if $3 then
		req:=req ||' or (date_debut>='''||$1||''' and date_debut<='''||$2||''')';
	    else
		req:=req ||' (date_debut>='''||$1||''' and date_debut<='''||$2||''')';
	    end if;
	end if;
	if $5 then
	    if $3 or $4 then
		req:=req ||' or (date_fin>='''||$1||''' and date_fin<='''||$2||''')';
	    else
		req:=req ||'  (date_fin>='''||$1||''' and date_fin<='''||$2||''')';
	    end if;
	end if;
    end if;
    
    raise notice 'req=%',req;
    for rec in 
	execute req
    loop
	return next rec;
    end loop;
end;$_$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_get_formations_dates(date, date, boolean, boolean, boolean) OWNER TO pgsql;

--
-- TOC entry 7692 (class 0 OID 0)
-- Dependencies: 1080
-- Name: FUNCTION af_get_formations_dates(date, date, boolean, boolean, boolean); Type: COMMENT; Schema: contraintes; Owner: pgsql
--

COMMENT ON FUNCTION af_get_formations_dates(date, date, boolean, boolean, boolean) IS 'retourne les formations en fonction des dates de debut et fin';


--
-- TOC entry 1847 (class 1255 OID 2595880)
-- Dependencies: 2983 5
-- Name: af_get_formations_dates_bornes(); Type: FUNCTION; Schema: contraintes; Owner: pgsql
--

CREATE FUNCTION af_get_formations_dates_bornes() RETURNS record
    AS $$DECLARE
rec RECORD;

BEGIN
	SELECT INTO rec MIN(F1.date_debut) AS premier, MAX(F2.date_fin) AS dernier
	FROM contraintes.formation F1, contraintes.formation F2;

	RETURN rec;
 
END;$$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_get_formations_dates_bornes() OWNER TO pgsql;

--
-- TOC entry 1848 (class 1255 OID 2595881)
-- Dependencies: 2983 5
-- Name: af_get_formations_exotlcs_corriges(); Type: FUNCTION; Schema: contraintes; Owner: pgsql
--

CREATE FUNCTION af_get_formations_exotlcs_corriges() RETURNS SETOF record
    AS $$declare
rec record;
begin
    for rec in
	select id,libelle from contraintes.af_get_formations() 
	as (id int4,libelle varchar,parcours int4,date_debut date,date_fin date,langue int4),
	contraintes.formation_participants fp,
	contraintes.af_get_classes_exotlcs_corriges() as (c_id int4,c_libelle varchar) 
	where id=fp.formation and fp.classe=c_id
    loop
	return next rec;
    end loop;
end;$$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_get_formations_exotlcs_corriges() OWNER TO pgsql;

--
-- TOC entry 7695 (class 0 OID 0)
-- Dependencies: 1848
-- Name: FUNCTION af_get_formations_exotlcs_corriges(); Type: COMMENT; Schema: contraintes; Owner: pgsql
--

COMMENT ON FUNCTION af_get_formations_exotlcs_corriges() IS 'retourne les formations qui ont des exotlcs corriges';


--
-- TOC entry 1081 (class 1255 OID 2595882)
-- Dependencies: 2983 5
-- Name: af_get_formations_fichier_rendu(); Type: FUNCTION; Schema: contraintes; Owner: pgsql
--

CREATE FUNCTION af_get_formations_fichier_rendu() RETURNS SETOF record
    AS $$declare
rec record;
begin
    for rec in 
	select distinct f_id,libelle from contraintes.af_get_formations() 
	as (f_id int4,libelle varchar,parcours int4,date_debut date,date_fin date,langue int4),
	contraintes.resultat r,contraintes.resultat_exotlc re 
	where f_id=r.formation and re.id=r.id and fichier_rendu is not null
    loop
	return next rec;
    end loop;
end;$$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_get_formations_fichier_rendu() OWNER TO pgsql;

--
-- TOC entry 7697 (class 0 OID 0)
-- Dependencies: 1081
-- Name: FUNCTION af_get_formations_fichier_rendu(); Type: COMMENT; Schema: contraintes; Owner: pgsql
--

COMMENT ON FUNCTION af_get_formations_fichier_rendu() IS 'retourne les formations qui ont des fichier rendu';


--
-- TOC entry 1082 (class 1255 OID 2595883)
-- Dependencies: 2983 5
-- Name: af_get_formations_forums(integer); Type: FUNCTION; Schema: contraintes; Owner: pgsql
--

CREATE FUNCTION af_get_formations_forums(integer) RETURNS SETOF record
    AS $_$-- $1 : individu
declare
rec record;
begin
    if contraintes.fw_is_root($1) then
    for rec in 
	select fi.id,fi.libelle,fu.id,fu.libelle 
	from contraintes.formation fi,contraintes.forum fu,contraintes.formation_forums 
	where fi.id=formation and fu.id=forum
    loop
	return next rec;
    end loop;
    else
    for rec in 
	select fi.id,fi.libelle,fu.id,fu.libelle 
	from contraintes.formation fi,contraintes.forum fu,contraintes.formation_forums ff,contraintes.formation_participants fp 
	where fi.id=ff.formation and fu.id=forum and fi.id=fp.formation and fp.formateur=$1
    loop
	return next rec;
    end loop;
    end if;
end;$_$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_get_formations_forums(integer) OWNER TO pgsql;

--
-- TOC entry 7699 (class 0 OID 0)
-- Dependencies: 1082
-- Name: FUNCTION af_get_formations_forums(integer); Type: COMMENT; Schema: contraintes; Owner: pgsql
--

COMMENT ON FUNCTION af_get_formations_forums(integer) IS 'retourne les associations formations/forums de la plateforme pour le root ou formateur';


--
-- TOC entry 1083 (class 1255 OID 2595884)
-- Dependencies: 2983 5
-- Name: af_get_formations_presentielles(); Type: FUNCTION; Schema: contraintes; Owner: pgsql
--

CREATE FUNCTION af_get_formations_presentielles() RETURNS SETOF record
    AS $$declare
rec record;
begin
    for rec in
	select distinct id, f.libelle, parcours, date_debut, date_fin, langue 
	from contraintes.formation f,contraintes.evenement 
	where id=formation and modalite=3
    loop
	return next rec;
    end loop;
end;$$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_get_formations_presentielles() OWNER TO pgsql;

--
-- TOC entry 7701 (class 0 OID 0)
-- Dependencies: 1083
-- Name: FUNCTION af_get_formations_presentielles(); Type: COMMENT; Schema: contraintes; Owner: pgsql
--

COMMENT ON FUNCTION af_get_formations_presentielles() IS 'retourne les formations ayants du presentiel';


--
-- TOC entry 1084 (class 1255 OID 2595885)
-- Dependencies: 2983 5
-- Name: af_get_forum(integer); Type: FUNCTION; Schema: contraintes; Owner: pgsql
--

CREATE FUNCTION af_get_forum(integer) RETURNS record
    AS $_$declare
rec record;

begin
    select into rec * from contraintes.forum where id=$1;
    return rec;
end;$_$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_get_forum(integer) OWNER TO pgsql;

--
-- TOC entry 7703 (class 0 OID 0)
-- Dependencies: 1084
-- Name: FUNCTION af_get_forum(integer); Type: COMMENT; Schema: contraintes; Owner: pgsql
--

COMMENT ON FUNCTION af_get_forum(integer) IS 'retourne les donnees d''un forum';


--
-- TOC entry 21 (class 1255 OID 2595886)
-- Dependencies: 2983 5
-- Name: af_get_forum_environnement(integer); Type: FUNCTION; Schema: contraintes; Owner: pgsql
--

CREATE FUNCTION af_get_forum_environnement(integer) RETURNS record
    AS $_$-- $1 : forum
declare
rec record;
begin
    select into rec * from contraintes.af_get_forum_environnements() 
    as (id int4,libelle varchar,chemin varchar,db_type varchar,db_serveur varchar,db_name varchar,db_user varchar,db_pwd varchar,
		admin varchar,admin_pwd varchar,email_valide bool,email_verification bool,interpretation_html bool,citation bool,noms_longs bool,
		taille_pj int4,lignes int4,block_ip bool,compte_vus bool,fils_fermes bool,affiche_fils bool,encodage varchar)
    where id =$1;
    return rec;
end;$_$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_get_forum_environnement(integer) OWNER TO pgsql;

--
-- TOC entry 1085 (class 1255 OID 2595887)
-- Dependencies: 2983 5
-- Name: af_get_forum_environnements(); Type: FUNCTION; Schema: contraintes; Owner: pgsql
--

CREATE FUNCTION af_get_forum_environnements() RETURNS SETOF record
    AS $$declare
rec record;
begin
    for rec in
	select * from contraintes.forum_environnement
    loop
	return next rec;
    end loop;
end;$$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_get_forum_environnements() OWNER TO pgsql;

--
-- TOC entry 7706 (class 0 OID 0)
-- Dependencies: 1085
-- Name: FUNCTION af_get_forum_environnements(); Type: COMMENT; Schema: contraintes; Owner: pgsql
--

COMMENT ON FUNCTION af_get_forum_environnements() IS 'retourne les configurations pour les forums';


--
-- TOC entry 1086 (class 1255 OID 2595888)
-- Dependencies: 2983 5
-- Name: af_get_forum_forum_environnement(integer); Type: FUNCTION; Schema: contraintes; Owner: pgsql
--

CREATE FUNCTION af_get_forum_forum_environnement(integer) RETURNS record
    AS $_$-- $1 : forum
declare
rec record;
begin
    select into rec * from contraintes.af_get_forum_environnements() 
    as (id int4,libelle varchar,chemin varchar,db_type varchar,db_serveur varchar,db_name varchar,db_user varchar,db_pwd varchar,
		admin varchar,admin_pwd varchar,email_valide bool,email_verification bool,interpretation_html bool,citation bool,noms_longs bool,
		taille_pj int4,lignes int4,block_ip bool,compte_vus bool,fils_fermes bool,affiche_fils bool,encodage varchar)
    where id in (select environnement from contraintes.forum_environnements where forum=$1);
    return rec;
end;$_$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_get_forum_forum_environnement(integer) OWNER TO pgsql;

--
-- TOC entry 7708 (class 0 OID 0)
-- Dependencies: 1086
-- Name: FUNCTION af_get_forum_forum_environnement(integer); Type: COMMENT; Schema: contraintes; Owner: pgsql
--

COMMENT ON FUNCTION af_get_forum_forum_environnement(integer) IS 'retourne les données d''un environnement de forum';


--
-- TOC entry 1087 (class 1255 OID 2595889)
-- Dependencies: 2983 5
-- Name: af_get_forums(); Type: FUNCTION; Schema: contraintes; Owner: pgsql
--

CREATE FUNCTION af_get_forums() RETURNS SETOF record
    AS $$declare
rec record;
begin
    for rec in 
	select * from contraintes.forum
    loop
	return next rec;
    end loop;
	
end;$$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_get_forums() OWNER TO pgsql;

--
-- TOC entry 7710 (class 0 OID 0)
-- Dependencies: 1087
-- Name: FUNCTION af_get_forums(); Type: COMMENT; Schema: contraintes; Owner: pgsql
--

COMMENT ON FUNCTION af_get_forums() IS 'retourne les forrum de la plateforme';


--
-- TOC entry 1088 (class 1255 OID 2595890)
-- Dependencies: 2983 5
-- Name: af_get_ftb(integer); Type: FUNCTION; Schema: contraintes; Owner: pgsql
--

CREATE FUNCTION af_get_ftb(integer) RETURNS record
    AS $_$declare
rec record;

begin
    select into rec E.id,E.libelle,text,voir_mots,interpretation_html, date_creation
    from contraintes.ftb F, contraintes.evaluation E
    where E.id=$1
    and F.id=E.id;
    return rec;
end;$_$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_get_ftb(integer) OWNER TO pgsql;

--
-- TOC entry 7712 (class 0 OID 0)
-- Dependencies: 1088
-- Name: FUNCTION af_get_ftb(integer); Type: COMMENT; Schema: contraintes; Owner: pgsql
--

COMMENT ON FUNCTION af_get_ftb(integer) IS 'retourne les infos d''un ftb(remplir les blancs)';


--
-- TOC entry 1849 (class 1255 OID 2595891)
-- Dependencies: 2983 5
-- Name: af_get_ftb_liste_mot(integer, integer); Type: FUNCTION; Schema: contraintes; Owner: pgsql
--

CREATE FUNCTION af_get_ftb_liste_mot(integer, integer) RETURNS text[]
    AS $_$-- $1 : le ftb
-- $2 : la langue
declare
rec text[];
rec_ftb record;
mot_courant text;
texte text;
texte_ams text;
lettre char;
lettre_suivante char;
longueur_texte integer;
i integer;
j integer;
k integer;
begin
    -- recupere le texte du blanc
    select into rec_ftb * from contraintes.af_get_ftb($1) as (id int4, libelle varchar,text text,voir_mots bool,interpretation_html bool, date_creation timestamp);
    texte_ams:=rec_ftb.text;
    raise notice '$2=%',$2;
    if $2 is not null then
        texte:=substring(texte_ams from '##AMS'||$2||'##{"(.*?)"}');
    end if;
    if texte is null then
	texte:=texte_ams;
    end if;	
    raise notice 't=%',texte;
    longueur_texte:=char_length(texte);
	
    -- boucle sur le texte
    i:=1;
    k:=1;
    mot_courant:='';
    while i < longueur_texte
    loop
	if (substring(texte from i for 1))='[' then
	    i:=i+1;
	    if (substring(texte from i for 1))=':' then
		-- debut d'un mot
		
		i:=i+1;
		lettre:=substring(texte from i for 1);
		--raise notice 'lettre=%',lettre;
		mot_courant:=mot_courant || lettre;
		-- boucle jusqu'à ':]'
		i:=i+1;
		lettre:=substring(texte from i for 1);
		j:=i+1;
		lettre_suivante:=substring(texte from j for 1);
		while (lettre!=':' and lettre_suivante!=']')
		loop
		    mot_courant:=mot_courant || lettre;
		    i:=i+1;
		lettre:=substring(texte from i for 1);
		j:=i+1;
		lettre_suivante:=substring(texte from j for 1);
		end loop;
		-- stocke le mot
		rec[k]:=mot_courant;
		--raise notice 'mot_courant=%',mot_courant;
		--rec[k]:='toto';
		k:=k+1;
		mot_courant:='';
	    else
		i:=i+1;
	    end if;
	else
	    i:=i+1;
	end if;
	
    end loop;
	
    return rec;
end;$_$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_get_ftb_liste_mot(integer, integer) OWNER TO pgsql;

--
-- TOC entry 7714 (class 0 OID 0)
-- Dependencies: 1849
-- Name: FUNCTION af_get_ftb_liste_mot(integer, integer); Type: COMMENT; Schema: contraintes; Owner: pgsql
--

COMMENT ON FUNCTION af_get_ftb_liste_mot(integer, integer) IS 'retourne la liste des mots d''un ftb';


--
-- TOC entry 22 (class 1255 OID 2595892)
-- Dependencies: 2983 5
-- Name: af_get_glossaire(integer); Type: FUNCTION; Schema: contraintes; Owner: postgres
--

CREATE FUNCTION af_get_glossaire(integer) RETURNS record
    AS $_$-- $1 : glossaire
declare
rec record;
begin
    select into rec id,libelle from contraintes.glossaire where id=$1;
    return rec;
end;$_$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_get_glossaire(integer) OWNER TO postgres;

--
-- TOC entry 7716 (class 0 OID 0)
-- Dependencies: 22
-- Name: FUNCTION af_get_glossaire(integer); Type: COMMENT; Schema: contraintes; Owner: postgres
--

COMMENT ON FUNCTION af_get_glossaire(integer) IS 'retourne info d''un glossaire';


--
-- TOC entry 1089 (class 1255 OID 2595893)
-- Dependencies: 2983 5
-- Name: af_get_glossaire_fichier(integer); Type: FUNCTION; Schema: contraintes; Owner: pgsql
--

CREATE FUNCTION af_get_glossaire_fichier(integer) RETURNS integer
    AS $_$DECLARE
--$1 le numero du fichier
glossaire_id int4;
BEGIN

	SELECT INTO glossaire_id id FROM contraintes.glossaire
	WHERE fichier=$1;

	RETURN glossaire_id;

END$_$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_get_glossaire_fichier(integer) OWNER TO pgsql;

--
-- TOC entry 7718 (class 0 OID 0)
-- Dependencies: 1089
-- Name: FUNCTION af_get_glossaire_fichier(integer); Type: COMMENT; Schema: contraintes; Owner: pgsql
--

COMMENT ON FUNCTION af_get_glossaire_fichier(integer) IS 'Obtenir un glossaire à partir de son numero de fichier.
';


--
-- TOC entry 23 (class 1255 OID 2595894)
-- Dependencies: 2983 5
-- Name: af_get_glossaire_fichiers(integer); Type: FUNCTION; Schema: contraintes; Owner: pgsql
--

CREATE FUNCTION af_get_glossaire_fichiers(integer) RETURNS SETOF record
    AS $_$-- $1 : glossaire
declare
rec record;
begin
    for rec in 
	select f.id,f.libelle,f.type,f.connecte from contraintes.fichier f where id in
	(select fichier from contraintes.glossaire_fichiers where id=$1)
    loop
	return next rec;
    end loop;

end;$_$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_get_glossaire_fichiers(integer) OWNER TO pgsql;

--
-- TOC entry 7720 (class 0 OID 0)
-- Dependencies: 23
-- Name: FUNCTION af_get_glossaire_fichiers(integer); Type: COMMENT; Schema: contraintes; Owner: pgsql
--

COMMENT ON FUNCTION af_get_glossaire_fichiers(integer) IS 'retourne les fichier mots cles d''un glossaire';


--
-- TOC entry 1850 (class 1255 OID 2595895)
-- Dependencies: 2983 5
-- Name: af_get_grille(integer); Type: FUNCTION; Schema: contraintes; Owner: pgsql
--

CREATE FUNCTION af_get_grille(integer) RETURNS record
    AS $_$-- $1 : numero grille
declare
rec record;
begin
    select into rec id,libelle from contraintes.grille where id=$1;
    return rec;
end;$_$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_get_grille(integer) OWNER TO pgsql;

--
-- TOC entry 7722 (class 0 OID 0)
-- Dependencies: 1850
-- Name: FUNCTION af_get_grille(integer); Type: COMMENT; Schema: contraintes; Owner: pgsql
--

COMMENT ON FUNCTION af_get_grille(integer) IS 'retourne les infos d''une grille';


--
-- TOC entry 1090 (class 1255 OID 2595896)
-- Dependencies: 2983 5
-- Name: af_get_grille_capacite_titre_themes(integer); Type: FUNCTION; Schema: contraintes; Owner: pgsql
--

CREATE FUNCTION af_get_grille_capacite_titre_themes(integer) RETURNS SETOF record
    AS $_$declare 
rec record;
begin
    if contraintes.fw_is_root($1) then
    for rec in 
	select distinct t.id,t.libelle from
	(contraintes.theme t
	left outer join
	--(contraintes.af_get_categorie_themes(11) as (ct_id int4,ct_libelle varchar)
	contraintes.categorie_grille cg
	on t.id=cg.theme
	left outer join 
	contraintes.grille_capacites_titres gtc
	on gtc.grille=cg.id)
	where cg.theme is not null and gtc.grille is not null 
	
	
	
     loop
	return next rec;
     end loop;
    else
    for rec in 
	select distinct t.id,t.libelle from
	(contraintes.theme t
	left outer join
	--(contraintes.af_get_categorie_themes(11) as (ct_id int4,ct_libelle varchar)
	contraintes.categorie_grille cg
	on (t.id=cg.theme  and ( t.individu=$1 OR t.individu IS NULL) ) 
	left outer join 
	contraintes.grille_capacites_titres gtc
	on gtc.grille=cg.id)
	where cg.theme is not null and gtc.grille is not null 
	
	
	
     loop
	return next rec;
     end loop;
    end if;
     return;
end;$_$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_get_grille_capacite_titre_themes(integer) OWNER TO pgsql;

--
-- TOC entry 7724 (class 0 OID 0)
-- Dependencies: 1090
-- Name: FUNCTION af_get_grille_capacite_titre_themes(integer); Type: COMMENT; Schema: contraintes; Owner: pgsql
--

COMMENT ON FUNCTION af_get_grille_capacite_titre_themes(integer) IS 'retourne les themes des couples grille / capacite_titre pour un individu';


--
-- TOC entry 1091 (class 1255 OID 2595897)
-- Dependencies: 2983 5
-- Name: af_get_grille_capacites_titres(integer); Type: FUNCTION; Schema: contraintes; Owner: pgsql
--

CREATE FUNCTION af_get_grille_capacites_titres(integer) RETURNS SETOF record
    AS $_$-- $1 : numero grille
declare
rec record;
begin
    for rec in 
	select ct.id,ct.libelle,gct.grille from contraintes.capacite_titre ct,contraintes.grille_capacites_titres gct 
	where gct.grille=$1 and ct.id=gct.capacite_titre
    loop
	return next rec;
    end loop;
    return;
end;$_$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_get_grille_capacites_titres(integer) OWNER TO pgsql;

--
-- TOC entry 7726 (class 0 OID 0)
-- Dependencies: 1091
-- Name: FUNCTION af_get_grille_capacites_titres(integer); Type: COMMENT; Schema: contraintes; Owner: pgsql
--

COMMENT ON FUNCTION af_get_grille_capacites_titres(integer) IS 'retourne les titres de capacite pour une grille';


--
-- TOC entry 1092 (class 1255 OID 2595898)
-- Dependencies: 2983 5
-- Name: af_get_grille_capacites_titres_disponibles(integer, integer); Type: FUNCTION; Schema: contraintes; Owner: pgsql
--

CREATE FUNCTION af_get_grille_capacites_titres_disponibles(integer, integer) RETURNS SETOF record
    AS $_$-- $1 : numero grille
-- $2 : numero theme
declare 
rec record;
begin
    for rec in 
	select distinct ct.id,ct.libelle,$1 as grille from 
	
	(contraintes.capacite_titre ct
	left outer join
	contraintes.capacite_titre_capacites ctc
	on ct.id=ctc.capacite_titre) ,
	
	
	
	(contraintes.capacite_titre c
	left outer join
	contraintes.grille_capacites_titres gct
	on c.id=gct.capacite_titre and gct.grille=$1) ,
	contraintes.af_get_categorie_elements_theme(11,$2) et
	where gct.capacite_titre is null and ctc.capacite_titre is not null and ct.id=et
	and ct.id=c.id

    loop
	return next rec;
    end loop;
    return;
end;$_$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_get_grille_capacites_titres_disponibles(integer, integer) OWNER TO pgsql;

--
-- TOC entry 7728 (class 0 OID 0)
-- Dependencies: 1092
-- Name: FUNCTION af_get_grille_capacites_titres_disponibles(integer, integer); Type: COMMENT; Schema: contraintes; Owner: pgsql
--

COMMENT ON FUNCTION af_get_grille_capacites_titres_disponibles(integer, integer) IS 'retourne tous les capacites_titres disponibles pour une grille et un theme
(les titres d''un meme themes non associés à la grille)';


--
-- TOC entry 1093 (class 1255 OID 2595899)
-- Dependencies: 2983 5
-- Name: af_get_grille_stagiaires_formation(integer, integer); Type: FUNCTION; Schema: contraintes; Owner: pgsql
--

CREATE FUNCTION af_get_grille_stagiaires_formation(integer, integer) RETURNS SETOF record
    AS $_$-- $1 : grille
-- $2 : formation
declare
rec record;
begin
    for rec in 
	select distinct id,nom,prenom from 
	contraintes.fw_individu,
	contraintes.stagiaire_grille sg 
	where id=sg.stagiaire and sg.formation=$2 and sg.grille=$1
    loop
	return next rec;
    end loop;
end;$_$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_get_grille_stagiaires_formation(integer, integer) OWNER TO pgsql;

--
-- TOC entry 7730 (class 0 OID 0)
-- Dependencies: 1093
-- Name: FUNCTION af_get_grille_stagiaires_formation(integer, integer); Type: COMMENT; Schema: contraintes; Owner: pgsql
--

COMMENT ON FUNCTION af_get_grille_stagiaires_formation(integer, integer) IS 'retourne les stagiaires de la table stagiaire_grille pour une grille et une formation';


--
-- TOC entry 1094 (class 1255 OID 2595900)
-- Dependencies: 2983 5
-- Name: af_get_icones(); Type: FUNCTION; Schema: contraintes; Owner: pgsql
--

CREATE FUNCTION af_get_icones() RETURNS SETOF record
    AS $$declare
rec record;
begin
    for rec in 
	select f.id,f.libelle from contraintes.fichier f,contraintes.fichier_icone fi
	where f.id=fi.id
    loop
	return next rec;
    end loop;
end;$$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_get_icones() OWNER TO pgsql;

--
-- TOC entry 7732 (class 0 OID 0)
-- Dependencies: 1094
-- Name: FUNCTION af_get_icones(); Type: COMMENT; Schema: contraintes; Owner: pgsql
--

COMMENT ON FUNCTION af_get_icones() IS 'retourne les icones de la plateforme';


--
-- TOC entry 1095 (class 1255 OID 2595901)
-- Dependencies: 2983 5
-- Name: af_get_individu(integer); Type: FUNCTION; Schema: contraintes; Owner: pgsql
--

CREATE FUNCTION af_get_individu(integer) RETURNS record
    AS $_$declare
rec record;

begin
    select into rec id, identifiant_md5 ,login ,password ,nom ,prenom ,adresse ,code ,ville ,
		email ,tel_fixe ,tel_port ,langue,organisme ,photo  from contraintes.fw_individu where id=$1;
    return rec;
    
end;$_$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_get_individu(integer) OWNER TO pgsql;

--
-- TOC entry 7734 (class 0 OID 0)
-- Dependencies: 1095
-- Name: FUNCTION af_get_individu(integer); Type: COMMENT; Schema: contraintes; Owner: pgsql
--

COMMENT ON FUNCTION af_get_individu(integer) IS 'retourne les in infos d''un individu';


--
-- TOC entry 1096 (class 1255 OID 2595902)
-- Dependencies: 2983 5
-- Name: af_get_individu(character varying, character varying); Type: FUNCTION; Schema: contraintes; Owner: pgsql
--

CREATE FUNCTION af_get_individu(character varying, character varying) RETURNS record
    AS $_$DECLARE
rec RECORD;
BEGIN
	SELECT INTO rec id , identifiant_md5 ,login , password, nom , prenom , adresse , code , ville ,email , tel_fixe , tel_port , langue , organisme, photo FROM contraintes.fw_individu
	WHERE login LIKE $1
	AND password LIKE $2;
	
	RETURN rec;
END;$_$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_get_individu(character varying, character varying) OWNER TO pgsql;

--
-- TOC entry 1097 (class 1255 OID 2595903)
-- Dependencies: 2983 5
-- Name: af_get_individu_classes(integer); Type: FUNCTION; Schema: contraintes; Owner: pgsql
--

CREATE FUNCTION af_get_individu_classes(integer) RETURNS SETOF record
    AS $_$-- $1 : numero individu
declare
rec record;
begin
    for rec in 
	select id,libelle,pere,min,max from contraintes.af_get_classes() as (id int4,libelle varchar,pere int4,min int4,max int4),
	contraintes.classe_individus CI 
	where id=CI.classe and CI.individu=$1 
	ORDER BY libelle
    loop
	return next rec;
    end loop;
    return;
end;$_$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_get_individu_classes(integer) OWNER TO pgsql;

--
-- TOC entry 7737 (class 0 OID 0)
-- Dependencies: 1097
-- Name: FUNCTION af_get_individu_classes(integer); Type: COMMENT; Schema: contraintes; Owner: pgsql
--

COMMENT ON FUNCTION af_get_individu_classes(integer) IS 'retourne les classes d''un individu';


--
-- TOC entry 1098 (class 1255 OID 2595904)
-- Dependencies: 2983 5
-- Name: af_get_individu_date_connexion_max(integer); Type: FUNCTION; Schema: contraintes; Owner: pgsql
--

CREATE FUNCTION af_get_individu_date_connexion_max(integer) RETURNS record
    AS $_$-- $1 : individu
declare
rec record;
begin
    select into rec max(connexion) from contraintes.connexion where individu=$1;
    return rec;    
end;$_$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_get_individu_date_connexion_max(integer) OWNER TO pgsql;

--
-- TOC entry 7739 (class 0 OID 0)
-- Dependencies: 1098
-- Name: FUNCTION af_get_individu_date_connexion_max(integer); Type: COMMENT; Schema: contraintes; Owner: pgsql
--

COMMENT ON FUNCTION af_get_individu_date_connexion_max(integer) IS 'retourne la date de connexion max pour un individu';


--
-- TOC entry 1099 (class 1255 OID 2595905)
-- Dependencies: 2983 5
-- Name: af_get_individu_date_deconnexion_max(integer); Type: FUNCTION; Schema: contraintes; Owner: pgsql
--

CREATE FUNCTION af_get_individu_date_deconnexion_max(integer) RETURNS record
    AS $_$-- $1 : individu
declare
rec record;
begin
    select into rec max(deconnexion) from contraintes.connexion where individu=$1;
    return rec;
end;$_$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_get_individu_date_deconnexion_max(integer) OWNER TO pgsql;

--
-- TOC entry 7741 (class 0 OID 0)
-- Dependencies: 1099
-- Name: FUNCTION af_get_individu_date_deconnexion_max(integer); Type: COMMENT; Schema: contraintes; Owner: pgsql
--

COMMENT ON FUNCTION af_get_individu_date_deconnexion_max(integer) IS 'retourne la date de deconnexion max pour un individu';


--
-- TOC entry 1100 (class 1255 OID 2595906)
-- Dependencies: 2983 5
-- Name: af_get_individu_droits_classe(integer, integer); Type: FUNCTION; Schema: contraintes; Owner: pgsql
--

CREATE FUNCTION af_get_individu_droits_classe(integer, integer) RETURNS SETOF record
    AS $_$-- $1 : numero individu
-- $2 : numero classe
declare 
rec record;
begin
    for rec in 
	select id,libelle,type,defaut from contraintes.af_get_droits(2) as (id int4,libelle varchar,type int4,defaut bool),contraintes.individu_droits ID 
	where id=ID.droit and ID.individu=$1 and ID.classe=$2
    loop
	return next rec;
    end loop;
    return;
end;$_$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_get_individu_droits_classe(integer, integer) OWNER TO pgsql;

--
-- TOC entry 7743 (class 0 OID 0)
-- Dependencies: 1100
-- Name: FUNCTION af_get_individu_droits_classe(integer, integer); Type: COMMENT; Schema: contraintes; Owner: pgsql
--

COMMENT ON FUNCTION af_get_individu_droits_classe(integer, integer) IS 'retourne les droitts d''un individu pour une classe';


--
-- TOC entry 1101 (class 1255 OID 2595907)
-- Dependencies: 2983 5
-- Name: af_get_individu_filieres(integer); Type: FUNCTION; Schema: contraintes; Owner: pgsql
--

CREATE FUNCTION af_get_individu_filieres(integer) RETURNS SETOF record
    AS $_$-- $1 : individu
declare
rec record;
begin
    for rec in
	--voir avec remi pour l'optimisation
	/*
	select fil.id,fil.libelle from 
	contraintes.filiere fil,
	contraintes.parcours par,
	contraintes.formation for,
	contraintes.formation_participants fp,
	contraintes.classe_individus ci 
	where ...
	*/
	select fil.id,fil.libelle from contraintes.filiere fil where fil.id in 
	(select par.filiere from contraintes.parcours par where par.id in 
	(select form.parcours from contraintes.formation form where form.id in 
	(select fp.formation from contraintes.formation_participants fp where fp.classe in 
	(select ci.classe from contraintes.classe_individus ci where ci.individu=$1))))
	
    loop
	return next rec;
    end loop;
	
end;$_$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_get_individu_filieres(integer) OWNER TO pgsql;

--
-- TOC entry 7745 (class 0 OID 0)
-- Dependencies: 1101
-- Name: FUNCTION af_get_individu_filieres(integer); Type: COMMENT; Schema: contraintes; Owner: pgsql
--

COMMENT ON FUNCTION af_get_individu_filieres(integer) IS 'retourne les filieres de formation d''un individu';


--
-- TOC entry 1102 (class 1255 OID 2595908)
-- Dependencies: 2983 5
-- Name: af_get_individu_formations(integer, integer, character varying, character varying, integer); Type: FUNCTION; Schema: contraintes; Owner: pgsql
--

CREATE FUNCTION af_get_individu_formations(integer, integer, character varying, character varying, integer) RETURNS SETOF record
    AS $_$-- $1 : numero user
-- $2 filiere
-- $3 ordre pour classement ('asc' ou 'desc')
-- $4 'date_debut' ou 'libelle' (orderby)
-- $5 periode (1 : passées, 2 : présentes, 3 : futures, 0 : toutes)
declare
rec record;
begin
    for rec in 
	select f_id,libelle,f_parcours,date_debut,date_fin,langue,ci.individu,$2
	from contraintes.af_get_formations($3,$4,$5) 
	as (f_id int4,libelle varchar,f_parcours int4,date_debut date,date_fin date,langue int4,ressources_fusionnees boolean),
	contraintes.formation_participants fp,
	contraintes.classe_individus ci,
	contraintes.parcours p
	where fp.classe=ci.classe 
	and fp.formation=f_id 
	and ci.individu=$1 
	AND f_parcours=p.id
	AND p.filiere=$2
    loop
	return next rec;
    end loop;
    return;   
end;$_$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_get_individu_formations(integer, integer, character varying, character varying, integer) OWNER TO pgsql;

--
-- TOC entry 7747 (class 0 OID 0)
-- Dependencies: 1102
-- Name: FUNCTION af_get_individu_formations(integer, integer, character varying, character varying, integer); Type: COMMENT; Schema: contraintes; Owner: pgsql
--

COMMENT ON FUNCTION af_get_individu_formations(integer, integer, character varying, character varying, integer) IS 'retourne les formations d''un individu pour une filiere';


--
-- TOC entry 1103 (class 1255 OID 2595909)
-- Dependencies: 2983 5
-- Name: af_get_individu_formations(integer, character varying, character varying, integer, integer); Type: FUNCTION; Schema: contraintes; Owner: pgsql
--

CREATE FUNCTION af_get_individu_formations(integer, character varying, character varying, integer, integer) RETURNS SETOF record
    AS $_$-- $1 : numero user
-- $2 : ordre pour classement ('asc' ou 'desc')
-- $3 'date_debut' ou 'libelle' (orderby)
-- $4 periode (1 : passées, 2 : présentes, 3 : futures, 0 : toutes)
-- $5 individu
declare
rec record;
begin
    if contraintes.fw_is_root($5) then
    for rec in 
	select id,libelle,parcours,date_debut,date_fin,langue,ressources_fusionnees 
	from contraintes.af_get_formations($2,$3,$4) 
	as (id int4,libelle varchar,parcours int4,date_debut date,date_fin date,langue int4,ressources_fusionnees boolean),
	contraintes.formation_participants fp,contraintes.classe_individus ci 
	where fp.classe=ci.classe and fp.formation=id and ci.individu=$1 
    loop
	return next rec;
    end loop;
    else
    for rec in 
	select id,libelle,parcours,date_debut,date_fin,langue,ressources_fusionnees 
	from contraintes.af_get_formations($2,$3,$4) 
	as (id int4,libelle varchar,parcours int4,date_debut date,date_fin date,langue int4,ressources_fusionnees boolean),
	contraintes.formation_participants fp,contraintes.classe_individus ci 
	where fp.classe=ci.classe and fp.formation=id and ci.individu=$1 and fp.formateur=$5 
    loop
	return next rec;
    end loop;
    end if;
    return;   
end;$_$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_get_individu_formations(integer, character varying, character varying, integer, integer) OWNER TO pgsql;

--
-- TOC entry 7749 (class 0 OID 0)
-- Dependencies: 1103
-- Name: FUNCTION af_get_individu_formations(integer, character varying, character varying, integer, integer); Type: COMMENT; Schema: contraintes; Owner: pgsql
--

COMMENT ON FUNCTION af_get_individu_formations(integer, character varying, character varying, integer, integer) IS 'retourne les formations d''un individu pour le root ou formateur';


--
-- TOC entry 1104 (class 1255 OID 2595910)
-- Dependencies: 2983 5
-- Name: af_get_individu_grille(integer, integer, integer); Type: FUNCTION; Schema: contraintes; Owner: pgsql
--

CREATE FUNCTION af_get_individu_grille(integer, integer, integer) RETURNS SETOF record
    AS $_$DECLARE
rec record;
BEGIN
	SELECT INTO rec*
	FROM contraintes.stagiaire_grille
	WHERE formation=$1 and stagiaire=$2 and grille=$3;
	RETURN NEXT rec;

END;$_$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_get_individu_grille(integer, integer, integer) OWNER TO pgsql;

--
-- TOC entry 7751 (class 0 OID 0)
-- Dependencies: 1104
-- Name: FUNCTION af_get_individu_grille(integer, integer, integer); Type: COMMENT; Schema: contraintes; Owner: pgsql
--

COMMENT ON FUNCTION af_get_individu_grille(integer, integer, integer) IS 'retourne les infos de la table stagiaire_grille pour un individu';


--
-- TOC entry 1105 (class 1255 OID 2595911)
-- Dependencies: 2983 5
-- Name: af_get_individu_last_deconnexion(integer); Type: FUNCTION; Schema: contraintes; Owner: pgsql
--

CREATE FUNCTION af_get_individu_last_deconnexion(integer) RETURNS record
    AS $_$-- $1 : individu
declare
rec record;
begin
    select into rec max(deconnexion) from contraintes.connexion 
    where individu=$1;
    return rec;
end;$_$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_get_individu_last_deconnexion(integer) OWNER TO pgsql;

--
-- TOC entry 7753 (class 0 OID 0)
-- Dependencies: 1105
-- Name: FUNCTION af_get_individu_last_deconnexion(integer); Type: COMMENT; Schema: contraintes; Owner: pgsql
--

COMMENT ON FUNCTION af_get_individu_last_deconnexion(integer) IS 'retourne la derniere deconnexion pour un individu';


--
-- TOC entry 1106 (class 1255 OID 2595912)
-- Dependencies: 2983 5
-- Name: af_get_individu_nom_prenom(integer); Type: FUNCTION; Schema: contraintes; Owner: pgsql
--

CREATE FUNCTION af_get_individu_nom_prenom(integer) RETURNS record
    AS $_$-- $1 : numero individu
declare
rec record;
begin
    select into rec 
    id,nom,prenom from contraintes.fw_individu where id=$1;
    return rec;
end;$_$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_get_individu_nom_prenom(integer) OWNER TO pgsql;

--
-- TOC entry 7755 (class 0 OID 0)
-- Dependencies: 1106
-- Name: FUNCTION af_get_individu_nom_prenom(integer); Type: COMMENT; Schema: contraintes; Owner: pgsql
--

COMMENT ON FUNCTION af_get_individu_nom_prenom(integer) IS 'retourne nom et prenom d''un individu';


--
-- TOC entry 1107 (class 1255 OID 2595913)
-- Dependencies: 2983 5
-- Name: af_get_individu_themes(integer); Type: FUNCTION; Schema: contraintes; Owner: pgsql
--

CREATE FUNCTION af_get_individu_themes(integer) RETURNS SETOF record
    AS $_$-- $1 : individu
declare
rec record;

begin
    for rec in
	--select * from contraintes.themes 
    loop
	return next rec;
    end loop;
end;$_$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_get_individu_themes(integer) OWNER TO pgsql;

--
-- TOC entry 7757 (class 0 OID 0)
-- Dependencies: 1107
-- Name: FUNCTION af_get_individu_themes(integer); Type: COMMENT; Schema: contraintes; Owner: pgsql
--

COMMENT ON FUNCTION af_get_individu_themes(integer) IS 'retourne les themes pour un individu';


--
-- TOC entry 1108 (class 1255 OID 2595914)
-- Dependencies: 2983 5
-- Name: af_get_individu_types(integer); Type: FUNCTION; Schema: contraintes; Owner: pgsql
--

CREATE FUNCTION af_get_individu_types(integer) RETURNS SETOF record
    AS $_$declare
rec record;

begin
    for rec in 
	select id,libelle from contraintes.fw_individu_type,contraintes.fw_individu_types 
	where id=type and individu=$1 order by id
    loop
	return next rec;
    end loop;
    return;
end;$_$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_get_individu_types(integer) OWNER TO pgsql;

--
-- TOC entry 7759 (class 0 OID 0)
-- Dependencies: 1108
-- Name: FUNCTION af_get_individu_types(integer); Type: COMMENT; Schema: contraintes; Owner: pgsql
--

COMMENT ON FUNCTION af_get_individu_types(integer) IS 'retourne les types d''un individu';


--
-- TOC entry 1109 (class 1255 OID 2595915)
-- Dependencies: 2983 5
-- Name: af_get_individu_types(); Type: FUNCTION; Schema: contraintes; Owner: pgsql
--

CREATE FUNCTION af_get_individu_types() RETURNS SETOF record
    AS $$DECLARE

rec record;

BEGIN
	FOR rec IN
	  SELECT id,libelle,code 
	  FROM contraintes.fw_individu_type
	  ORDER BY libelle

	LOOP
	  return next rec;
	END LOOP;
return;

END;
$$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_get_individu_types() OWNER TO pgsql;

--
-- TOC entry 7761 (class 0 OID 0)
-- Dependencies: 1109
-- Name: FUNCTION af_get_individu_types(); Type: COMMENT; Schema: contraintes; Owner: pgsql
--

COMMENT ON FUNCTION af_get_individu_types() IS 'retourne tout les types';


--
-- TOC entry 1110 (class 1255 OID 2595916)
-- Dependencies: 2983 5
-- Name: af_get_individus(integer, character varying, boolean); Type: FUNCTION; Schema: contraintes; Owner: pgsql
--

CREATE FUNCTION af_get_individus(integer, character varying, boolean) RETURNS SETOF record
    AS $_$-- $1 (0=>tous, 1=>formateurs, 2=>utilisateurs)
-- $2 (asc ou desc)
-- $3 (vrai => que les utilisateurs ou que les formateurs)
declare
rec record;
req varchar;
begin
    req:='select distinct id,nom,prenom,organisme from contraintes.fw_individu,contraintes.fw_individu_types IT1 ';
    if $3 is true then
	req:= req || ',contraintes.fw_individu_types IT2 ' ;
    end if;
    if $1 !=0 then
	req:= req || ' where ';
    end if;
    -- suite req
    if $1=1 then -- LES FORMATEURS
	if $3 is true then -- LES FORMATEURS STRICT
	    req:=req || '  id =IT2.individu group by IT2.individu, IT1.individu, id, IT1.type, nom,prenom,organisme  having count(IT2.type)=1   ';
	    req:=req || ' and id =IT1.individu AND IT1.type=2';
	else
	    req:=req || ' id =IT1.individu AND IT1.type=2';
	end if;
	
    else
	if $1=2 then -- LES STAGIAIRES
	    if $3 is true then -- LES STAGIAIRES STRICT
	        req:=req || '  id =IT2.individu group by IT2.individu, IT1.individu, id, IT1.type, nom,prenom,organisme  having count(IT2.type)=1 '; 
		req:=req || ' and id =IT1.individu AND IT1.type=1';
	    else
		req:=req || ' id =IT1.individu AND IT1.type=1';
	    end if;
	    
	--/*
	else
	    if $1=3 then --LES INTERVENANTS
		if $3 is true then -- LES INTERVENANTS STRICT 
		    req:=req || '  id =IT2.individu group by IT2.individu, IT1.individu, id, IT1.type, nom,prenom,organisme  having count(IT2.type)=1 '; 
		    req:=req || ' and id =IT1.individu AND IT1.type=3';
	        else
		    req:=req || ' id =IT1.individu AND IT1.type=3';     
	        end if;
	    --else
		--raise exception 'la valeur pour le paramètre 3 (type) doit être 1,2 ou 0';
	    end if;
	--*/
	end if;
	
    end if;

    -- classement
    if $2 like 'DESC' then
	req:=req || ' order by nom desc ';
    else
	req:=req || ' order by nom ';
    end if;

	 raise notice 'req=%',req;
for rec in
	execute req
loop
return next rec;
end loop;
return ;
end;$_$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_get_individus(integer, character varying, boolean) OWNER TO pgsql;

--
-- TOC entry 7763 (class 0 OID 0)
-- Dependencies: 1110
-- Name: FUNCTION af_get_individus(integer, character varying, boolean); Type: COMMENT; Schema: contraintes; Owner: pgsql
--

COMMENT ON FUNCTION af_get_individus(integer, character varying, boolean) IS 'retourne les individus de la plateforme';


--
-- TOC entry 1111 (class 1255 OID 2595917)
-- Dependencies: 2983 5
-- Name: af_get_individus_exotlcs_corriges(); Type: FUNCTION; Schema: contraintes; Owner: pgsql
--

CREATE FUNCTION af_get_individus_exotlcs_corriges() RETURNS SETOF record
    AS $$declare
rec record;
begin
    for rec in
	select distinct I.id,I.nom,I.prenom
	
	from contraintes.fw_individu I where I.id in 
	(select R.stagiaire from contraintes.resultat R where R.id in
	(select RE.id from contraintes.resultat_exotlc RE where RE.date_correction is not null))
	
	
    loop
	return next rec;
    end loop;
end;$$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_get_individus_exotlcs_corriges() OWNER TO pgsql;

--
-- TOC entry 7765 (class 0 OID 0)
-- Dependencies: 1111
-- Name: FUNCTION af_get_individus_exotlcs_corriges(); Type: COMMENT; Schema: contraintes; Owner: pgsql
--

COMMENT ON FUNCTION af_get_individus_exotlcs_corriges() IS 'retourne les individus qui ont des exotlc corriges';


--
-- TOC entry 1112 (class 1255 OID 2595918)
-- Dependencies: 2983 5
-- Name: af_get_individus_infos(integer, character varying, boolean); Type: FUNCTION; Schema: contraintes; Owner: pgsql
--

CREATE FUNCTION af_get_individus_infos(integer, character varying, boolean) RETURNS SETOF record
    AS $_$-- $1 : type d'individu (0=tous, 1=formateurs & 2=stagiaires)
-- $2. ASC ou DESC = affichage dans l'ordre croissant ou decroissant
-- $3. exclusif : si VRAI alors que les 'u' ou les
declare
rec record;
req varchar;
begin
    req:='select distinct id,identifiant_md5,login,password,nom,prenom,adresse,code,ville,email,tel_fixe,tel_port,langue,organisme,photo from contraintes.fw_individu,contraintes.fw_individu_types IT1 ';
    if $3 is true then
	req:= req || ',contraintes.fw_individu_types IT2 ' ;
    end if;
    if $1 !=0 then
	req:= req || ' where ';
    end if;
    -- suite req
    if $1=1 then -- LES FORMATEURS
	if $3 is true then -- LES FORMATEURS STRICT
	    req:=req || '  id =IT2.individu group by IT2.individu, IT1.individu, id, IT1.type,identifiant_md5,login,password, nom,prenom,adresse,code,ville,email,tel_fixe,tel_port,langue,organisme,photo  having count(IT2.type)=1   ';
	    req:=req || ' and id =IT1.individu AND IT1.type=2';
	else
	    req:=req || ' id =IT1.individu AND IT1.type=2';
	end if;
	
    else
	if $1=2 then -- LES STAGIAIRES
	    if $3 is true then -- LES STAGIAIRES STRICT
	        req:=req || '  id =IT2.individu group by IT2.individu, IT1.individu, id, IT1.type,identifiant_md5,login,password, nom,prenom,adresse,code,ville,email,tel_fixe,tel_port,langue,organisme,photo  having count(IT2.type)=1 '; 
		req:=req || ' and id =IT1.individu AND IT1.type=1';
	    else
		req:=req || ' id =IT1.individu AND IT1.type=1';
	    end if;
	    
	--/*
	else
	    if $1=3 then --LES INTERVENANTS
		if $3 is true then -- LES INTERVENANTS STRICT 
		    req:=req || '  id =IT2.individu group by IT2.individu, IT1.individu, id, IT1.type, nom,prenom,organisme  having count(IT2.type)=1 '; 
		    req:=req || ' and id =IT1.individu AND IT1.type=3';
	        else
		    req:=req || ' id =IT1.individu AND IT1.type=3';     
	        end if;
	    --else
		--raise exception 'la valeur pour le paramètre 3 (type) doit être 1,2 ou 0';
	    end if;
	--*/
	end if;
	
    end if;

    -- classement
    if $2 like 'DESC' then
	req:=req || ' order by nom desc ';
    else
	req:=req || ' order by nom ';
    end if;

	 raise notice 'req=%',req; 
    for rec in
	execute req
    loop
	return next rec;
    end loop;
end;$_$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_get_individus_infos(integer, character varying, boolean) OWNER TO pgsql;

--
-- TOC entry 7767 (class 0 OID 0)
-- Dependencies: 1112
-- Name: FUNCTION af_get_individus_infos(integer, character varying, boolean); Type: COMMENT; Schema: contraintes; Owner: pgsql
--

COMMENT ON FUNCTION af_get_individus_infos(integer, character varying, boolean) IS 'Retourne les infos individus de la plateforme';


--
-- TOC entry 1851 (class 1255 OID 2595919)
-- Dependencies: 2983 5
-- Name: af_get_individus_initiale(character varying, integer, character varying, boolean); Type: FUNCTION; Schema: contraintes; Owner: pgsql
--

CREATE FUNCTION af_get_individus_initiale(character varying, integer, character varying, boolean) RETURNS SETOF record
    AS $_$-- $1 : initiale
-- $2 : type d'individu
-- $3 : classement (asc ou desc)
-- $4 : bool (excusif)
declare
rec record;
begin
    for rec in 
	select distinct id,nom,prenom from contraintes.af_get_individus($2,$3,$4) 
	--select * from contraintes.af_get_individus($2,$3,$4) 
	AS (id integer, nom varchar, prenom varchar,organisme int4) 
	where nom like $1 || '%' 
    loop
	return next rec;
    end loop;
end;$_$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_get_individus_initiale(character varying, integer, character varying, boolean) OWNER TO pgsql;

--
-- TOC entry 7769 (class 0 OID 0)
-- Dependencies: 1851
-- Name: FUNCTION af_get_individus_initiale(character varying, integer, character varying, boolean); Type: COMMENT; Schema: contraintes; Owner: pgsql
--

COMMENT ON FUNCTION af_get_individus_initiale(character varying, integer, character varying, boolean) IS 'retourne les individus dont le nom commence par l''initiale';


--
-- TOC entry 1852 (class 1255 OID 2595920)
-- Dependencies: 2983 5
-- Name: af_get_individus_types(); Type: FUNCTION; Schema: contraintes; Owner: pgsql
--

CREATE FUNCTION af_get_individus_types() RETURNS SETOF record
    AS $$DECLARE

rec record;

BEGIN
	FOR rec IN
	  SELECT id,libelle,code 
	  FROM contraintes.fw_individu_type
	  ORDER BY libelle

	LOOP
	  return next rec;
	END LOOP;
return;

END;
$$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_get_individus_types() OWNER TO pgsql;

--
-- TOC entry 7771 (class 0 OID 0)
-- Dependencies: 1852
-- Name: FUNCTION af_get_individus_types(); Type: COMMENT; Schema: contraintes; Owner: pgsql
--

COMMENT ON FUNCTION af_get_individus_types() IS 'retourne tous les individus_types';


--
-- TOC entry 1113 (class 1255 OID 2595921)
-- Dependencies: 2983 5
-- Name: af_get_inscription(integer); Type: FUNCTION; Schema: contraintes; Owner: pgsql
--

CREATE FUNCTION af_get_inscription(integer) RETURNS record
    AS $_$declare
rec record;

begin
    select into rec id, identifiant_md5 ,login ,password ,nom ,prenom ,adresse ,code ,ville ,
		email ,tel_fixe ,tel_port ,langue,organisme ,photo  from contraintes.inscription where id=$1;
    return rec;
    
end;$_$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_get_inscription(integer) OWNER TO pgsql;

--
-- TOC entry 7773 (class 0 OID 0)
-- Dependencies: 1113
-- Name: FUNCTION af_get_inscription(integer); Type: COMMENT; Schema: contraintes; Owner: pgsql
--

COMMENT ON FUNCTION af_get_inscription(integer) IS 'retourne les in infos d''une inscription';


--
-- TOC entry 1114 (class 1255 OID 2595922)
-- Dependencies: 2983 5
-- Name: af_get_inscriptions(); Type: FUNCTION; Schema: contraintes; Owner: pgsql
--

CREATE FUNCTION af_get_inscriptions() RETURNS SETOF record
    AS $$declare
rec record;
begin
    for rec in
	select * from contraintes.inscription order by nom
    loop
	return next rec;
    end loop;
end;$$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_get_inscriptions() OWNER TO pgsql;

--
-- TOC entry 7775 (class 0 OID 0)
-- Dependencies: 1114
-- Name: FUNCTION af_get_inscriptions(); Type: COMMENT; Schema: contraintes; Owner: pgsql
--

COMMENT ON FUNCTION af_get_inscriptions() IS 'retourne les inscrits en attente de validation';


--
-- TOC entry 1115 (class 1255 OID 2595923)
-- Dependencies: 2983 5
-- Name: af_get_intervenant_evenements(integer, date); Type: FUNCTION; Schema: contraintes; Owner: pgsql
--

CREATE FUNCTION af_get_intervenant_evenements(integer, date) RETURNS SETOF record
    AS $_$-- $1 : intervenant
-- $2 : date
declare
rec record;
begin
    for rec in 
	select * from contraintes.evenement 
	where intervenant=$1 and cast(date as date)=$2
    loop
	return next rec;
    end loop;
end;$_$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_get_intervenant_evenements(integer, date) OWNER TO pgsql;

--
-- TOC entry 7777 (class 0 OID 0)
-- Dependencies: 1115
-- Name: FUNCTION af_get_intervenant_evenements(integer, date); Type: COMMENT; Schema: contraintes; Owner: pgsql
--

COMMENT ON FUNCTION af_get_intervenant_evenements(integer, date) IS 'retourne les evenements d''un intervenant pour un jour de formation';


--
-- TOC entry 1116 (class 1255 OID 2595924)
-- Dependencies: 2983 5
-- Name: af_get_intervenant_evenements_presentiels(integer, integer); Type: FUNCTION; Schema: contraintes; Owner: pgsql
--

CREATE FUNCTION af_get_intervenant_evenements_presentiels(integer, integer) RETURNS SETOF record
    AS $_$-- $1 : intervenant
-- $2 : formation
declare
rec record;
begin
    for rec in
	select formation,libelle,date,duree,modalite,intervention,intervenant,salle 
	from contraintes.af_get_formation_evenements_presentiels($2) 
	as (formation int4,libelle varchar,date timestamp,duree interval,modalite int4,intervention int4,intervenant int4,salle int4) 
	where intervenant=$1 order by date
    loop
	return next rec;
    end loop;
end;$_$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_get_intervenant_evenements_presentiels(integer, integer) OWNER TO pgsql;

--
-- TOC entry 7779 (class 0 OID 0)
-- Dependencies: 1116
-- Name: FUNCTION af_get_intervenant_evenements_presentiels(integer, integer); Type: COMMENT; Schema: contraintes; Owner: pgsql
--

COMMENT ON FUNCTION af_get_intervenant_evenements_presentiels(integer, integer) IS 'retourne les evenements presentiels d''une formation pour un intervenant';


--
-- TOC entry 1117 (class 1255 OID 2595925)
-- Dependencies: 2983 5
-- Name: af_get_intervenant_formations_grille(integer); Type: FUNCTION; Schema: contraintes; Owner: pgsql
--

CREATE FUNCTION af_get_intervenant_formations_grille(integer) RETURNS SETOF record
    AS $_$-- $1 : intervenant
declare
rec record;
begin
    for rec in 
	select distinct id,f.libelle from 
	contraintes.formation f,
	contraintes.evenement e,
	contraintes.grille_resultats gr 
	where id=e.formation and e.intervenant=$1 and e.modalite=3 and id=gr.formation
    loop
	return next rec;
    end loop;
end;$_$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_get_intervenant_formations_grille(integer) OWNER TO pgsql;

--
-- TOC entry 7781 (class 0 OID 0)
-- Dependencies: 1117
-- Name: FUNCTION af_get_intervenant_formations_grille(integer); Type: COMMENT; Schema: contraintes; Owner: pgsql
--

COMMENT ON FUNCTION af_get_intervenant_formations_grille(integer) IS 'retourne les formations avec grille pour un intervenant';


--
-- TOC entry 1118 (class 1255 OID 2595926)
-- Dependencies: 2983 5
-- Name: af_get_intervenant_formations_presentielles(integer); Type: FUNCTION; Schema: contraintes; Owner: pgsql
--

CREATE FUNCTION af_get_intervenant_formations_presentielles(integer) RETURNS SETOF record
    AS $_$-- $1 : intervenant
declare
rec record;
begin
    for rec in
	select distinct f.id,f.libelle from contraintes.formation f,contraintes.evenement 
	where f.id=formation and intervenant=$1 and modalite=3
    loop
	return next rec;
    end loop;
end;$_$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_get_intervenant_formations_presentielles(integer) OWNER TO pgsql;

--
-- TOC entry 7783 (class 0 OID 0)
-- Dependencies: 1118
-- Name: FUNCTION af_get_intervenant_formations_presentielles(integer); Type: COMMENT; Schema: contraintes; Owner: pgsql
--

COMMENT ON FUNCTION af_get_intervenant_formations_presentielles(integer) IS 'retourne les formations presentielles d''un intervenant';


--
-- TOC entry 1119 (class 1255 OID 2595927)
-- Dependencies: 2983 5
-- Name: af_get_intervenants(integer); Type: FUNCTION; Schema: contraintes; Owner: pgsql
--

CREATE FUNCTION af_get_intervenants(integer) RETURNS SETOF record
    AS $_$declare
rec record;
begin
    if contraintes.fw_is_root($1) or contraintes.fw_is_formateur($1) then
    for rec in
	select id,nom,prenom from contraintes.fw_individu i,contraintes.fw_individu_types it 
	where i.id=it.individu and it.type=3
    loop
	return next rec;
    end loop;
    else
    for rec in
	select id,nom,prenom from contraintes.fw_individu i,contraintes.fw_individu_types it 
	where i.id=it.individu and it.type=3 and i.id=$1
    loop
	return next rec;
    end loop;
    end if;
end;$_$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_get_intervenants(integer) OWNER TO pgsql;

--
-- TOC entry 7785 (class 0 OID 0)
-- Dependencies: 1119
-- Name: FUNCTION af_get_intervenants(integer); Type: COMMENT; Schema: contraintes; Owner: pgsql
--

COMMENT ON FUNCTION af_get_intervenants(integer) IS 'retourne les intervenants de formation
si root ou formateur';


--
-- TOC entry 1120 (class 1255 OID 2595928)
-- Dependencies: 2983 5
-- Name: af_get_intervenants_presentiel_grille(integer); Type: FUNCTION; Schema: contraintes; Owner: pgsql
--

CREATE FUNCTION af_get_intervenants_presentiel_grille(integer) RETURNS SETOF record
    AS $_$-- $1 : individu
declare
rec record;
begin
    for rec in 
	select distinct id,nom,prenom from 
	contraintes.af_get_intervenants($1) as (id int4,nom varchar,prenom varchar),
	contraintes.evenement e,
	contraintes.grille_resultats gr 
	where id=e.intervenant and e.modalite=3 and e.formation=gr.formation
    loop
	return next rec;
    end loop;
end;$_$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_get_intervenants_presentiel_grille(integer) OWNER TO pgsql;

--
-- TOC entry 7787 (class 0 OID 0)
-- Dependencies: 1120
-- Name: FUNCTION af_get_intervenants_presentiel_grille(integer); Type: COMMENT; Schema: contraintes; Owner: pgsql
--

COMMENT ON FUNCTION af_get_intervenants_presentiel_grille(integer) IS 'retourne les intervenants presentiel avec grille si root';


--
-- TOC entry 1121 (class 1255 OID 2595929)
-- Dependencies: 2983 5
-- Name: af_get_intervention(integer); Type: FUNCTION; Schema: contraintes; Owner: pgsql
--

CREATE FUNCTION af_get_intervention(integer) RETURNS record
    AS $_$-- $1 : numero intervention
declare
rec record;
begin
    select into rec * from contraintes.af_get_interventions() as (id int4,libelle varchar,couleur varchar) where id=$1;
    return rec;
end;$_$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_get_intervention(integer) OWNER TO pgsql;

--
-- TOC entry 7789 (class 0 OID 0)
-- Dependencies: 1121
-- Name: FUNCTION af_get_intervention(integer); Type: COMMENT; Schema: contraintes; Owner: pgsql
--

COMMENT ON FUNCTION af_get_intervention(integer) IS 'retourne une intervention';


--
-- TOC entry 1122 (class 1255 OID 2595930)
-- Dependencies: 2983 5
-- Name: af_get_interventions(); Type: FUNCTION; Schema: contraintes; Owner: pgsql
--

CREATE FUNCTION af_get_interventions() RETURNS SETOF record
    AS $$declare
rec record;
begin
    for rec in 
	select id,libelle,couleur from contraintes.intervention order by libelle
    loop
	return next rec;
    end loop;
    return;
end;$$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_get_interventions() OWNER TO pgsql;

--
-- TOC entry 7791 (class 0 OID 0)
-- Dependencies: 1122
-- Name: FUNCTION af_get_interventions(); Type: COMMENT; Schema: contraintes; Owner: pgsql
--

COMMENT ON FUNCTION af_get_interventions() IS 'retourne les intervention de la plateforme';


--
-- TOC entry 1123 (class 1255 OID 2595931)
-- Dependencies: 2983 5
-- Name: af_get_langue(integer); Type: FUNCTION; Schema: contraintes; Owner: pgsql
--

CREATE FUNCTION af_get_langue(integer) RETURNS record
    AS $_$declare
rec record;
begin
    select into rec * from contraintes.af_get_langues() as (id int4,libelle varchar, code varchar, locale varchar) 
    where id=$1;
    return rec;
end;$_$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_get_langue(integer) OWNER TO pgsql;

--
-- TOC entry 7793 (class 0 OID 0)
-- Dependencies: 1123
-- Name: FUNCTION af_get_langue(integer); Type: COMMENT; Schema: contraintes; Owner: pgsql
--

COMMENT ON FUNCTION af_get_langue(integer) IS 'retourne les info langue';


--
-- TOC entry 1124 (class 1255 OID 2595932)
-- Dependencies: 2983 5
-- Name: af_get_langue(character varying); Type: FUNCTION; Schema: contraintes; Owner: pgsql
--

CREATE FUNCTION af_get_langue(character varying) RETURNS record
    AS $_$declare
rec record;
begin
    select into rec * from contraintes.af_get_langues() as (id int4,libelle varchar, code varchar, locale varchar) 
    where code=$1;
    return rec;
end;$_$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_get_langue(character varying) OWNER TO pgsql;

--
-- TOC entry 7795 (class 0 OID 0)
-- Dependencies: 1124
-- Name: FUNCTION af_get_langue(character varying); Type: COMMENT; Schema: contraintes; Owner: pgsql
--

COMMENT ON FUNCTION af_get_langue(character varying) IS 'retourne les info langue à partir du code';


--
-- TOC entry 1125 (class 1255 OID 2595933)
-- Dependencies: 2983 5
-- Name: af_get_langue_libelles(integer[], integer, integer, character varying, integer, integer, character varying); Type: FUNCTION; Schema: contraintes; Owner: pgsql
--

CREATE FUNCTION af_get_langue_libelles(integer[], integer, integer, character varying, integer, integer, character varying) RETURNS SETOF record
    AS $_$-- $1 : tableau de langue
-- $2 : type
-- $3 : numero du champ pour l'order by
-- $4 : classement (asc ou desc)
-- $5 : limit
-- $6 : offset
declare
rec record;
rec_langue record;
req varchar;
req_select varchar;
req_from varchar;
req_where varchar;
req_and varchar;
nb_langue integer;
i integer;
indice integer;
ind_select integer;
ind_from integer;
ind_where integer;
orderby varchar;
last_ref varchar;
msg alias for $7;
begin
    -- Exemple de requete à construire ( ici 4 langues : francais,anglais,chinois,japonnais)
    /*
    select a.id,a.libelle as francais,b.libelle as anglais,c.libelle as chinois,d.libelle as japonnais 
    from ((contraintes.langue_message as a join contraintes.langue_message as b
    on (a.id=b.id)) 
    join  contraintes.langue_message as c
    on (a.id=c.id)) 
    join contraintes.langue_message as d
    on (a.id=d.id)
    where (a.type=11 and b.type=11 and c.type=11 and d.type=11) 
    and (a.langue=1 and b.langue=2 and c.langue=3 and d.langue=4)
    order by a.id
    limit 7
    offset 0
    */


    -- INITIALISATION
    -- nombre de langues
    nb_langue:=0;
    nb_langue:=array_upper($1,1);
    -- premiere langue du tableau
    indice:=$1[1];
    --raise notice 'lg1=%',indice;
    --raise notice 'nb=%',nb_langue;	
    -- ordder by
    if $3 =0 then
	orderby:='lm'||indice||'.id';
    else
	orderby:='lm'||$3||'.libelle';
    end if;

    -- CONSTRUCTION REQUETE
    
    -- DEBUT REQUETE
    req:='';
    req_select:='select lm'||indice||'.id,';
    req_from:=' from ';
    req_where:=' where ';
    req_and:=' ';
    -- boucle sur le nb de langue
    ind_select:=0;
    ind_from:=0;
    ind_where:=0;
    FOR i IN array_lower($1,1)..array_upper($1,1)
    loop
	-- recup libelle langue pour construction select
	select into rec_langue * from contraintes.af_get_langue($1[i]) as (id int4,libelle varchar, code varchar, locale varchar);
	req_select:=req_select || 'lm'||$1[i] || '.'||'libelle as '||rec_langue.code ;
	ind_select:=ind_select + 1;
	if ind_select < nb_langue then
	    req_select:=req_select ||',';
	end if;

    -- contruction du from

    if ind_from=0 then
	ind_from:=ind_from + 1;
	req_from:=req_from || 'contraintes.langue_message as lm'||$1[i]; 
	    last_ref:='lm'||$1[i];
    else
	req_from:=req_from || ' join contraintes.langue_message as lm'||$1[i];
	req_from:=req_from || ' on '|| last_ref||'.id = lm'||$1[i]||'.id ';
	last_ref:='lm'||$1[i];
    end if;

    -- contruction du where
    ind_where:=ind_where+1;
	req_where:=req_where || 'lm'||$1[i]||'.type='||$2;
	if ind_where < nb_langue then
	    req_where:=req_where||' and ';
	end if;
    -- construction and
    req_and:=req_and || ' and lm'||$1[i]||'.langue='||$1[i];
    	
    end loop;
    
    -- assemblage
    req:=req || req_select||req_from||req_where||req_and;
    --raise notice 'req_select=% et req_from=% et req_where=% et req_and=%' ,req_select,req_from,req_where,req_and;
--raise notice 'msg=%',msg;
    -- test recherche libelle OK (A suivre ...)
    if $7 is not null then
	req:=req || ' and lm'||$1[1]||'.libelle ilike '''||msg||''''; 
    end if;
    --raise notice 'req=%',req; 
    -- fin requete
    req:=req ||' order by '||orderby ||' '|| $4 ;
    req:=req ||' limit ' ||$5;
    req:=req ||' offset '||$6;

    for rec in
	execute req
    loop
	return next rec;
    end loop;

end;$_$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_get_langue_libelles(integer[], integer, integer, character varying, integer, integer, character varying) OWNER TO pgsql;

--
-- TOC entry 7797 (class 0 OID 0)
-- Dependencies: 1125
-- Name: FUNCTION af_get_langue_libelles(integer[], integer, integer, character varying, integer, integer, character varying); Type: COMMENT; Schema: contraintes; Owner: pgsql
--

COMMENT ON FUNCTION af_get_langue_libelles(integer[], integer, integer, character varying, integer, integer, character varying) IS 'retourne les libelles des langues pour un type donné';


--
-- TOC entry 1853 (class 1255 OID 2595934)
-- Dependencies: 2983 5
-- Name: af_get_langue_message_libelle(integer, integer, integer); Type: FUNCTION; Schema: contraintes; Owner: pgsql
--

CREATE FUNCTION af_get_langue_message_libelle(integer, integer, integer) RETURNS record
    AS $_$-- $1 : numero id
-- $2 : langue
-- $3 : type
declare
rec record;
begin
    select into rec id,libelle,type,langue from contraintes.langue_message 
    where id=$1 and langue=$2 and type=$3;
    return rec;
end;$_$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_get_langue_message_libelle(integer, integer, integer) OWNER TO pgsql;

--
-- TOC entry 7799 (class 0 OID 0)
-- Dependencies: 1853
-- Name: FUNCTION af_get_langue_message_libelle(integer, integer, integer); Type: COMMENT; Schema: contraintes; Owner: pgsql
--

COMMENT ON FUNCTION af_get_langue_message_libelle(integer, integer, integer) IS 'retourne le libelle pour un id,un type et une langue';


--
-- TOC entry 1126 (class 1255 OID 2595935)
-- Dependencies: 2983 5
-- Name: af_get_langue_messages(integer); Type: FUNCTION; Schema: contraintes; Owner: pgsql
--

CREATE FUNCTION af_get_langue_messages(integer) RETURNS SETOF record
    AS $_$-- $1 : langue
declare
rec record;
begin
    for rec in
	select lm.id,lm.libelle,lm.type,lm.langue,lt.code||'_'||lm.id as message from contraintes.langue_message lm,contraintes.langue_type lt
	where lm.langue=$1 and lm.type=lt.id order by lm.type,lm.id
    loop
	return next rec;
    end loop;
end;$_$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_get_langue_messages(integer) OWNER TO pgsql;

--
-- TOC entry 7801 (class 0 OID 0)
-- Dependencies: 1126
-- Name: FUNCTION af_get_langue_messages(integer); Type: COMMENT; Schema: contraintes; Owner: pgsql
--

COMMENT ON FUNCTION af_get_langue_messages(integer) IS 'retourne les messages de langue pour une langue donnée';


--
-- TOC entry 1127 (class 1255 OID 2595936)
-- Dependencies: 2983 5
-- Name: af_get_langue_messages_type(integer, integer, character varying); Type: FUNCTION; Schema: contraintes; Owner: pgsql
--

CREATE FUNCTION af_get_langue_messages_type(integer, integer, character varying) RETURNS SETOF record
    AS $_$-- $1 : langue
-- $2 : type
-- $3 : message
declare
rec record;
req varchar;
msg alias for $3;
begin
    req:='select lm_id,lm_libelle,lm_type,lm_langue,lm_message from contraintes.af_get_langue_messages('||$1||')';
    req:=req ||'as (lm_id integer,lm_libelle text,lm_type integer,lm_langue integer,lm_message text)'; 
    req:=req ||'where lm_type='||$2;
    if $3 is not null then
	req:=req || 'and lm_libelle like '''||msg||''''; 
    end if;
raise notice 'req=%',req; 
	
    for rec in
	/*
	select lm_id,lm_libelle,lm_type,lm_langue,lm_message from contraintes.af_get_langue_messages($1) 
	as (lm_id integer,lm_libelle text,lm_type integer,lm_langue integer,lm_message text) 
	where lm_type=$2
	*/
	execute req
    loop
	return next rec;
    end loop;
end;$_$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_get_langue_messages_type(integer, integer, character varying) OWNER TO pgsql;

--
-- TOC entry 7803 (class 0 OID 0)
-- Dependencies: 1127
-- Name: FUNCTION af_get_langue_messages_type(integer, integer, character varying); Type: COMMENT; Schema: contraintes; Owner: pgsql
--

COMMENT ON FUNCTION af_get_langue_messages_type(integer, integer, character varying) IS 'retourne les messages langue pour une langue et un type';


--
-- TOC entry 24 (class 1255 OID 2595937)
-- Dependencies: 2983 5
-- Name: af_get_langue_type(integer); Type: FUNCTION; Schema: contraintes; Owner: pgsql
--

CREATE FUNCTION af_get_langue_type(integer) RETURNS record
    AS $_$-- $1 : type
declare
rec record;
begin
    select into rec * from contraintes.af_get_langue_types() as (id integer,libelle varchar,code varchar) 
    where id=$1;
    return rec;
end;$_$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_get_langue_type(integer) OWNER TO pgsql;

--
-- TOC entry 7805 (class 0 OID 0)
-- Dependencies: 24
-- Name: FUNCTION af_get_langue_type(integer); Type: COMMENT; Schema: contraintes; Owner: pgsql
--

COMMENT ON FUNCTION af_get_langue_type(integer) IS 'retourne les infos d''un type de message de langue';


--
-- TOC entry 1128 (class 1255 OID 2595938)
-- Dependencies: 2983 5
-- Name: af_get_langue_types(); Type: FUNCTION; Schema: contraintes; Owner: pgsql
--

CREATE FUNCTION af_get_langue_types() RETURNS SETOF record
    AS $$declare
rec record;
begin
    for rec in 
	-- order by provisoire (modif said 08/01/08)
	select * from contraintes.langue_type order by id
    loop
	return next rec;
    end loop;
end;$$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_get_langue_types() OWNER TO pgsql;

--
-- TOC entry 7807 (class 0 OID 0)
-- Dependencies: 1128
-- Name: FUNCTION af_get_langue_types(); Type: COMMENT; Schema: contraintes; Owner: pgsql
--

COMMENT ON FUNCTION af_get_langue_types() IS 'retourne les types de message langue';


--
-- TOC entry 1129 (class 1255 OID 2595939)
-- Dependencies: 2983 5
-- Name: af_get_langues(); Type: FUNCTION; Schema: contraintes; Owner: pgsql
--

CREATE FUNCTION af_get_langues() RETURNS SETOF record
    AS $$declare
rec record;
begin
    for rec in 
	select id,libelle, code, locale from contraintes.langue
    loop
	return next rec;
    end loop;
    return;
end;$$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_get_langues() OWNER TO pgsql;

--
-- TOC entry 7809 (class 0 OID 0)
-- Dependencies: 1129
-- Name: FUNCTION af_get_langues(); Type: COMMENT; Schema: contraintes; Owner: pgsql
--

COMMENT ON FUNCTION af_get_langues() IS 'retourne les langues de la plateforme';


--
-- TOC entry 1130 (class 1255 OID 2595940)
-- Dependencies: 2983 5
-- Name: af_get_langues_messages_type(integer[], integer); Type: FUNCTION; Schema: contraintes; Owner: pgsql
--

CREATE FUNCTION af_get_langues_messages_type(integer[], integer) RETURNS SETOF record
    AS $_$-- $1 : tableau de langues
-- $2 : type
declare
rec record;
i integer;
begin
    for i in array_lower($1,1) .. array_upper($1,1)
    loop
	for rec in
	    select * from contraintes.af_get_langue_messages_type(i,$2) as (id int4,libelle text,type int4,langue int4,variable text)
	loop
	    return next rec;
	end loop;
    end loop;
end;$_$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_get_langues_messages_type(integer[], integer) OWNER TO pgsql;

--
-- TOC entry 7811 (class 0 OID 0)
-- Dependencies: 1130
-- Name: FUNCTION af_get_langues_messages_type(integer[], integer); Type: COMMENT; Schema: contraintes; Owner: pgsql
--

COMMENT ON FUNCTION af_get_langues_messages_type(integer[], integer) IS 'retourne les messages de langues pour un type';


--
-- TOC entry 1131 (class 1255 OID 2595941)
-- Dependencies: 2983 5
-- Name: af_get_liste(integer); Type: FUNCTION; Schema: contraintes; Owner: pgsql
--

CREATE FUNCTION af_get_liste(integer) RETURNS record
    AS $_$DECLARE
--$1 liste
rec RECORD;
BEGIN
	SELECT INTO rec id, E_libelle, type, date_creation FROM contraintes.liste, contraintes.af_get_etape($1) AS (E_id int4, E_libelle varchar, E_type int4,date_creation timestamp)
	WHERE id=$1 
	AND id=E_id;

	RETURN rec;
END;$_$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_get_liste(integer) OWNER TO pgsql;

--
-- TOC entry 1132 (class 1255 OID 2595942)
-- Dependencies: 2983 5
-- Name: af_get_liste_themes(integer); Type: FUNCTION; Schema: contraintes; Owner: pgsql
--

CREATE FUNCTION af_get_liste_themes(integer) RETURNS SETOF record
    AS $_$declare
rec record;
rec_tmp record;
--$1 liste
categorie int4;
BEGIN
	--recup le type de la liste
	SELECT INTO rec_tmp id, type FROM contraintes.af_get_liste($1) AS (id int4, libelle varchar, type int4);
	
	IF rec_tmp.id IS NULL THEN
		RAISE EXCEPTION 'La liste d''identifiant % n''existe pas', $1;
	END IF;

	--categorie
	IF rec_tmp.type=1 THEN
		categorie:=19;
	ELSEIF rec_tmp.type=3 THEN
		categorie:=44;
	ELSE 
		RAISE EXCEPTION 'Le type % n''est pas un liste_type valide',rec_tmp.type;
	END IF;

	--requete
	FOR rec IN 
		SELECT * FROM contraintes.af_get_element_themes_categorie($1,categorie) AS (id int4, libelle varchar)
	LOOP
		return next rec;
	end loop;

	RETURN;
end;$_$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_get_liste_themes(integer) OWNER TO pgsql;

--
-- TOC entry 7814 (class 0 OID 0)
-- Dependencies: 1132
-- Name: FUNCTION af_get_liste_themes(integer); Type: COMMENT; Schema: contraintes; Owner: pgsql
--

COMMENT ON FUNCTION af_get_liste_themes(integer) IS 'retourne les themes d''une liste ';


--
-- TOC entry 1133 (class 1255 OID 2595943)
-- Dependencies: 2983 5
-- Name: af_get_medias(); Type: FUNCTION; Schema: contraintes; Owner: postgres
--

CREATE FUNCTION af_get_medias() RETURNS SETOF record
    AS $$DECLARE
rec record;
BEGIN
	
	FOR  rec IN
		select  id from contraintes.media
	LOOP
		RETURN NEXT rec;
	END LOOP;

	RETURN;

END$$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_get_medias() OWNER TO postgres;

--
-- TOC entry 7816 (class 0 OID 0)
-- Dependencies: 1133
-- Name: FUNCTION af_get_medias(); Type: COMMENT; Schema: contraintes; Owner: postgres
--

COMMENT ON FUNCTION af_get_medias() IS 'retourne le contenu de la table media';


--
-- TOC entry 1134 (class 1255 OID 2595944)
-- Dependencies: 2983 5
-- Name: af_get_medias_scenarios_theme(integer); Type: FUNCTION; Schema: contraintes; Owner: pgsql
--

CREATE FUNCTION af_get_medias_scenarios_theme(integer) RETURNS SETOF record
    AS $_$DECLARE
rec RECORD;
BEGIN
	FOR rec IN
		SELECT id,libelle,type,theme_id,theme_libelle
		FROM 
		contraintes.af_get_medias_scenarios_themes()  AS (id integer, libelle varchar, type integer, theme_id integer, theme_libelle varchar)
		WHERE theme_id=$1
		ORDER BY id,libelle
	LOOP
		RETURN NEXT rec;
	END LOOP;

	RETURN;

END;$_$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_get_medias_scenarios_theme(integer) OWNER TO pgsql;

--
-- TOC entry 7818 (class 0 OID 0)
-- Dependencies: 1134
-- Name: FUNCTION af_get_medias_scenarios_theme(integer); Type: COMMENT; Schema: contraintes; Owner: pgsql
--

COMMENT ON FUNCTION af_get_medias_scenarios_theme(integer) IS 'obtenir tous les médias d''un theme';


--
-- TOC entry 1135 (class 1255 OID 2595945)
-- Dependencies: 2983 5
-- Name: af_get_medias_scenarios_themes(integer); Type: FUNCTION; Schema: contraintes; Owner: pgsql
--

CREATE FUNCTION af_get_medias_scenarios_themes(integer) RETURNS SETOF record
    AS $_$DECLARE
rec RECORD;
BEGIN
	if contraintes.fw_is_root($1) then
	FOR rec IN
		SELECT F_id,F_libelle,F_type,T_id,T_libelle
		FROM 
		contraintes.af_get_categorie_elements(2) AS (C_id integer, C_theme integer,C_categorie integer) ,
		contraintes.af_get_categorie_themes(2,$1) AS (T_id integer, T_libelle varchar),
		contraintes.af_get_fichiers() AS (F_id integer, F_libelle varchar, F_type integer, F_connecte boolean)
		WHERE C_theme=T_id
		AND C_id=F_id
		AND F_connecte IS TRUE
		ORDER BY T_id,T_libelle,F_type
	LOOP
		RETURN NEXT rec;
	END LOOP;
	else
	FOR rec IN
		SELECT F_id,F_libelle,F_type,T_id,T_libelle
		FROM 
		contraintes.af_get_categorie_elements(2) AS (C_id integer, C_theme integer,C_categorie integer) ,
		contraintes.af_get_categorie_themes(2,$1) AS (T_id integer, T_libelle varchar),
		contraintes.af_get_fichiers() AS (F_id integer, F_libelle varchar, F_type integer, F_connecte boolean)
		WHERE C_theme=T_id
		AND C_id=F_id
		AND F_connecte IS TRUE
		ORDER BY T_id,T_libelle,F_type
	LOOP
		RETURN NEXT rec;
	END LOOP;
	end if;

	RETURN;

END;$_$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_get_medias_scenarios_themes(integer) OWNER TO pgsql;

--
-- TOC entry 7820 (class 0 OID 0)
-- Dependencies: 1135
-- Name: FUNCTION af_get_medias_scenarios_themes(integer); Type: COMMENT; Schema: contraintes; Owner: pgsql
--

COMMENT ON FUNCTION af_get_medias_scenarios_themes(integer) IS 'obtenir tous les médias et leurs themes';


--
-- TOC entry 1136 (class 1255 OID 2595946)
-- Dependencies: 2983 5
-- Name: af_get_medias_scenarios_themes(); Type: FUNCTION; Schema: contraintes; Owner: pgsql
--

CREATE FUNCTION af_get_medias_scenarios_themes() RETURNS SETOF record
    AS $$DECLARE
rec RECORD;
BEGIN
	FOR rec IN
		SELECT F_id,F_libelle,F_type,t.id,t.libelle
		FROM 
		contraintes.af_get_categorie_elements(2) AS (C_id integer, C_theme integer,C_categorie integer) ,
		contraintes.theme t ,
		contraintes.af_get_fichiers() AS (F_id integer, F_libelle varchar, F_type integer, F_connecte boolean)
		WHERE C_theme=t.id
		AND C_id=F_id
		
		AND F_connecte IS TRUE
		ORDER BY t.id,t.libelle,F_type
	LOOP
		RETURN NEXT rec;
	END LOOP;
	
	RETURN;

END;$$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_get_medias_scenarios_themes() OWNER TO pgsql;

--
-- TOC entry 7822 (class 0 OID 0)
-- Dependencies: 1136
-- Name: FUNCTION af_get_medias_scenarios_themes(); Type: COMMENT; Schema: contraintes; Owner: pgsql
--

COMMENT ON FUNCTION af_get_medias_scenarios_themes() IS 'obtenir tous les médias et leurs themes';


--
-- TOC entry 1137 (class 1255 OID 2595947)
-- Dependencies: 2983 5
-- Name: af_get_modalite(integer); Type: FUNCTION; Schema: contraintes; Owner: pgsql
--

CREATE FUNCTION af_get_modalite(integer) RETURNS record
    AS $_$-- $1 : numero modalite
declare
rec record;
begin
    SELECT into rec * FROM contraintes.af_get_modalites() as (id int4, libelle varchar, code varchar) 
	WHERE id=$1;

	RETURN rec;
end;$_$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_get_modalite(integer) OWNER TO pgsql;

--
-- TOC entry 7824 (class 0 OID 0)
-- Dependencies: 1137
-- Name: FUNCTION af_get_modalite(integer); Type: COMMENT; Schema: contraintes; Owner: pgsql
--

COMMENT ON FUNCTION af_get_modalite(integer) IS 'retourne une modalite';


--
-- TOC entry 1138 (class 1255 OID 2595948)
-- Dependencies: 2983 5
-- Name: af_get_modalites(); Type: FUNCTION; Schema: contraintes; Owner: pgsql
--

CREATE FUNCTION af_get_modalites() RETURNS SETOF record
    AS $$declare
rec record;
begin
    for rec in 
	SELECT * FROM contraintes.modalite
    LOOP
	RETURN NEXT rec;
    END LOOP;

	RETURN;
end;$$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_get_modalites() OWNER TO pgsql;

--
-- TOC entry 7826 (class 0 OID 0)
-- Dependencies: 1138
-- Name: FUNCTION af_get_modalites(); Type: COMMENT; Schema: contraintes; Owner: pgsql
--

COMMENT ON FUNCTION af_get_modalites() IS 'retourne les modalites de la plateforme';


--
-- TOC entry 1854 (class 1255 OID 2595949)
-- Dependencies: 2983 5
-- Name: af_get_modele_correction_criteres(integer); Type: FUNCTION; Schema: contraintes; Owner: pgsql
--

CREATE FUNCTION af_get_modele_correction_criteres(integer) RETURNS SETOF record
    AS $_$-- $1 : numero modele correction
declare
rec record;
begin
    for rec in 
	select M1.modele_correction, M1.critere, fils.id,M1.note_max
	from contraintes.modele_correction M1 
	     left outer join(	contraintes.critere pere 
						left outer join contraintes.critere fils 
						on (fils.pere=pere.id)
					)
			on (M1.critere=pere.id)
	where M1.modele_correction=$1
	
    loop
	return next rec;
    end loop;
    return;
end;$_$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_get_modele_correction_criteres(integer) OWNER TO pgsql;

--
-- TOC entry 7828 (class 0 OID 0)
-- Dependencies: 1854
-- Name: FUNCTION af_get_modele_correction_criteres(integer); Type: COMMENT; Schema: contraintes; Owner: pgsql
--

COMMENT ON FUNCTION af_get_modele_correction_criteres(integer) IS 'retourne les criteres et sous criteres d''un medele de correction';


--
-- TOC entry 1139 (class 1255 OID 2595950)
-- Dependencies: 2983 5
-- Name: af_get_modeles_correction(); Type: FUNCTION; Schema: contraintes; Owner: pgsql
--

CREATE FUNCTION af_get_modeles_correction() RETURNS SETOF record
    AS $$
declare
rec record;
begin
    for rec in 
	select id,libelle from contraintes.modele_correction 
	
    loop
	return next rec;
    end loop;
    return;
end;$$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_get_modeles_correction() OWNER TO pgsql;

--
-- TOC entry 7830 (class 0 OID 0)
-- Dependencies: 1139
-- Name: FUNCTION af_get_modeles_correction(); Type: COMMENT; Schema: contraintes; Owner: pgsql
--

COMMENT ON FUNCTION af_get_modeles_correction() IS 'retourne les modeles de correction de la plateforme';


--
-- TOC entry 1140 (class 1255 OID 2595951)
-- Dependencies: 2983 5
-- Name: af_get_organisme(integer); Type: FUNCTION; Schema: contraintes; Owner: pgsql
--

CREATE FUNCTION af_get_organisme(integer) RETURNS record
    AS $_$declare
rec record;

begin
    select into rec id,libelle 
    from contraintes.organisme where id=$1;
    return rec;
end;$_$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_get_organisme(integer) OWNER TO pgsql;

--
-- TOC entry 7832 (class 0 OID 0)
-- Dependencies: 1140
-- Name: FUNCTION af_get_organisme(integer); Type: COMMENT; Schema: contraintes; Owner: pgsql
--

COMMENT ON FUNCTION af_get_organisme(integer) IS 'retourne lid et le libelle d''un organisme';


--
-- TOC entry 1141 (class 1255 OID 2595952)
-- Dependencies: 2983 5
-- Name: af_get_organisme_individus(integer, character varying, integer, boolean); Type: FUNCTION; Schema: contraintes; Owner: pgsql
--

CREATE FUNCTION af_get_organisme_individus(integer, character varying, integer, boolean) RETURNS SETOF record
    AS $_$-- Retourne les informations des infividus appartenant ÃÂ  l'organisme

-- Parametres :
-- 1. Identifiant de l'organisme
-- 2. ASC ou DESC = affichage dans l'ordre croissant ou decroissant
-- 3. Type : 0=tous, 1=formateurs & 2=stagiaires
-- 4. exclusif : si VRAI alors que les 'u' ou les 'f'
declare
rec record;
req varchar;
org varchar;
begin
/*
    req:='select distinct id,nom,prenom,login,password,'||$3||' from contraintes.fw_individu, contraintes.fw_individu_types IT1 ' ;
    if $4 is true then
	req:= req || ',contraintes.fw_individu_types IT2 ' ;
    end if;
    req:= req || 'where IT1.individu=id and ';
    -- multi org ?
    if $1 is null then
	req:=req || 'organisme is null ';
    else
	req:=req || 'organisme ='||$1;
    end if;
    -- suite req
    if $3=1 then -- LES FORMATEURS
	if $4 is true then -- LES FORMATEURS STRICT
	    req:=req || ' and id =IT2.individu group by IT2.individu, IT1.individu, id, IT1.type, nom,prenom , login, password having count(IT2.type)=1   ';
	end if;
	req:=req || 'and id =IT1.individu AND IT1.type=2';
    else
	if $3=2 then -- LES STAGIAIRES
	    if $4 is true then -- LES STAGIAIRES STRICT
	        req:=req || ' and id =IT2.individu group by IT2.individu, IT1.individu, id, IT1.type, login, nom,prenom , login, password having count(IT2.type)=1 '; 
	    end if;
	    req:=req || 'and id =IT1.individu AND IT1.type=1';
	else
	    if $3=0 then --LES FORMATEURS ET STAGIAIRES
		if $1 IS NULL THEN
			org:='IS NULL';
		ELSE
			org:='='||$1;
		END IF;
		if $4 is true then -- LES FORMATEURS STRICT ET STAGIAIRES STRICT
		    req:='select id,nom,prenom,login,password,'||$3||' from contraintes.fw_individu where organisme '||org||' group by fw_individu.id,nom,prenom , login, password '; 
		    raise notice 'r1=%',req ;
	    
			--req:='select individu,nom,prenom,login,password,'||$3||' from contraintes.fw_individu where organisme ='||org||' group by nom,prenom , login, password '; 
		else    
	       	    req:='select id,nom,prenom,login,password,'||$3||' from contraintes.fw_individu where organisme '||org||' group by fw_individu.id,nom,prenom , login, password '; 
		    --req:='select individu,nom,prenom,login,password,'||$3||' from contraintes.fw_individu,contraintes.fw_individu_types where individu=id and organisme '||org||' group by individu,nom,prenom , login, password having count(individu)=1'; 
			raise notice 'r2=%',req;
	        end if;
	    else
		raise exception 'la valeur pour le paramètre 3 (type) doit être 1,2 ou 0';
	    end if;
	end if;

    end if;

    -- classement
    if $2 like 'DESC' then
	req:=req || 'order by nom desc ';
    else
	req:=req || 'order by nom ';
    end if;

	raise notice 'req=%',req;
for rec in
	execute req
loop
return next rec;
end loop;
*/
-- nouvelle méthode	
    if $3 =0 then 
        if $2 like 'desc' then
	    if $1 is null then
	        for rec in 
		    select distinct id,nom,prenom,login,password,$3 from contraintes.fw_individu 
		    where organisme is null order by nom desc
	        loop
		    return next rec;
	        end loop;
	    else
		for rec in 
		    select distinct id,nom,prenom,login,password,$3 from contraintes.fw_individu 
		    where organisme =$1 order by nom desc
	        loop
		    return next rec;
	        end loop;
	    end if;	
        else
	    if $1 is null then 
	        for rec in 
		    select distinct id,nom,prenom,login,password,$3 from contraintes.fw_individu 
		    where organisme is null order by nom 
	        loop
		    return next rec;
	        end loop; 
	    else
		for rec in 
		    select distinct id,nom,prenom,login,password,$3 from contraintes.fw_individu 
		    where organisme = $1 order by nom 
	        loop
		    return next rec;
	        end loop; 
	    end if;
        end if;


    else
        if $4 is true then
	    if $2 like 'desc' then
		if $1 is null then 
		    for rec in 
		    select distinct id,nom,prenom,login,password,$3 from contraintes.fw_individu,
		    contraintes.fw_individu_types IT1,contraintes.fw_individu_types IT2 
		    where IT1.individu=id and organisme is null 
		    and id=IT2.individu group by IT2.individu,IT1.individu,id,IT1.type,nom,prenom,login,password 
		    having count(IT2.type)=1 
		    and IT1.type=$3 order by nom desc
		    loop
			return next rec;
		    end loop;
		else
		    for rec in 	
		    select distinct id,nom,prenom,login,password,$3 from contraintes.fw_individu,
		    contraintes.fw_individu_types IT1,contraintes.fw_individu_types IT2 
		    where IT1.individu=id and organisme =$1 
		    and id=IT2.individu group by IT2.individu,IT1.individu,id,IT1.type,nom,prenom,login,password 
		    having count(IT2.type)=1 
		    and IT1.type=$3 order by nom desc
		    loop
			return next rec;
		    end loop;
		end if;

	    else
		if $1 is null then 
		    for rec in 
		    select distinct id,nom,prenom,login,password,$3 from contraintes.fw_individu,
		    contraintes.fw_individu_types IT1,contraintes.fw_individu_types IT2 
		    where IT1.individu=id and organisme is null 
		    and id=IT2.individu group by IT2.individu,IT1.individu,id,IT1.type,nom,prenom,login,password 
		    having count(IT2.type)=1 
		    and IT1.type=$3 order by nom 
		    loop
			return next rec;
		    end loop;
		else
		    for rec in 	
		    select distinct id,nom,prenom,login,password,$3 from contraintes.fw_individu,
		    contraintes.fw_individu_types IT1,contraintes.fw_individu_types IT2 
		    where IT1.individu=id and organisme =$1 
		    and id=IT2.individu group by IT2.individu,IT1.individu,id,IT1.type,nom,prenom,login,password 
		    having count(IT2.type)=1 
		    and IT1.type=$3 order by nom 
		    loop
			return next rec;
		    end loop;
		end if;
	    end if;
	
        else
	    if $2 like 'desc' then
		if $1 is null then
		    for rec in 
			select distinct id,nom,prenom,login,password,$3 from contraintes.fw_individu,
			contraintes.fw_individu_types IT1 
			where IT1.individu=id  and organisme is null and IT1.type=$3 order by nom desc
		    loop
			return next rec;
		    end loop;
		else
		    for rec in 
			select distinct id,nom,prenom,login,password,$3 from contraintes.fw_individu,
			contraintes.fw_individu_types IT1 
			where IT1.individu=id and IT1.type=$3 and organisme =$1 order by nom desc
		    loop
			return next rec;
		    end loop;	
		end if;

	    else
		if $1 is null then
		    for rec in 
			select distinct id,nom,prenom,login,password,$3 from contraintes.fw_individu,
			contraintes.fw_individu_types IT1 
			where IT1.individu=id and IT1.type=$3 and organisme is null order by nom 
		    loop
			return next rec;
		    end loop;
		else
		    for rec in 
			select distinct id,nom,prenom,login,password,$3 from contraintes.fw_individu,
			contraintes.fw_individu_types IT1 
			where IT1.individu=id and IT1.type=$3 and organisme =$1 order by nom 
		    loop
			return next rec;
		    end loop;
		end if;

	    end if;

	end if;

    end if;


return ;
end;$_$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_get_organisme_individus(integer, character varying, integer, boolean) OWNER TO pgsql;

--
-- TOC entry 7834 (class 0 OID 0)
-- Dependencies: 1141
-- Name: FUNCTION af_get_organisme_individus(integer, character varying, integer, boolean); Type: COMMENT; Schema: contraintes; Owner: pgsql
--

COMMENT ON FUNCTION af_get_organisme_individus(integer, character varying, integer, boolean) IS 'retourne les individus d''un organisme';


--
-- TOC entry 1855 (class 1255 OID 2595953)
-- Dependencies: 2983 5
-- Name: af_get_organismes(); Type: FUNCTION; Schema: contraintes; Owner: pgsql
--

CREATE FUNCTION af_get_organismes() RETURNS SETOF record
    AS $$declare
rec record;
begin
    for rec in 
	select id,libelle from contraintes.organisme order by libelle
    loop
	return next rec;
    end loop;
    return;
end;$$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_get_organismes() OWNER TO pgsql;

--
-- TOC entry 7836 (class 0 OID 0)
-- Dependencies: 1855
-- Name: FUNCTION af_get_organismes(); Type: COMMENT; Schema: contraintes; Owner: pgsql
--

COMMENT ON FUNCTION af_get_organismes() IS 'retourne les organismes de la plateforme';


--
-- TOC entry 1142 (class 1255 OID 2595954)
-- Dependencies: 2983 5
-- Name: af_get_organismes_non_vide(); Type: FUNCTION; Schema: contraintes; Owner: pgsql
--

CREATE FUNCTION af_get_organismes_non_vide() RETURNS SETOF record
    AS $$declare
rec record;

begin
    for rec in 
	select distinct O_id,O_libelle from contraintes.af_get_organismes() as (O_id int4,O_libelle "varchar"),contraintes.fw_individu I 
	where O_id=I.organisme
    loop
	return next rec;
    end loop;
    return;
end;$$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_get_organismes_non_vide() OWNER TO pgsql;

--
-- TOC entry 7838 (class 0 OID 0)
-- Dependencies: 1142
-- Name: FUNCTION af_get_organismes_non_vide(); Type: COMMENT; Schema: contraintes; Owner: pgsql
--

COMMENT ON FUNCTION af_get_organismes_non_vide() IS 'retourne les organismes pour lesquels il y a des individus';


--
-- TOC entry 1143 (class 1255 OID 2595955)
-- Dependencies: 2983 5
-- Name: af_get_page_annuaire_configuration(integer, integer, integer); Type: FUNCTION; Schema: contraintes; Owner: pgsql
--

CREATE FUNCTION af_get_page_annuaire_configuration(integer, integer, integer) RETURNS SETOF record
    AS $_$-- $1 : formation
-- $2 : page
-- $3 : type individu
declare
rec record;
begin
    for rec in 
	select page_element,formation,page,individu_type
	from contraintes.page_annuaire_configuration 
	where formation=$1 and individu_type=$3
    loop
	return next rec;
    end loop;
end;$_$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_get_page_annuaire_configuration(integer, integer, integer) OWNER TO pgsql;

--
-- TOC entry 7840 (class 0 OID 0)
-- Dependencies: 1143
-- Name: FUNCTION af_get_page_annuaire_configuration(integer, integer, integer); Type: COMMENT; Schema: contraintes; Owner: pgsql
--

COMMENT ON FUNCTION af_get_page_annuaire_configuration(integer, integer, integer) IS 'retourne la configuration d''une page d''annuaire';


--
-- TOC entry 1144 (class 1255 OID 2595956)
-- Dependencies: 2983 5
-- Name: af_get_page_commentaire(integer, integer, integer); Type: FUNCTION; Schema: contraintes; Owner: pgsql
--

CREATE FUNCTION af_get_page_commentaire(integer, integer, integer) RETURNS record
    AS $_$-- $1 : page
-- $2 : formation
-- $3 : stagiaire
declare
rec record;
begin
    select into rec * from contraintes.page_commentaire 
    where page=$1 and formation=$2 and stagiaire=$3;
    return rec;
end;$_$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_get_page_commentaire(integer, integer, integer) OWNER TO pgsql;

--
-- TOC entry 7842 (class 0 OID 0)
-- Dependencies: 1144
-- Name: FUNCTION af_get_page_commentaire(integer, integer, integer); Type: COMMENT; Schema: contraintes; Owner: pgsql
--

COMMENT ON FUNCTION af_get_page_commentaire(integer, integer, integer) IS 'retourne le commentaire pour une page';


--
-- TOC entry 1145 (class 1255 OID 2595957)
-- Dependencies: 2983 5
-- Name: af_get_page_elements(); Type: FUNCTION; Schema: contraintes; Owner: pgsql
--

CREATE FUNCTION af_get_page_elements() RETURNS SETOF record
    AS $$declare
rec record;
begin
    for rec in
	select id,libelle from contraintes.page_element
    loop
	return next rec;
    end loop;
end;$$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_get_page_elements() OWNER TO pgsql;

--
-- TOC entry 7844 (class 0 OID 0)
-- Dependencies: 1145
-- Name: FUNCTION af_get_page_elements(); Type: COMMENT; Schema: contraintes; Owner: pgsql
--

COMMENT ON FUNCTION af_get_page_elements() IS 'retourne les elements (des pages) de la plateforme';


--
-- TOC entry 1146 (class 1255 OID 2595958)
-- Dependencies: 2983 5
-- Name: af_get_page_elements(integer); Type: FUNCTION; Schema: contraintes; Owner: pgsql
--

CREATE FUNCTION af_get_page_elements(integer) RETURNS SETOF record
    AS $_$-- $1 : page
declare
rec record;
begin
    for rec in
	select id,libelle,page from contraintes.af_get_page_elements() as (id int4,libelle varchar),contraintes.page_elements 
	where id=page_element and page=$1 
    loop
	return next rec;
    end loop;
end;$_$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_get_page_elements(integer) OWNER TO pgsql;

--
-- TOC entry 7846 (class 0 OID 0)
-- Dependencies: 1146
-- Name: FUNCTION af_get_page_elements(integer); Type: COMMENT; Schema: contraintes; Owner: pgsql
--

COMMENT ON FUNCTION af_get_page_elements(integer) IS 'retourne les elements pour une page';


--
-- TOC entry 1147 (class 1255 OID 2595959)
-- Dependencies: 2983 5
-- Name: af_get_page_liste(integer, integer, integer, integer); Type: FUNCTION; Schema: contraintes; Owner: pgsql
--

CREATE FUNCTION af_get_page_liste(integer, integer, integer, integer) RETURNS record
    AS $_$-- $1 : formation
-- $2 : parcours
-- $3 : liste
-- $4 : page
declare
rec record;
begin
    select into rec titre,commentaire,formation,parcours,liste,page 
    from contraintes.page_liste 
    where formation=$1 and parcours=$2 and liste=$3 and page=$4;
    return rec;
end;$_$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_get_page_liste(integer, integer, integer, integer) OWNER TO pgsql;

--
-- TOC entry 7848 (class 0 OID 0)
-- Dependencies: 1147
-- Name: FUNCTION af_get_page_liste(integer, integer, integer, integer); Type: COMMENT; Schema: contraintes; Owner: pgsql
--

COMMENT ON FUNCTION af_get_page_liste(integer, integer, integer, integer) IS 'retourne titre et commentaire d''une page de liste';


--
-- TOC entry 1148 (class 1255 OID 2595960)
-- Dependencies: 2983 5
-- Name: af_get_page_liste_configuration(integer, integer, integer, integer); Type: FUNCTION; Schema: contraintes; Owner: pgsql
--

CREATE FUNCTION af_get_page_liste_configuration(integer, integer, integer, integer) RETURNS SETOF record
    AS $_$-- $1 : formation
-- $2 : parcours
-- $3 : liste
-- $4 : page
declare
rec record;
begin
    for rec in
	select page_element,formation,parcours,liste,page
	from contraintes.page_liste_configuration 
	where formation=$1 and parcours=$2 and liste=$3 and page=$4
    loop
	return next rec;
    end loop;
end;$_$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_get_page_liste_configuration(integer, integer, integer, integer) OWNER TO pgsql;

--
-- TOC entry 7850 (class 0 OID 0)
-- Dependencies: 1148
-- Name: FUNCTION af_get_page_liste_configuration(integer, integer, integer, integer); Type: COMMENT; Schema: contraintes; Owner: pgsql
--

COMMENT ON FUNCTION af_get_page_liste_configuration(integer, integer, integer, integer) IS 'retourne la configuration d''une page de liste';


--
-- TOC entry 1149 (class 1255 OID 2595961)
-- Dependencies: 2983 5
-- Name: af_get_page_ressource_configuration(integer, integer, integer, integer); Type: FUNCTION; Schema: contraintes; Owner: pgsql
--

CREATE FUNCTION af_get_page_ressource_configuration(integer, integer, integer, integer) RETURNS record
    AS $_$-- $1 : formation
-- $2 : page
-- $3 : parcours
-- $4 : etape_ressource
declare
rec record;
begin
    select into rec formation,page,parcours,etape_ressource,commentaire  
    from contraintes.page_ressource_configuration
    where formation=$1 and page=$2 and parcours=$3 and etape_ressource=$4;
    return rec;
end;$_$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_get_page_ressource_configuration(integer, integer, integer, integer) OWNER TO pgsql;

--
-- TOC entry 7852 (class 0 OID 0)
-- Dependencies: 1149
-- Name: FUNCTION af_get_page_ressource_configuration(integer, integer, integer, integer); Type: COMMENT; Schema: contraintes; Owner: pgsql
--

COMMENT ON FUNCTION af_get_page_ressource_configuration(integer, integer, integer, integer) IS 'retourne la configuration d''une page de ressource';


--
-- TOC entry 1150 (class 1255 OID 2595962)
-- Dependencies: 2983 5
-- Name: af_get_page_type_pages(integer); Type: FUNCTION; Schema: contraintes; Owner: pgsql
--

CREATE FUNCTION af_get_page_type_pages(integer) RETURNS SETOF record
    AS $_$-- $1 : type de page
declare
rec record;
begin
    for rec in
	select * from contraintes.page where type=$1
    loop
	return next rec;
    end loop;
end;$_$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_get_page_type_pages(integer) OWNER TO pgsql;

--
-- TOC entry 7854 (class 0 OID 0)
-- Dependencies: 1150
-- Name: FUNCTION af_get_page_type_pages(integer); Type: COMMENT; Schema: contraintes; Owner: pgsql
--

COMMENT ON FUNCTION af_get_page_type_pages(integer) IS 'retourne les page d''un type de page';


--
-- TOC entry 1151 (class 1255 OID 2595963)
-- Dependencies: 2983 5
-- Name: af_get_pages_types(); Type: FUNCTION; Schema: contraintes; Owner: pgsql
--

CREATE FUNCTION af_get_pages_types() RETURNS SETOF record
    AS $$declare
rec record;
begin
    for rec in 
	select id,libelle,code from contraintes.page_type
    loop
	return next rec;
    end loop;
end;$$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_get_pages_types() OWNER TO pgsql;

--
-- TOC entry 7856 (class 0 OID 0)
-- Dependencies: 1151
-- Name: FUNCTION af_get_pages_types(); Type: COMMENT; Schema: contraintes; Owner: pgsql
--

COMMENT ON FUNCTION af_get_pages_types() IS 'retourne les types de page de la plateforme';


--
-- TOC entry 1152 (class 1255 OID 2595964)
-- Dependencies: 2983 5
-- Name: af_get_parcours(); Type: FUNCTION; Schema: contraintes; Owner: pgsql
--

CREATE FUNCTION af_get_parcours() RETURNS SETOF record
    AS $$DECLARE
rec RECORD;
BEGIN
	FOR rec IN
		SELECT E.id, E.libelle, P.filiere, P.duree, E.date_creation  FROM contraintes.etape E 
		, contraintes.parcours P  
		WHERE P.id = E.id
	LOOP
		RETURN NEXT rec;
	END LOOP;
	RETURN;
END;$$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_get_parcours() OWNER TO pgsql;

--
-- TOC entry 1153 (class 1255 OID 2595965)
-- Dependencies: 2983 5
-- Name: af_get_parcours(integer); Type: FUNCTION; Schema: contraintes; Owner: pgsql
--

CREATE FUNCTION af_get_parcours(integer) RETURNS record
    AS $_$DECLARE
--$1 parcours
rec RECORD;
BEGIN
	IF $1 IS NULL THEN
		RETURN NULL;
	END IF;

	SELECT INTO rec  E.id, E.libelle, P.filiere, P.duree, E.date_creation  FROM contraintes.etape E 
	LEFT OUTER JOIN contraintes.parcours P  
	ON (P.id=E.id)
	WHERE E.id=$1;
	
	/*SELECT INTO rec * FROM contraintes.af_get_parcours() AS (id int4, libelle varchar, filiere int4, duree bool, date_creation timestamp) 
	WHERE id=$1;*/

	RETURN rec;
END;$_$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_get_parcours(integer) OWNER TO pgsql;

--
-- TOC entry 1856 (class 1255 OID 2595966)
-- Dependencies: 2983 5
-- Name: af_get_parcours_all_formations(integer); Type: FUNCTION; Schema: contraintes; Owner: pgsql
--

CREATE FUNCTION af_get_parcours_all_formations(integer) RETURNS SETOF record
    AS $_$DECLARE
--$1 parcours
rec record;
rec1 RECORD;
rec2 RECORD;
rec3 RECORD;
rec4 RECORD;
id_pere int4;
parcours_pere integer;
nb_formations int4;
BEGIN
	--raise notice 'parc=%',$1;
    FOR rec1 IN
	--selectionne la formation
	SELECT * FROM contraintes.af_get_formations() AS (id int4, libelle varchar, parcours int4, date_debut date, date_fin date, langue_defaut int4,ressources_fusionnees boolean)
	WHERE parcours=$1
    LOOP
	RETURN NEXT rec1;
	
    END LOOP;

    -- boucle sur les peres du parcours
    for rec in
	select pere from contraintes.af_get_parcours_parcours_pere($1) pere
    loop
	--raise notice 'pere=%',rec.pere;
	for rec2 in
	    SELECT * FROM contraintes.af_get_parcours_all_formations(rec.pere) AS (id int4, libelle varchar, parcours int4, date_debut date, date_fin date, langue_defaut int4,ressources_fusionnees boolean)
	loop
	    return next rec2;
	end loop;
    end loop;

    -- boucle sur les parcours orientes ayant le parcours comme sous_parcours

    for rec4 in 
	select distinct parcours from contraintes.af_get_parcourss_orientes() 
	as(parcours integer,sous_parcours integer) 
	where sous_parcours=$1
    loop
	raise notice 'parcours=%',rec4.parcours;
	for rec3 in
	    SELECT * FROM contraintes.af_get_parcours_all_formations(rec4.parcours) AS (id int4, libelle varchar, parcours int4, date_debut date, date_fin date, langue_defaut int4,ressources_fusionnees boolean)
	loop
	    return next rec3;
	end loop;

    end loop;

    
		

	RETURN;
END$_$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_get_parcours_all_formations(integer) OWNER TO pgsql;

--
-- TOC entry 7860 (class 0 OID 0)
-- Dependencies: 1856
-- Name: FUNCTION af_get_parcours_all_formations(integer); Type: COMMENT; Schema: contraintes; Owner: pgsql
--

COMMENT ON FUNCTION af_get_parcours_all_formations(integer) IS 'Obtenir les formations qui utilisent un parcours';


--
-- TOC entry 1154 (class 1255 OID 2595967)
-- Dependencies: 2983 5
-- Name: af_get_parcours_avancement(integer); Type: FUNCTION; Schema: contraintes; Owner: pgsql
--

CREATE FUNCTION af_get_parcours_avancement(integer) RETURNS SETOF record
    AS $_$DECLARE
--$1 parcours
rec RECORD;
BEGIN

	FOR rec IN
		SELECT e_parcours, e_id, A.formation, A.stagiaire, type
		FROM contraintes.af_get_parcours_etapes($1) 
		AS (e_id int4, libelle_alias varchar, libelle varchar, libelle_type_etape  varchar, type varchar,  pere int4, e_parcours int4, obligatoire bool, chrono int4, fin bool, libelle_type_original varchar,modifiable bool)
		LEFT OUTER JOIN contraintes.resultat  A
		ON(etape=e_id AND e_parcours=A.parcours)
		WHERE e_parcours=$1
	LOOP
		RETURN NEXT rec;
	END LOOP;

	RETURN;
END;$_$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_get_parcours_avancement(integer) OWNER TO pgsql;

--
-- TOC entry 1155 (class 1255 OID 2595968)
-- Dependencies: 2983 5
-- Name: af_get_parcours_avancement_max(integer); Type: FUNCTION; Schema: contraintes; Owner: pgsql
--

CREATE FUNCTION af_get_parcours_avancement_max(integer) RETURNS record
    AS $_$DECLARE
--$1 parcours
rec RECORD;
rec_etape RECORD;
etape_prec int4:=NULL;
BEGIN
	FOR rec IN 
		--on recupere l'avancement du parcours
		SELECT * FROM contraintes.af_get_parcours_avancement($1) AS (parcours int4, etape int4, formation int4, stagiaire int4 , type varchar)
	LOOP
		--cas pour la premiere etape
		IF etape_prec IS NULL THEN
			etape_prec:=rec.etape;
		ELSE
		
			--on suppose que si l'etape n'a pas encore été faite, etape_prec contient la derniere etape faite
			IF rec.formation IS NULL THEN
				--on recupere donc les informations de etape_prec
				SELECT INTO rec_etape * FROM contraintes.af_get_parcours_etape($1, etape_prec)  AS (id int4, libelle_alias varchar, libelle varchar, libelle_type_etape  varchar, type varchar,  pere int4, parcours int4, obligatoire bool, chrono int4, fin bool, libelle_type_original varchar);
				
				--si etape_prec est une etape obligatoire, il s'agit bien de la derniere etape faite
				IF rec_etape.obligatoire IS TRUE THEN
					--on la renvoie donc, sinon on continu a chercher	
					RETURN rec_etape;
				END IF;
			END IF;
			etape_prec:=rec.etape;
		END IF;

	END LOOP;

	RETURN NULL;
END;$_$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_get_parcours_avancement_max(integer) OWNER TO pgsql;

--
-- TOC entry 1156 (class 1255 OID 2595969)
-- Dependencies: 2983 5
-- Name: af_get_parcours_chats_disponibles(integer); Type: FUNCTION; Schema: contraintes; Owner: pgsql
--

CREATE FUNCTION af_get_parcours_chats_disponibles(integer) RETURNS SETOF record
    AS $_$-- $1 : parcours
declare
rec record;
begin
    for rec in
	select ef_id,ef_libelle_etape from contraintes.af_get_etapes_chats() 
	as 
	(ef_id int4,ef_libelle_etape varchar,type int4,date_creation timestamp)
	left outer join contraintes.af_gen_get_elements('contraintes.parcours_etapes', 'etape', NULL, 'AND parcours='||$1,1) elt 
	on (elt.id=ef_id) 
	where elt.id is null
    loop
	return next rec;
    end loop;
end;$_$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_get_parcours_chats_disponibles(integer) OWNER TO pgsql;

--
-- TOC entry 7864 (class 0 OID 0)
-- Dependencies: 1156
-- Name: FUNCTION af_get_parcours_chats_disponibles(integer); Type: COMMENT; Schema: contraintes; Owner: pgsql
--

COMMENT ON FUNCTION af_get_parcours_chats_disponibles(integer) IS 'retourne les chats disponible pour un parcours';


--
-- TOC entry 1157 (class 1255 OID 2595970)
-- Dependencies: 2983 5
-- Name: af_get_parcours_etape(integer, integer); Type: FUNCTION; Schema: contraintes; Owner: pgsql
--

CREATE FUNCTION af_get_parcours_etape(integer, integer) RETURNS record
    AS $_$DECLARE
--$1 parcours
--$2 etape
rec RECORD;
BEGIN
	SELECT INTO rec PE.etape, E.libelle, E.libelle, PE.libelle_type_etape, CAST(E.type AS varchar),  PE.pere, PE.parcours, PE.obligatoire, PE.chrono, PE.fin, T.libelle 
	FROM contraintes.parcours_etapes PE, contraintes.etape E, contraintes.etape_type T
	WHERE PE.etape=$2 AND PE.etape=E.id
	AND E.type=T.id
	AND PE.parcours=$1;

	RETURN rec;
END$_$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_get_parcours_etape(integer, integer) OWNER TO pgsql;

--
-- TOC entry 1158 (class 1255 OID 2595971)
-- Dependencies: 2983 5
-- Name: af_get_parcours_etape_fille(integer, integer); Type: FUNCTION; Schema: contraintes; Owner: pgsql
--

CREATE FUNCTION af_get_parcours_etape_fille(integer, integer) RETURNS record
    AS $_$DECLARE
--$1 parcours
--$2 identifiant de l'etape père
rec RECORD;
BEGIN
	IF $2 IS NOT NULL THEN
		SELECT INTO rec * FROM contraintes.af_get_parcours_etapes($1)
		AS (id int4, libelle_alias varchar, libelle varchar, libelle_type_etape varchar, type varchar, pere int4, parcours int4, obligatoire bool, chrono int4, fin bool, libelle_type_original varchar, modifiable bool)
		WHERE pere=$2;
	ELSE
		SELECT INTO rec * FROM contraintes.af_get_parcours_etapes($1)
		AS (id int4, libelle_alias varchar, libelle varchar, libelle_type_etape varchar, type varchar, pere int4, parcours int4, obligatoire bool, chrono int4, fin bool, libelle_type_original varchar, modifiable bool)
		WHERE pere IS NULL;
	END IF;

	RETURN rec;
END;$_$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_get_parcours_etape_fille(integer, integer) OWNER TO pgsql;

--
-- TOC entry 1159 (class 1255 OID 2595972)
-- Dependencies: 2983 5
-- Name: af_get_parcours_etape_parcours_oriente_parcourss_disponibles(integer); Type: FUNCTION; Schema: contraintes; Owner: pgsql
--

CREATE FUNCTION af_get_parcours_etape_parcours_oriente_parcourss_disponibles(integer) RETURNS SETOF record
    AS $_$DECLARE
--$1 numéro du parcours
/*filiere_id int4;
niveau int4;*/
ss_parcours RECORD;
BEGIN
	FOR ss_parcours IN
		SELECT * FROM contraintes.af_get_parcours_sous_parcourss_disponibles($1) 
		AS  (id int4, libelle varchar, filiere int4, duree bool, date_creation timestamp, indice integer)
	LOOP
		RETURN NEXT ss_parcours;
	END LOOP;

	RETURN;
	/*--selection de la filiere du parcours
	SELECT INTO filiere_id filiere FROM contraintes.parcours
	WHERE id =$1;

	--selection du niveau de la filiere
	SELECT INTO niveau * FROM contraintes.af_gen_get_element_niveau('contraintes.filiere','id', filiere_id, '',0);
	RAISE NOTICE 'filiere parcours: % niveau parcours=%',filiere_id,niveau;
	
	--selection des sous parcours disponibles pour le parcours
	FOR ss_parcours IN
		SELECT P_id, P_libelle, P_filiere, P_duree, P_date_creation,F_indice FROM contraintes.af_get_filieres()AS (F_id int4, F_libelle varchar, F_pere int4, F_indice int4),
		contraintes.af_get_parcours()AS (P_id integer, P_libelle varchar, P_filiere int4 , P_duree bool, P_date_creation timestamp)
		WHERE F_indice=(niveau+1)
		AND P_filiere=F_id
	LOOP
		RETURN NEXT ss_parcours;
	END LOOP;

	RETURN;*/
END;$_$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_get_parcours_etape_parcours_oriente_parcourss_disponibles(integer) OWNER TO pgsql;

--
-- TOC entry 1160 (class 1255 OID 2595973)
-- Dependencies: 2983 5
-- Name: af_get_parcours_etape_resultats(integer, integer); Type: FUNCTION; Schema: contraintes; Owner: pgsql
--

CREATE FUNCTION af_get_parcours_etape_resultats(integer, integer) RETURNS SETOF record
    AS $_$DECLARE
rec RECORD;
BEGIN
	FOR rec IN
		SELECT id, formation, stagiaire, parcours,  etape, date_debut, duree
		FROM contraintes.resultat
		WHERE parcours=$1 and etape=$2
	LOOP 
		RETURN NEXT rec;
	END LOOP;

	RETURN;
END;$_$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_get_parcours_etape_resultats(integer, integer) OWNER TO pgsql;

--
-- TOC entry 1161 (class 1255 OID 2595974)
-- Dependencies: 2983 5
-- Name: af_get_parcours_etapes(integer); Type: FUNCTION; Schema: contraintes; Owner: pgsql
--

CREATE FUNCTION af_get_parcours_etapes(integer) RETURNS SETOF record
    AS $_$DECLARE 
--$1 parcours
rec RECORD;
modif bool;
sous_type contraintes.type_element;
BEGIN
	FOR rec IN
		SELECT PE.etape, E.libelle, E.libelle, PE.libelle_type_etape, CAST(E.type AS varchar) AS type,  PE.pere, PE.parcours, PE.obligatoire, PE.chrono, PE.fin, T.libelle AS libelle_type_original, CAST(NULL AS bool) AS modifiable
		FROM contraintes.af_gen_get_elements('contraintes.parcours_etapes', 'etape', NULL, 'AND parcours='||$1,1) elt, contraintes.parcours_etapes PE, contraintes.etape E, contraintes.etape_type T
		WHERE elt.id=PE.etape AND PE.etape=E.id
		AND E.type=T.id
		AND PE.parcours=$1
		ORDER BY elt.ind
	LOOP
		--Cas speciaux: les types ayant des sous types
		SELECT INTO sous_type * FROM contraintes.af_get_etape_type_sous_type(rec.etape, CAST(rec.type AS int4), rec.libelle_type_original);
		rec.type:=sous_type.id;
		rec.libelle_type_original:=sous_type.libelle;

		--l'etape est elle modifiable?
		SELECT INTO modif * FROM contraintes.af_is_parcours_etape_modifiable($1, rec.etape, rec.type);
		rec.modifiable:=modif;

		--les series générées par les test
		IF rec.type='4_1_4' THEN

		END IF;

		RETURN NEXT rec;
	END LOOP;

	/*----------------------------------
	--      ETAPES SANS THEMES      --
	----------------------------------

	--les types d'étapes spéciales: forum (2), chat(8) et etape titre(9)
	FOR rec_spe IN 
		SELECT CAST(NULL AS int4) AS id,  CAST(NULL AS varchar) AS  libelle,CAST(NULL AS varchar) AS  libelle2,CAST(id AS varchar) AS type, libelle  AS libelle_type
		FROM contraintes.etape_type T
		WHERE id IN (2,8,9)
	LOOP
		RETURN NEXT rec_spe;
	END LOOP;

	FOR rec_ss_parcours IN 
		SELECT P_id,  P_libelle, P_libelle, CAST('1' AS varchar) AS type, libelle  AS libelle_type
		FROM contraintes.af_get_parcours_sous_parcourss_disponibles(num_parcours) AS (P_id int4, P_libelle varchar, filiere int4, duree bool),
		contraintes.etape_type T
		WHERE 1=T.id
	LOOP
		RETURN NEXT rec_ss_parcours;
	END LOOP;*/

	RETURN;
END;$_$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_get_parcours_etapes(integer) OWNER TO pgsql;

--
-- TOC entry 1162 (class 1255 OID 2595975)
-- Dependencies: 2983 5
-- Name: af_get_parcours_etapes_deroulees(integer); Type: FUNCTION; Schema: contraintes; Owner: pgsql
--

CREATE FUNCTION af_get_parcours_etapes_deroulees(integer) RETURNS SETOF record
    AS $_$DECLARE 
--$1 parcours
rec RECORD;
rec_p RECORD;
BEGIN
	--recup des etapes du parcours
	FOR rec IN
		SELECT * FROM contraintes.af_get_parcours_etapes($1) AS (id int4, libelle_alias varchar, libelle varchar, libelle_type_etape  varchar, type varchar,  pere int4, parcours int4, obligatoire bool, chrono int4, fin bool, libelle_type_original varchar, modifiable bool)
		--SELECT PE.etape AS id_etape, E.libelle, E.libelle, E.type,  PE.pere, PE.parcours, PE.obligatoire, PE.chrono, PE.fin 
		--FROM contraintes.af_gen_get_elements('contraintes.parcours_etapes', 'etape', NULL, 'AND parcours='||$1) P_ID, contraintes.parcours_etapes PE, contraintes.etape E
		--WHERE P_ID=PE.etape AND PE.etape=E.id and PE.parcours=$1
	LOOP
		--Si etape de type parcours attaché, on recuperes ses etapes par recursivite
		IF rec.type='1' THEN
			FOR rec_p IN
				SELECT * FROM contraintes.af_get_parcours_etapes_deroulees(rec.id) AS (id int4, libelle_alias varchar, libelle varchar, libelle_type_etape  varchar, type varchar,  pere int4, parcours int4, obligatoire bool, chrono int4, fin bool, libelle_type_original varchar, modifiable bool)
			LOOP
				RETURN NEXT rec_p;
			END LOOP;
		ELSE
			RETURN NEXT rec;
		END IF;
	END LOOP;

	RETURN;
END;$_$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_get_parcours_etapes_deroulees(integer) OWNER TO pgsql;

--
-- TOC entry 1857 (class 1255 OID 2595976)
-- Dependencies: 2983 5
-- Name: af_get_parcours_etapes_deroulees_formation_individu(integer, integer, integer); Type: FUNCTION; Schema: contraintes; Owner: pgsql
--

CREATE FUNCTION af_get_parcours_etapes_deroulees_formation_individu(integer, integer, integer) RETURNS SETOF record
    AS $_$DECLARE 
--$1 formation
--$2 individu
--$3 parcours
rec RECORD;
rec_resultat record;
rec_p RECORD;
sous_parcours integer;
indice integer;
BEGIN
    --recup des etapes du parcours
    FOR rec IN
	SELECT * FROM contraintes.af_get_parcours_etapes($3) 
	AS (id int4, libelle_alias varchar, libelle varchar, libelle_type_etape  varchar, type varchar,  pere int4, parcours int4, obligatoire bool, chrono int4, fin bool, libelle_type_original varchar, modifiable bool)
    LOOP
	--Si etape de type parcours attaché, on recuperes ses etapes par recursivite
	IF rec.type='1' THEN
	    FOR rec_p IN
		SELECT * FROM contraintes.af_get_parcours_etapes_deroulees_formation_individu($1,$2,rec.id) 
		AS (id int4, libelle_alias varchar, libelle varchar, libelle_type_etape  varchar, type varchar,  pere int4, parcours int4, obligatoire bool, chrono int4, fin bool, libelle_type_original varchar, modifiable bool)
	    LOOP
		RETURN NEXT rec_p;
	    END LOOP;
	ELSE
	    RETURN NEXT rec;
	    -- si etape parcours oriente
	    if rec.type='10' then
		-- test si l'etape a été faite
		select into rec_resultat * from contraintes.af_get_resultat($1,$2,$3,rec.id) 
		as (id bigint,formation int4, stagiaire int4, parcours int4, etape int4, date_debut timestamp, duree interval);
		if rec_resultat.id is not null then
		    -- recup sous-parcours 
		    select into sous_parcours * from contraintes.af_get_resultat_parcours_parcours_oriente(rec_resultat.id);
		    for rec_p in 
			--SELECT *,indice AS indic FROM contraintes.af_get_parcours_etapes_deroulees_formation_individu($1,$2,sous_parcours) AS (id int4, libelle_alias varchar, libelle varchar, libelle_type_etape  varchar, type varchar,  pere int4, parcours int4, obligatoire bool, chrono int4, fin bool, libelle_type_original varchar, modifiable bool)
			SELECT * FROM contraintes.af_get_parcours_etapes_deroulees_formation_individu($1,$2,sous_parcours) AS (id int4, libelle_alias varchar, libelle varchar, libelle_type_etape  varchar, type varchar,  pere int4, parcours int4, obligatoire bool, chrono int4, fin bool, libelle_type_original varchar, modifiable bool)
		
		    loop
			    --rec_p.indic:=indice;
			RETURN NEXT rec_p;
			    --indice:=indice+1;
		    end loop;
		end if;
	    --end if;--else
	    end if;
	END IF;
    END LOOP;
    RETURN;
END;$_$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_get_parcours_etapes_deroulees_formation_individu(integer, integer, integer) OWNER TO pgsql;

--
-- TOC entry 7872 (class 0 OID 0)
-- Dependencies: 1857
-- Name: FUNCTION af_get_parcours_etapes_deroulees_formation_individu(integer, integer, integer); Type: COMMENT; Schema: contraintes; Owner: pgsql
--

COMMENT ON FUNCTION af_get_parcours_etapes_deroulees_formation_individu(integer, integer, integer) IS 'deroule les etapes d''un parcours pour un individu y compris les etapes de sous-parcours issus d''etape parcours oriente
(suivant les resultats de l''individu)';


--
-- TOC entry 1163 (class 1255 OID 2595977)
-- Dependencies: 2983 5
-- Name: af_get_parcours_etapes_disponibles_theme(integer, integer); Type: FUNCTION; Schema: contraintes; Owner: pgsql
--

CREATE FUNCTION af_get_parcours_etapes_disponibles_theme(integer, integer) RETURNS SETOF record
    AS $_$DECLARE
--$1 parcours
--$2 theme
rec RECORD;
rec_spe RECORD;
rec_ss_parcours RECORD;
num_parcours int4;
nb_serie_generee int4;
sous_type contraintes.type_element;
BEGIN
	num_parcours:=$1;
	--IF num_parcours IS NULL THEN
	--	num_parcours:=0;
	--END IF;

	--on recupere tous les elements de la categorie etape, avec les type_d'etapes
	FOR rec IN 
		SELECT I_D AS id,  E.libelle AS libelle, CAST(E.type AS varchar) AS type, T.libelle  AS libelle_type
		FROM (contraintes.etape E 
		LEFT OUTER JOIN contraintes.parcours_etapes P
		ON E.id=P.etape AND P.parcours=num_parcours) 
		LEFT OUTER JOIN contraintes.af_get_categorie_elements_theme(29 ,$2) I_D
		ON E.id=I_D,contraintes.etape_type T
		WHERE P.etape IS NULL
		AND I_D IS NOT NULL
		AND E.type=T.id
		AND E.type!=10
		ORDER BY T.ordre

	LOOP
		--Cas speciaux: les types ayant des sous types
		SELECT INTO sous_type * FROM contraintes.af_get_etape_type_sous_type(rec.id, CAST(rec.type AS int4), rec.libelle_type)
		ORDER BY sous_type.id;
		rec.type:=sous_type.id;
		rec.libelle_type:=sous_type.libelle;

		--cas des séries générées par les test de positionnement
		IF FALSE AND rec.type='4_1_4' THEN
			SELECT INTO nb_serie_generee COUNT(*) FROM (
				--recup de toutes les séries générées par les test dynamiques du parcours
				SELECT P.serie_aleatoire FROM contraintes.af_get_parcours_etapes_type($1, '4_3') AS (PE_id int4, libelle_alias varchar, libelle varchar, libelle_type_etape  varchar, type varchar,  pere int4, parcours int4, obligatoire bool, chrono int4, fin bool, libelle_type_original varchar, modifiable bool, indice int4),
				contraintes.test T, contraintes.test_positionnements TP, contraintes.positionnement P
				WHERE PE_id=T.id
				AND T.dynamique IS TRUE
				AND T.id=TP.test
				AND P.id=TP.positionnement
			) as series_aleatoires
			--recup des séries générées déjà dans le parcours
			LEFT OUTER JOIN contraintes.af_get_parcours_etapes_type($1, '4_1_4') AS (series_aleatoire_id int4, libelle_alias varchar, libelle varchar, libelle_type_etape  varchar, type varchar,  pere int4, parcours int4, obligatoire bool, chrono int4, fin bool, libelle_type_original varchar, modifiable bool, indice int4)
			ON (series_aleatoire_id=series_aleatoires.serie_aleatoire)
			WHERE series_aleatoire_id IS NULL
			AND series_aleatoires.serie_aleatoire=rec.id;
			
			IF nb_serie_generee>0 THEN
				RETURN NEXT rec;
			END IF;
		ELSE
			RETURN NEXT rec;
		END IF;
	END LOOP;
	
	----------------------------------
	--      ETAPES SANS THEMES      --
	----------------------------------

	--les types d'étapes spéciales: forum (2), chat(8) et etape titre(9)
	FOR rec_spe IN 
		SELECT CAST(NULL AS int4) AS id,  CAST(NULL AS varchar) AS  libelle, CAST(9 AS varchar) AS type, libelle  AS libelle_type
		FROM contraintes.etape_type T
		WHERE T.id=9
	LOOP
		RETURN NEXT rec_spe;
	END LOOP;

	--les types d'étapes forum (2)
	
	FOR rec_spe IN 
		SELECT P_id,  P_libelle, cast('2' as varchar), T.libelle  AS libelle_type
		FROM contraintes.etape_type T,contraintes.af_get_parcours_forums_disponibles(num_parcours) AS (P_id int4, P_libelle varchar)
		WHERE T.id=2 
	LOOP
		RETURN NEXT rec_spe;
	END LOOP;

	-- type chat
	FOR rec_spe IN 
		SELECT P_id,  P_libelle, cast('8' as varchar), T.libelle  AS libelle_type
		FROM contraintes.etape_type T,contraintes.af_get_parcours_chats_disponibles(num_parcours) AS (P_id int4, P_libelle varchar)
		WHERE T.id=8 
	LOOP
		RETURN NEXT rec_spe;
	END LOOP;

	

	--les sous parcours
	FOR rec_ss_parcours IN 
		SELECT P_id,  P_libelle, CAST('1' AS varchar) AS type, libelle  AS libelle_type
		FROM contraintes.af_get_parcours_sous_parcourss_disponibles(num_parcours) AS (P_id int4, P_libelle varchar, P_filiere int4, P_duree bool, P_date_creation timestamp, P_indice integer),
		contraintes.etape_type T
		WHERE 1=T.id
	LOOP
		RETURN NEXT rec_ss_parcours;
	END LOOP;

	RETURN;
END;$_$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_get_parcours_etapes_disponibles_theme(integer, integer) OWNER TO pgsql;

--
-- TOC entry 1858 (class 1255 OID 2595978)
-- Dependencies: 2983 5
-- Name: af_get_parcours_etapes_duree_type(integer, character varying); Type: FUNCTION; Schema: contraintes; Owner: pgsql
--

CREATE FUNCTION af_get_parcours_etapes_duree_type(integer, character varying) RETURNS integer
    AS $_$DECLARE
--$1 parcours
--$2 type
rec RECORD;
somme int4;
BEGIN
	SELECT INTO somme SUM(chrono)
	FROM contraintes.af_get_parcours_etapes($1)AS (id int4, libelle_alias varchar, libelle varchar, libelle_type_etape  varchar, type varchar,  pere int4, parcours int4, obligatoire bool, chrono int4, fin bool, libelle_type_original varchar, modifiable bool)
	WHERE type NOT LIKE '4_1_4%'
	AND type LIKE $2||'%';
	
	RETURN somme;
	
END;$_$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_get_parcours_etapes_duree_type(integer, character varying) OWNER TO pgsql;

--
-- TOC entry 1164 (class 1255 OID 2595979)
-- Dependencies: 2983 5
-- Name: af_get_parcours_etapes_durees_type(integer, character varying); Type: FUNCTION; Schema: contraintes; Owner: pgsql
--

CREATE FUNCTION af_get_parcours_etapes_durees_type(integer, character varying) RETURNS SETOF integer
    AS $_$DECLARE
--$1 parcours
--$2 type
rec RECORD;
somme int4;
BEGIN
	FOR rec IN
		SELECT DISTINCT chrono
		FROM contraintes.af_get_parcours_etapes($1)AS (id int4, libelle_alias varchar, libelle varchar, libelle_type_etape  varchar, type varchar,  pere int4, parcours int4, obligatoire bool, chrono int4, fin bool, libelle_type_original varchar, modifiable bool)
		WHERE type NOT LIKE '4_1_4%'
		AND chrono IS NOT NULL
		AND type LIKE $2||'%'
	LOOP
		RETURN NEXT rec.chrono;
	END LOOP;
	
	RETURN;
	
END;$_$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_get_parcours_etapes_durees_type(integer, character varying) OWNER TO pgsql;

--
-- TOC entry 1165 (class 1255 OID 2595980)
-- Dependencies: 2983 5
-- Name: af_get_parcours_etapes_durees_type_distincts(integer, character varying); Type: FUNCTION; Schema: contraintes; Owner: pgsql
--

CREATE FUNCTION af_get_parcours_etapes_durees_type_distincts(integer, character varying) RETURNS SETOF integer
    AS $_$DECLARE
--$1 parcours
--$2 type
rec RECORD;
somme int4;
BEGIN
	FOR rec IN
		SELECT DISTINCT chrono
		FROM contraintes.af_get_parcours_etapes($1)AS (id int4, libelle_alias varchar, libelle varchar, libelle_type_etape  varchar, type varchar,  pere int4, parcours int4, obligatoire bool, chrono int4, fin bool, libelle_type_original varchar, modifiable bool)
		WHERE type NOT LIKE '4_1_4%'
		AND type LIKE $2||'%'
	LOOP
		RETURN NEXT rec.chrono;
	END LOOP;
	
	RETURN;
	
END;$_$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_get_parcours_etapes_durees_type_distincts(integer, character varying) OWNER TO pgsql;

--
-- TOC entry 1166 (class 1255 OID 2595981)
-- Dependencies: 2983 5
-- Name: af_get_parcours_etapes_durees_valuees(integer); Type: FUNCTION; Schema: contraintes; Owner: pgsql
--

CREATE FUNCTION af_get_parcours_etapes_durees_valuees(integer) RETURNS SETOF integer
    AS $_$DECLARE
--$1 parcours
rec RECORD;
BEGIN
	FOR rec IN
		SELECT chrono 
		FROM contraintes.parcours_etapes P--, contraintes.etape E
		WHERE chrono IS NOT NULL
		AND parcours=$1
		/*WHERE P.etape=E.id 
		AND P.parcours=$1
		AND E.type !=6
		AND E.type !=2
		AND E.type !=8
		AND E.type !=7
		AND E.type !=5*/
	LOOP
		RETURN NEXT rec.chrono;
	END LOOP;
END;$_$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_get_parcours_etapes_durees_valuees(integer) OWNER TO pgsql;

--
-- TOC entry 1167 (class 1255 OID 2595982)
-- Dependencies: 2983 5
-- Name: af_get_parcours_etapes_type(integer, character varying); Type: FUNCTION; Schema: contraintes; Owner: pgsql
--

CREATE FUNCTION af_get_parcours_etapes_type(integer, character varying) RETURNS SETOF record
    AS $_$declare
--$1 parcours
--$2 type d'étape
rec record;
indice int4;

begin
    indice:=0;
    for rec in
	SELECT id , libelle_alias, libelle , libelle_type_etape  , type ,  pere , parcours , obligatoire , chrono , fin , libelle_type_original , modifiable , CAST(NULL AS int4) AS ind
	FROM contraintes.af_get_parcours_etapes($1) 
	AS  (id int4, libelle_alias varchar, libelle varchar, libelle_type_etape  varchar, type varchar,  pere int4, parcours int4, obligatoire bool, chrono int4, fin bool, libelle_type_original varchar, modifiable bool)
    loop
	indice :=indice + 1;
	if(rec.type like $2||'%') then
	     rec.ind:=indice;	
	    return next rec;
	end if;
    end loop;
end;$_$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_get_parcours_etapes_type(integer, character varying) OWNER TO pgsql;

--
-- TOC entry 1168 (class 1255 OID 2595983)
-- Dependencies: 2983 5
-- Name: af_get_parcours_formations(integer); Type: FUNCTION; Schema: contraintes; Owner: pgsql
--

CREATE FUNCTION af_get_parcours_formations(integer) RETURNS SETOF record
    AS $_$-- $1 : parcours
declare
rec record;
begin
    for rec in
	SELECT * FROM contraintes.af_get_formations() AS (id int4, libelle varchar, parcours int4, date_debut date, date_fin date, langue_defaut int4,ressources_fusionnees boolean)
	WHERE parcours=$1
    loop
	return next rec;
    end loop;

end;
$_$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_get_parcours_formations(integer) OWNER TO pgsql;

--
-- TOC entry 7880 (class 0 OID 0)
-- Dependencies: 1168
-- Name: FUNCTION af_get_parcours_formations(integer); Type: COMMENT; Schema: contraintes; Owner: pgsql
--

COMMENT ON FUNCTION af_get_parcours_formations(integer) IS 'retourne les formations dont le parcours est principal';


--
-- TOC entry 1169 (class 1255 OID 2595984)
-- Dependencies: 2983 5
-- Name: af_get_parcours_forums_disponibles(integer); Type: FUNCTION; Schema: contraintes; Owner: pgsql
--

CREATE FUNCTION af_get_parcours_forums_disponibles(integer) RETURNS SETOF record
    AS $_$-- $1 : parcours
declare
rec record;
begin
    for rec in
	select ef_id,ef_libelle_etape from contraintes.af_get_etapes_forum() 
	as 
	(ef_id int4,ef_libelle_etape varchar,forum int4,libelle varchar,description varchar,moderation bool,moderateur_pwd varchar,fils int4,messages int4,upload bool,theme varchar,configuration int4,date_creation timestamp)
	left outer join contraintes.af_gen_get_elements('contraintes.parcours_etapes', 'etape', NULL, 'AND parcours='||$1,1) elt 
	on (elt.id=ef_id) 
	where elt.id is null
    loop
	return next rec;
    end loop;
end;$_$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_get_parcours_forums_disponibles(integer) OWNER TO pgsql;

--
-- TOC entry 7882 (class 0 OID 0)
-- Dependencies: 1169
-- Name: FUNCTION af_get_parcours_forums_disponibles(integer); Type: COMMENT; Schema: contraintes; Owner: pgsql
--

COMMENT ON FUNCTION af_get_parcours_forums_disponibles(integer) IS 'retourne les etapes forums disponibles pour un parcours';


--
-- TOC entry 1170 (class 1255 OID 2595985)
-- Dependencies: 2983 5
-- Name: af_get_parcours_mode_affichage(integer); Type: FUNCTION; Schema: contraintes; Owner: pgsql
--

CREATE FUNCTION af_get_parcours_mode_affichage(integer) RETURNS integer
    AS $_$DECLARE
--$1 parcours
BEGIN

    SELECT count(*) INTO mode_affich
    FROM gestparcours
    WHERE g_num_parcours = $1
    AND num_etape_suivante = 1 ;

    IF (mode_affich>0) THEN
        RETURN(2) ;
    END IF ;

    SELECT count(*) INTO mode_affich
    FROM gestparcours
    WHERE g_num_parcours = $1
    AND type_etape = 'I' ;

    IF (mode_affich>0) THEN
        RETURN(1) ;
    ELSE
        RETURN(0) ;
    END IF ;

END;$_$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_get_parcours_mode_affichage(integer) OWNER TO pgsql;

--
-- TOC entry 1171 (class 1255 OID 2595986)
-- Dependencies: 2983 5
-- Name: af_get_parcours_oriente_configuration(integer); Type: FUNCTION; Schema: contraintes; Owner: pgsql
--

CREATE FUNCTION af_get_parcours_oriente_configuration(integer) RETURNS SETOF record
    AS $_$DECLARE
--$1 etape parcours oriente
rec RECORD;
BEGIN
	FOR rec IN
		SELECT id,sous_parcours, type, seuil
		FROM contraintes.parcours_oriente
		WHERE id=$1
		ORDER BY ordre
	LOOP
		RETURN NEXT rec;
	END LOOP;

	RETURN;
END;$_$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_get_parcours_oriente_configuration(integer) OWNER TO pgsql;

--
-- TOC entry 1172 (class 1255 OID 2595987)
-- Dependencies: 2983 5
-- Name: af_get_parcours_oriente_sous_parcours(integer); Type: FUNCTION; Schema: contraintes; Owner: pgsql
--

CREATE FUNCTION af_get_parcours_oriente_sous_parcours(integer) RETURNS SETOF record
    AS $_$DECLARE
rec RECORD;
BEGIN
	FOR rec IN
		SELECT DISTINCT P_id, libelle, filiere, ordre 
		FROM contraintes.parcours_oriente PO, contraintes.af_get_parcours() AS (P_id int4, libelle varchar, filiere int4, duree bool,date_creation timestamp)
		WHERE sous_parcours=P_id
		AND PO.id=$1
		ORDER BY ordre
	LOOP
		RETURN NEXT rec;
	END LOOP;

	RETURN;
END;$_$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_get_parcours_oriente_sous_parcours(integer) OWNER TO pgsql;

--
-- TOC entry 1173 (class 1255 OID 2595988)
-- Dependencies: 2983 5
-- Name: af_get_parcours_orientes_sous_parcours(); Type: FUNCTION; Schema: contraintes; Owner: pgsql
--

CREATE FUNCTION af_get_parcours_orientes_sous_parcours() RETURNS SETOF record
    AS $$DECLARE
rec RECORD;
BEGIN
	FOR rec IN
		SELECT DISTINCT P_id, libelle, filiere 
		FROM contraintes.parcours_oriente PO, contraintes.af_get_parcours() AS (P_id int4, libelle varchar, filiere int4, duree bool,date_creation timestamp)
		WHERE sous_parcours=P_id
	LOOP
		RETURN NEXT rec;
	END LOOP;

	RETURN;
END;$$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_get_parcours_orientes_sous_parcours() OWNER TO pgsql;

--
-- TOC entry 1174 (class 1255 OID 2595989)
-- Dependencies: 2983 5
-- Name: af_get_parcours_parcours_pere(integer); Type: FUNCTION; Schema: contraintes; Owner: pgsql
--

CREATE FUNCTION af_get_parcours_parcours_pere(integer) RETURNS SETOF integer
    AS $_$DECLARE
rec RECORD;
BEGIN
	FOR rec IN
	    /*
		SELECT E.pere AS id FROM contraintes.parcours_etapes E, contraintes.parcours P
		WHERE E.etape=$1
		AND E.pere IS NOT NULL
		AND E.pere=P.id
	    */
	    select E.parcours as id from contraintes.parcours_etapes E,contraintes.parcours P
	    where E.etape=$1
	    and p.id=E.parcours
	LOOP
		RETURN NEXT rec.id;
	END LOOP;

	RETURN;
END;$_$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_get_parcours_parcours_pere(integer) OWNER TO pgsql;

--
-- TOC entry 1175 (class 1255 OID 2595990)
-- Dependencies: 2983 5
-- Name: af_get_parcours_ressources(integer); Type: FUNCTION; Schema: contraintes; Owner: pgsql
--

CREATE FUNCTION af_get_parcours_ressources(integer) RETURNS SETOF record
    AS $_$DECLARE
--$1 parcours
rec RECORD;
BEGIN
	FOR rec IN 
		SELECT R.id, R.fichier , ER.espace , ER.section , PE_id , PE_parcours 
		FROM contraintes.af_get_parcours_etapes($1) AS (PE_id int4, PE_libelle varchar, PE_libelle_type_etape  varchar, PE_type int4,  PE_pere int4, PE_parcours int4, PE_obligatoire bool, PE_chrono int4, PE_fin bool),
		contraintes.ressource R, contraintes.etape_ressource ER
		WHERE PE_parcours=$1 
		AND PE_type=7
		AND ER.id=PE_id
		AND ER.ressource=R.id
	LOOP
		RETURN NEXT rec;
	END LOOP;
	RETURN;
END;$_$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_get_parcours_ressources(integer) OWNER TO pgsql;

--
-- TOC entry 1176 (class 1255 OID 2595991)
-- Dependencies: 2983 5
-- Name: af_get_parcours_sous_parcourss_disponibles(integer); Type: FUNCTION; Schema: contraintes; Owner: pgsql
--

CREATE FUNCTION af_get_parcours_sous_parcourss_disponibles(integer) RETURNS SETOF record
    AS $_$DECLARE
--$1 numéro du parcours
filiere_id int4;
niveau int4;
ss_parcours RECORD;
BEGIN
	--selection de la filiere du parcours
	SELECT INTO filiere_id filiere FROM contraintes.parcours
	WHERE id =$1;

	--selection du niveau de la filiere
	SELECT INTO niveau * FROM contraintes.af_gen_get_element_niveau('contraintes.filiere','id', filiere_id, '',0);
	--RAISE NOTICE 'filiere parcours: % niveau parcours=%',filiere_id,niveau;
	
	--selection des sous parcours disponibles pour le parcours
	FOR ss_parcours IN
		SELECT P_id, P_libelle, P_filiere, P_duree, P_date_creation,F_indice FROM contraintes.af_get_filieres()AS (F_id int4, F_libelle varchar, F_pere int4, F_indice int4),
		contraintes.af_get_parcours()AS (P_id integer, P_libelle varchar, P_filiere int4 , P_duree bool, P_date_creation timestamp) 
		LEFT OUTER JOIN contraintes.af_get_parcours_etapes(727) AS (id int4, libelle_alias varchar, libelle varchar, libelle_type_etape  varchar, type varchar,  pere int4, parcours int4, obligatoire bool, chrono int4, fin bool, libelle_type_original varchar, modifiable bool)
		ON (P_id=id AND type LIKE '1')
		WHERE F_indice=(niveau+1)
		AND P_filiere=F_id
		AND id IS NULL
	LOOP
		RETURN NEXT ss_parcours;
	END LOOP;

	RETURN;
END;
$_$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_get_parcours_sous_parcourss_disponibles(integer) OWNER TO pgsql;

--
-- TOC entry 1177 (class 1255 OID 2595992)
-- Dependencies: 2983 5
-- Name: af_get_parcours_type_etape_personnalise(integer, character varying); Type: FUNCTION; Schema: contraintes; Owner: pgsql
--

CREATE FUNCTION af_get_parcours_type_etape_personnalise(integer, character varying) RETURNS SETOF character varying
    AS $_$DECLARE
--$1 parcours
--$2 type d'etape
rec RECORD;
BEGIN
	FOR rec IN
		SELECT DISTINCT P.libelle_type_etape AS libelle
		FROM contraintes.parcours_etapes P, contraintes.etape E
		WHERE P.parcours=$1
		--AND E.type LIKE $2||'%'
		AND E.type LIKE $2
		AND E.id=P.etape
	LOOP
		RETURN NEXT rec.libelle;
	END LOOP;
	
	RETURN;
END;$_$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_get_parcours_type_etape_personnalise(integer, character varying) OWNER TO pgsql;

--
-- TOC entry 1178 (class 1255 OID 2595993)
-- Dependencies: 2983 5
-- Name: af_get_parcours_types_etapes(integer); Type: FUNCTION; Schema: contraintes; Owner: pgsql
--

CREATE FUNCTION af_get_parcours_types_etapes(integer) RETURNS SETOF record
    AS $_$DECLARE
--$1 parcours
rec RECORD;
BEGIN
	FOR rec IN
		SELECT  type, libelle_type_original, CAST(COUNT (type)AS int4) FROM contraintes.af_get_parcours_etapes($1) AS (id int4, libelle_alias varchar, libelle varchar, libelle_type_etape  varchar, type varchar,  pere int4, parcours int4, obligatoire bool, chrono int4, fin bool, libelle_type_original varchar, modifiable bool)
		GROUP BY type,libelle_type_original
		ORDER BY type
		/*SELECT DISTINCT T.id, T.libelle 
		FROM contraintes.parcours_etapes P, contraintes.etape_type T, contraintes.etape E
		WHERE P.parcours=$1 
		AND P.etape=E.id
		AND E.type=T.id*/
	LOOP
		RETURN NEXT rec;
	END LOOP;
	RETURN;
END;$_$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_get_parcours_types_etapes(integer) OWNER TO pgsql;

--
-- TOC entry 1179 (class 1255 OID 2595994)
-- Dependencies: 2983 5
-- Name: af_get_parcours_types_etapes_personnalises(integer); Type: FUNCTION; Schema: contraintes; Owner: pgsql
--

CREATE FUNCTION af_get_parcours_types_etapes_personnalises(integer) RETURNS SETOF character varying
    AS $_$DECLARE
--$1 parcours
rec RECORD;
BEGIN
	FOR rec IN
		SELECT DISTINCT libelle_type_etape FROM contraintes.parcours_etapes
		WHERE parcours=$1
	LOOP
		RETURN NEXT rec;
	END LOOP;
	RETURN;
END;$_$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_get_parcours_types_etapes_personnalises(integer) OWNER TO pgsql;

--
-- TOC entry 1180 (class 1255 OID 2595995)
-- Dependencies: 2983 5
-- Name: af_get_parcourss_orientes(); Type: FUNCTION; Schema: contraintes; Owner: pgsql
--

CREATE FUNCTION af_get_parcourss_orientes() RETURNS SETOF record
    AS $$declare
rec record;
begin
    for rec in 
	select id,sous_parcours from contraintes.parcours_oriente
    loop
	return next rec;
    end loop;
    return;

end;$$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_get_parcourss_orientes() OWNER TO pgsql;

--
-- TOC entry 7894 (class 0 OID 0)
-- Dependencies: 1180
-- Name: FUNCTION af_get_parcourss_orientes(); Type: COMMENT; Schema: contraintes; Owner: pgsql
--

COMMENT ON FUNCTION af_get_parcourss_orientes() IS 'retourne les parcours oriente de la plateforme';


--
-- TOC entry 1181 (class 1255 OID 2595996)
-- Dependencies: 2983 5
-- Name: af_get_positionnement(integer); Type: FUNCTION; Schema: contraintes; Owner: pgsql
--

CREATE FUNCTION af_get_positionnement(integer) RETURNS record
    AS $_$DECLARE
rec RECORD;
BEGIN

	
	SELECT INTO rec P.id, P.libelle, QR.type, P.chrono, P.serie_generee, P.bareme, S.chrono AS chrono_genere, QR.radio, P.qsrc, E.date_creation
	FROM contraintes.positionnement P, contraintes.serie S, contraintes.qsrc Q, contraintes.question_reponse QR, contraintes.evaluation E
	WHERE P.id=$1
	AND P.serie_generee=S.id
	AND P.qsrc=Q.id
	AND Q.id=QR.id
	AND P.qsrc=E.id;

	RETURN rec;
	
END$_$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_get_positionnement(integer) OWNER TO pgsql;

--
-- TOC entry 1182 (class 1255 OID 2595997)
-- Dependencies: 2983 5
-- Name: af_get_positionnement_choix(integer); Type: FUNCTION; Schema: contraintes; Owner: pgsql
--

CREATE FUNCTION af_get_positionnement_choix(integer) RETURNS SETOF record
    AS $_$DECLARE
rec RECORD;
qr int4;
BEGIN
	--on selectionne le question-reponse associé au positionnement
	SELECT INTO qr question_reponse FROM contraintes.positionnement where id=$1;
	raise notice 'question_reponse=%',qr;
	FOR rec IN
		SELECT DISTINCT O_id,R.libelle,R.interpretation_html,R.reponse
		FROM contraintes.af_gen_get_elements('contraintes.choix', 'id', NULL, 'AND positionnement='||$1 ) O_id
		LEFT OUTER JOIN
		contraintes.question_reponse_element R
		ON O_id=R.id
	LOOP
		RETURN NEXT rec;
	END LOOP;

	RETURN;
END;$_$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_get_positionnement_choix(integer) OWNER TO pgsql;

--
-- TOC entry 1183 (class 1255 OID 2595998)
-- Dependencies: 2983 5
-- Name: af_get_positionnement_choix_infos(integer); Type: FUNCTION; Schema: contraintes; Owner: pgsql
--

CREATE FUNCTION af_get_positionnement_choix_infos(integer) RETURNS SETOF record
    AS $_$DECLARE
rec RECORD;

qr int4;
BEGIN
	--on selectionne le question-reponse associé au positionnement
	SELECT INTO qr question_reponse FROM contraintes.positionnement where id=$1;
	
	FOR rec IN
		SELECT C_id  , A_libelle, A_interpretationHTML ,C.positionnement, C.bareme, C.pere ,M.media, M.hauteur, M.largeur 
		FROM (contraintes.choix C INNER JOIN 
		contraintes.af_gen_get_elements('contraintes.choix', 'id', NULL, 'AND positionnement='||$1 ) C_id 
		ON C_id= C.id)
		LEFT OUTER JOIN contraintes.media_question_reponse_element M 
		ON C_id=M.question_reponse_element AND M.question_reponse=qr
		LEFT OUTER JOIN contraintes.af_get_positionnement_choix($1) AS (A_id int4, A_libelle varchar, A_interpretationHTML bool, A_question bool)
		ON C_id=A_id
	LOOP
		RETURN NEXT rec;
	END LOOP;


	RETURN;
END$_$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_get_positionnement_choix_infos(integer) OWNER TO pgsql;

--
-- TOC entry 1184 (class 1255 OID 2595999)
-- Dependencies: 2983 5
-- Name: af_get_positionnement_choix_infos(integer, integer); Type: FUNCTION; Schema: contraintes; Owner: pgsql
--

CREATE FUNCTION af_get_positionnement_choix_infos(integer, integer) RETURNS record
    AS $_$DECLARE
rec RECORD;
BEGIN
	
	
	SELECT INTO rec * FROM contraintes.af_get_positionnement_choix_infos($1)AS (id int4, libelle varchar, interpretationHTML bool, positionnement int4, bareme int4, pere int4, media int4, longueur int4, largeur int4)
	WHERE id=$2;
	

	RETURN rec;
END$_$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_get_positionnement_choix_infos(integer, integer) OWNER TO pgsql;

--
-- TOC entry 1859 (class 1255 OID 2596000)
-- Dependencies: 2983 5
-- Name: af_get_positionnement_count_evaluations_a_associer(integer); Type: FUNCTION; Schema: contraintes; Owner: pgsql
--

CREATE FUNCTION af_get_positionnement_count_evaluations_a_associer(integer) RETURNS integer
    AS $_$DECLARE
nb int4:=0;
rec RECORD;
BEGIN
	FOR rec IN
		SELECT * FROM contraintes.af_get_positionnement_nb_evaluations_a_generer($1) 
		AS (id int4, reponse int4, type int4, nb_a_generer int4, taille_chapeau int4)
	LOOP
		IF rec.taille_chapeau IS NULL THEN
			nb:=nb+rec.nb_a_generer;
		ELSE
			nb:=nb+rec.taille_chapeau;
		END IF;
	END LOOP;
	RETURN nb; 
END;$_$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_get_positionnement_count_evaluations_a_associer(integer) OWNER TO pgsql;

--
-- TOC entry 1185 (class 1255 OID 2596001)
-- Dependencies: 2983 5
-- Name: af_get_positionnement_elements(integer); Type: FUNCTION; Schema: contraintes; Owner: pgsql
--

CREATE FUNCTION af_get_positionnement_elements(integer) RETURNS SETOF record
    AS $_$DECLARE
rec RECORD;
qr int4;
BEGIN
	--on selectionne le question-reponse associé au positionnement
	SELECT INTO qr question_reponse FROM contraintes.positionnement where id=$1;
	
	FOR rec IN
		SELECT DISTINCT E.question , E.choix
		FROM contraintes.positionnement_elements E, 
		contraintes.af_gen_get_elements('contraintes.question_reponse_elements', 'question', NULL, 'AND question_reponse='||qr ) O_id
		WHERE E.question=O_id
	LOOP
		RETURN NEXT rec;
	END LOOP;
	
	RETURN;
END$_$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_get_positionnement_elements(integer) OWNER TO pgsql;

--
-- TOC entry 1186 (class 1255 OID 2596002)
-- Dependencies: 2983 5
-- Name: af_get_positionnement_evaluation_a_generer(integer, integer, integer, integer); Type: FUNCTION; Schema: contraintes; Owner: pgsql
--

CREATE FUNCTION af_get_positionnement_evaluation_a_generer(integer, integer, integer, integer) RETURNS record
    AS $_$DECLARE
--$1 positionnement
--$2 question
--$3 reponse
--$4 ordre
rec RECORD;
qr int4;
v_i int4:=0;
BEGIN

	--on selectionne le question-reponse associé au positionnement
	SELECT INTO qr question_reponse FROM contraintes.positionnement where id=$1;

	FOR rec IN
		
		SELECT E.id, E.libelle, E.type, P.pere 
		FROM 
		
		contraintes.af_gen_get_elements('contraintes.positionnement_evaluations', 'evaluation', NULL, ' AND question_reponse='||qr ||' AND question='||$2||' AND choix='||$3) AS O_id,
		contraintes.evaluation E ,
		contraintes.positionnement_evaluations P 
			
		     
		WHERE P.evaluation=O_id
		AND E.id=O_id
		AND P.question_reponse=qr 
		AND P.question=$2
		AND P.choix=$3
	LOOP
		RAISE NOTICE '% % %',qr,$2,$3;
		v_i:=v_i+1;
		IF v_i=$4 THEN
			RETURN rec;
		END IF;
	END LOOP; 

	RETURN NULL;
END$_$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_get_positionnement_evaluation_a_generer(integer, integer, integer, integer) OWNER TO pgsql;

--
-- TOC entry 1187 (class 1255 OID 2596003)
-- Dependencies: 2983 5
-- Name: af_get_positionnement_evaluations_a_generer(integer, integer, integer); Type: FUNCTION; Schema: contraintes; Owner: pgsql
--

CREATE FUNCTION af_get_positionnement_evaluations_a_generer(integer, integer, integer) RETURNS SETOF record
    AS $_$DECLARE
rec RECORD;
qr int4;
BEGIN
	SELECT INTO qr question_reponse FROM contraintes.positionnement
	WHERE positionnement=$1;
 
	FOR rec IN
		SELECT  T.id, T.libelle, T.type, E.question, E.reponse
		FROM contraintes.positionnement_elements E,
		contraintes.positionnement_evaluations V,
		--contraintes.af_gen_get_elements('contraintes.q', 'evaluation', NULL, 'AND question_reponse='||qr ) O_id,
		contraintes.evaluation T
		--WHERE O_id=V.question_reponse
		WHERE V.question_reponse=E.question_reponse
		AND E.question=$2
		AND E.choix=$3
		AND V.evaluation=T.id
	LOOP
		RETURN NEXT rec;
	END LOOP;


	RETURN;
END$_$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_get_positionnement_evaluations_a_generer(integer, integer, integer) OWNER TO pgsql;

--
-- TOC entry 1188 (class 1255 OID 2596004)
-- Dependencies: 2983 5
-- Name: af_get_positionnement_evaluations_a_generer(integer, integer, integer, integer); Type: FUNCTION; Schema: contraintes; Owner: pgsql
--

CREATE FUNCTION af_get_positionnement_evaluations_a_generer(integer, integer, integer, integer) RETURNS SETOF record
    AS $_$DECLARE
rec RECORD;
qr int4;
BEGIN
	SELECT INTO qr question_reponse FROM contraintes.positionnement
	WHERE id=$1;
 
	FOR rec IN
		SELECT  E.id, E.libelle, E.type, EV.pere
		FROM contraintes.af_gen_get_elements('contraintes.positionnement_evaluations', 'evaluation', NULL, 'AND question_reponse='||qr||' AND question='||$2||' AND choix='||$3 ) O_id,
		contraintes.evaluation E,
		contraintes.positionnement_evaluations EV
		WHERE E.id=O_id
		AND E.type=$4
		AND EV.question_reponse=qr
		AND EV.question=$2
		AND EV.choix=$3 
	LOOP
		RETURN NEXT rec;
	END LOOP;


	RETURN;
END$_$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_get_positionnement_evaluations_a_generer(integer, integer, integer, integer) OWNER TO pgsql;

--
-- TOC entry 1189 (class 1255 OID 2596005)
-- Dependencies: 2983 5
-- Name: af_get_positionnement_evaluations_a_generer(integer); Type: FUNCTION; Schema: contraintes; Owner: pgsql
--

CREATE FUNCTION af_get_positionnement_evaluations_a_generer(integer) RETURNS SETOF record
    AS $_$DECLARE
rec RECORD;
qr int4;
BEGIN
	SELECT INTO qr qsrc FROM contraintes.positionnement
	WHERE id=$1;
 
	FOR rec IN
		SELECT  T.id, T.libelle, T.type, V.question, V.choix, CAST(NULL AS int4) AS pere
		FROM 
		--contraintes.positionnement_elements E,
		contraintes.positionnement_evaluations V,
		contraintes.evaluation T
		WHERE V.question_reponse=qr
		--AND V.question_reponse=E.question_reponse
		AND V.evaluation=T.id
	LOOP
		RETURN NEXT rec;
	END LOOP;


	RETURN;
END$_$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_get_positionnement_evaluations_a_generer(integer) OWNER TO pgsql;

--
-- TOC entry 1190 (class 1255 OID 2596006)
-- Dependencies: 2983 5
-- Name: af_get_positionnement_evaluations_affiliables_type(integer, integer, integer); Type: FUNCTION; Schema: contraintes; Owner: pgsql
--

CREATE FUNCTION af_get_positionnement_evaluations_affiliables_type(integer, integer, integer) RETURNS SETOF record
    AS $_$DECLARE
--$1 positionnement
--$2 theme
--$3 type
rec RECORD;
qr int4;
BEGIN
	--on selectionne le question-reponse associé au positionnement
	SELECT INTO qr question_reponse FROM contraintes.positionnement where id=$1;
	
	FOR rec IN
		SELECT DISTINCT E.id, E.libelle, E.type
		FROM ((contraintes.evaluation E INNER JOIN 
		contraintes.af_get_theme_evaluations($2) AS (T_id int4, T_type int4) ON T_id=E.id)
		LEFT OUTER JOIN	contraintes.positionnement_evaluations PE 
		ON T_id=PE.evaluation AND PE.question_reponse=qr)
		WHERE E.type=$3
		AND T_type=$3 
		AND PE.evaluation IS NULL 
		 
		--GROUP BY E.id,PE.evaluation, PE.question_reponse, E.libelle, E.type
		--HAVING E.id!=PE.evaluation 
	LOOP
		RETURN NEXT rec;
	END LOOP;

	RETURN;
END;$_$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_get_positionnement_evaluations_affiliables_type(integer, integer, integer) OWNER TO pgsql;

--
-- TOC entry 1191 (class 1255 OID 2596007)
-- Dependencies: 2983 5
-- Name: af_get_positionnement_last_question(integer); Type: FUNCTION; Schema: contraintes; Owner: pgsql
--

CREATE FUNCTION af_get_positionnement_last_question(integer) RETURNS integer
    AS $_$DECLARE 
last_id int4;
question_reponse_id int4;

BEGIN
	--on recupere le question_reponse correscpondant au positionnement
	SELECT INTO question_reponse_id  question_reponse FROM contraintes.positionnement WHERE id=$1;
	
	IF question_reponse_id IS NOT NULL THEN
		SELECT INTO last_id ID FROM contraintes.af_gen_get_last_element('contraintes.question_reponse_elements', 'question',' AND question_reponse='||question_reponse_id);
		RETURN last_id;
	ELSE
		RETURN NULL;
	END IF;
END$_$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_get_positionnement_last_question(integer) OWNER TO pgsql;

--
-- TOC entry 1192 (class 1255 OID 2596008)
-- Dependencies: 2983 5
-- Name: af_get_positionnement_media(integer); Type: FUNCTION; Schema: contraintes; Owner: pgsql
--

CREATE FUNCTION af_get_positionnement_media(integer) RETURNS record
    AS $_$DECLARE
rec RECORD;
qr int4;
BEGIN
	--on selectionne le question-reponse associé au positionnement
	SELECT INTO qr question_reponse FROM contraintes.positionnement where id=$1;

	SELECT INTO rec media, hauteur, largeur, question_reponse 
	FROM contraintes.af_get_question_reponse_media(qr) AS (  question_reponse int4, media int4, flash int4, hauteur int4, largeur int4 );

	RETURN rec;
END$_$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_get_positionnement_media(integer) OWNER TO pgsql;

--
-- TOC entry 1193 (class 1255 OID 2596009)
-- Dependencies: 2983 5
-- Name: af_get_positionnement_nb_evaluations_a_generer(integer); Type: FUNCTION; Schema: contraintes; Owner: pgsql
--

CREATE FUNCTION af_get_positionnement_nb_evaluations_a_generer(integer) RETURNS SETOF record
    AS $_$DECLARE
rec RECORD;

BEGIN
 
	FOR rec IN
		SELECT E.positionnement , E.choix , E.type , E.nombre , E.nombre_max 
		FROM contraintes.positionnement_choix_evaluations E,
		contraintes.af_gen_get_elements('contraintes.choix', 'id', NULL, 'AND positionnement='||$1 ) O_id
		WHERE O_id=E.choix
		AND E.positionnement=$1
	LOOP
		RETURN NEXT rec;
	END LOOP;


	RETURN;
END$_$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_get_positionnement_nb_evaluations_a_generer(integer) OWNER TO pgsql;

--
-- TOC entry 1194 (class 1255 OID 2596010)
-- Dependencies: 2983 5
-- Name: af_get_positionnement_question_positionnement_solution(integer, integer, integer); Type: FUNCTION; Schema: contraintes; Owner: pgsql
--

CREATE FUNCTION af_get_positionnement_question_positionnement_solution(integer, integer, integer) RETURNS record
    AS $_$DECLARE
--$1 positionnement
--$2 question
--$3 reponse
rec RECORD;
qr int4;
BEGIN
	--on selectionne le question-reponse associé au positionnement
	SELECT INTO qr question_reponse FROM contraintes.positionnement where id=$1;

	SELECT INTO rec * FROM contraintes.qcm_elements
	WHERE question_reponse=qr
	AND question=$2
	AND reponse=$3;
	raise notice 'qr=% q=% r=%', qr, $2,$3;
	RETURN rec;
END$_$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_get_positionnement_question_positionnement_solution(integer, integer, integer) OWNER TO pgsql;

--
-- TOC entry 1195 (class 1255 OID 2596011)
-- Dependencies: 2983 5
-- Name: af_get_positionnement_questions(integer); Type: FUNCTION; Schema: contraintes; Owner: pgsql
--

CREATE FUNCTION af_get_positionnement_questions(integer) RETURNS SETOF record
    AS $_$DECLARE
rec RECORD;
qr int4;
BEGIN
	--on selectionne le question-reponse associé au positionnement
	SELECT INTO qr question_reponse FROM contraintes.positionnement where id=$1;
	
	FOR rec IN
		SELECT DISTINCT Q.id,Q.libelle,Q.interpretation_html,Q.reponse, O_id.ind
		FROM contraintes.af_gen_get_elements('contraintes.question_reponse_elements', 'question', NULL, 'AND question_reponse='||qr , 0) O_id,
		contraintes.question_reponse_element Q
		WHERE O_id.id=Q.id
		ORDER BY O_id.ind
	LOOP
		RETURN NEXT rec;
	END LOOP;

	RETURN;
END;$_$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_get_positionnement_questions(integer) OWNER TO pgsql;

--
-- TOC entry 1196 (class 1255 OID 2596012)
-- Dependencies: 2983 5
-- Name: af_get_positionnement_tests(integer); Type: FUNCTION; Schema: contraintes; Owner: pgsql
--

CREATE FUNCTION af_get_positionnement_tests(integer) RETURNS SETOF record
    AS $_$DECLARE
--$1 positionnement
rec RECORD;
BEGIN
	FOR rec IN

		SELECT DISTINCT E_id, E_libelle,  E_dynamique, E_continu, media , hauteur_media , largeur_media, date_creation   FROM contraintes.test_positionnements P,
		contraintes.af_get_tests() AS (E_id int4, E_libelle varchar,  E_dynamique bool, E_continu bool, media int4, hauteur_media int4, largeur_media int4, date_creation timestamp)
		WHERE E_id=P.test
		AND P.positionnement=$1
	LOOP
		RETURN NEXT rec;
	END LOOP;

	RETURN;
END;$_$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_get_positionnement_tests(integer) OWNER TO pgsql;

--
-- TOC entry 1197 (class 1255 OID 2596013)
-- Dependencies: 2983 5
-- Name: af_get_positionnements(); Type: FUNCTION; Schema: contraintes; Owner: pgsql
--

CREATE FUNCTION af_get_positionnements() RETURNS SETOF record
    AS $$DECLARE
rec RECORD;
BEGIN

	FOR rec IN
		SELECT DISTINCT P.id, P.libelle, P.type_question, P.chrono, P.serie_aleatoire, S.bareme, S.chrono
		FROM contraintes.positionnement P, contraintes.serie S
		WHERE P.serie_aleatoire=S.id
	LOOP
		RETURN NEXT rec;
	END LOOP;

	RETURN;
END$$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_get_positionnements() OWNER TO pgsql;

--
-- TOC entry 1198 (class 1255 OID 2596014)
-- Dependencies: 2983 5
-- Name: af_get_presentiel_carton_capacite_date(integer, integer, integer, integer, integer, timestamp without time zone); Type: FUNCTION; Schema: contraintes; Owner: pgsql
--

CREATE FUNCTION af_get_presentiel_carton_capacite_date(integer, integer, integer, integer, integer, timestamp without time zone) RETURNS record
    AS $_$-- $1 : formation
-- $2 : stagiaire
-- $3 : grille
-- $4 : titre capacite
-- $5 : capacite
-- $6 : date
declare
rec record;
begin
    select into rec carton from contraintes.grille_resultats 
    where formation=$1 and stagiaire=$2 and grille=$3 and capacite_titre=$4 and capacite=$5 and date=$6;
    return rec;	
end;$_$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_get_presentiel_carton_capacite_date(integer, integer, integer, integer, integer, timestamp without time zone) OWNER TO pgsql;

--
-- TOC entry 7914 (class 0 OID 0)
-- Dependencies: 1198
-- Name: FUNCTION af_get_presentiel_carton_capacite_date(integer, integer, integer, integer, integer, timestamp without time zone); Type: COMMENT; Schema: contraintes; Owner: pgsql
--

COMMENT ON FUNCTION af_get_presentiel_carton_capacite_date(integer, integer, integer, integer, integer, timestamp without time zone) IS 'retourne le carton pour une capacite à une date';


--
-- TOC entry 1199 (class 1255 OID 2596015)
-- Dependencies: 2983 5
-- Name: af_get_presentiel_carton_individu(integer, integer, integer, integer, integer); Type: FUNCTION; Schema: contraintes; Owner: pgsql
--

CREATE FUNCTION af_get_presentiel_carton_individu(integer, integer, integer, integer, integer) RETURNS SETOF record
    AS $_$-- $1 : formation
-- $2 : individu
-- $3 : grille
-- $4 : titre capacite
-- $5 : capacite
declare
rec record;
begin
    for rec in
	select * from contraintes.grille_resultats 
	where formation=$1 and stagiaire=$2 and grille=$3 and capacite_titre=$4 and capacite=$5
    loop
	return next rec;
    end loop;
end;$_$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_get_presentiel_carton_individu(integer, integer, integer, integer, integer) OWNER TO pgsql;

--
-- TOC entry 7916 (class 0 OID 0)
-- Dependencies: 1199
-- Name: FUNCTION af_get_presentiel_carton_individu(integer, integer, integer, integer, integer); Type: COMMENT; Schema: contraintes; Owner: pgsql
--

COMMENT ON FUNCTION af_get_presentiel_carton_individu(integer, integer, integer, integer, integer) IS 'retourne les notations presentielles pour un individu';


--
-- TOC entry 1200 (class 1255 OID 2596016)
-- Dependencies: 2983 5
-- Name: af_get_presentiel_note_individu_date(integer, integer, integer, integer, integer, timestamp without time zone); Type: FUNCTION; Schema: contraintes; Owner: pgsql
--

CREATE FUNCTION af_get_presentiel_note_individu_date(integer, integer, integer, integer, integer, timestamp without time zone) RETURNS record
    AS $_$-- $1 : formation
-- $2 : stagiaire
-- $3 : grille
-- $4 : titre capacite
-- $5 : capacite
-- $6 : date
declare
rec record;
begin
    select into rec commentaire,note,note_max from contraintes.grille_resultats 
    where formation=$1 and stagiaire=$2 and grille=$3 and capacite_titre=$4 and capacite=$5 and date=$6;
    return rec;
end;$_$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_get_presentiel_note_individu_date(integer, integer, integer, integer, integer, timestamp without time zone) OWNER TO pgsql;

--
-- TOC entry 7918 (class 0 OID 0)
-- Dependencies: 1200
-- Name: FUNCTION af_get_presentiel_note_individu_date(integer, integer, integer, integer, integer, timestamp without time zone); Type: COMMENT; Schema: contraintes; Owner: pgsql
--

COMMENT ON FUNCTION af_get_presentiel_note_individu_date(integer, integer, integer, integer, integer, timestamp without time zone) IS 'retourne la note pour une capacite à une date';


--
-- TOC entry 1201 (class 1255 OID 2596017)
-- Dependencies: 2983 5
-- Name: af_get_presentiel_resultat_individu_date(integer, integer, integer, integer, integer, timestamp without time zone); Type: FUNCTION; Schema: contraintes; Owner: pgsql
--

CREATE FUNCTION af_get_presentiel_resultat_individu_date(integer, integer, integer, integer, integer, timestamp without time zone) RETURNS record
    AS $_$-- $1 : formation
-- $2 : stagiaire
-- $3 : grille
-- $4 : titre capacite
-- $5 : capacite
-- $6 : date
declare
rec record;
begin
    select into rec * from contraintes.grille_resultats 
    where formation=$1 and stagiaire=$2 and grille=$3 and capacite_titre=$4 and capacite=$5 and date=$6;
    return rec;
end;$_$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_get_presentiel_resultat_individu_date(integer, integer, integer, integer, integer, timestamp without time zone) OWNER TO pgsql;

--
-- TOC entry 7920 (class 0 OID 0)
-- Dependencies: 1201
-- Name: FUNCTION af_get_presentiel_resultat_individu_date(integer, integer, integer, integer, integer, timestamp without time zone); Type: COMMENT; Schema: contraintes; Owner: pgsql
--

COMMENT ON FUNCTION af_get_presentiel_resultat_individu_date(integer, integer, integer, integer, integer, timestamp without time zone) IS 'retourne le resultat pour un individu à une date';


--
-- TOC entry 1202 (class 1255 OID 2596018)
-- Dependencies: 2983 5
-- Name: af_get_presentiel_resultats_individu_capacite(integer, integer, integer, integer, integer); Type: FUNCTION; Schema: contraintes; Owner: pgsql
--

CREATE FUNCTION af_get_presentiel_resultats_individu_capacite(integer, integer, integer, integer, integer) RETURNS SETOF record
    AS $_$-- $1 : formation
-- $2 : individu
-- $3 : grille
-- $4 : titre capacite
-- $5 : capacite
declare
rec record;
begin
    for rec in
	select * from contraintes.grille_resultats 
	where formation=$1 and stagiaire=$2 and grille=$3 and capacite_titre=$4 and capacite=$5
    loop
	return next rec;
    end loop;
end;$_$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_get_presentiel_resultats_individu_capacite(integer, integer, integer, integer, integer) OWNER TO pgsql;

--
-- TOC entry 7922 (class 0 OID 0)
-- Dependencies: 1202
-- Name: FUNCTION af_get_presentiel_resultats_individu_capacite(integer, integer, integer, integer, integer); Type: COMMENT; Schema: contraintes; Owner: pgsql
--

COMMENT ON FUNCTION af_get_presentiel_resultats_individu_capacite(integer, integer, integer, integer, integer) IS 'retourne les resultat presentiel d''un individu pour une capacite';


--
-- TOC entry 1203 (class 1255 OID 2596019)
-- Dependencies: 2983 5
-- Name: af_get_presentiel_resultats_individu_grille(integer, integer, integer); Type: FUNCTION; Schema: contraintes; Owner: pgsql
--

CREATE FUNCTION af_get_presentiel_resultats_individu_grille(integer, integer, integer) RETURNS SETOF record
    AS $_$-- $1 : formation
-- $2 : stagiaire
-- $3 : grille
declare
rec record;
begin
    for rec in 
	select formation,stagiaire,grille,g.libelle,capacite_titre,ct.libelle,capacite,c.libelle,commentaire,note,note_max,carton,date 
	from contraintes.grille_resultats,
	contraintes.grille g,
	contraintes.capacite_titre ct,
	contraintes.capacite c 
	where formation=$1 and stagiaire=$2 and grille=$3 
	and grille=g.id and capacite_titre=ct.id and capacite=c.id
    loop
	return next rec;
    end loop;
end;$_$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_get_presentiel_resultats_individu_grille(integer, integer, integer) OWNER TO pgsql;

--
-- TOC entry 7924 (class 0 OID 0)
-- Dependencies: 1203
-- Name: FUNCTION af_get_presentiel_resultats_individu_grille(integer, integer, integer); Type: COMMENT; Schema: contraintes; Owner: pgsql
--

COMMENT ON FUNCTION af_get_presentiel_resultats_individu_grille(integer, integer, integer) IS 'Obtenir les resultats presentiels pour un individu et une grille';


--
-- TOC entry 1204 (class 1255 OID 2596020)
-- Dependencies: 2983 5
-- Name: af_get_presentiel_stagiaire_grille(integer, integer, integer); Type: FUNCTION; Schema: contraintes; Owner: pgsql
--

CREATE FUNCTION af_get_presentiel_stagiaire_grille(integer, integer, integer) RETURNS record
    AS $_$-- $1 : formation
-- $2 : stagiaire
-- $3 : grille
declare
rec record;
begin
    select into rec * from contraintes.stagiaire_grille 
    where formation=$1 and stagiaire=$2 and grille=$3;
    return rec;
end;$_$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_get_presentiel_stagiaire_grille(integer, integer, integer) OWNER TO pgsql;

--
-- TOC entry 7926 (class 0 OID 0)
-- Dependencies: 1204
-- Name: FUNCTION af_get_presentiel_stagiaire_grille(integer, integer, integer); Type: COMMENT; Schema: contraintes; Owner: pgsql
--

COMMENT ON FUNCTION af_get_presentiel_stagiaire_grille(integer, integer, integer) IS 'retourne les infos de la table stagiaire_grille pour un stagiaire';


--
-- TOC entry 1205 (class 1255 OID 2596021)
-- Dependencies: 2983 5
-- Name: af_get_qrc_question_solution(integer, integer, integer); Type: FUNCTION; Schema: contraintes; Owner: pgsql
--

CREATE FUNCTION af_get_qrc_question_solution(integer, integer, integer) RETURNS record
    AS $_$DECLARE
--$1 qrc
--$2 question
--$3 reponse
rec RECORD;
qr int4;
BEGIN

	SELECT INTO rec * FROM contraintes.qcm_elements
	WHERE question_reponse=$1
	AND question=$2
	AND reponse=$3;
	--raise notice 'qr=% q=% r=%', qr, $2,$3;
	RETURN rec;
END$_$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_get_qrc_question_solution(integer, integer, integer) OWNER TO pgsql;

--
-- TOC entry 1206 (class 1255 OID 2596022)
-- Dependencies: 2983 5
-- Name: af_get_qsrc(integer); Type: FUNCTION; Schema: contraintes; Owner: pgsql
--

CREATE FUNCTION af_get_qsrc(integer) RETURNS record
    AS $_$DECLARE
--$1 identifiant du qsrc
rec RECORD;
BEGIN
	SELECT INTO rec Q.id, E_libelle, Q.question, E_type,E_date_modification, radio
	FROM contraintes.qsrc Q, contraintes.af_get_evaluation($1) AS (E_id int4, E_libelle varchar, E_type int4,  E_date_modification timestamp),
	contraintes.question_reponse QR
	WHERE Q.id=E_id
	AND Q.id=$1
	AND QR.id=Q.id;

	RETURN rec;
END;$_$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_get_qsrc(integer) OWNER TO pgsql;

--
-- TOC entry 1207 (class 1255 OID 2596023)
-- Dependencies: 2983 5
-- Name: af_get_qsrc_question_reponse(integer); Type: FUNCTION; Schema: contraintes; Owner: pgsql
--

CREATE FUNCTION af_get_qsrc_question_reponse(integer) RETURNS integer
    AS $_$DECLARE
v_question_reponse integer;
BEGIN
	SELECT INTO v_question_reponse question_reponse 
	FROM contraintes.qsrc Q, contraintes.positionnement P
	WHERE Q.id=$1 
	AND Q.positionnement=P.id;

	RETURN v_question_reponse;
END;$_$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_get_qsrc_question_reponse(integer) OWNER TO pgsql;

--
-- TOC entry 1208 (class 1255 OID 2596024)
-- Dependencies: 2983 5
-- Name: af_get_qsrc_questions(integer); Type: FUNCTION; Schema: contraintes; Owner: pgsql
--

CREATE FUNCTION af_get_qsrc_questions(integer) RETURNS SETOF record
    AS $_$DECLARE
rec RECORD;
BEGIN
    FOR rec IN
        /*
	SELECT DISTINCT Q.id,Q.libelle,Q.interpretation_html,Q.reponse, O_id.ind
	FROM contraintes.af_gen_get_elements('contraintes.question_reponse_elements', 'question', NULL, 'AND question_reponse='||$1 , 0) O_id,
	contraintes.question_reponse_element Q
	WHERE O_id.id=Q.id
	ORDER BY O_id.ind
	*/
	SELECT DISTINCT Q.id,Q.libelle,Q.interpretation_html,Q.reponse, O_id.ind
	FROM contraintes.af_gen_get_elements('contraintes.question_reponse_elements', 'question_reponse_element', NULL, 'AND question_reponse='||$1||'and question_reponse_element in (select id from contraintes.question_reponse_element where reponse is false)' , 0) O_id,
	contraintes.question_reponse_element Q
	WHERE O_id.id=Q.id
	ORDER BY O_id.ind
    LOOP
	RETURN NEXT rec;
    END LOOP;
	RETURN;
END;$_$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_get_qsrc_questions(integer) OWNER TO pgsql;

--
-- TOC entry 1209 (class 1255 OID 2596025)
-- Dependencies: 2983 5
-- Name: af_get_question(integer); Type: FUNCTION; Schema: contraintes; Owner: postgres
--

CREATE FUNCTION af_get_question(integer) RETURNS record
    AS $_$DECLARE
rec record;
BEGIN
	
	--select into rec from contraintes.af_get_question_reponse_element E, contraintes.question Q
	select  into rec E.id,E.libelle,E.interpretation_html from contraintes.question_reponse_element E, contraintes.question Q
	WHERE E.id=$1 AND E.id=Q.id;
	return rec;
	
	

END;$_$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_get_question(integer) OWNER TO postgres;

--
-- TOC entry 7932 (class 0 OID 0)
-- Dependencies: 1209
-- Name: FUNCTION af_get_question(integer); Type: COMMENT; Schema: contraintes; Owner: postgres
--

COMMENT ON FUNCTION af_get_question(integer) IS 'Obtenir une question.
';


--
-- TOC entry 1860 (class 1255 OID 2596026)
-- Dependencies: 2983 5
-- Name: af_get_question_positionnement_media(integer, integer); Type: FUNCTION; Schema: contraintes; Owner: pgsql
--

CREATE FUNCTION af_get_question_positionnement_media(integer, integer) RETURNS record
    AS $_$DECLARE
--$1 idenfifiant de la question de positionnement
--$2 idenfifiant du positionnement
rec RECORD;
qr int4;
BEGIN
	SELECT INTO qr question_reponse FROM contraintes.positionnement
	WHERE id=$2;

	SELECT INTO rec question_reponse, question_reponse_element, media, media, hauteur, largeur 
	FROM contraintes.af_get_question_reponse_element_media(qr,$1) AS (question_reponse int4, question_reponse_element int4, media int4, flash int4, hauteur int4, largeur int4);
	

	RETURN rec;
END$_$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_get_question_positionnement_media(integer, integer) OWNER TO pgsql;

--
-- TOC entry 7934 (class 0 OID 0)
-- Dependencies: 1860
-- Name: FUNCTION af_get_question_positionnement_media(integer, integer); Type: COMMENT; Schema: contraintes; Owner: pgsql
--

COMMENT ON FUNCTION af_get_question_positionnement_media(integer, integer) IS 'Obtenir le media d''une question de positionnement pour un positionnement.';


--
-- TOC entry 1210 (class 1255 OID 2596027)
-- Dependencies: 2983 5
-- Name: af_get_question_reponse(integer); Type: FUNCTION; Schema: contraintes; Owner: pgsql
--

CREATE FUNCTION af_get_question_reponse(integer) RETURNS record
    AS $_$DECLARE
--$1 question_reponse
rec RECORD;
BEGIN
	SELECT INTO rec E.id, E.libelle, E.type, E.date_creation, QR.radio
	FROM contraintes.question_reponse QR, contraintes.evaluation E
	WHERE QR.id = $1
	AND QR.id=E.id;

	return rec;
END$_$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_get_question_reponse(integer) OWNER TO pgsql;

--
-- TOC entry 7936 (class 0 OID 0)
-- Dependencies: 1210
-- Name: FUNCTION af_get_question_reponse(integer); Type: COMMENT; Schema: contraintes; Owner: pgsql
--

COMMENT ON FUNCTION af_get_question_reponse(integer) IS 'Obtenir un question_reponse.';


--
-- TOC entry 1211 (class 1255 OID 2596028)
-- Dependencies: 2983 5
-- Name: af_get_question_reponse_association_elements(integer); Type: FUNCTION; Schema: contraintes; Owner: pgsql
--

CREATE FUNCTION af_get_question_reponse_association_elements(integer) RETURNS SETOF record
    AS $_$

DECLARE
rec RECORD;
BEGIN

	FOR rec IN

		SELECT * FROM contraintes.question_reponse_elements
		WHERE question_reponse=$1
	LOOP
		RETURN NEXT rec;
	END LOOP;

		RETURN;

END
$_$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_get_question_reponse_association_elements(integer) OWNER TO pgsql;

--
-- TOC entry 7938 (class 0 OID 0)
-- Dependencies: 1211
-- Name: FUNCTION af_get_question_reponse_association_elements(integer); Type: COMMENT; Schema: contraintes; Owner: pgsql
--

COMMENT ON FUNCTION af_get_question_reponse_association_elements(integer) IS 'Obtenir les éléments associés à un question_reponse.';


--
-- TOC entry 1212 (class 1255 OID 2596029)
-- Dependencies: 2983 5
-- Name: af_get_question_reponse_choix(integer); Type: FUNCTION; Schema: contraintes; Owner: pgsql
--

CREATE FUNCTION af_get_question_reponse_choix(integer) RETURNS SETOF record
    AS $_$DECLARE
--$1 question_reponse
rec RECORD;
BEGIN
	FOR rec IN
		SELECT C_id.id  , R.libelle, R.interpretation_html ,C.question_reponse, C.bareme, C.pere ,M.media, M.hauteur, M.largeur 
		FROM (contraintes.choix C INNER JOIN 
		contraintes.af_gen_get_elements('contraintes.choix', 'id', NULL, 'AND question_reponse='||$1,0 ) C_id 
		ON C_id.id= C.id)
		LEFT OUTER JOIN contraintes.media_question_reponse_element M 
		ON C_id.id=M.question_reponse_element AND M.question_reponse=$1
		LEFT OUTER JOIN contraintes.question_reponse_element R
		ON R.id=C_id.id
		ORDER BY C_id.ind
	LOOP
		RETURN NEXT rec;
	END LOOP;


	RETURN;
END$_$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_get_question_reponse_choix(integer) OWNER TO pgsql;

--
-- TOC entry 1213 (class 1255 OID 2596030)
-- Dependencies: 2983 5
-- Name: af_get_question_reponse_element(integer); Type: FUNCTION; Schema: contraintes; Owner: postgres
--

CREATE FUNCTION af_get_question_reponse_element(integer) RETURNS record
    AS $_$declare 
rec record;
begin
	
	select INTO rec id,libelle,interpretation_html, "type", reponse from contraintes.question_reponse_element 
	where id=$1;
	
	return rec;
end;$_$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_get_question_reponse_element(integer) OWNER TO postgres;

--
-- TOC entry 7941 (class 0 OID 0)
-- Dependencies: 1213
-- Name: FUNCTION af_get_question_reponse_element(integer); Type: COMMENT; Schema: contraintes; Owner: postgres
--

COMMENT ON FUNCTION af_get_question_reponse_element(integer) IS 'FONCTION PRIVEE: Obtenir las enregistrements de la table question_reponse_element pour un type donnÃ©';


--
-- TOC entry 1214 (class 1255 OID 2596031)
-- Dependencies: 2983 5
-- Name: af_get_question_reponse_element_evaluations(integer); Type: FUNCTION; Schema: contraintes; Owner: pgsql
--

CREATE FUNCTION af_get_question_reponse_element_evaluations(integer) RETURNS SETOF record
    AS $_$DECLARE
rec RECORD;
BEGIN

	FOR rec IN
		SELECT DISTINCT E.id, E.libelle, E.type FROM contraintes.question_reponse_elements QR,
		contraintes.evaluation E
		--WHERE (QR.question=$1 OR QR.reponse=$1)
		WHERE (QR.question_reponse_element=$1)
		AND E.id=QR.question_reponse
	LOOP
		RETURN NEXT rec;
	END LOOP;

	RETURN;
END$_$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_get_question_reponse_element_evaluations(integer) OWNER TO pgsql;

--
-- TOC entry 7943 (class 0 OID 0)
-- Dependencies: 1214
-- Name: FUNCTION af_get_question_reponse_element_evaluations(integer); Type: COMMENT; Schema: contraintes; Owner: pgsql
--

COMMENT ON FUNCTION af_get_question_reponse_element_evaluations(integer) IS 'obtenir les evaluations utilisées par un question_reponse_element.';


--
-- TOC entry 1215 (class 1255 OID 2596032)
-- Dependencies: 2983 5
-- Name: af_get_question_reponse_element_media(integer, integer); Type: FUNCTION; Schema: contraintes; Owner: pgsql
--

CREATE FUNCTION af_get_question_reponse_element_media(integer, integer) RETURNS record
    AS $_$DECLARE
--$1 idenfifiant du question reponse
--$2 idenfifiant du question reponse element
rec RECORD;
libelle_media character varying;
BEGIN
	SELECT INTO rec question_reponse, question_reponse_element, media, CAST( NULL AS varchar) AS libelle, hauteur, largeur 
	FROM contraintes.af_get_question_reponse_elements_media($1) AS (question_reponse int4, question_reponse_element int4, media int4, flash int4, hauteur int4, largeur int4)
	WHERE question_reponse_element=$2;

	SELECT INTO libelle_media libelle FROM contraintes.af_get_fichier(rec.media) AS ( id int4, libelle varchar, "type" int4, connecte bool);

	rec.libelle:= libelle_media;

	RETURN rec;
END$_$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_get_question_reponse_element_media(integer, integer) OWNER TO pgsql;

--
-- TOC entry 7945 (class 0 OID 0)
-- Dependencies: 1215
-- Name: FUNCTION af_get_question_reponse_element_media(integer, integer); Type: COMMENT; Schema: contraintes; Owner: pgsql
--

COMMENT ON FUNCTION af_get_question_reponse_element_media(integer, integer) IS 'Obtenir le media d''un question_reponse_element pour un question_reponse.';


--
-- TOC entry 1216 (class 1255 OID 2596033)
-- Dependencies: 2983 5
-- Name: af_get_question_reponse_element_media(integer); Type: FUNCTION; Schema: contraintes; Owner: pgsql
--

CREATE FUNCTION af_get_question_reponse_element_media(integer) RETURNS record
    AS $_$DECLARE
--$1 idenfifiant du question reponse element
rec RECORD;
BEGIN
	SELECT INTO rec  question_reponse, question_reponse_element, media, media, hauteur, largeur 
	FROM contraintes.media_question_reponse_element, contraintes.question Q
	WHERE question_reponse_element=$1
	AND question_reponse_element=Q.id;

	RETURN rec;
END$_$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_get_question_reponse_element_media(integer) OWNER TO pgsql;

--
-- TOC entry 7947 (class 0 OID 0)
-- Dependencies: 1216
-- Name: FUNCTION af_get_question_reponse_element_media(integer); Type: COMMENT; Schema: contraintes; Owner: pgsql
--

COMMENT ON FUNCTION af_get_question_reponse_element_media(integer) IS 'Obtenir le media d''un question_reponse_element.
Le question_reponse_element doit etre une question.';


--
-- TOC entry 1217 (class 1255 OID 2596034)
-- Dependencies: 2983 5
-- Name: af_get_question_reponse_elements(); Type: FUNCTION; Schema: contraintes; Owner: postgres
--

CREATE FUNCTION af_get_question_reponse_elements() RETURNS SETOF record
    AS $$DECLARE
rec RECORD;
BEGIN
	FOR rec IN
		SELECT * FROM contraintes.question_reponse_element
	LOOP
		RETURN NEXT rec;
	END LOOP;

	RETURN;

END;$$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_get_question_reponse_elements() OWNER TO postgres;

--
-- TOC entry 7949 (class 0 OID 0)
-- Dependencies: 1217
-- Name: FUNCTION af_get_question_reponse_elements(); Type: COMMENT; Schema: contraintes; Owner: postgres
--

COMMENT ON FUNCTION af_get_question_reponse_elements() IS 'FONCTION PRIVEE: Obtenir les enregistrements de la table question_reponse_element';


--
-- TOC entry 1218 (class 1255 OID 2596035)
-- Dependencies: 2983 5
-- Name: af_get_question_reponse_elements(integer); Type: FUNCTION; Schema: contraintes; Owner: postgres
--

CREATE FUNCTION af_get_question_reponse_elements(integer) RETURNS SETOF record
    AS $_$declare 
rec record;
begin
	for rec in
		select id,libelle,interpretation_html,type,reponse from contraintes.question_reponse_element 
		--select * from contraintes.question_reponse_element 
		where type=$1
	loop
		return next rec;
	end loop;
	return;
end;$_$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_get_question_reponse_elements(integer) OWNER TO postgres;

--
-- TOC entry 7951 (class 0 OID 0)
-- Dependencies: 1218
-- Name: FUNCTION af_get_question_reponse_elements(integer); Type: COMMENT; Schema: contraintes; Owner: postgres
--

COMMENT ON FUNCTION af_get_question_reponse_elements(integer) IS 'FONCTION PRIVEE: Obtenir las enregistrements de la table question_reponse_element pour un type donnÃ©';


--
-- TOC entry 1219 (class 1255 OID 2596036)
-- Dependencies: 2983 5
-- Name: af_get_question_reponse_elements(integer, boolean); Type: FUNCTION; Schema: contraintes; Owner: pgsql
--

CREATE FUNCTION af_get_question_reponse_elements(integer, boolean) RETURNS SETOF record
    AS $_$DECLARE
--$1 le numero de question_réponse
--$2 question ou réponse?
rec RECORD;
cond varchar;
BEGIN
   if $2 is true then
	cond:=' is true ';
   else
	cond:=' is false ';
   end if; 
   FOR rec IN
    /*
 
	SELECT DISTINCT Q.id,Q.libelle,Q.interpretation_html,Q.type, Q.reponse, CASE WHEN Q.reponse IS FALSE THEN O_id.ind ELSE NULL END AS ind 
	FROM contraintes.question_reponse_elements E 
	LEFT OUTER JOIN contraintes.question_reponse_element Q ON (E.question=Q.id OR E.Reponse=Q.id)
	LEFT OUTER JOIN contraintes.af_gen_get_elements('contraintes.question_reponse_elements', 'question', NULL, 'AND question_reponse='||$1 , 0) O_id
	ON (O_id.id=E.question)
	WHERE E.question_reponse=$1
	AND Q.reponse=$2
	ORDER BY ind
    */

    SELECT DISTINCT Q.id,Q.libelle,Q.interpretation_html,Q.type, Q.reponse, 
    --CASE WHEN Q.reponse IS FALSE THEN O_id.ind ELSE O_id.ind END AS ind 
    O_id.ind as ind
    FROM contraintes.question_reponse_elements E 
    LEFT OUTER JOIN contraintes.question_reponse_element Q ON (E.question_reponse_element=Q.id)
    LEFT OUTER JOIN contraintes.af_gen_get_elements('contraintes.question_reponse_elements', 'question_reponse_element', NULL, 'AND question_reponse='||$1||'and question_reponse_element in (select id from contraintes.question_reponse_element where reponse'||cond||')' , 0) O_id
    ON (O_id.id=E.question_reponse_element)
    WHERE E.question_reponse=$1
    AND Q.reponse=$2
    ORDER BY ind
	LOOP
		RETURN NEXT rec;
	END LOOP; 
	
END$_$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_get_question_reponse_elements(integer, boolean) OWNER TO pgsql;

--
-- TOC entry 7953 (class 0 OID 0)
-- Dependencies: 1219
-- Name: FUNCTION af_get_question_reponse_elements(integer, boolean); Type: COMMENT; Schema: contraintes; Owner: pgsql
--

COMMENT ON FUNCTION af_get_question_reponse_elements(integer, boolean) IS 'Obtenir les informations des question_reponse_elements pour un question réponse.';


--
-- TOC entry 1220 (class 1255 OID 2596037)
-- Dependencies: 2983 5
-- Name: af_get_question_reponse_elements_infos(integer, integer, boolean); Type: FUNCTION; Schema: contraintes; Owner: pgsql
--

CREATE FUNCTION af_get_question_reponse_elements_infos(integer, integer, boolean) RETURNS SETOF record
    AS $_$DECLARE
--$1 le numero de question_réponse
--$2 le type de question réponse
--$3 question ou réponse?
rec RECORD;

BEGIN
	
	/*
	FOR rec IN
		SELECT DISTINCT id , libelle , interpretation_html , $2, reponse 
		FROM contraintes.af_get_question_reponse_association_elements($1) AS (E_question_reponse int4, E_question int4, E_reponse int4, E_pere int4),
		contraintes.af_get_question_reponse_elements($2) AS (id int4, libelle varchar, interpretation_html boolean,type integer, reponse boolean)
		WHERE (id=E_question
		OR id=E_reponse)
		AND reponse=$3
	*/
	
	
	FOR rec IN
		SELECT DISTINCT id , libelle , interpretation_html , $2, reponse 
		FROM contraintes.af_get_question_reponse_association_elements($1) AS (E_question_reponse int4, E_question_reponse_element int4, E_pere int4),
		contraintes.af_get_question_reponse_elements($2) AS (id int4, libelle varchar, interpretation_html boolean,type integer, reponse boolean)
		WHERE id=E_question_reponse_element 
		--OR id=E_question_reponse_element)
		AND reponse=$3

	LOOP
		RETURN NEXT rec;
	END LOOP;
	
END$_$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_get_question_reponse_elements_infos(integer, integer, boolean) OWNER TO pgsql;

--
-- TOC entry 7955 (class 0 OID 0)
-- Dependencies: 1220
-- Name: FUNCTION af_get_question_reponse_elements_infos(integer, integer, boolean); Type: COMMENT; Schema: contraintes; Owner: pgsql
--

COMMENT ON FUNCTION af_get_question_reponse_elements_infos(integer, integer, boolean) IS 'Obtenir les informations des question_reponse_elements.';


--
-- TOC entry 1221 (class 1255 OID 2596038)
-- Dependencies: 2983 5
-- Name: af_get_question_reponse_elements_media(integer); Type: FUNCTION; Schema: contraintes; Owner: pgsql
--

CREATE FUNCTION af_get_question_reponse_elements_media(integer) RETURNS SETOF record
    AS $_$DECLARE
--$1 idenfifiant du question reponse element
rec RECORD;
BEGIN
	FOR rec IN
		SELECT  question_reponse, question_reponse_element, media, media, hauteur, largeur FROM contraintes.media_question_reponse_element
		WHERE question_reponse=$1
	LOOP
		RETURN NEXT rec;
	END LOOP;

	RETURN;
END$_$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_get_question_reponse_elements_media(integer) OWNER TO pgsql;

--
-- TOC entry 7957 (class 0 OID 0)
-- Dependencies: 1221
-- Name: FUNCTION af_get_question_reponse_elements_media(integer); Type: COMMENT; Schema: contraintes; Owner: pgsql
--

COMMENT ON FUNCTION af_get_question_reponse_elements_media(integer) IS 'Obtenir les medias de tous les question_reponse_elements.';


--
-- TOC entry 25 (class 1255 OID 2596039)
-- Dependencies: 2983 5
-- Name: af_get_question_reponse_last_reponse(integer); Type: FUNCTION; Schema: contraintes; Owner: pgsql
--

CREATE FUNCTION af_get_question_reponse_last_reponse(integer) RETURNS record
    AS $_$-- $1 : question_reponse
declare
rec record;
begin
    select into rec * from 
    contraintes.af_gen_get_last_element('contraintes.question_reponse_elements', 'question_reponse_element',' AND question_reponse='||$1||' and question_reponse_element in (select id from contraintes.question_reponse_element where reponse is true)');
    return rec;
end;$_$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_get_question_reponse_last_reponse(integer) OWNER TO pgsql;

--
-- TOC entry 7959 (class 0 OID 0)
-- Dependencies: 25
-- Name: FUNCTION af_get_question_reponse_last_reponse(integer); Type: COMMENT; Schema: contraintes; Owner: pgsql
--

COMMENT ON FUNCTION af_get_question_reponse_last_reponse(integer) IS 'retourne la dernière reponse d''un question_reponse';


--
-- TOC entry 1222 (class 1255 OID 2596040)
-- Dependencies: 2983 5
-- Name: af_get_question_reponse_media(integer); Type: FUNCTION; Schema: contraintes; Owner: pgsql
--

CREATE FUNCTION af_get_question_reponse_media(integer) RETURNS record
    AS $_$DECLARE
--$1 idenfifiant du question reponse
rec RECORD;
BEGIN
	SELECT INTO rec  question_reponse, media, media, hauteur, largeur FROM contraintes.media_question_reponse
	WHERE question_reponse=$1;

	RETURN rec;
END$_$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_get_question_reponse_media(integer) OWNER TO pgsql;

--
-- TOC entry 7961 (class 0 OID 0)
-- Dependencies: 1222
-- Name: FUNCTION af_get_question_reponse_media(integer); Type: COMMENT; Schema: contraintes; Owner: pgsql
--

COMMENT ON FUNCTION af_get_question_reponse_media(integer) IS 'Obtenir le media d''un question_reponse.';


--
-- TOC entry 1223 (class 1255 OID 2596041)
-- Dependencies: 2983 5
-- Name: af_get_question_reponse_questions(integer); Type: FUNCTION; Schema: contraintes; Owner: pgsql
--

CREATE FUNCTION af_get_question_reponse_questions(integer) RETURNS SETOF integer
    AS $_$DECLARE
--$1 numero de question_reponse
rec RECORD;
BEGIN
	FOR rec IN
		/*
		SELECT DISTINCT question FROM contraintes.question_reponse_elements
		WHERE question_reponse=$1
		*/
		SELECT DISTINCT question_reponse_element FROM contraintes.question_reponse_elements
		WHERE question_reponse=$1 
		and question_reponse_element in (select id from contraintes.question_reponse_element where reponse is false)
	LOOP
		RETURN NEXT rec.question_reponse_element;
	END LOOP;

	RETURN;
END$_$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_get_question_reponse_questions(integer) OWNER TO pgsql;

--
-- TOC entry 7963 (class 0 OID 0)
-- Dependencies: 1223
-- Name: FUNCTION af_get_question_reponse_questions(integer); Type: COMMENT; Schema: contraintes; Owner: pgsql
--

COMMENT ON FUNCTION af_get_question_reponse_questions(integer) IS 'Obtenir les questions d''un question_reponse.';


--
-- TOC entry 1224 (class 1255 OID 2596042)
-- Dependencies: 2983 5
-- Name: af_get_question_reponse_solution(integer, integer); Type: FUNCTION; Schema: contraintes; Owner: pgsql
--

CREATE FUNCTION af_get_question_reponse_solution(integer, integer) RETURNS record
    AS $_$DECLARE
rec RECORD;
BEGIN
	SELECT INTO rec question_reponse, question,reponse,juste 
	FROM contraintes.qcm_elements
	WHERE question_reponse=$1
	AND reponse=$2;

	RETURN rec;
END$_$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_get_question_reponse_solution(integer, integer) OWNER TO pgsql;

--
-- TOC entry 7965 (class 0 OID 0)
-- Dependencies: 1224
-- Name: FUNCTION af_get_question_reponse_solution(integer, integer); Type: COMMENT; Schema: contraintes; Owner: pgsql
--

COMMENT ON FUNCTION af_get_question_reponse_solution(integer, integer) IS 'Obtenir la solution d''une reponse à un qcm.';


--
-- TOC entry 1225 (class 1255 OID 2596043)
-- Dependencies: 2983 5
-- Name: af_get_question_reponse_solutions(integer); Type: FUNCTION; Schema: contraintes; Owner: postgres
--

CREATE FUNCTION af_get_question_reponse_solutions(integer) RETURNS SETOF record
    AS $_$declare
rec record;
begin
	for rec in
	select question_reponse, question,reponse,juste from contraintes.qcm_elements where question_reponse=$1
	loop
		return next rec;
	end loop;
	return;
end;$_$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_get_question_reponse_solutions(integer) OWNER TO postgres;

--
-- TOC entry 7967 (class 0 OID 0)
-- Dependencies: 1225
-- Name: FUNCTION af_get_question_reponse_solutions(integer); Type: COMMENT; Schema: contraintes; Owner: postgres
--

COMMENT ON FUNCTION af_get_question_reponse_solutions(integer) IS 'Obtenir les reponses d''une question de qcm pour une question donnÃ©es (auteur : Said, modifiÃ©e par rÃ©mi)';


--
-- TOC entry 1226 (class 1255 OID 2596044)
-- Dependencies: 2983 5
-- Name: af_get_questions(); Type: FUNCTION; Schema: contraintes; Owner: postgres
--

CREATE FUNCTION af_get_questions() RETURNS SETOF record
    AS $$declare
rec record;
begin
	
	for rec in 
		select E_id,E_libelle,E_interpretation_html,E_type  from contraintes.af_get_question_reponse_elements() as (E_id int4,E_libelle varchar,E_interpretation_html bool,E_type int4,E_reponse bool), 
		contraintes.question Q  
		where Q.id=E_id
	loop
		return next rec;
	end loop;
	return;
end;$$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_get_questions() OWNER TO postgres;

--
-- TOC entry 7969 (class 0 OID 0)
-- Dependencies: 1226
-- Name: FUNCTION af_get_questions(); Type: COMMENT; Schema: contraintes; Owner: postgres
--

COMMENT ON FUNCTION af_get_questions() IS 'Obtenir les questions.';


--
-- TOC entry 1227 (class 1255 OID 2596045)
-- Dependencies: 2983 5
-- Name: af_get_reponse(integer); Type: FUNCTION; Schema: contraintes; Owner: postgres
--

CREATE FUNCTION af_get_reponse(integer) RETURNS record
    AS $_$declare
rec record;
begin
	select into rec E_id,E_libelle,E_interpretation_html,E_type from contraintes.af_get_reponses() as (E_id int4,E_libelle varchar,E_interpretation_html bool,E_type int4) where E_id=$1;
	return rec;
end;$_$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_get_reponse(integer) OWNER TO postgres;

--
-- TOC entry 7971 (class 0 OID 0)
-- Dependencies: 1227
-- Name: FUNCTION af_get_reponse(integer); Type: COMMENT; Schema: contraintes; Owner: postgres
--

COMMENT ON FUNCTION af_get_reponse(integer) IS 'Obtenir les informations d''une reponse donnÃ©e (auteur : Said)';


--
-- TOC entry 1228 (class 1255 OID 2596046)
-- Dependencies: 2983 5
-- Name: af_get_reponse_question_reponse_resultats(integer); Type: FUNCTION; Schema: contraintes; Owner: pgsql
--

CREATE FUNCTION af_get_reponse_question_reponse_resultats(integer) RETURNS SETOF record
    AS $_$-- $1 : reponse
declare
rec record;
begin
    for rec in
	select * from contraintes.resultat_serie_question_reponse where reponse=$1
    loop
	return next rec;
    end loop;
end;$_$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_get_reponse_question_reponse_resultats(integer) OWNER TO pgsql;

--
-- TOC entry 7973 (class 0 OID 0)
-- Dependencies: 1228
-- Name: FUNCTION af_get_reponse_question_reponse_resultats(integer); Type: COMMENT; Schema: contraintes; Owner: pgsql
--

COMMENT ON FUNCTION af_get_reponse_question_reponse_resultats(integer) IS 'retourne les resultats pour une reponse de question_reponse';


--
-- TOC entry 1229 (class 1255 OID 2596047)
-- Dependencies: 2983 5
-- Name: af_get_reponses(); Type: FUNCTION; Schema: contraintes; Owner: postgres
--

CREATE FUNCTION af_get_reponses() RETURNS SETOF record
    AS $$DECLARE
rec RECORD;
BEGIN
	FOR rec IN
		select  E_id,E_libelle,E_interpretation_html,E_type from contraintes.reponse R, 
		contraintes.af_get_question_reponse_elements() as (E_id int4,E_libelle varchar,E_interpretation_html bool, E_type int4,E_reponse bool)
		where R.id=E_id
	LOOP
		RETURN NEXT rec;
	END LOOP;

	RETURN;

END;$$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_get_reponses() OWNER TO postgres;

--
-- TOC entry 7975 (class 0 OID 0)
-- Dependencies: 1229
-- Name: FUNCTION af_get_reponses(); Type: COMMENT; Schema: contraintes; Owner: postgres
--

COMMENT ON FUNCTION af_get_reponses() IS 'Obtenir les réponses.';


--
-- TOC entry 1230 (class 1255 OID 2596048)
-- Dependencies: 2983 5
-- Name: af_get_reponses(integer); Type: FUNCTION; Schema: contraintes; Owner: postgres
--

CREATE FUNCTION af_get_reponses(integer) RETURNS SETOF record
    AS $_$DECLARE
rec RECORD;
BEGIN
	FOR rec IN
		select  E.id, libelle, interpretation_html, type from contraintes.reponse R, contraintes.af_get_question_reponse_elements($1) E
		where R.id=E.id
	LOOP
		RETURN NEXT rec;
	END LOOP;

	RETURN;

END;$_$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_get_reponses(integer) OWNER TO postgres;

--
-- TOC entry 7977 (class 0 OID 0)
-- Dependencies: 1230
-- Name: FUNCTION af_get_reponses(integer); Type: COMMENT; Schema: contraintes; Owner: postgres
--

COMMENT ON FUNCTION af_get_reponses(integer) IS 'Obtenir toutes les reponses d''un type donnÃ©.';


--
-- TOC entry 1231 (class 1255 OID 2596049)
-- Dependencies: 2983 5
-- Name: af_get_ressource(integer); Type: FUNCTION; Schema: contraintes; Owner: pgsql
--

CREATE FUNCTION af_get_ressource(integer) RETURNS record
    AS $_$-- $1 : ressource
declare
rec record;
begin
    select into rec r.id,e.libelle,fichier,mots_cles, er.id 
	from contraintes.ressource r,contraintes.etape_ressource er, contraintes.etape e
     where r.id=$1 and r.id=ressource AND e.id=er.id;
    return rec;
end;$_$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_get_ressource(integer) OWNER TO pgsql;

--
-- TOC entry 7979 (class 0 OID 0)
-- Dependencies: 1231
-- Name: FUNCTION af_get_ressource(integer); Type: COMMENT; Schema: contraintes; Owner: pgsql
--

COMMENT ON FUNCTION af_get_ressource(integer) IS 'retourne les infos ressource';


--
-- TOC entry 1232 (class 1255 OID 2596050)
-- Dependencies: 2983 5
-- Name: af_get_resultat(integer, integer, integer, integer); Type: FUNCTION; Schema: contraintes; Owner: pgsql
--

CREATE FUNCTION af_get_resultat(integer, integer, integer, integer) RETURNS record
    AS $_$DECLARE
--$1 formation
--$2 stagiaire
--$3 parcours
--$4 etape
rec RECORD;
BEGIN
	SELECT INTO rec id,formation, stagiaire, parcours, etape, date_debut, duree
	FROM contraintes.resultat
	WHERE formation=$1
	AND stagiaire=$2
	AND parcours=$3
	AND etape=$4;

	RETURN rec;
END;$_$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_get_resultat(integer, integer, integer, integer) OWNER TO pgsql;

--
-- TOC entry 1233 (class 1255 OID 2596051)
-- Dependencies: 2983 5
-- Name: af_get_resultat(bigint); Type: FUNCTION; Schema: contraintes; Owner: pgsql
--

CREATE FUNCTION af_get_resultat(bigint) RETURNS record
    AS $_$DECLARE
--$1 resultat
rec RECORD;
BEGIN
	SELECT INTO rec id,formation, stagiaire, parcours, etape, date_debut, duree
	FROM contraintes.resultat
	WHERE id=$1;

	RETURN rec;
END;$_$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_get_resultat(bigint) OWNER TO pgsql;

--
-- TOC entry 1234 (class 1255 OID 2596052)
-- Dependencies: 2983 5
-- Name: af_get_resultat_etape_tentative(bigint); Type: FUNCTION; Schema: contraintes; Owner: pgsql
--

CREATE FUNCTION af_get_resultat_etape_tentative(bigint) RETURNS SETOF record
    AS $_$-- $1 : id resultat
declare
rec record;
rec_resultat record;
begin
    -- Initialisation 
    -- recup des paramètres du resultat
    select into rec_resultat * from contraintes.af_get_resultat($1)
    as  (id bigint,formation integer,stagiaire integer,parcours integer,etape integer,date_debut timestamp, duree interval);
    if rec_resultat.id is null then
	select into rec_resultat * from contraintes.af_get_resultat_tentative($1)  
	as  (id bigint,formation integer,stagiaire integer,parcours integer,etape integer,date_debut timestamp, duree interval,tentative integer);
    end if;
    -- boucle sur les resultats stockés
    for rec in 
	select id,formation,stagiaire,parcours,etape,date_debut,duree,tentative from contraintes.resultat_tentative 
	where formation=rec_resultat.formation 
	and stagiaire=rec_resultat.stagiaire 
	and parcours=rec_resultat.parcours 
	and etape=rec_resultat.etape

    loop
	return next rec;
    end loop;
end;$_$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_get_resultat_etape_tentative(bigint) OWNER TO pgsql;

--
-- TOC entry 7983 (class 0 OID 0)
-- Dependencies: 1234
-- Name: FUNCTION af_get_resultat_etape_tentative(bigint); Type: COMMENT; Schema: contraintes; Owner: pgsql
--

COMMENT ON FUNCTION af_get_resultat_etape_tentative(bigint) IS 'retourne les tentatives deja effectuées';


--
-- TOC entry 1861 (class 1255 OID 2596053)
-- Dependencies: 2983 5
-- Name: af_get_resultat_exotlc(bigint); Type: FUNCTION; Schema: contraintes; Owner: pgsql
--

CREATE FUNCTION af_get_resultat_exotlc(bigint) RETURNS SETOF record
    AS $_$DECLARE
--$1 resultat
rec RECORD;
BEGIN
	FOR rec IN 
		SELECT R_id,R_formation,R_stagiaire, R_parcours, R_etape, R_date_debut, R_duree, commentaire, correction, fichier_rendu, date_correction 
		FROM contraintes.af_get_resultat($1) AS (R_id int8,R_formation int4,R_stagiaire int4, R_parcours int4, R_etape int4, R_date_debut timestamp, R_duree interval)
		LEFT OUTER JOIN contraintes.resultat_exotlc RE ON( R_id=RE.id)
	LOOP
		RETURN NEXT rec;
	END LOOP;
	RETURN ;
END;$_$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_get_resultat_exotlc(bigint) OWNER TO pgsql;

--
-- TOC entry 1862 (class 1255 OID 2596054)
-- Dependencies: 2983 5
-- Name: af_get_resultat_exotlc_critere(bigint, integer); Type: FUNCTION; Schema: contraintes; Owner: pgsql
--

CREATE FUNCTION af_get_resultat_exotlc_critere(bigint, integer) RETURNS record
    AS $_$-- $1 : id resultat
-- $2 : critere
declare
rec record;
begin
    select into rec id,critere,note,note_max,commentaire 
    from contraintes.resultat_exotlc_critere 
    where id=$1 and critere=$2;
    return rec;
end;$_$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_get_resultat_exotlc_critere(bigint, integer) OWNER TO pgsql;

--
-- TOC entry 7986 (class 0 OID 0)
-- Dependencies: 1862
-- Name: FUNCTION af_get_resultat_exotlc_critere(bigint, integer); Type: COMMENT; Schema: contraintes; Owner: pgsql
--

COMMENT ON FUNCTION af_get_resultat_exotlc_critere(bigint, integer) IS 'retourne le resultat d''un critere pour un identifiant de resultat';


--
-- TOC entry 1235 (class 1255 OID 2596055)
-- Dependencies: 2983 5
-- Name: af_get_resultat_exotlc_critere_sous_criteres(bigint, integer); Type: FUNCTION; Schema: contraintes; Owner: pgsql
--

CREATE FUNCTION af_get_resultat_exotlc_critere_sous_criteres(bigint, integer) RETURNS SETOF record
    AS $_$-- $1 : id resultat
-- $2 : critere
declare
rec record;
begin
    for rec in
	select id_sc,$2,sous_critere,libelle_sc,note,note_max 
	from contraintes.af_get_resultat_exotlc_sous_criteres($1) as (id_sc int8,sous_critere int4,libelle_sc varchar,note int4,note_max int4),
	contraintes.af_get_critere_sous_criteres($2) as (id int4,libelle varchar,theme int4,pere int4)
	where sous_critere=id
	
    loop
	return next rec;
    end loop;
end;
$_$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_get_resultat_exotlc_critere_sous_criteres(bigint, integer) OWNER TO pgsql;

--
-- TOC entry 7988 (class 0 OID 0)
-- Dependencies: 1235
-- Name: FUNCTION af_get_resultat_exotlc_critere_sous_criteres(bigint, integer); Type: COMMENT; Schema: contraintes; Owner: pgsql
--

COMMENT ON FUNCTION af_get_resultat_exotlc_critere_sous_criteres(bigint, integer) IS 'retourne les resultats des sous criteres d''un exotlc pour un identifiant de resultat et un critere';


--
-- TOC entry 1236 (class 1255 OID 2596056)
-- Dependencies: 2983 5
-- Name: af_get_resultat_exotlc_criteres(bigint); Type: FUNCTION; Schema: contraintes; Owner: pgsql
--

CREATE FUNCTION af_get_resultat_exotlc_criteres(bigint) RETURNS SETOF record
    AS $_$-- $1 : id resultat
declare
rec record;
begin
    for rec in 
	select R.id, R.critere, C.libelle, note, note_max, commentaire from contraintes.resultat_exotlc_critere R,
	contraintes.critere C
	where R.id=$1
	AND C.id=R.critere
    loop
	return next rec;
    end loop;
end;$_$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_get_resultat_exotlc_criteres(bigint) OWNER TO pgsql;

--
-- TOC entry 7990 (class 0 OID 0)
-- Dependencies: 1236
-- Name: FUNCTION af_get_resultat_exotlc_criteres(bigint); Type: COMMENT; Schema: contraintes; Owner: pgsql
--

COMMENT ON FUNCTION af_get_resultat_exotlc_criteres(bigint) IS 'retourne les resultats des criteres pour un identifiant de resultat';


--
-- TOC entry 1237 (class 1255 OID 2596057)
-- Dependencies: 2983 5
-- Name: af_get_resultat_exotlc_moyenne(bigint); Type: FUNCTION; Schema: contraintes; Owner: pgsql
--

CREATE FUNCTION af_get_resultat_exotlc_moyenne(bigint) RETURNS double precision
    AS $_$-- $1 : id resultat
declare
rec record;
ind integer:=0;
score double precision:=0;
begin 
    -- recup des notes des critere
    for rec in
	select * from contraintes.af_get_resultat_exotlc_criteres($1) as (id int8,critere int4,libelle varchar,note int4,note_max int4,commentaire text)
    loop
	if rec.note is not null and rec.note_max is not null then
	    ind:=ind+1;
	    score:=score + ((20*cast(rec.note as double precision))/cast(rec.note_max as double precision));
	end if;
    end loop;
    -- recup des note des sous criteres
    for rec in
	select * from contraintes.af_get_resultat_exotlc_sous_criteres($1) as (id int8,critere int4,libelle varchar,note int4,note_max int4)
    loop
	if rec.note is not null and rec.note_max is not null then
	    ind:=ind+1;
	    score:=score + ((20*cast(rec.note as double precision))/cast(rec.note_max as double precision));
	end if;
    end loop;
    return (score/ind);	
end;$_$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_get_resultat_exotlc_moyenne(bigint) OWNER TO pgsql;

--
-- TOC entry 7992 (class 0 OID 0)
-- Dependencies: 1237
-- Name: FUNCTION af_get_resultat_exotlc_moyenne(bigint); Type: COMMENT; Schema: contraintes; Owner: pgsql
--

COMMENT ON FUNCTION af_get_resultat_exotlc_moyenne(bigint) IS 'retourne la note general sur 20 pour un identifiant de resultat';


--
-- TOC entry 1238 (class 1255 OID 2596058)
-- Dependencies: 2983 5
-- Name: af_get_resultat_exotlc_sous_critere(bigint, integer); Type: FUNCTION; Schema: contraintes; Owner: pgsql
--

CREATE FUNCTION af_get_resultat_exotlc_sous_critere(bigint, integer) RETURNS record
    AS $_$-- $1 : id resultat
-- $2 : sous critere
declare
rec record;
begin
    select into rec R.id,R.sous_critere, C.libelle,R.note,R.note_max 
    from contraintes.resultat_exotlc_sous_critere R,contraintes.critere C
    where R.id=$1 and C.id=$2 
	AND sous_critere=C.id;
    return rec;
end;$_$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_get_resultat_exotlc_sous_critere(bigint, integer) OWNER TO pgsql;

--
-- TOC entry 7994 (class 0 OID 0)
-- Dependencies: 1238
-- Name: FUNCTION af_get_resultat_exotlc_sous_critere(bigint, integer); Type: COMMENT; Schema: contraintes; Owner: pgsql
--

COMMENT ON FUNCTION af_get_resultat_exotlc_sous_critere(bigint, integer) IS 'retourne les resultat pour un sous_critere';


--
-- TOC entry 1863 (class 1255 OID 2596059)
-- Dependencies: 2983 5
-- Name: af_get_resultat_exotlc_sous_criteres(bigint); Type: FUNCTION; Schema: contraintes; Owner: pgsql
--

CREATE FUNCTION af_get_resultat_exotlc_sous_criteres(bigint) RETURNS SETOF record
    AS $_$-- $1 : id resultat
declare
rec record;
begin
    for rec in
	select R.id, sous_critere,libelle, note, note_max from contraintes.resultat_exotlc_sous_critere R,
	contraintes.critere C
	where R.id=$1
	AND C.id=sous_critere
    loop
	return next rec;
    end loop;
end;$_$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_get_resultat_exotlc_sous_criteres(bigint) OWNER TO pgsql;

--
-- TOC entry 7996 (class 0 OID 0)
-- Dependencies: 1863
-- Name: FUNCTION af_get_resultat_exotlc_sous_criteres(bigint); Type: COMMENT; Schema: contraintes; Owner: pgsql
--

COMMENT ON FUNCTION af_get_resultat_exotlc_sous_criteres(bigint) IS 'retourne les resultats des sous criteres pour un identifiant de resultat';


--
-- TOC entry 1864 (class 1255 OID 2596060)
-- Dependencies: 2983 5
-- Name: af_get_resultat_formation(integer, integer, integer); Type: FUNCTION; Schema: contraintes; Owner: pgsql
--

CREATE FUNCTION af_get_resultat_formation(integer, integer, integer) RETURNS record
    AS $_$DECLARE
--$1 formation
--$2 individu
--$3 parcours (doit etre NULL à l'appel de la fonction, sert uniquement pour la recursivité)
id_parcours int4;
rec RECORD;
rec_p RECORD;
rec_pp RECORD;
id_resultat bigint; 
sous_parcours integer; 
BEGIN
	------------------------------
	--VERIFICATION DES PARAMETRES
	------------------------------
	IF $1 IS NULL OR $2 IS NULL THEN
		RAISE EXCEPTION 'La fonction n''accepte pas une formation (%) et/ou un individu(%) nulls',$1,$2;
	ELSE 
		RAISE NOTICE 'params f=% i=% p=%',$1,$2,$3;
	END IF;

	IF $3 IS NULL THEN
		--on récupère le parcours de la formation
		SELECT INTO id_parcours parcours FROM contraintes.af_get_formation($1) 
		AS (id int4, libelle varchar, parcours int4, date_debut date, date_fin date, langue int4,ressources_fusionnees boolean);
		
		IF id_parcours IS NULL THEN
			RAISE EXCEPTION 'Pas de parcours principal pour la formation';
		END IF;
 
		RAISE NOTICE 'Le parcours principal est le parcours n°%', id_parcours;	
	ELSE 
		id_parcours:=$3;
	END IF;
 
	------------------------------
	--AVANCEMENT PARCOURS APPELLE ($3 ou parcours principal)
	------------------------------

	--on recupere l'avancement max du parcours passé en argument
	SELECT INTO rec * FROM contraintes.af_get_formation_avancement_max_parcours($1, id_parcours, $2) AS (parcours int4, etape int4, type int4,formation int4, individu int4, date_debut timestamp, duree interval);
	--raise notice 'Type etape a suivre=%',rec.type;
 
	IF rec.type IS NULL THEN
		--raise notice 'ds le test du type avt retour (%)',rec.type;
		RETURN NULL;
	END IF;
	--raise notice 'ds le test du type apres retour';

	--si l'avancement max est un parcours  on recupere l'avancement max de ce dernier
	IF rec.type=1 THEN
		--RAISE NOTICE 'L''etape en cours est le parcours n°% de type% deb=%, d=%', rec.etape,rec.type, rec.date_debut,rec.duree  ;
		
		IF rec.date_debut IS NOT NULL THEN

			--IF rec.duree IS NULL THEN
				--RAISE NOTICE 'AAAA';
				--appel recursif: on réappel la fonction en changeant de parcours courant
				SELECT INTO rec_p * FROM contraintes.af_get_resultat_formation($1, $2,rec.etape) AS (parcours int4, etape int4,type int4, formation int4, individu int4, date_debut timestamp, duree interval);	
				--RAISE NOTICE 'AAAA L''etape du parcours trouvée:parcours(%) n°% de type% deb=%, d=%',rec_p.parcours, rec_p.etape,rec_p.type, rec_p.date_debut,rec_p.duree  ;
				
				--Si l'avancement max du nouveau parcours courant est null (ligne vide)
				IF rec_p.type IS NULL THEN
					RETURN rec;
				ELSE 
					RETURN rec_p;
				END IF;
					
		ELSE 
		
			RETURN rec;
		END IF;
	ELSE

			--RAISE EXCEPTION 'DANS LE ELSE';
		-- traitement etape parcours oriente
		if rec.type=10 THEN--and rec.date_debut IS NOT NULL 
			--recup sous parcours
			-- recup id_resultat
			--RAISE NOTICE 'parcours=% et etape=%', id_parcours,rec.etape;
			select into id_resultat id from contraintes.af_get_resultat($1,$2,id_parcours,rec.etape)
			AS (id bigint,formation int4, stagiaire int4, parcours int4, etape int4, date_debut timestamp, duree interval);
			--RAISE NOTICE 'id_resultat=%', id_resultat;
			if id_resultat is null then
			    --raise exception 'le parcours oriente pas commence';
			    return rec;
			end if;

			select into sous_parcours * from contraintes.af_get_resultat_parcours_parcours_oriente(id_resultat);
			--RAISE NOTICE 'sous_parcours=%', sous_parcours;
			select into rec_p * FROM contraintes.af_get_resultat_formation($1, $2,sous_parcours) AS (parcours int4, etape int4,type int4, formation int4, individu int4, date_debut timestamp, duree interval);	
			--Si l'avancement max du nouveau parcours courant est null (ligne vide)
				IF rec_p.type IS NULL THEN
					RETURN rec;
				ELSE 
					RETURN rec_p;
				END IF;
			
			
		else
			RETURN rec;
		end if;
		

		--RAISE NOTICE 'L''etape en cours est de type % n°%',rec.type, rec.etape;
		--
	    
		--RAISE NOTICE 'L''etape en cours est de type % n°%',rec.type, rec.etape;
		--RETURN rec;
	END IF;

END;$_$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_get_resultat_formation(integer, integer, integer) OWNER TO pgsql;

--
-- TOC entry 1239 (class 1255 OID 2596061)
-- Dependencies: 2983 5
-- Name: af_get_resultat_ftb_langue_ams_reponse(bigint, integer); Type: FUNCTION; Schema: contraintes; Owner: pgsql
--

CREATE FUNCTION af_get_resultat_ftb_langue_ams_reponse(bigint, integer) RETURNS record
    AS $_$-- $1 : resultat
-- $2 : ftb
declare
rec record;
lettre char;
rec_final record;
langue integer;
begin
    -- recup reponse
    select into  rec  
	RFTB.reponse FROM  contraintes.resultat_serie_ftb RFTB WHERE RFTB.ftb=$2 AND RFTB.id=$1;	
    -- la langue	
    lettre:=substring(rec.reponse from 6 for 1);
    langue:=cast(lettre as integer);
    raise notice 'lang=%',langue;	
end;$_$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_get_resultat_ftb_langue_ams_reponse(bigint, integer) OWNER TO pgsql;

--
-- TOC entry 7999 (class 0 OID 0)
-- Dependencies: 1239
-- Name: FUNCTION af_get_resultat_ftb_langue_ams_reponse(bigint, integer); Type: COMMENT; Schema: contraintes; Owner: pgsql
--

COMMENT ON FUNCTION af_get_resultat_ftb_langue_ams_reponse(bigint, integer) IS 'retourne pour un ftb corrigé la langue de sa reponse et sa reponse';


--
-- TOC entry 1240 (class 1255 OID 2596062)
-- Dependencies: 2983 5
-- Name: af_get_resultat_parcours_exotlcs_score_partiel(bigint); Type: FUNCTION; Schema: contraintes; Owner: pgsql
--

CREATE FUNCTION af_get_resultat_parcours_exotlcs_score_partiel(bigint) RETURNS real
    AS $_$-- $1 : id resultat
declare
rec record;
rec_resultat record;
total real;
res_exotlc real;
nb integer;
id_resultat bigint;
begin
    -- recup composants id resultat
    select into rec_resultat * from contraintes.af_get_resultat($1) 
    as (id bigint,  formation integer, stagiaire integer,parcours integer, etape integer,  date_debut timestamp, duree interval); 
    -- Initialisation
    total:=0;
    nb:=0;
    -- boucle sur les etapes du parcours
    for rec in 
	select * from contraintes.af_get_parcours_etapes(rec_resultat.parcours)
	AS (id int4, libelle varchar, libelle_bis varchar, libelle_alias  varchar, type varchar,  pere int4, parcours int4, obligatoire bool, chrono int4, fin bool, libelle_type_original varchar, modifiable bool)
    loop
	if rec.type='10' then
	    exit;
	end if;
	-- traitemement serie
    if rec.type ='5' and rec.obligatoire is true then
	-- recup id resultat
	select into id_resultat id from contraintes.af_get_resultat(rec_resultat.formation,rec_resultat.stagiaire,rec_resultat.parcours,rec.id)
	AS (id bigint,formation int4, stagiaire int4, parcours int4, etape int4, date_debut timestamp, duree interval);
	select into res_exotlc * from contraintes.af_get_resultat_exotlc_moyenne(id_resultat);
	total:=total+res_serie;
	nb:=nb+1;


    end if;

    end loop;
    if nb>0 then
	return total/nb;
    else
	return null;
    end if;

end;$_$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_get_resultat_parcours_exotlcs_score_partiel(bigint) OWNER TO pgsql;

--
-- TOC entry 8001 (class 0 OID 0)
-- Dependencies: 1240
-- Name: FUNCTION af_get_resultat_parcours_exotlcs_score_partiel(bigint); Type: COMMENT; Schema: contraintes; Owner: pgsql
--

COMMENT ON FUNCTION af_get_resultat_parcours_exotlcs_score_partiel(bigint) IS 'retourne le score aux exotlcs d''un parcours avant etape parcours oriente';


--
-- TOC entry 1241 (class 1255 OID 2596063)
-- Dependencies: 2983 5
-- Name: af_get_resultat_parcours_parcours_oriente(bigint); Type: FUNCTION; Schema: contraintes; Owner: pgsql
--

CREATE FUNCTION af_get_resultat_parcours_parcours_oriente(bigint) RETURNS integer
    AS $_$-- $1 : id resultat
declare
rec record;
rec2 record;
rec_resultat record;
seuil_individu real;
seuil_type real;
passage_type integer;
begin
    -- Initialisation
    -- recup param resultat
    select into rec_resultat * from contraintes.af_get_resultat($1) 
    as (id bigint,  formation integer, stagiaire integer,parcours integer, etape integer,  date_debut timestamp, duree interval); 
    -- recup score pour le parcours (avant l'etape parcours oriente)
    --select into seuil_individu * from contraintes.af_get_formation_individu_parcours_score(rec_resultat.formation,rec_resultat.stagiaire,rec_resultat.parcours);
    select into seuil_individu * from contraintes.af_get_resultat_parcours_score_partiel($1);
    -- boucle sur les sous parcours de la configuration de l'etape parcours oriente
    for rec in 
	select * from contraintes.af_get_parcours_oriente_sous_parcours(rec_resultat.etape)
	as (id integer,libelle varchar,filiere integer,ordre integer) order by ordre desc
    loop
	-- recup des seuils pour le sous parcours courant
	passage_type=0;
	for rec2 in 
	    select * from contraintes.af_get_parcours_oriente_configuration(rec_resultat.etape) 
	    as (etape integer,sous_parcours integer,type integer,seuil integer)
	    where sous_parcours=rec.id
	loop
	    if rec2.type =4 then
		-- recup score pour ce type
		select into seuil_type * from contraintes.af_get_formation_individu_parcours_series_score(rec_resultat.formation,rec_resultat.stagiaire,rec_resultat.parcours);
		if seuil_type<rec2.seuil then
		    exit;
		else
		    passage_type:=passage_type+1;
		end if;
	    else
		if rec2.type=5 then
		    -- recup score pour ce type
		    select into seuil_type * from contraintes.af_get_formation_individu_parcours_exotlcs_score(rec_resultat.formation,rec_resultat.stagiaire,rec_resultat.parcours);
		    if seuil_type<rec2.seuil then
		        exit;
		    else
			passage_type:=passage_type+1;
		    end if;
		else

		end if;
	    end if;

	end loop;
	if passage_type>0 then
	    return rec2.sous_parcours;
	else
	    if seuil_individu>rec2.seuil then
		return rec2.sous_parcours;
	    end if;	
	end if;
	
    end loop;
    return rec2.sous_parcours ;
end;$_$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_get_resultat_parcours_parcours_oriente(bigint) OWNER TO pgsql;

--
-- TOC entry 8003 (class 0 OID 0)
-- Dependencies: 1241
-- Name: FUNCTION af_get_resultat_parcours_parcours_oriente(bigint); Type: COMMENT; Schema: contraintes; Owner: pgsql
--

COMMENT ON FUNCTION af_get_resultat_parcours_parcours_oriente(bigint) IS 'retourne le numero du sous_parcours issu de la configuration de l''etape parcours_oriente et des resultat de l''individu';


--
-- TOC entry 1865 (class 1255 OID 2596064)
-- Dependencies: 2983 5
-- Name: af_get_resultat_parcours_score_partiel(bigint); Type: FUNCTION; Schema: contraintes; Owner: pgsql
--

CREATE FUNCTION af_get_resultat_parcours_score_partiel(bigint) RETURNS real
    AS $_$-- $1 : identifiant resultat
declare
rec record;
rec_resultat record;
id_resultat bigint;
total real;
res_serie real;
res_exotlc real;
nb integer;
begin
    -- recup des composant de l'identifiant résultat
    select into rec_resultat * from contraintes.af_get_resultat($1) 
    as (id bigint,  formation integer, stagiaire integer,parcours integer, etape integer,  date_debut timestamp, duree interval); 
    -- Initialisation
    total:=0;
    nb:=0;
    -- boucle sur les etapes du parcours
    for rec in 
	select * from contraintes.af_get_parcours_etapes(rec_resultat.parcours)
	AS (id int4, libelle varchar, libelle_bis varchar, libelle_alias  varchar, type varchar,  pere int4, parcours int4, obligatoire bool, chrono int4, fin bool, libelle_type_original varchar, modifiable bool)
    loop
	if rec.type='10' then
	    exit;
	end if;
	-- traitement serie
	if (rec.type like 4 || '%') then
	    -- recup identifiant resultat pour cette etape
	    select into id_resultat id from contraintes.af_get_resultat(rec_resultat.formation,rec_resultat.stagiaire,rec_resultat.parcours,rec.id)
	    AS (id bigint,formation int4, stagiaire int4, parcours int4, etape int4, date_debut timestamp, duree interval);
	    select into res_serie * from contraintes.af_get_resultat_serie_score(id_resultat);
	    total:=total+res_serie;
	    nb:=nb+1;

	end if;
	if rec.type='5' then
	    -- recup identifiant resultat pour cette etape
	    select into id_resultat id from contraintes.af_get_resultat(rec_resultat.formation,rec_resultat.stagiaire,rec_resultat.parcours,rec.id)
	    AS (id bigint,formation int4, stagiaire int4, parcours int4, etape int4, date_debut timestamp, duree interval);
	    select into res_exotlc * from contraintes.af_get_resultat_exotlc_moyenne(id_resultat);
	    total:=total+res_exotlc;
	    nb:=nb+1;
	end if;

    end loop;
    if nb>0 then
	return total/nb;
    else
	return null;
    end if;


end;$_$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_get_resultat_parcours_score_partiel(bigint) OWNER TO pgsql;

--
-- TOC entry 8005 (class 0 OID 0)
-- Dependencies: 1865
-- Name: FUNCTION af_get_resultat_parcours_score_partiel(bigint); Type: COMMENT; Schema: contraintes; Owner: pgsql
--

COMMENT ON FUNCTION af_get_resultat_parcours_score_partiel(bigint) IS 'retourne le score d''in individu pour un parcours avant l''etape parcours oriente';


--
-- TOC entry 1242 (class 1255 OID 2596065)
-- Dependencies: 2983 5
-- Name: af_get_resultat_parcours_series_score_partiel(bigint); Type: FUNCTION; Schema: contraintes; Owner: pgsql
--

CREATE FUNCTION af_get_resultat_parcours_series_score_partiel(bigint) RETURNS real
    AS $_$-- $1 : id resultat
declare
rec record;
rec_resultat record;
total real;
res_serie real;
nb integer;
id_resultat bigint;
begin
    -- recup composants id resultat
    select into rec_resultat * from contraintes.af_get_resultat($1) 
    as (id bigint,  formation integer, stagiaire integer,parcours integer, etape integer,  date_debut timestamp, duree interval); 
    -- Initialisation
    total:=0;
    nb:=0;
    -- boucle sur les etapes du parcours
    for rec in 
	select * from contraintes.af_get_parcours_etapes(rec_resultat.parcours)
	AS (id int4, libelle varchar, libelle_bis varchar, libelle_alias  varchar, type varchar,  pere int4, parcours int4, obligatoire bool, chrono int4, fin bool, libelle_type_original varchar, modifiable bool)
    loop
	if rec.type='10' then
	    exit;
	end if;
	-- traitemement serie
    if (rec.type like 4 || '%') and rec.type <> '4_1_0_2' and rec.obligatoire is true then
	-- recup id resultat
	select into id_resultat id from contraintes.af_get_resultat(rec_resultat.formation,rec_resultat.stagiaire,rec_resultat.parcours,rec.id)
	AS (id bigint,formation int4, stagiaire int4, parcours int4, etape int4, date_debut timestamp, duree interval);
	select into res_serie * from contraintes.af_get_resultat_serie_score(id_resultat);
	total:=total+res_serie;
	nb:=nb+1;


    end if;

    end loop;
    if nb>0 then
	return total/nb;
    else
	return null;
    end if;

end;$_$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_get_resultat_parcours_series_score_partiel(bigint) OWNER TO pgsql;

--
-- TOC entry 8007 (class 0 OID 0)
-- Dependencies: 1242
-- Name: FUNCTION af_get_resultat_parcours_series_score_partiel(bigint); Type: COMMENT; Schema: contraintes; Owner: pgsql
--

COMMENT ON FUNCTION af_get_resultat_parcours_series_score_partiel(bigint) IS 'retourne le score aux series d''un parcours avant etape parcours oriente';


--
-- TOC entry 1866 (class 1255 OID 2596066)
-- Dependencies: 2983 5
-- Name: af_get_resultat_serie_aleatoire_avancement_max(bigint); Type: FUNCTION; Schema: contraintes; Owner: pgsql
--

CREATE FUNCTION af_get_resultat_serie_aleatoire_avancement_max(bigint) RETURNS record
    AS $_$-- $1 : identifiant resultat
declare
rec RECORD;
resultat RECORD;
indice integer:=1;
BEGIN
	SELECT INTO resultat *
	FROM contraintes.af_get_resultat($1)  AS (id int8,formation int4, stagiaire int4, parcours int4, etape int4, date_debut timestamp, duree interval);

	
	IF resultat.etape IS NULL THEN
		RAISE EXCEPTION 'Erreur: ne peut determiner l''avancement d''une serie aleatoire sans son identifiant.';
	END IF;

	--selection de l'indice
	SELECT INTO indice MIN(elt2.ind) FROM contraintes.af_gen_get_elements('contraintes.serie_aleatoire_evaluations', 'evaluation', NULL, 'AND serie='||resultat.etape||' AND formation='||resultat.formation||' AND parcours='||resultat.parcours||' AND stagiaire='||resultat.stagiaire,0) elt2
	LEFT OUTER JOIN contraintes.resultat_serie R2 ON (R2.id = $1 AND evaluation=elt2.id)
	WHERE R2.id IS NULL;
	
	SELECT INTO rec resultat.id,resultat.formation , resultat.stagiaire , resultat.parcours, resultat.etape, E.id, E.type,elt.ind,cast(NULL as interval) as duree
	FROM contraintes.evaluation E ,contraintes.af_gen_get_elements('contraintes.serie_aleatoire_evaluations', 'evaluation', NULL, 'AND serie='||resultat.etape||' AND formation='||resultat.formation||' AND parcours='||resultat.parcours||' AND stagiaire='||resultat.stagiaire ,0) elt
	WHERE E.id=elt.id
	AND elt.ind = indice;
	
	select into rec.duree * from contraintes.af_get_resultat_serie_aleatoire_evaluations_duree_totale($1);
	--rec.duree:=10;
	RETURN rec; 
END; $_$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_get_resultat_serie_aleatoire_avancement_max(bigint) OWNER TO pgsql;

--
-- TOC entry 8009 (class 0 OID 0)
-- Dependencies: 1866
-- Name: FUNCTION af_get_resultat_serie_aleatoire_avancement_max(bigint); Type: COMMENT; Schema: contraintes; Owner: pgsql
--

COMMENT ON FUNCTION af_get_resultat_serie_aleatoire_avancement_max(bigint) IS 'retourne l''evaluation à faire d''une serie aleatoire';


--
-- TOC entry 1867 (class 1255 OID 2596067)
-- Dependencies: 2983 5
-- Name: af_get_resultat_serie_aleatoire_evaluation(bigint, integer); Type: FUNCTION; Schema: contraintes; Owner: pgsql
--

CREATE FUNCTION af_get_resultat_serie_aleatoire_evaluation(bigint, integer) RETURNS SETOF record
    AS $_$-- $1 : resultat
-- $2 : evaluation
declare
rec RECORD;
rec_resultat RECORD;
BEGIN
	SELECT INTO rec_resultat * FROM contraintes.af_get_resultat($1) AS (id int8,formation int4, stagiaire int4, parcours int4, etape int4, date_debut timestamp, duree interval);
	
	FOR rec IN 
		SELECT RS.id, RS.evaluation, RS.date_debut,s.bareme,s.chrono
		FROM contraintes.resultat_serie RS,
		contraintes.serie_aleatoire_evaluations SE,
		contraintes.serie s
		WHERE RS.id=$1
		AND RS.evaluation=$2
		AND SE.serie=rec_resultat.etape and formation=rec_resultat.formation 
		and parcours=rec_resultat.parcours and stagiaire=rec_resultat.stagiaire 
		AND SE.evaluation=RS.evaluation 
		and rec_resultat.etape=s.id
	LOOP
		RETURN NEXT rec;
	END LOOP;
	RETURN ;
END;$_$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_get_resultat_serie_aleatoire_evaluation(bigint, integer) OWNER TO pgsql;

--
-- TOC entry 8011 (class 0 OID 0)
-- Dependencies: 1867
-- Name: FUNCTION af_get_resultat_serie_aleatoire_evaluation(bigint, integer); Type: COMMENT; Schema: contraintes; Owner: pgsql
--

COMMENT ON FUNCTION af_get_resultat_serie_aleatoire_evaluation(bigint, integer) IS 'retourne le resultat d''une evaluation';


--
-- TOC entry 26 (class 1255 OID 2596068)
-- Dependencies: 2983 5
-- Name: af_get_resultat_serie_aleatoire_evaluations_duree_totale(bigint); Type: FUNCTION; Schema: contraintes; Owner: pgsql
--

CREATE FUNCTION af_get_resultat_serie_aleatoire_evaluations_duree_totale(bigint) RETURNS interval
    AS $_$DECLARE
duree_totale INTERVAL;
resultat RECORD;
BEGIN

	SELECT INTO resultat *
	FROM contraintes.af_get_resultat($1)  AS (id int8,formation int4, stagiaire int4, parcours int4, etape int4, date_debut timestamp, duree interval);

	IF resultat.etape IS NULL THEN
		RAISE EXCEPTION 'Erreur: ne peut determiner la duree des evaluations d''une serie sans son identifiant.';
	END IF;

	

	SELECT INTO duree_totale SUM(RS.date_fin-RS.date_debut)
	FROM contraintes.af_gen_get_elements('contraintes.serie_aleatoire_evaluations', 'evaluation', NULL,  'AND serie='||resultat.etape||' AND formation='||resultat.formation||' AND parcours='||resultat.parcours||' AND stagiaire='||resultat.stagiaire,0) elt,
	contraintes.resultat_serie RS
	WHERE RS.id=resultat.id
	AND elt.id=RS.evaluation
	AND RS.date_debut IS NOT NULL
	AND RS.date_fin IS NOT NULL;

	RETURN duree_totale;
END;$_$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_get_resultat_serie_aleatoire_evaluations_duree_totale(bigint) OWNER TO pgsql;

--
-- TOC entry 1243 (class 1255 OID 2596069)
-- Dependencies: 2983 5
-- Name: af_get_resultat_serie_aleatoire_evaluations_scores(bigint); Type: FUNCTION; Schema: contraintes; Owner: pgsql
--

CREATE FUNCTION af_get_resultat_serie_aleatoire_evaluations_scores(bigint) RETURNS SETOF record
    AS $_$DECLARE
--$1 identifiant resultat
rec RECORD;
rec_resultat RECORD;
res_sondage integer;
rec_serie record;
BEGIN
    SELECT INTO rec_resultat * FROM contraintes.af_get_resultat($1) AS (id int8,formation int4, stagiaire int4, parcours int4, etape int4, date_debut timestamp, duree interval);
	FOR rec IN
	    /*
	    SELECT $1, serie, id_evaluation, type_evaluation, commentaire_evaluation, bareme_evaluation, chrono_evaluation, points_evaluation, CAST(NULL AS real)  AS score
	    FROM contraintes.af_get_serie_evaluations(rec_resultat.etape) 
	    AS (id_evaluation integer, libelle_evaluation varchar, serie integer, pere_evaluation integer, commentaire_evaluation varchar, bareme_evaluation integer, chrono_evaluation integer, points_evaluation integer, type_evaluation integer )
	    */
	    select $1,rec_resultat.etape,id_evaluation,type_evaluation,cast(null as varchar) as commentaire,cast(null as integer) as bareme,cast(null as integer) as chrono,1, CAST(NULL AS real)  AS score 
	    from contraintes.af_get_serie_aleatoire_evaluations(rec_resultat.etape,rec_resultat.formation,rec_resultat.parcours,rec_resultat.stagiaire) 
	    as (id_evaluation int4, libelle varchar, serie int4, pere int4,  type_evaluation int4 )
	    --AS (id_evaluation integer, libelle_evaluation varchar, serie integer, pere_evaluation integer, commentaire_evaluation varchar, bareme_evaluation integer, chrono_evaluation integer, points_evaluation integer, type_evaluation integer )
	   
	LOOP

	raise notice 'type=%',rec.type_evaluation;
	    --QCM 
	    IF rec.type_evaluation=1 or rec.type_evaluation=4 THEN
	        SELECT INTO rec.score * FROM contraintes.af_get_resultat_serie_aleatoire_questionreponses_scores(rec_resultat.id, rec.id_evaluation);
	    END IF;
	    -- FTB
	    if rec.type_evaluation=3 then
		SELECT INTO rec.score * FROM contraintes.af_get_resultat_serie_ftb_scores(rec_resultat.id, rec.id_evaluation);
	    end if;
	    -- complete le record
	    select into rec_serie bareme,chrono from contraintes.af_get_serie_aleatoire(rec_resultat.etape) as (id integer,libelle varchar,bareme integer,chrono integer,type integer,date_creation timestamp);
	    rec.bareme:=rec_serie.bareme;
	    rec.chrono:=rec_serie.chrono;
	    rec.commentaire:=null;
		RETURN NEXT rec;
	END LOOP;
END$_$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_get_resultat_serie_aleatoire_evaluations_scores(bigint) OWNER TO pgsql;

--
-- TOC entry 8014 (class 0 OID 0)
-- Dependencies: 1243
-- Name: FUNCTION af_get_resultat_serie_aleatoire_evaluations_scores(bigint); Type: COMMENT; Schema: contraintes; Owner: pgsql
--

COMMENT ON FUNCTION af_get_resultat_serie_aleatoire_evaluations_scores(bigint) IS 'Obtenir les résultats des evaluations d''une serie aleatoire(test sur qcm).';


--
-- TOC entry 1244 (class 1255 OID 2596070)
-- Dependencies: 2983 5
-- Name: af_get_resultat_serie_aleatoire_question_reponse(bigint, integer); Type: FUNCTION; Schema: contraintes; Owner: pgsql
--

CREATE FUNCTION af_get_resultat_serie_aleatoire_question_reponse(bigint, integer) RETURNS SETOF record
    AS $_$-- $1 : identifiant resultat
-- $2 : question_reponse
DECLARE
rec RECORD;
type_evaluation integer;
resultat real;

BEGIN
	
	SELECT INTO type_evaluation type FROM contraintes.af_get_question_reponse($2) AS (id integer, libelle varchar, type integer, date_creation timestamp, radio bool);
	
	FOR rec IN 
		SELECT id, rs_evaluation, question,reponse,rs_date_creation, coche, CAST(s_juste AS integer)
		FROM  contraintes.resultat_serie_question_reponse QR
		INNER JOIN contraintes.af_get_resultat_serie_aleatoire_evaluation($1,$2) AS (rs_id int8, rs_evaluation integer, rs_date_creation timestamp,bareme integer,chrono integer)
		ON(	QR.id=rs_id AND QR.id=$1 AND QR.question_reponse=rs_evaluation )
		
		LEFT OUTER JOIN contraintes.af_get_question_reponse_solutions($2) AS (s_question_reponse integer, s_question integer,s_reponse integer ,s_juste bool )
		ON (	$2=s_question_reponse AND QR.reponse=s_reponse 
			AND QR.question=s_question AND s_question_reponse=$2)
	LOOP
		IF type_evaluation=2 OR type_evaluation=5 THEN
			--SELECT INTO rec.s_juste * FROM contraintes.af_get_resultat_serie_sondage($2);
			--rec.s_juste:=80;
			-- verifier si fonctionne avec un sondage aleatoire
			select into resultat * from contraintes.af_get_resultat_sondage_question_reponse_score($1,$2,rec.question,rec.reponse);
		    rec.s_juste:=resultat*100;
		END IF;

		RETURN NEXT rec;
	END LOOP;
	RETURN ;
END;$_$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_get_resultat_serie_aleatoire_question_reponse(bigint, integer) OWNER TO pgsql;

--
-- TOC entry 8016 (class 0 OID 0)
-- Dependencies: 1244
-- Name: FUNCTION af_get_resultat_serie_aleatoire_question_reponse(bigint, integer); Type: COMMENT; Schema: contraintes; Owner: pgsql
--

COMMENT ON FUNCTION af_get_resultat_serie_aleatoire_question_reponse(bigint, integer) IS 'retourne les resultat d''un question_reponse';


--
-- TOC entry 1245 (class 1255 OID 2596071)
-- Dependencies: 2983 5
-- Name: af_get_resultat_serie_aleatoire_questionreponses_scores(bigint, integer); Type: FUNCTION; Schema: contraintes; Owner: pgsql
--

CREATE FUNCTION af_get_resultat_serie_aleatoire_questionreponses_scores(bigint, integer) RETURNS real
    AS $_$-- $1 : $id_resultat
-- $2 : n° question reponse
declare
rec record;
rec_bareme record;
serie integer;
bareme integer;
point real;
somme real;
total real;
begin
    
    -- recup n° serie de l'evaluation
    select into rec * from contraintes.af_get_resultat($1) as (id int8,formation int4, stagiaire int4, parcours int4, etape int4, date_debut timestamp, duree interval);
    serie:=rec.etape;
    -- recup n° bareme 
    select into bareme * from contraintes.af_get_evaluation_bareme(serie,$2);
    -- les attributs du bareme
    select into rec_bareme * from contraintes.af_get_bareme(bareme) as (id int4, libelle varchar, juste int4, fausse int4, manquantes int4, toutes int4);
    -- recup point de l'evaluation de la serie
    select into point * from contraintes.af_get_evaluation_point(serie,$2);
    raise notice 'point=%',point;
    -- boucle sur les reponses
    somme:=0;
    total:=0;	
    for rec in
	select * from contraintes.af_get_resultat_serie_aleatoire_question_reponse($1,$2) as (id int8, question_reponse integer, question integer, reponse integer,  date_creation timestamp, coche boolean, juste integer)
    loop
	if (rec.coche is true and rec.juste=1) or (rec.coche is false and rec.juste=0) then
	    somme:=somme + rec_bareme.juste;
	else
	    somme:=somme - rec_bareme.fausse;
	end if;
	total:=total + rec_bareme.juste;

    end loop;
    if total>0 then
    somme:=(somme/total)*point;
    end if;
    if somme<0 then
	somme:=0;
    end if;
    return somme;
     
     
end;$_$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_get_resultat_serie_aleatoire_questionreponses_scores(bigint, integer) OWNER TO pgsql;

--
-- TOC entry 8018 (class 0 OID 0)
-- Dependencies: 1245
-- Name: FUNCTION af_get_resultat_serie_aleatoire_questionreponses_scores(bigint, integer); Type: COMMENT; Schema: contraintes; Owner: pgsql
--

COMMENT ON FUNCTION af_get_resultat_serie_aleatoire_questionreponses_scores(bigint, integer) IS 'retoune le score pour un qcm de serie aleatoire';


--
-- TOC entry 1246 (class 1255 OID 2596072)
-- Dependencies: 2983 5
-- Name: af_get_resultat_serie_aleatoire_score(bigint); Type: FUNCTION; Schema: contraintes; Owner: pgsql
--

CREATE FUNCTION af_get_resultat_serie_aleatoire_score(bigint) RETURNS real
    AS $_$-- $1 : id resultat
declare
rec record;
rec_resultat record;
total real;
nb integer;
point_evaluation integer;
begin
    -- Initialisation
    point_evaluation:=1;
    -- recupe etape,formation,parcours et individu
    SELECT INTO rec_resultat * FROM contraintes.af_get_resultat($1) AS (id int8,formation int4, stagiaire int4, parcours int4, etape int4, date_debut timestamp, duree interval);
    total:=0;
    nb:=0;
    FOR rec IN
	/*
	SELECT $1, serie, id_evaluation, type_evaluation, commentaire_evaluation, bareme_evaluation, chrono_evaluation, points_evaluation, CAST(NULL AS real)  AS score
		FROM contraintes.af_get_serie_evaluations(rec_resultat.etape) 
		AS (id_evaluation integer, libelle_evaluation varchar, serie integer, pere_evaluation integer, commentaire_evaluation varchar, bareme_evaluation integer, chrono_evaluation integer, points_evaluation integer, type_evaluation integer )
	*/
	select id_evaluation,libelle,serie,pere,type_evaluation, CAST(NULL AS real)  AS score 
	from contraintes.af_get_serie_aleatoire_evaluations(rec_resultat.etape,rec_resultat.formation,rec_resultat.parcours,rec_resultat.stagiaire) 
	as (id_evaluation int4, libelle varchar, serie int4, pere int4,  type_evaluation int4 )
    LOOP
	--QCM et QRC
	raise notice 'type=%',rec.type_evaluation;
	IF rec.type_evaluation=1 OR rec.type_evaluation=4 THEN
	    SELECT INTO rec.score * FROM contraintes.af_get_resultat_serie_aleatoire_questionreponses_scores(rec_resultat.id, rec.id_evaluation);		
	
	end if;
	IF rec.type_evaluation=3 THEN
	    SELECT INTO rec.score * FROM contraintes.af_get_resultat_serie_ftb_scores(rec_resultat.id, rec.id_evaluation);
			--rec.score=CAST(NULL AS integer);
			--FTB
			--SELECT RSFTB.id, RSFTB.ftb, RSFTB.reponse
			--FROM contraintes.resultat_serie_ftb RSFTB
			--WHERE RSFTB.ftb=rec.id_evaluation 
			--AND RSFTB.id=rec_resultat.id;
	END IF;
	    raise notice 'recscore=%',rec.score;
	    -- calcul à suivre
	    total:=total+(rec.score*20)/point_evaluation;
	    nb:=nb+1;
	END LOOP;
	return total/nb;
end;$_$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_get_resultat_serie_aleatoire_score(bigint) OWNER TO pgsql;

--
-- TOC entry 8020 (class 0 OID 0)
-- Dependencies: 1246
-- Name: FUNCTION af_get_resultat_serie_aleatoire_score(bigint); Type: COMMENT; Schema: contraintes; Owner: pgsql
--

COMMENT ON FUNCTION af_get_resultat_serie_aleatoire_score(bigint) IS 'retourne le score pour une serie aleatoire';


--
-- TOC entry 1247 (class 1255 OID 2596073)
-- Dependencies: 2983 5
-- Name: af_get_resultat_serie_avancement_max(bigint); Type: FUNCTION; Schema: contraintes; Owner: pgsql
--

CREATE FUNCTION af_get_resultat_serie_avancement_max(bigint) RETURNS record
    AS $_$DECLARE
--$1 resultat
rec RECORD;
resultat RECORD;
BEGIN
	SELECT INTO resultat *
	FROM contraintes.af_get_resultat($1)  AS (id int8,formation int4, stagiaire int4, parcours int4, etape int4, date_debut timestamp, duree interval);

	IF resultat.etape IS NULL THEN
		RAISE EXCEPTION 'Erreur: ne peut determiner l''avancement d''une serie sans son identifiant.';
	END IF;

	SELECT INTO rec resultat.id,resultat.formation , resultat.stagiaire , resultat.parcours, resultat.etape, E.id, E.type,elt.ind, CAST(NULL AS interval) AS duree
	FROM contraintes.evaluation E ,contraintes.af_gen_get_elements('contraintes.serie_evaluations', 'evaluation', NULL, 'AND serie='||resultat.etape,0) elt
		
	WHERE E.id=elt.id
	AND elt.ind = 
	 (
		SELECT MIN(elt2.ind) FROM contraintes.af_gen_get_elements('contraintes.serie_evaluations', 'evaluation', NULL, 'AND serie='||resultat.etape,0) elt2
		LEFT OUTER JOIN contraintes.resultat_serie R2 ON (R2.id = $1 AND evaluation=elt2.id)
		WHERE R2.date_fin IS  NULL
	);


	select INTO rec.duree * from contraintes.af_get_resultat_serie_evaluations_duree_totale($1);

	RETURN rec; 
END;  $_$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_get_resultat_serie_avancement_max(bigint) OWNER TO pgsql;

--
-- TOC entry 1248 (class 1255 OID 2596074)
-- Dependencies: 2983 5
-- Name: af_get_resultat_serie_evaluation(bigint, integer); Type: FUNCTION; Schema: contraintes; Owner: pgsql
--

CREATE FUNCTION af_get_resultat_serie_evaluation(bigint, integer) RETURNS SETOF record
    AS $_$DECLARE
--$1 resultat
--$2 evaluation
rec RECORD;
rec_resultat RECORD;
BEGIN
	SELECT INTO rec_resultat * FROM contraintes.af_get_resultat($1) AS (id int8,formation int4, stagiaire int4, parcours int4, etape int4, date_debut timestamp, duree interval);
	
	FOR rec IN 
		SELECT RS.id, RS.evaluation, RS.date_debut, RS.date_fin
		FROM contraintes.resultat_serie RS
		WHERE id=$1
		AND RS.evaluation=$2
	LOOP
		RETURN NEXT rec;
	END LOOP;
	RETURN ;
END;$_$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_get_resultat_serie_evaluation(bigint, integer) OWNER TO pgsql;

--
-- TOC entry 1249 (class 1255 OID 2596075)
-- Dependencies: 2983 5
-- Name: af_get_resultat_serie_evaluation_old(bigint, integer); Type: FUNCTION; Schema: contraintes; Owner: pgsql
--

CREATE FUNCTION af_get_resultat_serie_evaluation_old(bigint, integer) RETURNS SETOF record
    AS $_$DECLARE
--$1 resultat
--$2 evaluation
rec RECORD;
rec_resultat RECORD;
BEGIN
	SELECT INTO rec_resultat * FROM contraintes.af_get_resultat($1) AS (id int8,formation int4, stagiaire int4, parcours int4, etape int4, date_debut timestamp, duree interval);
	
	FOR rec IN 
		SELECT RS.id, RS.evaluation, RS.date_debut, SE.commentaire, SE.bareme, SE.chrono, SE.points
		FROM contraintes.resultat_serie RS,
		contraintes.serie_evaluations SE
		WHERE id=$1
		AND RS.evaluation=$2
		AND SE.serie=rec_resultat.etape
		AND SE.evaluation=RS.evaluation
	LOOP
		RETURN NEXT rec;
	END LOOP;
	RETURN ;
END;$_$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_get_resultat_serie_evaluation_old(bigint, integer) OWNER TO pgsql;

--
-- TOC entry 1250 (class 1255 OID 2596076)
-- Dependencies: 2983 5
-- Name: af_get_resultat_serie_evaluation_tentative(bigint, integer); Type: FUNCTION; Schema: contraintes; Owner: pgsql
--

CREATE FUNCTION af_get_resultat_serie_evaluation_tentative(bigint, integer) RETURNS SETOF record
    AS $_$DECLARE
--$1 resultat
--$2 evaluation
rec RECORD;
rec_resultat RECORD;
BEGIN
	SELECT INTO rec_resultat * FROM contraintes.af_get_resultat_tentative($1) AS (id int8,formation int4, stagiaire int4, parcours int4, etape int4, date_debut timestamp, duree interval,tentative integer);
	
	FOR rec IN 
		SELECT RS.id, RS.evaluation, RS.date_debut,RS.date_fin , SE.commentaire, SE.bareme, SE.chrono, SE.points
		FROM contraintes.resultat_serie_tentative RS,
		contraintes.serie_evaluations SE
		WHERE id=$1
		AND RS.evaluation=$2
		AND SE.serie=rec_resultat.etape
		AND SE.evaluation=RS.evaluation
	LOOP
		RETURN NEXT rec;
	END LOOP;
	RETURN ;
END;$_$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_get_resultat_serie_evaluation_tentative(bigint, integer) OWNER TO pgsql;

--
-- TOC entry 1251 (class 1255 OID 2596077)
-- Dependencies: 2983 5
-- Name: af_get_resultat_serie_evaluations(bigint); Type: FUNCTION; Schema: contraintes; Owner: pgsql
--

CREATE FUNCTION af_get_resultat_serie_evaluations(bigint) RETURNS SETOF record
    AS $_$-- $1 : id resultat
declare
rec record;
begin
    for rec in 
	select * from contraintes.resultat_serie where id=$1
    loop
	return next rec;
    end loop;
    
end;$_$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_get_resultat_serie_evaluations(bigint) OWNER TO pgsql;

--
-- TOC entry 8026 (class 0 OID 0)
-- Dependencies: 1251
-- Name: FUNCTION af_get_resultat_serie_evaluations(bigint); Type: COMMENT; Schema: contraintes; Owner: pgsql
--

COMMENT ON FUNCTION af_get_resultat_serie_evaluations(bigint) IS 'retourne les evaluations d''une serie effecutées par l''individu';


--
-- TOC entry 27 (class 1255 OID 2596078)
-- Dependencies: 2983 5
-- Name: af_get_resultat_serie_evaluations_duree_totale(bigint); Type: FUNCTION; Schema: contraintes; Owner: pgsql
--

CREATE FUNCTION af_get_resultat_serie_evaluations_duree_totale(bigint) RETURNS interval
    AS $_$DECLARE
duree_totale INTERVAL;
resultat RECORD;
BEGIN

	SELECT INTO resultat *
	FROM contraintes.af_get_resultat($1)  AS (id int8,formation int4, stagiaire int4, parcours int4, etape int4, date_debut timestamp, duree interval);

	IF resultat.etape IS NULL THEN
		RAISE EXCEPTION 'Erreur: ne peut determiner la duree des evaluations d''une serie sans son identifiant.';
	END IF;

	

	SELECT INTO duree_totale SUM(RS.date_fin-RS.date_debut)
	FROM contraintes.af_gen_get_elements('contraintes.serie_evaluations', 'evaluation', NULL, 'AND serie='||resultat.etape,0) elt,
	contraintes.resultat_serie RS
	WHERE RS.id=resultat.id
	AND elt.id=RS.evaluation
	AND RS.date_debut IS NOT NULL
	AND RS.date_fin IS NOT NULL;

	RETURN duree_totale;
END;$_$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_get_resultat_serie_evaluations_duree_totale(bigint) OWNER TO pgsql;

--
-- TOC entry 1252 (class 1255 OID 2596079)
-- Dependencies: 2983 5
-- Name: af_get_resultat_serie_evaluations_scores_tentative(bigint); Type: FUNCTION; Schema: contraintes; Owner: pgsql
--

CREATE FUNCTION af_get_resultat_serie_evaluations_scores_tentative(bigint) RETURNS SETOF record
    AS $_$-- $1 : id resultat
declare
rec RECORD;
rec_resultat RECORD;
begin
    SELECT INTO rec_resultat * FROM contraintes.af_get_resultat_tentative($1) AS (id int8,formation int4, stagiaire int4, parcours int4, etape int4, date_debut timestamp, duree interval,tentative integer);
	FOR rec IN
	    SELECT $1, serie, id_evaluation, type_evaluation, commentaire_evaluation, bareme_evaluation, chrono_evaluation, points_evaluation, CAST(NULL AS real)  AS score
	    FROM contraintes.af_get_serie_evaluations(rec_resultat.etape) 
	    AS (id_evaluation integer, libelle_evaluation varchar, serie integer, pere_evaluation integer, commentaire_evaluation varchar, bareme_evaluation integer, chrono_evaluation integer, points_evaluation integer, type_evaluation integer )
	LOOP

	raise notice 'type=%',rec.type_evaluation;
	    --QCM 
	    IF rec.type_evaluation=1 or rec.type_evaluation=4 THEN
	        SELECT INTO rec.score * FROM contraintes.af_get_resultat_serie_questionreponses_scores_tentative(rec_resultat.id, rec.id_evaluation);
	    END IF;
	    -- FTB
	    if rec.type_evaluation=3 then
		SELECT INTO rec.score * FROM contraintes.af_get_resultat_serie_ftb_scores_tentative(rec_resultat.id, rec.id_evaluation);
	    end if;
		RETURN NEXT rec;
	END LOOP;
end;$_$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_get_resultat_serie_evaluations_scores_tentative(bigint) OWNER TO pgsql;

--
-- TOC entry 8029 (class 0 OID 0)
-- Dependencies: 1252
-- Name: FUNCTION af_get_resultat_serie_evaluations_scores_tentative(bigint); Type: COMMENT; Schema: contraintes; Owner: pgsql
--

COMMENT ON FUNCTION af_get_resultat_serie_evaluations_scores_tentative(bigint) IS 'retourne les scores des evaluation d''une serie (tentative)';


--
-- TOC entry 1253 (class 1255 OID 2596080)
-- Dependencies: 2983 5
-- Name: af_get_resultat_serie_evaluations_scores_toto(bigint); Type: FUNCTION; Schema: contraintes; Owner: pgsql
--

CREATE FUNCTION af_get_resultat_serie_evaluations_scores_toto(bigint) RETURNS SETOF record
    AS $_$DECLARE
--$1 identifiant resultat
rec RECORD;
rec_resultat RECORD;
res_sondage integer;
BEGIN
    SELECT INTO rec_resultat * FROM contraintes.af_get_resultat($1) AS (id int8,formation int4, stagiaire int4, parcours int4, etape int4, date_debut timestamp, duree interval);
	FOR rec IN
	    SELECT $1, serie, id_evaluation, type_evaluation, commentaire_evaluation, bareme_evaluation, chrono_evaluation, points_evaluation, CAST(NULL AS real)  AS score
	    FROM contraintes.af_get_serie_evaluations(rec_resultat.etape) 
	    AS (id_evaluation integer, libelle_evaluation varchar, serie integer, pere_evaluation integer, commentaire_evaluation varchar, bareme_evaluation integer, chrono_evaluation integer, points_evaluation integer, type_evaluation integer )
	LOOP

	raise notice 'type=%',rec.type_evaluation;
	    --QCM 
	    IF rec.type_evaluation=1 or rec.type_evaluation=4 THEN
	        SELECT INTO rec.score * FROM contraintes.af_get_resultat_serie_questionreponses_scores(rec_resultat.id, rec.id_evaluation);
	    END IF;
	    -- FTB
	    if rec.type_evaluation=3 then
		SELECT INTO rec.score * FROM contraintes.af_get_resultat_serie_ftb_scores(rec_resultat.id, rec.id_evaluation);
	    end if;
		RETURN NEXT rec;
	END LOOP;
END$_$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_get_resultat_serie_evaluations_scores_toto(bigint) OWNER TO pgsql;

--
-- TOC entry 8031 (class 0 OID 0)
-- Dependencies: 1253
-- Name: FUNCTION af_get_resultat_serie_evaluations_scores_toto(bigint); Type: COMMENT; Schema: contraintes; Owner: pgsql
--

COMMENT ON FUNCTION af_get_resultat_serie_evaluations_scores_toto(bigint) IS 'Obtenir les résultats des evaluations d''une serie(test sur qcm).';


--
-- TOC entry 1254 (class 1255 OID 2596081)
-- Dependencies: 2983 5
-- Name: af_get_resultat_serie_evaluations_tentative(bigint); Type: FUNCTION; Schema: contraintes; Owner: pgsql
--

CREATE FUNCTION af_get_resultat_serie_evaluations_tentative(bigint) RETURNS SETOF record
    AS $_$-- $1 : id resultat
declare
rec record;
begin
    for rec in 
	select * from contraintes.resultat_serie_tentative where id=$1
    loop
	return next rec;
    end loop;
    
end;$_$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_get_resultat_serie_evaluations_tentative(bigint) OWNER TO pgsql;

--
-- TOC entry 8033 (class 0 OID 0)
-- Dependencies: 1254
-- Name: FUNCTION af_get_resultat_serie_evaluations_tentative(bigint); Type: COMMENT; Schema: contraintes; Owner: pgsql
--

COMMENT ON FUNCTION af_get_resultat_serie_evaluations_tentative(bigint) IS 'retourne les evaluations d''une serie effecutées par l''individu';


--
-- TOC entry 1255 (class 1255 OID 2596082)
-- Dependencies: 2983 5
-- Name: af_get_resultat_serie_ftb(bigint, integer); Type: FUNCTION; Schema: contraintes; Owner: pgsql
--

CREATE FUNCTION af_get_resultat_serie_ftb(bigint, integer) RETURNS SETOF record
    AS $_$DECLARE
--$1 resultat
--$2 ftb
rec RECORD;
rec_final RECORD;
chaine varchar;
langue integer;
mot varchar;
i integer;
j integer;
tab text[];

continu boolean;
BEGIN
    select into  rec RS.id, RS.evaluation,  RFTB.reponse,RS.date_debut
    FROM  contraintes.resultat_serie_ftb RFTB,contraintes.resultat_serie RS
    WHERE RS.id=$1
    AND RS.evaluation=$2
    AND RS.evaluation=RFTB.ftb
    AND RFTB.id=RS.id;
    if rec.reponse is not null then
    -- stock les réponses en tableau
    -- recup de la chaine
    SELECT INTO chaine SUBSTRING(rec.reponse,'##AMS[0-9]+##{"(.*?)"}');
    raise notice 'chaine=%',chaine;
    -- numero langue
    SELECT INTO langue  SUBSTRING(rec.reponse FROM '##AMS([0-9]+)##{');
    raise notice 'langue=%',langue;
    -- boucle sur les reponses
    j:=1;
    
    continu:=true;
    while continu is true
	loop
	mot=split_part(chaine,',',j);
	raise notice 'mot=%',mot;
	if mot ='' then
	    continu:=false;
	else
	    tab[j]:=mot;
	    j:=j+1;
	end if;
	end loop;

    FOR rec_final IN
	SELECT cast($1 as int8), cast($2 as integer),cast(tab as text[]), cast(rec.date_debut as timestamp),langue
	LOOP
	    RETURN NEXT rec_final;
	END LOOP;
    else
	FOR rec_final IN
	SELECT cast($1 as int8), cast($2 as integer),cast(null as text[]), cast(null as timestamp),cast(null as integer)
	LOOP
	    RETURN NEXT rec_final;
	END LOOP;
    end if;
    RETURN ;
END;$_$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_get_resultat_serie_ftb(bigint, integer) OWNER TO pgsql;

--
-- TOC entry 1256 (class 1255 OID 2596083)
-- Dependencies: 2983 5
-- Name: af_get_resultat_serie_ftb_scores(bigint, integer); Type: FUNCTION; Schema: contraintes; Owner: pgsql
--

CREATE FUNCTION af_get_resultat_serie_ftb_scores(bigint, integer) RETURNS real
    AS $_$-- $1 : id resultat
-- $2 : evaluation

declare
rec record;
rec_ftb record;
rec_liste_mot text[];
rec_resultat_liste_mot record;
rec_bareme record;
mot text;
serie integer;
bareme integer;
langue_ams integer;
longueur_mot integer;
point real;
somme real;
total real;
begin
    
    -- recup n° serie de l'evaluation
    select into rec * from contraintes.af_get_resultat($1) as (id int8,formation int4, stagiaire int4, parcours int4, etape int4, date_debut timestamp, duree interval);
    serie:=rec.etape;
    -- recup n° bareme 
    select into bareme * from contraintes.af_get_evaluation_bareme(serie,$2);
    -- les attributs du bareme
    select into rec_bareme * from contraintes.af_get_bareme(bareme) as (id int4, libelle varchar, juste int4, fausse int4, manquantes int4, toutes int4);
    -- recup point de l'evaluation de la serie
    select into point * from contraintes.af_get_evaluation_point(serie,$2);
    somme:=0;
    total:=0;
    
    -- recup resultat ftb
    select into rec_ftb * from contraintes.af_get_resultat_serie_ftb($1,$2) as (id int8, ftb integer, reponse text[],  date_creation timestamp,langue integer);
    
    -- recup de la liste des mots dans le texte du ftb
    -- Note : en fonction de la langue ams de la reponse
        
    select into rec_liste_mot * from contraintes.af_get_ftb_liste_mot($2,rec_ftb.langue);
    
    -- boucle sur les listes de mots
    FOR i IN array_lower(rec_liste_mot, 1) .. array_upper(rec_liste_mot, 1)
    
 
    loop
	
	-- supprime les cotes
	longueur_mot:=char_length(rec_ftb.reponse[i]);
	mot:=substring(rec_ftb.reponse[i] from 2 for longueur_mot -2);
	raise notice 'ftb_rep=%',rec_ftb.reponse[i];
	raise notice 'lst_mot=%',rec_liste_mot[i];
	-- traitement spécial pour mots séparés par ~ ex : lune~plume~brume
	if split_part(rec_liste_mot[i],'~',1)=mot or lower(mot)= lower(rec_liste_mot[i]) then
	--if lower(mot)= lower(rec_liste_mot[i]) then
	--if strpos(lower(rec_liste_mot[i]),lower(mot))>0 then
	    somme:=somme + rec_bareme.juste;
	else
	    somme:=somme - rec_bareme.fausse;
	end if;
	total:=total + rec_bareme.juste;	
    end loop;
    somme:=(somme/total)*point;
    if somme<0 then
	somme:=0;
    end if;





    return somme;
end;$_$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_get_resultat_serie_ftb_scores(bigint, integer) OWNER TO pgsql;

--
-- TOC entry 8036 (class 0 OID 0)
-- Dependencies: 1256
-- Name: FUNCTION af_get_resultat_serie_ftb_scores(bigint, integer); Type: COMMENT; Schema: contraintes; Owner: pgsql
--

COMMENT ON FUNCTION af_get_resultat_serie_ftb_scores(bigint, integer) IS 'retourne le score d''un blanc de serie';


--
-- TOC entry 1868 (class 1255 OID 2596084)
-- Dependencies: 2983 5
-- Name: af_get_resultat_serie_ftb_scores_tentative(bigint, integer); Type: FUNCTION; Schema: contraintes; Owner: pgsql
--

CREATE FUNCTION af_get_resultat_serie_ftb_scores_tentative(bigint, integer) RETURNS real
    AS $_$-- $1 : id resultat
-- $2 : evaluation
declare
rec record;
rec_ftb record;
rec_liste_mot text[];
rec_resultat_liste_mot record;
rec_bareme record;
mot text;
serie integer;
bareme integer;
longueur_mot integer;
point real;
somme real;
total real;
begin
    
    -- recup n° serie de l'evaluation
    select into rec * from contraintes.af_get_resultat_tentative($1) as (id int8,formation int4, stagiaire int4, parcours int4, etape int4, date_debut timestamp, duree interval);
    serie:=rec.etape;
    -- recup n° bareme 
    select into bareme * from contraintes.af_get_evaluation_bareme(serie,$2);
    -- les attributs du bareme
    select into rec_bareme * from contraintes.af_get_bareme(bareme) as (id int4, libelle varchar, juste int4, fausse int4, manquantes int4, toutes int4);
    -- recup point de l'evaluation de la serie
    select into point * from contraintes.af_get_evaluation_point(serie,$2);
    somme:=0;
    total:=0;
    
    -- recup resultat ftb
    select into rec_ftb * from contraintes.af_get_resultat_serie_ftb($1,$2) as (id int8, ftb integer, reponse text[],  date_creation timestamp,langue integer);
    
    -- recup de la liste des mots dans le texte du ftb
    
    select into rec_liste_mot * from contraintes.af_get_ftb_liste_mot($2);
    
    -- boucle sur les listes de mots
    FOR i IN array_lower(rec_liste_mot, 1) .. array_upper(rec_liste_mot, 1) 
    loop
	
	-- supprime les cotes
	longueur_mot:=char_length(rec_ftb.reponse[i]);
	mot:=substring(rec_ftb.reponse[i] from 2 for longueur_mot -2);
	--raise notice 'ftb_rep=%',mot;
	--raise notice 'lst_mot=%',rec_liste_mot[i];
	if lower(mot)=lower(rec_liste_mot[i]) then
	    somme:=somme + rec_bareme.juste;
	else
	    somme:=somme - rec_bareme.fausse;
	end if;
	total:=total + rec_bareme.juste;	
    end loop;
    somme:=(somme/total)*point;
    if somme<0 then
	somme:=0;
    end if;





    return somme;
end;$_$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_get_resultat_serie_ftb_scores_tentative(bigint, integer) OWNER TO pgsql;

--
-- TOC entry 8038 (class 0 OID 0)
-- Dependencies: 1868
-- Name: FUNCTION af_get_resultat_serie_ftb_scores_tentative(bigint, integer); Type: COMMENT; Schema: contraintes; Owner: pgsql
--

COMMENT ON FUNCTION af_get_resultat_serie_ftb_scores_tentative(bigint, integer) IS 'retourne le score d''un blans de serie';


--
-- TOC entry 1257 (class 1255 OID 2596085)
-- Dependencies: 2983 5
-- Name: af_get_resultat_serie_ftb_tentative(bigint, integer); Type: FUNCTION; Schema: contraintes; Owner: pgsql
--

CREATE FUNCTION af_get_resultat_serie_ftb_tentative(bigint, integer) RETURNS SETOF record
    AS $_$DECLARE
--$1 resultat
--$2 ftb
rec RECORD;
BEGIN
	
	FOR rec IN 
		SELECT RS.id, RS.evaluation, RFTB.reponse,RS.date_creation
		FROM  contraintes.resultat_serie_tentative_ftb RFTB,
		contraintes.resultat_serie RS
		WHERE RS.id=$1
		AND RS.evaluation=$2
		AND RS.evaluation=RFTB.ftb
		AND RFTB.id=RS.id
	LOOP
		RETURN NEXT rec;
	END LOOP;
	RETURN ;
END;$_$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_get_resultat_serie_ftb_tentative(bigint, integer) OWNER TO pgsql;

--
-- TOC entry 1258 (class 1255 OID 2596086)
-- Dependencies: 2983 5
-- Name: af_get_resultat_serie_melangee_avancement_max(bigint); Type: FUNCTION; Schema: contraintes; Owner: pgsql
--

CREATE FUNCTION af_get_resultat_serie_melangee_avancement_max(bigint) RETURNS record
    AS $_$-- $1 : identifiant resultat
declare
rec record;
resultat record;
indice integer;
begin
    SELECT INTO resultat *
    FROM contraintes.af_get_resultat($1)  AS (id int8,formation int4, stagiaire int4, parcours int4, etape int4, date_debut timestamp, duree interval);

    IF resultat.etape IS NULL THEN
	RAISE EXCEPTION 'Erreur: ne peut determiner l''avancement d''une serie aleatoire sans son identifiant.';
    END IF;
     
	select into rec resultat.id,resultat.formation , resultat.stagiaire , resultat.parcours, resultat.etape, e_id, e_type,cast(e_id * 0 + random()as integer) as ind 
	from contraintes.af_get_serie_evaluations(resultat.etape)as  (e_id int4, libelle varchar, serie int4, pere int4, commentaire varchar, bareme int4, chrono int4, points int4, e_type int4 )
	left outer join contraintes.resultat_serie on (evaluation=e_id and id=$1)
	where id is null order by ind limit 1;
    
/*
	select into rec resultat.id,resultat.formation , resultat.stagiaire , resultat.parcours, resultat.etape, e_id, e_type,cast(e_id * 0 + random()as integer) as ind 
	from contraintes.af_get_serie_evaluations(resultat.etape)as  (e_id int4, libelle varchar, serie int4, pere int4, commentaire varchar, bareme int4, chrono int4, points int4, e_type int4 )
	left outer join contraintes.resultat_serie on (evaluation=e_id and id=$1)
	where id is null order by ind limit 1;
*/
	-- recup indice reel
	--select into indice * from contraintes.af_get_serie_evaluation_indice(resultat.etape,rec.e_id);
	
	select into indice count(*) +1 from contraintes.resultat_serie where id=$1;
	rec.ind:=indice;

	return rec;
	
end;$_$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_get_resultat_serie_melangee_avancement_max(bigint) OWNER TO pgsql;

--
-- TOC entry 8041 (class 0 OID 0)
-- Dependencies: 1258
-- Name: FUNCTION af_get_resultat_serie_melangee_avancement_max(bigint); Type: COMMENT; Schema: contraintes; Owner: pgsql
--

COMMENT ON FUNCTION af_get_resultat_serie_melangee_avancement_max(bigint) IS 'Retourne l''evaluation à faire d''une serie aleatoire configuree';


--
-- TOC entry 1259 (class 1255 OID 2596087)
-- Dependencies: 2983 5
-- Name: af_get_resultat_serie_question_reponse(bigint, integer); Type: FUNCTION; Schema: contraintes; Owner: pgsql
--

CREATE FUNCTION af_get_resultat_serie_question_reponse(bigint, integer) RETURNS SETOF record
    AS $_$DECLARE
--$1 resultat
--$2 question_reponse
rec RECORD;
type_evaluation integer;
resultat real;

BEGIN
	SELECT INTO type_evaluation type FROM contraintes.af_get_question_reponse($2) AS (id integer, libelle varchar, type integer, date_creation timestamp, radio bool);
	raise notice 'type=%',type_evaluation;

	
	FOR rec IN 



/*
select $1,$2,QQ.question,QQ.reponse,rs_date_debut,coche,CAST(s_juste AS integer)
	    from contraintes.question_reponse_elements QQ
		LEFT OUTER JOIN 
		contraintes.af_get_question_reponse_solutions($2) AS (s_question_reponse integer, s_question integer,s_reponse integer ,s_juste bool )
	        on ( s_question_reponse=$2 AND QQ.question_reponse= s_question_reponse AND   QQ.question_reponse=$2  AND QQ.reponse = s_reponse AND QQ.question = s_question )
		left outer join contraintes.resultat_serie_question_reponse QR
		on ( QR.id=$1 AND QR.question_reponse=$2 AND QR.question_reponse=QQ.question_reponse AND QQ.reponse = QR.reponse AND QQ.question = QR.question)
		LEFT OUTER JOIN contraintes.af_get_resultat_serie_evaluation($1,$2) AS (rs_id int8, rs_evaluation integer, rs_date_debut timestamp, rs_date_fin timestamp)--commentaire varchar, bareme integer, chrono integer, points integer)
		ON (rs_id=$1 and $2=QQ.question_reponse AND QQ.question_reponse=rs_evaluation)
		WHERE QQ.question_reponse=$2
*/

select $1,$2,QQ.question_reponse_element,QQR.question_reponse_element as qre,rs_date_debut,coche,CAST(s_juste AS integer)
	    from contraintes.question_reponse_elements QQ
		left outer join
		contraintes.question_reponse_elements QQR
		on (QQ.question_reponse=QQR.question_reponse)
		LEFT OUTER JOIN 
		contraintes.af_get_question_reponse_solutions($2) AS (s_question_reponse integer, s_question integer,s_reponse integer ,s_juste bool )
	        on ( 
	        s_question_reponse=$2 
	        AND QQ.question_reponse= s_question_reponse
	        AND QQR.question_reponse= s_question_reponse 
	        AND QQ.question_reponse=$2 
	        and QQR.question_reponse=$2  
	        AND QQR.question_reponse_element = s_reponse 
	        AND QQ.question_reponse_element = s_question 
	        )
		left outer join contraintes.resultat_serie_question_reponse QR
		on ( 
		QR.id=$1 
		AND QR.question_reponse=$2 
		AND QR.question_reponse=QQ.question_reponse
		AND QR.question_reponse=QQR.question_reponse
		AND QQR.question_reponse_element = QR.reponse
		AND QQ.question_reponse_element = QR.question
		)
		LEFT OUTER JOIN contraintes.af_get_resultat_serie_evaluation($1,$2) AS (rs_id int8, rs_evaluation integer, rs_date_debut timestamp, rs_date_fin timestamp)--commentaire varchar, bareme integer, chrono integer, points integer)
		ON (
		rs_id=$1 
		and $2=QQ.question_reponse 
		and $2=QQR.question_reponse 
		AND QQ.question_reponse=rs_evaluation
		AND QQR.question_reponse=rs_evaluation
		)
		WHERE 
		QQ.question_reponse=$2 
		and QQR.question_reponse=$2 
		and QQ.question_reponse_element in (select id from contraintes.question_reponse_element where reponse is false) 
		and QQR.question_reponse_element in (select id from contraintes.question_reponse_element where reponse is true) 
		and QQ.question_reponse=$2 and QQR.question_reponse=$2




--version rémi
/*
select $1,$2,s_question,s_reponse,rs_date_debut,coche,CAST(s_juste AS integer)
	    from --contraintes.question_reponse_elements QQ
		--LEFT OUTER JOIN 
		contraintes.af_get_question_reponse_solutions($2) AS (s_question_reponse integer, s_question integer,s_reponse integer ,s_juste bool )
	        --on ( s_question_reponse=$2 AND QQ.question_reponse= s_question_reponse AND   QQ.question_reponse=$2  AND QQ.reponse = s_reponse AND QQ.question = s_question )
	        
		left outer join contraintes.resultat_serie_question_reponse QR
		on ( QR.id=$1 AND QR.question_reponse=$2 AND QR.question_reponse=s_question_reponse AND s_reponse = QR.reponse AND s_question = QR.question)
		
		LEFT OUTER JOIN contraintes.af_get_resultat_serie_evaluation($1,$2) AS (rs_id int8, rs_evaluation integer, rs_date_debut timestamp, rs_date_fin timestamp)--commentaire varchar, bareme integer, chrono integer, points integer)
		ON (rs_id=$1 and $2=s_question_reponse AND s_question_reponse=rs_evaluation)
		WHERE s_question_reponse=$2
*/

	LOOP
	raise notice 'type=%',type_evaluation;
	raise notice 'rec1=%',rec.question_reponse_element;
		IF type_evaluation=2 OR type_evaluation=5 THEN
			
			--SELECT INTO rec.s_juste * FROM contraintes.af_get_resultat_serie_sondage($2);
			--rec.s_juste:=60;
		--raise notice 'q=% et r=%',rec.QQ.question_reponse_element,rec.QQR.question_reponse_element;
		    select into resultat * from contraintes.af_get_resultat_sondage_question_reponse_score($1,$2,rec.question_reponse_element,rec.qre);
		--raise notice 'res=%',resultat;
		    rec.s_juste:=cast(resultat*100 as integer);
		END IF;

		RETURN NEXT rec;
	END LOOP;

	RETURN ;
END;$_$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_get_resultat_serie_question_reponse(bigint, integer) OWNER TO pgsql;

--
-- TOC entry 1260 (class 1255 OID 2596088)
-- Dependencies: 2983 5
-- Name: af_get_resultat_serie_question_reponse_tentative(bigint, integer); Type: FUNCTION; Schema: contraintes; Owner: pgsql
--

CREATE FUNCTION af_get_resultat_serie_question_reponse_tentative(bigint, integer) RETURNS SETOF record
    AS $_$DECLARE
--$1 resultat
--$2 question_reponse
rec RECORD;
type_evaluation integer;
resultat real;
BEGIN
	SELECT INTO type_evaluation type FROM contraintes.af_get_question_reponse($2) AS (id integer, libelle varchar, type integer, date_creation timestamp, radio bool);
	
	FOR rec IN 
		SELECT id, rs_evaluation, question,reponse,rs_date_debut,rs_date_fin, coche, CAST(s_juste AS integer)
		FROM  contraintes.resultat_serie_tentative_question_reponse QR
		INNER JOIN contraintes.af_get_resultat_serie_evaluation_tentative($1,$2) AS (rs_id int8, rs_evaluation integer, rs_date_debut timestamp,rs_date_fin timestamp, commentaire varchar, bareme integer, chrono integer, points integer)
		ON(	QR.id=rs_id AND QR.id=$1 AND QR.question_reponse=rs_evaluation)
		LEFT OUTER JOIN contraintes.af_get_question_reponse_solutions($2) AS (s_question_reponse integer, s_question integer,s_reponse integer ,s_juste bool )
		ON (	$2=s_question_reponse AND QR.reponse=s_reponse 
			AND QR.question=s_question AND s_question_reponse=$2)
	LOOP
		IF type_evaluation=2 OR type_evaluation=5 THEN
			--SELECT INTO rec.s_juste * FROM contraintes.af_get_resultat_serie_sondage($2);
			--rec.s_juste:=60;
		    select into resultat * from contraintes.af_get_resultat_sondage_question_reponse_score($1,$2,rec.question,rec.reponse);
		    rec.s_juste:=resultat*100;
		END IF;

		RETURN NEXT rec;
	END LOOP;
	RETURN ;
END;$_$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_get_resultat_serie_question_reponse_tentative(bigint, integer) OWNER TO pgsql;

--
-- TOC entry 1261 (class 1255 OID 2596089)
-- Dependencies: 2983 5
-- Name: af_get_resultat_serie_questionreponses_scores(bigint, integer); Type: FUNCTION; Schema: contraintes; Owner: pgsql
--

CREATE FUNCTION af_get_resultat_serie_questionreponses_scores(bigint, integer) RETURNS real
    AS $_$-- $1 : $id_resultat
-- $2 : n° question reponse
declare
rec record;
rec_bareme record;
serie integer;
bareme integer;
point real;
somme real;
total real;
begin
    
    -- recup n° serie de l'evaluation
    select into rec * from contraintes.af_get_resultat($1) as (id int8,formation int4, stagiaire int4, parcours int4, etape int4, date_debut timestamp, duree interval);
    serie:=rec.etape;
    -- recup n° bareme 
    select into bareme * from contraintes.af_get_evaluation_bareme(serie,$2);
    -- les attributs du bareme
    select into rec_bareme * from contraintes.af_get_bareme(bareme) as (id int4, libelle varchar, juste int4, fausse int4, manquantes int4, toutes int4);
    -- recup point de l'evaluation de la serie
    select into point * from contraintes.af_get_evaluation_point(serie,$2);
    --raise notice 'point=% et bareme=% et serie=%',point,bareme,serie;
    -- boucle sur les reponses
    somme:=0;
    total:=0;
    raise notice '$1=% et $2=%',$1,$2;	
    for rec in
	select * from contraintes.af_get_resultat_serie_question_reponse($1,$2) as (id int8, question_reponse integer, question integer, reponse integer,  date_creation timestamp, coche boolean, juste integer)
    loop
	raise notice 'rec.coche=% et rec.juste=%',rec.coche,rec.juste;
	if (rec.coche is true and rec.juste=1) or (rec.coche is false and rec.juste=0) then
       
	    somme:=somme + rec_bareme.juste;
	else
	    somme:=somme - rec_bareme.fausse;
	end if;
	total:=total + rec_bareme.juste;

    end loop;
    if total>0 then
    --raise notice 'somme=%',somme;
    somme:=(somme/total)*point;
    end if;
    if somme<0 then
	somme:=0;
    end if;
    return somme;
     
     
end;$_$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_get_resultat_serie_questionreponses_scores(bigint, integer) OWNER TO pgsql;

--
-- TOC entry 8045 (class 0 OID 0)
-- Dependencies: 1261
-- Name: FUNCTION af_get_resultat_serie_questionreponses_scores(bigint, integer); Type: COMMENT; Schema: contraintes; Owner: pgsql
--

COMMENT ON FUNCTION af_get_resultat_serie_questionreponses_scores(bigint, integer) IS 'retoune le score pour un qcm ';


--
-- TOC entry 1262 (class 1255 OID 2596090)
-- Dependencies: 2983 5
-- Name: af_get_resultat_serie_questionreponses_scores_tentative(bigint, integer); Type: FUNCTION; Schema: contraintes; Owner: pgsql
--

CREATE FUNCTION af_get_resultat_serie_questionreponses_scores_tentative(bigint, integer) RETURNS real
    AS $_$-- $1 : $id_resultat
-- $2 : n° question reponse
declare
rec record;
rec_bareme record;
serie integer;
bareme integer;
point real;
somme real;
total real;
begin
    
    -- recup n° serie de l'evaluation
    select into rec * from contraintes.af_get_resultat_tentative($1) as (id int8,formation int4, stagiaire int4, parcours int4, etape int4, date_debut timestamp, duree interval,tentative integer);
    serie:=rec.etape;
    -- recup n° bareme 
    select into bareme * from contraintes.af_get_evaluation_bareme(serie,$2);
    -- les attributs du bareme
    select into rec_bareme * from contraintes.af_get_bareme(bareme) as (id int4, libelle varchar, juste int4, fausse int4, manquantes int4, toutes int4);
    -- recup point de l'evaluation de la serie
    select into point * from contraintes.af_get_evaluation_point(serie,$2);
    -- boucle sur les reponses
    somme:=0;
    total:=0;	
    for rec in
	select * from contraintes.af_get_resultat_serie_question_reponse_tentative($1,$2) as (id int8, question_reponse integer, question integer, reponse integer,  date_debut timestamp, date_fin timestamp, coche boolean, juste integer)
    loop
	if (rec.coche is true and rec.juste=1) or (rec.coche is false and rec.juste=0) then
	    somme:=somme + rec_bareme.juste;
	else
	    somme:=somme - rec_bareme.fausse;
	end if;
	total:=total + rec_bareme.juste;

    end loop;
    if total>0 then
    somme:=(somme/total)*point;
    end if;
    if somme<0 then
	somme:=0;
    end if;
raise notice '---------------score qr tentative =%',somme;
    
    return somme;
     
     
end;$_$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_get_resultat_serie_questionreponses_scores_tentative(bigint, integer) OWNER TO pgsql;

--
-- TOC entry 8047 (class 0 OID 0)
-- Dependencies: 1262
-- Name: FUNCTION af_get_resultat_serie_questionreponses_scores_tentative(bigint, integer); Type: COMMENT; Schema: contraintes; Owner: pgsql
--

COMMENT ON FUNCTION af_get_resultat_serie_questionreponses_scores_tentative(bigint, integer) IS 'retoune le score pour un qcm ';


--
-- TOC entry 1263 (class 1255 OID 2596091)
-- Dependencies: 2983 5
-- Name: af_get_resultat_serie_questionreponses_stagiaires(bigint, integer); Type: FUNCTION; Schema: contraintes; Owner: pgsql
--

CREATE FUNCTION af_get_resultat_serie_questionreponses_stagiaires(bigint, integer) RETURNS SETOF record
    AS $_$-- $1 : id resultat
-- $2 : evaluation
declare
rec_resultat record;
rec record;
rec2 record;
rec_stagiaire record;
begin
    -- Initialisation
    -- recup infos resultat
    select into rec_resultat * from contraintes.af_get_resultat($1) 
    AS (id int8,  formation int4, stagiaire int4,parcours int4, etape int4,  date_debut timestamp, duree interval);
    -- boucle sur les evaluation
    for rec in 
	select distinct srq.id from contraintes.resultat_serie_question_reponse srq 
	where question_reponse=$2
    loop
	-- formation courante
	select into rec2 * from contraintes.af_get_resultat(rec.id) 
	AS (id int8,  formation int4, stagiaire int4,parcours int4, etape int4,  date_debut timestamp, duree interval);
	if (rec_resultat.formation=rec2.formation) and (rec_resultat.parcours=rec2.parcours) and (rec_resultat.etape=rec2.etape) then
	    select into rec_stagiaire * from contraintes.af_get_individu_nom_prenom(rec2.stagiaire) as (s_id integer,s_nom varchar,s_prenom varchar);
	    return next rec_stagiaire;
	end if;
	

    end loop;
end;$_$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_get_resultat_serie_questionreponses_stagiaires(bigint, integer) OWNER TO pgsql;

--
-- TOC entry 8049 (class 0 OID 0)
-- Dependencies: 1263
-- Name: FUNCTION af_get_resultat_serie_questionreponses_stagiaires(bigint, integer); Type: COMMENT; Schema: contraintes; Owner: pgsql
--

COMMENT ON FUNCTION af_get_resultat_serie_questionreponses_stagiaires(bigint, integer) IS 'retourne les stagiaires ayants repondu à une evaluation(meme formation)';


--
-- TOC entry 1264 (class 1255 OID 2596092)
-- Dependencies: 2983 5
-- Name: af_get_resultat_serie_score(bigint); Type: FUNCTION; Schema: contraintes; Owner: pgsql
--

CREATE FUNCTION af_get_resultat_serie_score(bigint) RETURNS real
    AS $_$-- $1 : id resultat
declare
rec record;
rec_resultat record;
total real;
nb integer;
point integer;
begin
    --total:=null;
    -- recupe etape
    SELECT INTO rec_resultat * FROM contraintes.af_get_resultat($1) AS (id int8,formation int4, stagiaire int4, parcours int4, etape int4, date_debut timestamp, duree interval);
    total:=0;
    nb:=0;
    point:=0;
    FOR rec IN
	SELECT $1, serie, id_evaluation, type_evaluation, commentaire_evaluation, bareme_evaluation, chrono_evaluation, points_evaluation, CAST(NULL AS real)  AS score
		FROM contraintes.af_get_serie_evaluations(rec_resultat.etape) 
		AS (id_evaluation integer, libelle_evaluation varchar, serie integer, pere_evaluation integer, commentaire_evaluation varchar, bareme_evaluation integer, chrono_evaluation integer, points_evaluation integer, type_evaluation integer )
    LOOP
	--QCM et QRC
	IF rec.type_evaluation=1 OR rec.type_evaluation=4 THEN
	    SELECT INTO rec.score * FROM contraintes.af_get_resultat_serie_questionreponses_scores(rec_resultat.id, rec.id_evaluation);		
	--raise notice 'rec.type_evaluation=%',rec.type_evaluation;
	end if;
	IF rec.type_evaluation=3 THEN
	    SELECT INTO rec.score * FROM contraintes.af_get_resultat_serie_ftb_scores(rec_resultat.id, rec.id_evaluation);
			--rec.score=CAST(NULL AS integer);
			--FTB
			--SELECT RSFTB.id, RSFTB.ftb, RSFTB.reponse
			--FROM contraintes.resultat_serie_ftb RSFTB
			--WHERE RSFTB.ftb=rec.id_evaluation 
			--AND RSFTB.id=rec_resultat.id;
	END IF;
	
	    -- calcul à suivre
	    if rec.points_evaluation is not null then
	    --total:=total+(rec.score*20)/rec.points_evaluation;
	    total:=total + rec.score;
	    raise notice 'total=% et points=% et score=%',total,rec.points_evaluation,rec.score;
	    nb:=nb+1;
	    point:=point + rec.points_evaluation;	
	    end if;
	END LOOP;
	--raise notice 'total=%',total;
	if nb > 0 then
	    --return total/nb;
	    return (total*20)/point;
	else
	    return null;
	end if;	
end;$_$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_get_resultat_serie_score(bigint) OWNER TO pgsql;

--
-- TOC entry 8051 (class 0 OID 0)
-- Dependencies: 1264
-- Name: FUNCTION af_get_resultat_serie_score(bigint); Type: COMMENT; Schema: contraintes; Owner: pgsql
--

COMMENT ON FUNCTION af_get_resultat_serie_score(bigint) IS 'retourne le score pour une serie ';


--
-- TOC entry 1265 (class 1255 OID 2596093)
-- Dependencies: 2983 5
-- Name: af_get_resultat_serie_score_tentative(bigint); Type: FUNCTION; Schema: contraintes; Owner: pgsql
--

CREATE FUNCTION af_get_resultat_serie_score_tentative(bigint) RETURNS real
    AS $_$-- $1 : id resultat
declare
rec record;
rec_resultat record;
total real;
nb integer;
begin
    -- recupe etape
    SELECT INTO rec_resultat * FROM contraintes.af_get_resultat_tentative($1) AS (id int8,formation int4, stagiaire int4, parcours int4, etape int4, date_debut timestamp, duree interval,tentative integer);
    total:=0;
    nb:=0;
    FOR rec IN
	SELECT $1, serie, id_evaluation, type_evaluation, commentaire_evaluation, bareme_evaluation, chrono_evaluation, points_evaluation, CAST(NULL AS real)  AS score
		FROM contraintes.af_get_serie_evaluations(rec_resultat.etape) 
		AS (id_evaluation integer, libelle_evaluation varchar, serie integer, pere_evaluation integer, commentaire_evaluation varchar, bareme_evaluation integer, chrono_evaluation integer, points_evaluation integer, type_evaluation integer )
    LOOP
	--QCM et QRC
	IF rec.type_evaluation=1 OR rec.type_evaluation=4 THEN
	    SELECT INTO rec.score * FROM contraintes.af_get_resultat_serie_questionreponses_scores_tentative(rec_resultat.id, rec.id_evaluation);		
	raise notice 'QCM QRC---------------serie score =% (%,%) ',rec.score,rec_resultat.id, rec.id_evaluation;
	end if;
	IF rec.type_evaluation=3 THEN
	    SELECT INTO rec.score * FROM contraintes.af_get_resultat_serie_ftb_scores_tentative(rec_resultat.id, rec.id_evaluation);
			--rec.score=CAST(NULL AS integer);
			--FTB
			--SELECT RSFTB.id, RSFTB.ftb, RSFTB.reponse
			--FROM contraintes.resultat_serie_ftb RSFTB
			--WHERE RSFTB.ftb=rec.id_evaluation 
			--AND RSFTB.id=rec_resultat.id;
			raise notice 'FTB---------------serie score =% (%,%) ',rec.score,rec_resultat.id, rec.id_evaluation;
	END IF;
	raise notice '---------------serie score =% (%,%) ',rec.score,rec_resultat.id, rec.id_evaluation;

	
	-- calcul à suivre
	IF rec.score IS NOT NULL THEN
		total:=total+(rec.score*20)/rec.points_evaluation;
		nb:=nb+1;
	END IF;
	
	END LOOP;
	raise notice '---------------serie score tentative =%  (%)',total,total/nb;
	return total/nb;
end;$_$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_get_resultat_serie_score_tentative(bigint) OWNER TO pgsql;

--
-- TOC entry 8053 (class 0 OID 0)
-- Dependencies: 1265
-- Name: FUNCTION af_get_resultat_serie_score_tentative(bigint); Type: COMMENT; Schema: contraintes; Owner: pgsql
--

COMMENT ON FUNCTION af_get_resultat_serie_score_tentative(bigint) IS 'retourne le score pour une serie(tentative)';


--
-- TOC entry 1266 (class 1255 OID 2596094)
-- Dependencies: 2983 5
-- Name: af_get_resultat_sondage_question_reponse_score(bigint, integer, integer, integer); Type: FUNCTION; Schema: contraintes; Owner: pgsql
--

CREATE FUNCTION af_get_resultat_sondage_question_reponse_score(bigint, integer, integer, integer) RETURNS real
    AS $_$-- $1 : id resultat
-- $2 : evaluation
-- $3 : question
-- $4 : reponse
declare
rec_resultat record;
rec record;
rec2 record;
nb_votant real;
nb_coche real;
begin
    -- Initialisation
    nb_votant:=0;
    nb_coche:=0;
    -- recup la formation
    select into rec_resultat * from contraintes.af_get_resultat($1) 
    AS (id int8,  formation int4, stagiaire int4,parcours int4, etape int4,  date_debut timestamp, duree interval);
    -- boucle sur la reponse cochée
    for rec in 
	select * from contraintes.resultat_serie_question_reponse srq 
	where question_reponse=$2 and question=$3 and reponse=$4 
	 --and coche is true
    loop
	-- formation courante
	select into rec2 * from contraintes.af_get_resultat(rec.id) 
	AS (id int8,  formation int4, stagiaire int4,parcours int4, etape int4,  date_debut timestamp, duree interval);
	if (rec_resultat.formation=rec2.formation) and (rec_resultat.parcours=rec2.parcours) and (rec_resultat.etape=rec2.etape) then
	    --raise notice 'form1=% et form2=%',rec_resultat.formation,rec2.formation;
	    if rec.coche is true then
		raise notice 'coucougg';
		nb_coche:=nb_coche + 1;
	    end if;
	    nb_votant:=nb_votant + 1;
	    --raise notice 'coche=% et votant=%',nb_coche,nb_votant;	
	end if;
    end loop;
    return (nb_coche/nb_votant);
end;$_$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_get_resultat_sondage_question_reponse_score(bigint, integer, integer, integer) OWNER TO pgsql;

--
-- TOC entry 8055 (class 0 OID 0)
-- Dependencies: 1266
-- Name: FUNCTION af_get_resultat_sondage_question_reponse_score(bigint, integer, integer, integer); Type: COMMENT; Schema: contraintes; Owner: pgsql
--

COMMENT ON FUNCTION af_get_resultat_sondage_question_reponse_score(bigint, integer, integer, integer) IS 'retourne le pourcentage pour une reponse de sondage';


--
-- TOC entry 1869 (class 1255 OID 2596095)
-- Dependencies: 2983 5
-- Name: af_get_resultat_tentative(integer, integer, integer, integer, integer); Type: FUNCTION; Schema: contraintes; Owner: pgsql
--

CREATE FUNCTION af_get_resultat_tentative(integer, integer, integer, integer, integer) RETURNS record
    AS $_$-- $1 : formation
-- $2 : stagiaire
-- $3 : parcours
-- $4 : etape
-- $5 : numero tentative
declare
rec record;
begin
    if $5 <1 then
	-- On prend l'enregistrement de la derniere tentative
/*
	SELECT INTO rec id,formation, stagiaire, parcours, etape, date_debut, duree,tentative
	FROM contraintes.resultat_tentative
	WHERE formation=$1
	AND stagiaire=$2
	AND parcours=$3
	AND etape=$4 
	group by id,formation,stagiaire,parcours,etape,date_debut, duree,tentative having tentative=max(tentative);
*/
	SELECT into rec R1.id,R1.formation, R1.stagiaire, R1.parcours, R1.etape, R1.date_debut, R1.duree,R1.tentative 
	FROM contraintes.resultat_tentative R1, contraintes.resultat_tentative R2
	WHERE R1.formation=$1
	AND R1.stagiaire=$2
	AND R1.parcours=$3
	AND R1.etape=$4
	--and R1.tentative=max(R2.tentative)
	group by R1.id,R1.formation,R1.stagiaire,R1.parcours,R1.etape,R1.date_debut, R1.duree,R1.tentative
	having R1.tentative=max(R2.tentative);
	
    else
	-- On prend l'enregistrement correspondant à la tentative
	SELECT INTO rec id,formation, stagiaire, parcours, etape, date_debut, duree,tentative
	FROM contraintes.resultat_tentative
	WHERE formation=$1
	AND stagiaire=$2
	AND parcours=$3
	AND etape=$4
	and tentative=$5;
    end if;
    return rec;
end;$_$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_get_resultat_tentative(integer, integer, integer, integer, integer) OWNER TO pgsql;

--
-- TOC entry 8057 (class 0 OID 0)
-- Dependencies: 1869
-- Name: FUNCTION af_get_resultat_tentative(integer, integer, integer, integer, integer); Type: COMMENT; Schema: contraintes; Owner: pgsql
--

COMMENT ON FUNCTION af_get_resultat_tentative(integer, integer, integer, integer, integer) IS 'retourne le dernier identifiant resultat_tentative ou celui correspondant à un numero de tentative';


--
-- TOC entry 1267 (class 1255 OID 2596096)
-- Dependencies: 2983 5
-- Name: af_get_resultat_tentative(bigint); Type: FUNCTION; Schema: contraintes; Owner: pgsql
--

CREATE FUNCTION af_get_resultat_tentative(bigint) RETURNS record
    AS $_$DECLARE
--$1 resultat
rec RECORD;
BEGIN
	SELECT INTO rec id,formation, stagiaire, parcours, etape, date_debut, duree,tentative
	FROM contraintes.resultat_tentative
	WHERE id=$1;

	RETURN rec;
END;$_$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_get_resultat_tentative(bigint) OWNER TO pgsql;

--
-- TOC entry 8059 (class 0 OID 0)
-- Dependencies: 1267
-- Name: FUNCTION af_get_resultat_tentative(bigint); Type: COMMENT; Schema: contraintes; Owner: pgsql
--

COMMENT ON FUNCTION af_get_resultat_tentative(bigint) IS 'retourne les attributs associes à un id resultat (tentative)';


--
-- TOC entry 1268 (class 1255 OID 2596097)
-- Dependencies: 2983 5
-- Name: af_get_salle(integer); Type: FUNCTION; Schema: contraintes; Owner: pgsql
--

CREATE FUNCTION af_get_salle(integer) RETURNS record
    AS $_$-- $1 : numero salle
declare
rec record;
begin
    select into rec * from contraintes.af_get_salles() as (id int4,libelle varchar) where id=$1;
    return rec;
end;$_$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_get_salle(integer) OWNER TO pgsql;

--
-- TOC entry 8061 (class 0 OID 0)
-- Dependencies: 1268
-- Name: FUNCTION af_get_salle(integer); Type: COMMENT; Schema: contraintes; Owner: pgsql
--

COMMENT ON FUNCTION af_get_salle(integer) IS 'retourne une salle';


--
-- TOC entry 1269 (class 1255 OID 2596098)
-- Dependencies: 2983 5
-- Name: af_get_salle_evenements(integer, date); Type: FUNCTION; Schema: contraintes; Owner: pgsql
--

CREATE FUNCTION af_get_salle_evenements(integer, date) RETURNS SETOF record
    AS $_$-- $1 : numero salle
-- $2 : date
declare
rec record;
begin
    for rec in 
	select * from contraintes.evenement 
	where salle=$1 and cast(date as date)=$2
    loop
	return next rec;
    end loop;
end;$_$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_get_salle_evenements(integer, date) OWNER TO pgsql;

--
-- TOC entry 8063 (class 0 OID 0)
-- Dependencies: 1269
-- Name: FUNCTION af_get_salle_evenements(integer, date); Type: COMMENT; Schema: contraintes; Owner: pgsql
--

COMMENT ON FUNCTION af_get_salle_evenements(integer, date) IS 'retourne les evvenements dans une salle pour une journee de formation';


--
-- TOC entry 1270 (class 1255 OID 2596099)
-- Dependencies: 2983 5
-- Name: af_get_salles(); Type: FUNCTION; Schema: contraintes; Owner: postgres
--

CREATE FUNCTION af_get_salles() RETURNS SETOF record
    AS $$declare
rec record;
begin
	for rec in 
		select * from contraintes.salle order by libelle
	loop
		return next rec;
	end loop;
	return;
end;$$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_get_salles() OWNER TO postgres;

--
-- TOC entry 8065 (class 0 OID 0)
-- Dependencies: 1270
-- Name: FUNCTION af_get_salles(); Type: COMMENT; Schema: contraintes; Owner: postgres
--

COMMENT ON FUNCTION af_get_salles() IS 'Obtenir les salles de la plate-forme (auteur : Said)';


--
-- TOC entry 1271 (class 1255 OID 2596100)
-- Dependencies: 2983 5
-- Name: af_get_scenario(integer); Type: FUNCTION; Schema: contraintes; Owner: pgsql
--

CREATE FUNCTION af_get_scenario(integer) RETURNS record
    AS $_$DECLARE
--$1 scenario
rec RECORD;
BEGIN
	SELECT INTO rec E_id, E_libelle, E_type, S.fichier ,F_libelle, F_connecte, E_date_creation
	FROM contraintes.af_get_etape($1)AS (E_id int4, E_libelle varchar, E_type int4,E_date_creation timestamp),
	contraintes.scenario S, contraintes.af_get_fichiers() AS ( F_id int4, F_libelle varchar, F_type int4, F_connecte bool) 
	WHERE S.id=E_id
	AND S.fichier = F_id;

	IF rec.F_connecte IS FALSE THEN
		RAISE EXCEPTION 'Vous tentez de récuperer les informations d\'un scénario dont le fichier est déconnécté';
	END IF;

	RETURN rec;
END;$_$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_get_scenario(integer) OWNER TO pgsql;

--
-- TOC entry 1272 (class 1255 OID 2596101)
-- Dependencies: 2983 5
-- Name: af_get_scenario_dynamique(integer); Type: FUNCTION; Schema: contraintes; Owner: pgsql
--

CREATE FUNCTION af_get_scenario_dynamique(integer) RETURNS record
    AS $_$DECLARE
--$1 scenario
rec RECORD;
BEGIN
	SELECT INTO rec E_id, E_libelle, E_type, S.fichier ,F_libelle, F_connecte, E_date_creation
	FROM contraintes.af_get_etape($1)AS (E_id int4, E_libelle varchar, E_type int4,E_date_creation timestamp),
	contraintes.scenario_dynamique S, contraintes.af_get_fichiers() AS ( F_id int4, F_libelle varchar, F_type int4, F_connecte bool) 
	WHERE S.id=E_id
	AND S.fichier = F_id;

	IF rec.F_connecte IS FALSE THEN
		RAISE EXCEPTION 'Vous tentez de récuperer les informations d\'un scenario dynamique dont le fichier est déconnécté';
	END IF;

	RETURN rec;
END;$_$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_get_scenario_dynamique(integer) OWNER TO pgsql;

--
-- TOC entry 1273 (class 1255 OID 2596102)
-- Dependencies: 2983 5
-- Name: af_get_scenario_dynamique_fichier(integer); Type: FUNCTION; Schema: contraintes; Owner: pgsql
--

CREATE FUNCTION af_get_scenario_dynamique_fichier(integer) RETURNS integer
    AS $_$DECLARE
--$1 le numero du fichier
scenario_id int4;
BEGIN

	SELECT INTO scenario_id id FROM contraintes.scenario_dynamique
	WHERE fichier=$1;

	RETURN scenario_id;

END$_$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_get_scenario_dynamique_fichier(integer) OWNER TO pgsql;

--
-- TOC entry 8069 (class 0 OID 0)
-- Dependencies: 1273
-- Name: FUNCTION af_get_scenario_dynamique_fichier(integer); Type: COMMENT; Schema: contraintes; Owner: pgsql
--

COMMENT ON FUNCTION af_get_scenario_dynamique_fichier(integer) IS 'Obtenir un scenario dynamque à partir de son numero de fichier.
';


--
-- TOC entry 1274 (class 1255 OID 2596103)
-- Dependencies: 2983 5
-- Name: af_get_scenario_fichier(integer); Type: FUNCTION; Schema: contraintes; Owner: pgsql
--

CREATE FUNCTION af_get_scenario_fichier(integer) RETURNS integer
    AS $_$DECLARE
--$1 le numero du fichier
scenario_id int4;
BEGIN

	SELECT INTO scenario_id id FROM contraintes.scenario
	WHERE fichier=$1;

	RETURN scenario_id;

END$_$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_get_scenario_fichier(integer) OWNER TO pgsql;

--
-- TOC entry 8071 (class 0 OID 0)
-- Dependencies: 1274
-- Name: FUNCTION af_get_scenario_fichier(integer); Type: COMMENT; Schema: contraintes; Owner: pgsql
--

COMMENT ON FUNCTION af_get_scenario_fichier(integer) IS 'Obtenir un scenario à partir de son numero de fichier.
';


--
-- TOC entry 1275 (class 1255 OID 2596104)
-- Dependencies: 2983 5
-- Name: af_get_section(integer); Type: FUNCTION; Schema: contraintes; Owner: pgsql
--

CREATE FUNCTION af_get_section(integer) RETURNS record
    AS $_$-- s1 : numero section
declare
rec record;
begin
    select into rec * from contraintes.af_get_sections() as (id int4,libelle varchar,icone int4) 
    where id=$1;
    return rec;
end;$_$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_get_section(integer) OWNER TO pgsql;

--
-- TOC entry 8073 (class 0 OID 0)
-- Dependencies: 1275
-- Name: FUNCTION af_get_section(integer); Type: COMMENT; Schema: contraintes; Owner: pgsql
--

COMMENT ON FUNCTION af_get_section(integer) IS 'retourne une section';


--
-- TOC entry 1276 (class 1255 OID 2596105)
-- Dependencies: 2983 5
-- Name: af_get_sections(); Type: FUNCTION; Schema: contraintes; Owner: pgsql
--

CREATE FUNCTION af_get_sections() RETURNS SETOF record
    AS $$declare
rec record;
begin
    for rec in 
	select * from contraintes.section 
    loop
	return next rec;
    end loop;
    return;
end;$$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_get_sections() OWNER TO pgsql;

--
-- TOC entry 8075 (class 0 OID 0)
-- Dependencies: 1276
-- Name: FUNCTION af_get_sections(); Type: COMMENT; Schema: contraintes; Owner: pgsql
--

COMMENT ON FUNCTION af_get_sections() IS 'retourne les sections de la plateforme';


--
-- TOC entry 1277 (class 1255 OID 2596106)
-- Dependencies: 2983 5
-- Name: af_get_serie(integer); Type: FUNCTION; Schema: contraintes; Owner: pgsql
--

CREATE FUNCTION af_get_serie(integer) RETURNS record
    AS $_$DECLARE
rec RECORD;
BEGIN
	SELECT INTO rec E.id , E.libelle , S.bareme , S.chrono, E.date_creation 
	FROM contraintes.etape E, contraintes.serie S
	WHERE E.id= S.id
	AND E.id=$1;

	RETURN rec;
END
$_$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_get_serie(integer) OWNER TO pgsql;

--
-- TOC entry 8077 (class 0 OID 0)
-- Dependencies: 1277
-- Name: FUNCTION af_get_serie(integer); Type: COMMENT; Schema: contraintes; Owner: pgsql
--

COMMENT ON FUNCTION af_get_serie(integer) IS 'Obtenir les informations d''une serie.';


--
-- TOC entry 1278 (class 1255 OID 2596107)
-- Dependencies: 2983 5
-- Name: af_get_serie_aleatoire(integer); Type: FUNCTION; Schema: contraintes; Owner: pgsql
--

CREATE FUNCTION af_get_serie_aleatoire(integer) RETURNS record
    AS $_$declare
rec record;
begin
    select into rec S_id,S_libelle,S_bareme,S_chrono,sa.type, date_creation from 
    contraintes.af_get_serie($1) as (S_id int4,S_libelle varchar, S_bareme int4, S_chrono int4, date_creation timestamp) ,
    contraintes.serie_aleatoire sa
    where sa.id=$1 and S_id=sa.id;

    
    return rec;
end;$_$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_get_serie_aleatoire(integer) OWNER TO pgsql;

--
-- TOC entry 8079 (class 0 OID 0)
-- Dependencies: 1278
-- Name: FUNCTION af_get_serie_aleatoire(integer); Type: COMMENT; Schema: contraintes; Owner: pgsql
--

COMMENT ON FUNCTION af_get_serie_aleatoire(integer) IS 'retourne les infos d''une serie aleatoire';


--
-- TOC entry 1279 (class 1255 OID 2596108)
-- Dependencies: 2983 5
-- Name: af_get_serie_aleatoire_evaluations(integer, integer, integer, integer); Type: FUNCTION; Schema: contraintes; Owner: pgsql
--

CREATE FUNCTION af_get_serie_aleatoire_evaluations(integer, integer, integer, integer) RETURNS SETOF record
    AS $_$-- $1 : serie
-- $2 : formation
-- $3 : parcours
-- $4 : individu

declare
rec record;
begin
    FOR rec IN
		SELECT E.evaluation, EV.libelle, E.serie, E.pere,  EV.type 
		FROM contraintes.serie_aleatoire_evaluations E, 
		contraintes.af_gen_get_elements('contraintes.serie_aleatoire_evaluations', 'evaluation', NULL,' AND serie='||$1||' AND formation='||$2||' AND parcours='||$3||' AND stagiaire='||$4 ,0) G_id,
		contraintes.evaluation EV
		WHERE E.evaluation=G_id.id
		AND E.serie=$1
		AND E.evaluation=EV.id
		AND E.stagiaire=$4
		and E.parcours=$3
		ORDER BY G_id.ind
	LOOP
		RETURN NEXT rec;
	END LOOP;
	
	RETURN;
end;$_$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_get_serie_aleatoire_evaluations(integer, integer, integer, integer) OWNER TO pgsql;

--
-- TOC entry 8081 (class 0 OID 0)
-- Dependencies: 1279
-- Name: FUNCTION af_get_serie_aleatoire_evaluations(integer, integer, integer, integer); Type: COMMENT; Schema: contraintes; Owner: pgsql
--

COMMENT ON FUNCTION af_get_serie_aleatoire_evaluations(integer, integer, integer, integer) IS 'retourne les evaluations d''une serie aleatoire';


--
-- TOC entry 1280 (class 1255 OID 2596109)
-- Dependencies: 2983 5
-- Name: af_get_serie_aleatoire_melangee_themes(); Type: FUNCTION; Schema: contraintes; Owner: pgsql
--

CREATE FUNCTION af_get_serie_aleatoire_melangee_themes() RETURNS SETOF record
    AS $$declare
rec record;

begin
    for rec in 
	select * from contraintes.af_get_serie_aleatoire_themes(1) as (id int4,libelle varchar)
    loop
	return next rec;
    end loop;
    return;
end;$$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_get_serie_aleatoire_melangee_themes() OWNER TO pgsql;

--
-- TOC entry 8083 (class 0 OID 0)
-- Dependencies: 1280
-- Name: FUNCTION af_get_serie_aleatoire_melangee_themes(); Type: COMMENT; Schema: contraintes; Owner: pgsql
--

COMMENT ON FUNCTION af_get_serie_aleatoire_melangee_themes() IS 'retourne les themes pour les serie aleatoires configurees';


--
-- TOC entry 28 (class 1255 OID 2596110)
-- Dependencies: 2983 5
-- Name: af_get_serie_aleatoire_multiserie_evaluation(integer, integer, integer, integer, integer); Type: FUNCTION; Schema: contraintes; Owner: www
--

CREATE FUNCTION af_get_serie_aleatoire_multiserie_evaluation(integer, integer, integer, integer, integer) RETURNS record
    AS $_$DECLARE
rec RECORD;
BEGIN
	SELECT INTO rec * FROM contraintes.af_get_serie_aleatoire_multiserie_evaluations($1, $2, $3, $4)
	AS (id int4, libelle varchar, serie int4, pere int4, commentaire varchar, bareme int4, chrono int4, points int4,type int4 )
	WHERE id=$5;

	RETURN rec;
END;$_$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_get_serie_aleatoire_multiserie_evaluation(integer, integer, integer, integer, integer) OWNER TO www;

--
-- TOC entry 1281 (class 1255 OID 2596111)
-- Dependencies: 2983 5
-- Name: af_get_serie_aleatoire_multiserie_evaluations(integer, integer, integer, integer); Type: FUNCTION; Schema: contraintes; Owner: pgsql
--

CREATE FUNCTION af_get_serie_aleatoire_multiserie_evaluations(integer, integer, integer, integer) RETURNS SETOF record
    AS $_$-- $1 : serie
-- $2 : formation
-- $3 : parcours
-- $4 : individu

declare
rec record;
begin
    FOR rec IN
		SELECT E.evaluation, EV.libelle, E.serie, E.pere, SOURCE.commentaire,  SOURCE.bareme ,  SOURCE.chrono ,  SOURCE.points ,  EV.type 
		FROM contraintes.serie_aleatoire_evaluations E, 
		contraintes.af_gen_get_elements('contraintes.serie_aleatoire_evaluations', 'evaluation', NULL,' AND serie='||$1||' AND formation='||$2||' AND parcours='||$3||' AND stagiaire='||$4 ,0) G_id,
		contraintes.evaluation EV,
		contraintes.serie_evaluations SOURCE
		WHERE E.evaluation=G_id.id
		AND E.serie=$1
		AND E.evaluation=EV.id
		AND E.stagiaire=$4
		and E.parcours=$3
		AND SOURCE.serie=E.source
		AND SOURCE.evaluation=E.evaluation
		ORDER BY G_id.ind
	LOOP
		RETURN NEXT rec;
	END LOOP;
	
	RETURN;
end;$_$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_get_serie_aleatoire_multiserie_evaluations(integer, integer, integer, integer) OWNER TO pgsql;

--
-- TOC entry 8086 (class 0 OID 0)
-- Dependencies: 1281
-- Name: FUNCTION af_get_serie_aleatoire_multiserie_evaluations(integer, integer, integer, integer); Type: COMMENT; Schema: contraintes; Owner: pgsql
--

COMMENT ON FUNCTION af_get_serie_aleatoire_multiserie_evaluations(integer, integer, integer, integer) IS 'retourne les evaluations d''une serie aleatoire';


--
-- TOC entry 1870 (class 1255 OID 2596112)
-- Dependencies: 2983 5
-- Name: af_get_serie_aleatoire_multiserie_somme_chronos(integer, integer, integer, integer); Type: FUNCTION; Schema: contraintes; Owner: pgsql
--

CREATE FUNCTION af_get_serie_aleatoire_multiserie_somme_chronos(integer, integer, integer, integer) RETURNS integer
    AS $_$DECLARE
--$1 : serie
-- $2 : formation
-- $3 : parcours
-- $4 : individu
somme int4;
BEGIN
	SELECT INTO somme SUM(chrono)
	FROM contraintes.af_get_serie_aleatoire_multiserie_evaluations($1, $2, $3, $4)
	AS (id int4, libelle varchar, serie int4, pere int4, commentaire varchar, bareme int4, chrono int4, points int4,type int4 );
	
	RETURN somme;
END;$_$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_get_serie_aleatoire_multiserie_somme_chronos(integer, integer, integer, integer) OWNER TO pgsql;

--
-- TOC entry 1871 (class 1255 OID 2596113)
-- Dependencies: 2983 5
-- Name: af_get_serie_aleatoire_multiserie_somme_points(integer, integer, integer, integer); Type: FUNCTION; Schema: contraintes; Owner: pgsql
--

CREATE FUNCTION af_get_serie_aleatoire_multiserie_somme_points(integer, integer, integer, integer) RETURNS integer
    AS $_$DECLARE
--$1 : serie
-- $2 : formation
-- $3 : parcours
-- $4 : individu
somme int4;
BEGIN
	SELECT INTO somme SUM(points) 
	FROM contraintes.af_get_serie_aleatoire_multiserie_evaluations($1, $2, $3, $4)
	AS (id int4, libelle varchar, serie int4, pere int4, commentaire varchar, bareme int4, chrono int4, points int4,type int4 );
	
	RETURN somme;
END$_$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_get_serie_aleatoire_multiserie_somme_points(integer, integer, integer, integer) OWNER TO pgsql;

--
-- TOC entry 8089 (class 0 OID 0)
-- Dependencies: 1871
-- Name: FUNCTION af_get_serie_aleatoire_multiserie_somme_points(integer, integer, integer, integer); Type: COMMENT; Schema: contraintes; Owner: pgsql
--

COMMENT ON FUNCTION af_get_serie_aleatoire_multiserie_somme_points(integer, integer, integer, integer) IS 'Obtenir la somme des points d''une série.';


--
-- TOC entry 1872 (class 1255 OID 2596114)
-- Dependencies: 2983 5
-- Name: af_get_serie_aleatoire_multiserie_themes(integer); Type: FUNCTION; Schema: contraintes; Owner: pgsql
--

CREATE FUNCTION af_get_serie_aleatoire_multiserie_themes(integer) RETURNS SETOF record
    AS $_$-- $1 : individu
declare
rec record;

begin
    for rec in 
	select * from contraintes.af_get_serie_aleatoire_themes(2,$1) as (id int4,libelle varchar)
    loop
	return next rec;
    end loop;
    return;
end;$_$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_get_serie_aleatoire_multiserie_themes(integer) OWNER TO pgsql;

--
-- TOC entry 8091 (class 0 OID 0)
-- Dependencies: 1872
-- Name: FUNCTION af_get_serie_aleatoire_multiserie_themes(integer); Type: COMMENT; Schema: contraintes; Owner: pgsql
--

COMMENT ON FUNCTION af_get_serie_aleatoire_multiserie_themes(integer) IS 'retourne les themes pour les series aleatoires multiserie pour le root ou formateur';


--
-- TOC entry 1282 (class 1255 OID 2596115)
-- Dependencies: 2983 5
-- Name: af_get_serie_aleatoire_series_associations(integer); Type: FUNCTION; Schema: contraintes; Owner: pgsql
--

CREATE FUNCTION af_get_serie_aleatoire_series_associations(integer) RETURNS SETOF record
    AS $_$declare
rec record;

begin
    for rec in
	select serie,serie_source,nb_evaluations,type_evaluations 
	from contraintes.serie_aleatoire_multiserie where 
	serie=$1
    loop
	return next rec;
    end loop;
end;$_$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_get_serie_aleatoire_series_associations(integer) OWNER TO pgsql;

--
-- TOC entry 8093 (class 0 OID 0)
-- Dependencies: 1282
-- Name: FUNCTION af_get_serie_aleatoire_series_associations(integer); Type: COMMENT; Schema: contraintes; Owner: pgsql
--

COMMENT ON FUNCTION af_get_serie_aleatoire_series_associations(integer) IS 'retourne la configuration d''une serie aleatoire multiserie';


--
-- TOC entry 1283 (class 1255 OID 2596116)
-- Dependencies: 2983 5
-- Name: af_get_serie_aleatoire_series_sources(integer); Type: FUNCTION; Schema: contraintes; Owner: pgsql
--

CREATE FUNCTION af_get_serie_aleatoire_series_sources(integer) RETURNS SETOF record
    AS $_$declare
rec record;

begin
    for rec in
	select distinct serie_source from 
	contraintes.serie_aleatoire_multiserie where 
	serie=$1
    loop
	return next rec;
    end loop;
    return;
end;$_$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_get_serie_aleatoire_series_sources(integer) OWNER TO pgsql;

--
-- TOC entry 8095 (class 0 OID 0)
-- Dependencies: 1283
-- Name: FUNCTION af_get_serie_aleatoire_series_sources(integer); Type: COMMENT; Schema: contraintes; Owner: pgsql
--

COMMENT ON FUNCTION af_get_serie_aleatoire_series_sources(integer) IS 'retourne les series sources d''une serie aleatoire multiserie';


--
-- TOC entry 1284 (class 1255 OID 2596117)
-- Dependencies: 2983 5
-- Name: af_get_serie_aleatoire_themes(integer, integer); Type: FUNCTION; Schema: contraintes; Owner: pgsql
--

CREATE FUNCTION af_get_serie_aleatoire_themes(integer, integer) RETURNS SETOF record
    AS $_$-- $1 : type de serie aleatoire
-- $2 individu
declare
rec record;

begin
    if contraintes.fw_is_root($2) then
    for rec in 
	select distinct t.id,t.libelle from 
	contraintes.theme t,
	contraintes.serie_aleatoire sa,
	contraintes.theme_categories tc where
	tc.categorie=19 and
	tc.theme=t.id and
	tc.id=sa.id and
	sa.type=$1
    loop
	return next rec;
    end loop;
    else
    for rec in 
	select distinct t.id,t.libelle from 
	contraintes.theme t,
	contraintes.serie_aleatoire sa,
	contraintes.theme_categories tc where
	tc.categorie=19 and
	tc.theme=t.id and
	tc.id=sa.id and
	sa.type=$1 and (t.individu=$2 OR t.individu IS NULL)
    loop
	return next rec;
    end loop;
    end if;
    return;
end;$_$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_get_serie_aleatoire_themes(integer, integer) OWNER TO pgsql;

--
-- TOC entry 8097 (class 0 OID 0)
-- Dependencies: 1284
-- Name: FUNCTION af_get_serie_aleatoire_themes(integer, integer); Type: COMMENT; Schema: contraintes; Owner: pgsql
--

COMMENT ON FUNCTION af_get_serie_aleatoire_themes(integer, integer) IS 'retourne les themes pour les series aleatoires pour un type de serie pour le root ou formateur';


--
-- TOC entry 1285 (class 1255 OID 2596118)
-- Dependencies: 2983 5
-- Name: af_get_serie_aleatoire_themes_associations(integer); Type: FUNCTION; Schema: contraintes; Owner: pgsql
--

CREATE FUNCTION af_get_serie_aleatoire_themes_associations(integer) RETURNS SETOF record
    AS $_$declare
rec record;
begin
for rec in
	select  serie,theme_source,nb_evaluations,type_evaluations 
	from contraintes.serie_aleatoire_multitheme  where 
	serie=$1 
    loop
	return next rec;
    end loop;
end;$_$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_get_serie_aleatoire_themes_associations(integer) OWNER TO pgsql;

--
-- TOC entry 8099 (class 0 OID 0)
-- Dependencies: 1285
-- Name: FUNCTION af_get_serie_aleatoire_themes_associations(integer); Type: COMMENT; Schema: contraintes; Owner: pgsql
--

COMMENT ON FUNCTION af_get_serie_aleatoire_themes_associations(integer) IS 'retourne la configuration d''une serie aleatoire multitheme';


--
-- TOC entry 1286 (class 1255 OID 2596119)
-- Dependencies: 2155 2983 5
-- Name: af_get_serie_aleatoire_type(integer); Type: FUNCTION; Schema: contraintes; Owner: pgsql
--

CREATE FUNCTION af_get_serie_aleatoire_type(integer) RETURNS type_element
    AS $_$DECLARE
--$1 serie aleatoire
retour contraintes.type_element;
serie_type contraintes.type_element;
type_eval int4;
libelle_type_eval varchar;
BEGIN
	SELECT INTO serie_type  S_type AS type, libelle
	FROM contraintes.af_get_serie_aleatoire($1) AS  (S_id int4,S_libelle varchar, S_bareme int4, S_chrono int4, S_type int4, date_creation timestamp),
	contraintes.serie_aleatoire_type T
	WHERE S_type=T.id;

	--AFFECTE LE TYPE DE SERIE ALEATOIRE
	retour.libelle:=serie_type.libelle;
	retour.id:=serie_type.id;

	IF serie_type.id=3 THEN --multi-themes
		SELECT INTO type_eval type_evaluations FROM contraintes.serie_aleatoire_multitheme
		WHERE serie=$1
		GROUP BY type_evaluations
		HAVING COUNT(type_evaluations)=1;
	ELSEIF serie_type.id=2 THEN --multi-serie
		SELECT INTO type_eval type_evaluations FROM contraintes.serie_aleatoire_multiserie
		WHERE serie=$1
		GROUP BY type_evaluations
		HAVING COUNT(type_evaluations)=1;
	END IF;

	IF type_eval IS NOT NULL THEN
		SELECT INTO libelle_type_eval libelle
		FROM contraintes.evaluation_type
		WHERE id=type_eval;

		--AFFECTE LE TYPE (D'EVALUATION)DE SERIE
		retour.libelle:=retour.libelle||'.''(''.'||libelle_type_eval||'.'')''';
		retour.id:=retour.id||'_'||type_eval;
	END IF;

	RETURN retour;
END;$_$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_get_serie_aleatoire_type(integer) OWNER TO pgsql;

--
-- TOC entry 1873 (class 1255 OID 2596120)
-- Dependencies: 2983 5
-- Name: af_get_serie_aleatoire_types_evaluations_type(integer, integer, integer, integer); Type: FUNCTION; Schema: contraintes; Owner: pgsql
--

CREATE FUNCTION af_get_serie_aleatoire_types_evaluations_type(integer, integer, integer, integer) RETURNS SETOF record
    AS $_$DECLARE
rec RECORD;
req varchar;
req2 varchar;
BEGIN
    req:='select distinct T.id, T.libelle, T.code, CAST(COUNT(T.id) AS integer), couleur
    from contraintes.evaluation_type T, contraintes.evaluation E, ';
    req2:=' GROUP BY T.id, T.libelle, T.code,couleur';
    req:=req || 'contraintes.serie_aleatoire_evaluations S WHERE T.id=E.type AND E.id=S.evaluation AND S.serie=' || $1||' and S.formation=' ||$2||' and S.parcours=' ||$3||' and S.stagiaire=' ||$4||req2;
	raise notice 'req=%',req;
	FOR rec IN EXECUTE req
	LOOP
			RETURN NEXT rec;
	END LOOP;
RETURN;
END;$_$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_get_serie_aleatoire_types_evaluations_type(integer, integer, integer, integer) OWNER TO pgsql;

--
-- TOC entry 1287 (class 1255 OID 2596121)
-- Dependencies: 2983 5
-- Name: af_get_serie_avancement(integer); Type: FUNCTION; Schema: contraintes; Owner: pgsql
--

CREATE FUNCTION af_get_serie_avancement(integer) RETURNS SETOF record
    AS $_$DECLARE
rec RECORD;
BEGIN
	FOR rec IN
	
		SELECT RQR_formation, RQR_stagiaire, RQR_parcours,  $1 AS serie, RQR_question_response AS evaluation
		--FROM (contraintes.af_get_serie_evaluations($1) AS (SE_id int4, SE_libelle varchar, SE_serie int4, SE_pere int4, SE_commentaire varchar, SE_bareme int4, SE_chrono int4, SE_points int4, SE_type int4 )
		FROM (contraintes.af_gen_get_elements('contraintes.serie_evaluations', 'evaluation', NULL,' AND serie='||$1 ,0) G_id
		LEFT OUTER JOIN contraintes.af_get_serie_question_reponse_resultats($1) AS (RQR_id int4, RQR_formation int4,  RQR_classe int4, RQR_stagiaire int4, RQR_parcours int4,  RQR_etape int4, RQR_date_debut timestamp, RQR_date_fin timestamp, RQR_question_response int4, RQR_reponse int4, coche bool)
		ON (G_id.id=RQR_question_response))
		LEFT OUTER JOIN contraintes.af_get_serie_ftb_resultats($1) AS (RFTB_id int4, RFTB_formation int4,  RFTB_classe int4, RFTB_stagiaire int4, RFTB_parcours int4,  RFTB_etape int4, RFTB_date_debut timestamp, RFTB_date_fin timestamp, RFTB_ftb int4, RFTB_reponse text)
		ON (G_id.id=RFTB_ftb )
		--ORDER BY SE_id,G_id.ind, RQR_question_response, RQR_formation,RQR_classe, RQR_parcours, RQR_stagiaire 
		ORDER BY G_id.ind, RQR_question_response, RQR_formation,RQR_classe, RQR_parcours, RQR_stagiaire 
	LOOP
		RETURN NEXT rec;
	END LOOP;

	RETURN;
END$_$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_get_serie_avancement(integer) OWNER TO pgsql;

--
-- TOC entry 1288 (class 1255 OID 2596122)
-- Dependencies: 2983 5
-- Name: af_get_serie_avancement_max(integer); Type: FUNCTION; Schema: contraintes; Owner: pgsql
--

CREATE FUNCTION af_get_serie_avancement_max(integer) RETURNS record
    AS $_$DECLARE
rec RECORD;
BEGIN
	/*SELECT INTO rec  RQR_formation,  RQR_stagiaire, RQR_parcours,  RFTB_id AS serie, RQR_question_response AS evaluation
	--FROM (contraintes.af_get_serie_evaluations($1) AS (SE_id int4, SE_libelle varchar, SE_serie int4, SE_pere int4, SE_commentaire varchar, SE_bareme int4, SE_chrono int4, SE_points int4, SE_type int4 )
	FROM (contraintes.af_gen_get_elements('contraintes.serie_evaluations', 'evaluation', NULL,' AND serie='||$1 ,0) G_id
	LEFT OUTER JOIN contraintes.af_get_serie_question_reponse_resultats($1) AS (RQR_id int4, RQR_formation int4,  RQR_classe int4, RQR_stagiaire int4, RQR_parcours int4,  RQR_etape int4, RQR_date_debut timestamp, RQR_date_fin timestamp, RQR_question_response int4, RQR_reponse int4, coche bool)
	ON (G_id.id=RQR_question_response))
	LEFT OUTER JOIN contraintes.af_get_serie_ftb_resultats($1) AS (RFTB_id int4, RFTB_formation int4,  RFTB_classe int4, RFTB_stagiaire int4, RFTB_parcours int4,  RFTB_etape int4, RFTB_date_debut timestamp, RFTB_date_fin timestamp, RFTB_ftb int4, RFTB_reponse text)
	ON (G_id.id=RFTB_ftb )
	GROUP BY RFTB_id,G_id.ind, RQR_question_response, RQR_formation,RQR_classe, RQR_parcours, RQR_stagiaire
	HAVING G_id.ind=MAX(G_id.ind);
	
	RETURN rec;*/

	RETURN NULL;
END; $_$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_get_serie_avancement_max(integer) OWNER TO pgsql;

--
-- TOC entry 1289 (class 1255 OID 2596123)
-- Dependencies: 2983 5
-- Name: af_get_serie_bloquante_configuration(integer, integer, integer); Type: FUNCTION; Schema: contraintes; Owner: pgsql
--

CREATE FUNCTION af_get_serie_bloquante_configuration(integer, integer, integer) RETURNS record
    AS $_$-- $1 : serie
-- $2 : formation
-- $3 : parcours
declare
rec record;
begin
    select into rec * from contraintes.serie_bloquante where serie=$1 and formation=$2 and parcours=$3;
    return rec;
end;$_$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_get_serie_bloquante_configuration(integer, integer, integer) OWNER TO pgsql;

--
-- TOC entry 8105 (class 0 OID 0)
-- Dependencies: 1289
-- Name: FUNCTION af_get_serie_bloquante_configuration(integer, integer, integer); Type: COMMENT; Schema: contraintes; Owner: pgsql
--

COMMENT ON FUNCTION af_get_serie_bloquante_configuration(integer, integer, integer) IS 'retourne la configuration d''une serie bloquante';


--
-- TOC entry 29 (class 1255 OID 2596124)
-- Dependencies: 2983 5
-- Name: af_get_serie_bloquante_tentative(integer, integer, integer, integer); Type: FUNCTION; Schema: contraintes; Owner: pgsql
--

CREATE FUNCTION af_get_serie_bloquante_tentative(integer, integer, integer, integer) RETURNS SETOF record
    AS $_$DECLARE
rec RECORD;
rec_resultat RECORD;
BEGIN

	FOR rec IN 
		SELECT id,formation,stagiaire,parcours,etape,date_debut,duree,tentative 
		FROM contraintes.resultat_tentative 
		WHERE formation=$1
		AND stagiaire=$2
		AND parcours=$3
		AND etape=$4

	LOOP
		RETURN NEXT rec;
	END LOOP;
END;$_$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_get_serie_bloquante_tentative(integer, integer, integer, integer) OWNER TO pgsql;

--
-- TOC entry 1290 (class 1255 OID 2596125)
-- Dependencies: 2983 5
-- Name: af_get_serie_commentaires(integer); Type: FUNCTION; Schema: contraintes; Owner: pgsql
--

CREATE FUNCTION af_get_serie_commentaires(integer) RETURNS SETOF record
    AS $_$-- $1 : numero serie
declare
rec record;
begin
    for rec in
	select etape,min,max,commentaire 
	from contraintes.commentaire_etape 
	where etape=$1
    loop
    return next rec;
    end loop;
    return;
end;$_$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_get_serie_commentaires(integer) OWNER TO pgsql;

--
-- TOC entry 8108 (class 0 OID 0)
-- Dependencies: 1290
-- Name: FUNCTION af_get_serie_commentaires(integer); Type: COMMENT; Schema: contraintes; Owner: pgsql
--

COMMENT ON FUNCTION af_get_serie_commentaires(integer) IS 'retourne les commentaire d''une serie';


--
-- TOC entry 1291 (class 1255 OID 2596126)
-- Dependencies: 2983 5
-- Name: af_get_serie_distincts_types(integer); Type: FUNCTION; Schema: contraintes; Owner: pgsql
--

CREATE FUNCTION af_get_serie_distincts_types(integer) RETURNS SETOF record
    AS $_$-- $1 : serie
declare
rec record;
begin
    for rec in 
	select distinct ev.type from 
	contraintes.evaluation ev,contraintes.serie_evaluations se 
	where ev.id=se.evaluation and se.serie=$1
    loop
	return next rec;
    end loop;
end;$_$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_get_serie_distincts_types(integer) OWNER TO pgsql;

--
-- TOC entry 8110 (class 0 OID 0)
-- Dependencies: 1291
-- Name: FUNCTION af_get_serie_distincts_types(integer); Type: COMMENT; Schema: contraintes; Owner: pgsql
--

COMMENT ON FUNCTION af_get_serie_distincts_types(integer) IS 'retourne les différents types d''évaluation d''une serie';


--
-- TOC entry 1292 (class 1255 OID 2596127)
-- Dependencies: 2983 5
-- Name: af_get_serie_evaluation(integer, integer); Type: FUNCTION; Schema: contraintes; Owner: pgsql
--

CREATE FUNCTION af_get_serie_evaluation(integer, integer) RETURNS record
    AS $_$
DECLARE
rec RECORD;
BEGIN

	SELECT INTO rec * FROM
	contraintes.af_get_serie_evaluations($1) AS (evaluation int4, libelle varchar, serie int4, pere int4, commentaire varchar, bareme int4, chrono int4, points int4, type int4 )
	WHERE evaluation=$2;
	 
	RETURN rec;
END
$_$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_get_serie_evaluation(integer, integer) OWNER TO pgsql;

--
-- TOC entry 8112 (class 0 OID 0)
-- Dependencies: 1292
-- Name: FUNCTION af_get_serie_evaluation(integer, integer); Type: COMMENT; Schema: contraintes; Owner: pgsql
--

COMMENT ON FUNCTION af_get_serie_evaluation(integer, integer) IS 'Obtenir les info d''une evaluation d''une serie.';


--
-- TOC entry 1293 (class 1255 OID 2596128)
-- Dependencies: 2983 5
-- Name: af_get_serie_evaluation_indice(integer, integer); Type: FUNCTION; Schema: contraintes; Owner: pgsql
--

CREATE FUNCTION af_get_serie_evaluation_indice(integer, integer) RETURNS integer
    AS $_$-- $1 : serie
-- $2 : evaluation
declare
rec record;
ind integer;
begin
    ind:=0;
    for rec in 
	select * from contraintes.af_get_serie_evaluations($1) 
	as (id int4, libelle varchar, serie int4, pere int4, commentaire varchar, bareme int4, chrono int4, points int4, type int4 )
    loop
	if rec.id=$2 then
	    return ind;
	else
	    ind:=ind+1;
	end if;
    end loop;
    return ind;    
end;$_$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_get_serie_evaluation_indice(integer, integer) OWNER TO pgsql;

--
-- TOC entry 8114 (class 0 OID 0)
-- Dependencies: 1293
-- Name: FUNCTION af_get_serie_evaluation_indice(integer, integer); Type: COMMENT; Schema: contraintes; Owner: pgsql
--

COMMENT ON FUNCTION af_get_serie_evaluation_indice(integer, integer) IS 'retourne l''indice d''une evaluation de serie';


--
-- TOC entry 30 (class 1255 OID 2596129)
-- Dependencies: 2983 5
-- Name: af_get_serie_evaluation_resultats(integer, integer); Type: FUNCTION; Schema: contraintes; Owner: pgsql
--

CREATE FUNCTION af_get_serie_evaluation_resultats(integer, integer) RETURNS SETOF record
    AS $_$-- $1 : serie
-- $2 : evaluation
declare
rec record;
begin
    for rec in
	select * from contraintes.resultat_serie where id=$1 and evaluation=$2
    loop
	return next rec;
    end loop;
end;$_$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_get_serie_evaluation_resultats(integer, integer) OWNER TO pgsql;

--
-- TOC entry 1294 (class 1255 OID 2596130)
-- Dependencies: 2983 5
-- Name: af_get_serie_evaluations(integer); Type: FUNCTION; Schema: contraintes; Owner: pgsql
--

CREATE FUNCTION af_get_serie_evaluations(integer) RETURNS SETOF record
    AS $_$DECLARE
rec RECORD;
BEGIN
	IF $1 IS NULL THEN
		RAISE EXCEPTION 'af_get_serie_evaluations requiert un parametre';
	END IF;
	FOR rec IN
		SELECT E.evaluation, EV.libelle, E.serie, E.pere, E.commentaire, E.bareme, E.chrono, E.points, EV.type 
		FROM contraintes.serie_evaluations E, 
		contraintes.af_gen_get_elements('contraintes.serie_evaluations', 'evaluation', NULL,' AND serie='||$1 ,0) G_id,
		contraintes.evaluation EV
		WHERE E.evaluation=G_id.id
		AND E.serie=$1
		AND E.evaluation=EV.id
		ORDER BY G_id.ind
	LOOP
		RETURN NEXT rec;
	END LOOP;
	
	RETURN;
END$_$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_get_serie_evaluations(integer) OWNER TO pgsql;

--
-- TOC entry 8117 (class 0 OID 0)
-- Dependencies: 1294
-- Name: FUNCTION af_get_serie_evaluations(integer); Type: COMMENT; Schema: contraintes; Owner: pgsql
--

COMMENT ON FUNCTION af_get_serie_evaluations(integer) IS 'Obtenir les evaluations d''une serie.';


--
-- TOC entry 1295 (class 1255 OID 2596131)
-- Dependencies: 2983 5
-- Name: af_get_serie_evaluations_disponibles_theme(integer, integer); Type: FUNCTION; Schema: contraintes; Owner: pgsql
--

CREATE FUNCTION af_get_serie_evaluations_disponibles_theme(integer, integer) RETURNS SETOF record
    AS $_$DECLARE
--$1 serie
--$2 theme
--$3 type d'evaluation
rec RECORD;
BEGIN

	FOR rec IN
		SELECT E.id,lower(E.libelle) AS min_text, E.type
		FROM contraintes.evaluation E,
		contraintes.af_get_theme_elements($2) AS (T_id int4 , T_categorie int4)
		WHERE E.id= T_id 
		AND E.id NOT IN
			(SELECT evaluation FROM contraintes.af_get_serie_evaluations($1) AS (evaluation int4,  libelle varchar, serie int4, pere int4, commentaire varchar, bareme int4, chrono int4, points int4, type int4 ) )
		ORDER BY E.type, min_text
	LOOP
		RETURN NEXT rec;
	END LOOP;
	
	RETURN;
END$_$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_get_serie_evaluations_disponibles_theme(integer, integer) OWNER TO pgsql;

--
-- TOC entry 8119 (class 0 OID 0)
-- Dependencies: 1295
-- Name: FUNCTION af_get_serie_evaluations_disponibles_theme(integer, integer); Type: COMMENT; Schema: contraintes; Owner: pgsql
--

COMMENT ON FUNCTION af_get_serie_evaluations_disponibles_theme(integer, integer) IS 'Obtenir les evaluations disponibles  d''un theme donné pour une serie. ';


--
-- TOC entry 1296 (class 1255 OID 2596132)
-- Dependencies: 2983 5
-- Name: af_get_serie_evaluations_disponibles_theme_categorie(integer, integer, integer); Type: FUNCTION; Schema: contraintes; Owner: pgsql
--

CREATE FUNCTION af_get_serie_evaluations_disponibles_theme_categorie(integer, integer, integer) RETURNS SETOF record
    AS $_$DECLARE
--$1 serie
--$2 theme
--$3 categorie d'evaluation
rec RECORD;
BEGIN

	FOR rec IN
		SELECT E.id,lower(E.libelle) AS min_text, E.type
		FROM contraintes.evaluation E,
		contraintes.af_get_categorie_elements_theme($3, $2) AS T_id
		WHERE E.id= T_id 
		AND E.id NOT IN
			(SELECT evaluation FROM contraintes.af_get_serie_evaluations($1) AS (evaluation int4,  libelle varchar, serie int4, pere int4, commentaire varchar, bareme int4, chrono int4, points int4, type int4 ) )
		ORDER BY E.type, min_text
	LOOP
		RETURN NEXT rec;
	END LOOP;
	
	RETURN;
END$_$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_get_serie_evaluations_disponibles_theme_categorie(integer, integer, integer) OWNER TO pgsql;

--
-- TOC entry 8121 (class 0 OID 0)
-- Dependencies: 1296
-- Name: FUNCTION af_get_serie_evaluations_disponibles_theme_categorie(integer, integer, integer); Type: COMMENT; Schema: contraintes; Owner: pgsql
--

COMMENT ON FUNCTION af_get_serie_evaluations_disponibles_theme_categorie(integer, integer, integer) IS 'Obtenir les evaluations disponibles  d''un theme et d''une categorie donnés pour une serie. ';


--
-- TOC entry 1297 (class 1255 OID 2596133)
-- Dependencies: 2983 5
-- Name: af_get_serie_evaluations_disponibles_theme_type(integer, integer, integer); Type: FUNCTION; Schema: contraintes; Owner: pgsql
--

CREATE FUNCTION af_get_serie_evaluations_disponibles_theme_type(integer, integer, integer) RETURNS SETOF record
    AS $_$DECLARE
--$1 serie
--$2 theme
--$3 type d'evaluation
rec RECORD;
BEGIN

	FOR rec IN
		-- lower génant pour AMS
		--SELECT DISTINCT E.id,lower(E.libelle) AS min_text, E.type
		SELECT  distinct E.id,cast(E.libelle as text) , E.type
		FROM contraintes.evaluation E,
		contraintes.af_get_theme_elements($2) AS (T_id int4 , T_categorie int4)
		WHERE E.id= T_id 
		AND E.type=$3
		AND E.id NOT IN
			(SELECT evaluation FROM contraintes.af_get_serie_evaluations($1) AS (evaluation int4,  libelle varchar, serie int4, pere int4, commentaire varchar, bareme int4, chrono int4, points int4, type int4 ) )
		--ORDER BY E.type, min_text
		--ORDER BY E.type
	LOOP
		RETURN NEXT rec;
	END LOOP;
	
	RETURN;
END$_$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_get_serie_evaluations_disponibles_theme_type(integer, integer, integer) OWNER TO pgsql;

--
-- TOC entry 8123 (class 0 OID 0)
-- Dependencies: 1297
-- Name: FUNCTION af_get_serie_evaluations_disponibles_theme_type(integer, integer, integer); Type: COMMENT; Schema: contraintes; Owner: pgsql
--

COMMENT ON FUNCTION af_get_serie_evaluations_disponibles_theme_type(integer, integer, integer) IS 'Obtenir les evaluations disponibles  d''un theme et d''un type donnés pour une serie. ';


--
-- TOC entry 1874 (class 1255 OID 2596134)
-- Dependencies: 2983 5
-- Name: af_get_serie_ftb_resultats(integer); Type: FUNCTION; Schema: contraintes; Owner: pgsql
--

CREATE FUNCTION af_get_serie_ftb_resultats(integer) RETURNS SETOF record
    AS $_$DECLARE
rec RECORD;
BEGIN
		FOR rec IN
			/*SELECT
			FROM contraintes.af_get_serie_evaluations($1) AS (SE_id int4, SE_libelle varchar, SE_serie int4, SE_pere int4, SE_commentaire varchar, SE_bareme int4, SE_chrono int4, SE_points int4, SE_type int4 )
			LEFT OUTER JOIN 
				(contraintes.resultat_serie_question_reponse RSQR 
					INNER JOIN contraintes.af_get_etape_resultats($1) AS (R_id int4, R_formation int4,  R_classe int4, R_stagiaire int4, R_parcours int4,  R_etape int4, R_date_debut timestamp, R_date_fin timestamp)
					ON (RSQR.id=R_id)
			ON (serie=RSQR.serie)*/

			SELECT R_id , R_formation ,  R_classe , R_stagiaire , R_parcours ,  R_etape , R_date_debut, R_date_fin , RSFTB.ftb, RSFTB.reponse
			FROM contraintes.af_get_etape_resultats($1) AS (R_id int4, R_formation int4,  R_classe int4, R_stagiaire int4, R_parcours int4,  R_etape int4, R_date_debut timestamp, R_date_fin timestamp),
			contraintes.resultat_serie_ftb RSFTB
			WHERE R_id=RSFTB.id
			AND R_etape=RSFTB.serie

		LOOP
			RETURN NEXT rec;
		END LOOP;

		RETURN;
END$_$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_get_serie_ftb_resultats(integer) OWNER TO pgsql;

--
-- TOC entry 1298 (class 1255 OID 2596135)
-- Dependencies: 2983 5
-- Name: af_get_serie_individus(integer); Type: FUNCTION; Schema: contraintes; Owner: pgsql
--

CREATE FUNCTION af_get_serie_individus(integer) RETURNS SETOF record
    AS $_$-- $1 : serie
declare
rec record;
begin
    for rec in
	select r.formation,f.libelle,r.stagiaire,i.nom,i.prenom,r.parcours,e.libelle,r.etape
	from contraintes.resultat r,contraintes.formation f,contraintes.fw_individu i,contraintes.etape e 
	where r.etape=$1 
	and r.formation=f.id
	and r.stagiaire=i.id 
	and r.parcours=e.id
    loop
	return next rec;

    end loop;

end;$_$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_get_serie_individus(integer) OWNER TO pgsql;

--
-- TOC entry 8126 (class 0 OID 0)
-- Dependencies: 1298
-- Name: FUNCTION af_get_serie_individus(integer); Type: COMMENT; Schema: contraintes; Owner: pgsql
--

COMMENT ON FUNCTION af_get_serie_individus(integer) IS 'retourne les individus et formations pour la serie donnée';


--
-- TOC entry 1299 (class 1255 OID 2596136)
-- Dependencies: 2983 5
-- Name: af_get_serie_question_reponse_resultats(integer); Type: FUNCTION; Schema: contraintes; Owner: pgsql
--

CREATE FUNCTION af_get_serie_question_reponse_resultats(integer) RETURNS SETOF record
    AS $_$DECLARE
rec RECORD;
BEGIN
		FOR rec IN
			/*SELECT
			FROM contraintes.af_get_serie_evaluations($1) AS (SE_id int4, SE_libelle varchar, SE_serie int4, SE_pere int4, SE_commentaire varchar, SE_bareme int4, SE_chrono int4, SE_points int4, SE_type int4 )
			LEFT OUTER JOIN 
				(contraintes.resultat_serie_question_reponse RSQR 
					INNER JOIN contraintes.af_get_etape_resultats($1) AS (R_id int4, R_formation int4,  R_classe int4, R_stagiaire int4, R_parcours int4,  R_etape int4, R_date_debut timestamp, R_date_fin timestamp)
					ON (RSQR.id=R_id)
			ON (serie=RSQR.serie)*/
			-- CE QUI SUIT NE FONCTIONNE PAS !!!
			SELECT R_id , R_formation ,  R_classe , R_stagiaire , R_parcours ,  R_etape , R_date_debut, R_date_fin , RSQR.question_reponse, RSQR.reponse, RSQR.coche
			FROM contraintes.af_get_etape_resultats($1) AS (R_id int4, R_formation int4,  R_classe int4, R_stagiaire int4, R_parcours int4,  R_etape int4, R_date_debut timestamp, R_ddate_fin timestamp),
			contraintes.resultat_serie_question_reponse RSQR
			WHERE R_id=RSQR.id
			AND R_etape=RSQR.serie

		LOOP
			RETURN NEXT rec;
		END LOOP;

		RETURN;
END$_$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_get_serie_question_reponse_resultats(integer) OWNER TO pgsql;

--
-- TOC entry 1300 (class 1255 OID 2596137)
-- Dependencies: 2983 5
-- Name: af_get_serie_questions_evaluations_disponibles_theme_type(integer, integer, integer); Type: FUNCTION; Schema: contraintes; Owner: pgsql
--

CREATE FUNCTION af_get_serie_questions_evaluations_disponibles_theme_type(integer, integer, integer) RETURNS SETOF record
    AS $_$DECLARE
--$1 serie
--$2 theme
--$3 type d'evaluation
rec RECORD;
BEGIN

	FOR rec IN
		SELECT DISTINCT ELT.id,ELT.libelle, ELT.type, lower(ELT.libelle) as minlib
		FROM contraintes.af_get_categorie_elements_theme(17,$2) T_id ,
		contraintes.question_reponse_elements QR,
		contraintes.question_reponse_element ELT,
		contraintes.evaluation E
		WHERE E.type=$3 
		--AND (QR.question=T_id)
		AND (QR.question_reponse_element=T_id)
		--AND ELT.id=QR.question
		AND ELT.id=QR.question_reponse_element
		AND E.id=QR.question_reponse
		AND E.id NOT IN
			(SELECT evaluation FROM contraintes.af_get_serie_evaluations($1) AS (evaluation int4,  libelle varchar, serie int4, pere int4, commentaire varchar, bareme int4, chrono int4, points int4, type int4 ) )
		and QR.question_reponse_element in (select id from contraintes.question_reponse_element where reponse is false)
		ORDER BY minlib
	LOOP
		RETURN NEXT rec;
	END LOOP;
	
	RETURN;
END$_$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_get_serie_questions_evaluations_disponibles_theme_type(integer, integer, integer) OWNER TO pgsql;

--
-- TOC entry 1301 (class 1255 OID 2596138)
-- Dependencies: 2983 5
-- Name: af_get_serie_series_aleatoires(integer); Type: FUNCTION; Schema: contraintes; Owner: pgsql
--

CREATE FUNCTION af_get_serie_series_aleatoires(integer) RETURNS SETOF record
    AS $_$DECLARE
rec RECORD;
BEGIN
	FOR rec IN
		SELECT DISTINCT id, libelle,type, date_creation  FROM contraintes.serie_aleatoire_multiserie, contraintes.af_get_etape($1) AS (id int4, libelle varchar, type int4, date_creation timestamp)
		WHERE serie_source=$1
		AND id=serie
	LOOP
		RETURN NEXT rec;
	END LOOP;

	RETURN;
END;$_$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_get_serie_series_aleatoires(integer) OWNER TO pgsql;

--
-- TOC entry 1875 (class 1255 OID 2596139)
-- Dependencies: 2983 5
-- Name: af_get_serie_simple(integer); Type: FUNCTION; Schema: contraintes; Owner: pgsql
--

CREATE FUNCTION af_get_serie_simple(integer) RETURNS record
    AS $_$DECLARE
rec RECORD;
BEGIN
	SELECT INTO rec E.id , E.libelle , S.bareme , S.chrono,date_creation  
	FROM contraintes.etape E, contraintes.serie S LEFT OUTER JOIN contraintes.serie_aleatoire SA
	ON (S.id=SA.id)
	WHERE E.id= S.id
	AND E.id=$1
	AND SA.id IS NULL;

	RETURN rec;
END
$_$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_get_serie_simple(integer) OWNER TO pgsql;

--
-- TOC entry 8131 (class 0 OID 0)
-- Dependencies: 1875
-- Name: FUNCTION af_get_serie_simple(integer); Type: COMMENT; Schema: contraintes; Owner: pgsql
--

COMMENT ON FUNCTION af_get_serie_simple(integer) IS 'Obtenir les informations d''une serie simple.';


--
-- TOC entry 1302 (class 1255 OID 2596140)
-- Dependencies: 2155 2983 5
-- Name: af_get_serie_simple_type(integer); Type: FUNCTION; Schema: contraintes; Owner: pgsql
--

CREATE FUNCTION af_get_serie_simple_type(integer) RETURNS type_element
    AS $_$DECLARE
--$1 serie
type_serie contraintes.type_element;
nb_types int4;
BEGIN
	IF $1 IS NULL THEN
		RAISE EXCEPTION 'af_get_serie_type requiert un parametre';
	END IF;

	--compte le nombre de type différents
	SELECT INTO nb_types sum(cnt) 
	FROM(
		--compte 1 pour chaque type différent
		SELECT 1 AS cnt
		FROM contraintes.af_get_serie_evaluations($1) 
		AS (S_id int4, S_libelle varchar, S_serie int4, S_pere int4, S_commentaire varchar, S_bareme int4, S_chrono int4, S_points int4, S_type int4 )
		GROUP BY S_type
	) AS t;
	--si un seul type, on récupere le type des evaluations (qui est le meme normalement)
	IF nb_types=1 THEN
		
		FOR type_serie IN
			SELECT S_type AS T_id, E.libelle AS T_libelle
			FROM contraintes.af_get_serie_evaluations($1) 
			AS (S_id int4, S_libelle varchar, S_serie int4, S_pere int4, S_commentaire varchar, S_bareme int4, S_chrono int4, S_points int4, S_type int4 ),
			contraintes.evaluation_type E
			WHERE E.id=S_type
			GROUP BY S_type,E.libelle
		LOOP 
			--rien ;)
		END LOOP;
	END IF;
	RETURN type_serie;
END;$_$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_get_serie_simple_type(integer) OWNER TO pgsql;

--
-- TOC entry 1303 (class 1255 OID 2596141)
-- Dependencies: 2983 5
-- Name: af_get_serie_somme_chronos(integer); Type: FUNCTION; Schema: contraintes; Owner: pgsql
--

CREATE FUNCTION af_get_serie_somme_chronos(integer) RETURNS integer
    AS $_$DECLARE
--$1 serie
somme int4;
BEGIN
	SELECT INTO somme SUM(chrono)
	FROM contraintes.af_get_serie_evaluations($1) AS(id int4, libelle varchar, serie int4, pere int4, commentaire varchar, bareme int4, chrono int4, points int4, type int4 );

	RETURN somme;
END;$_$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_get_serie_somme_chronos(integer) OWNER TO pgsql;

--
-- TOC entry 1304 (class 1255 OID 2596142)
-- Dependencies: 2983 5
-- Name: af_get_serie_somme_points(integer); Type: FUNCTION; Schema: contraintes; Owner: pgsql
--

CREATE FUNCTION af_get_serie_somme_points(integer) RETURNS integer
    AS $_$DECLARE
somme int4;
BEGIN
	SELECT INTO somme SUM(points) FROM contraintes.serie_evaluations where serie=$1;
	RETURN somme;
END$_$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_get_serie_somme_points(integer) OWNER TO pgsql;

--
-- TOC entry 8135 (class 0 OID 0)
-- Dependencies: 1304
-- Name: FUNCTION af_get_serie_somme_points(integer); Type: COMMENT; Schema: contraintes; Owner: pgsql
--

COMMENT ON FUNCTION af_get_serie_somme_points(integer) IS 'Obtenir la somme des points d''une série.';


--
-- TOC entry 1305 (class 1255 OID 2596143)
-- Dependencies: 2983 5
-- Name: af_get_serie_types_evaluations_type(integer, boolean); Type: FUNCTION; Schema: contraintes; Owner: pgsql
--

CREATE FUNCTION af_get_serie_types_evaluations_type(integer, boolean) RETURNS SETOF record
    AS $_$DECLARE
rec RECORD;
req varchar;
req2 varchar;
BEGIN
	req:='select distinct T.id, T.libelle, T.code, CAST(COUNT(T.id) AS integer), couleur
	from contraintes.evaluation_type T, contraintes.evaluation E, ';

	req2:=' GROUP BY T.id, T.libelle, T.code,couleur';

	IF($2 IS TRUE)THEN
		req:=req || 'contraintes.serie_aleatoire_evaluations S WHERE T.id=E.type AND E.id=S.serie AND S.serie=' || $1||req2;
	ELSE
		req:=req || 'contraintes.serie_evaluations S WHERE T.id=E.type AND E.id=S.evaluation AND S.serie=' || $1||req2;
	END IF;
	raise notice 'req=%',req;
	FOR rec IN EXECUTE req
	LOOP
			RETURN NEXT rec;
	END LOOP;
RETURN;
END;$_$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_get_serie_types_evaluations_type(integer, boolean) OWNER TO pgsql;

--
-- TOC entry 1306 (class 1255 OID 2596144)
-- Dependencies: 2983 5
-- Name: af_get_series_aleatoires_type(integer); Type: FUNCTION; Schema: contraintes; Owner: pgsql
--

CREATE FUNCTION af_get_series_aleatoires_type(integer) RETURNS SETOF record
    AS $_$declare
rec record;
req varchar;
table_aleatoire varchar;
begin
/*
    if($1=2) then
	table_aleatoire:='serie_aleatoire_multiserie';
    else
	table_aleatoire:='serie_aleatoire_multitheme';
    end if;
    req:='select  e.id,e.libelle from contraintes.etape e,contraintes.'||table_aleatoire||' a
    where e.id=a.serie' ;
    --raise exception 'sql=%',req;
*/    
    for rec in
	--execute req
	select e.id,e.libelle from 
	contraintes.etape e,
	contraintes.serie_aleatoire sa where
	e.id=sa.id and sa.type=$1
    loop
	return next rec;
    end loop;
    return;

end;$_$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_get_series_aleatoires_type(integer) OWNER TO pgsql;

--
-- TOC entry 8138 (class 0 OID 0)
-- Dependencies: 1306
-- Name: FUNCTION af_get_series_aleatoires_type(integer); Type: COMMENT; Schema: contraintes; Owner: pgsql
--

COMMENT ON FUNCTION af_get_series_aleatoires_type(integer) IS 'Obtenir les series aleatoires pour un type donné';


--
-- TOC entry 1307 (class 1255 OID 2596145)
-- Dependencies: 2983 5
-- Name: af_get_session_individus(); Type: FUNCTION; Schema: contraintes; Owner: pgsql
--

CREATE FUNCTION af_get_session_individus() RETURNS SETOF record
    AS $$declare
rec record;
begin
    for rec in
	select individu,nom,prenom,formation 
	from contraintes.fw_individu,contraintes.session where id=individu
    loop
	return next rec;
    end loop;
end;$$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_get_session_individus() OWNER TO pgsql;

--
-- TOC entry 8140 (class 0 OID 0)
-- Dependencies: 1307
-- Name: FUNCTION af_get_session_individus(); Type: COMMENT; Schema: contraintes; Owner: pgsql
--

COMMENT ON FUNCTION af_get_session_individus() IS 'retourne les individus en session';


--
-- TOC entry 1308 (class 1255 OID 2596146)
-- Dependencies: 2983 5
-- Name: af_get_sondage_elements(); Type: FUNCTION; Schema: contraintes; Owner: postgres
--

CREATE FUNCTION af_get_sondage_elements() RETURNS SETOF record
    AS $$DECLARE
rec RECORD;
BEGIN
	FOR rec IN
		select * from contraintes.af_get_question_reponse_elements(2) as (E_id int4,E_libelle varchar,E_interpretation_html bool,E_reponse bool)
		--select E_id,E_libelle,E_interpretation_html,E_reponse from contraintes.af_get_question_reponse_elements(2) as (E_id int4,E_libelle varchar,E_interpretation_html bool,E_reponse bool) 
	LOOP
		RETURN NEXT rec;
	END LOOP;

	RETURN;

END;$$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_get_sondage_elements() OWNER TO postgres;

--
-- TOC entry 8142 (class 0 OID 0)
-- Dependencies: 1308
-- Name: FUNCTION af_get_sondage_elements(); Type: COMMENT; Schema: contraintes; Owner: postgres
--

COMMENT ON FUNCTION af_get_sondage_elements() IS 'FONCTION PRIVEE: Obtenir les enregistrements de la table question_reponse_element pour un type donnÃ©';


--
-- TOC entry 31 (class 1255 OID 2596147)
-- Dependencies: 2983 5
-- Name: af_get_sondage_propositions(integer); Type: FUNCTION; Schema: contraintes; Owner: pgsql
--

CREATE FUNCTION af_get_sondage_propositions(integer) RETURNS SETOF record
    AS $_$-- $1 : question_reponse
declare
rec record;
begin
    for rec in 
	select $1,a.question_reponse_element,b.question_reponse_element 
	from contraintes.question_reponse_elements a,contraintes.question_reponse_elements b 
	where a.question_reponse_element 
	in (select id from contraintes.question_reponse_element where reponse is false) 
	and b.question_reponse_element 
	in (select id from contraintes.question_reponse_element where reponse is true) 
	and a.question_reponse=$1 and b.question_reponse=$1
    loop
	return next rec;
    end loop;

end;$_$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_get_sondage_propositions(integer) OWNER TO pgsql;

--
-- TOC entry 8144 (class 0 OID 0)
-- Dependencies: 31
-- Name: FUNCTION af_get_sondage_propositions(integer); Type: COMMENT; Schema: contraintes; Owner: pgsql
--

COMMENT ON FUNCTION af_get_sondage_propositions(integer) IS 'retourne les proposition d''un sondage';


--
-- TOC entry 1309 (class 1255 OID 2596148)
-- Dependencies: 2983 5
-- Name: af_get_stagiaire_exotlcs_corriges_formation(integer, integer); Type: FUNCTION; Schema: contraintes; Owner: pgsql
--

CREATE FUNCTION af_get_stagiaire_exotlcs_corriges_formation(integer, integer) RETURNS SETOF record
    AS $_$-- $1 : stagiaire
-- $2 : formation
declare
rec record;
begin
    for rec in
	select * from 
	contraintes.af_get_formation_etapes_type($2,'5') 
	as(id int4, libelle_pour_parcours varchar, libelle_etape  varchar,libelle_type_etape  varchar, type varchar,  pere int4, parcours int4, obligatoire bool, chrono int4, fin bool,libelle_type_original varchar, modifiable bool,indice integer) 
	where id in 
	(select r.etape from contraintes.resultat r where r.formation=$2 and r.stagiaire=$1 and r.id in 
	(select re.id from contraintes.resultat_exotlc re where re.date_correction is not null))
    loop
	return next rec;
    end loop;
end;$_$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_get_stagiaire_exotlcs_corriges_formation(integer, integer) OWNER TO pgsql;

--
-- TOC entry 8146 (class 0 OID 0)
-- Dependencies: 1309
-- Name: FUNCTION af_get_stagiaire_exotlcs_corriges_formation(integer, integer); Type: COMMENT; Schema: contraintes; Owner: pgsql
--

COMMENT ON FUNCTION af_get_stagiaire_exotlcs_corriges_formation(integer, integer) IS 'retourne ts les exotlcs corriges pour un stagiaire et une formtion';


--
-- TOC entry 1310 (class 1255 OID 2596149)
-- Dependencies: 2983 5
-- Name: af_get_stagiaires_formation(); Type: FUNCTION; Schema: contraintes; Owner: pgsql
--

CREATE FUNCTION af_get_stagiaires_formation() RETURNS SETOF record
    AS $$declare
rec record;
begin
    for rec in 
	select distinct i.id,i.nom,i.prenom
	from contraintes.fw_individu i,contraintes.classe_individus ci,contraintes.formation_participants fp
	where i.id=ci.individu and ci.classe=fp.classe
    loop
	return next rec;
    end loop;
end;$$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_get_stagiaires_formation() OWNER TO pgsql;

--
-- TOC entry 8148 (class 0 OID 0)
-- Dependencies: 1310
-- Name: FUNCTION af_get_stagiaires_formation(); Type: COMMENT; Schema: contraintes; Owner: pgsql
--

COMMENT ON FUNCTION af_get_stagiaires_formation() IS 'retourne les stagiaires des formations de la plateforme';


--
-- TOC entry 1311 (class 1255 OID 2596150)
-- Dependencies: 2983 5
-- Name: af_get_template(integer); Type: FUNCTION; Schema: contraintes; Owner: pgsql
--

CREATE FUNCTION af_get_template(integer) RETURNS record
    AS $_$-- $1 : numero modele
declare
rec record;
begin
    select into rec id,libelle from contraintes.modele_correction where id=$1;
    return rec;
end;$_$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_get_template(integer) OWNER TO pgsql;

--
-- TOC entry 8150 (class 0 OID 0)
-- Dependencies: 1311
-- Name: FUNCTION af_get_template(integer); Type: COMMENT; Schema: contraintes; Owner: pgsql
--

COMMENT ON FUNCTION af_get_template(integer) IS 'retourne un modele de correction (id,libelle)';


SET default_tablespace = '';

SET default_with_oids = true;

--
-- TOC entry 3927 (class 1259 OID 2596151)
-- Dependencies: 4952 5
-- Name: modele_correction_criteres; Type: TABLE; Schema: contraintes; Owner: postgres; Tablespace: 
--

CREATE TABLE modele_correction_criteres (
    modele_correction integer NOT NULL,
    critere integer NOT NULL,
    pere integer,
    note_max integer,
    CONSTRAINT check_note_max CHECK ((note_max > 0))
);


ALTER TABLE contraintes.modele_correction_criteres OWNER TO postgres;

--
-- TOC entry 1312 (class 1255 OID 2596154)
-- Dependencies: 2160 2983 5
-- Name: af_get_template_associations(integer); Type: FUNCTION; Schema: contraintes; Owner: pgsql
--

CREATE FUNCTION af_get_template_associations(integer) RETURNS SETOF modele_correction_criteres
    AS $_$-- $1 : numero modele
declare
rec record;
rec2 record;
trans int4;
begin
    for rec in 
	select modele_correction,id,pere,note_max from contraintes.af_get_template_criteres($1) as (modele_correction int4,id int4,libelle varchar,pere int4,note_max int4)
    loop
	if rec.note_max is null then
	    return next rec;
	    -- cas d'un critere avec sous criteres
	    -- boucle sur ses sous criteres 
	
	    for rec2 in 
		select modele_correction,id,pere,note_max from contraintes.af_get_template_sous_criteres($1,rec.id) as (modele_correction int4,id int4,libelle varchar,pere int4,note_max int4)
	    loop
		trans:=rec2.id;
		rec2.id:=rec2.pere;
		rec2.pere:=trans;
		return next rec2;
	    end loop;
	else
	    return next rec;
        end if;
    end loop;
		
	
    return;
end;$_$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_get_template_associations(integer) OWNER TO pgsql;

--
-- TOC entry 8153 (class 0 OID 0)
-- Dependencies: 1312
-- Name: FUNCTION af_get_template_associations(integer); Type: COMMENT; Schema: contraintes; Owner: pgsql
--

COMMENT ON FUNCTION af_get_template_associations(integer) IS 'retourne les associations pour un modele de correction';


--
-- TOC entry 1313 (class 1255 OID 2596155)
-- Dependencies: 2983 5
-- Name: af_get_template_criteres(integer); Type: FUNCTION; Schema: contraintes; Owner: pgsql
--

CREATE FUNCTION af_get_template_criteres(integer) RETURNS SETOF record
    AS $_$-- $1 : nnumero modele
declare
rec record;
t_ids _int4;
i int4 :=0;
begin
    -- recup les criteres du modele ds 1 tablo
    for rec in 
	select c_id
	from contraintes.af_get_template_criteres_non_ordonnes($1) as (c_modele_correction int4,c_id int4,c_libelle varchar,c_pere int4,c_note_max int4)
    loop
	t_ids[i]:=rec.c_id;
	i:=i+1;
    end loop;	
    for rec in 
	select c_modele_correction,c_id,c_libelle,c_pere,c_note_max 
	from contraintes.af_gen_get_elements('contraintes.modele_correction_criteres','critere',NULL,'and modele_correction='||$1,1,t_ids) ID,
	contraintes.af_get_template_criteres_non_ordonnes($1) as (c_modele_correction int4,c_id int4,c_libelle varchar,c_pere int4,c_note_max int4)
	where ID.id=c_id order by ID.ind
    loop
	return next rec;

    end loop;
    return;
end;$_$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_get_template_criteres(integer) OWNER TO pgsql;

--
-- TOC entry 8155 (class 0 OID 0)
-- Dependencies: 1313
-- Name: FUNCTION af_get_template_criteres(integer); Type: COMMENT; Schema: contraintes; Owner: pgsql
--

COMMENT ON FUNCTION af_get_template_criteres(integer) IS 'retourne les criteres d''un modele de correction (ds l''ordre)';


--
-- TOC entry 1314 (class 1255 OID 2596156)
-- Dependencies: 2983 5
-- Name: af_get_template_criteres_non_ordonnes(integer); Type: FUNCTION; Schema: contraintes; Owner: pgsql
--

CREATE FUNCTION af_get_template_criteres_non_ordonnes(integer) RETURNS SETOF record
    AS $_$-- $1 : numero modele
declare
rec record;
begin
    for rec in
	select distinct mc.modele_correction,c_id,c_libelle,c_pere,mc.note_max from contraintes.af_get_criteres() as (c_id int4,c_libelle varchar,c_pere int4),
	contraintes.modele_correction_criteres mc 
	where mc.modele_correction=$1 and c_id=mc.critere and c_pere is null
    loop
	return next rec;
    end loop;
    return;
end;$_$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_get_template_criteres_non_ordonnes(integer) OWNER TO pgsql;

--
-- TOC entry 8157 (class 0 OID 0)
-- Dependencies: 1314
-- Name: FUNCTION af_get_template_criteres_non_ordonnes(integer); Type: COMMENT; Schema: contraintes; Owner: pgsql
--

COMMENT ON FUNCTION af_get_template_criteres_non_ordonnes(integer) IS 'retourne les criteres d''un modele de correction';


--
-- TOC entry 1876 (class 1255 OID 2596157)
-- Dependencies: 2983 5
-- Name: af_get_template_sous_critere(integer, integer, integer); Type: FUNCTION; Schema: contraintes; Owner: pgsql
--

CREATE FUNCTION af_get_template_sous_critere(integer, integer, integer) RETURNS record
    AS $_$-- $1 : numero modele
-- $2 : numero critere
-- $3 : numero ss critere
declare
rec record;

begin
	SELECT INTO rec * FROM contraintes.af_get_template_sous_criteres($1,$2)
	AS (modele_correction int4,id int4,libelle varchar,pere int4,note_max int4)
	WHERE id=$3;

	RETURN rec;
   
end;$_$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_get_template_sous_critere(integer, integer, integer) OWNER TO pgsql;

--
-- TOC entry 8159 (class 0 OID 0)
-- Dependencies: 1876
-- Name: FUNCTION af_get_template_sous_critere(integer, integer, integer); Type: COMMENT; Schema: contraintes; Owner: pgsql
--

COMMENT ON FUNCTION af_get_template_sous_critere(integer, integer, integer) IS 'retourne un sous critere d''un modele ds l''ordre';


--
-- TOC entry 1315 (class 1255 OID 2596158)
-- Dependencies: 2983 5
-- Name: af_get_template_sous_criteres(integer, integer); Type: FUNCTION; Schema: contraintes; Owner: pgsql
--

CREATE FUNCTION af_get_template_sous_criteres(integer, integer) RETURNS SETOF record
    AS $_$-- $1 : numero modele
-- $2 : numero critere
declare
rec record;
t_ids _int4;
i int4 :=0;
begin
    -- recup les sous criteres du modele ds 1 tablo
    for rec in 
	select c_id
	from contraintes.af_get_template_sous_criteres_non_ordonnes($1,$2) as (c_modele_correction int4,c_id int4,c_libelle varchar,c_pere int4,c_note_max int4)
    loop
	t_ids[i]:=rec.c_id;
	i:=i+1;
    end loop;	
    for rec in 
	select c_modele_correction,c_id,c_libelle,c_pere,c_note_max 
	from contraintes.af_gen_get_elements('contraintes.modele_correction_criteres','critere',NULL,'and modele_correction='||$1,1,t_ids) ID,
	contraintes.af_get_template_sous_criteres_non_ordonnes($1,$2) as (c_modele_correction int4,c_id int4,c_libelle varchar,c_pere int4,c_note_max int4)
	where ID.id=c_id order by ID.ind
    loop
	return next rec;

    end loop;
end;$_$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_get_template_sous_criteres(integer, integer) OWNER TO pgsql;

--
-- TOC entry 8161 (class 0 OID 0)
-- Dependencies: 1315
-- Name: FUNCTION af_get_template_sous_criteres(integer, integer); Type: COMMENT; Schema: contraintes; Owner: pgsql
--

COMMENT ON FUNCTION af_get_template_sous_criteres(integer, integer) IS 'retourne les sous criteres d''un modele ds l''ordre';


--
-- TOC entry 1316 (class 1255 OID 2596159)
-- Dependencies: 2983 5
-- Name: af_get_template_sous_criteres_non_ordonnes(integer, integer); Type: FUNCTION; Schema: contraintes; Owner: pgsql
--

CREATE FUNCTION af_get_template_sous_criteres_non_ordonnes(integer, integer) RETURNS SETOF record
    AS $_$-- $1 : numero modele
-- $2 : numero critere
declare
rec record;
begin
    for rec in 
	select distinct mc.modele_correction,c_id,c_libelle,c_pere,mc.note_max from contraintes.af_get_criteres() as (c_id int4,c_libelle varchar,c_pere int4),
	contraintes.modele_correction_criteres mc where 
	mc.modele_correction=$1 and c_id=mc.critere and c_pere=$2
    loop
	return next rec;
    end loop;
    return;
end;$_$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_get_template_sous_criteres_non_ordonnes(integer, integer) OWNER TO pgsql;

--
-- TOC entry 8163 (class 0 OID 0)
-- Dependencies: 1316
-- Name: FUNCTION af_get_template_sous_criteres_non_ordonnes(integer, integer); Type: COMMENT; Schema: contraintes; Owner: pgsql
--

COMMENT ON FUNCTION af_get_template_sous_criteres_non_ordonnes(integer, integer) IS 'retourn les sous critere pour un critere d''un modele de correction';


--
-- TOC entry 1317 (class 1255 OID 2596160)
-- Dependencies: 2983 5
-- Name: af_get_test(integer); Type: FUNCTION; Schema: contraintes; Owner: pgsql
--

CREATE FUNCTION af_get_test(integer) RETURNS record
    AS $_$DECLARE
rec RECORD;
BEGIN
	SELECT INTO rec * FROM contraintes.af_get_tests() AS (id int4, libelle varchar, dynamique bool, continu bool, media int4, hauteur_media int4, largeur_media int4,date_creation timestamp)
	WHERE id=$1;

	RETURN rec;
END;$_$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_get_test(integer) OWNER TO pgsql;

--
-- TOC entry 1318 (class 1255 OID 2596161)
-- Dependencies: 2983 5
-- Name: af_get_test_last_positionnement(integer); Type: FUNCTION; Schema: contraintes; Owner: pgsql
--

CREATE FUNCTION af_get_test_last_positionnement(integer) RETURNS integer
    AS $_$DECLARE
--$1 le numero du test
id int4;
BEGIN
	SELECT INTO id * FROM contraintes.af_gen_get_last_element('contraintes.test_positionnements', 'positionnement', ' AND test='||$1);
	RETURN id;
END;$_$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_get_test_last_positionnement(integer) OWNER TO pgsql;

--
-- TOC entry 1319 (class 1255 OID 2596162)
-- Dependencies: 2983 5
-- Name: af_get_test_parcours(integer); Type: FUNCTION; Schema: contraintes; Owner: pgsql
--

CREATE FUNCTION af_get_test_parcours(integer) RETURNS SETOF record
    AS $$DECLARE
rec RECORD;
BEGIN
	FOR rec IN
		SELECT P_id, P_libelle, P_filiere, P_duree, P_date_creation  FROM contraintes.af_get_parcours() AS (P_id int4, P_libelle varchar, P_filiere int4, P_duree bool, P_date_creation timestamp),
		contraintes.parcours_etapes E
		WHERE E.parcours=P_id

	LOOP
		RETURN NEXT rec;
	END LOOP;
	
	RETURN;
END;$$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_get_test_parcours(integer) OWNER TO pgsql;

--
-- TOC entry 1320 (class 1255 OID 2596163)
-- Dependencies: 2983 5
-- Name: af_get_test_positionnements(integer); Type: FUNCTION; Schema: contraintes; Owner: pgsql
--

CREATE FUNCTION af_get_test_positionnements(integer) RETURNS SETOF record
    AS $_$DECLARE
rec RECORD;
BEGIN
	FOR rec IN
		SELECT P.test, P.positionnement, P.pere
		FROM contraintes.af_gen_get_elements('contraintes.test_positionnements', 'positionnement', NULL, ' AND test='||$1,1) P_id,
		contraintes.test_positionnements P
		WHERE P_id.id=P.positionnement
		AND P.test=$1
		ORDER BY P_id.ind
		
	LOOP
		RETURN NEXT rec;
	END LOOP;

	RETURN;
END;$_$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_get_test_positionnements(integer) OWNER TO pgsql;

--
-- TOC entry 1321 (class 1255 OID 2596164)
-- Dependencies: 2983 5
-- Name: af_get_test_positionnements_disponibles(integer); Type: FUNCTION; Schema: contraintes; Owner: pgsql
--

CREATE FUNCTION af_get_test_positionnements_disponibles(integer) RETURNS SETOF record
    AS $_$DECLARE
rec RECORD;
BEGIN
	FOR rec IN
		SELECT * FROM contraintes.af_get_positionnements() AS (id int4, libelle varchar, type_question int4, chrono int4, serie_aleatoire int4, bareme int4, chrono_gen int4)
		WHERE id NOT IN (
			SELECT DISTINCT positionnement 
			FROM contraintes.af_get_test_positionnements($1) AS (test int4, positionnement int4, pere int4)
				)
	LOOP
		RETURN NEXT rec;
	END LOOP;

	RETURN;
END;$_$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_get_test_positionnements_disponibles(integer) OWNER TO pgsql;

--
-- TOC entry 1322 (class 1255 OID 2596165)
-- Dependencies: 2983 5
-- Name: af_get_test_positionnements_infos(integer); Type: FUNCTION; Schema: contraintes; Owner: pgsql
--

CREATE FUNCTION af_get_test_positionnements_infos(integer) RETURNS SETOF record
    AS $_$DECLARE
rec RECORD;
BEGIN
	FOR rec IN
		SELECT PO.id, PO.libelle, PO.type_question, PO.chrono, PO.serie_aleatoire, PO.question_reponse, $1
		FROM contraintes.af_gen_get_elements('contraintes.test_positionnements', 'positionnement', NULL, ' AND test='||$1,1) P_id,
		contraintes.test_positionnements P, contraintes.positionnement PO
		WHERE P_id.id=P.positionnement
		AND P.test=$1
		AND P_id.id=PO.id
		ORDER BY P_id.ind
		
	LOOP
		RETURN NEXT rec;
	END LOOP;

	RETURN;
END;$_$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_get_test_positionnements_infos(integer) OWNER TO pgsql;

--
-- TOC entry 1323 (class 1255 OID 2596166)
-- Dependencies: 2983 5
-- Name: af_get_test_somme_chronos(integer); Type: FUNCTION; Schema: contraintes; Owner: pgsql
--

CREATE FUNCTION af_get_test_somme_chronos(integer) RETURNS integer
    AS $_$DECLARE
--$1 serie
somme int4;
BEGIN
	SELECT INTO somme SUM(chrono)
	FROM contraintes.af_get_test_positionnements_infos($1) AS  ( id int4, libelle varchar, type  int4, chrono  int4, serie_aleatoire int4, question_reponse int4, test int4 );

	RETURN somme;
END;$_$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_get_test_somme_chronos(integer) OWNER TO pgsql;

--
-- TOC entry 1324 (class 1255 OID 2596167)
-- Dependencies: 2983 5
-- Name: af_get_tests(); Type: FUNCTION; Schema: contraintes; Owner: pgsql
--

CREATE FUNCTION af_get_tests() RETURNS SETOF record
    AS $$DECLARE
rec RECORD;
BEGIN
	FOR rec IN 
		SELECT E_id , E_libelle,  T.dynamique, T.continu,  M.media, M.hauteur , M.largeur,date_creation  
		FROM (
			( contraintes.af_get_etapes() AS (E_id int4, E_libelle varchar, E_type int4,date_creation timestamp) INNER JOIN  contraintes.test T  ON  E_id=T.id )
			LEFT OUTER JOIN contraintes.media_test M ON T.id=M.test
		     )
		ORDER BY E_libelle
	LOOP
		RETURN NEXT rec;
	END LOOP;
END;$$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_get_tests() OWNER TO pgsql;

--
-- TOC entry 1325 (class 1255 OID 2596168)
-- Dependencies: 2983 5
-- Name: af_get_theme(integer); Type: FUNCTION; Schema: contraintes; Owner: postgres
--

CREATE FUNCTION af_get_theme(integer) RETURNS record
    AS $_$DECLARE
rec RECORD;

BEGIN
	--pour la conversion du int4 en varchar, on utilise un masque de 9999999999 car les valeurs d'un int4
	--vont de -2147483648 Ã  +2147483647, il faut ensuite supprimer les blancs du dÃ©but de la chaine du aux '9' inutiles par rapport aux
	--nombres de chiffres rÃ©els du nombre 
	SELECT INTO rec id, libelle,  trim(leading ' ' from (CAST(to_char(id, '9999999999') AS varchar))),individu FROM contraintes.theme WHERE id=$1;
	RETURN rec;
END;$_$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_get_theme(integer) OWNER TO postgres;

--
-- TOC entry 8173 (class 0 OID 0)
-- Dependencies: 1325
-- Name: FUNCTION af_get_theme(integer); Type: COMMENT; Schema: contraintes; Owner: postgres
--

COMMENT ON FUNCTION af_get_theme(integer) IS 'Obtenir le theme dont l''identifiant est passÃ© en paramettre';


--
-- TOC entry 1326 (class 1255 OID 2596169)
-- Dependencies: 2983 5
-- Name: af_get_theme(character varying); Type: FUNCTION; Schema: contraintes; Owner: postgres
--

CREATE FUNCTION af_get_theme(character varying) RETURNS record
    AS $_$DECLARE
rec RECORD;

BEGIN
	--pour la conversion du int4 en varchar, on utilise un masque de 9999999999 car les valeurs d'un int4
	--vont de -2147483648 Ã  +2147483647, il faut ensuite supprimer les blancs du dÃ©but de la chaine du aux '9' inutiles par rapport aux
	--nombres de chiffres rÃ©els du nombre 
	SELECT INTO rec id, libelle,  trim(leading ' ' from (CAST(to_char(id, '9999999999') AS varchar))) FROM contraintes.theme WHERE libelle LIKE $1;
	RETURN rec;
END;$_$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_get_theme(character varying) OWNER TO postgres;

--
-- TOC entry 8175 (class 0 OID 0)
-- Dependencies: 1326
-- Name: FUNCTION af_get_theme(character varying); Type: COMMENT; Schema: contraintes; Owner: postgres
--

COMMENT ON FUNCTION af_get_theme(character varying) IS 'Obtenir le theme dont le libéllé est passé en paramettre';


--
-- TOC entry 1327 (class 1255 OID 2596170)
-- Dependencies: 2983 5
-- Name: af_get_theme_capacites(integer); Type: FUNCTION; Schema: contraintes; Owner: pgsql
--

CREATE FUNCTION af_get_theme_capacites(integer) RETURNS SETOF record
    AS $_$-- $1 : numero theme
declare
rec record;
begin
    for rec in 
	select c.id,c.libelle from contraintes.capacite c,
	contraintes.af_get_categorie_elements_theme(10,$1) tc 
	where c.id=tc
    loop
	return next rec;
    end loop;
    return;
end;$_$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_get_theme_capacites(integer) OWNER TO pgsql;

--
-- TOC entry 8177 (class 0 OID 0)
-- Dependencies: 1327
-- Name: FUNCTION af_get_theme_capacites(integer); Type: COMMENT; Schema: contraintes; Owner: pgsql
--

COMMENT ON FUNCTION af_get_theme_capacites(integer) IS 'retourne les capacite pour un theme';


--
-- TOC entry 1328 (class 1255 OID 2596171)
-- Dependencies: 2983 5
-- Name: af_get_theme_capacites_titres(integer); Type: FUNCTION; Schema: contraintes; Owner: pgsql
--

CREATE FUNCTION af_get_theme_capacites_titres(integer) RETURNS SETOF record
    AS $_$-- $1 : numero theme
declare
rec record;
begin
    for rec in 
	select c.id,c.libelle from contraintes.capacite_titre c,
	contraintes.af_get_categorie_elements_theme(11,$1) tc 
	where c.id=tc
    loop
	return next rec;
    end loop;
    return;
end;$_$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_get_theme_capacites_titres(integer) OWNER TO pgsql;

--
-- TOC entry 8179 (class 0 OID 0)
-- Dependencies: 1328
-- Name: FUNCTION af_get_theme_capacites_titres(integer); Type: COMMENT; Schema: contraintes; Owner: pgsql
--

COMMENT ON FUNCTION af_get_theme_capacites_titres(integer) IS 'retourne les titres de capacite pour un theme';


--
-- TOC entry 1329 (class 1255 OID 2596172)
-- Dependencies: 2983 5
-- Name: af_get_theme_categories(integer); Type: FUNCTION; Schema: contraintes; Owner: postgres
--

CREATE FUNCTION af_get_theme_categories(integer) RETURNS SETOF record
    AS $_$DECLARE
rec RECORD;
BEGIN

	FOR rec IN
		SELECT DISTINCT C_id, C_libelle, C_table_cible, C_gestionnaire_contenu, C_code FROM contraintes.af_get_categories() AS (C_id int4, C_libelle varchar, C_table_cible varchar, C_gestionnaire_contenu bool, C_code varchar), contraintes.theme_categories TC
		WHERE TC.theme=$1
		AND TC.categorie=C_id
	LOOP
		RETURN NEXT rec;
	END LOOP;

	RETURN;
END$_$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_get_theme_categories(integer) OWNER TO postgres;

--
-- TOC entry 8181 (class 0 OID 0)
-- Dependencies: 1329
-- Name: FUNCTION af_get_theme_categories(integer); Type: COMMENT; Schema: contraintes; Owner: postgres
--

COMMENT ON FUNCTION af_get_theme_categories(integer) IS 'Obtenir les categories qui ont des éléments dans un theme.';


--
-- TOC entry 1330 (class 1255 OID 2596173)
-- Dependencies: 2983 5
-- Name: af_get_theme_criteres(integer); Type: FUNCTION; Schema: contraintes; Owner: pgsql
--

CREATE FUNCTION af_get_theme_criteres(integer) RETURNS SETOF record
    AS $_$-- $1 : numero theme
declare
rec record;
begin
    for rec in 
	select C_id,C_libelle,C_pere from contraintes.af_get_criteres()  as (C_id int4,C_libelle varchar,C_pere int4),
	contraintes.af_get_categorie_elements_theme(12,$1) ET 
	where C_id=ET and C_pere is null
    loop
	return next rec;
    end loop;
    return;
end;$_$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_get_theme_criteres(integer) OWNER TO pgsql;

--
-- TOC entry 8183 (class 0 OID 0)
-- Dependencies: 1330
-- Name: FUNCTION af_get_theme_criteres(integer); Type: COMMENT; Schema: contraintes; Owner: pgsql
--

COMMENT ON FUNCTION af_get_theme_criteres(integer) IS 'retourne les criteres de correction pour un theme';


--
-- TOC entry 1331 (class 1255 OID 2596174)
-- Dependencies: 2983 5
-- Name: af_get_theme_elements(integer); Type: FUNCTION; Schema: contraintes; Owner: pgsql
--

CREATE FUNCTION af_get_theme_elements(integer) RETURNS SETOF record
    AS $_$DECLARE
rec RECORD;
BEGIN
	FOR rec IN
		SELECT A_id,A_categorie FROM contraintes.af_get_theme_elements_all($1) AS (A_id int4, A_categorie int4, theme int4)	,
		contraintes.fichier_type T
		WHERE A_categorie NOT IN (SELECT categorie FROM contraintes.fichier_type WHERE categorie IS NOT NULL)
		UNION
		SELECT A_id,A_categorie FROM contraintes.af_get_theme_elements_all($1) AS (A_id int4, A_categorie int4, theme int4)	,
		contraintes.fichier_type T, contraintes.fichier F
		WHERE T.id=F.type
		AND F.connecte=TRUE
		AND A_categorie=T.categorie
		AND A_id=F.id
	LOOP
		RETURN NEXT rec;
	END LOOP;

	RETURN;
	
END				$_$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_get_theme_elements(integer) OWNER TO pgsql;

--
-- TOC entry 8185 (class 0 OID 0)
-- Dependencies: 1331
-- Name: FUNCTION af_get_theme_elements(integer); Type: COMMENT; Schema: contraintes; Owner: pgsql
--

COMMENT ON FUNCTION af_get_theme_elements(integer) IS 'Obtenir les éléments (et leur categorie) d''un theme.';


--
-- TOC entry 1332 (class 1255 OID 2596175)
-- Dependencies: 2983 5
-- Name: af_get_theme_elements_all(integer); Type: FUNCTION; Schema: contraintes; Owner: pgsql
--

CREATE FUNCTION af_get_theme_elements_all(integer) RETURNS SETOF record
    AS $_$DECLARE
rec RECORD;

BEGIN

	FOR rec IN
		SELECT id, categorie, theme FROM contraintes.theme_categories 
		WHERE theme=$1 ORDER BY categorie
	LOOP
		RETURN NEXT rec;
	END LOOP;


	RETURN;
END$_$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_get_theme_elements_all(integer) OWNER TO pgsql;

--
-- TOC entry 8187 (class 0 OID 0)
-- Dependencies: 1332
-- Name: FUNCTION af_get_theme_elements_all(integer); Type: COMMENT; Schema: contraintes; Owner: pgsql
--

COMMENT ON FUNCTION af_get_theme_elements_all(integer) IS 'FONCTION PRIVEE:
Retourne tous les Ã©lÃ©ments d''un theme, y compris les fichiers non connectÃ©s';


--
-- TOC entry 1333 (class 1255 OID 2596176)
-- Dependencies: 2983 5
-- Name: af_get_theme_etapes_forum(integer); Type: FUNCTION; Schema: contraintes; Owner: pgsql
--

CREATE FUNCTION af_get_theme_etapes_forum(integer) RETURNS SETOF record
    AS $_$-- $1 : theme
declare
rec record;
begin
    for rec in
	select ef.id,e.libelle,f.id,f.libelle,f.description,f.moderation,f.moderateur_pwd,f.fils,f.messages,f.upload,f.theme,fe.environnement,date_creation 
	from contraintes.etape e ,
	contraintes.af_get_categorie_elements_theme(61,$1) tc,
	contraintes.etape_forum ef  left outer join contraintes.forum f on (f.id=ef.forum)
	left outer join contraintes.forum_environnements fe ON (fe.forum=f.id) 
	where e.id=ef.id
	and ef.id=tc
	
	
    loop
	return next rec;
    end loop;
end;$_$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_get_theme_etapes_forum(integer) OWNER TO pgsql;

--
-- TOC entry 8189 (class 0 OID 0)
-- Dependencies: 1333
-- Name: FUNCTION af_get_theme_etapes_forum(integer); Type: COMMENT; Schema: contraintes; Owner: pgsql
--

COMMENT ON FUNCTION af_get_theme_etapes_forum(integer) IS 'retourne les etapes forum d''un theme';


--
-- TOC entry 1334 (class 1255 OID 2596177)
-- Dependencies: 2983 5
-- Name: af_get_theme_etapes_ressource(integer); Type: FUNCTION; Schema: contraintes; Owner: pgsql
--

CREATE FUNCTION af_get_theme_etapes_ressource(integer) RETURNS SETOF record
    AS $_$-- $1 : theme
declare
rec record;
begin
    for rec in 
	SELECT er.id,e.libelle,er.espace,er.section,fm.id,er.fichier,fm.mots_cles 
	FROM contraintes.etape e,
	contraintes.af_get_categorie_elements_theme(39,$1) tc,
	contraintes.etape_ressource er LEFT OUTER JOIN
	(contraintes.fichier_ressource fr LEFT OUTER JOIN
	contraintes.fichier_metadata fm ON (fr.id=fm.id)) ON (er.fichier=fr.id)
	WHERE er.id=e.id
	AND tc=e.id 
    loop
	return next rec;
    end loop;
end;$_$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_get_theme_etapes_ressource(integer) OWNER TO pgsql;

--
-- TOC entry 8191 (class 0 OID 0)
-- Dependencies: 1334
-- Name: FUNCTION af_get_theme_etapes_ressource(integer); Type: COMMENT; Schema: contraintes; Owner: pgsql
--

COMMENT ON FUNCTION af_get_theme_etapes_ressource(integer) IS 'retourne les etapes ressource d''un theme';


--
-- TOC entry 1335 (class 1255 OID 2596178)
-- Dependencies: 2983 5
-- Name: af_get_theme_evaluations(integer); Type: FUNCTION; Schema: contraintes; Owner: pgsql
--

CREATE FUNCTION af_get_theme_evaluations(integer) RETURNS SETOF record
    AS $_$declare
rec record;
begin
    for rec in
	select distinct e.id,e.type from contraintes.evaluation e,
	contraintes.categorie_evaluation ce--,
	--contraintes.serie_evaluations se
	where 
	--e.id=se.evaluation 
	--and 
	e.id=ce.id 
	and ce.theme=$1
    loop
    return next rec;
    end loop;
    return;
end;$_$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_get_theme_evaluations(integer) OWNER TO pgsql;

--
-- TOC entry 8193 (class 0 OID 0)
-- Dependencies: 1335
-- Name: FUNCTION af_get_theme_evaluations(integer); Type: COMMENT; Schema: contraintes; Owner: pgsql
--

COMMENT ON FUNCTION af_get_theme_evaluations(integer) IS 'retourne les évaluations pour un theme';


--
-- TOC entry 1336 (class 1255 OID 2596179)
-- Dependencies: 2983 5
-- Name: af_get_theme_exostlc_titre(integer, character varying); Type: FUNCTION; Schema: contraintes; Owner: pgsql
--

CREATE FUNCTION af_get_theme_exostlc_titre(integer, character varying) RETURNS SETOF record
    AS $_$-- $1 : numero theme
-- $2 : asc ou desc
declare
rec record;
req varchar;
begin
    req:='select  GE_id ,GE_libelle ,lower(GE_libelle) as minus,E.type , GE_date_creation from contraintes.af_get_etapes() as (GE_id int4,GE_libelle varchar,GE_type int4, GE_date_creation timestamp) ,
    contraintes.categorie_exotlc CE,contraintes.exotlc E where GE_id=CE.id and GE_id=E.id and CE.theme='||$1||' order by minus ' || $2;
    for rec in
	execute req
    loop
	return next rec;
    end loop;
    return;
end;$_$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_get_theme_exostlc_titre(integer, character varying) OWNER TO pgsql;

--
-- TOC entry 8195 (class 0 OID 0)
-- Dependencies: 1336
-- Name: FUNCTION af_get_theme_exostlc_titre(integer, character varying); Type: COMMENT; Schema: contraintes; Owner: pgsql
--

COMMENT ON FUNCTION af_get_theme_exostlc_titre(integer, character varying) IS 'retourne les exos tlc (classés par titre)pour un theme';


--
-- TOC entry 1337 (class 1255 OID 2596180)
-- Dependencies: 2983 5
-- Name: af_get_theme_exostlc_type(integer, character varying); Type: FUNCTION; Schema: contraintes; Owner: pgsql
--

CREATE FUNCTION af_get_theme_exostlc_type(integer, character varying) RETURNS SETOF record
    AS $_$-- $1 : numero theme
-- $2 : asc ou desc
declare
rec record;
req varchar;
begin
    req:='select  GE_id ,GE_libelle,lower(GE_libelle) ,E.type, GE_date_creation from contraintes.af_get_etapes() as (GE_id int4,GE_libelle varchar,GE_type int4, GE_date_creation timestamp) ,
    contraintes.categorie_exotlc CE,contraintes.exotlc E where GE_id=CE.id and GE_id=E.id and CE.theme='||$1||' order by E.type ' || $2;
    for rec in
	execute req
    loop
	return next rec;
    end loop;
    return;
end;$_$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_get_theme_exostlc_type(integer, character varying) OWNER TO pgsql;

--
-- TOC entry 8197 (class 0 OID 0)
-- Dependencies: 1337
-- Name: FUNCTION af_get_theme_exostlc_type(integer, character varying); Type: COMMENT; Schema: contraintes; Owner: pgsql
--

COMMENT ON FUNCTION af_get_theme_exostlc_type(integer, character varying) IS 'retourne les exos tlc (classés par type) pour un theme';


--
-- TOC entry 1877 (class 1255 OID 2596181)
-- Dependencies: 2983 5
-- Name: af_get_theme_fichiers_blocs_scenarios(integer); Type: FUNCTION; Schema: contraintes; Owner: postgres
--

CREATE FUNCTION af_get_theme_fichiers_blocs_scenarios(integer) RETURNS SETOF record
    AS $_$DECLARE
rec RECORD;
BEGIN
	FOR rec IN
		SELECT F_id, F_libelle, F_type , F_connecte, BS.date_modification,58,$1
		FROM contraintes.af_get_fichiers() AS ( F_id int4, F_libelle varchar, F_type int4, F_connecte bool),
		contraintes.fichier_bloc_scenario BS,
		contraintes.af_get_categorie_elements_theme(58,$1) C_id
		WHERE BS.id=F_id
		AND C_id=F_id
		
	LOOP
		RETURN NEXT rec;
	END LOOP;

	RETURN;
END$_$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_get_theme_fichiers_blocs_scenarios(integer) OWNER TO postgres;

--
-- TOC entry 1338 (class 1255 OID 2596182)
-- Dependencies: 2983 5
-- Name: af_get_theme_fichiers_scenarios_dynamiques(integer, character varying); Type: FUNCTION; Schema: contraintes; Owner: pgsql
--

CREATE FUNCTION af_get_theme_fichiers_scenarios_dynamiques(integer, character varying) RETURNS SETOF record
    AS $_$DECLARE
rec RECORD;
--$1 theme
--$2 message
req varchar;
msg alias for $2;
BEGIN

	req:='SELECT F_id, F_libelle, F_type , F_connecte, SD.style, SD.date_modification
	FROM contraintes.af_get_fichiers() AS ( F_id int4, F_libelle varchar, F_type int4, F_connecte bool),
	contraintes.fichier_scenario_dynamique SD,
	contraintes.af_get_categorie_elements_theme(59,'||$1||') AS elt
	WHERE SD.id=F_id
	AND F_id=elt';
	if $2 is not null then
		req:=req || ' and F_libelle like '''||msg||''''; 
	end if;
	FOR rec IN
		execute req
	LOOP
		
		RETURN NEXT rec;
	END LOOP;
	RETURN;
END;$_$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_get_theme_fichiers_scenarios_dynamiques(integer, character varying) OWNER TO pgsql;

--
-- TOC entry 1339 (class 1255 OID 2596183)
-- Dependencies: 2983 5
-- Name: af_get_theme_fichiers_slides_scenarios(integer); Type: FUNCTION; Schema: contraintes; Owner: postgres
--

CREATE FUNCTION af_get_theme_fichiers_slides_scenarios(integer) RETURNS SETOF record
    AS $_$DECLARE
rec RECORD;
BEGIN
	FOR rec IN
		SELECT F_id, F_libelle, F_type , F_connecte, BS.date_modification,62,$1
		FROM contraintes.af_get_fichiers() AS ( F_id int4, F_libelle varchar, F_type int4, F_connecte bool),
		contraintes.fichier_slide_scenario BS,
		contraintes.af_get_categorie_elements_theme(62,$1) C_id
		WHERE BS.id=F_id
		AND C_id=F_id
		
	LOOP
		RETURN NEXT rec;
	END LOOP;

	RETURN;
END$_$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_get_theme_fichiers_slides_scenarios(integer) OWNER TO postgres;

--
-- TOC entry 1340 (class 1255 OID 2596184)
-- Dependencies: 2983 5
-- Name: af_get_theme_ftbs(integer, integer); Type: FUNCTION; Schema: contraintes; Owner: pgsql
--

CREATE FUNCTION af_get_theme_ftbs(integer, integer) RETURNS SETOF record
    AS $_$declare
rec record;
begin
for rec in
    select DISTINCT f.id,f.text,f.voir_mots,f.interpretation_html
    from contraintes.ftb f,contraintes.af_get_categorie_elements_theme($2,$1) e_id
    where f.id=e_id
loop
    return next rec;
end loop;
return;
end;$_$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_get_theme_ftbs(integer, integer) OWNER TO pgsql;

--
-- TOC entry 8202 (class 0 OID 0)
-- Dependencies: 1340
-- Name: FUNCTION af_get_theme_ftbs(integer, integer); Type: COMMENT; Schema: contraintes; Owner: pgsql
--

COMMENT ON FUNCTION af_get_theme_ftbs(integer, integer) IS 'retourn les exos "remplir les blancs" pour le theme';


--
-- TOC entry 32 (class 1255 OID 2596185)
-- Dependencies: 2983 5
-- Name: af_get_theme_glossaires(integer); Type: FUNCTION; Schema: contraintes; Owner: postgres
--

CREATE FUNCTION af_get_theme_glossaires(integer) RETURNS SETOF record
    AS $_$-- $1 : theme
declare
rec record;
begin
    for rec in
	select g.id,g.libelle from contraintes.glossaire g,
	contraintes.af_get_categorie_elements_theme(67,$1) tc 
	where g.id=tc
    loop
	return next rec;
    end loop;
end;$_$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_get_theme_glossaires(integer) OWNER TO postgres;

--
-- TOC entry 8204 (class 0 OID 0)
-- Dependencies: 32
-- Name: FUNCTION af_get_theme_glossaires(integer); Type: COMMENT; Schema: contraintes; Owner: postgres
--

COMMENT ON FUNCTION af_get_theme_glossaires(integer) IS 'retourne les glossaire pour un theme';


--
-- TOC entry 1341 (class 1255 OID 2596186)
-- Dependencies: 2983 5
-- Name: af_get_theme_grilles(integer); Type: FUNCTION; Schema: contraintes; Owner: pgsql
--

CREATE FUNCTION af_get_theme_grilles(integer) RETURNS SETOF record
    AS $_$-- $1 : numero theme
declare
rec record;
begin
    for rec in 
	select c.id,c.libelle from contraintes.grille c,
	contraintes.af_get_categorie_elements_theme(15,$1) tc 
	where c.id=tc
    loop
	return next rec;
    end loop;
    return;
end;$_$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_get_theme_grilles(integer) OWNER TO pgsql;

--
-- TOC entry 8206 (class 0 OID 0)
-- Dependencies: 1341
-- Name: FUNCTION af_get_theme_grilles(integer); Type: COMMENT; Schema: contraintes; Owner: pgsql
--

COMMENT ON FUNCTION af_get_theme_grilles(integer) IS 'retourne les grilles presentielles pour un theme';


--
-- TOC entry 1342 (class 1255 OID 2596187)
-- Dependencies: 2983 5
-- Name: af_get_theme_grilles_capacite(integer); Type: FUNCTION; Schema: contraintes; Owner: pgsql
--

CREATE FUNCTION af_get_theme_grilles_capacite(integer) RETURNS SETOF record
    AS $_$-- $1 : theme
declare
rec record;
begin
    for rec in
	select distinct g_id,g_libelle from contraintes.af_get_theme_grilles($1) as (g_id int4,g_libelle varchar),
	contraintes.grille_capacites_titres gct,contraintes.capacite_titre_capacites ctc 
	where g_id=gct.grille and gct.capacite_titre=ctc.capacite_titre
    loop
	return next rec;
    end loop;
end;$_$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_get_theme_grilles_capacite(integer) OWNER TO pgsql;

--
-- TOC entry 8208 (class 0 OID 0)
-- Dependencies: 1342
-- Name: FUNCTION af_get_theme_grilles_capacite(integer); Type: COMMENT; Schema: contraintes; Owner: pgsql
--

COMMENT ON FUNCTION af_get_theme_grilles_capacite(integer) IS 'retourne les grilles (avec capacite) pour le theme';


--
-- TOC entry 1343 (class 1255 OID 2596188)
-- Dependencies: 2983 5
-- Name: af_get_theme_modeles_correction(integer); Type: FUNCTION; Schema: contraintes; Owner: pgsql
--

CREATE FUNCTION af_get_theme_modeles_correction(integer) RETURNS SETOF record
    AS $_$-- $1 : numero theme
declare
rec record;
begin
    for rec in 
	select mc.id,mc.libelle from contraintes.modele_correction mc,
	contraintes.af_get_categorie_elements_theme(16,$1) tc 
	where mc.id=tc
    loop
	return next rec;
    end loop;
    return;
end;$_$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_get_theme_modeles_correction(integer) OWNER TO pgsql;

--
-- TOC entry 8210 (class 0 OID 0)
-- Dependencies: 1343
-- Name: FUNCTION af_get_theme_modeles_correction(integer); Type: COMMENT; Schema: contraintes; Owner: pgsql
--

COMMENT ON FUNCTION af_get_theme_modeles_correction(integer) IS 'retorne les modeles de correction pour un theme';


--
-- TOC entry 1344 (class 1255 OID 2596189)
-- Dependencies: 2983 5
-- Name: af_get_theme_positionnements(integer); Type: FUNCTION; Schema: contraintes; Owner: pgsql
--

CREATE FUNCTION af_get_theme_positionnements(integer) RETURNS SETOF record
    AS $_$DECLARE
rec RECORD;
BEGIN
	FOR rec IN
		SELECT P.id, P.libelle, P.type_question, P.chrono, P.serie_aleatoire, P.question_reponse, C_theme 
		FROM contraintes.positionnement P,
		contraintes.af_get_categorie_elements(22) AS (C_id int4, C_theme int4, C_categorie int4)
		WHERE P.id=C_id
		AND C_theme=$1
		ORDER BY P.libelle
	LOOP
		RETURN NEXT rec;
	END LOOP;

	RETURN;
END$_$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_get_theme_positionnements(integer) OWNER TO pgsql;

--
-- TOC entry 1345 (class 1255 OID 2596190)
-- Dependencies: 2983 5
-- Name: af_get_theme_qsrcs(integer, integer, integer); Type: FUNCTION; Schema: contraintes; Owner: pgsql
--

CREATE FUNCTION af_get_theme_qsrcs(integer, integer, integer) RETURNS SETOF record
    AS $_$DECLARE
--$1 le theme
--$2 la categorie
--$3 le type de question_reponse
rec RECORD;
BEGIN
	FOR rec IN
	
		SELECT  E.id , E.libelle, E.type, QS.question, QS.id 
		FROM contraintes.evaluation E,
		contraintes.af_get_categorie_elements_theme($2, $1) T_ID,
		contraintes.qsrc QS
		WHERE E.type=$3
		AND E.id=T_ID
		AND QS.id=T_ID

	LOOP
		RETURN NEXT rec;
	END LOOP;

	RETURN;
END$_$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_get_theme_qsrcs(integer, integer, integer) OWNER TO pgsql;

--
-- TOC entry 8213 (class 0 OID 0)
-- Dependencies: 1345
-- Name: FUNCTION af_get_theme_qsrcs(integer, integer, integer); Type: COMMENT; Schema: contraintes; Owner: pgsql
--

COMMENT ON FUNCTION af_get_theme_qsrcs(integer, integer, integer) IS 'Obtenir les qsrc d''un theme.';


--
-- TOC entry 1346 (class 1255 OID 2596191)
-- Dependencies: 2983 5
-- Name: af_get_theme_question_reponse_elements(integer, integer, integer, boolean); Type: FUNCTION; Schema: contraintes; Owner: pgsql
--

CREATE FUNCTION af_get_theme_question_reponse_elements(integer, integer, integer, boolean) RETURNS SETOF record
    AS $_$DECLARE
--$1 le theme
--$2 la categorie
--$3 le type de question_reponse_element
--$4 reponse ou pas
rec RECORD;

BEGIN

	FOR rec IN
	
		SELECT E.id, E.libelle , E.interpretation_html , E.type, E.reponse FROM contraintes.question_reponse_element E,
		contraintes.af_get_categorie_elements_theme($2, $1) C_id
		WHERE E.id=C_id
		AND E.reponse=$4
		AND E.type=$3
	LOOP
		RETURN NEXT rec;
	END LOOP;

	RETURN;
END$_$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_get_theme_question_reponse_elements(integer, integer, integer, boolean) OWNER TO pgsql;

--
-- TOC entry 8215 (class 0 OID 0)
-- Dependencies: 1346
-- Name: FUNCTION af_get_theme_question_reponse_elements(integer, integer, integer, boolean); Type: COMMENT; Schema: contraintes; Owner: pgsql
--

COMMENT ON FUNCTION af_get_theme_question_reponse_elements(integer, integer, integer, boolean) IS 'Obtenir les question_reponse_elements d''un theme.';


--
-- TOC entry 1878 (class 1255 OID 2596192)
-- Dependencies: 2983 5
-- Name: af_get_theme_question_reponse_reponses(integer, integer, integer); Type: FUNCTION; Schema: contraintes; Owner: postgres
--

CREATE FUNCTION af_get_theme_question_reponse_reponses(integer, integer, integer) RETURNS SETOF record
    AS $_$declare
rec record;
null_value int4:=NULL;
begin
	for rec in
		--les elements qui ne sont pas associés
		(select distinct R_id,R_libelle, null_value,  R_inter, R_type from 
		--les reponses
		contraintes.af_get_reponses() as (R_id int4,R_libelle varchar,R_inter bool,R_type int4),
		--les elements rangÃ©s dans un theme
		contraintes.af_get_categorie_elements_theme($2,$1) C_id
		--les associations question reponse
		--,contraintes.question_reponse_elements E
		--where E.question_reponse=C_id 
		--and E.question=R_id
		WHERE C_id=R_id
		AND R_type=$3
		AND C_id NOT IN 
			(select distinct E.reponse from 
			--les associations question reponse
			contraintes.question_reponse_elements E)	
		)

		UNION

		--les elements associés
		(select distinct R_id,R_libelle, E.question_reponse , R_inter, R_type from 
		--les reponses
		contraintes.af_get_reponses() as (R_id int4,R_libelle varchar,R_inter bool,R_type int4),
		--les elements rangÃ©s dans un theme
		contraintes.af_get_categorie_elements_theme($2,$1) C_id
		--les associations question reponse
		,contraintes.question_reponse_elements E
		where E.reponse=C_id
		AND R_type=$3
		and E.reponse=R_id)
		

	loop
		return next rec;
	end loop;
	return;
end;$_$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_get_theme_question_reponse_reponses(integer, integer, integer) OWNER TO postgres;

--
-- TOC entry 8217 (class 0 OID 0)
-- Dependencies: 1878
-- Name: FUNCTION af_get_theme_question_reponse_reponses(integer, integer, integer); Type: COMMENT; Schema: contraintes; Owner: postgres
--

COMMENT ON FUNCTION af_get_theme_question_reponse_reponses(integer, integer, integer) IS 'Obtenir les questions de qcm pour un theme (auteur : said modifié par rémi)';


--
-- TOC entry 1347 (class 1255 OID 2596193)
-- Dependencies: 2983 5
-- Name: af_get_theme_question_reponses(integer, integer, integer); Type: FUNCTION; Schema: contraintes; Owner: pgsql
--

CREATE FUNCTION af_get_theme_question_reponses(integer, integer, integer) RETURNS SETOF record
    AS $_$DECLARE
--$1 le theme
--$2 la categorie
--$3 le type de question_reponse
rec RECORD;
BEGIN
	FOR rec IN
	
		SELECT DISTINCT QR.id , QR.type, QR.radio 
		FROM contraintes.question_reponse QR,
		contraintes.af_get_categorie_elements_theme($2, $1) T_ID
		WHERE QR.type=$3
		AND QR.id=T_ID

	LOOP
		RETURN NEXT rec;
	END LOOP;

	RETURN;
END$_$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_get_theme_question_reponses(integer, integer, integer) OWNER TO pgsql;

--
-- TOC entry 8219 (class 0 OID 0)
-- Dependencies: 1347
-- Name: FUNCTION af_get_theme_question_reponses(integer, integer, integer); Type: COMMENT; Schema: contraintes; Owner: pgsql
--

COMMENT ON FUNCTION af_get_theme_question_reponses(integer, integer, integer) IS 'Obtenir les question_reponses d''un theme.';


--
-- TOC entry 1348 (class 1255 OID 2596194)
-- Dependencies: 2983 5
-- Name: af_get_theme_ressources(integer); Type: FUNCTION; Schema: contraintes; Owner: pgsql
--

CREATE FUNCTION af_get_theme_ressources(integer) RETURNS SETOF record
    AS $_$-- $1 : theme
declare
rec record;
begin
    for rec in 
	/* non! pas d'étape ici!
	select r.id,e.libelle,fichier,mots_cles from contraintes.ressource r,
	contraintes.etape_ressource er,
	contraintes.af_get_categorie_elements_theme(39,$1) tc, 
	contraintes.etape e
	where er.id=tc and er.ressource=r.id and e.id=er.id
	*/
	SELECT f.id,f.libelle,f.id,fm.mots_cles 
	FROM
	contraintes.af_get_categorie_elements_theme(43,$1) fichier_ressource_id,
	contraintes.fichier_ressource fr,
	contraintes.fichier f LEFT OUTER JOIN 
	contraintes.fichier_metadata fm ON (f.id=fm.id)
	WHERE fichier_ressource_id=fr.id
	AND fr.id=f.id
	AND f.connecte IS TRUE

    loop
	return next rec;
    end loop;
end;$_$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_get_theme_ressources(integer) OWNER TO pgsql;

--
-- TOC entry 8221 (class 0 OID 0)
-- Dependencies: 1348
-- Name: FUNCTION af_get_theme_ressources(integer); Type: COMMENT; Schema: contraintes; Owner: pgsql
--

COMMENT ON FUNCTION af_get_theme_ressources(integer) IS 'retourne les ressources d''un theme';


--
-- TOC entry 1349 (class 1255 OID 2596195)
-- Dependencies: 2983 5
-- Name: af_get_theme_scenarios_dynamiques_colonnes_libelles(integer, character varying, integer, character varying, integer, integer); Type: FUNCTION; Schema: contraintes; Owner: pgsql
--

CREATE FUNCTION af_get_theme_scenarios_dynamiques_colonnes_libelles(integer, character varying, integer, character varying, integer, integer) RETURNS SETOF record
    AS $_$DECLARE
-- $1 : theme
--$2 message
-- $3 : numero du champ pour l'order by
-- $4 : classement (asc ou desc)
-- $5 : limit
-- $6 : offset
rec record;
req varchar;
func varchar;
msg varchar;
begin
	IF $2 IS NULL THEN
		func:='contraintes.af_get_theme_fichiers_scenarios_dynamiques('||$1||',NULL) ';
	ELSE
		func:='contraintes.af_get_theme_fichiers_scenarios_dynamiques('||$1||','''||$2||''') ';
	END IF;

	req:='SELECT id, libelle,date_creation
	FROM '||func||'
	AS (id int4, libelle varchar, type int4, connecte bool, style integer,date_creation date)
	ORDER BY '||( CAST($3 AS integer)+1)||' '||$4
	||' LIMIT '||$5
	||' OFFSET '|| $6||';';

	RAISE NOTICE 'req=%',req;
    FOR rec IN
	EXECUTE req
    LOOP
	RETURN NEXT rec;
    END LOOP;

END;$_$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_get_theme_scenarios_dynamiques_colonnes_libelles(integer, character varying, integer, character varying, integer, integer) OWNER TO pgsql;

--
-- TOC entry 1350 (class 1255 OID 2596196)
-- Dependencies: 2983 5
-- Name: af_get_theme_series(integer); Type: FUNCTION; Schema: contraintes; Owner: pgsql
--

CREATE FUNCTION af_get_theme_series(integer) RETURNS SETOF record
    AS $_$declare
rec record;
type_serie contraintes.type_element;
begin
    for rec in
	select S.id,E.libelle, CAST(NULL AS int4) as type_evaluations, CAST(NULL AS varchar) as libelle_type_evaluations  from 
	contraintes.serie S  LEFT OUTER JOIN contraintes.serie_aleatoire SA ON (S.id=SA.id) and type!=1 LEFT OUTER JOIN  contraintes.categorie_serie CS ON (CS.theme=$1 AND S.id=CS.id)
	LEFT OUTER JOIN contraintes.etape E ON (E.id=CS.id)
	WHERE SA.id IS NULL
	AND CS.id IS NOT NULL
	ORDER BY e.libelle
    loop
	SELECT INTO type_serie * FROM contraintes.af_get_serie_simple_type(rec.id);
	rec.type_evaluations:=type_serie.id;
	rec.libelle_type_evaluations:=type_serie.libelle;
	return next rec;
    end loop;
    return;
end;$_$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_get_theme_series(integer) OWNER TO pgsql;

--
-- TOC entry 8224 (class 0 OID 0)
-- Dependencies: 1350
-- Name: FUNCTION af_get_theme_series(integer); Type: COMMENT; Schema: contraintes; Owner: pgsql
--

COMMENT ON FUNCTION af_get_theme_series(integer) IS 'retourne les serie associées à un theme';


--
-- TOC entry 1351 (class 1255 OID 2596197)
-- Dependencies: 2983 5
-- Name: af_get_theme_series_aleatoire_melangees(integer); Type: FUNCTION; Schema: contraintes; Owner: pgsql
--

CREATE FUNCTION af_get_theme_series_aleatoire_melangees(integer) RETURNS SETOF record
    AS $_$-- $1 : theme
declare
rec record;
begin
    for rec in
	select id ,libelle , type , libelle_type,formation,parcours  from 
	contraintes.af_get_theme_series($1) as (id int4,libelle varchar, type int4, libelle_type varchar),
	contraintes.serie_aleatoire_melangee 
	where id=serie
    loop
	return next rec;
   end loop; 
end;$_$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_get_theme_series_aleatoire_melangees(integer) OWNER TO pgsql;

--
-- TOC entry 8226 (class 0 OID 0)
-- Dependencies: 1351
-- Name: FUNCTION af_get_theme_series_aleatoire_melangees(integer); Type: COMMENT; Schema: contraintes; Owner: pgsql
--

COMMENT ON FUNCTION af_get_theme_series_aleatoire_melangees(integer) IS 'retourne les series existantes configurees en mode aleatoire pour un theme donne';


--
-- TOC entry 1879 (class 1255 OID 2596198)
-- Dependencies: 2983 5
-- Name: af_get_theme_series_aleatoires(integer, integer); Type: FUNCTION; Schema: contraintes; Owner: pgsql
--

CREATE FUNCTION af_get_theme_series_aleatoires(integer, integer) RETURNS SETOF record
    AS $_$declare
rec record;
sous_type contraintes.type_element;
begin
    for rec in
	select e.id,e.libelle, CAST(e.type AS varchar), T.libelle AS libelle_type_original from 
	contraintes.etape e,
	contraintes.categorie_serie cs,
	contraintes.liste l,
	contraintes.serie_aleatoire sa,
	contraintes.etape_type T
	where 
	e.id=cs.id and 
	cs.categorie=19 and
	cs.theme=$1 and
	l.type=1 and l.id=e.id
	and e.id=sa.id and
	sa.type=$2
	AND e.type=T.id
    loop
	SELECT INTO sous_type * FROM contraintes.af_get_etape_type_sous_type(rec.id, CAST(rec.type AS int4), rec.libelle_type_original);
	rec.type:=sous_type.id;
	rec.libelle_type_original:=sous_type.libelle;
	return next rec;
    end loop;
    return;
end;$_$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_get_theme_series_aleatoires(integer, integer) OWNER TO pgsql;

--
-- TOC entry 8228 (class 0 OID 0)
-- Dependencies: 1879
-- Name: FUNCTION af_get_theme_series_aleatoires(integer, integer); Type: COMMENT; Schema: contraintes; Owner: pgsql
--

COMMENT ON FUNCTION af_get_theme_series_aleatoires(integer, integer) IS 'retourne les series aleatoires pour un type et un theme';


--
-- TOC entry 1352 (class 1255 OID 2596199)
-- Dependencies: 2983 5
-- Name: af_get_theme_series_non_vide(integer, integer); Type: FUNCTION; Schema: contraintes; Owner: pgsql
--

CREATE FUNCTION af_get_theme_series_non_vide(integer, integer) RETURNS SETOF record
    AS $_$declare
rec record;
begin
    for rec in 
	select distinct gt_id,gt_libelle,gt_type_evaluations ,gt_libelle_type_evaluations  from contraintes.af_get_theme_series($1) as (gt_id int4,gt_libelle varchar, gt_type_evaluations int4, gt_libelle_type_evaluations varchar),
	contraintes.serie_evaluations e 
	where gt_id=e.serie
    loop
	return next rec;
    end loop;
    return;
end;$_$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_get_theme_series_non_vide(integer, integer) OWNER TO pgsql;

--
-- TOC entry 8230 (class 0 OID 0)
-- Dependencies: 1352
-- Name: FUNCTION af_get_theme_series_non_vide(integer, integer); Type: COMMENT; Schema: contraintes; Owner: pgsql
--

COMMENT ON FUNCTION af_get_theme_series_non_vide(integer, integer) IS 'retourne les series (avec evaluations) pour un theme';


--
-- TOC entry 1353 (class 1255 OID 2596200)
-- Dependencies: 2983 5
-- Name: af_get_theme_sous_criteres(integer); Type: FUNCTION; Schema: contraintes; Owner: pgsql
--

CREATE FUNCTION af_get_theme_sous_criteres(integer) RETURNS SETOF record
    AS $_$-- $1 : numero theme
declare
rec record;
begin
    for rec in 
	select C_id,C_libelle,C_pere from contraintes.af_get_criteres()  as (C_id int4,C_libelle varchar,C_pere int4),
	contraintes.af_get_categorie_elements_theme(12,$1) ET 
	where C_id=ET and C_pere is not null
    loop
	return next rec;
    end loop;
    return;
end;$_$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_get_theme_sous_criteres(integer) OWNER TO pgsql;

--
-- TOC entry 8232 (class 0 OID 0)
-- Dependencies: 1353
-- Name: FUNCTION af_get_theme_sous_criteres(integer); Type: COMMENT; Schema: contraintes; Owner: pgsql
--

COMMENT ON FUNCTION af_get_theme_sous_criteres(integer) IS 'retourne les sous criteres pour un theme';


--
-- TOC entry 1354 (class 1255 OID 2596201)
-- Dependencies: 2983 5
-- Name: af_get_themes(integer); Type: FUNCTION; Schema: contraintes; Owner: postgres
--

CREATE FUNCTION af_get_themes(integer) RETURNS SETOF record
    AS $_$DECLARE
rec RECORD;
BEGIN
    if contraintes.fw_is_root($1) then
	FOR rec IN
	--pour la conversion du int4 en varchar, on utilise un masque de 9999999999 car les valeurs d'un int4
	--vont de -2147483648 Ã  +2147483647, il faut ensuite supprimer les blancs du dÃ©but de la chaine du aux '9' inutiles par rapport aux
	--nombres de chiffres rÃ©els du nombre 

		SELECT id, libelle, trim(leading ' ' from (CAST(to_char(id, '9999999999') AS varchar))),individu FROM contraintes.theme ORDER BY libelle
	LOOP
		RETURN NEXT rec;
	END LOOP;
    else
	FOR rec IN
	--pour la conversion du int4 en varchar, on utilise un masque de 9999999999 car les valeurs d'un int4
	--vont de -2147483648 Ã  +2147483647, il faut ensuite supprimer les blancs du dÃ©but de la chaine du aux '9' inutiles par rapport aux
	--nombres de chiffres rÃ©els du nombre 

		SELECT id, libelle, trim(leading ' ' from (CAST(to_char(id, '9999999999') AS varchar))),individu 
		FROM contraintes.theme where (individu=$1 OR individu IS NULL) ORDER BY libelle
	LOOP
		RETURN NEXT rec;
	END LOOP;
    end if;

	RETURN;
END;$_$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_get_themes(integer) OWNER TO postgres;

--
-- TOC entry 8234 (class 0 OID 0)
-- Dependencies: 1354
-- Name: FUNCTION af_get_themes(integer); Type: COMMENT; Schema: contraintes; Owner: postgres
--

COMMENT ON FUNCTION af_get_themes(integer) IS 'Obtenir tous les themes de la plate-forme';


--
-- TOC entry 1355 (class 1255 OID 2596202)
-- Dependencies: 2983 5
-- Name: af_get_themes_ressource(); Type: FUNCTION; Schema: contraintes; Owner: pgsql
--

CREATE FUNCTION af_get_themes_ressource() RETURNS SETOF record
    AS $$declare
rec record;
begin
    for rec in

    loop
	return next rec;
    end loop;
end;$$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_get_themes_ressource() OWNER TO pgsql;

--
-- TOC entry 8236 (class 0 OID 0)
-- Dependencies: 1355
-- Name: FUNCTION af_get_themes_ressource(); Type: COMMENT; Schema: contraintes; Owner: pgsql
--

COMMENT ON FUNCTION af_get_themes_ressource() IS 'retourne les themes des ressources';


--
-- TOC entry 1356 (class 1255 OID 2596203)
-- Dependencies: 2983 5
-- Name: af_get_themes_ressource_fichier_texte(integer); Type: FUNCTION; Schema: contraintes; Owner: pgsql
--

CREATE FUNCTION af_get_themes_ressource_fichier_texte(integer) RETURNS SETOF record
    AS $_$-- $1 : individu
declare
rec record;
begin
    for rec in
	select * from contraintes.af_get_categorie_themes(7,$1) as (id int4,libelle varchar)
	union
	select * from contraintes.af_get_categorie_themes(26,$1) as (id int4,libelle varchar)
	union
	select * from contraintes.af_get_categorie_themes(1,$1) as (id int4,libelle varchar)
	union
	select * from contraintes.af_get_categorie_themes(59,$1) as (id integer,libelle varchar)
    loop
	return next rec;
    end loop;
end;$_$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_get_themes_ressource_fichier_texte(integer) OWNER TO pgsql;

--
-- TOC entry 8238 (class 0 OID 0)
-- Dependencies: 1356
-- Name: FUNCTION af_get_themes_ressource_fichier_texte(integer); Type: COMMENT; Schema: contraintes; Owner: pgsql
--

COMMENT ON FUNCTION af_get_themes_ressource_fichier_texte(integer) IS 'retourne les themes des fichiers ressource (fichier et texte et scenario et scenario dynamique) pour un individu';


--
-- TOC entry 1357 (class 1255 OID 2596204)
-- Dependencies: 2983 5
-- Name: af_is_capacite_titre_capacite_supprimable(integer, integer); Type: FUNCTION; Schema: contraintes; Owner: pgsql
--

CREATE FUNCTION af_is_capacite_titre_capacite_supprimable(integer, integer) RETURNS boolean
    AS $_$-- $1 : numero capacite_titre
-- $2 : numero capacite
begin
    perform * from contraintes.grille_resultats where capacite_titre=$1 and capacite=$2;
    return not found;
end;$_$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_is_capacite_titre_capacite_supprimable(integer, integer) OWNER TO pgsql;

--
-- TOC entry 8240 (class 0 OID 0)
-- Dependencies: 1357
-- Name: FUNCTION af_is_capacite_titre_capacite_supprimable(integer, integer); Type: COMMENT; Schema: contraintes; Owner: pgsql
--

COMMENT ON FUNCTION af_is_capacite_titre_capacite_supprimable(integer, integer) IS 'retourne vrai si le couple capacite_titre / capacite peut etre supprimer';


--
-- TOC entry 1880 (class 1255 OID 2962811)
-- Dependencies: 2983 5
-- Name: af_is_fichier_scenario_dynamique_supprimable(integer); Type: FUNCTION; Schema: contraintes; Owner: www
--

CREATE FUNCTION af_is_fichier_scenario_dynamique_supprimable(integer) RETURNS boolean
    AS $_$DECLARE
scenario integer;
used1 boolean:=FALSE;
used2 boolean:=FALSE;
BEGIN
	SELECT INTO scenario * FROM contraintes.af_get_scenario_dynamique_fichier($1);

	IF scenario IS NOT NULL THEN
		SELECT INTO used1 *  FROM contraintes.af_fk_finder('etape', 'id', scenario);
		RAISE NOTICE '-----scenario utilise---%--', used1;
	END IF;
		

	SELECT INTO used2 *  FROM contraintes.af_fk_finder('fichier_ressource', 'id', $1);
	RAISE NOTICE '----- fichier scenario utilise----%--', used2;
	RETURN NOT (used1 OR used2);
END;$_$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_is_fichier_scenario_dynamique_supprimable(integer) OWNER TO www;

--
-- TOC entry 1358 (class 1255 OID 2596205)
-- Dependencies: 2983 5
-- Name: af_is_fichier_scenario_dynamique_used(integer); Type: FUNCTION; Schema: contraintes; Owner: pgsql
--

CREATE FUNCTION af_is_fichier_scenario_dynamique_used(integer) RETURNS boolean
    AS $_$DECLARE
--$1 scenario bloc
rec RECORD;
search_string varchar;
BEGIN

	--recherche la chaine \"id_fichier\"
	search_string:='.*\\"'||$1||'\\".*';
	FOR rec IN
		SELECT bloc_vars_values FROM contraintes.fichier_scenario_dynamique_blocs
	LOOP	
		--FOR i IN array_lower(rec.bloc_vars_values,1)..array_upper(rec.bloc_vars_values,1)
		--LOOP
			
			--RAISE NOTICE 'cherche % dans %',search_string,rec.bloc_vars_values[i];
			IF(rec.bloc_vars_values ~* search_string) THEN
				--RAISE NOTICE 'trouve';
				RETURN TRUE;
			END IF;
		--END LOOP;
	END LOOP;
	RETURN FALSE;
END;$_$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_is_fichier_scenario_dynamique_used(integer) OWNER TO pgsql;

--
-- TOC entry 1359 (class 1255 OID 2596206)
-- Dependencies: 2983 5
-- Name: af_is_filiere_libelle_ok(integer, character varying); Type: FUNCTION; Schema: contraintes; Owner: pgsql
--

CREATE FUNCTION af_is_filiere_libelle_ok(integer, character varying) RETURNS boolean
    AS $_$DECLARE
--$1 filiere 
--$2 libelle
ok bool;
BEGIN
	IF $2 LIKE '%/%' THEN 
		--RAISE NOTICE 'Caractère ''/'' interdit dans le libellé d''une filière ';
		RETURN FALSE; 
	END IF;
	RAISE NOTICE 'ici';
	IF $1 IS NOT NULL THEN
		PERFORM * FROM contraintes.filiere
		WHERE pere=$1 
		AND libelle LIKE $2;
	ELSE
		PERFORM * FROM contraintes.filiere
		WHERE pere IS NULL
		AND libelle LIKE $2;
	END IF;
	RETURN NOT FOUND;
END;$_$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_is_filiere_libelle_ok(integer, character varying) OWNER TO pgsql;

--
-- TOC entry 1360 (class 1255 OID 2596207)
-- Dependencies: 2983 5
-- Name: af_is_formation_evenement_supprimable(integer, timestamp without time zone); Type: FUNCTION; Schema: contraintes; Owner: pgsql
--

CREATE FUNCTION af_is_formation_evenement_supprimable(integer, timestamp without time zone) RETURNS boolean
    AS $_$-- $1 : formation
-- $2 : timestamp
begin
    perform * from contraintes.grille_resultats
    where formation=$1 and date=$2;
    return not found;
end;$_$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_is_formation_evenement_supprimable(integer, timestamp without time zone) OWNER TO pgsql;

--
-- TOC entry 8245 (class 0 OID 0)
-- Dependencies: 1360
-- Name: FUNCTION af_is_formation_evenement_supprimable(integer, timestamp without time zone); Type: COMMENT; Schema: contraintes; Owner: pgsql
--

COMMENT ON FUNCTION af_is_formation_evenement_supprimable(integer, timestamp without time zone) IS 'teste si un evenement de formation est supprimable';


--
-- TOC entry 1361 (class 1255 OID 2596208)
-- Dependencies: 2983 5
-- Name: af_is_formation_evenements_hors_periode(integer, date, date); Type: FUNCTION; Schema: contraintes; Owner: pgsql
--

CREATE FUNCTION af_is_formation_evenements_hors_periode(integer, date, date) RETURNS boolean
    AS $_$-- $1 : formation
-- $2 : date debut
-- $3 : date fin
begin
    perform * from contraintes.evenement 
    where formation=$1
    and (cast(date as date)<$2 or cast(date as date)>$3);
    return found;
end;$_$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_is_formation_evenements_hors_periode(integer, date, date) OWNER TO pgsql;

--
-- TOC entry 8247 (class 0 OID 0)
-- Dependencies: 1361
-- Name: FUNCTION af_is_formation_evenements_hors_periode(integer, date, date); Type: COMMENT; Schema: contraintes; Owner: pgsql
--

COMMENT ON FUNCTION af_is_formation_evenements_hors_periode(integer, date, date) IS 'retourne vrai si un evenement est hors date de formation';


--
-- TOC entry 1362 (class 1255 OID 2596209)
-- Dependencies: 2983 5
-- Name: af_is_formation_evenements_supprimable(integer, date); Type: FUNCTION; Schema: contraintes; Owner: pgsql
--

CREATE FUNCTION af_is_formation_evenements_supprimable(integer, date) RETURNS boolean
    AS $_$-- $1 : formation
-- $2 : date
begin
    perform * from contraintes.grille_resultats 
    where formation=$1 and cast(date as date)=$2;
    return not found;
end;$_$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_is_formation_evenements_supprimable(integer, date) OWNER TO pgsql;

--
-- TOC entry 8249 (class 0 OID 0)
-- Dependencies: 1362
-- Name: FUNCTION af_is_formation_evenements_supprimable(integer, date); Type: COMMENT; Schema: contraintes; Owner: pgsql
--

COMMENT ON FUNCTION af_is_formation_evenements_supprimable(integer, date) IS 'teste si une journée de formation est supprimable';


--
-- TOC entry 1363 (class 1255 OID 2596210)
-- Dependencies: 2983 5
-- Name: af_is_grille_capacite_titre_supprimable(integer, integer); Type: FUNCTION; Schema: contraintes; Owner: pgsql
--

CREATE FUNCTION af_is_grille_capacite_titre_supprimable(integer, integer) RETURNS boolean
    AS $_$-- $1 : numero grille
-- $2 : numero capacite_titre
begin
    perform * from contraintes.grille_resultats where grille=$1 and capacite_titre=$2;
    return not found;
end;$_$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_is_grille_capacite_titre_supprimable(integer, integer) OWNER TO pgsql;

--
-- TOC entry 8251 (class 0 OID 0)
-- Dependencies: 1363
-- Name: FUNCTION af_is_grille_capacite_titre_supprimable(integer, integer); Type: COMMENT; Schema: contraintes; Owner: pgsql
--

COMMENT ON FUNCTION af_is_grille_capacite_titre_supprimable(integer, integer) IS 'retourne vrai si le couple grille / capacite_titre est supprimable';


--
-- TOC entry 1364 (class 1255 OID 2596211)
-- Dependencies: 2983 5
-- Name: af_is_individu_droit_classe(integer, integer, integer); Type: FUNCTION; Schema: contraintes; Owner: pgsql
--

CREATE FUNCTION af_is_individu_droit_classe(integer, integer, integer) RETURNS boolean
    AS $_$-- $1 : numero individu
-- $2 : numero classe
-- $3 : numero droit
begin
    perform * from contraintes.individu_droits where individu=$1 and classe=$2 and droit=$3;
    return found;
end;$_$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_is_individu_droit_classe(integer, integer, integer) OWNER TO pgsql;

--
-- TOC entry 8253 (class 0 OID 0)
-- Dependencies: 1364
-- Name: FUNCTION af_is_individu_droit_classe(integer, integer, integer); Type: COMMENT; Schema: contraintes; Owner: pgsql
--

COMMENT ON FUNCTION af_is_individu_droit_classe(integer, integer, integer) IS 'retourne vrai si un individu possede le droit pour la classe,faux sinon';


--
-- TOC entry 1365 (class 1255 OID 2596212)
-- Dependencies: 2983 5
-- Name: af_is_individu_supprimable(integer); Type: FUNCTION; Schema: contraintes; Owner: pgsql
--

CREATE FUNCTION af_is_individu_supprimable(integer) RETURNS boolean
    AS $_$-- $1 : individu
declare
nb_rec int4;
begin
    -- si admin ou formateur temporaire,alors pas de suppression
    perform * from contraintes.fw_individu where id=$1 and login='temporaire' and password='temporaire';
    if found then
	return false;
    end if;
    perform * from contraintes.fw_individu where id=$1 and login='admin' and password='admin';
    if found then
	return false;
    end if;
    -- si intervenant ou formateur,alors pas de suppression
    perform * from contraintes.evenement where intervenant=$1;
    if found then
	return false;
    end if;
    perform * from contraintes.formation_participants where formateur=$1;
    if found then
	return false;
    end if;
    -- si affilié à une classe,alors pas de suppression
    perform * from contraintes.af_get_individu_classes($1) as (id int4,libelle varchar,pere int4,min int4,max int4);
    GET DIAGNOSTICS nb_rec = ROW_COUNT;
    if nb_rec>0 then
	return false;
    end if;
    return true;
end;$_$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_is_individu_supprimable(integer) OWNER TO pgsql;

--
-- TOC entry 8255 (class 0 OID 0)
-- Dependencies: 1365
-- Name: FUNCTION af_is_individu_supprimable(integer); Type: COMMENT; Schema: contraintes; Owner: pgsql
--

COMMENT ON FUNCTION af_is_individu_supprimable(integer) IS 'retourne vrai si un individu est supprimable';


--
-- TOC entry 1366 (class 1255 OID 2596213)
-- Dependencies: 2983 5
-- Name: af_is_locked_by_constraint(character varying, character varying, character varying); Type: FUNCTION; Schema: contraintes; Owner: pgsql
--

CREATE FUNCTION af_is_locked_by_constraint(character varying, character varying, character varying) RETURNS void
    AS $$BEGIN
SELECT

	--NULL::text AS PKTABLE_CAT,
	pknam.nspname AS PKTABLE_SCHEM,
	pkc.relname AS PKTABLE_NAME,
	pka.attname AS PKCOLUMN_NAME,
	--NULL::text AS FKTABLE_CAT,
	fknam.nspname AS FKTABLE_SCHEM,
	fkc.relname AS FKTABLE_NAME,
	fka.attname AS FKCOLUMN_NAME
	--fkcon.conkey[1] AS KEY_SEQ,
	--CASE
	---	WHEN fkcon.confupdtype = 'c' THEN 0
	--	WHEN fkcon.confupdtype = 'r' THEN 1
	--	WHEN fkcon.confupdtype = 'n' THEN 2
	--	WHEN fkcon.confupdtype = 'a' THEN 3
	--	WHEN fkcon.confupdtype = 'd' THEN 4
	--END AS UPDATE_RULE
	--CASE
	--	WHEN fkcon.confdeltype = 'c' THEN 0
	--	WHEN fkcon.confdeltype = 'r' THEN 1
	--	WHEN fkcon.confdeltype = 'n' THEN 2
	--	WHEN fkcon.confdeltype = 'a' THEN 3
	--	WHEN fkcon.confdeltype = 'd' THEN 4
	--END AS DELETE_RULE,
	--fkcon.conname AS FK_NAME,
	--pkcon.conname AS PK_NAME,
	--CASE
	--	WHEN fkcon.condeferrable = 'f' THEN 7
	--	WHEN fkcon.condeferred = 't' THEN 6
	--	WHEN fkcon.condeferred = 'f' THEN 5
	--END AS DEFERRABILITY,
	--CASE
	--	WHEN pkcon.contype = 'p' THEN 'PRIMARY'
	--	WHEN pkcon.contype = 'u' THEN 'UNIQUE'
	--END AS UNIQUE_OR_PRIMARY
	FROM
		pg_constraint AS fkcon
	JOIN
		pg_constraint AS pkcon ON fkcon.confrelid=pkcon.conrelid
			AND fkcon.confkey=pkcon.conkey
	JOIN
		pg_class fkc ON fkc.oid=fkcon.conrelid
	JOIN
		pg_class pkc ON pkc.oid=fkcon.confrelid
	JOIN
		pg_namespace pknam ON pkcon.connamespace=pknam.oid
	JOIN
		pg_namespace fknam ON fkcon.connamespace=fknam.oid
	JOIN
		pg_attribute fka ON fka.attnum=fkcon.conkey[1] AND fka.attrelid=fkc.oid
	JOIN
		pg_attribute pka ON pka.attnum=pkcon.conkey[1] AND pka.attrelid=pkc.oid

	WHERE pkc.relname='fichier';
END$$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_is_locked_by_constraint(character varying, character varying, character varying) OWNER TO pgsql;

--
-- TOC entry 1881 (class 1255 OID 2596214)
-- Dependencies: 2983 5
-- Name: af_is_login_inscription_ok(character varying); Type: FUNCTION; Schema: contraintes; Owner: pgsql
--

CREATE FUNCTION af_is_login_inscription_ok(character varying) RETURNS boolean
    AS $_$begin
    perform login from contraintes.inscription where login LIKE $1;
    return NOT found;
end;$_$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_is_login_inscription_ok(character varying) OWNER TO pgsql;

--
-- TOC entry 8258 (class 0 OID 0)
-- Dependencies: 1881
-- Name: FUNCTION af_is_login_inscription_ok(character varying); Type: COMMENT; Schema: contraintes; Owner: pgsql
--

COMMENT ON FUNCTION af_is_login_inscription_ok(character varying) IS 'teste si un login est deja utilise dans la table inscription';


--
-- TOC entry 1367 (class 1255 OID 2596215)
-- Dependencies: 2983 5
-- Name: af_is_login_ok(character varying); Type: FUNCTION; Schema: contraintes; Owner: pgsql
--

CREATE FUNCTION af_is_login_ok(character varying) RETURNS boolean
    AS $_$begin
    perform login from contraintes.fw_individu where login LIKE $1;
    return NOT found;
end;$_$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_is_login_ok(character varying) OWNER TO pgsql;

--
-- TOC entry 8260 (class 0 OID 0)
-- Dependencies: 1367
-- Name: FUNCTION af_is_login_ok(character varying); Type: COMMENT; Schema: contraintes; Owner: pgsql
--

COMMENT ON FUNCTION af_is_login_ok(character varying) IS 'teste si un login est deja utilise';


--
-- TOC entry 1882 (class 1255 OID 2596216)
-- Dependencies: 2983 5
-- Name: af_is_parcours_etape_modifiable(integer, integer, character varying); Type: FUNCTION; Schema: contraintes; Owner: pgsql
--

CREATE FUNCTION af_is_parcours_etape_modifiable(integer, integer, character varying) RETURNS boolean
    AS $_$DECLARE
--$1 parcours
--$2 etape
--$3 type de l'étape
--rec_etape RECORD;
tmp bool;
rec record;
rec2 record;
nb integer;
BEGIN
	--selection de l'étape
	--SELECT INTO rec_etape * FROM contraintes.etape WHERE etape=$2;	IF 

	--etape de type test de positionnement dynamique
    /*
	IF $3='4_3' THEN
		SELECT INTO tmp dynamique FROM contraintes.af_get_test($2) AS (id int4, libelle varchar, dynamique bool, continu bool, media int4, hauteur_media int4, largeur_media int4,date_creation timestamp);
	END IF;
	
	IF tmp IS TRUE THEN
		RETURN FALSE; 
	ELSE
		RETURN TRUE;
	END IF;
    */
    -- test si l'étape du parcours est enregistrée
    select into rec * from contraintes.af_get_parcours_etape_resultats($1,$2)
    as (id bigint, formation int4, stagiaire int4, parcours int4,  etape int4, date_debut timestamp, duree interval);
    
    if rec.id is not null then
	return false;
    else
    
    
	-- si etape notée et parcours configuré en orientation alors pas de modif
	nb:=0;
	for rec2 in 
	    select * from contraintes.parcours_etapes
	    where parcours=$1 and etape in 
	    (select id from contraintes.etape where type=10)
	loop
	    nb:=nb+1;
	    raise notice 'nb=%',nb;
	end loop;
	raise notice 'nb=%',nb;
	if nb>0 and ($3 like 4 || '%' or $3 like 5 || '%')then
	    return false;
	else
	    return true;
	
	end if;
    end if;
    
END; $_$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_is_parcours_etape_modifiable(integer, integer, character varying) OWNER TO pgsql;

--
-- TOC entry 1883 (class 1255 OID 2596217)
-- Dependencies: 2983 5
-- Name: af_is_parcours_oriente(integer); Type: FUNCTION; Schema: contraintes; Owner: pgsql
--

CREATE FUNCTION af_is_parcours_oriente(integer) RETURNS boolean
    AS $_$-- $1 : parcours
declare
rec record;
nb integer;
begin
    nb:=0;
    for rec in 
	select * from contraintes.af_get_parcours_oriente_configuration($1)
	as ( etape int4,  sous_parcours int4, type_evaluation int4, seuil int4)
    loop
	nb:=nb+1;
	raise notice 'nb=%',nb;
    end loop;
    if nb=0 then
	return false;
    else
	return true;
    end if;
    
end;$_$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_is_parcours_oriente(integer) OWNER TO pgsql;

--
-- TOC entry 8263 (class 0 OID 0)
-- Dependencies: 1883
-- Name: FUNCTION af_is_parcours_oriente(integer); Type: COMMENT; Schema: contraintes; Owner: pgsql
--

COMMENT ON FUNCTION af_is_parcours_oriente(integer) IS 'retourne vrai si le parcours est configuré en orientation,faux sinon';


--
-- TOC entry 1884 (class 1255 OID 2596218)
-- Dependencies: 2983 5
-- Name: af_is_resultat_exotlc_critere(integer, integer); Type: FUNCTION; Schema: contraintes; Owner: pgsql
--

CREATE FUNCTION af_is_resultat_exotlc_critere(integer, integer) RETURNS boolean
    AS $_$-- $1 : id resultat
-- $2 : critere
begin
    perform * from contraintes.resultat_exotlc_critere where id=$1 and critere=$2;
    return found;
end;$_$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_is_resultat_exotlc_critere(integer, integer) OWNER TO pgsql;

--
-- TOC entry 8265 (class 0 OID 0)
-- Dependencies: 1884
-- Name: FUNCTION af_is_resultat_exotlc_critere(integer, integer); Type: COMMENT; Schema: contraintes; Owner: pgsql
--

COMMENT ON FUNCTION af_is_resultat_exotlc_critere(integer, integer) IS 'Verifie si un critere existe pour un identifiant de resultat';


--
-- TOC entry 1885 (class 1255 OID 2596219)
-- Dependencies: 2983 5
-- Name: af_is_resultat_exotlc_sous_critere(integer, integer); Type: FUNCTION; Schema: contraintes; Owner: pgsql
--

CREATE FUNCTION af_is_resultat_exotlc_sous_critere(integer, integer) RETURNS boolean
    AS $_$-- $1 : id resultat
-- $2 : sous critere
begin
    perform * from contraintes.resultat_exotlc_sous_critere where id=$1 and sous_critere=$2;
    return found;
end;$_$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_is_resultat_exotlc_sous_critere(integer, integer) OWNER TO pgsql;

--
-- TOC entry 8267 (class 0 OID 0)
-- Dependencies: 1885
-- Name: FUNCTION af_is_resultat_exotlc_sous_critere(integer, integer); Type: COMMENT; Schema: contraintes; Owner: pgsql
--

COMMENT ON FUNCTION af_is_resultat_exotlc_sous_critere(integer, integer) IS 'Verifie si un sous critere existe pour un identifiant de resultat';


--
-- TOC entry 1368 (class 1255 OID 2596220)
-- Dependencies: 2983 5
-- Name: af_is_resultat_formation_parcours_etape(integer, integer, integer); Type: FUNCTION; Schema: contraintes; Owner: pgsql
--

CREATE FUNCTION af_is_resultat_formation_parcours_etape(integer, integer, integer) RETURNS boolean
    AS $_$-- $1 : formation
-- $2 : parcours
-- $3 : etape
declare


begin
    perform * from contraintes.resultat where formation=$1 and parcours=$2 and etape=$3;
    return found;
end;$_$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_is_resultat_formation_parcours_etape(integer, integer, integer) OWNER TO pgsql;

--
-- TOC entry 8269 (class 0 OID 0)
-- Dependencies: 1368
-- Name: FUNCTION af_is_resultat_formation_parcours_etape(integer, integer, integer); Type: COMMENT; Schema: contraintes; Owner: pgsql
--

COMMENT ON FUNCTION af_is_resultat_formation_parcours_etape(integer, integer, integer) IS 'test si resultat pour une etape,un parcours et une formation';


--
-- TOC entry 1369 (class 1255 OID 2596221)
-- Dependencies: 2983 5
-- Name: af_is_serie_aleatoire(integer); Type: FUNCTION; Schema: contraintes; Owner: pgsql
--

CREATE FUNCTION af_is_serie_aleatoire(integer) RETURNS boolean
    AS $_$DECLARE
rec RECORD;
BEGIN
	SELECT INTO rec *
	FROM contraintes.etape E, contraintes.serie S LEFT OUTER JOIN contraintes.serie_aleatoire SA
	ON (S.id=SA.id)
	WHERE E.id= S.id
	AND E.id=$1
	AND SA.id IS NOT NULL;

	RETURN FOUND;
END
$_$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_is_serie_aleatoire(integer) OWNER TO pgsql;

--
-- TOC entry 8271 (class 0 OID 0)
-- Dependencies: 1369
-- Name: FUNCTION af_is_serie_aleatoire(integer); Type: COMMENT; Schema: contraintes; Owner: pgsql
--

COMMENT ON FUNCTION af_is_serie_aleatoire(integer) IS 'savoir si une serie est aleatoire.';


--
-- TOC entry 1370 (class 1255 OID 2596222)
-- Dependencies: 2983 5
-- Name: af_is_serie_aleatoire_melangee(integer, integer, integer); Type: FUNCTION; Schema: contraintes; Owner: pgsql
--

CREATE FUNCTION af_is_serie_aleatoire_melangee(integer, integer, integer) RETURNS boolean
    AS $_$-- $1 : serie
-- $2 : formation
-- $3 : parcours
declare
resultat int4:=0;
begin
    select into resultat count(*) from contraintes.serie_aleatoire_melangee where serie=$1 and formation=$2 and parcours=$3;
    if(resultat>0) then
	return true;
    else
	return false;
    end if;
end$_$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_is_serie_aleatoire_melangee(integer, integer, integer) OWNER TO pgsql;

--
-- TOC entry 8273 (class 0 OID 0)
-- Dependencies: 1370
-- Name: FUNCTION af_is_serie_aleatoire_melangee(integer, integer, integer); Type: COMMENT; Schema: contraintes; Owner: pgsql
--

COMMENT ON FUNCTION af_is_serie_aleatoire_melangee(integer, integer, integer) IS 'retourne vrai si une serie existante est configuree en mode aleatoire';


--
-- TOC entry 1371 (class 1255 OID 2596223)
-- Dependencies: 2983 5
-- Name: af_is_serie_bloquante_configuree(integer, integer, integer); Type: FUNCTION; Schema: contraintes; Owner: pgsql
--

CREATE FUNCTION af_is_serie_bloquante_configuree(integer, integer, integer) RETURNS boolean
    AS $_$-- $1 : serie
-- $2 : formation
-- $3 : parcours
declare
resultat int4:=0;
begin
    select into resultat count(*) from contraintes.serie_bloquante where serie=$1 and formation=$2 and parcours=$3;
    if(resultat>0) then
	return true;
    else
	return false;
    end if;
end;$_$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_is_serie_bloquante_configuree(integer, integer, integer) OWNER TO pgsql;

--
-- TOC entry 8275 (class 0 OID 0)
-- Dependencies: 1371
-- Name: FUNCTION af_is_serie_bloquante_configuree(integer, integer, integer); Type: COMMENT; Schema: contraintes; Owner: pgsql
--

COMMENT ON FUNCTION af_is_serie_bloquante_configuree(integer, integer, integer) IS 'retourne vrai si une serie est configurée en mode bloquant';


--
-- TOC entry 1372 (class 1255 OID 2596224)
-- Dependencies: 2983 5
-- Name: af_maj_alerte(integer, character varying, integer, character varying); Type: FUNCTION; Schema: contraintes; Owner: pgsql
--

CREATE FUNCTION af_maj_alerte(integer, character varying, integer, character varying) RETURNS boolean
    AS $_$-- $1 : numero alerte
-- $2 : libelle
-- $3 : nb jours
-- $4 : texte
declare
ams_libelle varchar;
ams_texte varchar;
begin
    SELECT INTO ams_libelle contraintes.fw_get_ams_libelle('alerte','libelle','id='||$1,$2);
    SELECT INTO ams_texte contraintes.fw_get_ams_libelle('alerte','texte','id='||$1,$4);
    update contraintes.alerte set libelle=ams_libelle,jours=$3,texte=ams_texte where id=$1;
    return found;
end;$_$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_maj_alerte(integer, character varying, integer, character varying) OWNER TO pgsql;

--
-- TOC entry 8277 (class 0 OID 0)
-- Dependencies: 1372
-- Name: FUNCTION af_maj_alerte(integer, character varying, integer, character varying); Type: COMMENT; Schema: contraintes; Owner: pgsql
--

COMMENT ON FUNCTION af_maj_alerte(integer, character varying, integer, character varying) IS 'met à jour une alerte';


--
-- TOC entry 1373 (class 1255 OID 2596225)
-- Dependencies: 2983 5
-- Name: af_maj_bareme(integer, character varying, integer, integer, integer, integer); Type: FUNCTION; Schema: contraintes; Owner: pgsql
--

CREATE FUNCTION af_maj_bareme(integer, character varying, integer, integer, integer, integer) RETURNS boolean
    AS $_$-- $1 : numero bareme
-- $2 : libelle
-- $3 : juste
-- $4 : fausse
-- $5 : pas coché
-- $6 : tout coché
begin
    update contraintes.bareme set libelle=$2,juste=$3,fausse=$4,manquantes=$5,toutes=$6 
    where id=$1;
    return found;
end;$_$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_maj_bareme(integer, character varying, integer, integer, integer, integer) OWNER TO pgsql;

--
-- TOC entry 8279 (class 0 OID 0)
-- Dependencies: 1373
-- Name: FUNCTION af_maj_bareme(integer, character varying, integer, integer, integer, integer); Type: COMMENT; Schema: contraintes; Owner: pgsql
--

COMMENT ON FUNCTION af_maj_bareme(integer, character varying, integer, integer, integer, integer) IS 'modifie un bareme';


--
-- TOC entry 1374 (class 1255 OID 2596226)
-- Dependencies: 2983 5
-- Name: af_maj_capacite(integer, character varying); Type: FUNCTION; Schema: contraintes; Owner: pgsql
--

CREATE FUNCTION af_maj_capacite(integer, character varying) RETURNS boolean
    AS $_$-- $1 : numero capacite
-- $2 : libelle capacite
declare
ams varchar;
begin
    SELECT INTO ams contraintes.fw_get_ams_libelle('capacite','libelle','id='||$1,$2);

    update contraintes.capacite set libelle =ams where id=$1;
    return found;
end;$_$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_maj_capacite(integer, character varying) OWNER TO pgsql;

--
-- TOC entry 8281 (class 0 OID 0)
-- Dependencies: 1374
-- Name: FUNCTION af_maj_capacite(integer, character varying); Type: COMMENT; Schema: contraintes; Owner: pgsql
--

COMMENT ON FUNCTION af_maj_capacite(integer, character varying) IS 'met à jour une capacite';


--
-- TOC entry 1375 (class 1255 OID 2596227)
-- Dependencies: 2983 5
-- Name: af_maj_capacite_titre(integer, character varying); Type: FUNCTION; Schema: contraintes; Owner: pgsql
--

CREATE FUNCTION af_maj_capacite_titre(integer, character varying) RETURNS boolean
    AS $_$-- $1 : numero capacite_titre
-- $2 : libelle capacite_titre
declare
ams varchar;
begin
    SELECT INTO ams contraintes.fw_get_ams_libelle('capacite_titre','libelle','id='||$1,$2);

    update contraintes.capacite_titre set libelle=ams where id=$1;
    return found;
end;$_$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_maj_capacite_titre(integer, character varying) OWNER TO pgsql;

--
-- TOC entry 8283 (class 0 OID 0)
-- Dependencies: 1375
-- Name: FUNCTION af_maj_capacite_titre(integer, character varying); Type: COMMENT; Schema: contraintes; Owner: pgsql
--

COMMENT ON FUNCTION af_maj_capacite_titre(integer, character varying) IS 'met à jour un titre de capacite';


--
-- TOC entry 1376 (class 1255 OID 2596228)
-- Dependencies: 2983 5
-- Name: af_maj_categorie(integer, character varying, boolean); Type: FUNCTION; Schema: contraintes; Owner: postgres
--

CREATE FUNCTION af_maj_categorie(integer, character varying, boolean) RETURNS boolean
    AS $_$--$1 identifiant de la categorie
--$2 libellÃ© de la catÃ©gorie
--$3 aparait dans le gestionnaire de contenus
declare
ams varchar;
BEGIN
	SELECT INTO ams contraintes.fw_get_ams_libelle('categorie','libelle','id='||$1,$2);
	UPDATE contraintes.categorie SET libelle=ams, gestionnaire_contenu=$3 WHERE id=$1;

	RETURN FOUND;

END$_$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_maj_categorie(integer, character varying, boolean) OWNER TO postgres;

--
-- TOC entry 8285 (class 0 OID 0)
-- Dependencies: 1376
-- Name: FUNCTION af_maj_categorie(integer, character varying, boolean); Type: COMMENT; Schema: contraintes; Owner: postgres
--

COMMENT ON FUNCTION af_maj_categorie(integer, character varying, boolean) IS 'Mise a jour d''une categorie.';


--
-- TOC entry 1377 (class 1255 OID 2596229)
-- Dependencies: 2983 5
-- Name: af_maj_classe(integer, character varying, integer); Type: FUNCTION; Schema: contraintes; Owner: pgsql
--

CREATE FUNCTION af_maj_classe(integer, character varying, integer) RETURNS boolean
    AS $_$-- $1 numero de la classe
-- $2 nouveau nom de la classe
-- $3 numero du pere
declare

begin
    -- test doublon
    if $3 is null then
	perform * from contraintes.classe where lower(libelle) like lower($2) and pere is null;
    else
	perform * from contraintes.classe where lower(libelle) like lower($2) and pere =$3;
    end if;
    if not found then
	update contraintes.classe set libelle=$2 where id=$1;
    end if;
    return found;
end;$_$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_maj_classe(integer, character varying, integer) OWNER TO pgsql;

--
-- TOC entry 8287 (class 0 OID 0)
-- Dependencies: 1377
-- Name: FUNCTION af_maj_classe(integer, character varying, integer); Type: COMMENT; Schema: contraintes; Owner: pgsql
--

COMMENT ON FUNCTION af_maj_classe(integer, character varying, integer) IS 'met à jour le nom d''une classe';


--
-- TOC entry 1378 (class 1255 OID 2596230)
-- Dependencies: 2983 5
-- Name: af_maj_classe_places(integer, integer, integer); Type: FUNCTION; Schema: contraintes; Owner: pgsql
--

CREATE FUNCTION af_maj_classe_places(integer, integer, integer) RETURNS boolean
    AS $_$-- $1 : numero de la classe
-- $2 : min
-- $3 : max
begin
    update contraintes.classe set min=$2,max=$3 where id=$1;
    return found;
end;
$_$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_maj_classe_places(integer, integer, integer) OWNER TO pgsql;

--
-- TOC entry 8289 (class 0 OID 0)
-- Dependencies: 1378
-- Name: FUNCTION af_maj_classe_places(integer, integer, integer); Type: COMMENT; Schema: contraintes; Owner: pgsql
--

COMMENT ON FUNCTION af_maj_classe_places(integer, integer, integer) IS 'met à jour le nombre de place min et max d''une classe';


--
-- TOC entry 1379 (class 1255 OID 2596231)
-- Dependencies: 2983 5
-- Name: af_maj_commentaire(integer, integer, integer, character varying, integer, integer); Type: FUNCTION; Schema: contraintes; Owner: pgsql
--

CREATE FUNCTION af_maj_commentaire(integer, integer, integer, character varying, integer, integer) RETURNS boolean
    AS $_$-- $1 : numero etape
-- $2 : min
-- $3 : max
-- $4 : commentaire
-- $5 : old min
-- $6 : old max
begin
    update contraintes.commentaire_etape 
    set min=$2,max=$3,commentaire=$4 
    where etape=$1 and min=$5 and max=$6;
    return found;
end;$_$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_maj_commentaire(integer, integer, integer, character varying, integer, integer) OWNER TO pgsql;

--
-- TOC entry 8291 (class 0 OID 0)
-- Dependencies: 1379
-- Name: FUNCTION af_maj_commentaire(integer, integer, integer, character varying, integer, integer); Type: COMMENT; Schema: contraintes; Owner: pgsql
--

COMMENT ON FUNCTION af_maj_commentaire(integer, integer, integer, character varying, integer, integer) IS 'mettre à jour un commentaire';


--
-- TOC entry 1380 (class 1255 OID 2596232)
-- Dependencies: 2983 5
-- Name: af_maj_critere(integer, character varying); Type: FUNCTION; Schema: contraintes; Owner: pgsql
--

CREATE FUNCTION af_maj_critere(integer, character varying) RETURNS boolean
    AS $_$-- $1 : numero critere
-- $2 : libelle
declare
ams varchar;
begin
    SELECT INTO ams contraintes.fw_get_ams_libelle('critere','libelle','id='||$1,$2);

    update contraintes.critere set libelle=ams where id=$1;
    return found;
end;$_$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_maj_critere(integer, character varying) OWNER TO pgsql;

--
-- TOC entry 8293 (class 0 OID 0)
-- Dependencies: 1380
-- Name: FUNCTION af_maj_critere(integer, character varying); Type: COMMENT; Schema: contraintes; Owner: pgsql
--

COMMENT ON FUNCTION af_maj_critere(integer, character varying) IS 'met à jour un critere';


--
-- TOC entry 1381 (class 1255 OID 2596233)
-- Dependencies: 2983 5
-- Name: af_maj_droit(integer, character varying, boolean); Type: FUNCTION; Schema: contraintes; Owner: pgsql
--

CREATE FUNCTION af_maj_droit(integer, character varying, boolean) RETURNS boolean
    AS $_$-- $1 : numero droit
-- $2 : libelle
-- $3 : defaut
begin
    update contraintes.droit set libelle=$2,defaut=$3 where id=$1;
    return found;
end;$_$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_maj_droit(integer, character varying, boolean) OWNER TO pgsql;

--
-- TOC entry 8295 (class 0 OID 0)
-- Dependencies: 1381
-- Name: FUNCTION af_maj_droit(integer, character varying, boolean); Type: COMMENT; Schema: contraintes; Owner: pgsql
--

COMMENT ON FUNCTION af_maj_droit(integer, character varying, boolean) IS 'met à jour un droit';


--
-- TOC entry 1382 (class 1255 OID 2596234)
-- Dependencies: 2983 5
-- Name: af_maj_espace(integer, character varying); Type: FUNCTION; Schema: contraintes; Owner: pgsql
--

CREATE FUNCTION af_maj_espace(integer, character varying) RETURNS boolean
    AS $_$-- $1 : numero espace
-- $2 : libelle
declare
ams varchar;
begin
    SELECT INTO ams contraintes.fw_get_ams_libelle('espace','libelle','id='||$1,$2);

    update contraintes.espace set libelle=ams 
    where id=$1;
    return found;
end;$_$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_maj_espace(integer, character varying) OWNER TO pgsql;

--
-- TOC entry 8297 (class 0 OID 0)
-- Dependencies: 1382
-- Name: FUNCTION af_maj_espace(integer, character varying); Type: COMMENT; Schema: contraintes; Owner: pgsql
--

COMMENT ON FUNCTION af_maj_espace(integer, character varying) IS 'met à jour un espace';


--
-- TOC entry 1383 (class 1255 OID 2596235)
-- Dependencies: 2983 5
-- Name: af_maj_etape_chat(integer, character varying); Type: FUNCTION; Schema: contraintes; Owner: pgsql
--

CREATE FUNCTION af_maj_etape_chat(integer, character varying) RETURNS boolean
    AS $_$-- $1 : etape
-- $2 : libelle
declare
ok bool;
begin
    SELECT INTO ok * FROM contraintes.af_maj_etape_libelle($1, $2);
    return ok;
end;$_$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_maj_etape_chat(integer, character varying) OWNER TO pgsql;

--
-- TOC entry 8299 (class 0 OID 0)
-- Dependencies: 1383
-- Name: FUNCTION af_maj_etape_chat(integer, character varying); Type: COMMENT; Schema: contraintes; Owner: pgsql
--

COMMENT ON FUNCTION af_maj_etape_chat(integer, character varying) IS 'modifie une etape chat';


--
-- TOC entry 1384 (class 1255 OID 2596236)
-- Dependencies: 2983 5
-- Name: af_maj_etape_forum(integer, character varying, integer); Type: FUNCTION; Schema: contraintes; Owner: pgsql
--

CREATE FUNCTION af_maj_etape_forum(integer, character varying, integer) RETURNS boolean
    AS $_$-- $1 : etape
-- $2 : libelle
-- $3 : forum
declare
ok bool;
begin
    SELECT INTO ok * FROM contraintes.af_maj_etape_libelle($1, $2);
    update contraintes.etape_forum set forum=$3 where id=$1;
    return found OR ok;
end;$_$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_maj_etape_forum(integer, character varying, integer) OWNER TO pgsql;

--
-- TOC entry 8301 (class 0 OID 0)
-- Dependencies: 1384
-- Name: FUNCTION af_maj_etape_forum(integer, character varying, integer); Type: COMMENT; Schema: contraintes; Owner: pgsql
--

COMMENT ON FUNCTION af_maj_etape_forum(integer, character varying, integer) IS 'modifier une etape forum';


--
-- TOC entry 1385 (class 1255 OID 2596237)
-- Dependencies: 2983 5
-- Name: af_maj_etape_libelle(integer, character varying); Type: FUNCTION; Schema: contraintes; Owner: pgsql
--

CREATE FUNCTION af_maj_etape_libelle(integer, character varying) RETURNS boolean
    AS $_$DECLARE
--$1 etape
--$2 libelle de l'etape
ams varchar;
BEGIN
	SELECT INTO ams contraintes.fw_get_ams_libelle('etape','libelle','id='||$1,$2);
	UPDATE contraintes.etape SET libelle=ams WHERE id=$1;
	--RAISE NOTICE 'met a jour l''Ã©tape % avec %',$1,$2;
	
	RETURN FOUND;
END$_$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_maj_etape_libelle(integer, character varying) OWNER TO pgsql;

--
-- TOC entry 8303 (class 0 OID 0)
-- Dependencies: 1385
-- Name: FUNCTION af_maj_etape_libelle(integer, character varying); Type: COMMENT; Schema: contraintes; Owner: pgsql
--

COMMENT ON FUNCTION af_maj_etape_libelle(integer, character varying) IS 'Mise a jour du libellé d''une étape.';


--
-- TOC entry 1386 (class 1255 OID 2596238)
-- Dependencies: 2983 5
-- Name: af_maj_etape_parcours(integer, integer, character varying, boolean, integer, boolean); Type: FUNCTION; Schema: contraintes; Owner: pgsql
--

CREATE FUNCTION af_maj_etape_parcours(integer, integer, character varying, boolean, integer, boolean) RETURNS boolean
    AS $_$DECLARE
--$1 parcours
--$2 etape
--$3 libelle_type_etape 
--$4 obligatoire
--$5 chrono
--$6 fin de page
ams varchar;
BEGIN
	SELECT INTO ams contraintes.fw_get_ams_libelle('parcours_etapes','libelle_type_etape','parcours='||$1||'and etape='||$2,$3);
	
	
	UPDATE contraintes.parcours_etapes
	SET libelle_type_etape=ams, obligatoire=$4, chrono=$5, fin=$6
	WHERE parcours=$1 AND etape=$2;

	RETURN FOUND;
END;$_$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_maj_etape_parcours(integer, integer, character varying, boolean, integer, boolean) OWNER TO pgsql;

--
-- TOC entry 1387 (class 1255 OID 2596239)
-- Dependencies: 2983 5
-- Name: af_maj_etape_ressource(integer, character varying, integer, integer, integer); Type: FUNCTION; Schema: contraintes; Owner: pgsql
--

CREATE FUNCTION af_maj_etape_ressource(integer, character varying, integer, integer, integer) RETURNS boolean
    AS $_$
DECLARE
-- $1 : etape
-- $2 : libelle
-- $3 : ressource
-- $4 : espace
-- $5 : section
ok bool;
--ams varchar;
begin
    --SELECT INTO ams contraintes.fw_get_ams_libelle('critere','libelle','id='||$1,$2);

    SELECT INTO ok * FROM contraintes.af_maj_etape_libelle($1, $2);

    update contraintes.etape_ressource set fichier=$3,espace=$4 , section=$5
    where id=$1;

    return found OR ok;
end;$_$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_maj_etape_ressource(integer, character varying, integer, integer, integer) OWNER TO pgsql;

--
-- TOC entry 8306 (class 0 OID 0)
-- Dependencies: 1387
-- Name: FUNCTION af_maj_etape_ressource(integer, character varying, integer, integer, integer); Type: COMMENT; Schema: contraintes; Owner: pgsql
--

COMMENT ON FUNCTION af_maj_etape_ressource(integer, character varying, integer, integer, integer) IS 'modifie une étape ressource';


--
-- TOC entry 1388 (class 1255 OID 2596240)
-- Dependencies: 2983 5
-- Name: af_maj_etapes_libelles(integer[], character varying[]); Type: FUNCTION; Schema: contraintes; Owner: pgsql
--

CREATE FUNCTION af_maj_etapes_libelles(integer[], character varying[]) RETURNS integer
    AS $_$DECLARE
i integer;

BEGIN

	FOR i IN array_lower($1, 1) .. array_upper($1, 1) 
	LOOP
		PERFORM * FROM contraintes.af_maj_etape_libelle($1[i],$2[i]);
	END LOOP; 

	RETURN i;
END$_$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_maj_etapes_libelles(integer[], character varying[]) OWNER TO pgsql;

--
-- TOC entry 8308 (class 0 OID 0)
-- Dependencies: 1388
-- Name: FUNCTION af_maj_etapes_libelles(integer[], character varying[]); Type: COMMENT; Schema: contraintes; Owner: pgsql
--

COMMENT ON FUNCTION af_maj_etapes_libelles(integer[], character varying[]) IS 'Mise a jour des libelles d''un ensemble d''étapes.';


--
-- TOC entry 1389 (class 1255 OID 2596241)
-- Dependencies: 2983 5
-- Name: af_maj_evaluation(integer, character varying); Type: FUNCTION; Schema: contraintes; Owner: pgsql
--

CREATE FUNCTION af_maj_evaluation(integer, character varying) RETURNS boolean
    AS $_$DECLARE
--$1 l'evaluation
--$2 le libelle	
ams varchar;
BEGIN 
	SELECT INTO ams contraintes.fw_get_ams_libelle('evaluation','libelle','id='||$1,$2);

	UPDATE contraintes.evaluation SET libelle=ams WHERE id=$1;
	RETURN FOUND;
END
$_$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_maj_evaluation(integer, character varying) OWNER TO pgsql;

--
-- TOC entry 8310 (class 0 OID 0)
-- Dependencies: 1389
-- Name: FUNCTION af_maj_evaluation(integer, character varying); Type: COMMENT; Schema: contraintes; Owner: pgsql
--

COMMENT ON FUNCTION af_maj_evaluation(integer, character varying) IS 'Mise a jour d''une evaluation.';


--
-- TOC entry 1390 (class 1255 OID 2596242)
-- Dependencies: 2983 5
-- Name: af_maj_exotlc_mail(integer, character varying, character varying, character varying, character varying, character varying, integer); Type: FUNCTION; Schema: contraintes; Owner: pgsql
--

CREATE FUNCTION af_maj_exotlc_mail(integer, character varying, character varying, character varying, character varying, character varying, integer) RETURNS boolean
    AS $_$-- $1 : numero exotlc
-- $2 : titre
-- $3 : commentaire
-- $4 : texte
-- $5 : enonce
-- $6 : remarque
-- $7 : numero formateur
declare
modif1 bool:=false;
modif2 bool:=false;
v_commentaire  text;
v_texte  text;
v_enonce  text;
v_remarque  text;
ams  text;
begin
	SELECT INTO ams contraintes.fw_get_ams_libelle('etape','libelle','id='||$1,$2);

    -- mise à jour du titre
    UPDATE contraintes.etape SET libelle=ams WHERE id=$1;
    modif1:=found;
    -- mise à jour exotlc

SELECT INTO v_commentaire contraintes.fw_get_ams_libelle('exotlc','commentaire','id='||$1,$3);
SELECT INTO v_texte contraintes.fw_get_ams_libelle('exotlc','texte','id='||$1,$4);
SELECT INTO v_enonce contraintes.fw_get_ams_libelle('exotlc','enonce','id='||$1,$5);
SELECT INTO v_remarque contraintes.fw_get_ams_libelle('exotlc','remarque','id='||$1,$6);

    update contraintes.exotlc set commentaire=v_commentaire,texte=v_texte,enonce=v_enonce,remarque=v_remarque
    where id=$1;

    modif2:=found;
    -- mise à jour fformateur
    update contraintes.exotlc_mail set formateur=$7 where id=$1;
    return modif1 or modif2 or found;


end;$_$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_maj_exotlc_mail(integer, character varying, character varying, character varying, character varying, character varying, integer) OWNER TO pgsql;

--
-- TOC entry 8312 (class 0 OID 0)
-- Dependencies: 1390
-- Name: FUNCTION af_maj_exotlc_mail(integer, character varying, character varying, character varying, character varying, character varying, integer); Type: COMMENT; Schema: contraintes; Owner: pgsql
--

COMMENT ON FUNCTION af_maj_exotlc_mail(integer, character varying, character varying, character varying, character varying, character varying, integer) IS 'met à jour un exotlc mail';


--
-- TOC entry 33 (class 1255 OID 2596243)
-- Dependencies: 2983 5
-- Name: af_maj_exotlc_modele_correction(integer, integer); Type: FUNCTION; Schema: contraintes; Owner: pgsql
--

CREATE FUNCTION af_maj_exotlc_modele_correction(integer, integer) RETURNS boolean
    AS $_$-- $1 : exotlc
-- $2 : modele de correction
begin
    if $2 is not null then
	update contraintes.exotlc_modele_correction set modele_correction=$2 where id=$1;
	if not found then
	    insert into contraintes.exotlc_modele_correction(id,modele_correction) values($1,$2);
	end if;
    else
	delete from contraintes.exotlc_modele_correction where id=$1;
    end if;
    return true;
end;$_$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_maj_exotlc_modele_correction(integer, integer) OWNER TO pgsql;

--
-- TOC entry 8314 (class 0 OID 0)
-- Dependencies: 33
-- Name: FUNCTION af_maj_exotlc_modele_correction(integer, integer); Type: COMMENT; Schema: contraintes; Owner: pgsql
--

COMMENT ON FUNCTION af_maj_exotlc_modele_correction(integer, integer) IS 'Met à jour un modele de correction pour 
exo pf autocorrigé';


--
-- TOC entry 1391 (class 1255 OID 2596244)
-- Dependencies: 2983 5
-- Name: af_maj_exotlc_plate_forme(integer, character varying, character varying, character varying, character varying, character varying, character varying, boolean); Type: FUNCTION; Schema: contraintes; Owner: pgsql
--

CREATE FUNCTION af_maj_exotlc_plate_forme(integer, character varying, character varying, character varying, character varying, character varying, character varying, boolean) RETURNS boolean
    AS $_$-- $1 : numero exotlc
-- $2 : titre exotlc
-- $3 : commentaire
-- $4 : texte
-- $5 : enonce
-- $6 : remarque
-- $7 : fichier rendu
-- $8 : autocorrection
declare
modif1 bool:=false;
modif2 bool:=false;
v_commentaire  text;
v_texte  text;
v_enonce  text;
v_remarque  text;

ams  text;
begin
	
    -- mise à jour du titre
    SELECT INTO ams contraintes.fw_get_ams_libelle('etape','libelle','id='||$1,$2);

    UPDATE contraintes.etape SET libelle=ams WHERE id=$1;
    modif1:=found;
    -- mise à jour exotlc
    SELECT INTO v_commentaire contraintes.fw_get_ams_libelle('exotlc','commentaire','id='||$1,$3);
    SELECT INTO v_texte contraintes.fw_get_ams_libelle('exotlc','texte','id='||$1,$4);
    SELECT INTO v_enonce contraintes.fw_get_ams_libelle('exotlc','enonce','id='||$1,$5);
    SELECT INTO v_remarque contraintes.fw_get_ams_libelle('exotlc','remarque','id='||$1,$6);

RAISE NOTICE '%new_remarque=',v_commentaire;
    update contraintes.exotlc set commentaire=v_commentaire,texte=v_texte,enonce=v_enonce,remarque=v_remarque
    where id=$1;
    modif2:=found;
    -- mise à jour fichier rendu
   
    update contraintes.exotlc_plate_forme set fichier_rendu=$7 , autocorrection=$8 where id=$1;
    return modif1 or modif2 or found;
end;$_$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_maj_exotlc_plate_forme(integer, character varying, character varying, character varying, character varying, character varying, character varying, boolean) OWNER TO pgsql;

--
-- TOC entry 8316 (class 0 OID 0)
-- Dependencies: 1391
-- Name: FUNCTION af_maj_exotlc_plate_forme(integer, character varying, character varying, character varying, character varying, character varying, character varying, boolean); Type: COMMENT; Schema: contraintes; Owner: pgsql
--

COMMENT ON FUNCTION af_maj_exotlc_plate_forme(integer, character varying, character varying, character varying, character varying, character varying, character varying, boolean) IS 'met à jour un exotlc plateforme';


--
-- TOC entry 1392 (class 1255 OID 2596245)
-- Dependencies: 2983 5
-- Name: af_maj_fichier(integer, character varying, integer, boolean); Type: FUNCTION; Schema: contraintes; Owner: pgsql
--

CREATE FUNCTION af_maj_fichier(integer, character varying, integer, boolean) RETURNS boolean
    AS $_$DECLARE

BEGIN
	
	UPDATE contraintes.fichier SET libelle=$2, "type"=$3, connecte=$4 WHERE id=$1;
	
	RETURN FOUND;
END$_$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_maj_fichier(integer, character varying, integer, boolean) OWNER TO pgsql;

--
-- TOC entry 8318 (class 0 OID 0)
-- Dependencies: 1392
-- Name: FUNCTION af_maj_fichier(integer, character varying, integer, boolean); Type: COMMENT; Schema: contraintes; Owner: pgsql
--

COMMENT ON FUNCTION af_maj_fichier(integer, character varying, integer, boolean) IS 'Mise a jour d''un fichier.';


--
-- TOC entry 1886 (class 1255 OID 2596246)
-- Dependencies: 2983 5
-- Name: af_maj_fichier_libelle(integer, text); Type: FUNCTION; Schema: contraintes; Owner: pgsql
--

CREATE FUNCTION af_maj_fichier_libelle(integer, text) RETURNS boolean
    AS $_$-- $1 :  id
-- $2 : libelle
begin
    update contraintes.fichier set libelle=$2 
    where id=$1;
    return found;
end;$_$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_maj_fichier_libelle(integer, text) OWNER TO pgsql;

--
-- TOC entry 1393 (class 1255 OID 2596247)
-- Dependencies: 2983 5
-- Name: af_maj_fichier_scenario_dynamique(integer, character varying, integer); Type: FUNCTION; Schema: contraintes; Owner: postgres
--

CREATE FUNCTION af_maj_fichier_scenario_dynamique(integer, character varying, integer) RETURNS boolean
    AS $_$DECLARE
--$1 id
--$2 libelle
--$3 style
ok bool;
ams varchar;
BEGIN
	SELECT INTO ams contraintes.fw_get_ams_libelle('fichier','libelle','id='||$1,$2);

	UPDATE contraintes.fichier_scenario_dynamique 
	SET style=$3 where id=$1;
	ok:=FOUND;

	UPDATE contraintes.fichier 
	SET libelle=ams where id=$1;

	RETURN ok OR FOUND;
END;$_$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_maj_fichier_scenario_dynamique(integer, character varying, integer) OWNER TO postgres;

--
-- TOC entry 1394 (class 1255 OID 2596248)
-- Dependencies: 2983 5
-- Name: af_maj_fichier_scenario_dynamique_bloc(integer, integer, integer); Type: FUNCTION; Schema: contraintes; Owner: pgsql
--

CREATE FUNCTION af_maj_fichier_scenario_dynamique_bloc(integer, integer, integer) RETURNS boolean
    AS $_$DECLARE
--$1 scenario
--$2 ordre
--$3 direction si positif  on monte, si negatif ou egal à 0 on descend
ok1 boolean;
ok2 boolean;
ok3 boolean;
ok4 boolean;
rec RECORD;
BEGIN

	--on monte le bloc
	IF $3>0 THEN
		FOR rec IN
			SELECT id, ordre
			FROM contraintes.fichier_scenario_dynamique_blocs
			WHERE id=$1
			ORDER BY ordre ASC
		LOOP		
			IF rec.ordre < $2 THEN
				--on décale tous les prédecesseurs
				UPDATE contraintes.fichier_scenario_dynamique_blocs
				SET ordre=ordre-1
				WHERE id=rec.id
				AND ordre=rec.ordre;
				--RAISE NOTICE 'decale predecesseurs';

			ELSEIF 	rec.ordre = $2 THEN
				--on decale le bloc
				UPDATE contraintes.fichier_scenario_dynamique_blocs
				SET ordre=ordre-1
				WHERE id=rec.id
				AND ordre=rec.ordre;
				--RAISE NOTICE 'decale bloc';

			END IF;
		END LOOP;
			
		--on decale le bloc dont on a pris la place
		UPDATE contraintes.fichier_scenario_dynamique_blocs
		SET ordre=ordre+2
		WHERE id=$1
		AND ordre=$2-2;
		--RAISE NOTICE 'decale bloc remplace';
		
		--on recale tous les prédecesseurs
		FOR rec IN
			SELECT id, ordre
			FROM contraintes.fichier_scenario_dynamique_blocs
			WHERE id=$1
			AND ordre < $2-1 
			ORDER BY ordre DESC
		LOOP			
			UPDATE contraintes.fichier_scenario_dynamique_blocs
			SET ordre=ordre+1
			WHERE id=$1
			AND ordre=rec.ordre;
			--RAISE NOTICE 'recale predecesseurs (ordre=%)',rec.ordre;

		END LOOP;
		
			
		RETURN TRUE;
	--on descend le bloc
	ELSE
		FOR rec IN
			SELECT id, ordre
			FROM contraintes.fichier_scenario_dynamique_blocs
			WHERE id=$1
			ORDER BY ordre DESC
		LOOP		
			IF rec.ordre > $2 THEN
				--on décale tous les successeurs
				UPDATE contraintes.fichier_scenario_dynamique_blocs
				SET ordre=ordre+1
				WHERE id=rec.id
				AND ordre=rec.ordre;
				--RAISE NOTICE 'decale successeurs';
			ELSEIF 	rec.ordre = $2 THEN
				--on decale le bloc
				UPDATE contraintes.fichier_scenario_dynamique_blocs
				SET ordre=ordre+1
				WHERE id=rec.id
				AND ordre=rec.ordre;
				--RAISE NOTICE 'decale bloc';
			END IF;
		END LOOP;
		
		--on decale le bloc dont on a pris la place
		UPDATE contraintes.fichier_scenario_dynamique_blocs
		SET ordre=ordre-2
		WHERE id=$1
		AND ordre=$2+2;
		--RAISE NOTICE 'decale bloc remplace';
		
		FOR rec IN
			SELECT id, ordre
			FROM contraintes.fichier_scenario_dynamique_blocs
			WHERE id=$1
			AND ordre> $2+1 
			ORDER BY ordre ASC
		LOOP		
			--on recale tous les successeurs
			UPDATE contraintes.fichier_scenario_dynamique_blocs
			SET ordre=ordre-1
			WHERE id=$1
			AND ordre=rec.ordre;
		END LOOP;
		
		RETURN TRUE;
	END IF;
	
	RETURN FALSE;
END;$_$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_maj_fichier_scenario_dynamique_bloc(integer, integer, integer) OWNER TO pgsql;

--
-- TOC entry 1395 (class 1255 OID 2596249)
-- Dependencies: 2983 5
-- Name: af_maj_fichier_texte(integer, character varying, character varying, character varying, character varying, text, boolean); Type: FUNCTION; Schema: contraintes; Owner: pgsql
--

CREATE FUNCTION af_maj_fichier_texte(integer, character varying, character varying, character varying, character varying, text, boolean) RETURNS boolean
    AS $_$DECLARE
--$1 id du fichier
--$2 libelle du fichier texte
--$3 titre du lien
--$4 adresse du lien
--$5 description
--$6 mise en forme
--$7 connectÃ©
fait boolean;
ams2 varchar;
ams3 varchar;
ams4 varchar;
ams5 varchar;
ams6 varchar;
BEGIN
	-- mise à jour du libelle fichier
	SELECT INTO ams2 contraintes.fw_get_ams_libelle('fichier','libelle','id='||$1,$2);
	UPDATE contraintes.fichier SET libelle=$2, connecte=$7 WHERE id=$1;
	fait:=FOUND;

	-- mise à jour fichier_texte
	SELECT INTO ams3 contraintes.fw_get_ams_libelle('fichier_ressource_texte','libelle','id='||$1,$3);
	SELECT INTO ams4 contraintes.fw_get_ams_libelle('fichier_ressource_texte','adresse','id='||$1,$4);
	SELECT INTO ams5 contraintes.fw_get_ams_libelle('fichier_ressource_texte','description','id='||$1,$5);
	SELECT INTO ams6 contraintes.fw_get_ams_libelle('fichier_ressource_texte','mise_en_forme','id='||$1,$6);
	UPDATE contraintes.fichier_ressource_texte SET libelle=ams3, adresse=ams4, description=ams5, mise_en_forme=ams6, date_modification=now() WHERE id=$1;
	fait:=fait OR FOUND;
		
	RETURN fait;
END$_$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_maj_fichier_texte(integer, character varying, character varying, character varying, character varying, text, boolean) OWNER TO pgsql;

--
-- TOC entry 8323 (class 0 OID 0)
-- Dependencies: 1395
-- Name: FUNCTION af_maj_fichier_texte(integer, character varying, character varying, character varying, character varying, text, boolean); Type: COMMENT; Schema: contraintes; Owner: pgsql
--

COMMENT ON FUNCTION af_maj_fichier_texte(integer, character varying, character varying, character varying, character varying, text, boolean) IS 'Mise a jour d''un fichier texte.';


--
-- TOC entry 1396 (class 1255 OID 2596250)
-- Dependencies: 2983 5
-- Name: af_maj_fichiers_connection(integer[], boolean); Type: FUNCTION; Schema: contraintes; Owner: pgsql
--

CREATE FUNCTION af_maj_fichiers_connection(integer[], boolean) RETURNS integer
    AS $_$DECLARE
i integer;

BEGIN

	FOR i IN array_lower($1, 1) .. array_upper($1, 1) 
	LOOP
		UPDATE contraintes.fichier SET connecte=$2 WHERE id=$1[i];
		RAISE NOTICE 'met a jour le fichier % d''indice%',$1[i],i;
	END LOOP; 

	RETURN i;
END$_$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_maj_fichiers_connection(integer[], boolean) OWNER TO pgsql;

--
-- TOC entry 8325 (class 0 OID 0)
-- Dependencies: 1396
-- Name: FUNCTION af_maj_fichiers_connection(integer[], boolean); Type: COMMENT; Schema: contraintes; Owner: pgsql
--

COMMENT ON FUNCTION af_maj_fichiers_connection(integer[], boolean) IS 'Mise a jour d''un ensemble de connections de fichiers.';


--
-- TOC entry 1397 (class 1255 OID 2596251)
-- Dependencies: 2983 5
-- Name: af_maj_fichiers_scenarios_dynamiques_libelles(integer[], text[]); Type: FUNCTION; Schema: contraintes; Owner: pgsql
--

CREATE FUNCTION af_maj_fichiers_scenarios_dynamiques_libelles(integer[], text[]) RETURNS boolean
    AS $_$-- $1 : tableau d'identifiants
-- $2 : tableau de libelles
declare
i integer;
begin
    IF array_upper($2, 1) !=array_upper($2, 1) THEN
	RAISE EXCEPTION '% identifiants % textes',array_upper($1, 1),array_upper($2, 1); 
    END IF;

    FOR i IN array_lower($1, 1) .. array_upper($1, 1) 
	LOOP
	    PERFORM * FROM contraintes.af_maj_fichier_libelle($1[i],$2[i]);
	END LOOP; 
    return found;

end;$_$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_maj_fichiers_scenarios_dynamiques_libelles(integer[], text[]) OWNER TO pgsql;

--
-- TOC entry 8327 (class 0 OID 0)
-- Dependencies: 1397
-- Name: FUNCTION af_maj_fichiers_scenarios_dynamiques_libelles(integer[], text[]); Type: COMMENT; Schema: contraintes; Owner: pgsql
--

COMMENT ON FUNCTION af_maj_fichiers_scenarios_dynamiques_libelles(integer[], text[]) IS 'Modifie des messages de langue';


--
-- TOC entry 1398 (class 1255 OID 2596252)
-- Dependencies: 2983 5
-- Name: af_maj_filiere(integer, character varying, integer); Type: FUNCTION; Schema: contraintes; Owner: pgsql
--

CREATE FUNCTION af_maj_filiere(integer, character varying, integer) RETURNS boolean
    AS $_$DECLARE
--$1 filiere
--$2 libelle
--$3 pere
ams varchar;
BEGIN
	SELECT INTO ams contraintes.fw_get_ams_libelle('filiere','libelle','id='||$1,$2);

	UPDATE contraintes.filiere SET libelle=ams, pere=$3
	WHERE id=$1;

	RETURN FOUND;
END;$_$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_maj_filiere(integer, character varying, integer) OWNER TO pgsql;

--
-- TOC entry 1399 (class 1255 OID 2596253)
-- Dependencies: 2983 5
-- Name: af_maj_formation(integer, character varying, date, date, integer); Type: FUNCTION; Schema: contraintes; Owner: pgsql
--

CREATE FUNCTION af_maj_formation(integer, character varying, date, date, integer) RETURNS boolean
    AS $_$-- $1 : formation
-- $2 : libelle
-- $3 : debut
-- $4 : fin
-- $5 : langue defaut
declare
ams varchar;
begin
    SELECT INTO ams contraintes.fw_get_ams_libelle('formation','libelle','id='||$1,$2);

	
    update contraintes.formation set libelle=ams,date_debut=$3,date_fin=$4,langue=$5 
    where id=$1;
    return found;
end;$_$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_maj_formation(integer, character varying, date, date, integer) OWNER TO pgsql;

--
-- TOC entry 8330 (class 0 OID 0)
-- Dependencies: 1399
-- Name: FUNCTION af_maj_formation(integer, character varying, date, date, integer); Type: COMMENT; Schema: contraintes; Owner: pgsql
--

COMMENT ON FUNCTION af_maj_formation(integer, character varying, date, date, integer) IS 'met à jour une formation';


--
-- TOC entry 1400 (class 1255 OID 2596254)
-- Dependencies: 2983 5
-- Name: af_maj_formation_dates(integer, date, date); Type: FUNCTION; Schema: contraintes; Owner: pgsql
--

CREATE FUNCTION af_maj_formation_dates(integer, date, date) RETURNS boolean
    AS $_$-- $1 : formation
-- $2 : date debut
-- $3 : date fin
begin
    update contraintes.formation set
	date_debut=$2,
	date_fin=$3
    where id=$1;
    return found;
end;$_$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_maj_formation_dates(integer, date, date) OWNER TO pgsql;

--
-- TOC entry 8332 (class 0 OID 0)
-- Dependencies: 1400
-- Name: FUNCTION af_maj_formation_dates(integer, date, date); Type: COMMENT; Schema: contraintes; Owner: pgsql
--

COMMENT ON FUNCTION af_maj_formation_dates(integer, date, date) IS 'Mettre à jour les dates d''une formation';


--
-- TOC entry 1401 (class 1255 OID 2596255)
-- Dependencies: 2983 5
-- Name: af_maj_formation_evenement(integer, character varying, timestamp without time zone, time without time zone, integer, integer, integer, integer, timestamp without time zone); Type: FUNCTION; Schema: contraintes; Owner: pgsql
--

CREATE FUNCTION af_maj_formation_evenement(integer, character varying, timestamp without time zone, time without time zone, integer, integer, integer, integer, timestamp without time zone) RETURNS boolean
    AS $_$-- $1 : formation
-- $2 : libelle
-- $3 : date
-- $4 : duree
-- $5 : modalite
-- $6 : intervention
-- $7 : intervenant
-- $8 : salle
-- $9 : ancienne date
declare
ams varchar;
begin
    SELECT INTO ams contraintes.fw_get_ams_libelle('evenement','libelle','formation='||$1||' and date='''||$9||'''',$2);

    update contraintes.evenement set
	libelle=ams,
	date=$3,
	duree=$4  ,
	modalite=$5,
	intervention=$6,
	intervenant=$7,
	salle=$8
    where formation=$1 and date=$9;
    return found;
end;$_$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_maj_formation_evenement(integer, character varying, timestamp without time zone, time without time zone, integer, integer, integer, integer, timestamp without time zone) OWNER TO pgsql;

--
-- TOC entry 8334 (class 0 OID 0)
-- Dependencies: 1401
-- Name: FUNCTION af_maj_formation_evenement(integer, character varying, timestamp without time zone, time without time zone, integer, integer, integer, integer, timestamp without time zone); Type: COMMENT; Schema: contraintes; Owner: pgsql
--

COMMENT ON FUNCTION af_maj_formation_evenement(integer, character varying, timestamp without time zone, time without time zone, integer, integer, integer, integer, timestamp without time zone) IS 'met à jour un evenement de formation';


--
-- TOC entry 1402 (class 1255 OID 2596256)
-- Dependencies: 2983 5
-- Name: af_maj_formation_langues(integer, integer[], integer[]); Type: FUNCTION; Schema: contraintes; Owner: pgsql
--

CREATE FUNCTION af_maj_formation_langues(integer, integer[], integer[]) RETURNS boolean
    AS $_$-- $1 : formation
-- $2 : tableau des langue à inserer
-- $3 : tableau des langues à supprimer
declare
i int4;
ok1 bool;
begin
    --LANGUES à ajouter
    if array_upper($2,1)>0 then
    FOR i IN array_lower($2, 1) .. array_upper($2, 1) 
    LOOP
	SELECT INTO ok1 *  FROM contraintes.af_set_formation_langue($1,$2[i]);
	IF NOT ok1 THEN
	    RAISE EXCEPTION 'Les langues n''ont pu etre ajouté .';
	END IF;
    END LOOP;
    end if;
 
    --LANGUES à supprimer
    if array_upper($3,1)>0 then
    FOR i IN array_lower($3, 1) .. array_upper($3, 1) 
    LOOP
	SELECT INTO ok1 *  FROM contraintes.af_del_formation_langue($1,$3[i]);
	IF NOT ok1 THEN
	    RAISE EXCEPTION 'Les langues n''ont pu etre supprimee.';
	END IF;
    END LOOP;
    end if;
    return ok1;
end;$_$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_maj_formation_langues(integer, integer[], integer[]) OWNER TO pgsql;

--
-- TOC entry 8336 (class 0 OID 0)
-- Dependencies: 1402
-- Name: FUNCTION af_maj_formation_langues(integer, integer[], integer[]); Type: COMMENT; Schema: contraintes; Owner: pgsql
--

COMMENT ON FUNCTION af_maj_formation_langues(integer, integer[], integer[]) IS 'met à jour les langues disponibles de la formation';


--
-- TOC entry 1403 (class 1255 OID 2596257)
-- Dependencies: 2983 5
-- Name: af_maj_formation_libelle(integer, character varying); Type: FUNCTION; Schema: contraintes; Owner: pgsql
--

CREATE FUNCTION af_maj_formation_libelle(integer, character varying) RETURNS boolean
    AS $_$-- $1 : formation
-- $2 : titre
declare
ams varchar;
begin
    SELECT INTO ams contraintes.fw_get_ams_libelle('formation','libelle','id='||$1,$2);

    update contraintes.formation set libelle=ams where id=$1;
    return found;
end;$_$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_maj_formation_libelle(integer, character varying) OWNER TO pgsql;

--
-- TOC entry 8338 (class 0 OID 0)
-- Dependencies: 1403
-- Name: FUNCTION af_maj_formation_libelle(integer, character varying); Type: COMMENT; Schema: contraintes; Owner: pgsql
--

COMMENT ON FUNCTION af_maj_formation_libelle(integer, character varying) IS 'mettre à jour le nom d''une formation';


--
-- TOC entry 1404 (class 1255 OID 2596258)
-- Dependencies: 2983 5
-- Name: af_maj_formation_ressource(integer, integer, integer, integer, character varying, timestamp without time zone, timestamp without time zone, interval, text, integer, integer); Type: FUNCTION; Schema: contraintes; Owner: pgsql
--

CREATE FUNCTION af_maj_formation_ressource(integer, integer, integer, integer, character varying, timestamp without time zone, timestamp without time zone, interval, text, integer, integer) RETURNS boolean
    AS $_$-- $1 : formation
-- $2 : ressource
-- $3 : ancien espace
-- $4 : ancienne section
-- $5 : libelle ressource
-- $6 : debut
-- $7 : fin
-- $8 : duree nouveaute
-- $9 : mots cles
-- $10 : espace
-- $11 : section
declare
etape int4;
ok bool;
ok2 bool;
ams varchar;
begin
    -- recup n° etape
    -- mise en commentaire par said (19/06/08)
    --select into etape id from contraintes.etape_ressource where fichier_ressource=$2;
    -- maj libelle etape
    -- mise en commentaire par said (19/06/08)
    --select into ok * from contraintes.af_maj_etape_libelle(etape,$5);
    -- maj table formation_ressource
    update contraintes.formation_ressources set 
    debut_disponibilite=$6,fin_disponibilite=$7,duree_nouveaute=$8,espace=$10,section=$11 
    where formation=$1 and fichier_ressource=$2 and espace=$3 and section=$4;
    ok2:=found;	
    -- maj table ressource (mot cles)
    SELECT INTO ams contraintes.fw_get_ams_libelle('fichier_metadata','mots_cles','id='||$2,$9);
    update contraintes.fichier_metadata set mots_cles=ams where id=$2;
    --return found or ok or ok2;
    return found or ok2;
end;$_$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_maj_formation_ressource(integer, integer, integer, integer, character varying, timestamp without time zone, timestamp without time zone, interval, text, integer, integer) OWNER TO pgsql;

--
-- TOC entry 8340 (class 0 OID 0)
-- Dependencies: 1404
-- Name: FUNCTION af_maj_formation_ressource(integer, integer, integer, integer, character varying, timestamp without time zone, timestamp without time zone, interval, text, integer, integer); Type: COMMENT; Schema: contraintes; Owner: pgsql
--

COMMENT ON FUNCTION af_maj_formation_ressource(integer, integer, integer, integer, character varying, timestamp without time zone, timestamp without time zone, interval, text, integer, integer) IS 'modifie une ressource de formation';


--
-- TOC entry 1405 (class 1255 OID 2596259)
-- Dependencies: 2983 5
-- Name: af_maj_formation_ressources_fusionnees(integer, boolean); Type: FUNCTION; Schema: contraintes; Owner: pgsql
--

CREATE FUNCTION af_maj_formation_ressources_fusionnees(integer, boolean) RETURNS boolean
    AS $_$-- $1 : formation
-- $2 : booleen fusion
begin
    update contraintes.formation set ressources_fusionnees=$2 where id=$1;
    return found;
end;$_$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_maj_formation_ressources_fusionnees(integer, boolean) OWNER TO pgsql;

--
-- TOC entry 8342 (class 0 OID 0)
-- Dependencies: 1405
-- Name: FUNCTION af_maj_formation_ressources_fusionnees(integer, boolean); Type: COMMENT; Schema: contraintes; Owner: pgsql
--

COMMENT ON FUNCTION af_maj_formation_ressources_fusionnees(integer, boolean) IS 'modifie le booleen de fusion des ressources pour une formation';


--
-- TOC entry 1407 (class 1255 OID 2596260)
-- Dependencies: 2983 5
-- Name: af_maj_forum(integer, character varying, character varying, boolean, character varying, integer, integer); Type: FUNCTION; Schema: contraintes; Owner: pgsql
--

CREATE FUNCTION af_maj_forum(integer, character varying, character varying, boolean, character varying, integer, integer) RETURNS boolean
    AS $_$-- $1 : forum
-- $2 : libelle forum
-- $3 : description
-- $4 : upload
-- $5 : theme
-- $6 : arbo par page
-- $7 : msg par page
begin
    update contraintes.forum 
    set libelle=$2,description=$3,fils=$6,messages=$7,upload=$4,theme=$5 
    where id=$1;
    return found;     
end;$_$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_maj_forum(integer, character varying, character varying, boolean, character varying, integer, integer) OWNER TO pgsql;

--
-- TOC entry 8344 (class 0 OID 0)
-- Dependencies: 1407
-- Name: FUNCTION af_maj_forum(integer, character varying, character varying, boolean, character varying, integer, integer); Type: COMMENT; Schema: contraintes; Owner: pgsql
--

COMMENT ON FUNCTION af_maj_forum(integer, character varying, character varying, boolean, character varying, integer, integer) IS 'modifier un forum';


--
-- TOC entry 1406 (class 1255 OID 2596261)
-- Dependencies: 2983 5
-- Name: af_maj_forum(integer, character varying, character varying, boolean, character varying, integer, integer, integer); Type: FUNCTION; Schema: contraintes; Owner: pgsql
--

CREATE FUNCTION af_maj_forum(integer, character varying, character varying, boolean, character varying, integer, integer, integer) RETURNS boolean
    AS $_$-- $1 : forum
-- $2 : libelle
-- $3 : description
-- $4 : upload
-- $5 : theme
-- $6 : arbo par page
-- $7 : msg par page
-- $8 : configuration
declare
ams_libelle varchar;
ams_description varchar;
begin
    SELECT INTO ams_libelle contraintes.fw_get_ams_libelle('forum','libelle','id='||$1,$2);
    SELECT INTO ams_description contraintes.fw_get_ams_libelle('forum','description','id='||$1,$3);
    update contraintes.forum 
    set libelle=ams_libelle,description=ams_description,upload=$4,theme=$5,fils=$6,messages=$7 
    where id=$1;
    update contraintes.forum_environnements set environnement=$8 where forum=$1;
    return found;
end;$_$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_maj_forum(integer, character varying, character varying, boolean, character varying, integer, integer, integer) OWNER TO pgsql;

--
-- TOC entry 8346 (class 0 OID 0)
-- Dependencies: 1406
-- Name: FUNCTION af_maj_forum(integer, character varying, character varying, boolean, character varying, integer, integer, integer); Type: COMMENT; Schema: contraintes; Owner: pgsql
--

COMMENT ON FUNCTION af_maj_forum(integer, character varying, character varying, boolean, character varying, integer, integer, integer) IS 'Mettre à jour les donées d''un forum';


--
-- TOC entry 34 (class 1255 OID 2596262)
-- Dependencies: 2983 5
-- Name: af_maj_forum_environnement(integer, character varying, character varying, character varying, character varying, character varying, character varying, character varying, character varying, character varying, boolean, boolean, boolean, boolean, boolean, integer, integer, boolean, boolean, boolean, boolean, character varying); Type: FUNCTION; Schema: contraintes; Owner: pgsql
--

CREATE FUNCTION af_maj_forum_environnement(integer, character varying, character varying, character varying, character varying, character varying, character varying, character varying, character varying, character varying, boolean, boolean, boolean, boolean, boolean, integer, integer, boolean, boolean, boolean, boolean, character varying) RETURNS boolean
    AS $_$BEGIN

  UPDATE contraintes.forum_environnement 
  SET
  libelle =$2,
  chemin =$3,
  db_type =$4,
  db_serveur =$5,
  db_name = $6,
  db_user = $7,
  db_pwd = $8,
  admin = $9,
  admin_pwd =$10,
  email_valide =$11,
  email_verification =$12,
  interpretation_html =$13,
  citation =$14,
  noms_longs =$15,
  taille_pj =$16,
  lignes =$17,
  block_ip =$18,
  compte_vus =$19,
  fils_fermes =$20,
  affiche_fils =$21,
  encodage =$22
  WHERE id=$1;

  RETURN FOUND;

END;$_$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_maj_forum_environnement(integer, character varying, character varying, character varying, character varying, character varying, character varying, character varying, character varying, character varying, boolean, boolean, boolean, boolean, boolean, integer, integer, boolean, boolean, boolean, boolean, character varying) OWNER TO pgsql;

--
-- TOC entry 1408 (class 1255 OID 2596263)
-- Dependencies: 2983 5
-- Name: af_maj_ftb(integer, text, boolean, boolean); Type: FUNCTION; Schema: contraintes; Owner: pgsql
--

CREATE FUNCTION af_maj_ftb(integer, text, boolean, boolean) RETURNS boolean
    AS $_$declare
ams varchar;
begin
    SELECT INTO ams contraintes.fw_get_ams_libelle('ftb','text','id='||$1,$2);

    update contraintes.ftb set text=ams,voir_mots=$3,interpretation_html=$4 
    where id=$1;
    -- Ajout said le 03/09/08 (mise à jour dans évaluation)
    perform * from contraintes.af_maj_evaluation($1,$2);
    return found;
end;$_$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_maj_ftb(integer, text, boolean, boolean) OWNER TO pgsql;

--
-- TOC entry 8349 (class 0 OID 0)
-- Dependencies: 1408
-- Name: FUNCTION af_maj_ftb(integer, text, boolean, boolean); Type: COMMENT; Schema: contraintes; Owner: pgsql
--

COMMENT ON FUNCTION af_maj_ftb(integer, text, boolean, boolean) IS 'met à jour un remplir les blancs (ftb)';


--
-- TOC entry 1409 (class 1255 OID 2596264)
-- Dependencies: 2983 5
-- Name: af_maj_grille(integer, character varying); Type: FUNCTION; Schema: contraintes; Owner: pgsql
--

CREATE FUNCTION af_maj_grille(integer, character varying) RETURNS boolean
    AS $_$-- $1 : numero grille
-- $2 : libelle
declare
ams varchar;
begin
    SELECT INTO ams contraintes.fw_get_ams_libelle('grille','libelle','id='||$1,$2);

    update contraintes.grille set libelle =ams where id=$1;
    return found;
end;$_$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_maj_grille(integer, character varying) OWNER TO pgsql;

--
-- TOC entry 8351 (class 0 OID 0)
-- Dependencies: 1409
-- Name: FUNCTION af_maj_grille(integer, character varying); Type: COMMENT; Schema: contraintes; Owner: pgsql
--

COMMENT ON FUNCTION af_maj_grille(integer, character varying) IS 'met à jour une grille';


--
-- TOC entry 1410 (class 1255 OID 2596265)
-- Dependencies: 2983 5
-- Name: af_maj_individu(integer, character varying, character varying, character varying, character varying, character varying, character varying, character varying, character varying, character varying, character varying, integer, integer, integer); Type: FUNCTION; Schema: contraintes; Owner: pgsql
--

CREATE FUNCTION af_maj_individu(integer, character varying, character varying, character varying, character varying, character varying, character varying, character varying, character varying, character varying, character varying, integer, integer, integer) RETURNS boolean
    AS $_$declare
fait boolean;
begin
    update contraintes.fw_individu 
    set login=$2,password=$3,nom=$4,prenom=$5,adresse=$6,code=$7,ville=$8,email=$9,tel_fixe=$10,tel_port=$11,langue=$12,organisme=$13,photo=$14 
    where id=$1;
    fait:=found;
    return fait;	
end;$_$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_maj_individu(integer, character varying, character varying, character varying, character varying, character varying, character varying, character varying, character varying, character varying, character varying, integer, integer, integer) OWNER TO pgsql;

--
-- TOC entry 8353 (class 0 OID 0)
-- Dependencies: 1410
-- Name: FUNCTION af_maj_individu(integer, character varying, character varying, character varying, character varying, character varying, character varying, character varying, character varying, character varying, character varying, integer, integer, integer); Type: COMMENT; Schema: contraintes; Owner: pgsql
--

COMMENT ON FUNCTION af_maj_individu(integer, character varying, character varying, character varying, character varying, character varying, character varying, character varying, character varying, character varying, character varying, integer, integer, integer) IS 'met à jour un individu';


--
-- TOC entry 1411 (class 1255 OID 2596266)
-- Dependencies: 2983 5
-- Name: af_maj_individu(integer, character varying, character varying, character varying, character varying, character varying, character varying, character varying, character varying, character varying, integer, integer); Type: FUNCTION; Schema: contraintes; Owner: pgsql
--

CREATE FUNCTION af_maj_individu(integer, character varying, character varying, character varying, character varying, character varying, character varying, character varying, character varying, character varying, integer, integer) RETURNS boolean
    AS $_$declare
fait boolean;
begin
    update contraintes.fw_individu 
    set password=$2,nom=$3,prenom=$4,adresse=$5,code=$6,ville=$7,email=$8,tel_fixe=$9,tel_port=$10,langue=$11,photo=$12
    where id=$1;
    fait:=found;
    return fait;
end;$_$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_maj_individu(integer, character varying, character varying, character varying, character varying, character varying, character varying, character varying, character varying, character varying, integer, integer) OWNER TO pgsql;

--
-- TOC entry 1412 (class 1255 OID 2596267)
-- Dependencies: 2983 5
-- Name: af_maj_individu_date_deconnexion(integer, timestamp without time zone); Type: FUNCTION; Schema: contraintes; Owner: pgsql
--

CREATE FUNCTION af_maj_individu_date_deconnexion(integer, timestamp without time zone) RETURNS boolean
    AS $_$-- $1 : individu
-- $2 : date deconnexion
begin
    update contraintes.connexion set deconnexion=$2 
    where individu=$1 
    and connexion in 
    (select max(connexion) from contraintes.connexion where individu=$1);
    return found;
end;$_$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_maj_individu_date_deconnexion(integer, timestamp without time zone) OWNER TO pgsql;

--
-- TOC entry 8356 (class 0 OID 0)
-- Dependencies: 1412
-- Name: FUNCTION af_maj_individu_date_deconnexion(integer, timestamp without time zone); Type: COMMENT; Schema: contraintes; Owner: pgsql
--

COMMENT ON FUNCTION af_maj_individu_date_deconnexion(integer, timestamp without time zone) IS 'met à jour la date de deconnexion pour un individu';


--
-- TOC entry 1413 (class 1255 OID 2596268)
-- Dependencies: 2983 5
-- Name: af_maj_individu_session(integer, integer); Type: FUNCTION; Schema: contraintes; Owner: pgsql
--

CREATE FUNCTION af_maj_individu_session(integer, integer) RETURNS boolean
    AS $_$-- $1 : individu
-- $2 : formation
begin
    update contraintes.session set formation=$2 where individu=$1;
    return found;
end;$_$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_maj_individu_session(integer, integer) OWNER TO pgsql;

--
-- TOC entry 8358 (class 0 OID 0)
-- Dependencies: 1413
-- Name: FUNCTION af_maj_individu_session(integer, integer); Type: COMMENT; Schema: contraintes; Owner: pgsql
--

COMMENT ON FUNCTION af_maj_individu_session(integer, integer) IS 'met à jour la session d''un individu';


--
-- TOC entry 1414 (class 1255 OID 2596269)
-- Dependencies: 2983 5
-- Name: af_maj_inscription(integer, character varying, character varying, character varying, character varying, character varying, character varying, character varying, character varying, character varying, character varying, integer, integer, integer); Type: FUNCTION; Schema: contraintes; Owner: pgsql
--

CREATE FUNCTION af_maj_inscription(integer, character varying, character varying, character varying, character varying, character varying, character varying, character varying, character varying, character varying, character varying, integer, integer, integer) RETURNS boolean
    AS $_$declare
fait boolean;
begin
    update contraintes.inscription 
    set login=$2,password=$3,nom=$4,prenom=$5,adresse=$6,code=$7,ville=$8,email=$9,tel_fixe=$10,tel_port=$11,langue=$12,organisme=$13,photo=$14 
    where id=$1;
    fait:=found;
   
    return fait;	
end;$_$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_maj_inscription(integer, character varying, character varying, character varying, character varying, character varying, character varying, character varying, character varying, character varying, character varying, integer, integer, integer) OWNER TO pgsql;

--
-- TOC entry 8360 (class 0 OID 0)
-- Dependencies: 1414
-- Name: FUNCTION af_maj_inscription(integer, character varying, character varying, character varying, character varying, character varying, character varying, character varying, character varying, character varying, character varying, integer, integer, integer); Type: COMMENT; Schema: contraintes; Owner: pgsql
--

COMMENT ON FUNCTION af_maj_inscription(integer, character varying, character varying, character varying, character varying, character varying, character varying, character varying, character varying, character varying, character varying, integer, integer, integer) IS 'met à jour une inscription';


--
-- TOC entry 1415 (class 1255 OID 2596270)
-- Dependencies: 2983 5
-- Name: af_maj_intervention(integer, character varying, character varying); Type: FUNCTION; Schema: contraintes; Owner: pgsql
--

CREATE FUNCTION af_maj_intervention(integer, character varying, character varying) RETURNS boolean
    AS $_$-- $1 : numero intervention
-- $2 : libelle
-- $3 : couleur
declare
ams varchar;
begin
    SELECT INTO ams contraintes.fw_get_ams_libelle('intervention','libelle','id='||$1,$2);

    update contraintes.intervention set libelle=ams,couleur=$3 where id=$1;
    return found;
end;$_$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_maj_intervention(integer, character varying, character varying) OWNER TO pgsql;

--
-- TOC entry 8362 (class 0 OID 0)
-- Dependencies: 1415
-- Name: FUNCTION af_maj_intervention(integer, character varying, character varying); Type: COMMENT; Schema: contraintes; Owner: pgsql
--

COMMENT ON FUNCTION af_maj_intervention(integer, character varying, character varying) IS 'met à jour une intervention';


--
-- TOC entry 1416 (class 1255 OID 2596271)
-- Dependencies: 2983 5
-- Name: af_maj_langue_libelle(integer, integer, integer, text); Type: FUNCTION; Schema: contraintes; Owner: pgsql
--

CREATE FUNCTION af_maj_langue_libelle(integer, integer, integer, text) RETURNS boolean
    AS $_$-- $1 : langue
-- $2 : type
-- $3 : id
-- $4 : libelle
begin
    update contraintes.langue_message set libelle=$4 
    where langue=$1 and type=$2 and id=$3;
    return found;
end;$_$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_maj_langue_libelle(integer, integer, integer, text) OWNER TO pgsql;

--
-- TOC entry 8364 (class 0 OID 0)
-- Dependencies: 1416
-- Name: FUNCTION af_maj_langue_libelle(integer, integer, integer, text); Type: COMMENT; Schema: contraintes; Owner: pgsql
--

COMMENT ON FUNCTION af_maj_langue_libelle(integer, integer, integer, text) IS 'met à jour un libelle de langue';


--
-- TOC entry 1417 (class 1255 OID 2596272)
-- Dependencies: 2983 5
-- Name: af_maj_langue_libelles(integer, integer, integer[], text[]); Type: FUNCTION; Schema: contraintes; Owner: pgsql
--

CREATE FUNCTION af_maj_langue_libelles(integer, integer, integer[], text[]) RETURNS boolean
    AS $_$-- $1 : le numero de langue
-- $2 : le numero de type
-- $3 : tableau d'identifiants
-- $4 : tableau de messages
declare
i integer;
begin
    IF array_upper($3, 1) !=array_upper($4, 1) THEN
	RAISE EXCEPTION '% identifiants % textes',array_upper($3, 1),array_upper($4, 1); 
    END IF;

    FOR i IN array_lower($3, 1) .. array_upper($3, 1) 
	LOOP
	    PERFORM * FROM contraintes.af_maj_langue_libelle($1,$2,$3[i],$4[i]);
	END LOOP; 
    return found;

end;$_$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_maj_langue_libelles(integer, integer, integer[], text[]) OWNER TO pgsql;

--
-- TOC entry 8366 (class 0 OID 0)
-- Dependencies: 1417
-- Name: FUNCTION af_maj_langue_libelles(integer, integer, integer[], text[]); Type: COMMENT; Schema: contraintes; Owner: pgsql
--

COMMENT ON FUNCTION af_maj_langue_libelles(integer, integer, integer[], text[]) IS 'Modifie des messages de langue';


--
-- TOC entry 1418 (class 1255 OID 2596273)
-- Dependencies: 2983 5
-- Name: af_maj_modele_correction_criteres_note(integer, integer, integer, integer); Type: FUNCTION; Schema: contraintes; Owner: pgsql
--

CREATE FUNCTION af_maj_modele_correction_criteres_note(integer, integer, integer, integer) RETURNS boolean
    AS $_$-- $1 : numero modele
-- $2 : numero critere
-- $3 : numero pere
-- $4 : note
begin
    if $3 is not null then	
    update contraintes.modele_correction_criteres set note_max=$4 
    where modele_correction=$1 and critere=$2 and pere=$3;
    else
    update contraintes.modele_correction_criteres set note_max=$4 
    where modele_correction=$1 and critere=$2 and pere is null;
    end if;
    return found;
end$_$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_maj_modele_correction_criteres_note(integer, integer, integer, integer) OWNER TO pgsql;

--
-- TOC entry 8368 (class 0 OID 0)
-- Dependencies: 1418
-- Name: FUNCTION af_maj_modele_correction_criteres_note(integer, integer, integer, integer); Type: COMMENT; Schema: contraintes; Owner: pgsql
--

COMMENT ON FUNCTION af_maj_modele_correction_criteres_note(integer, integer, integer, integer) IS 'met à jour la note dans un modele de correction';


--
-- TOC entry 1419 (class 1255 OID 2596274)
-- Dependencies: 2983 5
-- Name: af_maj_organisme(integer, character varying); Type: FUNCTION; Schema: contraintes; Owner: pgsql
--

CREATE FUNCTION af_maj_organisme(integer, character varying) RETURNS boolean
    AS $_$begin
    update contraintes.organisme 
    set libelle=$2 where id=$1;
    return FOUND;
end;$_$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_maj_organisme(integer, character varying) OWNER TO pgsql;

--
-- TOC entry 8370 (class 0 OID 0)
-- Dependencies: 1419
-- Name: FUNCTION af_maj_organisme(integer, character varying); Type: COMMENT; Schema: contraintes; Owner: pgsql
--

COMMENT ON FUNCTION af_maj_organisme(integer, character varying) IS 'met à jour un organisme';


--
-- TOC entry 1420 (class 1255 OID 2596275)
-- Dependencies: 2983 5
-- Name: af_maj_parcours_duree(integer, boolean); Type: FUNCTION; Schema: contraintes; Owner: pgsql
--

CREATE FUNCTION af_maj_parcours_duree(integer, boolean) RETURNS boolean
    AS $_$DECLARE
--$1 parcours
--$2 affichage duree fo
BEGIN
	UPDATE contraintes.parcours
	SET duree=$2
	WHERE id=$1; 
	
	RETURN FOUND;
END;$_$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_maj_parcours_duree(integer, boolean) OWNER TO pgsql;

--
-- TOC entry 1421 (class 1255 OID 2596276)
-- Dependencies: 2983 5
-- Name: af_maj_parcours_etape(integer, integer, integer, boolean, integer, boolean); Type: FUNCTION; Schema: contraintes; Owner: pgsql
--

CREATE FUNCTION af_maj_parcours_etape(integer, integer, integer, boolean, integer, boolean) RETURNS boolean
    AS $_$DECLARE
--$1 parcours
--$2 pere
--$3 nouvelle tape
--$4 obligation
--$5 chrono
--$6 fin de page
BEGIN
	IF $2 IS NOT NULL THEN
		UPDATE contraintes.parcours_etapes
		SET etape=$3, obligatoire=$4, chrono=$5, fin=$6
		WHERE parcours=$1 AND pere=$2;
	ELSE
		UPDATE contraintes.parcours_etapes
		SET etape=$3, obligatoire=$4, chrono=$5, fin=$6
		WHERE parcours=$1 AND pere IS NULL;
	END IF;

	RETURN FOUND;
END;$_$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_maj_parcours_etape(integer, integer, integer, boolean, integer, boolean) OWNER TO pgsql;

--
-- TOC entry 1422 (class 1255 OID 2596277)
-- Dependencies: 2983 5
-- Name: af_maj_parcours_etape_duree(integer, integer, integer); Type: FUNCTION; Schema: contraintes; Owner: pgsql
--

CREATE FUNCTION af_maj_parcours_etape_duree(integer, integer, integer) RETURNS boolean
    AS $_$DECLARE
--$1 parcours
--$2 etape
--$3 duree
val int4;
BEGIN
	IF $3=0 THEN
		val:=NULL;
	ELSE
		val:=$3;
	END IF;

	UPDATE contraintes.parcours_etapes
	SET chrono=val
	WHERE parcours=$1 AND etape=$2;

	RETURN FOUND;
END;$_$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_maj_parcours_etape_duree(integer, integer, integer) OWNER TO pgsql;

--
-- TOC entry 1887 (class 1255 OID 2596278)
-- Dependencies: 2983 5
-- Name: af_maj_parcours_etape_ordre(integer, integer, integer, boolean); Type: FUNCTION; Schema: contraintes; Owner: pgsql
--

CREATE FUNCTION af_maj_parcours_etape_ordre(integer, integer, integer, boolean) RETURNS boolean
    AS $_$DECLARE
--$1 parcours
--$2 etape source
--$3 etape destination
pere_src int4;
pere_dst int4;
suivant_src int4;
precedent_dst int4;
tmp int4;
BEGIN

	--recup du pere de la source
	SELECT INTO pere_src pere FROM contraintes.af_get_parcours_etape($1,$2)AS (id int4, libelle_alias varchar, libelle varchar, libelle_type_etape  varchar, type varchar,  pere int4, parcours int4, obligatoire bool, chrono int4, fin bool, libelle_type_original varchar);

	--recup du pere de la destination
	SELECT INTO pere_dst pere FROM contraintes.af_get_parcours_etape($1,$3)AS (id int4, libelle_alias varchar, libelle varchar, libelle_type_etape  varchar, type varchar,  pere int4, parcours int4, obligatoire bool, chrono int4, fin bool, libelle_type_original varchar);

	--maj de la source (1ere etape -> petite astuce: on met le pere à l'id du dernier, (pas utilisé pour un pere) pour eviter les conflits)
	SELECT INTO tmp P.id FROM contraintes.af_gen_get_last_element('contraintes.parcours_etapes', 'etape',' AND parcours='||$1) P;
	UPDATE contraintes.parcours_etapes SET pere=tmp WHERE parcours=$1 AND etape=$2;

	--maj du suivant de la source
	UPDATE contraintes.parcours_etapes SET pere=pere_src WHERE parcours=$1 AND pere=$2;
		
--INSERTION AVANT
IF $4 THEN

	--recup du suivant de la source
	SELECT INTO suivant_src etape FROM contraintes.parcours_etapes WHERE parcours=$1 AND pere=$2;

	--maj de la destination
	UPDATE contraintes.parcours_etapes SET pere=$2   WHERE parcours=$1 AND etape=$3;

	--maj de la source (2eme etape -> on met la bonne valeur au pere)
	UPDATE contraintes.parcours_etapes SET pere=pere_dst WHERE parcours=$1 AND etape=$2; 

--INSERTION APRES
ELSE
	--maj du suivant de la destination
	UPDATE contraintes.parcours_etapes SET pere=$2   WHERE parcours=$1 AND pere=$3;

	--maj de la source (2eme etape -> on met la bonne valeur au pere)
	UPDATE contraintes.parcours_etapes SET pere=$3 WHERE parcours=$1 AND etape=$2; 
END IF;

	RETURN TRUE;
END;$_$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_maj_parcours_etape_ordre(integer, integer, integer, boolean) OWNER TO pgsql;

--
-- TOC entry 1423 (class 1255 OID 2596279)
-- Dependencies: 2983 5
-- Name: af_maj_parcours_etape_type_etape_personnalise(integer, integer, character varying); Type: FUNCTION; Schema: contraintes; Owner: pgsql
--

CREATE FUNCTION af_maj_parcours_etape_type_etape_personnalise(integer, integer, character varying) RETURNS boolean
    AS $_$DECLARE
--$1 parcours
--$2 etape
--$3 libelle
BEGIN
	UPDATE contraintes.parcours_etapes
	SET libelle_type_etape=$3
	WHERE parcours=$1
	AND etape=$2;

	RETURN FOUND;
END;$_$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_maj_parcours_etape_type_etape_personnalise(integer, integer, character varying) OWNER TO pgsql;

--
-- TOC entry 1424 (class 1255 OID 2596280)
-- Dependencies: 2983 5
-- Name: af_maj_parcours_etapes_duree_type(integer, character varying, integer); Type: FUNCTION; Schema: contraintes; Owner: pgsql
--

CREATE FUNCTION af_maj_parcours_etapes_duree_type(integer, character varying, integer) RETURNS boolean
    AS $_$DECLARE
--$1 parcours
--$2 type
--$3 duree
val int4;
BEGIN
	IF $3=0 THEN
		val:=NULL;
	ELSE
		val:=$3;
	END IF;

	UPDATE contraintes.parcours_etapes 
	SET chrono=val
	FROM contraintes.af_get_parcours_etapes($1)AS (E_id int4, E_libelle_alias varchar, E_libelle varchar, E_libelle_type_etape  varchar, E_type varchar,  E_pere int4, E_parcours int4, E_obligatoire bool, E_chrono int4, E_fin bool, E_libelle_type_original varchar, E_modifiable bool) 
	WHERE parcours=$1 AND E_type LIKE $2||'%'
	AND E_type NOT LIKE '4_1_4%'
	AND etape=E_id;

	RETURN FOUND;
END;$_$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_maj_parcours_etapes_duree_type(integer, character varying, integer) OWNER TO pgsql;

--
-- TOC entry 1425 (class 1255 OID 2596281)
-- Dependencies: 2983 5
-- Name: af_maj_parcours_oriente(integer, character varying, integer[], integer[], integer, integer[]); Type: FUNCTION; Schema: contraintes; Owner: pgsql
--

CREATE FUNCTION af_maj_parcours_oriente(integer, character varying, integer[], integer[], integer, integer[]) RETURNS boolean
    AS $_$DECLARE
--$1 identifiant de l'étape
--$2 libelle etape
--$3 les sous parcours
--$4 types d'étapes
--$5 nombre de types d'etapes
--$6 seuil
ok1 bool;
ok2 bool;
val int4;
i int4;
j int4;
curs int4:=1;
BEGIN
	--modif de l'etape
	SELECT INTO ok1 * FROM contraintes.af_maj_etape_libelle($1,$2); 
	
	--suppression de la configuration
	DELETE FROM contraintes.parcours_oriente WHERE id=$1;
	ok2:=FOUND;

	--insertion de la nouvelle configuration
	FOR i IN array_lower($3, 1) .. array_upper($3, 1)  
	LOOP
		--le 1er sous parcours
		IF i=1 THEN
			INSERT INTO contraintes.parcours_oriente(id,sous_parcours,type,seuil,ordre) values($1,$3[i],NULL,NULL, i);
			raise notice '1er parcours %: INSERT INTO contraintes.parcours_oriente(id,sous_parcours,type,seuil) values(%,%,%,%);',curs,$1,$3[i],'NULL','NULL';
		--les autres
		ELSE
			--seuil global
			IF $4[curs]=-1 THEN
				INSERT INTO contraintes.parcours_oriente(id,sous_parcours,type,seuil,ordre) values($1,$3[i],NULL,$6[curs],i);
				raise notice 'global %: INSERT INTO contraintes.parcours_oriente(id,sous_parcours,type,seuil) values(%,%,%,%);',curs,$1,$3[i],'NULL',$6[curs];
				curs:=curs+1;
			--seuil par type
			ELSE
				--pour chacun des types
				FOR j IN 1 .. $5
				LOOP
					--cas ou pas de seuil pour le type
					IF $6[curs] =-1 THEN
						val:=NULL;
					ELSE
						val:=$6[curs];
					END IF;
					INSERT INTO contraintes.parcours_oriente(id,sous_parcours,type,seuil,ordre) values($1,$3[i],$4[curs],val,i);
					raise notice 'type %: INSERT INTO contraintes.parcours_oriente(id,sous_parcours,type,seuil) values(%,%,%,%);',curs,$1,$3[i],$4[curs],val;
					curs:=curs+1;
				END LOOP;
			END IF;
		END IF;
	END LOOP;
	
	RETURN ok1 OR ok2;
END; $_$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_maj_parcours_oriente(integer, character varying, integer[], integer[], integer, integer[]) OWNER TO pgsql;

--
-- TOC entry 1426 (class 1255 OID 2596282)
-- Dependencies: 2983 5
-- Name: af_maj_parcours_type_etape_personnalise(integer, integer, character varying); Type: FUNCTION; Schema: contraintes; Owner: pgsql
--

CREATE FUNCTION af_maj_parcours_type_etape_personnalise(integer, integer, character varying) RETURNS boolean
    AS $_$DECLARE
--$1 parcours
--$2 type d'etape
--$3 libelle
BEGIN
	UPDATE contraintes.parcours_etapes
	SET libelle_type_etape=$3
	FROM contraintes.etape
	WHERE parcours=$1
	AND contraintes.parcours_etapes.etape=contraintes.etape.id
	AND contraintes.etape.type=$2;

	RETURN FOUND;
END;$_$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_maj_parcours_type_etape_personnalise(integer, integer, character varying) OWNER TO pgsql;

--
-- TOC entry 1427 (class 1255 OID 2596283)
-- Dependencies: 2983 5
-- Name: af_maj_positionnement(integer, character varying, integer, integer, integer, integer, integer, integer); Type: FUNCTION; Schema: contraintes; Owner: pgsql
--

CREATE FUNCTION af_maj_positionnement(integer, character varying, integer, integer, integer, integer, integer, integer) RETURNS boolean
    AS $_$DECLARE
--$1 id
--$2 libelle
--$3 media
--$4 hauteur
--$5 largeur
--$6 chrono
--$7 chrono evaluations generees
--$8 bareme evaluations generees
ok bool;
ok1 bool;
eval int4;
serie_al int4;
qr int4;
BEGIN 

	--on selectionne la serie aleatoire associée au positionnement
	SELECT INTO serie_al serie_aleatoire FROM contraintes.positionnement where id=$1;

	--on selectionne le question reponse associée au positionnement
	SELECT INTO qr question_reponse FROM contraintes.positionnement where id=$1;

	--on maj la serie aleatoire
	PERFORM contraintes.af_maj_serie(serie_al, $2, $8, $7);

	--on maj l'evaluation
	PERFORM contraintes.af_maj_evaluation($1, $2);

	--on maj le positionnement
	UPDATE contraintes.positionnement SET
	libelle=$2, chrono=$6
	WHERE id=$1;	
	ok:=FOUND;

	IF $3 IS NOT NULL THEN
		SELECT INTO ok1 * FROM contraintes.af_maj_question_reponse_media(qr,$3,$4,$5);
		IF ok1=FALSE THEN
			PERFORM * FROM contraintes.af_set_question_reponse_media(qr,$3,$4,$5);
		END IF;
	ELSE
		PERFORM * FROM contraintes.af_del_question_reponse_media(qr);
	END IF;

	RETURN ok;
END$_$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_maj_positionnement(integer, character varying, integer, integer, integer, integer, integer, integer) OWNER TO pgsql;

--
-- TOC entry 1888 (class 1255 OID 2596284)
-- Dependencies: 2983 5
-- Name: af_maj_positionnement_choix(integer, integer, integer, integer, integer, integer, integer); Type: FUNCTION; Schema: contraintes; Owner: pgsql
--

CREATE FUNCTION af_maj_positionnement_choix(integer, integer, integer, integer, integer, integer, integer) RETURNS boolean
    AS $_$DECLARE
--$1 positionnement
--$2 choix
--$3 nouveau choix
--$4 bareme
--$5 media
--$6 hauteur
--$7 largeur
r1 boolean;
r2 boolean;
qr int4;
BEGIN
	--on selectionne le question-reponse associé au positionnement
	SELECT INTO qr question_reponse FROM contraintes.positionnement where id=$1;

	UPDATE contraintes.choix
	SET id=$3, bareme=$4
	WHERE positionnement=$1
	AND id=$2;
	r1 := FOUND;

	IF $5 IS NOT NULL THEN
		UPDATE contraintes.media_question_reponse_element
		SET media=$5, hauteur=$6, largeur=$7
		WHERE question_reponse=qr
		AND question_reponse_element=$3;
		r2 := FOUND;
		
		IF r2!=TRUE THEN
			INSERT INTO contraintes.media_question_reponse_element (question_reponse, question_reponse_element, media, hauteur, largeur )
			VALUES (qr, $3, $5, $6, $7);
			r2 := FOUND;
		END IF;
	ELSE 
		DELETE FROM contraintes.media_question_reponse_element 
		WHERE question_reponse=qr
		AND question_reponse_element=$2;
		r2 := FOUND;
	END IF;

	RETURN r1 OR r2;
END$_$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_maj_positionnement_choix(integer, integer, integer, integer, integer, integer, integer) OWNER TO pgsql;

--
-- TOC entry 1428 (class 1255 OID 2596285)
-- Dependencies: 2983 5
-- Name: af_maj_positionnement_nb_evaluations_a_generer(integer, integer, integer[]); Type: FUNCTION; Schema: contraintes; Owner: pgsql
--

CREATE FUNCTION af_maj_positionnement_nb_evaluations_a_generer(integer, integer, integer[]) RETURNS boolean
    AS $_$DECLARE
--$1 positionnement
--$2 choix
--$3array int4 : type |  nb_a_generer | taille_chapeau
i int4;
qr int4;
j int4;
k int4;
BEGIN
FOR i IN array_lower($3,1) .. array_upper($3,1)
LOOP
	IF $3[i][3]=-1 THEN
		j:=NULL;
	ELSE
		j:=$3[i][3];
	END IF;

	IF $3[i][2]=-1 THEN
		k:=0;
	ELSE
		k:=$3[i][2];
	END IF;

	--on met a jour les nombres d'evaluations a generer
	UPDATE contraintes.positionnement_choix_evaluations
	SET nombre=k, nombre_max=j
	WHERE positionnement=$1 
	AND choix=$2
	AND type=$3[i][1];
	
END LOOP;
	RETURN FOUND;
END$_$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_maj_positionnement_nb_evaluations_a_generer(integer, integer, integer[]) OWNER TO pgsql;

--
-- TOC entry 1429 (class 1255 OID 2596286)
-- Dependencies: 2983 5
-- Name: af_maj_positionnement_question_positionnement_solution(integer, integer, integer[]); Type: FUNCTION; Schema: contraintes; Owner: pgsql
--

CREATE FUNCTION af_maj_positionnement_question_positionnement_solution(integer, integer, integer[]) RETURNS boolean
    AS $_$DECLARE
--$1 positionnement
--$2 question
--$3array int4 : choix |  juste (0 ou 1)
i int4;
qr int4;
b_value bool;
ok bool;
ok2 bool;
BEGIN
	--on selectionne le question-reponse associé au positionnement
	SELECT INTO qr question_reponse FROM contraintes.positionnement where id=$1;

	FOR i IN array_lower($3,1) .. array_upper($3,1)
	LOOP
		IF $3[i][2]=1 THEN
			b_value:=TRUE;
		ELSE 
			b_value:=FALSE;
		END IF;
		RAISE NOTICE 'maj: %, %, %, %==%',qr, $2, $3[i][1], b_value, $3[i][2];
		SELECT INTO ok * FROM contraintes.af_maj_question_reponse_solution(qr, $2, $3[i][1], b_value);
		IF ok IS FALSE THEN
			RAISE NOTICE 'set: %, %, %, %==%',qr, $2, $3[i][1], b_value, $3[i][2];
			SELECT INTO ok2 * FROM contraintes.af_set_question_reponse_solution(qr, $2, $3[i][1], b_value);
			IF ok2 IS FALSE THEN RAISE EXCEPTION 'Erreur sur l''insertion de la solution.'; END IF;
		END IF;
	END LOOP;
	
	RETURN FOUND;
END$_$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_maj_positionnement_question_positionnement_solution(integer, integer, integer[]) OWNER TO pgsql;

--
-- TOC entry 1430 (class 1255 OID 2596287)
-- Dependencies: 2983 5
-- Name: af_maj_presentiel_carton_capacite_date(integer, integer, integer, integer, integer, timestamp without time zone, integer); Type: FUNCTION; Schema: contraintes; Owner: pgsql
--

CREATE FUNCTION af_maj_presentiel_carton_capacite_date(integer, integer, integer, integer, integer, timestamp without time zone, integer) RETURNS boolean
    AS $_$-- $1 : formation
-- $2 : stagiaire
-- $3 : grille
-- $4 : titre capacite
-- $5 : capacite
-- $6 : date
-- $7 : carton
begin
    update contraintes.grille_resultats 
    set carton =$7
    where formation=$1 and stagiaire=$2 and grille=$3 and capacite_titre=$4 and capacite=$5 and date=$6;
    return found;
end;$_$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_maj_presentiel_carton_capacite_date(integer, integer, integer, integer, integer, timestamp without time zone, integer) OWNER TO pgsql;

--
-- TOC entry 8384 (class 0 OID 0)
-- Dependencies: 1430
-- Name: FUNCTION af_maj_presentiel_carton_capacite_date(integer, integer, integer, integer, integer, timestamp without time zone, integer); Type: COMMENT; Schema: contraintes; Owner: pgsql
--

COMMENT ON FUNCTION af_maj_presentiel_carton_capacite_date(integer, integer, integer, integer, integer, timestamp without time zone, integer) IS 'met à jour le carton pour une capacite à une date';


--
-- TOC entry 1431 (class 1255 OID 2596288)
-- Dependencies: 2983 5
-- Name: af_maj_presentiel_note_individu_date(integer, integer, integer, integer, integer, timestamp without time zone, text, integer, integer); Type: FUNCTION; Schema: contraintes; Owner: pgsql
--

CREATE FUNCTION af_maj_presentiel_note_individu_date(integer, integer, integer, integer, integer, timestamp without time zone, text, integer, integer) RETURNS boolean
    AS $_$-- $1 : formation
-- $2 : stagiaire
-- $3 : grille
-- $4 : titre capacite
-- $5 : capacite
-- $6 : date
-- $7 : commentaire
-- $8 : note
-- $9 : notesur
declare
ams varchar;
begin
    SELECT INTO ams contraintes.fw_get_ams_libelle('grille_resultats','commentaire','formation='||$1||'and stagiaire='||$2||' and grille='||$3||' and capacite_titre='||$4||' and capacite='||$5||' and date='''||$6||'''',$7);
    update contraintes.grille_resultats 
    set commentaire=ams,note=$8,note_max=$9 
    where formation=$1 and stagiaire=$2 and grille=$3 and capacite_titre=$4 and capacite=$5 and date=$6;
    return found;
end;$_$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_maj_presentiel_note_individu_date(integer, integer, integer, integer, integer, timestamp without time zone, text, integer, integer) OWNER TO pgsql;

--
-- TOC entry 8386 (class 0 OID 0)
-- Dependencies: 1431
-- Name: FUNCTION af_maj_presentiel_note_individu_date(integer, integer, integer, integer, integer, timestamp without time zone, text, integer, integer); Type: COMMENT; Schema: contraintes; Owner: pgsql
--

COMMENT ON FUNCTION af_maj_presentiel_note_individu_date(integer, integer, integer, integer, integer, timestamp without time zone, text, integer, integer) IS 'met à jour la note pour une capacite à une date';


--
-- TOC entry 1432 (class 1255 OID 2596289)
-- Dependencies: 2983 5
-- Name: af_maj_presentiel_stagiaire_grille(integer, integer, integer, boolean); Type: FUNCTION; Schema: contraintes; Owner: pgsql
--

CREATE FUNCTION af_maj_presentiel_stagiaire_grille(integer, integer, integer, boolean) RETURNS boolean
    AS $_$-- $1 : formation
-- $2 : stagiaire
-- $3 : grille
-- $4 : bool
begin
    update contraintes.stagiaire_grille set visible=$4 
    where formation=$1 and stagiaire=$2 and grille=$3;
    return found;	
end;$_$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_maj_presentiel_stagiaire_grille(integer, integer, integer, boolean) OWNER TO pgsql;

--
-- TOC entry 8388 (class 0 OID 0)
-- Dependencies: 1432
-- Name: FUNCTION af_maj_presentiel_stagiaire_grille(integer, integer, integer, boolean); Type: COMMENT; Schema: contraintes; Owner: pgsql
--

COMMENT ON FUNCTION af_maj_presentiel_stagiaire_grille(integer, integer, integer, boolean) IS 'Met à jour la table stagiaire_grille(voir ou pas) pour un stagiaire';


--
-- TOC entry 1433 (class 1255 OID 2596290)
-- Dependencies: 2983 5
-- Name: af_maj_qrc(integer, character varying, character varying, boolean, integer[], integer[], integer[]); Type: FUNCTION; Schema: contraintes; Owner: pgsql
--

CREATE FUNCTION af_maj_qrc(integer, character varying, character varying, boolean, integer[], integer[], integer[]) RETURNS boolean
    AS $_$
--$1 Identifiant du question_reponse
--$2 libelle
--$3 question commmune
--$4 radio?
--$5 questions
--$6 reponses
--$7 : tableau des juste/faux
DECLARE
prec_i integer:=NULL;
prec_j integer:=NULL;
maj_ok boolean;
assos_ok_q boolean:=TRUE;
assos_ok_r boolean:=TRUE;
assos_ok_s boolean:=TRUE;
rep_ok boolean:=TRUE;
ins_ok boolean;
b_value boolean;
k integer=1;
BEGIN
    SELECT INTO maj_ok * FROM contraintes.af_maj_qsrc($1, $2,$3,$4);
    DELETE FROM contraintes.question_reponse_elements
    WHERE question_reponse = $1;
    
    -- boucle d'enregistrement des questions
    IF array_upper($5, 1) IS NOT NULL THEN
	FOR i IN array_lower($5, 1) .. array_upper($5, 1)  
	LOOP 
	    IF i-1>0 THEN
		prec_i:=$5[i-1];
	    END IF;
	    SELECT INTO ins_ok contraintes.af_set_question_reponse_association_element($1,$5[i], prec_i);
	    IF NOT ins_ok THEN
		assos_ok_q:=FALSE;
	    END IF;
	end loop;
    end if;
    -- boucle d'enregistrement des reponses
    IF array_upper($6, 1) IS NOT NULL THEN
	FOR j IN array_lower($6, 1) .. array_upper($6, 1)  
	LOOP 
	    IF j-1>0 THEN
		prec_j:=$6[j-1];
	    END IF;
	    SELECT INTO ins_ok contraintes.af_set_question_reponse_association_element($1,$6[j], prec_j);
	    IF NOT ins_ok THEN
		assos_ok_r:=FALSE;
	    END IF;
	end loop;
    end if;

    -- boucles d'enregistrement des vrai faux
    IF array_upper($5, 1) IS NOT NULL THEN
	FOR i IN array_lower($5, 1) .. array_upper($5, 1)  
	LOOP 
	    IF array_upper($6, 1) IS NOT NULL THEN
		FOR j IN array_lower($6, 1) .. array_upper($6, 1)  
		LOOP
		    IF $7[k][1]=$5[i] AND $7[k][2]=$6[j] AND $7[k][3]=1 THEN
			b_value:=TRUE;
		    ELSE 
			b_value:=FALSE;
		    END IF;
		    SELECT INTO rep_ok * FROM contraintes.af_set_question_reponse_solution($1, $5[i], $6[j], b_value);
		    IF NOT rep_ok THEN
			assos_ok_s:=FALSE;
		    END IF;
		    k:=k+1;
		end loop;
	    end if;
	end loop;
    end if;
    

    /*
    IF array_upper($5, 1) IS NOT NULL THEN
	FOR i IN array_lower($5, 1) .. array_upper($5, 1)  
	LOOP 
	    IF i-1>0 THEN
		prec_i:=$5[i-1];
	    END IF;
	    IF array_upper($6, 1) IS NOT NULL THEN
		FOR j IN array_lower($6, 1) .. array_upper($6, 1)  
		LOOP
		    SELECT INTO ins_ok contraintes.af_set_question_reponse_association_element($1,$5[i], $6[j],prec_i);
		    IF NOT ins_ok THEN
			assos_ok:=FALSE;
		    END IF;
		    RAISE NOTICE 'lit juste = %',$7[k][3];
		    IF $7[k][1]=$5[i] AND $7[k][2]=$6[j] AND $7[k][3]=1 THEN
			b_value:=TRUE;
		    ELSE 
			b_value:=FALSE;
		    END IF;
		    SELECT INTO rep_ok * FROM contraintes.af_set_question_reponse_solution($1, $5[i], $6[j], b_value);
		    IF NOT rep_ok THEN
			assos_ok:=FALSE;
		    END IF;
		    k:=k+1;
		END LOOP;
	    END IF;
	END LOOP;
    END IF;
    */

   
    RETURN maj_ok AND assos_ok_q and assos_ok_r and assos_ok_s;
end 
$_$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_maj_qrc(integer, character varying, character varying, boolean, integer[], integer[], integer[]) OWNER TO pgsql;

--
-- TOC entry 8390 (class 0 OID 0)
-- Dependencies: 1433
-- Name: FUNCTION af_maj_qrc(integer, character varying, character varying, boolean, integer[], integer[], integer[]); Type: COMMENT; Schema: contraintes; Owner: pgsql
--

COMMENT ON FUNCTION af_maj_qrc(integer, character varying, character varying, boolean, integer[], integer[], integer[]) IS 'Enregistre un qrc';


--
-- TOC entry 1889 (class 1255 OID 2596291)
-- Dependencies: 2983 5
-- Name: af_maj_qrc_question_solution(integer, integer, integer[]); Type: FUNCTION; Schema: contraintes; Owner: pgsql
--

CREATE FUNCTION af_maj_qrc_question_solution(integer, integer, integer[]) RETURNS boolean
    AS $_$DECLARE
--$1 qrc
--$2 question
--$3 array int4 : choix |  juste (0 ou 1)
i int4;
b_value bool;
ok bool;
ok2 bool;
BEGIN

	FOR i IN array_lower($3,1) .. array_upper($3,1)
	LOOP
		IF $3[i][2]=1 THEN
			b_value:=TRUE;
		ELSE 
			b_value:=FALSE;
		END IF;
		--RAISE NOTICE 'maj: %, %, %, %==%',$1, $2, $3[i][1], b_value, $3[i][2];
		SELECT INTO ok * FROM contraintes.af_maj_question_reponse_solution($1, $2, $3[i][1], b_value);
		IF ok IS FALSE THEN
			RAISE NOTICE 'set: %, %, %, %==%',$1, $2, $3[i][1], b_value, $3[i][2];
			SELECT INTO ok2 * FROM contraintes.af_set_question_reponse_solution($1, $2, $3[i][1], b_value);
			IF ok2 IS FALSE THEN RAISE EXCEPTION 'Erreur sur l''insertion de la solution.'; END IF;
		END IF;
	END LOOP;
	
	RETURN FOUND;
END$_$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_maj_qrc_question_solution(integer, integer, integer[]) OWNER TO pgsql;

--
-- TOC entry 1434 (class 1255 OID 2596292)
-- Dependencies: 2983 5
-- Name: af_maj_qsrc(integer, character varying, character varying, boolean); Type: FUNCTION; Schema: contraintes; Owner: pgsql
--

CREATE FUNCTION af_maj_qsrc(integer, character varying, character varying, boolean) RETURNS boolean
    AS $_$DECLARE
--$1 qsrc
--$2 libelle
--$3 question commune
--$4 radio?
ok bool;
ok1 bool;
ams varchar;

BEGIN

	SELECT INTO ok * FROM contraintes.af_maj_evaluation($1,$2);
	SELECT INTO ams contraintes.fw_get_ams_libelle('qsrc','question','id='||$1,$3);

	UPDATE contraintes.qsrc SET question=ams WHERE id=$1; 
	ok1=FOUND;

	UPDATE contraintes.question_reponse SET radio=$4 WHERE id=$1; 

	RETURN FOUND OR ok OR ok1;
END;$_$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_maj_qsrc(integer, character varying, character varying, boolean) OWNER TO pgsql;

--
-- TOC entry 1435 (class 1255 OID 2596293)
-- Dependencies: 2983 5
-- Name: af_maj_qsrc_question(integer, integer, character varying, integer, integer, integer, boolean); Type: FUNCTION; Schema: contraintes; Owner: pgsql
--

CREATE FUNCTION af_maj_qsrc_question(integer, integer, character varying, integer, integer, integer, boolean) RETURNS boolean
    AS $_$DECLARE
--$1 qsrc
--$2 question
--$3 libelle
--$4 media
--$5 hauteur
--$6 largeur
--$7 interpretation html

ok1 bool;
ok2 bool;
rec RECORD;
maj_rec RECORD;
existe int4;
BEGIN

	--on met a jour la question 
	SELECT INTO ok1 * FROM contraintes.af_maj_question_reponse_element($2, $3, $7);
	RAISE NOTICE 'maj de la question: % % % % -->%',$1, $2, $3, $7,ok1;

	--on recupere la question (pour avaoir le champ pere)
	SELECT INTO maj_rec * 
	FROM  contraintes.question_reponse_elements
	WHERE question_reponse=$1
	AND question=$2;

	--on met a jour le media de la question de positionnement
	IF $4 IS NOT NULL THEN
		SELECT INTO ok2 * FROM contraintes.af_maj_question_reponse_element_media($1, $2, $4, $5, $6);
		IF NOT ok2 THEN
			SELECT INTO ok2 * FROM contraintes.af_set_media_question_reponse_element($1, $2, $4, $5, $6);
		END IF;
	ELSE
		PERFORM * FROM contraintes.af_del_question_reponse_element_media($1, $2);
	END IF;
	ok2:=FOUND;

	FOR rec IN
		--on selectionne les choix du question_reponse
		SELECT id FROM contraintes.choix where question_reponse=$1

	--pour chacun des choix
	LOOP
		SELECT INTO existe COUNT (*) 
		FROM contraintes.question_reponse_elements
		WHERE question_reponse=$1
		AND question=$2
		AND reponse=rec.id;

		IF existe= 0 THEN

			--on associe les elements du question reponse
			PERFORM * FROM contraintes.af_set_question_reponse_association_element($1, $2, rec.id, maj_rec.pere);

			--on enregistre l'association en tant qu'element de positionnement 
			INSERT INTO contraintes.positionnement_elements(question_reponse, question, choix)
			VALUES ($1, $2, rec.id);

		END IF;
	END LOOP;
	
	RETURN ok1 OR ok2;
END;$_$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_maj_qsrc_question(integer, integer, character varying, integer, integer, integer, boolean) OWNER TO pgsql;

--
-- TOC entry 1436 (class 1255 OID 2596294)
-- Dependencies: 2983 5
-- Name: af_maj_question_positionnement(integer, integer, character varying, integer, integer, integer, boolean); Type: FUNCTION; Schema: contraintes; Owner: pgsql
--

CREATE FUNCTION af_maj_question_positionnement(integer, integer, character varying, integer, integer, integer, boolean) RETURNS boolean
    AS $_$DECLARE
--$1 positionnement
--$2 question
--$3 libelle
--$4 media
--$5 hauteur
--$6 largeur
--$7 interpretation html
qr int4;
ok1 bool;
ok2 bool;
rec RECORD;
maj_rec RECORD;
existe int4;
BEGIN
	--on selectionne le question-reponse associé au positionnement
	SELECT INTO qr question_reponse FROM contraintes.positionnement
	WHERE id=$1;

	--on met a jour la question 
	SELECT INTO ok1 * FROM contraintes.af_maj_question_reponse_element($2, $3, $7);
	RAISE NOTICE 'maj de la question: % % % % -->%',qr, $2, $3, $7,ok1;

	--on recupere la question (pour avaoir le champ pere)
	SELECT INTO maj_rec * 
	FROM  contraintes.question_reponse_elements
	WHERE question_reponse=$1
	AND question=$2;

	--on met a jour le media de la question de positionnement
	IF $4 IS NOT NULL THEN
		SELECT INTO ok2 * FROM contraintes.af_maj_question_reponse_element_media(qr, $2, $4, $5, $6);
		IF NOT ok2 THEN
			SELECT INTO ok2 * FROM contraintes.af_set_media_question_reponse_element(qr, $2, $4, $5, $6);
		END IF;
	ELSE
		PERFORM * FROM contraintes.af_del_question_reponse_element_media(qr, $2);
	END IF;
	ok2:=FOUND;

	FOR rec IN
		--on selectionne les choix du positionnement
		SELECT id FROM contraintes.choix where positionnement=$1

	--pour chacun des choix
	LOOP
		SELECT INTO existe COUNT (*) 
		FROM contraintes.question_reponse_elements
		WHERE question_reponse=qr
		AND question=$2
		AND reponse=rec.id;

		IF existe= 0 THEN

			--on associe les elements du question reponse
			PERFORM * FROM contraintes.af_set_question_reponse_association_element(qr, $2, rec.id, maj_rec.pere);

			--on enregistre l'association en tant qu'element de positionnement 
			INSERT INTO contraintes.positionnement_elements(question_reponse, question, choix)
			VALUES (qr, $2, rec.id);

		END IF;
	END LOOP;
	
	RETURN ok1 OR ok2;
END;$_$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_maj_question_positionnement(integer, integer, character varying, integer, integer, integer, boolean) OWNER TO pgsql;

--
-- TOC entry 1437 (class 1255 OID 2596295)
-- Dependencies: 2983 5
-- Name: af_maj_question_reponse_choix(integer, integer, integer, integer, integer, integer, integer); Type: FUNCTION; Schema: contraintes; Owner: pgsql
--

CREATE FUNCTION af_maj_question_reponse_choix(integer, integer, integer, integer, integer, integer, integer) RETURNS boolean
    AS $_$DECLARE
--$1 question_reponse
--$2 choix
--$3 nouveau choix
--$4 bareme
--$5 media
--$6 hauteur
--$7 largeur
r1 boolean;
r2 boolean;
qr int4;
BEGIN
	
	UPDATE contraintes.choix
	SET id=$3, bareme=$4
	WHERE question_reponse=$1
	AND id=$2;
	r1 := FOUND;

	IF $5 IS NOT NULL THEN
		UPDATE contraintes.media_question_reponse_element
		SET media=$5, hauteur=$6, largeur=$7
		WHERE question_reponse=$1
		AND question_reponse_element=$3;
		r2 := FOUND;
		
		IF r2!=TRUE THEN
			INSERT INTO contraintes.media_question_reponse_element (question_reponse, question_reponse_element, media, hauteur, largeur )
			VALUES ($1, $3, $5, $6, $7);
			r2 := FOUND;
		END IF;
	ELSE 
		DELETE FROM contraintes.media_question_reponse_element 
		WHERE question_reponse=$1
		AND question_reponse_element=$2;
		r2 := FOUND;
	END IF;

	RETURN r1 OR r2;
END$_$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_maj_question_reponse_choix(integer, integer, integer, integer, integer, integer, integer) OWNER TO pgsql;

--
-- TOC entry 1438 (class 1255 OID 2596296)
-- Dependencies: 2983 5
-- Name: af_maj_question_reponse_element(integer, character varying, boolean); Type: FUNCTION; Schema: contraintes; Owner: pgsql
--

CREATE FUNCTION af_maj_question_reponse_element(integer, character varying, boolean) RETURNS boolean
    AS $_$DECLARE
ams varchar;
BEGIN
	SELECT INTO ams contraintes.fw_get_ams_libelle('question_reponse_element','libelle','id='||$1,$2);

	UPDATE contraintes.question_reponse_element SET libelle=ams , interpretation_html=$3 WHERE id=$1;
	RETURN FOUND;
END$_$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_maj_question_reponse_element(integer, character varying, boolean) OWNER TO pgsql;

--
-- TOC entry 8397 (class 0 OID 0)
-- Dependencies: 1438
-- Name: FUNCTION af_maj_question_reponse_element(integer, character varying, boolean); Type: COMMENT; Schema: contraintes; Owner: pgsql
--

COMMENT ON FUNCTION af_maj_question_reponse_element(integer, character varying, boolean) IS 'Mise à jour d''un question_reponse_element.';


--
-- TOC entry 1439 (class 1255 OID 2596297)
-- Dependencies: 2983 5
-- Name: af_maj_question_reponse_element_media(integer, integer, integer, integer, integer); Type: FUNCTION; Schema: contraintes; Owner: pgsql
--

CREATE FUNCTION af_maj_question_reponse_element_media(integer, integer, integer, integer, integer) RETURNS boolean
    AS $_$DECLARE 
rec RECORD;
BEGIN

	SELECT INTO rec * from contraintes.af_get_question_reponse_element_media($1,$2) AS (question_reponse int4, question_reponse_element int4, media int4, libelle varchar, hauteur int4, largeur int4);

	IF $3 IS NULL THEN
		PERFORM * FROM contraintes.af_del_media_question_reponse_element($1,$2,$3,$4,$5);
		RAISE NOTICE 'DELETE % % % ',$1,$2,$3;
		RETURN FOUND;

	ELSEIF rec.media IS NOT NULL THEN
		UPDATE contraintes.media_question_reponse_element 
		SET media=$3, largeur=$4, hauteur=$5 WHERE question_reponse_element=$2 AND question_reponse=$1;
		RAISE NOTICE 'UPDATE % % % ',$1,$2,$3;
		RETURN FOUND;
	ELSE 
		PERFORM * FROM contraintes.af_set_media_question_reponse_element($1,$2,$3,$4,$5);
		RAISE NOTICE 'INSERT % % % ',$1,$2,$3;
		RETURN FOUND;
	END IF;
	
	RETURN FALSE;
END$_$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_maj_question_reponse_element_media(integer, integer, integer, integer, integer) OWNER TO pgsql;

--
-- TOC entry 8399 (class 0 OID 0)
-- Dependencies: 1439
-- Name: FUNCTION af_maj_question_reponse_element_media(integer, integer, integer, integer, integer); Type: COMMENT; Schema: contraintes; Owner: pgsql
--

COMMENT ON FUNCTION af_maj_question_reponse_element_media(integer, integer, integer, integer, integer) IS 'Mise à jour d''un media de question_reponse_element.';


--
-- TOC entry 1440 (class 1255 OID 2596298)
-- Dependencies: 2983 5
-- Name: af_maj_question_reponse_media(integer, integer, integer, integer); Type: FUNCTION; Schema: contraintes; Owner: pgsql
--

CREATE FUNCTION af_maj_question_reponse_media(integer, integer, integer, integer) RETURNS boolean
    AS $_$BEGIN
	UPDATE contraintes.media_question_reponse 
	SET media=$2, largeur=$3, hauteur=$4 WHERE  question_reponse=$1;

	RETURN FOUND;
END$_$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_maj_question_reponse_media(integer, integer, integer, integer) OWNER TO pgsql;

--
-- TOC entry 8401 (class 0 OID 0)
-- Dependencies: 1440
-- Name: FUNCTION af_maj_question_reponse_media(integer, integer, integer, integer); Type: COMMENT; Schema: contraintes; Owner: pgsql
--

COMMENT ON FUNCTION af_maj_question_reponse_media(integer, integer, integer, integer) IS 'Mise à jour d''un media de question_reponse_element.';


--
-- TOC entry 1890 (class 1255 OID 2596299)
-- Dependencies: 2983 5
-- Name: af_maj_question_reponse_solution(integer, integer, integer, boolean); Type: FUNCTION; Schema: contraintes; Owner: pgsql
--

CREATE FUNCTION af_maj_question_reponse_solution(integer, integer, integer, boolean) RETURNS boolean
    AS $_$DECLARE
--$1 question reponse(qcm)
--$2 question
--$3 reponse
--$4 juste (vrai ou faux)

BEGIN
	UPDATE contraintes.qcm_elements 
	SET juste=$4
	WHERE question_reponse=$1
	AND question=$2
	AND reponse=$3;

	RETURN FOUND;
END$_$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_maj_question_reponse_solution(integer, integer, integer, boolean) OWNER TO pgsql;

--
-- TOC entry 8403 (class 0 OID 0)
-- Dependencies: 1890
-- Name: FUNCTION af_maj_question_reponse_solution(integer, integer, integer, boolean); Type: COMMENT; Schema: contraintes; Owner: pgsql
--

COMMENT ON FUNCTION af_maj_question_reponse_solution(integer, integer, integer, boolean) IS 'Mise a jour d''une association d''element de QCM.';


--
-- TOC entry 1891 (class 1255 OID 2596300)
-- Dependencies: 2983 5
-- Name: af_maj_ressource(integer, integer, text); Type: FUNCTION; Schema: contraintes; Owner: pgsql
--

CREATE FUNCTION af_maj_ressource(integer, integer, text) RETURNS boolean
    AS $_$-- $1 : ressource
-- $2 : fichier
-- $3 : mots cles
begin
    update contraintes.ressource set fichier=$2,mots_cles=$3
    where id=$1;
    return found;
end;$_$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_maj_ressource(integer, integer, text) OWNER TO pgsql;

--
-- TOC entry 8405 (class 0 OID 0)
-- Dependencies: 1891
-- Name: FUNCTION af_maj_ressource(integer, integer, text); Type: COMMENT; Schema: contraintes; Owner: pgsql
--

COMMENT ON FUNCTION af_maj_ressource(integer, integer, text) IS 'modifie une ressource';


--
-- TOC entry 1441 (class 1255 OID 2596301)
-- Dependencies: 2983 5
-- Name: af_maj_resultat_debut(integer); Type: FUNCTION; Schema: contraintes; Owner: pgsql
--

CREATE FUNCTION af_maj_resultat_debut(integer) RETURNS boolean
    AS $_$DECLARE
--$1 resultat
date_deb timestamp;
BEGIN
	SELECT INTO date_deb date_debut FROM contraintes.resultat
	WHERE id=$1;

	IF date_deb IS NULL THEN
		RAISE EXCEPTION 'Erreur: la date de début ne peut etre mise jour, elle n''a pas été affectée auparavent';
	END IF;

	UPDATE contraintes.resultat
	SET date_debut=now()
	WHERE id=$1;
	
	RETURN FOUND;
END;$_$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_maj_resultat_debut(integer) OWNER TO pgsql;

--
-- TOC entry 1442 (class 1255 OID 2596302)
-- Dependencies: 2983 5
-- Name: af_maj_resultat_exotlc(integer, text, boolean); Type: FUNCTION; Schema: contraintes; Owner: pgsql
--

CREATE FUNCTION af_maj_resultat_exotlc(integer, text, boolean) RETURNS boolean
    AS $_$-- $1 : id resultat
-- $2 : commentaire
-- $3 : correction
declare
ams varchar;
begin
    --SELECT INTO ams contraintes.fw_get_ams_libelle('resultat_exotlc','commentaire','id='||$1,$2);

    update contraintes.resultat_exotlc 
    set commentaire=$2,correction=$3,date_correction=now() 
    where id=$1;
    return found;	
end;$_$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_maj_resultat_exotlc(integer, text, boolean) OWNER TO pgsql;

--
-- TOC entry 8408 (class 0 OID 0)
-- Dependencies: 1442
-- Name: FUNCTION af_maj_resultat_exotlc(integer, text, boolean); Type: COMMENT; Schema: contraintes; Owner: pgsql
--

COMMENT ON FUNCTION af_maj_resultat_exotlc(integer, text, boolean) IS 'met à jour les reultats pour un identifiant de resultat';


--
-- TOC entry 1443 (class 1255 OID 2596303)
-- Dependencies: 2983 5
-- Name: af_maj_resultat_exotlc_critere(bigint, integer, integer, integer, text); Type: FUNCTION; Schema: contraintes; Owner: pgsql
--

CREATE FUNCTION af_maj_resultat_exotlc_critere(bigint, integer, integer, integer, text) RETURNS boolean
    AS $_$-- $1 : id resultat
-- $2 : critere
-- $3 : note
-- $4 : note_max
-- $5 : commentaire
declare
ams varchar;
begin
    --SELECT INTO ams contraintes.fw_get_ams_libelle('resultat_exotlc_critere','commentaire','id='||$1||' and critere='||$2,$5);

    update contraintes.resultat_exotlc_critere 
    set note=$3,note_max=$4,commentaire=$5 
    where id=$1 and critere=$2;
    return found;	
end; $_$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_maj_resultat_exotlc_critere(bigint, integer, integer, integer, text) OWNER TO pgsql;

--
-- TOC entry 8410 (class 0 OID 0)
-- Dependencies: 1443
-- Name: FUNCTION af_maj_resultat_exotlc_critere(bigint, integer, integer, integer, text); Type: COMMENT; Schema: contraintes; Owner: pgsql
--

COMMENT ON FUNCTION af_maj_resultat_exotlc_critere(bigint, integer, integer, integer, text) IS 'Modifie les resultats d''un critere pour un identifiant de resultat';


--
-- TOC entry 1444 (class 1255 OID 2596304)
-- Dependencies: 2983 5
-- Name: af_maj_resultat_exotlc_plateforme(bigint, integer); Type: FUNCTION; Schema: contraintes; Owner: pgsql
--

CREATE FUNCTION af_maj_resultat_exotlc_plateforme(bigint, integer) RETURNS boolean
    AS $_$DECLARE
--$1 resultat
--$2 fichier_rendu
ok boolean;
BEGIN
	--SELECT INTO ok * FROM contraintes.af_set_resultat_fin($1);

	UPDATE contraintes.resultat_exotlc
	SET fichier_rendu=$2
	WHERE id=$1;
	
	RETURN FOUND ;--AND ok;
END;$_$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_maj_resultat_exotlc_plateforme(bigint, integer) OWNER TO pgsql;

--
-- TOC entry 1445 (class 1255 OID 2596305)
-- Dependencies: 2983 5
-- Name: af_maj_resultat_exotlc_sous_critere(bigint, integer, integer, integer); Type: FUNCTION; Schema: contraintes; Owner: pgsql
--

CREATE FUNCTION af_maj_resultat_exotlc_sous_critere(bigint, integer, integer, integer) RETURNS boolean
    AS $_$-- $1 : id resultat
-- $2 : sous critere
-- $3 : note
-- $4 : note max
begin
    update contraintes.resultat_exotlc_sous_critere 
    set note=$3,note_max=$4 
    where id=$1 and sous_critere=$2;
    return found;
end;$_$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_maj_resultat_exotlc_sous_critere(bigint, integer, integer, integer) OWNER TO pgsql;

--
-- TOC entry 8413 (class 0 OID 0)
-- Dependencies: 1445
-- Name: FUNCTION af_maj_resultat_exotlc_sous_critere(bigint, integer, integer, integer); Type: COMMENT; Schema: contraintes; Owner: pgsql
--

COMMENT ON FUNCTION af_maj_resultat_exotlc_sous_critere(bigint, integer, integer, integer) IS 'modifie les resultats d''un sous critere pour un identifiant de resultat';


--
-- TOC entry 1892 (class 1255 OID 2596306)
-- Dependencies: 2983 5
-- Name: af_maj_resultat_fin(integer); Type: FUNCTION; Schema: contraintes; Owner: pgsql
--

CREATE FUNCTION af_maj_resultat_fin(integer) RETURNS boolean
    AS $_$DECLARE
--$1 resultat
duree_init interval;
BEGIN
	SELECT INTO duree_init duree FROM contraintes.resultat WHERE id=$1;
	
	IF duree_init IS NULL THEN
		RAISE EXCEPTION 'Erreur: la durée doit avoir déjà été affectée pour la fin de l''étape';
	ELSE
		UPDATE contraintes.resultat
		SET duree=cast(now() AS timestamp without time zone)-date_debut+duree_init
		WHERE id=$1;

		RETURN FOUND;
		
	END IF;
	
END;$_$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_maj_resultat_fin(integer) OWNER TO pgsql;

--
-- TOC entry 1446 (class 1255 OID 2596307)
-- Dependencies: 2983 5
-- Name: af_maj_salle(integer, character varying); Type: FUNCTION; Schema: contraintes; Owner: pgsql
--

CREATE FUNCTION af_maj_salle(integer, character varying) RETURNS boolean
    AS $_$-- $1 : numero salle
-- $2 : libelle
declare
ams varchar;
begin
    SELECT INTO ams contraintes.fw_get_ams_libelle('salle','libelle','id='||$1,$2);

    update contraintes.salle set libelle=ams where id=$1;
    return found;
end;$_$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_maj_salle(integer, character varying) OWNER TO pgsql;

--
-- TOC entry 8416 (class 0 OID 0)
-- Dependencies: 1446
-- Name: FUNCTION af_maj_salle(integer, character varying); Type: COMMENT; Schema: contraintes; Owner: pgsql
--

COMMENT ON FUNCTION af_maj_salle(integer, character varying) IS 'met à jour une salle';


--
-- TOC entry 1447 (class 1255 OID 2596308)
-- Dependencies: 2983 5
-- Name: af_maj_section(integer, character varying, integer); Type: FUNCTION; Schema: contraintes; Owner: pgsql
--

CREATE FUNCTION af_maj_section(integer, character varying, integer) RETURNS boolean
    AS $_$-- $1 : numero section
-- $2 : libelle
-- $3 : numero icone
declare
ams varchar;
begin
    SELECT INTO ams contraintes.fw_get_ams_libelle('section','libelle','id='||$1,$2);

    update contraintes.section set libelle=ams,icone=$3 
    where id=$1;
    return found;
end;$_$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_maj_section(integer, character varying, integer) OWNER TO pgsql;

--
-- TOC entry 8418 (class 0 OID 0)
-- Dependencies: 1447
-- Name: FUNCTION af_maj_section(integer, character varying, integer); Type: COMMENT; Schema: contraintes; Owner: pgsql
--

COMMENT ON FUNCTION af_maj_section(integer, character varying, integer) IS 'met à jour une section';


--
-- TOC entry 1448 (class 1255 OID 2596309)
-- Dependencies: 2983 5
-- Name: af_maj_serie(integer, character varying, integer, integer); Type: FUNCTION; Schema: contraintes; Owner: pgsql
--

CREATE FUNCTION af_maj_serie(integer, character varying, integer, integer) RETURNS boolean
    AS $_$DECLARE
--$1 serie
--$2 libelle
--$3 bareme
--$4 chrono
mod bool:=FALSE;
ams varchar;
BEGIN
	SELECT INTO ams contraintes.fw_get_ams_libelle('etape','libelle','id='||$1,$2);

	UPDATE contraintes.etape SET libelle=ams
	WHERE id=$1;

	mod:=FOUND;

	UPDATE contraintes.serie SET bareme=$3, chrono=$4
	WHERE id=$1;

	RETURN mod OR FOUND;
END$_$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_maj_serie(integer, character varying, integer, integer) OWNER TO pgsql;

--
-- TOC entry 8420 (class 0 OID 0)
-- Dependencies: 1448
-- Name: FUNCTION af_maj_serie(integer, character varying, integer, integer); Type: COMMENT; Schema: contraintes; Owner: pgsql
--

COMMENT ON FUNCTION af_maj_serie(integer, character varying, integer, integer) IS 'Mise à jour d''une série.';


--
-- TOC entry 1449 (class 1255 OID 2596310)
-- Dependencies: 2983 5
-- Name: af_maj_serie_bloquante_configuration(integer, integer, integer, integer, integer, integer, boolean, boolean); Type: FUNCTION; Schema: contraintes; Owner: pgsql
--

CREATE FUNCTION af_maj_serie_bloquante_configuration(integer, integer, integer, integer, integer, integer, boolean, boolean) RETURNS boolean
    AS $_$-- $1 : serie
-- $2 : formation
-- $3 : parcours
-- $4 : seuil
-- $5 : etape retour
-- $6 : tentative
-- $7 : correction
-- $8 : blocage parcours
begin
    update contraintes.serie_bloquante 
    set seuil=$4,etape_retour=$5,tentatives=$6,correction=$7,blocage_parcours=$8 
    where serie=$1 and formation=$2 and parcours=$3;
    return found;
end;$_$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_maj_serie_bloquante_configuration(integer, integer, integer, integer, integer, integer, boolean, boolean) OWNER TO pgsql;

--
-- TOC entry 8422 (class 0 OID 0)
-- Dependencies: 1449
-- Name: FUNCTION af_maj_serie_bloquante_configuration(integer, integer, integer, integer, integer, integer, boolean, boolean); Type: COMMENT; Schema: contraintes; Owner: pgsql
--

COMMENT ON FUNCTION af_maj_serie_bloquante_configuration(integer, integer, integer, integer, integer, integer, boolean, boolean) IS 'Met à jour la configuration d''une serie bloquante';


--
-- TOC entry 1450 (class 1255 OID 2596311)
-- Dependencies: 2983 5
-- Name: af_maj_serie_evaluation(integer, integer, integer, character varying, integer, integer, integer); Type: FUNCTION; Schema: contraintes; Owner: pgsql
--

CREATE FUNCTION af_maj_serie_evaluation(integer, integer, integer, character varying, integer, integer, integer) RETURNS boolean
    AS $_$DECLARE
--$1 serie
--$2 evaluation
--$3 pere
--$4 commentaire
--$5 bareme
--$6 chrono
--$7 point
req varchar;
cond varchar;
cond1 varchar;
cond2 varchar;
ams varchar;
BEGIN

	IF $3 IS NULL THEN
		cond:=' IS NULL';
		cond2:=' NULL';
	ELSE
		cond:=' ='||$3;
		cond2:=$3;

	END IF;

	IF $5 IS NULL THEN
		cond1:=' NULL';
	ELSE
		cond1:= $5;

	END IF;
	
	-- mise à jour du commentaire
	SELECT INTO ams contraintes.fw_get_ams_libelle('serie_evaluations','commentaire','serie='||$1||'and evaluation='||$2,$4);

	req:='UPDATE contraintes.serie_evaluations
	SET evaluation='||$2||', pere='||cond2||', points='||$7||', bareme='||cond1||', chrono='||$6||', commentaire='''||ams||'''
	WHERE serie='||$1||' AND pere '||cond;
	
	EXECUTE req;

	RETURN FOUND;
END$_$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_maj_serie_evaluation(integer, integer, integer, character varying, integer, integer, integer) OWNER TO pgsql;

--
-- TOC entry 8424 (class 0 OID 0)
-- Dependencies: 1450
-- Name: FUNCTION af_maj_serie_evaluation(integer, integer, integer, character varying, integer, integer, integer); Type: COMMENT; Schema: contraintes; Owner: pgsql
--

COMMENT ON FUNCTION af_maj_serie_evaluation(integer, integer, integer, character varying, integer, integer, integer) IS 'Mise à jour d''une évaluation d''une serie.';


--
-- TOC entry 1452 (class 1255 OID 2596312)
-- Dependencies: 2983 5
-- Name: af_maj_serie_evaluation_ordre(integer, integer, character varying, integer, integer, integer); Type: FUNCTION; Schema: contraintes; Owner: pgsql
--

CREATE FUNCTION af_maj_serie_evaluation_ordre(integer, integer, character varying, integer, integer, integer) RETURNS boolean
    AS $_$DECLARE
--$1 serie
--$2 numero du pere
--$3 commentaire pour la correction
--$4 bareme
--$5 chrono
--$6 points
req varchar;
cond varchar;
cond1 varchar;
BEGIN


	IF $2 IS NULL THEN
		cond:=' IS NULL';
	ELSE
		cond:='='||$2;

	END IF;


	IF $4 IS NULL THEN
		cond1:=' NULL';
	ELSE
		cond1:=$4;

	END IF;

	req:='UPDATE contraintes.serie_evaluations 
	SET commentaire='''||$3||''', bareme='||cond1||', chrono='||$5||', points='||$6||'  
	WHERE serie='||$1||' AND pere '||cond||';';

	RAISE NOTICE 'req=%',req;

	EXECUTE req;

	RETURN FOUND;
END$_$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_maj_serie_evaluation_ordre(integer, integer, character varying, integer, integer, integer) OWNER TO pgsql;

--
-- TOC entry 8426 (class 0 OID 0)
-- Dependencies: 1452
-- Name: FUNCTION af_maj_serie_evaluation_ordre(integer, integer, character varying, integer, integer, integer); Type: COMMENT; Schema: contraintes; Owner: pgsql
--

COMMENT ON FUNCTION af_maj_serie_evaluation_ordre(integer, integer, character varying, integer, integer, integer) IS 'Met ajour une association d''une evaluation pour une série en fonction du numero du pere.';


--
-- TOC entry 1451 (class 1255 OID 2596313)
-- Dependencies: 2983 5
-- Name: af_maj_serie_evaluation_ordre(integer, integer, integer, boolean); Type: FUNCTION; Schema: contraintes; Owner: pgsql
--

CREATE FUNCTION af_maj_serie_evaluation_ordre(integer, integer, integer, boolean) RETURNS boolean
    AS $_$DECLARE
--$1 serie
--$2 evaluation source
--$3 evaluation destination
pere_src int4;
pere_dst int4;
suivant_src int4;
precedent_dst int4;
tmp int4;
BEGIN

	--recup du pere de la source
	SELECT INTO pere_src pere FROM contraintes.af_get_serie_evaluation($1,$2)AS (evaluation int4, libelle varchar, serie int4, pere int4, commentaire varchar, bareme int4, chrono int4, points int4, type int4 );

	--recup du pere de la destination
	SELECT INTO pere_dst pere FROM contraintes.af_get_serie_evaluation($1,$3)AS (evaluation int4, libelle varchar, serie int4, pere int4, commentaire varchar, bareme int4, chrono int4, points int4, type int4 ) ;

	--maj de la source (1ere etape -> petite astuce: on met le pere à l'id du dernier, (pas utilisé pour un pere) pour eviter les conflits)
	SELECT INTO tmp P.id FROM contraintes.af_gen_get_last_element('contraintes.serie_evaluations', 'evaluation',' AND serie='||$1) P;
	UPDATE contraintes.serie_evaluations SET pere=tmp WHERE serie=$1 AND evaluation=$2;

	--maj du suivant de la source
	UPDATE contraintes.serie_evaluations SET pere=pere_src WHERE serie=$1 AND pere=$2;
		
--INSERTION AVANT
IF $4 THEN

	--recup du suivant de la source
	SELECT INTO suivant_src evaluation FROM contraintes.serie_evaluations WHERE serie=$1 AND pere=$2;

	--maj de la destination
	UPDATE contraintes.serie_evaluations SET pere=$2   WHERE serie=$1 AND evaluation=$3;

	--maj de la source (2eme etape -> on met la bonne valeur au pere)
	UPDATE contraintes.serie_evaluations SET pere=pere_dst WHERE serie=$1 AND evaluation=$2; 

--INSERTION APRES
ELSE
	--maj du suivant de la destination
	UPDATE contraintes.serie_evaluations SET pere=$2   WHERE serie=$1 AND pere=$3;

	--maj de la source (2eme etape -> on met la bonne valeur au pere)
	UPDATE contraintes.serie_evaluations SET pere=$3 WHERE serie=$1 AND evaluation=$2; 
END IF;

	RETURN 't';
END;$_$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_maj_serie_evaluation_ordre(integer, integer, integer, boolean) OWNER TO pgsql;

--
-- TOC entry 1893 (class 1255 OID 2596314)
-- Dependencies: 2983 5
-- Name: af_maj_src(integer, character varying, character varying, boolean, integer[], integer[]); Type: FUNCTION; Schema: contraintes; Owner: pgsql
--

CREATE FUNCTION af_maj_src(integer, character varying, character varying, boolean, integer[], integer[]) RETURNS boolean
    AS $_$DECLARE
--$1 Identifiant du question_reponse
--$2 libelle
--$3 question commmune
--$4 radio?
--$5 questions
--$6 reponses
prec_i integer;
prec_j integer;
maj_ok boolean;
assos_ok_q boolean:=TRUE;
assos_ok_r boolean:=TRUE;
ins_ok boolean;
BEGIN
    SELECT INTO maj_ok * FROM contraintes.af_maj_qsrc($1, $2,$3,$4);
    DELETE FROM contraintes.question_reponse_elements
    WHERE question_reponse = $1;
    /*
    FOR i IN array_lower($5, 1) .. array_upper($5, 1)  
    LOOP
	IF i-1>0 THEN
	    prec_i:=$5[i-1];
	END IF;

	FOR j IN array_lower($6, 1) .. array_upper($6, 1)  
	LOOP
	    SELECT INTO ins_ok contraintes.af_set_question_reponse_association_element($1,$5[i], $6[j],prec_i);
	    IF NOT ins_ok THEN
		assos_ok:=FALSE;
	    END IF;
	END LOOP;
    END LOOP;
    */
    
    -- boucle d'enregistrement des questions
    FOR i IN array_lower($5, 1) .. array_upper($5, 1)  
    LOOP
	IF i-1>0 THEN
	    prec_i:=$5[i-1];
	END IF;
	SELECT INTO ins_ok contraintes.af_set_question_reponse_association_element($1,$5[i], prec_i);
	IF NOT ins_ok THEN
		assos_ok_q:=FALSE;
	    END IF;
    end loop;

    -- boucle d'enregistrements des reponses
    FOR j IN array_lower($6, 1) .. array_upper($6, 1)  
    LOOP
	IF j-1>0 THEN
	    prec_j:=$6[j-1];
	END IF;
	SELECT INTO ins_ok contraintes.af_set_question_reponse_association_element($1, $6[j],prec_j);
	    IF NOT ins_ok THEN
		assos_ok_r:=FALSE;
	    END IF;
	
    END LOOP;
    RETURN maj_ok AND assos_ok_q and assos_ok_r;
END$_$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_maj_src(integer, character varying, character varying, boolean, integer[], integer[]) OWNER TO pgsql;

--
-- TOC entry 1894 (class 1255 OID 2596315)
-- Dependencies: 2983 5
-- Name: af_maj_test(integer, character varying, boolean, boolean, integer, integer, integer); Type: FUNCTION; Schema: contraintes; Owner: pgsql
--

CREATE FUNCTION af_maj_test(integer, character varying, boolean, boolean, integer, integer, integer) RETURNS integer
    AS $_$DECLARE
id_positionnement int4;
id_test int4;
oid_id int4;
BEGIN 
 ---a continuer!!
/*	INSERT INTO contraintes.etape(libelle, type) VALUES ($1, 4);
	GET DIAGNOSTICS new_id = RESULT_OID;
	
	SELECT INTO res id FROM contraintes.etape WHERE oid=new_id;
	
	INSERT INTO contraintes.liste (id, type) VALUES (res, $4);
	
	INSERT INTO contraintes.serie(id, bareme, chrono) VALUES (res, $2, $3);
	RETURN res;;

	SELECT INTO id_positionnement * FROM contraintes.af_set_positionnement($1,$2,$3,$4,$5,$6);
	
	INSERT INTO contraintes.positionnement 
	(libelle, type_question, chrono)
	VALUES ($1, $2, $6);

	GET DIAGNOSTICS oid_id = RESULT_OID;

	SELECT INTO id id FROM contraintes.positionnement WHERE oid=oid_id;

	INSERT INTO contraintes.media_positionnement 
	(positionnement, media, hauteur, largeur)
	VALUES ($3, $4, $5);


	RETURN id;*/
END$_$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_maj_test(integer, character varying, boolean, boolean, integer, integer, integer) OWNER TO pgsql;

--
-- TOC entry 1453 (class 1255 OID 2596316)
-- Dependencies: 2983 5
-- Name: af_maj_theme(integer, character varying); Type: FUNCTION; Schema: contraintes; Owner: postgres
--

CREATE FUNCTION af_maj_theme(integer, character varying) RETURNS boolean
    AS $_$-- $1 : theme
-- $2 : libelle
declare
ams varchar;
BEGIN
	SELECT INTO ams contraintes.fw_get_ams_libelle('theme','libelle','id='||$1,$2);

	UPDATE contraintes.theme SET libelle=ams WHERE id=$1;

	RETURN FOUND;
END$_$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_maj_theme(integer, character varying) OWNER TO postgres;

--
-- TOC entry 8431 (class 0 OID 0)
-- Dependencies: 1453
-- Name: FUNCTION af_maj_theme(integer, character varying); Type: COMMENT; Schema: contraintes; Owner: postgres
--

COMMENT ON FUNCTION af_maj_theme(integer, character varying) IS 'Mise a jour d''un theme.';


--
-- TOC entry 35 (class 1255 OID 2596317)
-- Dependencies: 2983 5
-- Name: af_maj_theme_individu(integer, integer); Type: FUNCTION; Schema: contraintes; Owner: pgsql
--

CREATE FUNCTION af_maj_theme_individu(integer, integer) RETURNS boolean
    AS $_$-- $1 : theme
-- $2 : libelle

BEGIN

	UPDATE contraintes.theme SET individu=$2 WHERE id=$1;

	RETURN FOUND;
END$_$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_maj_theme_individu(integer, integer) OWNER TO pgsql;

--
-- TOC entry 1454 (class 1255 OID 2596318)
-- Dependencies: 2983 5
-- Name: af_set_alerte(character varying, integer, date, integer, character varying); Type: FUNCTION; Schema: contraintes; Owner: pgsql
--

CREATE FUNCTION af_set_alerte(character varying, integer, date, integer, character varying) RETURNS integer
    AS $_$-- $1 : libelle alerte (titre)
-- $2 : numero formation
-- $3 : date (timestamp)
-- $4 : nombre de jours
-- $5 : texte de l'alerte
declare
new_id int4;
res int4;
begin
    insert into contraintes.alerte(libelle,formation,date,jours,texte) values($1,$2,$3,$4,$5);
    --RECUPERE L'IDENTIFIANT De la nouvelle capacite
    GET DIAGNOSTICS new_id = RESULT_OID;
    SELECT INTO res id FROM contraintes.alerte WHERE oid=new_id;
    return res;
end;$_$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_set_alerte(character varying, integer, date, integer, character varying) OWNER TO pgsql;

--
-- TOC entry 8434 (class 0 OID 0)
-- Dependencies: 1454
-- Name: FUNCTION af_set_alerte(character varying, integer, date, integer, character varying); Type: COMMENT; Schema: contraintes; Owner: pgsql
--

COMMENT ON FUNCTION af_set_alerte(character varying, integer, date, integer, character varying) IS 'enregistre une alerte';


--
-- TOC entry 1455 (class 1255 OID 2596319)
-- Dependencies: 2983 5
-- Name: af_set_bareme(character varying, integer, integer, integer, integer); Type: FUNCTION; Schema: contraintes; Owner: pgsql
--

CREATE FUNCTION af_set_bareme(character varying, integer, integer, integer, integer) RETURNS integer
    AS $_$DECLARE
new_id int4;
res int4;
BEGIN
	
	INSERT INTO contraintes.bareme(libelle, juste,fausse,manquantes,toutes) 
	VALUES($1,$2,$3,$4,$5);

	--RECUPERE L'IDENTIFIANT DE LA NOUVELLE CATEGORIE
	GET DIAGNOSTICS new_id = RESULT_OID;

	SELECT INTO res id FROM contraintes.bareme WHERE oid=new_id;

	RAISE NOTICE 'insertion du bareme d''id: % (oid=%)',res, new_id;
	RETURN res;
END$_$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_set_bareme(character varying, integer, integer, integer, integer) OWNER TO pgsql;

--
-- TOC entry 8436 (class 0 OID 0)
-- Dependencies: 1455
-- Name: FUNCTION af_set_bareme(character varying, integer, integer, integer, integer); Type: COMMENT; Schema: contraintes; Owner: pgsql
--

COMMENT ON FUNCTION af_set_bareme(character varying, integer, integer, integer, integer) IS 'Création d''un bareme';


--
-- TOC entry 1456 (class 1255 OID 2596320)
-- Dependencies: 2983 5
-- Name: af_set_capacite(character varying); Type: FUNCTION; Schema: contraintes; Owner: pgsql
--

CREATE FUNCTION af_set_capacite(character varying) RETURNS integer
    AS $_$-- $1 : libelle capacite
declare
new_id int4;
res int4;
begin
    insert into contraintes.capacite(libelle) values($1);
    --RECUPERE L'IDENTIFIANT De la nouvelle capacite
    GET DIAGNOSTICS new_id = RESULT_OID;
    SELECT INTO res id FROM contraintes.capacite WHERE oid=new_id;
    return res;
end;$_$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_set_capacite(character varying) OWNER TO pgsql;

--
-- TOC entry 8438 (class 0 OID 0)
-- Dependencies: 1456
-- Name: FUNCTION af_set_capacite(character varying); Type: COMMENT; Schema: contraintes; Owner: pgsql
--

COMMENT ON FUNCTION af_set_capacite(character varying) IS 'enregistre une capacite';


--
-- TOC entry 1457 (class 1255 OID 2596321)
-- Dependencies: 2983 5
-- Name: af_set_capacite_titre(character varying); Type: FUNCTION; Schema: contraintes; Owner: pgsql
--

CREATE FUNCTION af_set_capacite_titre(character varying) RETURNS integer
    AS $_$-- $1 : libelle capacite_titre
declare
new_id int4;
res int4;
begin
    insert into contraintes.capacite_titre(libelle) values($1);
    --RECUPERE L'IDENTIFIANT De la nouvelle capacite
    GET DIAGNOSTICS new_id = RESULT_OID;
    SELECT INTO res id FROM contraintes.capacite_titre WHERE oid=new_id;
    return res;
end;$_$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_set_capacite_titre(character varying) OWNER TO pgsql;

--
-- TOC entry 8440 (class 0 OID 0)
-- Dependencies: 1457
-- Name: FUNCTION af_set_capacite_titre(character varying); Type: COMMENT; Schema: contraintes; Owner: pgsql
--

COMMENT ON FUNCTION af_set_capacite_titre(character varying) IS 'enregistre un titre de capacite';


--
-- TOC entry 1458 (class 1255 OID 2596322)
-- Dependencies: 2983 5
-- Name: af_set_capacite_titre_capacite(integer, integer); Type: FUNCTION; Schema: contraintes; Owner: pgsql
--

CREATE FUNCTION af_set_capacite_titre_capacite(integer, integer) RETURNS boolean
    AS $_$-- $1 : numero capacite_titre
-- $2 : numero capacite
begin
    insert into contraintes.capacite_titre_capacites(capacite_titre,capacite) values($1,$2);
    return found;
end;$_$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_set_capacite_titre_capacite(integer, integer) OWNER TO pgsql;

--
-- TOC entry 8442 (class 0 OID 0)
-- Dependencies: 1458
-- Name: FUNCTION af_set_capacite_titre_capacite(integer, integer); Type: COMMENT; Schema: contraintes; Owner: pgsql
--

COMMENT ON FUNCTION af_set_capacite_titre_capacite(integer, integer) IS 'enregistre le couple capacite_titre / capacite';


--
-- TOC entry 1895 (class 1255 OID 2596323)
-- Dependencies: 2983 5
-- Name: af_set_categorie(character varying, character varying, boolean); Type: FUNCTION; Schema: contraintes; Owner: postgres
--

CREATE FUNCTION af_set_categorie(character varying, character varying, boolean) RETURNS integer
    AS $_$--$1 libÃÂ©llÃÂ© de la nouvelle catÃÂ©gorie
--$2 nom de la table associÃÂ© ou NULL si repertoire
--$3 TRUE si la catÃÂ©gorie doit apparaitre dans le gestionaire de contenu, FALSE sinon.
DECLARE
--identifiant de la nouvelle catÃÂ©gorie
new_id int4;
res int4;
--requete de creation de la table associee ÃÂ  la categorie
req_create text;
BEGIN
	--INSERE LA NOUVELLE CATEGORIE
	INSERT INTO contraintes.categorie (libelle, table_cible, gestionnaire_contenu) VALUES ($1,$2,$3); 
	--RECUPERE L'IDENTIFIANT DE LA NOUVELLE CATEGORIE
	GET DIAGNOSTICS new_id = RESULT_OID;

	IF ($2 IS NOT NULL) THEN
		--CREE LA TABLE PERMETTANT DE GERER LES CONTRAINTES SUR LE CHAMP ID DE LA TABLE THEME_CATEGORIES
		req_create:='CREATE TABLE contraintes.categorie_'|| $2  ||'
		(
		  id int4 NOT NULL,
		  categorie int4 NOT NULL,
		  theme int4 NOT NULL,
		  CONSTRAINT pk_categorie_'|| $2 ||' PRIMARY KEY (id),
		  CONSTRAINT fk_categorie_'|| $2 ||'_1 FOREIGN KEY (id, categorie, theme) REFERENCES contraintes.theme_categories (id, categorie, theme) ON UPDATE CASCADE ON DELETE CASCADE,
		  CONSTRAINT fk_categorie_'|| $2 ||'_2 FOREIGN KEY (id) REFERENCES contraintes.'|| $2 ||' (id) ON UPDATE RESTRICT ON DELETE CASCADE
		) 
		WITH OIDS;
		ALTER TABLE contraintes.categorie_'|| $2 ||' OWNER TO postgres;
		GRANT ALL ON TABLE contraintes.categorie_'|| $2 ||' TO "www";
		CREATE TRIGGER del_theme_categorie
		AFTER DELETE
		ON contraintes.categorie_'|| $2 ||'
		FOR EACH ROW
		EXECUTE PROCEDURE contraintes.del_theme_categorie();';
		EXECUTE req_create;
	END IF;
	select into res id from contraintes.categorie where oid=new_id;
	RETURN res;
END;$_$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_set_categorie(character varying, character varying, boolean) OWNER TO postgres;

--
-- TOC entry 8444 (class 0 OID 0)
-- Dependencies: 1895
-- Name: FUNCTION af_set_categorie(character varying, character varying, boolean); Type: COMMENT; Schema: contraintes; Owner: postgres
--

COMMENT ON FUNCTION af_set_categorie(character varying, character varying, boolean) IS 'Fonction qui crÃ©ee une nouvelle catÃ©gorie. 
Un enregistrement est ajoutÃ© dans la table categorie et une table nommÃ©e categorie_nomtable est crÃ©e, avec les contraintes requises.

Param1:
Libelle de la catÃ©gorie

Param2:
Nom de la table ciblÃ©e par la catÃ©gorie, NULL si pas de table.

Param3:
TRUE si la catÃ©gorie doit etre visible dans le gestionnaire de contenu, false sinon.

Retourne: le numero de la nouvelle ligne insÃ©rÃ©e dans la table catÃ©gorie.

exemple d''appel:
select  contraintes.af_set_categorie(varchar ''Positionnement'', varchar ''positionnement'' , FALSE);';


--
-- TOC entry 1896 (class 1255 OID 2596324)
-- Dependencies: 2983 5
-- Name: af_set_categorie_element_theme(integer, integer, integer); Type: FUNCTION; Schema: contraintes; Owner: postgres
--

CREATE FUNCTION af_set_categorie_element_theme(integer, integer, integer) RETURNS boolean
    AS $_$declare
val_theme alias for $2;
val_categorie alias for $1;
val_id alias for $3;
table_fic varchar;
req varchar;
begin

	--RAISE NOTICE 'theme= % categorie=% id=%',val_theme,val_categorie,val_id;
	--recupere la table de sa categorie
	SELECT INTO table_fic table_cible FROM contraintes.categorie 
	WHERE id=val_categorie;

	--insert dans la table principale
	insert into contraintes.theme_categories(theme,categorie,id) values(val_theme,val_categorie,val_id);

	--insert dans la table de la categorie
	req:='INSERT INTO contraintes.categorie_'||table_fic||'(id, categorie, theme) VALUES ('||val_id||','||val_categorie||','||val_theme||')';
	EXECUTE req;

	return FOUND;
end;$_$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_set_categorie_element_theme(integer, integer, integer) OWNER TO postgres;

--
-- TOC entry 8446 (class 0 OID 0)
-- Dependencies: 1896
-- Name: FUNCTION af_set_categorie_element_theme(integer, integer, integer); Type: COMMENT; Schema: contraintes; Owner: postgres
--

COMMENT ON FUNCTION af_set_categorie_element_theme(integer, integer, integer) IS 'association theme/categorie/element';


--
-- TOC entry 1459 (class 1255 OID 2596325)
-- Dependencies: 2983 5
-- Name: af_set_categorie_fichier_glossaire_theme(character varying, integer, integer); Type: FUNCTION; Schema: contraintes; Owner: pgsql
--

CREATE FUNCTION af_set_categorie_fichier_glossaire_theme(character varying, integer, integer) RETURNS integer
    AS $_$DECLARE
--$1 libelle du fichier glossaire
--$2 theme
--$3 categorie
new_id int4;
BEGIN
	--cree le fichier (table pÃ¨re)
	SELECT INTO new_id * FROM contraintes.af_set_categorie_fichier_theme($1,true,$2,$3);

	--cree le fichier glossaire (table fille)
	INSERT INTO contraintes.fichier_glossaire (id,date_modification) 
	VALUES (new_id, now());

	--enregistre dans les themes (ce n'est pas fait par af_set_categorie_fichier_theme car
	--il faut inserer dans fichier_texte avant)
	PERFORM contraintes.af_set_categorie_element_theme($3, $2,new_id);
	RETURN new_id;
END$_$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_set_categorie_fichier_glossaire_theme(character varying, integer, integer) OWNER TO pgsql;

--
-- TOC entry 8448 (class 0 OID 0)
-- Dependencies: 1459
-- Name: FUNCTION af_set_categorie_fichier_glossaire_theme(character varying, integer, integer); Type: COMMENT; Schema: contraintes; Owner: pgsql
--

COMMENT ON FUNCTION af_set_categorie_fichier_glossaire_theme(character varying, integer, integer) IS 'Crée un fichier glossaire et l''enregistre dans un theme et une categorie';


--
-- TOC entry 1460 (class 1255 OID 2596326)
-- Dependencies: 2983 5
-- Name: af_set_categorie_fichier_texte_theme(character varying, character varying, character varying, character varying, text, boolean, integer, integer); Type: FUNCTION; Schema: contraintes; Owner: pgsql
--

CREATE FUNCTION af_set_categorie_fichier_texte_theme(character varying, character varying, character varying, character varying, text, boolean, integer, integer) RETURNS integer
    AS $_$DECLARE
--$1 libelle du fichier texte
--$2 titre du lien
--$3 adresse du lien
--$4 description
--$5 mise en forme
--$6 connectÃ©
--$7 theme
--$8 categorie
new_id int4;
BEGIN
	--cree le fichier (table pÃ¨re)
	SELECT INTO new_id * FROM contraintes.af_set_categorie_fichier_theme($1,$6,$7,$8);

	--cree le fichier texte (table fille)
	INSERT INTO contraintes.fichier_ressource_texte (id,libelle,adresse,description,mise_en_forme) 
	VALUES (new_id, $2, $3, $4, $5);

	--enregistre dans les themes (ce n'est pas fait par af_set_categorie_fichier_theme car
	--il faut inserer dans fichier_texte avant)
	PERFORM contraintes.af_set_categorie_element_theme($8, $7,new_id);
	RETURN new_id;
END$_$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_set_categorie_fichier_texte_theme(character varying, character varying, character varying, character varying, text, boolean, integer, integer) OWNER TO pgsql;

--
-- TOC entry 8450 (class 0 OID 0)
-- Dependencies: 1460
-- Name: FUNCTION af_set_categorie_fichier_texte_theme(character varying, character varying, character varying, character varying, text, boolean, integer, integer); Type: COMMENT; Schema: contraintes; Owner: pgsql
--

COMMENT ON FUNCTION af_set_categorie_fichier_texte_theme(character varying, character varying, character varying, character varying, text, boolean, integer, integer) IS 'Crée un fichier texte et l''enregistre dans un theme et une categorie';


--
-- TOC entry 1461 (class 1255 OID 2596327)
-- Dependencies: 2983 5
-- Name: af_set_categorie_fichier_theme(character varying, boolean, integer, integer); Type: FUNCTION; Schema: contraintes; Owner: postgres
--

CREATE FUNCTION af_set_categorie_fichier_theme(character varying, boolean, integer, integer) RETURNS integer
    AS $_$DECLARE
--$1 libelle
--$2 connecte
--$3 theme
--$4 categorie
type_fic int4;
table_fic varchar;
new_id int4;
new_oid  int4;
req varchar; 
BEGIN
	--RAISE NOTICE 'theme=% categorie=%',$3,$4;
	--selectionne le type du fichier
	SELECT INTO type_fic id  FROM contraintes.fichier_type
	WHERE categorie=$4;

	--recupere la table de sa categorie
	SELECT INTO table_fic table_cible FROM contraintes.categorie 
	WHERE id=$4;	

	--enregistre le fichier dans la table principale
	INSERT INTO contraintes.fichier (libelle, connecte, "type")
	VALUES ($1, $2, type_fic);

	--recupere l'oid et le numero du nouvel enregistrement
	GET DIAGNOSTICS new_oid = RESULT_OID;
	SELECT INTO new_id id FROM contraintes.fichier WHERE oid=new_oid;

	IF $4!=26 and $4!=66 THEN
		--enregistre le fichier dans la table de sa categorie
		req:='INSERT INTO contraintes.'||table_fic||' (id) VALUES ('||new_id||')';
		--req:='INSERT INTO contraintes.fichier_'||table_fic||' (id) VALUES ('||new_id||')';
		EXECUTE req;
		RAISE NOTICE 'req=%',req;

		--enregistre dans les themes
		PERFORM contraintes.af_set_categorie_element_theme($4, $3,new_id);
	END IF;



	RETURN new_id;
END$_$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_set_categorie_fichier_theme(character varying, boolean, integer, integer) OWNER TO postgres;

--
-- TOC entry 8452 (class 0 OID 0)
-- Dependencies: 1461
-- Name: FUNCTION af_set_categorie_fichier_theme(character varying, boolean, integer, integer); Type: COMMENT; Schema: contraintes; Owner: postgres
--

COMMENT ON FUNCTION af_set_categorie_fichier_theme(character varying, boolean, integer, integer) IS 'Crée un fichier 
 et l''enregistre dans un theme et une categorie';


--
-- TOC entry 1462 (class 1255 OID 2596328)
-- Dependencies: 2983 5
-- Name: af_set_categorie_sondage_element(integer, integer, integer); Type: FUNCTION; Schema: contraintes; Owner: postgres
--

CREATE FUNCTION af_set_categorie_sondage_element(integer, integer, integer) RETURNS boolean
    AS $_$begin
	insert into contraintes.categorie_sondage_element(id,categorie,theme) values ($1,$2,$3);
	return found;
end;$_$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_set_categorie_sondage_element(integer, integer, integer) OWNER TO postgres;

--
-- TOC entry 8454 (class 0 OID 0)
-- Dependencies: 1462
-- Name: FUNCTION af_set_categorie_sondage_element(integer, integer, integer); Type: COMMENT; Schema: contraintes; Owner: postgres
--

COMMENT ON FUNCTION af_set_categorie_sondage_element(integer, integer, integer) IS 'Association sondage/categorie/theme';


--
-- TOC entry 1463 (class 1255 OID 2596329)
-- Dependencies: 2983 5
-- Name: af_set_categories_elements_theme(integer); Type: FUNCTION; Schema: contraintes; Owner: pgsql
--

CREATE FUNCTION af_set_categories_elements_theme(integer) RETURNS void
    AS $_$DECLARE
--$1 le theme
rec RECORD;
req1 varchar;
req2 varchar;
BEGIN

	FOR rec IN 
		SELECT id, table_cible
		FROM contraintes.categorie WHERE --table_cible NOT IN
		--(SELECT table_etape FROM contraintes.categorie WHERE table_etape IS NOT NULL)
		--AND 
		id !=28 AND id!=29 AND id!=43
		ORDER BY id
	LOOP
		req1:='INSERT INTO contraintes.theme_categories
		(id, categorie, theme) SELECT id,'||rec.id||','||$1||
		' FROM contraintes.'||rec.table_cible||'';
		EXECUTE req1;

		req2:='INSERT INTO contraintes.categorie_'||rec.table_cible||'
		(id, categorie, theme) SELECT id,'||rec.id||','||$1||
		' FROM contraintes.'||rec.table_cible||'';
		EXECUTE req2;
		RAISE NOTICE 'CATEGORIE %: ajoutee AU theme %',rec.id,$1;
	END LOOP;
END;$_$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_set_categories_elements_theme(integer) OWNER TO pgsql;

--
-- TOC entry 1464 (class 1255 OID 2596330)
-- Dependencies: 2983 5
-- Name: af_set_classe(character varying, integer, integer, integer); Type: FUNCTION; Schema: contraintes; Owner: pgsql
--

CREATE FUNCTION af_set_classe(character varying, integer, integer, integer) RETURNS integer
    AS $_$-- $1 nom de la classe
-- $2 n° pere (null si racine)
-- $3 nombre de places min
-- $4 nombre de places max
declare
req varchar;
new_id int4;
res int4;
begin
    -- test doublon
    --req:='select * from contraintes.classe where lower(libelle) like lower('||$1||') and ';
    if $2 is null then
	--req:=req || ' pere is null';
	perform * from contraintes.classe where lower(libelle) like lower($1) and pere is null;
    else
	--req:=req || ' pere='||$2;
	perform * from contraintes.classe where lower(libelle) like lower($1) and pere =$2;
    end if;
    --execute req;
    if not found then
	insert into contraintes.classe(libelle,pere,min,max) values($1,$2,$3,$4);
	get diagnostics new_id=result_oid;
	SELECT INTO res id FROM contraintes.classe WHERE oid=new_id;

    else
	raise exception 'ce nom existe déjà !';
	res=0;
    end if;

    return res;
end;$_$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_set_classe(character varying, integer, integer, integer) OWNER TO pgsql;

--
-- TOC entry 8457 (class 0 OID 0)
-- Dependencies: 1464
-- Name: FUNCTION af_set_classe(character varying, integer, integer, integer); Type: COMMENT; Schema: contraintes; Owner: pgsql
--

COMMENT ON FUNCTION af_set_classe(character varying, integer, integer, integer) IS 'enregistre une classe';


--
-- TOC entry 1465 (class 1255 OID 2596331)
-- Dependencies: 2983 5
-- Name: af_set_classe_droit(integer, integer); Type: FUNCTION; Schema: contraintes; Owner: pgsql
--

CREATE FUNCTION af_set_classe_droit(integer, integer) RETURNS boolean
    AS $_$-- $1 : numero clase
-- $2 : numero droit
declare
rec contraintes.organisme_type_individu;
ret bool;
begin
    -- boucle sur les individu de la classe
    for rec in
	select * from contraintes.af_get_classe_individus($1,0,'desc',false) 
    loop
	-- insertion droit si l'individu ne le possède pas
	select into ret * from contraintes.af_is_individu_droit_classe(rec.id,$1,$2);
	
	if ret is false then
		
	    perform * from contraintes.af_set_individu_droit_classe(rec.id,$1,$2);
	end if;
    end loop;
    return found;
end$_$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_set_classe_droit(integer, integer) OWNER TO pgsql;

--
-- TOC entry 8459 (class 0 OID 0)
-- Dependencies: 1465
-- Name: FUNCTION af_set_classe_droit(integer, integer); Type: COMMENT; Schema: contraintes; Owner: pgsql
--

COMMENT ON FUNCTION af_set_classe_droit(integer, integer) IS 'enregistre un droit pour une classe';


--
-- TOC entry 1897 (class 1255 OID 2596332)
-- Dependencies: 2983 5
-- Name: af_set_classe_individu(integer, integer); Type: FUNCTION; Schema: contraintes; Owner: pgsql
--

CREATE FUNCTION af_set_classe_individu(integer, integer) RETURNS boolean
    AS $_$-- $1 n°classe
-- $2 n° individu
declare

begin
    insert into contraintes.classe_individus(classe,individu) values($1,$2);
    return true;
end;$_$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_set_classe_individu(integer, integer) OWNER TO pgsql;

--
-- TOC entry 8461 (class 0 OID 0)
-- Dependencies: 1897
-- Name: FUNCTION af_set_classe_individu(integer, integer); Type: COMMENT; Schema: contraintes; Owner: pgsql
--

COMMENT ON FUNCTION af_set_classe_individu(integer, integer) IS 'affilie un individu à une classe';


--
-- TOC entry 1466 (class 1255 OID 2596333)
-- Dependencies: 2983 5
-- Name: af_set_classe_individu(); Type: FUNCTION; Schema: contraintes; Owner: pgsql
--

CREATE FUNCTION af_set_classe_individu() RETURNS boolean
    AS $_$-- $1 n°classe
-- $2 n° individu
declare

begin
    insert into contraintes.classe_individus(classe,individu) values($1,$2);
    return true;
end;$_$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_set_classe_individu() OWNER TO pgsql;

--
-- TOC entry 1467 (class 1255 OID 2596334)
-- Dependencies: 2983 5
-- Name: af_set_commentaire(integer, integer, integer, text); Type: FUNCTION; Schema: contraintes; Owner: pgsql
--

CREATE FUNCTION af_set_commentaire(integer, integer, integer, text) RETURNS boolean
    AS $_$-- $1 : numero etape
-- $2 : min
-- $3 : max
-- $4 : commentaire
begin
    insert into contraintes.commentaire_etape(etape,min,max,commentaire) values($1,$2,$3,$4);
    return found;
end;$_$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_set_commentaire(integer, integer, integer, text) OWNER TO pgsql;

--
-- TOC entry 8464 (class 0 OID 0)
-- Dependencies: 1467
-- Name: FUNCTION af_set_commentaire(integer, integer, integer, text); Type: COMMENT; Schema: contraintes; Owner: pgsql
--

COMMENT ON FUNCTION af_set_commentaire(integer, integer, integer, text) IS 'enregistre un commentaire';


--
-- TOC entry 1468 (class 1255 OID 2596335)
-- Dependencies: 2983 5
-- Name: af_set_critere(character varying, integer); Type: FUNCTION; Schema: contraintes; Owner: pgsql
--

CREATE FUNCTION af_set_critere(character varying, integer) RETURNS integer
    AS $_$-- $1 : libelle
-- $2 : pere

declare
new_id int4;
res int4;
begin
    insert into contraintes.critere(libelle,pere) values($1,$2);
    --RECUPERE L'IDENTIFIANT DU NOUVEAU CRITERE
    GET DIAGNOSTICS new_id = RESULT_OID;
    SELECT INTO res id FROM contraintes.critere WHERE oid=new_id;
    return res;
end;$_$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_set_critere(character varying, integer) OWNER TO pgsql;

--
-- TOC entry 8466 (class 0 OID 0)
-- Dependencies: 1468
-- Name: FUNCTION af_set_critere(character varying, integer); Type: COMMENT; Schema: contraintes; Owner: pgsql
--

COMMENT ON FUNCTION af_set_critere(character varying, integer) IS 'enregistre un critere de correction';


--
-- TOC entry 1469 (class 1255 OID 2596336)
-- Dependencies: 2983 5
-- Name: af_set_espace(character varying); Type: FUNCTION; Schema: contraintes; Owner: pgsql
--

CREATE FUNCTION af_set_espace(character varying) RETURNS integer
    AS $_$-- $1 : libelle
declare
new_id int4;
res int4;
begin
    insert into contraintes.espace(libelle) values($1);
    --RECUPERE L'IDENTIFIANT DU NOUVEL ESPACE
    GET DIAGNOSTICS new_id = RESULT_OID;
    SELECT INTO res id FROM contraintes.espace WHERE oid=new_id;
    -- RAISE NOTICE 'insertion du bareme d''id: % (oid=%)',res, new_id;
    RETURN res;
end;$_$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_set_espace(character varying) OWNER TO pgsql;

--
-- TOC entry 8468 (class 0 OID 0)
-- Dependencies: 1469
-- Name: FUNCTION af_set_espace(character varying); Type: COMMENT; Schema: contraintes; Owner: pgsql
--

COMMENT ON FUNCTION af_set_espace(character varying) IS 'enregistre un nouvel espace';


--
-- TOC entry 1470 (class 1255 OID 2596337)
-- Dependencies: 2983 5
-- Name: af_set_etape(character varying, integer); Type: FUNCTION; Schema: contraintes; Owner: postgres
--

CREATE FUNCTION af_set_etape(character varying, integer) RETURNS integer
    AS $_$declare
	titre alias for $1;
	typ alias for $2;
	new_id int4;
	res int4;
begin
	insert into contraintes.etape(libelle,type) values($1,$2);
	GET DIAGNOSTICS new_id = RESULT_OID;
	select into res id from contraintes.etape where oid=new_id;
	
	return res;

	

end;$_$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_set_etape(character varying, integer) OWNER TO postgres;

--
-- TOC entry 8470 (class 0 OID 0)
-- Dependencies: 1470
-- Name: FUNCTION af_set_etape(character varying, integer); Type: COMMENT; Schema: contraintes; Owner: postgres
--

COMMENT ON FUNCTION af_set_etape(character varying, integer) IS 'crÃ©e une etape';


--
-- TOC entry 1471 (class 1255 OID 2596338)
-- Dependencies: 2983 5
-- Name: af_set_etape_chat(character varying); Type: FUNCTION; Schema: contraintes; Owner: pgsql
--

CREATE FUNCTION af_set_etape_chat(character varying) RETURNS integer
    AS $_$-- $1 : libelle
declare
res int4;
new_id oid;
begin
    -- etape
    insert into contraintes.etape(libelle, type) VALUES ($1, 8);
    GET DIAGNOSTICS new_id = RESULT_OID;
    SELECT INTO res id FROM contraintes.etape WHERE oid=new_id;
    -- etape chat
    insert INTO contraintes.etape_chat(id) VALUES (res);

    RETURN res;
end;$_$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_set_etape_chat(character varying) OWNER TO pgsql;

--
-- TOC entry 8472 (class 0 OID 0)
-- Dependencies: 1471
-- Name: FUNCTION af_set_etape_chat(character varying); Type: COMMENT; Schema: contraintes; Owner: pgsql
--

COMMENT ON FUNCTION af_set_etape_chat(character varying) IS 'enregistre une etape chat';


--
-- TOC entry 1472 (class 1255 OID 2596339)
-- Dependencies: 2983 5
-- Name: af_set_etape_forum(character varying, integer); Type: FUNCTION; Schema: contraintes; Owner: pgsql
--

CREATE FUNCTION af_set_etape_forum(character varying, integer) RETURNS integer
    AS $_$-- $1 : libelle
-- $2 : forum
declare
res int4;
new_id oid;
begin
    -- etape
    insert into contraintes.etape(libelle, type) VALUES ($1, 2);
    GET DIAGNOSTICS new_id = RESULT_OID;
    SELECT INTO res id FROM contraintes.etape WHERE oid=new_id;
    -- etape forum
    insert INTO contraintes.etape_forum(id,forum) VALUES (res,$2);

	RETURN res;
end;$_$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_set_etape_forum(character varying, integer) OWNER TO pgsql;

--
-- TOC entry 8474 (class 0 OID 0)
-- Dependencies: 1472
-- Name: FUNCTION af_set_etape_forum(character varying, integer); Type: COMMENT; Schema: contraintes; Owner: pgsql
--

COMMENT ON FUNCTION af_set_etape_forum(character varying, integer) IS 'Enregistre une etape forum';


--
-- TOC entry 1473 (class 1255 OID 2596340)
-- Dependencies: 2983 5
-- Name: af_set_etape_parcours_oriente_configuration(integer, integer[], integer[], integer[]); Type: FUNCTION; Schema: contraintes; Owner: pgsql
--

CREATE FUNCTION af_set_etape_parcours_oriente_configuration(integer, integer[], integer[], integer[]) RETURNS boolean
    AS $_$DECLARE
--$1 etape
--$2 types
--$3 seuils
--$4 sous parcours
BEGIN
	
END;$_$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_set_etape_parcours_oriente_configuration(integer, integer[], integer[], integer[]) OWNER TO pgsql;

--
-- TOC entry 1474 (class 1255 OID 2596341)
-- Dependencies: 2983 5
-- Name: af_set_etape_ressource(character varying, integer, integer, integer); Type: FUNCTION; Schema: contraintes; Owner: pgsql
--

CREATE FUNCTION af_set_etape_ressource(character varying, integer, integer, integer) RETURNS integer
    AS $_$DECLARE
--$1 libelle
--$2 fichier ressource
--$3 espace
--$4 section
res int4;
new_id oid;
BEGIN
	-- insertion dans etape
	INSERT INTO contraintes.etape(libelle, type) VALUES ($1, 7);
	GET DIAGNOSTICS new_id = RESULT_OID;
	SELECT INTO res id FROM contraintes.etape WHERE oid=new_id;

	-- insertion dans etape_ressource
	INSERT INTO contraintes.etape_ressource(id,fichier,espace,section) VALUES (res,$2,$3,$4);

	RETURN res;
END;
$_$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_set_etape_ressource(character varying, integer, integer, integer) OWNER TO pgsql;

--
-- TOC entry 1898 (class 1255 OID 2596342)
-- Dependencies: 2983 5
-- Name: af_set_evaluation(character varying, integer); Type: FUNCTION; Schema: contraintes; Owner: postgres
--

CREATE FUNCTION af_set_evaluation(character varying, integer) RETURNS integer
    AS $_$DECLARE
val_libelle ALIAS FOR $1;
val_type ALIAS FOR $2;
new_id int4;
res int4;
BEGIN
	
	insert into contraintes.evaluation(libelle, "type") VALUES(val_libelle, val_type);

	--RECUPERE L'IDENTIFIANT DE LA NOUVELLE CATEGORIE
	GET DIAGNOSTICS new_id = RESULT_OID;

	select into res id from contraintes.evaluation where oid=new_id;
	return res;
END$_$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_set_evaluation(character varying, integer) OWNER TO postgres;

--
-- TOC entry 8478 (class 0 OID 0)
-- Dependencies: 1898
-- Name: FUNCTION af_set_evaluation(character varying, integer); Type: COMMENT; Schema: contraintes; Owner: postgres
--

COMMENT ON FUNCTION af_set_evaluation(character varying, integer) IS 'FONCTION PRIVEE: creer une nouvelle evaluation. retourne le numero de la nouvelle evaluation.';


--
-- TOC entry 1475 (class 1255 OID 2596343)
-- Dependencies: 2983 5
-- Name: af_set_exotlc_corrections(integer, integer[]); Type: FUNCTION; Schema: contraintes; Owner: pgsql
--

CREATE FUNCTION af_set_exotlc_corrections(integer, integer[]) RETURNS integer
    AS $_$-- $1 : numero exotlc
-- $2 : tableau de fichiers correction
declare
i int4;
nb int4 :=0;
begin
    for i in array_lower($2,1) .. array_upper($2,1)
loop
    insert into contraintes.exotlc_corrections(exotlc,correction) 
    values($1,$2[i]);
    if found then
	nb:=nb+1;
    end if;
end loop;
return nb;
end;$_$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_set_exotlc_corrections(integer, integer[]) OWNER TO pgsql;

--
-- TOC entry 8480 (class 0 OID 0)
-- Dependencies: 1475
-- Name: FUNCTION af_set_exotlc_corrections(integer, integer[]); Type: COMMENT; Schema: contraintes; Owner: pgsql
--

COMMENT ON FUNCTION af_set_exotlc_corrections(integer, integer[]) IS 'enregistre les fichiers correzction pour un exotlc';


--
-- TOC entry 1476 (class 1255 OID 2596344)
-- Dependencies: 2983 5
-- Name: af_set_exotlc_fichiers(integer, integer[]); Type: FUNCTION; Schema: contraintes; Owner: pgsql
--

CREATE FUNCTION af_set_exotlc_fichiers(integer, integer[]) RETURNS integer
    AS $_$-- $1 : numero exotlc
-- $2 : tableau de fichiers
declare
i int4;
nb int4 :=0;
begin
    for i in array_lower($2,1) .. array_upper($2,1)
loop
    insert into contraintes.exotlc_fichiers(exotlc,fichier) 
    values($1,$2[i]);
    if found then
	nb:=nb+1;
    end if;
end loop;
return nb;
end;$_$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_set_exotlc_fichiers(integer, integer[]) OWNER TO pgsql;

--
-- TOC entry 8482 (class 0 OID 0)
-- Dependencies: 1476
-- Name: FUNCTION af_set_exotlc_fichiers(integer, integer[]); Type: COMMENT; Schema: contraintes; Owner: pgsql
--

COMMENT ON FUNCTION af_set_exotlc_fichiers(integer, integer[]) IS 'enregistre les fichiers pour un exotlc';


--
-- TOC entry 1477 (class 1255 OID 2596345)
-- Dependencies: 2983 5
-- Name: af_set_exotlc_fichiers_all(integer, integer[], integer[]); Type: FUNCTION; Schema: contraintes; Owner: pgsql
--

CREATE FUNCTION af_set_exotlc_fichiers_all(integer, integer[], integer[]) RETURNS boolean
    AS $_$-- $1 : numero exotlc
-- $2 : tableau des fichiers exotlc
-- $3 : tableau des fichiers correction
declare
nb_fichier_exotlc int4;
nb_fichier_correction int4;
begin
    select into nb_fichier_exotlc * from contraintes.af_set_exotlc_fichiers($1,$2);
    select into nb_fichier_correction * from contraintes.af_set_exotlc_corrections($1,$3);
    return (nb_fichier_exotlc>0 and nb_fichier_correction>0);
end;$_$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_set_exotlc_fichiers_all(integer, integer[], integer[]) OWNER TO pgsql;

--
-- TOC entry 8484 (class 0 OID 0)
-- Dependencies: 1477
-- Name: FUNCTION af_set_exotlc_fichiers_all(integer, integer[], integer[]); Type: COMMENT; Schema: contraintes; Owner: pgsql
--

COMMENT ON FUNCTION af_set_exotlc_fichiers_all(integer, integer[], integer[]) IS 'enregistre les fichiers exotlc et fichiers correction pour un exotlc';


--
-- TOC entry 1478 (class 1255 OID 2596346)
-- Dependencies: 2983 5
-- Name: af_set_exotlc_mail(character varying, character varying, character varying, character varying, character varying, integer); Type: FUNCTION; Schema: contraintes; Owner: pgsql
--

CREATE FUNCTION af_set_exotlc_mail(character varying, character varying, character varying, character varying, character varying, integer) RETURNS integer
    AS $_$-- $1 : titre exo
-- $2 : commentaire
-- $3 : texte
-- $4 : enonce
-- $5 : remarque
-- $6 : numero formateur
declare
new_id int4;
res int4;
begin
    INSERT INTO contraintes.etape(libelle, type) VALUES ($1, 5);
    GET DIAGNOSTICS new_id = RESULT_OID;
    SELECT INTO res id FROM contraintes.etape WHERE oid=new_id;
    -- insertion ds exotlc
    insert into contraintes.exotlc(id,commentaire,texte,enonce,remarque,type) 
    values(res,$2,$3,$4,$5,2);
    -- insertion fichier rendu
    insert into contraintes.exotlc_mail(id,formateur) values(res,$6);
    return res;
end;$_$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_set_exotlc_mail(character varying, character varying, character varying, character varying, character varying, integer) OWNER TO pgsql;

--
-- TOC entry 8486 (class 0 OID 0)
-- Dependencies: 1478
-- Name: FUNCTION af_set_exotlc_mail(character varying, character varying, character varying, character varying, character varying, integer); Type: COMMENT; Schema: contraintes; Owner: pgsql
--

COMMENT ON FUNCTION af_set_exotlc_mail(character varying, character varying, character varying, character varying, character varying, integer) IS 'enregistre un exotlc mail';


--
-- TOC entry 1479 (class 1255 OID 2596347)
-- Dependencies: 2983 5
-- Name: af_set_exotlc_plateforme(character varying, character varying, character varying, character varying, character varying, character varying, boolean); Type: FUNCTION; Schema: contraintes; Owner: pgsql
--

CREATE FUNCTION af_set_exotlc_plateforme(character varying, character varying, character varying, character varying, character varying, character varying, boolean) RETURNS integer
    AS $_$-- $1 : titre exo
-- $2 : commentaire
-- $3 : texte
-- $4 : ennoce
-- $5 : remarque
-- $6 : nom fichier rendu
-- $7 : autocorrection
declare
new_id int4;
res int4;
begin
    INSERT INTO contraintes.etape(libelle, type) VALUES ($1, 5);
    GET DIAGNOSTICS new_id = RESULT_OID;
    SELECT INTO res id FROM contraintes.etape WHERE oid=new_id;
    -- insertion ds exotlc
    insert into contraintes.exotlc(id,commentaire,texte,enonce,remarque,type) 
    values(res,$2,$3,$4,$5,1);
    -- insertion fichier rendu
    insert into contraintes.exotlc_plate_forme(id,fichier_rendu,autocorrection) values(res,$6,$7);
    return res;
end;$_$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_set_exotlc_plateforme(character varying, character varying, character varying, character varying, character varying, character varying, boolean) OWNER TO pgsql;

--
-- TOC entry 8488 (class 0 OID 0)
-- Dependencies: 1479
-- Name: FUNCTION af_set_exotlc_plateforme(character varying, character varying, character varying, character varying, character varying, character varying, boolean); Type: COMMENT; Schema: contraintes; Owner: pgsql
--

COMMENT ON FUNCTION af_set_exotlc_plateforme(character varying, character varying, character varying, character varying, character varying, character varying, boolean) IS 'enregistre un exotlc plateforme';


--
-- TOC entry 1480 (class 1255 OID 2596348)
-- Dependencies: 2983 5
-- Name: af_set_fichier(character varying, integer, boolean); Type: FUNCTION; Schema: contraintes; Owner: pgsql
--

CREATE FUNCTION af_set_fichier(character varying, integer, boolean) RETURNS integer
    AS $_$DECLARE
--$1 libelle du fichier
--$2 type
--$3 connecte
new_oid oid;
new_id integer;
BEGIN
	--enregistre le fichier dans la table principale
	INSERT INTO contraintes.fichier (libelle,type,connecte)
	VALUES ($1, $2, $3);

	--recupere l'oid et le numero du nouvel enregistrement
	GET DIAGNOSTICS new_oid = RESULT_OID;
	SELECT INTO new_id id FROM contraintes.fichier WHERE oid=new_oid;

	RETURN new_id;
END;$_$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_set_fichier(character varying, integer, boolean) OWNER TO pgsql;

--
-- TOC entry 1481 (class 1255 OID 2596349)
-- Dependencies: 2983 5
-- Name: af_set_fichier_icone(character varying); Type: FUNCTION; Schema: contraintes; Owner: pgsql
--

CREATE FUNCTION af_set_fichier_icone(character varying) RETURNS integer
    AS $_$-- $1 : libelle fichier
declare
new_id integer;
begin
    -- enregistre dans la table principale (fichier)
    select into new_id * from contraintes.af_set_fichier($1,6,false);
    -- enregistre dans la table fichier_icone
    insert into contraintes.fichier_icone(id) values(new_id);
    return new_id;
end;$_$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_set_fichier_icone(character varying) OWNER TO pgsql;

--
-- TOC entry 8491 (class 0 OID 0)
-- Dependencies: 1481
-- Name: FUNCTION af_set_fichier_icone(character varying); Type: COMMENT; Schema: contraintes; Owner: pgsql
--

COMMENT ON FUNCTION af_set_fichier_icone(character varying) IS 'Enregistre un fichier icone';


--
-- TOC entry 1482 (class 1255 OID 2596350)
-- Dependencies: 2983 5
-- Name: af_set_fichier_metadata(integer, text, integer); Type: FUNCTION; Schema: contraintes; Owner: pgsql
--

CREATE FUNCTION af_set_fichier_metadata(integer, text, integer) RETURNS boolean
    AS $_$DECLARE
--$1 fichier
--$2 mots clés
--$3 individu proprietaite
ams varchar;
BEGIN
	PERFORM id FROM contraintes.fichier_metadata
	WHERE id=$1;

	IF FOUND THEN
		SELECT INTO ams contraintes.fw_get_ams_libelle('fichier_metadata','mots_cles','id='||$1,$2);

		UPDATE contraintes.fichier_metadata SET mots_cles=ams, individu=$3
		--WHERE individu=$1 ;
		where id=$1;
	ELSE
		INSERT INTO contraintes.fichier_metadata (id, mots_cles, individu) values($1,$2,$3);
	END IF;

	RETURN FOUND;
END;$_$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_set_fichier_metadata(integer, text, integer) OWNER TO pgsql;

--
-- TOC entry 36 (class 1255 OID 2596351)
-- Dependencies: 2983 5
-- Name: af_set_fichier_photo(character varying); Type: FUNCTION; Schema: contraintes; Owner: pgsql
--

CREATE FUNCTION af_set_fichier_photo(character varying) RETURNS integer
    AS $_$DECLARE
--$1 nom fichier photo
fic_id integer;
BEGIN
	select INTO fic_id * from contraintes.af_set_fichier($1,4,TRUE);
	INSERT INTO contraintes.fichier_photo (id) VALUES (fic_id);

	RETURN fic_id;
END;$_$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_set_fichier_photo(character varying) OWNER TO pgsql;

--
-- TOC entry 1483 (class 1255 OID 2596352)
-- Dependencies: 2983 5
-- Name: af_set_fichier_scenario_dynamique(character varying, integer); Type: FUNCTION; Schema: contraintes; Owner: postgres
--

CREATE FUNCTION af_set_fichier_scenario_dynamique(character varying, integer) RETURNS integer
    AS $_$DECLARE
--$1 libelle
--$2 style
new_oid OID ;
new_id integer;
BEGIN
	INSERT INTO contraintes.fichier (libelle,type)
	VALUES ($1,15);

	GET DIAGNOSTICS new_oid = RESULT_OID;
	SELECT INTO new_id id FROM contraintes.fichier WHERE oid=new_oid;

	--INSERT INTO contraintes.fichier_scenario (id)
	---VALUES (new_id);
	
	INSERT INTO contraintes.fichier_scenario_dynamique (id,style)
	VALUES (new_id,$2);
	RETURN new_id;
END;$_$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_set_fichier_scenario_dynamique(character varying, integer) OWNER TO postgres;

--
-- TOC entry 1484 (class 1255 OID 2596353)
-- Dependencies: 2983 5
-- Name: af_set_fichier_scenario_dynamique_bloc(integer, integer, integer, text[], text); Type: FUNCTION; Schema: contraintes; Owner: pgsql
--

CREATE FUNCTION af_set_fichier_scenario_dynamique_bloc(integer, integer, integer, text[], text) RETURNS boolean
    AS $_$DECLARE
--$1 scenario
--$2 bloc
--$3 ordre
--$4 bloc_vars_keys
--$5 bloc_vars_values
ams varchar;
BEGIN

	PERFORM * FROM contraintes.fichier_scenario_dynamique_blocs
	WHERE id=$1
	AND ordre=$3;

	IF NOT FOUND THEN
		INSERT INTO contraintes.fichier_scenario_dynamique_blocs
		(id, fichier_bloc_scenario, ordre,bloc_vars_keys,bloc_vars_values)
		VALUES($1,$2,$3,$4,$5);
	ELSE
		SELECT INTO ams contraintes.fw_get_ams_libelle('fichier_scenario_dynamique_blocs','bloc_vars_values','id='||$1||' and ordre='||$3,$5);
		raise notice 'ams=%',ams;
		UPDATE contraintes.fichier_scenario_dynamique_blocs
		SET fichier_bloc_scenario=$2, bloc_vars_keys=$4,bloc_vars_values=ams
		WHERE id=$1
		AND ordre=$3;
	END IF;

	RETURN FOUND;
END;
$_$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_set_fichier_scenario_dynamique_bloc(integer, integer, integer, text[], text) OWNER TO pgsql;

--
-- TOC entry 1485 (class 1255 OID 2596354)
-- Dependencies: 2983 5
-- Name: af_set_filiere(character varying, integer); Type: FUNCTION; Schema: contraintes; Owner: pgsql
--

CREATE FUNCTION af_set_filiere(character varying, integer) RETURNS integer
    AS $_$DECLARE
--$1 libelle
--$2 pere
new_id int4;
new_oid int4;
BEGIN
	INSERT INTO contraintes.filiere (libelle, pere) VALUES ($1,$2);
	GET DIAGNOSTICS new_oid = RESULT_OID;
	SELECT INTO new_id id FROM contraintes.filiere WHERE oid=new_oid;
	RETURN new_id;
END;$_$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_set_filiere(character varying, integer) OWNER TO pgsql;

--
-- TOC entry 1486 (class 1255 OID 2596355)
-- Dependencies: 2983 5
-- Name: af_set_formation(character varying, date, date, integer, integer, integer, integer, integer[]); Type: FUNCTION; Schema: contraintes; Owner: pgsql
--

CREATE FUNCTION af_set_formation(character varying, date, date, integer, integer, integer, integer, integer[]) RETURNS integer
    AS $_$DECLARE
--$1 libelle de la formation
--$2 date de debut
--$3 date de fin
--$4 classe virtuelle
--$5 formateur
--$6 parcours
--$7 langue par defaut
--$8 langues disponibles en front office
new_id int4;
res int4;
i int4;
ok1 bool;
ok2 bool;
fusion bool:=false;
BEGIN
	--CREATION DE LA FORMATION
	INSERT INTO contraintes.formation(libelle, parcours, date_debut, date_fin, langue)
	VALUES($1, $6, $2, $3, $7);
	--recupere l'identifiant
	GET DIAGNOSTICS new_id = RESULT_OID;
	SELECT INTO res id FROM contraintes.formation WHERE oid=new_id;
	
	--ASSOCIATION DU GROUPE ET DU FORMATEUR
	SELECT INTO ok1 * FROM contraintes.af_set_formation_participants(res, $5, $4);
	IF NOT ok1 THEN
		RAISE EXCEPTION 'Les participants n''ont pu etre ajouté lors de la création de la formation.';
	END IF;

	--LANGUES DE LA FORMATION EN FRONT OFFICE
	if array_upper($8,1)>0 then
	FOR i IN array_lower($8, 1) .. array_upper($8, 1) 
	LOOP
		SELECT INTO ok2 *  FROM contraintes.af_set_formation_langue(res,$8[i]);
		IF NOT ok2 THEN
			RAISE EXCEPTION 'Les langues n''ont pu etre ajouté lors de la création de la formation.';
		END IF;
	END LOOP;
	end if; 

	return res;
END;$_$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_set_formation(character varying, date, date, integer, integer, integer, integer, integer[]) OWNER TO pgsql;

--
-- TOC entry 1899 (class 1255 OID 2596356)
-- Dependencies: 2983 5
-- Name: af_set_formation_droit(integer, integer); Type: FUNCTION; Schema: contraintes; Owner: pgsql
--

CREATE FUNCTION af_set_formation_droit(integer, integer) RETURNS boolean
    AS $_$-- $1 : numero formation
-- $2 : numero droit
begin
    insert into contraintes.formateur_droits(formation,droit) values($1,$2);
    return found;	
end;$_$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_set_formation_droit(integer, integer) OWNER TO pgsql;

--
-- TOC entry 8499 (class 0 OID 0)
-- Dependencies: 1899
-- Name: FUNCTION af_set_formation_droit(integer, integer); Type: COMMENT; Schema: contraintes; Owner: pgsql
--

COMMENT ON FUNCTION af_set_formation_droit(integer, integer) IS 'ajoute un droit à une formation';


--
-- TOC entry 1900 (class 1255 OID 2596357)
-- Dependencies: 2983 5
-- Name: af_set_formation_evenement(integer, character varying, timestamp without time zone, time without time zone, integer, integer, integer, integer); Type: FUNCTION; Schema: contraintes; Owner: pgsql
--

CREATE FUNCTION af_set_formation_evenement(integer, character varying, timestamp without time zone, time without time zone, integer, integer, integer, integer) RETURNS boolean
    AS $_$-- $1 : formation
-- $2 : libelle
-- $3 : date
-- $4 : duree
-- $5 : modalite
-- $6 : intervention
-- $7 : intervenant
-- $8 : salle
begin
    insert into contraintes.evenement(formation,libelle,date,duree,modalite,intervention,intervenant,salle) 
    values($1,$2,$3,$4,$5,$6,$7,$8);
    if $5=3 then
	insert into contraintes.evenement_presentiel(formation,date) 
	values($1,$3);
    end if;
    return found;
end;$_$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_set_formation_evenement(integer, character varying, timestamp without time zone, time without time zone, integer, integer, integer, integer) OWNER TO pgsql;

--
-- TOC entry 8501 (class 0 OID 0)
-- Dependencies: 1900
-- Name: FUNCTION af_set_formation_evenement(integer, character varying, timestamp without time zone, time without time zone, integer, integer, integer, integer); Type: COMMENT; Schema: contraintes; Owner: pgsql
--

COMMENT ON FUNCTION af_set_formation_evenement(integer, character varying, timestamp without time zone, time without time zone, integer, integer, integer, integer) IS 'enregistre un evenement de formation';


--
-- TOC entry 1487 (class 1255 OID 2596358)
-- Dependencies: 2983 5
-- Name: af_set_formation_forum(integer, integer); Type: FUNCTION; Schema: contraintes; Owner: pgsql
--

CREATE FUNCTION af_set_formation_forum(integer, integer) RETURNS boolean
    AS $_$-- $1 : formation
-- $2 : forum
begin
    insert into contraintes.formation_forums(formation,forum) 
    values($1,$2);
    return found;
end;$_$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_set_formation_forum(integer, integer) OWNER TO pgsql;

--
-- TOC entry 8503 (class 0 OID 0)
-- Dependencies: 1487
-- Name: FUNCTION af_set_formation_forum(integer, integer); Type: COMMENT; Schema: contraintes; Owner: pgsql
--

COMMENT ON FUNCTION af_set_formation_forum(integer, integer) IS 'associer un forum à une formation';


--
-- TOC entry 1488 (class 1255 OID 2596359)
-- Dependencies: 2983 5
-- Name: af_set_formation_langue(integer, integer); Type: FUNCTION; Schema: contraintes; Owner: pgsql
--

CREATE FUNCTION af_set_formation_langue(integer, integer) RETURNS boolean
    AS $_$DECLARE
--$1 formation
--$2 langue
BEGIN
	INSERT INTO contraintes.formation_langues
	(formation, langue) VALUES
	($1, $2);

	RETURN FOUND;
END;$_$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_set_formation_langue(integer, integer) OWNER TO pgsql;

--
-- TOC entry 1489 (class 1255 OID 2596360)
-- Dependencies: 2983 5
-- Name: af_set_formation_participants(integer, integer, integer); Type: FUNCTION; Schema: contraintes; Owner: pgsql
--

CREATE FUNCTION af_set_formation_participants(integer, integer, integer) RETURNS boolean
    AS $_$DECLARE
--$1 formation
--$2 formateur
--$3 classe
BEGIN
	INSERT INTO contraintes.formation_participants
	(formation, formateur, classe) VALUES
	($1, $2, $3);

	RETURN FOUND;
END;$_$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_set_formation_participants(integer, integer, integer) OWNER TO pgsql;

--
-- TOC entry 1490 (class 1255 OID 2596361)
-- Dependencies: 2983 5
-- Name: af_set_formation_ressource(integer, integer, timestamp without time zone, timestamp without time zone, interval, integer, integer); Type: FUNCTION; Schema: contraintes; Owner: pgsql
--

CREATE FUNCTION af_set_formation_ressource(integer, integer, timestamp without time zone, timestamp without time zone, interval, integer, integer) RETURNS boolean
    AS $_$-- $1 : formation
-- $2 : fichier_ressource
-- $3 : debut
-- $4 : fin
-- $5 : duree
-- $6 : espace
-- $7 : section
declare

begin
    -- test existence (formation,ressource,espace,section)
    perform * from contraintes.formation_ressources where formation=$1 and fichier_ressource=$2 and espace=$6 and section=$7;
    if found then
	update contraintes.formation_ressources 
	set debut_disponibilite=$3,fin_disponibilite=$4,duree_nouveaute=$5 
	where formation=$1 and fichier_ressource=$2 and espace=$6 and section=$7;
    else
	insert into contraintes.formation_ressources(formation,fichier_ressource,debut_disponibilite,fin_disponibilite,duree_nouveaute,espace,section) 
	values($1,$2,$3,$4,$5,$6,$7);
    end if;
    return found;
end;$_$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_set_formation_ressource(integer, integer, timestamp without time zone, timestamp without time zone, interval, integer, integer) OWNER TO pgsql;

--
-- TOC entry 8507 (class 0 OID 0)
-- Dependencies: 1490
-- Name: FUNCTION af_set_formation_ressource(integer, integer, timestamp without time zone, timestamp without time zone, interval, integer, integer); Type: COMMENT; Schema: contraintes; Owner: pgsql
--

COMMENT ON FUNCTION af_set_formation_ressource(integer, integer, timestamp without time zone, timestamp without time zone, interval, integer, integer) IS 'associe une ressource à une formation';


--
-- TOC entry 1491 (class 1255 OID 2596362)
-- Dependencies: 2983 5
-- Name: af_set_formation_session(integer, time without time zone, time without time zone); Type: FUNCTION; Schema: contraintes; Owner: pgsql
--

CREATE FUNCTION af_set_formation_session(integer, time without time zone, time without time zone) RETURNS boolean
    AS $_$-- $1 : formation
-- $2 : durée d'inactivité
-- $3 : durée session
begin
    delete from contraintes.formation_session where formation=$1;	
    insert into contraintes.formation_session(formation,inactivite,duree_session) 
    values($1,$2,$3);
    return found;
end;$_$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_set_formation_session(integer, time without time zone, time without time zone) OWNER TO pgsql;

--
-- TOC entry 8509 (class 0 OID 0)
-- Dependencies: 1491
-- Name: FUNCTION af_set_formation_session(integer, time without time zone, time without time zone); Type: COMMENT; Schema: contraintes; Owner: pgsql
--

COMMENT ON FUNCTION af_set_formation_session(integer, time without time zone, time without time zone) IS 'enregistre les temps d''inactivité et de session pour une formation';


--
-- TOC entry 1492 (class 1255 OID 2596363)
-- Dependencies: 2983 5
-- Name: af_set_forum(character varying, character varying, boolean, character varying, integer, integer, integer); Type: FUNCTION; Schema: contraintes; Owner: pgsql
--

CREATE FUNCTION af_set_forum(character varying, character varying, boolean, character varying, integer, integer, integer) RETURNS integer
    AS $_$-- $1 : libelle forum
-- $2 : description
-- $3 : upload
-- $4 : theme
-- $5 : arbo par page
-- $6 : msg par page
-- $7 : configuration
declare
new_id int4;
res int4;
begin
    insert into contraintes.forum (libelle,description ,  moderation ,  moderateur_pwd ,fils,messages ,upload ,theme) 
    values($1,$2,false,'',$5,$6,$3,$4);
    GET DIAGNOSTICS new_id = RESULT_OID;
    SELECT INTO res id FROM contraintes.forum WHERE oid=new_id;
    -- environnement (configuration)
    insert into contraintes.forum_environnements(forum,environnement) values(res,$7);
    return res;
end;$_$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_set_forum(character varying, character varying, boolean, character varying, integer, integer, integer) OWNER TO pgsql;

--
-- TOC entry 8511 (class 0 OID 0)
-- Dependencies: 1492
-- Name: FUNCTION af_set_forum(character varying, character varying, boolean, character varying, integer, integer, integer); Type: COMMENT; Schema: contraintes; Owner: pgsql
--

COMMENT ON FUNCTION af_set_forum(character varying, character varying, boolean, character varying, integer, integer, integer) IS 'enregistre un forum';


--
-- TOC entry 1493 (class 1255 OID 2596364)
-- Dependencies: 2983 5
-- Name: af_set_ftb(text, boolean, boolean); Type: FUNCTION; Schema: contraintes; Owner: pgsql
--

CREATE FUNCTION af_set_ftb(text, boolean, boolean) RETURNS integer
    AS $_$declare
new_id int4;
res int4;
begin
	select into new_id * from contraintes.af_set_evaluation($1,3);
	insert into contraintes.ftb(id,text,voir_mots,interpretation_html) values(new_id,$1,$2,$3);
	
	return new_id;
end$_$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_set_ftb(text, boolean, boolean) OWNER TO pgsql;

--
-- TOC entry 8513 (class 0 OID 0)
-- Dependencies: 1493
-- Name: FUNCTION af_set_ftb(text, boolean, boolean); Type: COMMENT; Schema: contraintes; Owner: pgsql
--

COMMENT ON FUNCTION af_set_ftb(text, boolean, boolean) IS 'enregistre un "remplir les blancs"';


--
-- TOC entry 37 (class 1255 OID 2596365)
-- Dependencies: 2983 5
-- Name: af_set_glossaire(character varying); Type: FUNCTION; Schema: contraintes; Owner: postgres
--

CREATE FUNCTION af_set_glossaire(character varying) RETURNS integer
    AS $_$-- $1 : libelle
declare
new_id integer;
res integer;
begin
    insert into contraintes.glossaire(libelle) values($1);
    -- recup id
    GET DIAGNOSTICS new_id = RESULT_OID;
    SELECT INTO res id FROM contraintes.glossaire WHERE oid=new_id;
    return res;

end;$_$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_set_glossaire(character varying) OWNER TO postgres;

--
-- TOC entry 8515 (class 0 OID 0)
-- Dependencies: 37
-- Name: FUNCTION af_set_glossaire(character varying); Type: COMMENT; Schema: contraintes; Owner: postgres
--

COMMENT ON FUNCTION af_set_glossaire(character varying) IS 'enregistre un glossaire';


--
-- TOC entry 38 (class 1255 OID 2596366)
-- Dependencies: 2983 5
-- Name: af_set_glossaire_fichier(integer, integer); Type: FUNCTION; Schema: contraintes; Owner: pgsql
--

CREATE FUNCTION af_set_glossaire_fichier(integer, integer) RETURNS boolean
    AS $_$-- $1 : glossaire
-- $2 : fichier
begin
    insert into contraintes.glossaire_fichiers(id,fichier) values($1,$2);
    return found;
end;$_$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_set_glossaire_fichier(integer, integer) OWNER TO pgsql;

--
-- TOC entry 8517 (class 0 OID 0)
-- Dependencies: 38
-- Name: FUNCTION af_set_glossaire_fichier(integer, integer); Type: COMMENT; Schema: contraintes; Owner: pgsql
--

COMMENT ON FUNCTION af_set_glossaire_fichier(integer, integer) IS 'associe un glossaire à un fichier';


--
-- TOC entry 1494 (class 1255 OID 2596367)
-- Dependencies: 2983 5
-- Name: af_set_grille(character varying); Type: FUNCTION; Schema: contraintes; Owner: pgsql
--

CREATE FUNCTION af_set_grille(character varying) RETURNS integer
    AS $_$-- $1 : libelle grille
declare
new_id int4;
res int4;
begin
    insert into contraintes.grille(libelle) values($1);
     --RECUPERE L'IDENTIFIANT De la nouvelle capacite
    GET DIAGNOSTICS new_id = RESULT_OID;
    SELECT INTO res id FROM contraintes.grille WHERE oid=new_id;
    return res;
end;$_$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_set_grille(character varying) OWNER TO pgsql;

--
-- TOC entry 8519 (class 0 OID 0)
-- Dependencies: 1494
-- Name: FUNCTION af_set_grille(character varying); Type: COMMENT; Schema: contraintes; Owner: pgsql
--

COMMENT ON FUNCTION af_set_grille(character varying) IS 'enregistre une grille';


--
-- TOC entry 1495 (class 1255 OID 2596368)
-- Dependencies: 2983 5
-- Name: af_set_grille_capacite_titre(integer, integer); Type: FUNCTION; Schema: contraintes; Owner: pgsql
--

CREATE FUNCTION af_set_grille_capacite_titre(integer, integer) RETURNS boolean
    AS $_$-- $1 : numero grille
-- $2 : numero capacite_titre
begin
    insert into contraintes.grille_capacites_titres(grille,capacite_titre) values($1,$2);
    return found;
end;$_$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_set_grille_capacite_titre(integer, integer) OWNER TO pgsql;

--
-- TOC entry 8521 (class 0 OID 0)
-- Dependencies: 1495
-- Name: FUNCTION af_set_grille_capacite_titre(integer, integer); Type: COMMENT; Schema: contraintes; Owner: pgsql
--

COMMENT ON FUNCTION af_set_grille_capacite_titre(integer, integer) IS 'enregistre le couple grille / capacite_titre';


--
-- TOC entry 1496 (class 1255 OID 2596369)
-- Dependencies: 2983 5
-- Name: af_set_individu(character varying, character varying, character varying, character varying, character varying, character varying, character varying, character varying, character varying, character varying, character varying, integer, integer, integer, integer[]); Type: FUNCTION; Schema: contraintes; Owner: pgsql
--

CREATE FUNCTION af_set_individu(character varying, character varying, character varying, character varying, character varying, character varying, character varying, character varying, character varying, character varying, character varying, integer, integer, integer, integer[]) RETURNS integer
    AS $_$declare
new_id int4;
res int4;
i int4;
begin
    insert into 
    contraintes.fw_individu(identifiant_md5,login,password,nom,prenom,adresse,code,ville,email,tel_fixe,tel_port,langue,organisme,photo) 
    values($1,$2,$3,$4,$5,$6,$7,$8,$9,$10,$11,$12,$13,$14);
    -- recup id
    GET DIAGNOSTICS new_id=RESULT_OID;
    select into res id from contraintes.fw_individu 
    where oid=new_id;
    -- insertion type (formateur,utilisateur ...)
    if $15 is not null then
    for i in array_lower($15,1)..array_upper($15,1)
	loop
	perform * from contraintes.af_set_individu_type(res,$15[i]);
	end loop;
    end if;
    return res;
end;$_$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_set_individu(character varying, character varying, character varying, character varying, character varying, character varying, character varying, character varying, character varying, character varying, character varying, integer, integer, integer, integer[]) OWNER TO pgsql;

--
-- TOC entry 8523 (class 0 OID 0)
-- Dependencies: 1496
-- Name: FUNCTION af_set_individu(character varying, character varying, character varying, character varying, character varying, character varying, character varying, character varying, character varying, character varying, character varying, integer, integer, integer, integer[]); Type: COMMENT; Schema: contraintes; Owner: pgsql
--

COMMENT ON FUNCTION af_set_individu(character varying, character varying, character varying, character varying, character varying, character varying, character varying, character varying, character varying, character varying, character varying, integer, integer, integer, integer[]) IS 'enregistre un individu';


--
-- TOC entry 1497 (class 1255 OID 2596370)
-- Dependencies: 2983 5
-- Name: af_set_individu_connexion(integer, timestamp without time zone, timestamp without time zone, character varying); Type: FUNCTION; Schema: contraintes; Owner: pgsql
--

CREATE FUNCTION af_set_individu_connexion(integer, timestamp without time zone, timestamp without time zone, character varying) RETURNS boolean
    AS $_$-- $1 : individu
-- $2 : date connexion (int4)
-- $3 : date deconnexion (int4)
-- $4 : ip
begin
    insert into contraintes.connexion(individu,connexion,deconnexion,ip) values($1,$2,$2,$4);
    return found;
end;$_$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_set_individu_connexion(integer, timestamp without time zone, timestamp without time zone, character varying) OWNER TO pgsql;

--
-- TOC entry 8525 (class 0 OID 0)
-- Dependencies: 1497
-- Name: FUNCTION af_set_individu_connexion(integer, timestamp without time zone, timestamp without time zone, character varying); Type: COMMENT; Schema: contraintes; Owner: pgsql
--

COMMENT ON FUNCTION af_set_individu_connexion(integer, timestamp without time zone, timestamp without time zone, character varying) IS 'enregistre les dates  connexion et deconnexion pour un individu';


--
-- TOC entry 1498 (class 1255 OID 2596371)
-- Dependencies: 2983 5
-- Name: af_set_individu_droit_classe(integer, integer, integer); Type: FUNCTION; Schema: contraintes; Owner: pgsql
--

CREATE FUNCTION af_set_individu_droit_classe(integer, integer, integer) RETURNS boolean
    AS $_$-- $1 : numero individu
-- $2 : numero classe
-- $3 : numero droit
begin
    insert into contraintes.individu_droits(individu,classe,droit) values ($1,$2,$3);
    return found;
end;$_$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_set_individu_droit_classe(integer, integer, integer) OWNER TO pgsql;

--
-- TOC entry 8527 (class 0 OID 0)
-- Dependencies: 1498
-- Name: FUNCTION af_set_individu_droit_classe(integer, integer, integer); Type: COMMENT; Schema: contraintes; Owner: pgsql
--

COMMENT ON FUNCTION af_set_individu_droit_classe(integer, integer, integer) IS 'enregistre un droit pour un individu et une classe';


--
-- TOC entry 1499 (class 1255 OID 2596372)
-- Dependencies: 2983 5
-- Name: af_set_individu_droits_classe(integer, integer, integer[]); Type: FUNCTION; Schema: contraintes; Owner: pgsql
--

CREATE FUNCTION af_set_individu_droits_classe(integer, integer, integer[]) RETURNS boolean
    AS $_$-- $1 n° individu
-- $2 n° classe
-- $3 tableau de droits
declare
i int4;
begin
    for i in array_lower($3,1) .. array_upper($3,1)
loop
    insert into contraintes.individu_droits(individu,classe,droit) values ($1,$2,$3[i]);
end loop;
return true;
end;$_$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_set_individu_droits_classe(integer, integer, integer[]) OWNER TO pgsql;

--
-- TOC entry 8529 (class 0 OID 0)
-- Dependencies: 1499
-- Name: FUNCTION af_set_individu_droits_classe(integer, integer, integer[]); Type: COMMENT; Schema: contraintes; Owner: pgsql
--

COMMENT ON FUNCTION af_set_individu_droits_classe(integer, integer, integer[]) IS 'enregistre les droits pour un individu et une classe';


--
-- TOC entry 1500 (class 1255 OID 2596373)
-- Dependencies: 2983 5
-- Name: af_set_individu_session(integer, character varying, integer); Type: FUNCTION; Schema: contraintes; Owner: pgsql
--

CREATE FUNCTION af_set_individu_session(integer, character varying, integer) RETURNS boolean
    AS $_$-- $1 : individu
-- $2 : id session
-- $3 : formation
begin
    insert into contraintes.session (individu,session,formation) values($1,$2,$3);
    return found;
end;$_$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_set_individu_session(integer, character varying, integer) OWNER TO pgsql;

--
-- TOC entry 8531 (class 0 OID 0)
-- Dependencies: 1500
-- Name: FUNCTION af_set_individu_session(integer, character varying, integer); Type: COMMENT; Schema: contraintes; Owner: pgsql
--

COMMENT ON FUNCTION af_set_individu_session(integer, character varying, integer) IS 'enregistre la session pour un individu';


--
-- TOC entry 1501 (class 1255 OID 2596374)
-- Dependencies: 2983 5
-- Name: af_set_individu_type(integer, integer); Type: FUNCTION; Schema: contraintes; Owner: pgsql
--

CREATE FUNCTION af_set_individu_type(integer, integer) RETURNS boolean
    AS $_$begin
    insert into contraintes.fw_individu_types(individu,"type") values($1,$2);
    return found;
end;$_$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_set_individu_type(integer, integer) OWNER TO pgsql;

--
-- TOC entry 8533 (class 0 OID 0)
-- Dependencies: 1501
-- Name: FUNCTION af_set_individu_type(integer, integer); Type: COMMENT; Schema: contraintes; Owner: pgsql
--

COMMENT ON FUNCTION af_set_individu_type(integer, integer) IS 'enregistre un type (formateur,utilisateur,intervenant...) pour un individu';


--
-- TOC entry 1502 (class 1255 OID 2596375)
-- Dependencies: 2983 5
-- Name: af_set_inscription(character varying, character varying, character varying, character varying, character varying, character varying, character varying, character varying, character varying, character varying, character varying, integer, integer, integer); Type: FUNCTION; Schema: contraintes; Owner: pgsql
--

CREATE FUNCTION af_set_inscription(character varying, character varying, character varying, character varying, character varying, character varying, character varying, character varying, character varying, character varying, character varying, integer, integer, integer) RETURNS integer
    AS $_$declare
new_id int4;
res int4;
i int4;
begin
    insert into 
    contraintes.inscription(identifiant_md5,login,password,nom,prenom,adresse,code,ville,email,tel_fixe,tel_port,langue,organisme,photo) 
    values($1,$2,$3,$4,$5,$6,$7,$8,$9,$10,$11,$12,$13,$14);
    -- recup id
    GET DIAGNOSTICS new_id=RESULT_OID;
    select into res id from contraintes.inscription
    where oid=new_id;
    
    return res;
end;$_$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_set_inscription(character varying, character varying, character varying, character varying, character varying, character varying, character varying, character varying, character varying, character varying, character varying, integer, integer, integer) OWNER TO pgsql;

--
-- TOC entry 8535 (class 0 OID 0)
-- Dependencies: 1502
-- Name: FUNCTION af_set_inscription(character varying, character varying, character varying, character varying, character varying, character varying, character varying, character varying, character varying, character varying, character varying, integer, integer, integer); Type: COMMENT; Schema: contraintes; Owner: pgsql
--

COMMENT ON FUNCTION af_set_inscription(character varying, character varying, character varying, character varying, character varying, character varying, character varying, character varying, character varying, character varying, character varying, integer, integer, integer) IS 'enregistre un individu';


--
-- TOC entry 39 (class 1255 OID 2596376)
-- Dependencies: 2983 5
-- Name: af_set_inscriptions(integer, character varying, integer, integer); Type: FUNCTION; Schema: contraintes; Owner: pgsql
--

CREATE FUNCTION af_set_inscriptions(integer, character varying, integer, integer) RETURNS boolean
    AS $_$DECLARE
--$1 nombre d'inscriptions
--$2 base de libelle pour le login
--$3 langue
--$4 organisme
i integer:=1;
login_part varchar;
login varchar;
password varchar;
identifiant_md5 varchar;
nom varchar;
prenom varchar;
BEGIN
	
	FOR i IN 1 .. $1
	LOOP
		SELECT INTO login_part * FROM contraintes.get_random_string(2);
		login:=$2||'_'||login_part||i;
		SELECT INTO password * FROM  contraintes.get_random_string_2(8);
		identifiant_md5:=md5(password);
		nom:=login;
		prenom:=login;
		
		PERFORM contraintes.af_set_inscription(identifiant_md5,login,password,nom,prenom,NULL,NULL,NULL,NULL,NULL,NULL,$3,$4,NULL);

	END LOOP;

	--RAISE NOTICE '% == %',i,$1;
	RETURN i=$1;
END;$_$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_set_inscriptions(integer, character varying, integer, integer) OWNER TO pgsql;

--
-- TOC entry 1503 (class 1255 OID 2596377)
-- Dependencies: 2983 5
-- Name: af_set_intervention(character varying, character varying); Type: FUNCTION; Schema: contraintes; Owner: pgsql
--

CREATE FUNCTION af_set_intervention(character varying, character varying) RETURNS integer
    AS $_$-- $1 : libelle intervention
-- $2 : code couleur
declare
new_id int4;
res int4;
begin
    insert into contraintes.intervention(libelle,couleur) values($1,$2);
    --RECUPERE L'IDENTIFIANT DU NOUVEL ESPACE
    GET DIAGNOSTICS new_id = RESULT_OID;
    SELECT INTO res id FROM contraintes.intervention WHERE oid=new_id;
    RETURN res;
end;$_$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_set_intervention(character varying, character varying) OWNER TO pgsql;

--
-- TOC entry 8538 (class 0 OID 0)
-- Dependencies: 1503
-- Name: FUNCTION af_set_intervention(character varying, character varying); Type: COMMENT; Schema: contraintes; Owner: pgsql
--

COMMENT ON FUNCTION af_set_intervention(character varying, character varying) IS 'enregistre une intervention';


--
-- TOC entry 1505 (class 1255 OID 2596378)
-- Dependencies: 2983 5
-- Name: af_set_langue_message(integer, integer, character varying); Type: FUNCTION; Schema: contraintes; Owner: pgsql
--

CREATE FUNCTION af_set_langue_message(integer, integer, character varying) RETURNS integer
    AS $_$-- $1 : numero langue
-- $2 : type
-- $3 : libelle
declare
numero integer;
begin
    -- détermine le prochain id pour l'insertion
    select into numero max(id) from contraintes.langue_message where langue=$1 and type=$2;
    if numero is null then
	numero:=1;
    else
	numero:=numero+1;
    end if;
    -- insertion
    perform * from contraintes.af_set_langue_message(numero,$1,$2,$3);
    return numero; 
end;$_$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_set_langue_message(integer, integer, character varying) OWNER TO pgsql;

--
-- TOC entry 8540 (class 0 OID 0)
-- Dependencies: 1505
-- Name: FUNCTION af_set_langue_message(integer, integer, character varying); Type: COMMENT; Schema: contraintes; Owner: pgsql
--

COMMENT ON FUNCTION af_set_langue_message(integer, integer, character varying) IS 'insert un nouveau message de langue et
retourne son numero';


--
-- TOC entry 1504 (class 1255 OID 2596379)
-- Dependencies: 2983 5
-- Name: af_set_langue_message(integer, integer, integer, character varying); Type: FUNCTION; Schema: contraintes; Owner: pgsql
--

CREATE FUNCTION af_set_langue_message(integer, integer, integer, character varying) RETURNS boolean
    AS $_$-- $1 : numero message
-- $2 : numero langue
-- $3 : type message
-- $4 : libelle message
declare

begin
    insert into contraintes.langue_message(id,langue,type,libelle) 
    values($1,$2,$3,$4);
    return found;
end;$_$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_set_langue_message(integer, integer, integer, character varying) OWNER TO pgsql;

--
-- TOC entry 8542 (class 0 OID 0)
-- Dependencies: 1504
-- Name: FUNCTION af_set_langue_message(integer, integer, integer, character varying); Type: COMMENT; Schema: contraintes; Owner: pgsql
--

COMMENT ON FUNCTION af_set_langue_message(integer, integer, integer, character varying) IS 'enregistre un message de langue';


--
-- TOC entry 1506 (class 1255 OID 2596380)
-- Dependencies: 2983 5
-- Name: af_set_langues_messages_incomplets(); Type: FUNCTION; Schema: contraintes; Owner: pgsql
--

CREATE FUNCTION af_set_langues_messages_incomplets() RETURNS boolean
    AS $$declare
rec record;
rec2 record;
rec_langue record;
texte text;
begin
    texte:='A completer';
    -- boucle sur les messages de langue french (1)
    for rec in
	select * from contraintes.af_get_langue_messages(1) 
	as (id int4,libelle text,type int4,langue int4,variable text)
    loop
	--raise notice 'id=%,lib=%,typ=%,lang=%',rec.id,rec.libelle,rec.type,rec.langue;
	-- boucle sur les autres langues
	for rec_langue in 
	    select * from contraintes.af_get_langues() as (id int4,libelle varchar, code varchar, locale varchar) 
	    where id<>1
	loop
	
	    select into rec2 * from contraintes.af_get_langue_message_libelle(rec.id,rec_langue.id,rec.type) as (id int4,libelle text,type int4,langue int4);
	    if rec2.id is null then
	        --raise notice 'lang=% rec_id=% rec_type=%',rec_langue.id,rec.id,rec.type;
	        perform * from contraintes.af_set_langue_message(rec.id,rec_langue.id,rec.type,texte);
	    end if;
	end loop;
        
    end loop;
return true;
end;$$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_set_langues_messages_incomplets() OWNER TO pgsql;

--
-- TOC entry 8544 (class 0 OID 0)
-- Dependencies: 1506
-- Name: FUNCTION af_set_langues_messages_incomplets(); Type: COMMENT; Schema: contraintes; Owner: pgsql
--

COMMENT ON FUNCTION af_set_langues_messages_incomplets() IS 'insere le texte ''A completer'' pour les libelles manquants.
Langue de référence : french';


--
-- TOC entry 1507 (class 1255 OID 2596381)
-- Dependencies: 2101 2983 5
-- Name: af_set_media(integer); Type: FUNCTION; Schema: contraintes; Owner: postgres
--

CREATE FUNCTION af_set_media(integer) RETURNS information_schema.cardinal_number
    AS $_$BEGIN
	insert into media (id) values ($1);
	return FOUND;
END$_$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_set_media(integer) OWNER TO postgres;

--
-- TOC entry 8546 (class 0 OID 0)
-- Dependencies: 1507
-- Name: FUNCTION af_set_media(integer); Type: COMMENT; Schema: contraintes; Owner: postgres
--

COMMENT ON FUNCTION af_set_media(integer) IS 'FONCTION PRIVEE: creer un nouveau media (enregistre un fichier en tant que media)';


--
-- TOC entry 1901 (class 1255 OID 2596382)
-- Dependencies: 2983 5
-- Name: af_set_media_question_reponse_element(integer, integer, integer, integer, integer); Type: FUNCTION; Schema: contraintes; Owner: postgres
--

CREATE FUNCTION af_set_media_question_reponse_element(integer, integer, integer, integer, integer) RETURNS boolean
    AS $_$DECLARE
val_question_reponse ALIAS FOR $1;
val_question_reponse_element ALIAS FOR $2;
val_media ALIAS FOR $3;
val_hauteur ALIAS FOR $4;
val_largeur ALIAS FOR $5;

BEGIN
	insert into contraintes.media_question_reponse_element(question_reponse,question_reponse_element,media,hauteur, largeur ) 
	values (val_question_reponse, val_question_reponse_element, val_media, val_hauteur, val_largeur);

	return FOUND;
END$_$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_set_media_question_reponse_element(integer, integer, integer, integer, integer) OWNER TO postgres;

--
-- TOC entry 8548 (class 0 OID 0)
-- Dependencies: 1901
-- Name: FUNCTION af_set_media_question_reponse_element(integer, integer, integer, integer, integer); Type: COMMENT; Schema: contraintes; Owner: postgres
--

COMMENT ON FUNCTION af_set_media_question_reponse_element(integer, integer, integer, integer, integer) IS 'ajoute un media Ã  un element d''un question_reponse. retourne true si l''operation s''est bien passÃ©e.';


--
-- TOC entry 1508 (class 1255 OID 2596383)
-- Dependencies: 2983 5
-- Name: af_set_modele_correction(character varying); Type: FUNCTION; Schema: contraintes; Owner: pgsql
--

CREATE FUNCTION af_set_modele_correction(character varying) RETURNS integer
    AS $_$-- $1 : libelle modele correction
declare
new_id int4;
res int4;
begin
    insert into contraintes.modele_correction(libelle) values($1);
    --RECUPERE L'IDENTIFIANT DU NOUVEAU CRITERE
    GET DIAGNOSTICS new_id = RESULT_OID;
    SELECT INTO res id FROM contraintes.modele_correction WHERE oid=new_id;
    return res;
end;$_$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_set_modele_correction(character varying) OWNER TO pgsql;

--
-- TOC entry 8550 (class 0 OID 0)
-- Dependencies: 1508
-- Name: FUNCTION af_set_modele_correction(character varying); Type: COMMENT; Schema: contraintes; Owner: pgsql
--

COMMENT ON FUNCTION af_set_modele_correction(character varying) IS 'enregistre un modele de correction';


--
-- TOC entry 1509 (class 1255 OID 2596384)
-- Dependencies: 2983 5
-- Name: af_set_modele_correction_criteres(integer, integer, integer, integer); Type: FUNCTION; Schema: contraintes; Owner: pgsql
--

CREATE FUNCTION af_set_modele_correction_criteres(integer, integer, integer, integer) RETURNS boolean
    AS $_$-- $1 : numero modele
-- $2 : numero critere
-- $3 : numero pere
-- $4 : note
begin
    insert into contraintes.modele_correction_criteres(modele_correction,critere,pere,note_max) 
    values($1,$2,$3,$4);
    return found;
end;$_$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_set_modele_correction_criteres(integer, integer, integer, integer) OWNER TO pgsql;

--
-- TOC entry 8552 (class 0 OID 0)
-- Dependencies: 1509
-- Name: FUNCTION af_set_modele_correction_criteres(integer, integer, integer, integer); Type: COMMENT; Schema: contraintes; Owner: pgsql
--

COMMENT ON FUNCTION af_set_modele_correction_criteres(integer, integer, integer, integer) IS 'enregistre dans modele_correction_criteres';


--
-- TOC entry 1510 (class 1255 OID 2596385)
-- Dependencies: 2983 5
-- Name: af_set_organisme(character varying); Type: FUNCTION; Schema: contraintes; Owner: pgsql
--

CREATE FUNCTION af_set_organisme(character varying) RETURNS integer
    AS $_$declare
new_id int4;
res int4;
begin
    insert into contraintes.organisme(libelle) values($1);
    -- recup id
    GET DIAGNOSTICS new_id=RESULT_OID;
    select into res id from contraintes.organisme 
    where oid=new_id;
    return res;
end;$_$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_set_organisme(character varying) OWNER TO pgsql;

--
-- TOC entry 8554 (class 0 OID 0)
-- Dependencies: 1510
-- Name: FUNCTION af_set_organisme(character varying); Type: COMMENT; Schema: contraintes; Owner: pgsql
--

COMMENT ON FUNCTION af_set_organisme(character varying) IS 'enregistre un organisme';


--
-- TOC entry 1511 (class 1255 OID 2596386)
-- Dependencies: 2983 5
-- Name: af_set_page_annuaire_configuration(integer, integer, integer, integer[]); Type: FUNCTION; Schema: contraintes; Owner: pgsql
--

CREATE FUNCTION af_set_page_annuaire_configuration(integer, integer, integer, integer[]) RETURNS boolean
    AS $_$-- $1 : formation
-- $2 : page
-- $3 : type individu
-- $4 : tableau d'elements
declare
i int4;
begin
    for i in array_lower($4,1) .. array_upper($4,1)
    loop
	insert into contraintes.page_annuaire_configuration values ($1,$2,$3,$4[i]);
    end loop;
return true;


end;$_$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_set_page_annuaire_configuration(integer, integer, integer, integer[]) OWNER TO pgsql;

--
-- TOC entry 8556 (class 0 OID 0)
-- Dependencies: 1511
-- Name: FUNCTION af_set_page_annuaire_configuration(integer, integer, integer, integer[]); Type: COMMENT; Schema: contraintes; Owner: pgsql
--

COMMENT ON FUNCTION af_set_page_annuaire_configuration(integer, integer, integer, integer[]) IS 'enregistre la configuration de la page annuaire';


--
-- TOC entry 1512 (class 1255 OID 2596387)
-- Dependencies: 2983 5
-- Name: af_set_page_commentaire(integer, integer, integer, text); Type: FUNCTION; Schema: contraintes; Owner: pgsql
--

CREATE FUNCTION af_set_page_commentaire(integer, integer, integer, text) RETURNS boolean
    AS $_$-- $1 : page
-- $2 : formation
-- $3 : stagiaire
-- $4 : commentaire
declare
ams varchar;
begin
    -- test si existe
    perform * from contraintes.page_commentaire where page=$1 and formation=$2 and stagiaire=$3;
    if found then
	SELECT INTO ams contraintes.fw_get_ams_libelle('page_commentaire','commentaire','page='||$1||' and formation='||$2||' and stagiaire='||$3,$4);
	update contraintes.page_commentaire set commentaire=ams
	where page=$1 and formation=$2 and stagiaire=$3;
    else
	insert into contraintes.page_commentaire (page,formation,stagiaire,commentaire) 
	values($1,$2,$3,$4);
    end if;
    return found;
end;$_$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_set_page_commentaire(integer, integer, integer, text) OWNER TO pgsql;

--
-- TOC entry 8558 (class 0 OID 0)
-- Dependencies: 1512
-- Name: FUNCTION af_set_page_commentaire(integer, integer, integer, text); Type: COMMENT; Schema: contraintes; Owner: pgsql
--

COMMENT ON FUNCTION af_set_page_commentaire(integer, integer, integer, text) IS 'Enregistre le commentaire pour une page';


--
-- TOC entry 1513 (class 1255 OID 2596388)
-- Dependencies: 2983 5
-- Name: af_set_page_liste_configuration(integer, integer, integer, integer, integer[], character varying, text); Type: FUNCTION; Schema: contraintes; Owner: pgsql
--

CREATE FUNCTION af_set_page_liste_configuration(integer, integer, integer, integer, integer[], character varying, text) RETURNS boolean
    AS $_$-- $1 : formation
-- $2 : parcours
-- $3 : liste
-- $4 : page
-- $5 : tableau d'element
-- $6 : titre
-- $7 : commentaire
declare
i int4;
begin
    for i in array_lower($5,1) .. array_upper($5,1)
    loop
	insert into contraintes.page_liste_configuration values ($1,$2,$3,$4,$5[i]);
    end loop;
    insert into contraintes.page_liste values ($1,$2,$3,$4,$6,$7);
return true;
end;
$_$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_set_page_liste_configuration(integer, integer, integer, integer, integer[], character varying, text) OWNER TO pgsql;

--
-- TOC entry 8560 (class 0 OID 0)
-- Dependencies: 1513
-- Name: FUNCTION af_set_page_liste_configuration(integer, integer, integer, integer, integer[], character varying, text); Type: COMMENT; Schema: contraintes; Owner: pgsql
--

COMMENT ON FUNCTION af_set_page_liste_configuration(integer, integer, integer, integer, integer[], character varying, text) IS 'Enregistre la configuration d''une page de liste';


--
-- TOC entry 1514 (class 1255 OID 2596389)
-- Dependencies: 2983 5
-- Name: af_set_page_ressource_configuration(integer, integer, integer, integer, text); Type: FUNCTION; Schema: contraintes; Owner: pgsql
--

CREATE FUNCTION af_set_page_ressource_configuration(integer, integer, integer, integer, text) RETURNS boolean
    AS $_$-- $1 : formation
-- $2 : page
-- $3 : parcours
-- $4 : etape_ressource
-- $5 : commentaire
begin
    -- test si existe
    perform * from contraintes.page_ressource_configuration where formation=$1 and page=$2 and parcours=$3 and etape_ressource=$4;
    if found then 
	update contraintes.page_ressource_configuration set commentaire=$5
	where formation=$1 and page=$2 and parcours=$3 and etape_ressource=$4;
    else
	insert into contraintes.page_ressource_configuration (formation,page,parcours,etape_ressource,commentaire) 
	values($1,$2,$3,$4,$5);
    end if;
    return found;
end;$_$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_set_page_ressource_configuration(integer, integer, integer, integer, text) OWNER TO pgsql;

--
-- TOC entry 8562 (class 0 OID 0)
-- Dependencies: 1514
-- Name: FUNCTION af_set_page_ressource_configuration(integer, integer, integer, integer, text); Type: COMMENT; Schema: contraintes; Owner: pgsql
--

COMMENT ON FUNCTION af_set_page_ressource_configuration(integer, integer, integer, integer, text) IS 'Enregistre la configuration d''une page de ressource';


--
-- TOC entry 1515 (class 1255 OID 2596390)
-- Dependencies: 2983 5
-- Name: af_set_parcours(character varying, integer); Type: FUNCTION; Schema: contraintes; Owner: postgres
--

CREATE FUNCTION af_set_parcours(character varying, integer) RETURNS integer
    AS $_$declare
	num_etape int4;
begin
	
	select into num_etape contraintes.af_set_etape($1,1); 
	insert into contraintes.parcours(id,filiere) values(num_etape,$2);
	return num_etape;
end;$_$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_set_parcours(character varying, integer) OWNER TO postgres;

--
-- TOC entry 8564 (class 0 OID 0)
-- Dependencies: 1515
-- Name: FUNCTION af_set_parcours(character varying, integer); Type: COMMENT; Schema: contraintes; Owner: postgres
--

COMMENT ON FUNCTION af_set_parcours(character varying, integer) IS 'crÃ©e un parcours';


--
-- TOC entry 1516 (class 1255 OID 2596391)
-- Dependencies: 2983 5
-- Name: af_set_parcours_etape(integer, integer, integer, boolean, integer, boolean); Type: FUNCTION; Schema: contraintes; Owner: postgres
--

CREATE FUNCTION af_set_parcours_etape(integer, integer, integer, boolean, integer, boolean) RETURNS boolean
    AS $_$DECLARE
--$1 parcours
--$2 etape
--$3 pere
--$4 obligation
--$5 duree
--$6 fin de page
/*BEGIN
	INSERT INTO contraintes.parcours_etapes (parcours, etape, pere, obligatoire, chrono, fin)
	VALUES ($1, $2, $3, $4, $5, $6);

	RETURN FOUND;
END;
declare*/
	
	insere bool;
	chaine varchar;
	req text;
	rec record;
begin
	
	chaine:=','||$1||','||
	case when $4 then 
		
		'true'
	else
		
		'false'
	end
	||' ,';

	IF $5 IS NOT NULL THEN chaine:=chaine||$5;
	ELSE chaine:=chaine||'NULL';
	END IF;
 
	chaine:=chaine||','||
	case when $6 then 
		
		'true'
	else
		
		'false'
	end
	||' ';

	
	raise notice '%',chaine;
	req:='select  contraintes.af_gen_set_element(varchar ''contraintes.parcours_etapes'', varchar ''etape'' ,';
	IF $3 is null then 
		req:=req||' NULL';
	else
		req:=req||$3;
	end if;
	req:=req||','||$2||', text'', parcours,obligatoire,chrono,fin'',text '''||chaine||''', text ''AND parcours='||$1||''');';
	--raise notice '%',req;
	

	execute req;

	--IF FOUND THEN 
		return  TRUE;
	--ELSE 
	--	RETURN FALSE;
	--END IF;

end;$_$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_set_parcours_etape(integer, integer, integer, boolean, integer, boolean) OWNER TO postgres;

--
-- TOC entry 8566 (class 0 OID 0)
-- Dependencies: 1516
-- Name: FUNCTION af_set_parcours_etape(integer, integer, integer, boolean, integer, boolean); Type: COMMENT; Schema: contraintes; Owner: postgres
--

COMMENT ON FUNCTION af_set_parcours_etape(integer, integer, integer, boolean, integer, boolean) IS 'ajoute une etape au parcours';


--
-- TOC entry 1517 (class 1255 OID 2596392)
-- Dependencies: 2983 5
-- Name: af_set_parcours_oriente(character varying, integer[], integer[], integer, integer[]); Type: FUNCTION; Schema: contraintes; Owner: pgsql
--

CREATE FUNCTION af_set_parcours_oriente(character varying, integer[], integer[], integer, integer[]) RETURNS integer
    AS $_$DECLARE
--$1 libelle etape
--$2 les sous parcours
--$3 types d'étapes
--$4 nombre de types d'etapes
--$5 seuil
num_etape int4;
val int4;
i int4;
j int4;
curs int4:=1;
BEGIN
	--creation de l'etape
	SELECT INTO num_etape contraintes.af_set_etape($1,10); 
	
	--insertion de la configuration
	FOR i IN array_lower($2, 1) .. array_upper($2, 1)  
	LOOP
		--le 1er sous parcours
		IF i=1 THEN
			raise notice '1er parcours %: INSERT INTO contraintes.parcours_oriente(id,sous_parcours,type,seuil) values(%,%,%,%);',i,num_etape,$2[i],'NULL','NULL';
			INSERT INTO contraintes.parcours_oriente(id,sous_parcours,type,seuil,ordre) values(num_etape,$2[i],NULL,NULL, i);
		--les autres
		ELSE
			--seuil global
			IF $3[curs]=-1 THEN
				raise notice 'global %: INSERT INTO contraintes.parcours_oriente(id,sous_parcours,type,seuil) values(%,%,%,%);',i,num_etape,$2[i],'NULL',$5[curs];
				INSERT INTO contraintes.parcours_oriente(id,sous_parcours,type,seuil,ordre) values(num_etape,$2[i],NULL,$5[curs],i);
				curs:=curs+1;
			--seuil par type
			ELSE
				--pour chacun des types
				FOR j IN 1 .. $4
				LOOP
					--cas ou pas de seuil pour le type
					IF $5[curs] =-1 THEN
						val:=NULL;
					ELSE
						val:=$5[curs];
					END IF;
					raise notice 'type %: INSERT INTO contraintes.parcours_oriente(id,sous_parcours,type,seuil) values(%,%,%,%);',i,num_etape,$2[i],$3[curs],val;
					INSERT INTO contraintes.parcours_oriente(id,sous_parcours,type,seuil,ordre) values(num_etape,$2[i],$3[curs],val,i);
					curs:=curs+1;
				END LOOP;
			END IF;
		END IF;
	END LOOP;
	
	RETURN num_etape;
END; $_$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_set_parcours_oriente(character varying, integer[], integer[], integer, integer[]) OWNER TO pgsql;

--
-- TOC entry 1518 (class 1255 OID 2596393)
-- Dependencies: 2983 5
-- Name: af_set_positionnement(character varying, integer, integer, integer); Type: FUNCTION; Schema: contraintes; Owner: pgsql
--

CREATE FUNCTION af_set_positionnement(character varying, integer, integer, integer) RETURNS integer
    AS $_$DECLARE
--$1 libelle
--$2 chrono
--$3 qsrc
--$4 serie_generee
new_id int4;
oid_id int4;
BEGIN 
	
	INSERT INTO contraintes.positionnement 
	(libelle, chrono, qsrc, serie_generee)
	VALUES ($1, $2, $3, $4);
	GET DIAGNOSTICS oid_id = RESULT_OID;
	--RAISE NOTICE 'oid inseree: % ',oid_id;

	SELECT INTO new_id id FROM contraintes.positionnement WHERE oid=oid_id;
	--RAISE NOTICE 'valeur inseree: % ',new_id;

	RETURN new_id;
END$_$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_set_positionnement(character varying, integer, integer, integer) OWNER TO pgsql;

--
-- TOC entry 1902 (class 1255 OID 2596394)
-- Dependencies: 2983 5
-- Name: af_set_positionnement_choix(integer, integer, integer, integer, integer, integer, integer); Type: FUNCTION; Schema: contraintes; Owner: pgsql
--

CREATE FUNCTION af_set_positionnement_choix(integer, integer, integer, integer, integer, integer, integer) RETURNS boolean
    AS $_$DECLARE
--$1 positionnement
--$2 reponse
--$3 pere
--$4 bareme
--$5 media
--$6 hauteur
--$7 largeur
r1 boolean;
r2 boolean;
qr int4;
rec RECORD;
v_pere integer;
BEGIN
	--on recupere le pere pour l'insertion
	select INTO v_pere * from contraintes.af_gen_get_last_element('contraintes.choix', 'id',' AND positionnement='||$1);

	--on selectionne le question-reponse associé au positionnement
	SELECT INTO qr question_reponse FROM contraintes.positionnement where id=$1;

	--insert le nouveau choix
	INSERT INTO contraintes.choix (positionnement, id, pere, bareme )
	VALUES ($1, $2, $3, $4);
	r1 := FOUND;

	--selection les questions existantes
	FOR rec IN 
		SELECT id FROM contraintes.af_get_positionnement_questions($1) AS (id integer, libelle varchar, interpretationHTML boolean, reponse boolean)
	LOOP 
		PERFORM * FROM contraintes.af_set_question_reponse_association_element(qr, rec.id, $2, v_pere);
		IF NOT FOUND THEN
			RAISE EXCEPTION 'af_set_positionnement: erreur association choix/question_reponse';
		END IF;
	END LOOP;

	--SELECT * FROM contraintes.af_set_question_reponse_association_element(qr, integer, $2, $3)

	IF $5 IS NOT NULL THEN
		INSERT INTO contraintes.media_question_reponse_element (question_reponse, question_reponse_element, media, hauteur, largeur )
		VALUES (qr, $2, $5, $6, $7);
		r2 := FOUND;
	END IF;

	RETURN r1 OR r2;
END$_$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_set_positionnement_choix(integer, integer, integer, integer, integer, integer, integer) OWNER TO pgsql;

--
-- TOC entry 1903 (class 1255 OID 2596395)
-- Dependencies: 2983 5
-- Name: af_set_positionnement_evaluation_a_generer(integer, integer, integer, integer); Type: FUNCTION; Schema: contraintes; Owner: pgsql
--

CREATE FUNCTION af_set_positionnement_evaluation_a_generer(integer, integer, integer, integer) RETURNS boolean
    AS $_$DECLARE
--$1 positionnement
--$2 question de positionnement
--$3 choix
--$4 evaluation
qr int4;
id_pere int4;
BEGIN
	--on selectionne le question-reponse associé au positionnement
	SELECT INTO qr question_reponse FROM contraintes.positionnement where id=$1;

	--on selectionne le dernier element
	SELECT INTO id_pere * FROM
	contraintes.af_gen_get_last_element('contraintes.positionnement_evaluations', 'evaluation', ' AND question_reponse='||qr||' AND question='||$2||' AND choix='||$3);

	INSERT INTO contraintes.positionnement_evaluations
	(question_reponse, question, choix, evaluation, pere)
	VALUES (qr, $2, $3,$4,id_pere);

	RETURN FOUND;
END$_$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_set_positionnement_evaluation_a_generer(integer, integer, integer, integer) OWNER TO pgsql;

--
-- TOC entry 1519 (class 1255 OID 2596396)
-- Dependencies: 2983 5
-- Name: af_set_positionnement_nb_evaluations_a_generer(integer, integer, integer, integer, integer); Type: FUNCTION; Schema: contraintes; Owner: pgsql
--

CREATE FUNCTION af_set_positionnement_nb_evaluations_a_generer(integer, integer, integer, integer, integer) RETURNS boolean
    AS $_$DECLARE
--$1 positionnement
--$2 choix
--$3 type
--$4 nb_a_generer
--$5 taille_chapeau
BEGIN

	INSERT INTO contraintes.positionnement_choix_evaluations
	(positionnement, choix, type, nombre, nombre_max)
	VALUES ($1,$2,$3,$4,$5);

	RETURN FOUND;
END$_$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_set_positionnement_nb_evaluations_a_generer(integer, integer, integer, integer, integer) OWNER TO pgsql;

--
-- TOC entry 1520 (class 1255 OID 2596397)
-- Dependencies: 2983 5
-- Name: af_set_positionnement_question_positionnement_solution(integer, integer, integer[]); Type: FUNCTION; Schema: contraintes; Owner: pgsql
--

CREATE FUNCTION af_set_positionnement_question_positionnement_solution(integer, integer, integer[]) RETURNS boolean
    AS $_$DECLARE
--$1 positionnement
--$2 question
--$3array int4 : choix |  juste (0 ou 1)
i int4;
qr int4;
b_value bool;
BEGIN
	--on selectionne le question-reponse associé au positionnement
	SELECT INTO qr question_reponse FROM contraintes.positionnement where id=$1;

	FOR i IN array_lower($3,1) .. array_upper($3,1)
	LOOP
		IF $3[i][2]=1 THEN
			b_value:=TRUE;
		ELSE 
			b_value:=FALSE;
		END IF;
		PERFORM * FROM contraintes.af_set_question_reponse_solution(qr, $2, $3[i][1], b_value);
	END LOOP;
	
	RETURN FOUND;
END$_$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_set_positionnement_question_positionnement_solution(integer, integer, integer[]) OWNER TO pgsql;

--
-- TOC entry 1521 (class 1255 OID 2596398)
-- Dependencies: 2983 5
-- Name: af_set_presentiel_carton_capacite_date(integer, integer, integer, integer, integer, timestamp without time zone, integer); Type: FUNCTION; Schema: contraintes; Owner: pgsql
--

CREATE FUNCTION af_set_presentiel_carton_capacite_date(integer, integer, integer, integer, integer, timestamp without time zone, integer) RETURNS boolean
    AS $_$-- $1 : formation
-- $2 : stagiaire
-- $3 : grille
-- $4 : titre capacite
-- $5 : capacite
-- $6 : date
-- $7 : carton
begin
    perform * from contraintes.stagiaire_grille where formation=$1 and stagiaire=$2 and grille=$3;
    if not found then
	insert into contraintes.stagiaire_grille(formation,stagiaire,grille,visible) 
	values($1,$2,$3,true);
    end if;
    insert into contraintes.grille_resultats (formation,stagiaire,grille,capacite_titre,capacite,carton,date) 
    values($1,$2,$3,$4,$5,$7,$6);
    return found;	
end;$_$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_set_presentiel_carton_capacite_date(integer, integer, integer, integer, integer, timestamp without time zone, integer) OWNER TO pgsql;

--
-- TOC entry 8574 (class 0 OID 0)
-- Dependencies: 1521
-- Name: FUNCTION af_set_presentiel_carton_capacite_date(integer, integer, integer, integer, integer, timestamp without time zone, integer); Type: COMMENT; Schema: contraintes; Owner: pgsql
--

COMMENT ON FUNCTION af_set_presentiel_carton_capacite_date(integer, integer, integer, integer, integer, timestamp without time zone, integer) IS 'enregistre le carton pour une capacite à une date';


--
-- TOC entry 1522 (class 1255 OID 2596399)
-- Dependencies: 2983 5
-- Name: af_set_qcm(character varying, integer, boolean, integer[], integer[], integer[]); Type: FUNCTION; Schema: contraintes; Owner: postgres
--

CREATE FUNCTION af_set_qcm(character varying, integer, boolean, integer[], integer[], integer[]) RETURNS integer
    AS $_$DECLARE
--$1 libelle
--$2 type
--$3 radio
--$4 questions
--$5 reponses
--$6 justes
i integer;
b_value boolean;
val_id integer;
BEGIN	

	SELECT INTO val_id * FROM contraintes.af_set_question_reponse($1, $2, $3, $4,$5 );

	FOR i IN array_lower($6,1) .. array_upper($6,1)
	LOOP
		IF $6[i][2]=1 THEN
			b_value:=TRUE;
		ELSE 
			b_value:=FALSE;
		END IF;
		--note: un QCM à une seule question, dc pas besoin de parcourir le tableau
		PERFORM * FROM contraintes.af_set_question_reponse_solution(val_id, $4[1], $6[i][1], b_value);
	END LOOP;

	RETURN val_id;

END$_$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_set_qcm(character varying, integer, boolean, integer[], integer[], integer[]) OWNER TO postgres;

--
-- TOC entry 8576 (class 0 OID 0)
-- Dependencies: 1522
-- Name: FUNCTION af_set_qcm(character varying, integer, boolean, integer[], integer[], integer[]); Type: COMMENT; Schema: contraintes; Owner: postgres
--

COMMENT ON FUNCTION af_set_qcm(character varying, integer, boolean, integer[], integer[], integer[]) IS 'Créer un QCM complet';


--
-- TOC entry 1523 (class 1255 OID 2596400)
-- Dependencies: 2983 5
-- Name: af_set_qrc(character varying, integer, character varying, integer[], integer[], boolean, integer[]); Type: FUNCTION; Schema: contraintes; Owner: pgsql
--

CREATE FUNCTION af_set_qrc(character varying, integer, character varying, integer[], integer[], boolean, integer[]) RETURNS integer
    AS $_$-- $1 : libelle qrc
-- $2 : type evaluation qrc
-- $3 : libelle question commune
-- $4 : tableau de questions
-- $5 : tableau de reponses
-- $6 : type radio ou checkbox
-- $7 : tableau des juste/faux
declare
i integer;
j integer;
k integer :=1;
b_value boolean;
val_id int4;
begin
    SELECT INTO val_id * FROM contraintes.af_set_question_reponse($1, $2, $6, $4,$5 );
    INSERT INTO contraintes.qsrc (id, question) VALUES (val_id, $3);
    ---raise notice 'On a fin insert';
    FOR i IN array_lower($4,1) .. array_upper($4,1)
	LOOP
	for j in array_lower($5,1) .. array_upper($5,1)
	    loop
		--raise notice 'On traite % % % % ',$4[i],$5[j],$7[k][1],$7[k][2];
		IF $4[i]=$7[k][1] and $5[j]=$7[k][2] THEN
		    if $7[k][3]=1 then
			b_value:=TRUE;
		    ELSE 
			b_value:=FALSE;
	       	    end if;
		    k:=k+1;
		else
		    return null;
		END IF;
		
		PERFORM * FROM contraintes.af_set_question_reponse_solution(val_id, $4[i], $5[j], b_value);
		
	    end loop;
	END LOOP;

	RETURN val_id;
end; $_$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_set_qrc(character varying, integer, character varying, integer[], integer[], boolean, integer[]) OWNER TO pgsql;

--
-- TOC entry 8578 (class 0 OID 0)
-- Dependencies: 1523
-- Name: FUNCTION af_set_qrc(character varying, integer, character varying, integer[], integer[], boolean, integer[]); Type: COMMENT; Schema: contraintes; Owner: pgsql
--

COMMENT ON FUNCTION af_set_qrc(character varying, integer, character varying, integer[], integer[], boolean, integer[]) IS 'Enregistre un qrc';


--
-- TOC entry 1524 (class 1255 OID 2596401)
-- Dependencies: 2983 5
-- Name: af_set_qrc_question_solution(integer, integer, integer[]); Type: FUNCTION; Schema: contraintes; Owner: pgsql
--

CREATE FUNCTION af_set_qrc_question_solution(integer, integer, integer[]) RETURNS boolean
    AS $_$DECLARE
--$1 qrc
--$2 question
--$3 array int4 : choix |  juste (0 ou 1)
i int4;
qr int4;
b_value bool;
BEGIN

	FOR i IN array_lower($3,1) .. array_upper($3,1)
	LOOP
		IF $3[i][2]=1 THEN
			b_value:=TRUE;
		ELSE 
			b_value:=FALSE;
		END IF;
		PERFORM * FROM contraintes.af_set_question_reponse_solution($1, $2, $3[i][1], b_value);
	END LOOP;
	
	RETURN FOUND;
END$_$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_set_qrc_question_solution(integer, integer, integer[]) OWNER TO pgsql;

--
-- TOC entry 1525 (class 1255 OID 2596402)
-- Dependencies: 2983 5
-- Name: af_set_qsrc(character varying, integer, character varying, boolean); Type: FUNCTION; Schema: contraintes; Owner: pgsql
--

CREATE FUNCTION af_set_qsrc(character varying, integer, character varying, boolean) RETURNS integer
    AS $_$DECLARE
--$1 libelle
--$2 type (4 ou 5)
--$3 question commmune
--$4 radio?
new_id int4;
v_question_reponse integer;
ok boolean;
BEGIN
	--cree l'evaluation
	SELECT INTO new_id * FROM contraintes.af_set_evaluation($1,$2);

	--cree le question reponse
	SELECT INTO ok * FROM contraintes.af_set_question_reponse(new_id, $2, $4);

	--cree le qsrc
	INSERT INTO contraintes.qsrc (id, question)
	VALUES (new_id, $3);

	IF FOUND AND ok THEN
		RETURN new_id;
	ELSE
		RAISE NOTICE 'erreur lors de la creation du SRC';
	END IF;
END$_$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_set_qsrc(character varying, integer, character varying, boolean) OWNER TO pgsql;

--
-- TOC entry 1526 (class 1255 OID 2596403)
-- Dependencies: 2983 5
-- Name: af_set_qsrc_question(integer, character varying, boolean, integer, integer, integer, integer); Type: FUNCTION; Schema: contraintes; Owner: pgsql
--

CREATE FUNCTION af_set_qsrc_question(integer, character varying, boolean, integer, integer, integer, integer) RETURNS integer
    AS $_$DECLARE
--$1 qsrc
--$2 libelle
--$3 interHTML
--$4 media
--$5 largeur
--$6 hauteur
--$7 pere
rec RECORD;
id_quest int4;
v_type integer;
BEGIN
	SELECT INTO v_type type FROM contraintes.af_get_question_reponse($1) AS (id int4, libelle varchar, type int4, date_creation timestamp, radio bool);

	
	--on cree la question et son media
	SELECT INTO id_quest * FROM contraintes.af_set_question_reponse_element($2, $3, v_type,FALSE);

	FOR rec IN
		--on selectionne les choix du positionnement
		SELECT id FROM contraintes.choix where question_reponse=$1

	--pour chacun des choix
	LOOP
RAISE NOTICE 'pere=%',$7;
		--on associe les elements du question reponse
		--PERFORM * FROM contraintes.af_set_question_reponse_association_element(qr, id_quest, rec.id, $7);
		PERFORM * FROM contraintes.af_gen_set_element('contraintes.question_reponse_elements', 'question', $7, id_quest, ',question_reponse, reponse', ','||$1||','||rec.id,'and question_reponse='||$1||' and reponse='||rec.id);
		--on enregistre l'association en tant qu'element de positionnement 
		--INSERT INTO contraintes.positionnement_elements(question_reponse, question, choix)
		--VALUES ($1, id_quest, rec.id);
 
	END LOOP;

	IF $4 IS NOT NULL THEN
		--RAISE NOTICE 'insertion image % / % / % / % / %',$1, id_quest, $4,$5,$6;
		PERFORM * FROM contraintes.af_set_media_question_reponse_element($1, id_quest, $4,$5,$6);
	END IF;

	RETURN id_quest;
END$_$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_set_qsrc_question(integer, character varying, boolean, integer, integer, integer, integer) OWNER TO pgsql;

--
-- TOC entry 1904 (class 1255 OID 2596404)
-- Dependencies: 2983 5
-- Name: af_set_question(character varying, boolean, integer); Type: FUNCTION; Schema: contraintes; Owner: postgres
--

CREATE FUNCTION af_set_question(character varying, boolean, integer) RETURNS integer
    AS $_$DECLARE
libelle ALIAS FOR $1;
interpretation_HTML ALIAS  FOR $2;
val_type ALIAS FOR $3;

res int4;
BEGIN

	--insertion dans la table des elements 
	select into res contraintes.af_set_question_reponse_element(libelle, interpretation_HTML, val_type, FALSE);

	--insertion dans la table des questions
	--insert into contraintes.question(id) VALUES (res);

	--on retourne l'id de l'enregistrement
	return res;

END;$_$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_set_question(character varying, boolean, integer) OWNER TO postgres;

--
-- TOC entry 8583 (class 0 OID 0)
-- Dependencies: 1904
-- Name: FUNCTION af_set_question(character varying, boolean, integer); Type: COMMENT; Schema: contraintes; Owner: postgres
--

COMMENT ON FUNCTION af_set_question(character varying, boolean, integer) IS 'FONCTION PRIVEE:
Insere une question.';


--
-- TOC entry 1527 (class 1255 OID 2596405)
-- Dependencies: 2983 5
-- Name: af_set_question_positionnement(integer, character varying, boolean, integer, integer, integer, integer); Type: FUNCTION; Schema: contraintes; Owner: pgsql
--

CREATE FUNCTION af_set_question_positionnement(integer, character varying, boolean, integer, integer, integer, integer) RETURNS integer
    AS $_$DECLARE
--$1 positionnement
--$2 libelle
--$3 interHTML
--$4 media
--$5 largeur
--$6 hauteur
--$7 pere
rec RECORD;
qr int4;
id_quest int4;
BEGIN
	--on selectionne le question-reponse associé au positionnement
	SELECT INTO qr question_reponse FROM contraintes.positionnement where id=$1;
		
	--on cree la question et son media
	SELECT INTO id_quest * FROM contraintes.af_set_question_reponse_element($2, $3, 6,FALSE);

	FOR rec IN
		--on selectionne les choix du positionnement
		SELECT id FROM contraintes.choix where positionnement=$1

	--pour chacun des choix
	LOOP

		--on associe les elements du question reponse
		--PERFORM * FROM contraintes.af_set_question_reponse_association_element(qr, id_quest, rec.id, $7);
		PERFORM * FROM contraintes.af_gen_set_element('contraintes.question_reponse_elements', 'question', $7, id_quest, ',question_reponse, reponse', ','||qr||','||rec.id,'and question_reponse='||qr||' and reponse='||rec.id);
		--on enregistre l'association en tant qu'element de positionnement 
		INSERT INTO contraintes.positionnement_elements(question_reponse, question, choix)
		VALUES (qr, id_quest, rec.id);

	END LOOP;

	IF $4 IS NOT NULL THEN
		RAISE NOTICE 'insertion image % / % / % / % / %',qr, id_quest, $4,$5,$6;
		PERFORM * FROM contraintes.af_set_media_question_reponse_element(qr, id_quest, $4,$5,$6);
	END IF;

	RETURN id_quest;
END$_$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_set_question_positionnement(integer, character varying, boolean, integer, integer, integer, integer) OWNER TO pgsql;

--
-- TOC entry 1528 (class 1255 OID 2596406)
-- Dependencies: 2983 5
-- Name: af_set_question_reponse(integer, integer, boolean); Type: FUNCTION; Schema: contraintes; Owner: postgres
--

CREATE FUNCTION af_set_question_reponse(integer, integer, boolean) RETURNS boolean
    AS $_$DECLARE
val_id ALIAS FOR $1;
val_type ALIAS FOR $2;
val_radio ALIAS FOR $3;
BEGIN	
	insert into contraintes.question_reponse (id, "type", radio) values (val_id, val_type, val_radio) ;
	return FOUND;
END$_$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_set_question_reponse(integer, integer, boolean) OWNER TO postgres;

--
-- TOC entry 8586 (class 0 OID 0)
-- Dependencies: 1528
-- Name: FUNCTION af_set_question_reponse(integer, integer, boolean); Type: COMMENT; Schema: contraintes; Owner: postgres
--

COMMENT ON FUNCTION af_set_question_reponse(integer, integer, boolean) IS 'FONCTION PRIVEE';


--
-- TOC entry 1529 (class 1255 OID 2596407)
-- Dependencies: 2983 5
-- Name: af_set_question_reponse(character varying, integer, boolean, integer[], integer[]); Type: FUNCTION; Schema: contraintes; Owner: postgres
--

CREATE FUNCTION af_set_question_reponse(character varying, integer, boolean, integer[], integer[]) RETURNS integer
    AS $_$DECLARE
--$1 libelle
--$2 type
--$3 radio
--$4 questions
--$5 reponses
i integer;
j integer;
prec_i integer:=NULL;
prec_j integer:=NULL;
val_id integer;
BEGIN	
    SELECT INTO val_id * FROM contraintes.af_set_evaluation($1,$2);
    PERFORM contraintes.af_set_question_reponse(val_id, $2, $3);
    /*
    FOR i IN array_lower($4, 1) .. array_upper($4, 1)  
    LOOP
	FOR j IN array_lower($5, 1) .. array_upper($5, 1)  
	LOOP
	    IF j-1>0 THEN
		prec_j:=$5[j-1];--precedent reponse
	    END IF;
	    --RAISE NOTICE 'association: %, %,%,%',val_id,$4[i], $5[j],prec_i;
	    PERFORM contraintes.af_set_question_reponse_association_element(val_id,$4[i], $5[j],prec_j);
	END LOOP;
    END LOOP;
    */
    -- Boucle d'enregistrement des questions
    FOR i IN array_lower($4, 1) .. array_upper($4, 1)  
    LOOP
	IF i-1>0 THEN
		prec_i:=$4[i-1];--precedent question
	END IF;
	--RAISE NOTICE 'association: %, %,%,%',val_id,$4[i], $5[j],prec_i;
	PERFORM contraintes.af_set_question_reponse_association_element(val_id,$4[i],prec_i);
    END LOOP;
    -- Boucle d'enregistrement des reponse
    FOR j IN array_lower($5, 1) .. array_upper($5, 1)  
    LOOP
	IF j-1>0 THEN
		prec_j:=$5[j-1];--precedent reponse
	END IF;
	--RAISE NOTICE 'association: %, %,%,%',val_id,$4[i], $5[j],prec_i;
	PERFORM contraintes.af_set_question_reponse_association_element(val_id,$5[j],prec_j);
    END LOOP;
    
    RETURN val_id;
END$_$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_set_question_reponse(character varying, integer, boolean, integer[], integer[]) OWNER TO postgres;

--
-- TOC entry 8588 (class 0 OID 0)
-- Dependencies: 1529
-- Name: FUNCTION af_set_question_reponse(character varying, integer, boolean, integer[], integer[]); Type: COMMENT; Schema: contraintes; Owner: postgres
--

COMMENT ON FUNCTION af_set_question_reponse(character varying, integer, boolean, integer[], integer[]) IS 'Créer un Question Réponse complet';


--
-- TOC entry 1905 (class 1255 OID 2596408)
-- Dependencies: 2983 5
-- Name: af_set_question_reponse_association_element(integer, integer, integer); Type: FUNCTION; Schema: contraintes; Owner: postgres
--

CREATE FUNCTION af_set_question_reponse_association_element(integer, integer, integer) RETURNS boolean
    AS $_$DECLARE
val_question_reponse ALIAS FOR $1;
val_question_reponse_element ALIAS FOR $2;

val_pere ALIAS FOR $3;
BEGIN
	--RAISE NOTICE 'qr=% q=% r=% pere=%',val_question_reponse, val_question, val_reponse, val_pere;
	insert into contraintes.question_reponse_elements (question_reponse, question_reponse_element, pere) values  (val_question_reponse, val_question_reponse_element, val_pere) ;
	return FOUND;
END;$_$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_set_question_reponse_association_element(integer, integer, integer) OWNER TO postgres;

--
-- TOC entry 8590 (class 0 OID 0)
-- Dependencies: 1905
-- Name: FUNCTION af_set_question_reponse_association_element(integer, integer, integer); Type: COMMENT; Schema: contraintes; Owner: postgres
--

COMMENT ON FUNCTION af_set_question_reponse_association_element(integer, integer, integer) IS 'ajoute un element de question_reponse, c''est Ã  dire une paire question reponse. Le champs pere s''applique Ã  la rÃ©ponse pour permettre de conserver l''ordre des reponses.';


--
-- TOC entry 1530 (class 1255 OID 2596409)
-- Dependencies: 2983 5
-- Name: af_set_question_reponse_choix(integer, integer, integer, integer, integer, integer, integer); Type: FUNCTION; Schema: contraintes; Owner: pgsql
--

CREATE FUNCTION af_set_question_reponse_choix(integer, integer, integer, integer, integer, integer, integer) RETURNS boolean
    AS $_$DECLARE
--$1 question_reponse
--$2 reponse
--$3 pere
--$4 bareme
--$5 media
--$6 hauteur
--$7 largeur
r1 boolean;
r2 boolean;
qr int4;
rec RECORD;
v_pere integer;
v_type integer;
BEGIN
	SELECT INTO v_type type FROM contraintes.af_get_question_reponse($1) AS (id int4, libelle varchar, type int4, date_creation timestamp, radio bool);

	--insert le nouveau choix
	INSERT INTO contraintes.choix (question_reponse, id, pere, bareme )
	VALUES ($1, $2, $3, $4);
	r1 := FOUND;

	--selection les questions existantes
	FOR rec IN 
		SELECT id FROM contraintes.af_get_question_reponse_elements($1,TRUE) as (id int4,libelle varchar,interpretation_html bool,type int4, reponse bool, indice integer)
	LOOP 
		PERFORM * FROM contraintes.af_set_question_reponse_association_element(qr, rec.id, $2, v_pere);
		IF NOT FOUND THEN
			RAISE EXCEPTION 'af_set_question_reponse_choix: erreur association choix/question_reponse';
		END IF;
	END LOOP;

	--SELECT * FROM contraintes.af_set_question_reponse_association_element(qr, integer, $2, $3)

	IF $5 IS NOT NULL THEN
		INSERT INTO contraintes.media_question_reponse_element (question_reponse, question_reponse_element, media, hauteur, largeur )
		VALUES (qr, $2, $5, $6, $7);
		r2 := FOUND;
	END IF;

	RETURN r1 OR r2;
END$_$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_set_question_reponse_choix(integer, integer, integer, integer, integer, integer, integer) OWNER TO pgsql;

--
-- TOC entry 1531 (class 1255 OID 2596410)
-- Dependencies: 2983 5
-- Name: af_set_question_reponse_element(character varying, boolean, integer, boolean); Type: FUNCTION; Schema: contraintes; Owner: postgres
--

CREATE FUNCTION af_set_question_reponse_element(character varying, boolean, integer, boolean) RETURNS integer
    AS $_$DECLARE

res int4;
new_id int4;

BEGIN

	insert into contraintes.question_reponse_element(libelle, interpretation_HTML, "type", reponse) values($1,$2,$3,$4);
	GET DIAGNOSTICS new_id = RESULT_OID;
	
	select into res id from contraintes.question_reponse_element where oid=new_id;
	
	return res;

END;$_$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_set_question_reponse_element(character varying, boolean, integer, boolean) OWNER TO postgres;

--
-- TOC entry 8593 (class 0 OID 0)
-- Dependencies: 1531
-- Name: FUNCTION af_set_question_reponse_element(character varying, boolean, integer, boolean); Type: COMMENT; Schema: contraintes; Owner: postgres
--

COMMENT ON FUNCTION af_set_question_reponse_element(character varying, boolean, integer, boolean) IS 'FONCTION PRIVEE:
Insere un element de question reponse. ';


--
-- TOC entry 1532 (class 1255 OID 2596411)
-- Dependencies: 2983 5
-- Name: af_set_question_reponse_media(integer, integer, integer, integer); Type: FUNCTION; Schema: contraintes; Owner: postgres
--

CREATE FUNCTION af_set_question_reponse_media(integer, integer, integer, integer) RETURNS boolean
    AS $_$DECLARE
val_question_reponse ALIAS FOR $1;
val_media ALIAS FOR $2;
val_hauteur ALIAS FOR $3;
val_largeur ALIAS FOR $4;

BEGIN
	insert into contraintes.media_question_reponse(question_reponse,media,hauteur, largeur ) 
	values (val_question_reponse,  val_media, val_hauteur, val_largeur);

	return FOUND;
END$_$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_set_question_reponse_media(integer, integer, integer, integer) OWNER TO postgres;

--
-- TOC entry 8595 (class 0 OID 0)
-- Dependencies: 1532
-- Name: FUNCTION af_set_question_reponse_media(integer, integer, integer, integer); Type: COMMENT; Schema: contraintes; Owner: postgres
--

COMMENT ON FUNCTION af_set_question_reponse_media(integer, integer, integer, integer) IS 'ajoute un media Ã  un question_reponse. retourne true si l''operation s''est bien passÃ©e.';


--
-- TOC entry 1533 (class 1255 OID 2596412)
-- Dependencies: 2983 5
-- Name: af_set_question_reponse_solution(integer, integer, integer, boolean); Type: FUNCTION; Schema: contraintes; Owner: postgres
--

CREATE FUNCTION af_set_question_reponse_solution(integer, integer, integer, boolean) RETURNS boolean
    AS $_$DECLARE
val_question_reponse ALIAS FOR $1;
val_question ALIAS FOR $2;
val_reponse ALIAS FOR $3;
val_juste ALIAS FOR $4;
BEGIN
	--RAISE NOTICE 'INSERT SOLUTION qr=%  q=%  r=% j=%',val_question_reponse, val_question, val_reponse, val_juste;
	insert into contraintes.qcm_elements(question_reponse, question, reponse, juste) values (val_question_reponse, val_question, val_reponse, val_juste) ;
	return FOUND;

END$_$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_set_question_reponse_solution(integer, integer, integer, boolean) OWNER TO postgres;

--
-- TOC entry 8597 (class 0 OID 0)
-- Dependencies: 1533
-- Name: FUNCTION af_set_question_reponse_solution(integer, integer, integer, boolean); Type: COMMENT; Schema: contraintes; Owner: postgres
--

COMMENT ON FUNCTION af_set_question_reponse_solution(integer, integer, integer, boolean) IS 'FONCTION PRIVEE: ajoute un enregistrement  dans la table qcm_elements';


--
-- TOC entry 1534 (class 1255 OID 2596413)
-- Dependencies: 2983 5
-- Name: af_set_reponse(character varying, boolean, integer); Type: FUNCTION; Schema: contraintes; Owner: postgres
--

CREATE FUNCTION af_set_reponse(character varying, boolean, integer) RETURNS integer
    AS $_$DECLARE
libelle ALIAS FOR $1;
interpretation_HTML ALIAS  FOR $2;
"type" ALIAS FOR $3;

res int4;
BEGIN

	--insertion dans la table generique
	select into res contraintes.af_set_question_reponse_element(libelle, interpretation_HTML, "type", TRUE);
	
	--insertion dans la table des reponses
	--insert into contraintes.reponse(id) VALUES (res);
	
	--on retourne l'id
	return res;

END;$_$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_set_reponse(character varying, boolean, integer) OWNER TO postgres;

--
-- TOC entry 8599 (class 0 OID 0)
-- Dependencies: 1534
-- Name: FUNCTION af_set_reponse(character varying, boolean, integer); Type: COMMENT; Schema: contraintes; Owner: postgres
--

COMMENT ON FUNCTION af_set_reponse(character varying, boolean, integer) IS 'FONCTION PRIVEE:
Insere une reponse.';


--
-- TOC entry 1535 (class 1255 OID 2596414)
-- Dependencies: 2983 5
-- Name: af_set_ressource(integer, text); Type: FUNCTION; Schema: contraintes; Owner: pgsql
--

CREATE FUNCTION af_set_ressource(integer, text) RETURNS integer
    AS $_$
-- $1 : fichier
-- $2 : mots cles
declare
new_id oid;
res int4;
begin
    -- insertion ressource
    INSERT INTO contraintes.ressource( fichier,mots_cles) VALUES ($1, $2);
    GET DIAGNOSTICS new_id = RESULT_OID;
    SELECT INTO res id FROM contraintes.ressource WHERE oid=new_id;

    RETURN res;
end;$_$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_set_ressource(integer, text) OWNER TO pgsql;

--
-- TOC entry 8601 (class 0 OID 0)
-- Dependencies: 1535
-- Name: FUNCTION af_set_ressource(integer, text); Type: COMMENT; Schema: contraintes; Owner: pgsql
--

COMMENT ON FUNCTION af_set_ressource(integer, text) IS 'enregistre une ressource';


--
-- TOC entry 1536 (class 1255 OID 2596415)
-- Dependencies: 2983 5
-- Name: af_set_resultat_debut(integer, integer, integer, integer); Type: FUNCTION; Schema: contraintes; Owner: pgsql
--

CREATE FUNCTION af_set_resultat_debut(integer, integer, integer, integer) RETURNS integer
    AS $_$DECLARE
--$1 formation
--$2 stagiaire
--$3 parcours
--$5 etape
new_oid oid;
new_id int4;
BEGIN

	SELECT INTO new_id * FROM contraintes.resultat
	WHERE formation=$1
	AND stagiaire=$2
	AND parcours=$3
	AND etape=$4
	AND date_debut IS NOT NULL;

	IF NOT FOUND THEN
		INSERT INTO contraintes.resultat
		(formation,stagiaire,parcours,etape, date_debut)
		VALUES ($1,$2,$3,$4, now());

		--RECUPERE L'IDENTIFIANT DU NOUVEAU RESULTAT
		GET DIAGNOSTICS new_oid = RESULT_OID;

		select into new_id id from contraintes.resultat where oid=new_oid;
	END IF;

	return new_id;
END;$_$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_set_resultat_debut(integer, integer, integer, integer) OWNER TO pgsql;

--
-- TOC entry 1537 (class 1255 OID 2596416)
-- Dependencies: 2983 5
-- Name: af_set_resultat_exotlc(bigint); Type: FUNCTION; Schema: contraintes; Owner: pgsql
--

CREATE FUNCTION af_set_resultat_exotlc(bigint) RETURNS boolean
    AS $_$DECLARE
-- $1 : id resultat
exotlc_type integer;
ok boolean;
begin
	
	 
    -- test si existe
    perform * from contraintes.resultat_exotlc where id=$1;
    if not found then
	insert into contraintes.resultat_exotlc (id,date_correction) values($1,now());
ELSE
	UPDATE contraintes.resultat_exotlc SET date_correction=now()
	WHERE id=$1 AND date_correction IS NULL;
    end if;

	ok:=FOUND;
	--recuperation du type d'exotlc
	SELECT INTO exotlc_type E.type 
	FROM contraintes.af_get_resultat($1) AS (R_id int8,  formation int4, stagiaire int4,parcours int4, etape int4,  date_debut timestamp, duree interval),
	contraintes.exotlc E
	WHERE etape=E.id;

	IF exotlc_type=2 THEN
		 perform * from contraintes.af_set_resultat_fin($1);
	END IF;
	
    return ok;
end;$_$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_set_resultat_exotlc(bigint) OWNER TO pgsql;

--
-- TOC entry 8604 (class 0 OID 0)
-- Dependencies: 1537
-- Name: FUNCTION af_set_resultat_exotlc(bigint); Type: COMMENT; Schema: contraintes; Owner: pgsql
--

COMMENT ON FUNCTION af_set_resultat_exotlc(bigint) IS 'insere l''identifiant de resultat dans la table resultat_exotlc';


--
-- TOC entry 1538 (class 1255 OID 2596417)
-- Dependencies: 2983 5
-- Name: af_set_resultat_exotlc_critere(bigint, integer, integer, integer, text); Type: FUNCTION; Schema: contraintes; Owner: pgsql
--

CREATE FUNCTION af_set_resultat_exotlc_critere(bigint, integer, integer, integer, text) RETURNS boolean
    AS $_$-- $1 : id resultat
-- $2 : critere
-- $3 : note
-- $4 : note_max
-- $5 : commentaire
begin
    insert into contraintes.resultat_exotlc_critere(id,critere,note,note_max,commentaire) 
    values($1,$2,$3,$4,$5);
    return found;	
end; $_$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_set_resultat_exotlc_critere(bigint, integer, integer, integer, text) OWNER TO pgsql;

--
-- TOC entry 8606 (class 0 OID 0)
-- Dependencies: 1538
-- Name: FUNCTION af_set_resultat_exotlc_critere(bigint, integer, integer, integer, text); Type: COMMENT; Schema: contraintes; Owner: pgsql
--

COMMENT ON FUNCTION af_set_resultat_exotlc_critere(bigint, integer, integer, integer, text) IS 'Enregistre les resultats d''un critere pour un identifiant de resultat';


--
-- TOC entry 1539 (class 1255 OID 2596418)
-- Dependencies: 2983 5
-- Name: af_set_resultat_exotlc_plateforme(bigint, integer); Type: FUNCTION; Schema: contraintes; Owner: pgsql
--

CREATE FUNCTION af_set_resultat_exotlc_plateforme(bigint, integer) RETURNS boolean
    AS $_$DECLARE
--$1 resultat
--$2 fichier_rendu
ok boolean;
BEGIN

	PERFORM * FROM contraintes.resultat_exotlc WHERE id=$1;
	IF NOT FOUND THEN
		INSERT INTO contraintes.resultat_exotlc
		(id,fichier_rendu)
		VALUES ($1,$2);
	ELSE
		UPDATE contraintes.resultat_exotlc SET fichier_rendu=$2
		WHERE id=$1;
	END IF;
	
	RETURN FOUND ;--AND ok;
END;$_$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_set_resultat_exotlc_plateforme(bigint, integer) OWNER TO pgsql;

--
-- TOC entry 1540 (class 1255 OID 2596419)
-- Dependencies: 2983 5
-- Name: af_set_resultat_exotlc_sous_critere(bigint, integer, integer, integer); Type: FUNCTION; Schema: contraintes; Owner: pgsql
--

CREATE FUNCTION af_set_resultat_exotlc_sous_critere(bigint, integer, integer, integer) RETURNS boolean
    AS $_$-- $1 : id resultat
-- $2 : sous critere
-- $3 : note
-- $4 : note max
begin
    insert into contraintes.resultat_exotlc_sous_critere(id,sous_critere,note,note_max) 
    values($1,$2,$3,$4);
    return found;
end;$_$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_set_resultat_exotlc_sous_critere(bigint, integer, integer, integer) OWNER TO pgsql;

--
-- TOC entry 8609 (class 0 OID 0)
-- Dependencies: 1540
-- Name: FUNCTION af_set_resultat_exotlc_sous_critere(bigint, integer, integer, integer); Type: COMMENT; Schema: contraintes; Owner: pgsql
--

COMMENT ON FUNCTION af_set_resultat_exotlc_sous_critere(bigint, integer, integer, integer) IS 'enregistre les resultats d''un sous critere pour un identifiant de resultat';


--
-- TOC entry 1541 (class 1255 OID 2596420)
-- Dependencies: 2983 5
-- Name: af_set_resultat_fin(bigint); Type: FUNCTION; Schema: contraintes; Owner: pgsql
--

CREATE FUNCTION af_set_resultat_fin(bigint) RETURNS interval
    AS $_$DECLARE
--$1 resultat
duree_init interval;
date_debut_init timestamp;
nouvelle_duree interval;
BEGIN
	SELECT INTO duree_init duree FROM contraintes.resultat WHERE id=$1;
	SELECT INTO date_debut_init date_debut FROM contraintes.resultat WHERE id=$1;

	IF duree_init IS NOT NULL THEN
		RAISE EXCEPTION 'Erreur: la durée a déjà été affectée pour la fin de l''étape';
	ELSE
		nouvelle_duree:=cast(now() AS timestamp without time zone)-date_debut_init;
		
		UPDATE contraintes.resultat
		SET duree=nouvelle_duree
		WHERE id=$1;

		RETURN nouvelle_duree;
		
	END IF;

	RETURN NULL;
	
END;$_$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_set_resultat_fin(bigint) OWNER TO pgsql;

--
-- TOC entry 1542 (class 1255 OID 2596421)
-- Dependencies: 2983 5
-- Name: af_set_resultat_meilleure_tentative(bigint); Type: FUNCTION; Schema: contraintes; Owner: pgsql
--

CREATE FUNCTION af_set_resultat_meilleure_tentative(bigint) RETURNS boolean
    AS $_$-- $1 : id resultat
/*declare
rec_resultat record;
rec record;
rec2 record;
rec_resultat_evaluation record;
score real;
score_courant real;
meilleure_tentative integer;
meilleur_identifiant bigint;
begin
    -- recup info resultat
    select into rec_resultat * from contraintes.af_get_resultat($1) 
    as (id bigint,formation integer,stagiaire integer,parcours integer,etape integer,date_debut timestamp, duree interval); 
    -- boucle sur les tentatives
    score:=0;
    meilleure_tentative:=0;
    for rec in 
	select * from contraintes.resultat_tentative where 
	formation=rec_resultat.formation and 
	stagiaire=rec_resultat.stagiaire and 
	parcours=rec_resultat.parcours and 
	etape=rec_resultat.etape
    loop
	-- recup score courant
	select into score_courant * from contraintes.af_get_resultat_serie_score_tentative(rec.id);
	raise notice '---------------score tentative %=%',rec.id,score_courant;
	if score_courant > score then
	    score:=score_courant;
	    meilleure_tentative:=rec.tentative;
	    meilleur_identifiant:=rec.id;
	end if;


    end loop;

    -- recup score serie
    select into score_courant * from contraintes.af_get_resultat_serie_score($1);
   -- raise notice 'sco=% et score_cour=%',score,score_courant;
raise notice '---------------score resultat %=%',$1,score_courant;   
 if score > score_courant then


	-- mise à jour des resultats
	-- boucle sur les evaluations de la serie
	for rec2 in
	    select * from contraintes.af_get_serie_evaluations(rec_resultat.etape) 
	    as (id_evaluation integer, libelle_evaluation varchar, serie integer, pere_evaluation integer, commentaire_evaluation varchar, bareme_evaluation integer, chrono_evaluation integer, points_evaluation integer, type_evaluation integer )
	loop
	    -- suivant le type d'évaluation
	    -- question reponse
	    if rec2.type_evaluation=1 or rec2.type_evaluation=4 then
		for rec_resultat_evaluation in
		    select * from contraintes.af_get_resultat_serie_question_reponse_tentative(meilleur_identifiant,rec2.id_evaluation) 
		    as (id bigint, question_reponse integer, question integer, reponse integer,  date_debut timestamp,  date_fin timestamp,coche boolean, juste integer)
		loop
		    -- mise à jour
		    --raise notice 'mise a jour';

			--TODO décocher aussi les réponses!!!!
			---TODO mettre a jouyr TOUS les champs
		    update contraintes.resultat_serie_question_reponse set coche=rec_resultat_evaluation.coche 
			where
		    id=$1 and 
		    question_reponse=rec_resultat_evaluation.question_reponse and
		    question=rec_resultat_evaluation.question and 
		    reponse=rec_resultat_evaluation.reponse;

		end loop;

	    end if;
	    -- ftb
	    if rec2.type_evaluation=3 then
		for rec_resultat_evaluation in
		    select * from contraintes.af_get_resultat_serie_ftb_tentative(meilleur_identifiant,rec2.id_evaluation)
		    as (id bigint, ftb integer, reponse character varying[],  date_creation timestamp)
		loop
		    -- mise à jour
		    update contraintes.resultat_serie_ftb set reponse=rec_resultat_evaluation.reponse where 
		    id=$1 and ftb=rec_resultat_evaluation.ftb; 
		end loop;
	    end if;
	    

	end loop;


    end if;
    return true;	


end;*/

-- $1 : id resultat
declare
rec record;
rec_resultat record;
rec_best record;
nb_tentative integer;
nb_tentatives integer;
res_id integer;
score real;
score_courant real;
meilleure_tentative integer;
meilleur_identifiant bigint;
begin


    -- recup info resultat
    select into rec_resultat * from contraintes.af_get_resultat($1) 
    as (id bigint,formation integer,stagiaire integer,parcours integer,etape integer,date_debut timestamp, duree interval); 
    -- boucle sur les tentatives
    score:=NULL;
    meilleure_tentative:=NULL;
    meilleur_identifiant:= NULL;
    for rec in 
	select * from contraintes.resultat_tentative where 
	formation=rec_resultat.formation and 
	stagiaire=rec_resultat.stagiaire and 
	parcours=rec_resultat.parcours and 
	etape=rec_resultat.etape
	ORDER BY tentative DESC --ordre important pour garder la derniere si pas de meilleure
    loop
	-- recup score courant
	select into score_courant * from contraintes.af_get_resultat_serie_score_tentative(rec.id);
	raise notice '---------------score tentative %=%',rec.tentative,score_courant;

	--meilleur score
	if ((meilleure_tentative IS NULL) OR (score_courant >= score) ) then
	    score:=score_courant;
	    meilleure_tentative:=rec.tentative;
	    meilleur_identifiant:=rec.id;
	end if;


    end loop;
    raise notice '---------------meilleure tentative %=%',meilleure_tentative,score;
    -- meilleur resultat_tentative
    select into rec_best * from contraintes.af_get_resultat_tentative(meilleur_identifiant) 
    as (id bigint,formation integer,stagiaire integer,parcours integer,etape integer,date_debut timestamp, duree interval,tentative integer); 

	--enregistre dans resultat
	UPDATE contraintes.resultat SET
	duree= rec_best.duree
	WHERE id=$1;
	 raise notice '---------------duree finale =%',rec_best.duree;

	
    -- insertion dans resultat_serie
    for rec in
	select * from contraintes.af_get_resultat_serie_evaluations_tentative(rec_best.id) 
	--as (id bigint,evaluation integer,date_creation timestamp)
	as (id bigint,evaluation integer,date_debut timestamp,date_fin timestamp)
    loop
	insert into contraintes.resultat_serie(id,evaluation,date_debut,date_fin) 
	values($1,rec.evaluation,rec.date_debut,rec.date_fin);
	raise notice '---------------insert eval';
    end loop;

    -- Les evaluations (question_reponse et ftb)
    for rec in 
	select * from contraintes.resultat_serie_tentative_question_reponse where id=rec_best.id
    loop
	insert into contraintes.resultat_serie_question_reponse(id,question_reponse,question,reponse,coche) 
	values($1,rec.question_reponse,rec.question,rec.reponse,rec.coche);
	raise notice '---------------insert qr';
    end loop;
    for rec in 
	select * from contraintes.resultat_serie_tentative_ftb where id=rec_best.id
    loop
	insert into contraintes.resultat_serie_ftb(id,ftb,reponse) 
	values($1,rec.ftb,rec.reponse);
	raise notice '---------------insert ftb';
    end loop;


    	--supprime la date de début de l'étape maintenant qu'elle est sauvegardés
	--UPDATE contraintes.resultat SET duree = NULL
	--WHERE id=$1;
	--RAISE NOTICE 'RAZ duree id=%',$1;

	--supprime les évaludations du resultat maintenant qu'elles sont sauvegardés
	--DELETE FROM contraintes.resultat_serie
	--WHERE id=$1;
	
    return true;

end;$_$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_set_resultat_meilleure_tentative(bigint) OWNER TO pgsql;

--
-- TOC entry 8612 (class 0 OID 0)
-- Dependencies: 1542
-- Name: FUNCTION af_set_resultat_meilleure_tentative(bigint); Type: COMMENT; Schema: contraintes; Owner: pgsql
--

COMMENT ON FUNCTION af_set_resultat_meilleure_tentative(bigint) IS 'enregistre la meilleurs tentative pour une serie bloquante';


--
-- TOC entry 1543 (class 1255 OID 2596423)
-- Dependencies: 2983 5
-- Name: af_set_resultat_serie_debut(bigint, integer); Type: FUNCTION; Schema: contraintes; Owner: pgsql
--

CREATE FUNCTION af_set_resultat_serie_debut(bigint, integer) RETURNS timestamp without time zone
    AS $_$DECLARE
--$1 resultat
--$2 evaluation
new_oid OID;
date_deb timestamp;
BEGIN
	INSERT INTO contraintes.resultat_serie
	(id,evaluation)
	VALUES ($1,$2);
	
	--RECUPERE L'IDENTIFIANT DU NOUVEAU RESULTAT
	GET DIAGNOSTICS new_oid = RESULT_OID;

	select into date_deb date_debut from contraintes.resultat_serie where oid=new_oid;
	return date_deb;
	
END;$_$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_set_resultat_serie_debut(bigint, integer) OWNER TO pgsql;

--
-- TOC entry 1544 (class 1255 OID 2596424)
-- Dependencies: 2983 5
-- Name: af_set_resultat_serie_fin(bigint, integer); Type: FUNCTION; Schema: contraintes; Owner: pgsql
--

CREATE FUNCTION af_set_resultat_serie_fin(bigint, integer) RETURNS timestamp without time zone
    AS $_$DECLARE
--$1 resultat
--$2 evaluation
date_fin_return timestamp;
BEGIN

	select into date_fin_return date_fin 
	from contraintes.resultat_serie  
	WHERE id=$1 AND evaluation=$2;

	IF date_fin_return IS NULL THEN
		UPDATE contraintes.resultat_serie
		set date_fin = now()
		WHERE id=$1 AND evaluation=$2;
	
		select into date_fin_return date_fin 
		from contraintes.resultat_serie  
		WHERE id=$1 AND evaluation=$2;
		return date_fin_return;
	ELSE
		RAISE EXCEPTION 'la fin de l''evaluation a deja ete affectee res=% et id=%',$1,$2;
		RETURN NULL;
	END IF;
	
END; $_$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_set_resultat_serie_fin(bigint, integer) OWNER TO pgsql;

--
-- TOC entry 1545 (class 1255 OID 2596425)
-- Dependencies: 2983 5
-- Name: af_set_resultat_serie_ftb(bigint, integer, text); Type: FUNCTION; Schema: contraintes; Owner: pgsql
--

CREATE FUNCTION af_set_resultat_serie_ftb(bigint, integer, text) RETURNS boolean
    AS $_$DECLARE
--$1 resultat
--$2 ftb
--$3 reponse
BEGIN
	INSERT INTO contraintes.resultat_serie_ftb
	(id,ftb, reponse)
	VALUES ($1,$2,$3);
	
	RETURN FOUND;
END;$_$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_set_resultat_serie_ftb(bigint, integer, text) OWNER TO pgsql;

--
-- TOC entry 1546 (class 1255 OID 2596426)
-- Dependencies: 2983 5
-- Name: af_set_resultat_serie_qsrc(bigint, integer, integer[], integer[], integer[]); Type: FUNCTION; Schema: contraintes; Owner: pgsql
--

CREATE FUNCTION af_set_resultat_serie_qsrc(bigint, integer, integer[], integer[], integer[]) RETURNS boolean
    AS $_$DECLARE
--$1 resultat
--$2 qsrc
--$3 id questions 
--$4 id reponses
--$5 valeurs coche
ok integer:=0;
cpt integer:=1;
BEGIN

	IF (array_upper($3, 1) IS NULL) OR (array_upper($4, 1) IS NULL) THEN
		RAISE EXCEPTION 'Il est impossible qu''un qsrc (%) n''ai pas de réponse et/ou de question',$2;
	END IF;
	
	FOR i IN array_lower($3, 1) .. array_upper($3, 1)  
	LOOP

		FOR j IN array_lower($4, 1) .. array_upper($4, 1)  
		LOOP
			INSERT INTO contraintes.resultat_serie_question_reponse
			(id,question_reponse, question, reponse, coche)
			VALUES ($1,$2,$3[i],$4[j], CAST($5[cpt] AS BOOLEAN) );

			IF FOUND THEN ok:=ok+1; END IF;
			cpt:=cpt+1;
		END LOOP;
	END LOOP;

	RETURN ok=array_upper($5, 1);
END;$_$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_set_resultat_serie_qsrc(bigint, integer, integer[], integer[], integer[]) OWNER TO pgsql;

--
-- TOC entry 1547 (class 1255 OID 2596427)
-- Dependencies: 2983 5
-- Name: af_set_resultat_serie_question_reponse(bigint, integer, integer[], integer[], integer[]); Type: FUNCTION; Schema: contraintes; Owner: pgsql
--

CREATE FUNCTION af_set_resultat_serie_question_reponse(bigint, integer, integer[], integer[], integer[]) RETURNS boolean
    AS $_$DECLARE
--$1 resultat
--$2 question_reponse
--$3 id questions 
--$4 id reponses
--$5 valeur coche
ok integer:=0;

BEGIN
	--INSERT INTO contraintes.resultat_serie
	--(id,evaluation)
	--VALUES ($1,$2 );
	
	FOR i IN array_lower($3, 1) .. array_upper($3, 1)  
	LOOP

		FOR j IN array_lower($4, 1) .. array_upper($4, 1)  
		LOOP
			INSERT INTO contraintes.resultat_serie_question_reponse
			(id,question_reponse, question, reponse, coche)
			VALUES ($1,$2,$3[i],$4[j], CAST($5[j] AS BOOLEAN) );

			IF FOUND THEN ok:=ok+1; END IF;
		END LOOP;
	END LOOP;

	RETURN ok=array_upper($4, 1);
END;$_$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_set_resultat_serie_question_reponse(bigint, integer, integer[], integer[], integer[]) OWNER TO pgsql;

--
-- TOC entry 1548 (class 1255 OID 2596428)
-- Dependencies: 2983 5
-- Name: af_set_resultat_tentative(bigint); Type: FUNCTION; Schema: contraintes; Owner: pgsql
--

CREATE FUNCTION af_set_resultat_tentative(bigint) RETURNS boolean
    AS $_$-- $1 : id resultat
declare
rec record;
rec_resultat record;
nb_tentative integer;
nb_tentatives integer;
res_id integer;
new_id integer;
begin
    
    -- recup nb_tentative deja faite
    perform * from contraintes.af_get_resultat_etape_tentative($1) 
    as (id bigint,formation integer,stagiaire integer,parcours integer,etape integer,date_debut timestamp,duree interval,tentative integer);
    GET DIAGNOSTICS nb_tentative = ROW_COUNT;
    nb_tentatives:=nb_tentative + 1;

    -- insertion dans resultat_tentative
    select into rec * from contraintes.af_get_resultat($1) 
    as (id bigint,formation integer,stagiaire integer,parcours integer,etape integer,date_debut timestamp, duree interval); 
    
    insert into contraintes.resultat_tentative(formation,stagiaire,parcours,etape,date_debut,duree,tentative) 
    values(rec.formation,rec.stagiaire,rec.parcours,rec.etape,rec.date_debut,rec.duree,nb_tentatives);
    GET DIAGNOSTICS res_id = RESULT_OID;
    select into new_id id from contraintes.resultat_tentative where oid=res_id;

	
    -- insertion dans resultat_serie_tentative
    for rec in
	select * from contraintes.af_get_resultat_serie_evaluations($1) 
	--as (id bigint,evaluation integer,date_creation timestamp)
	as (id bigint,evaluation integer,date_debut timestamp,date_fin timestamp)
    loop
	insert into contraintes.resultat_serie_tentative(id,evaluation,date_debut,date_fin) 
	values(new_id,rec.evaluation,rec.date_debut,rec.date_fin);
    end loop;

    -- Les evaluations (question_reponse et ftb)
    for rec in 
	select * from contraintes.resultat_serie_question_reponse where id=$1
    loop
	insert into contraintes.resultat_serie_tentative_question_reponse(id,question_reponse,question,reponse,coche) 
	values(new_id,rec.question_reponse,rec.question,rec.reponse,rec.coche);
    end loop;
    for rec in 
	select * from contraintes.resultat_serie_ftb where id=$1
    loop
	insert into contraintes.resultat_serie_tentative_ftb(id,ftb,reponse) 
	values(new_id,rec.ftb,rec.reponse);
    end loop;


    	--supprime la date de fin de l'étape maintenant qu'elle est sauvegardés
	UPDATE contraintes.resultat SET duree = NULL
	WHERE id=$1;
	RAISE NOTICE 'RAZ duree id=%',$1;

	--supprime les évaludations du resultat maintenant qu'elles sont sauvegardés
	DELETE FROM contraintes.resultat_serie
	WHERE id=$1;
	
    return true;

end;$_$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_set_resultat_tentative(bigint) OWNER TO pgsql;

--
-- TOC entry 8619 (class 0 OID 0)
-- Dependencies: 1548
-- Name: FUNCTION af_set_resultat_tentative(bigint); Type: COMMENT; Schema: contraintes; Owner: pgsql
--

COMMENT ON FUNCTION af_set_resultat_tentative(bigint) IS 'stocke tous les resultats pour un identifiant de resultat (serie bloquante)';


--
-- TOC entry 1549 (class 1255 OID 2596429)
-- Dependencies: 2983 5
-- Name: af_set_salle(character varying); Type: FUNCTION; Schema: contraintes; Owner: pgsql
--

CREATE FUNCTION af_set_salle(character varying) RETURNS integer
    AS $_$-- $1 : libelle salle
declare
new_id int4;
res int4;
begin
    insert into contraintes.salle(libelle) values($1);
    --RECUPERE L'IDENTIFIANT De la nouvelle capacite
    GET DIAGNOSTICS new_id = RESULT_OID;
    SELECT INTO res id FROM contraintes.salle WHERE oid=new_id;
    return res;    
end;$_$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_set_salle(character varying) OWNER TO pgsql;

--
-- TOC entry 8621 (class 0 OID 0)
-- Dependencies: 1549
-- Name: FUNCTION af_set_salle(character varying); Type: COMMENT; Schema: contraintes; Owner: pgsql
--

COMMENT ON FUNCTION af_set_salle(character varying) IS 'enregistre une salle';


--
-- TOC entry 1906 (class 1255 OID 2596430)
-- Dependencies: 2983 5
-- Name: af_set_section(character varying, integer); Type: FUNCTION; Schema: contraintes; Owner: pgsql
--

CREATE FUNCTION af_set_section(character varying, integer) RETURNS integer
    AS $_$-- $1 : libelle
-- $2 : numero icone
declare
new_id int4;
res int4;
begin
    insert into contraintes.section(libelle,icone) values($1,$2);
    --RECUPERE L'IDENTIFIANT DU NOUVEL ESPACE
    GET DIAGNOSTICS new_id = RESULT_OID;
    SELECT INTO res id FROM contraintes.section WHERE oid=new_id;
    -- RAISE NOTICE 'insertion du bareme d''id: % (oid=%)',res, new_id;
    RETURN res;
end;$_$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_set_section(character varying, integer) OWNER TO pgsql;

--
-- TOC entry 8623 (class 0 OID 0)
-- Dependencies: 1906
-- Name: FUNCTION af_set_section(character varying, integer); Type: COMMENT; Schema: contraintes; Owner: pgsql
--

COMMENT ON FUNCTION af_set_section(character varying, integer) IS 'enregistre une section';


--
-- TOC entry 1550 (class 1255 OID 2596431)
-- Dependencies: 2983 5
-- Name: af_set_serie(character varying, integer, integer); Type: FUNCTION; Schema: contraintes; Owner: pgsql
--

CREATE FUNCTION af_set_serie(character varying, integer, integer) RETURNS integer
    AS $_$DECLARE
--$1 libelle
--$2 numero de bareme global
--$3 valeur du chrono global


res int4;
BEGIN	
	SELECT INTO res * FROM contraintes.af_set_serie($1,$2,$3,1);
		
	RETURN res;
END$_$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_set_serie(character varying, integer, integer) OWNER TO pgsql;

--
-- TOC entry 8625 (class 0 OID 0)
-- Dependencies: 1550
-- Name: FUNCTION af_set_serie(character varying, integer, integer); Type: COMMENT; Schema: contraintes; Owner: pgsql
--

COMMENT ON FUNCTION af_set_serie(character varying, integer, integer) IS 'Crée une série.';


--
-- TOC entry 1551 (class 1255 OID 2596432)
-- Dependencies: 2983 5
-- Name: af_set_serie(character varying, integer, integer, integer); Type: FUNCTION; Schema: contraintes; Owner: pgsql
--

CREATE FUNCTION af_set_serie(character varying, integer, integer, integer) RETURNS integer
    AS $_$DECLARE
--$1 libelle
--$2 numero de bareme global
--$3 valeur du chrono global
--$4 type de la liste
new_id int4;
res int4;
BEGIN
	--RAISE NOTICE 'libelle=% bareme=% valeur=%',$1,$2, $3;
	INSERT INTO contraintes.etape(libelle, type) VALUES ($1, 4);
	GET DIAGNOSTICS new_id = RESULT_OID;
	
	SELECT INTO res id FROM contraintes.etape WHERE oid=new_id;
	
	INSERT INTO contraintes.liste (id, type) VALUES (res, $4);
	
	INSERT INTO contraintes.serie(id, bareme, chrono) VALUES (res, $2, $3);
	RETURN res;
END$_$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_set_serie(character varying, integer, integer, integer) OWNER TO pgsql;

--
-- TOC entry 8627 (class 0 OID 0)
-- Dependencies: 1551
-- Name: FUNCTION af_set_serie(character varying, integer, integer, integer); Type: COMMENT; Schema: contraintes; Owner: pgsql
--

COMMENT ON FUNCTION af_set_serie(character varying, integer, integer, integer) IS 'FONCTION PRIVEE: Crée une série d''un type donné .';


--
-- TOC entry 1552 (class 1255 OID 2596433)
-- Dependencies: 2983 5
-- Name: af_set_serie_aleatoire(character varying, integer, integer, integer); Type: FUNCTION; Schema: contraintes; Owner: pgsql
--

CREATE FUNCTION af_set_serie_aleatoire(character varying, integer, integer, integer) RETURNS integer
    AS $_$declare
res int4;
begin
    SELECT INTO res * FROM contraintes.af_set_serie($1,$2,$3,1);
    insert into contraintes.serie_aleatoire(id,type) values(res,$4);
    RETURN res;
end;$_$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_set_serie_aleatoire(character varying, integer, integer, integer) OWNER TO pgsql;

--
-- TOC entry 8629 (class 0 OID 0)
-- Dependencies: 1552
-- Name: FUNCTION af_set_serie_aleatoire(character varying, integer, integer, integer); Type: COMMENT; Schema: contraintes; Owner: pgsql
--

COMMENT ON FUNCTION af_set_serie_aleatoire(character varying, integer, integer, integer) IS 'enregistre un serie aleatoire';


--
-- TOC entry 1553 (class 1255 OID 2596434)
-- Dependencies: 2983 5
-- Name: af_set_serie_aleatoire_melangee(integer, integer, integer); Type: FUNCTION; Schema: contraintes; Owner: pgsql
--

CREATE FUNCTION af_set_serie_aleatoire_melangee(integer, integer, integer) RETURNS boolean
    AS $_$-- $1 : serie
-- $2 : formation
-- $3 : parcours
begin
    -- isertion dans serie aleatoire
    insert into contraintes.serie_aleatoire(id,type) values($1,1);
    insert into contraintes.serie_aleatoire_melangee(serie,formation,parcours) 
    values($1,$2,$3);
    return found;
end;$_$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_set_serie_aleatoire_melangee(integer, integer, integer) OWNER TO pgsql;

--
-- TOC entry 8631 (class 0 OID 0)
-- Dependencies: 1553
-- Name: FUNCTION af_set_serie_aleatoire_melangee(integer, integer, integer); Type: COMMENT; Schema: contraintes; Owner: pgsql
--

COMMENT ON FUNCTION af_set_serie_aleatoire_melangee(integer, integer, integer) IS 'Enregistre une serie existante en mode aleatoire';


--
-- TOC entry 1554 (class 1255 OID 2596435)
-- Dependencies: 2983 5
-- Name: af_set_serie_aleatoire_melangee_evaluations(integer, integer, integer, integer); Type: FUNCTION; Schema: contraintes; Owner: pgsql
--

CREATE FUNCTION af_set_serie_aleatoire_melangee_evaluations(integer, integer, integer, integer) RETURNS boolean
    AS $_$-- $1 : serie
-- $2 : formation
-- $3 : parcours
-- $4 : stagiaire
declare
rec record;
precedent int4:=NULL;
ok boolean;
begin
    -- recuperation aleatoire des evaluations de la serie
    for rec in 
	select  $1, e_id, $2,$3,$4,e_type,cast(e_id * 0 + random()as integer) as ind 
	from contraintes.af_get_serie_evaluations($1) 
	as  (e_id int4, libelle varchar, serie int4, pere int4, commentaire varchar, bareme int4, chrono int4, points int4, e_type int4 )
	--left outer join contraintes.resultat_serie on (evaluation=e_id and id=$1)
	--where id is null order by ind limit 1
	order by ind
    
    loop
	insert into contraintes.serie_aleatoire_evaluations (serie,evaluation,formation,parcours,stagiaire,pere) 
	values ($1,rec.e_id,$2,$3,$4,precedent);
	precedent:=rec.e_id;
	if not found then
	    ok:=false;
	end if;
    end loop;
    --return ok;
    return true;
end;$_$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_set_serie_aleatoire_melangee_evaluations(integer, integer, integer, integer) OWNER TO pgsql;

--
-- TOC entry 8633 (class 0 OID 0)
-- Dependencies: 1554
-- Name: FUNCTION af_set_serie_aleatoire_melangee_evaluations(integer, integer, integer, integer); Type: COMMENT; Schema: contraintes; Owner: pgsql
--

COMMENT ON FUNCTION af_set_serie_aleatoire_melangee_evaluations(integer, integer, integer, integer) IS 'remplit la table serie_aleatoire_melangee';


--
-- TOC entry 1907 (class 1255 OID 2596436)
-- Dependencies: 2983 5
-- Name: af_set_serie_aleatoire_multiserie_configuration(integer, integer[]); Type: FUNCTION; Schema: contraintes; Owner: pgsql
--

CREATE FUNCTION af_set_serie_aleatoire_multiserie_configuration(integer, integer[]) RETURNS boolean
    AS $_$declare
i int4;
begin
for i in array_lower($2,1) .. array_upper($2,1)
loop
    insert into contraintes.serie_aleatoire_multiserie values
    ($1,$2[i][1],$2[i][2],$2[i][3]);
end loop;
return true;
end;$_$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_set_serie_aleatoire_multiserie_configuration(integer, integer[]) OWNER TO pgsql;

--
-- TOC entry 8635 (class 0 OID 0)
-- Dependencies: 1907
-- Name: FUNCTION af_set_serie_aleatoire_multiserie_configuration(integer, integer[]); Type: COMMENT; Schema: contraintes; Owner: pgsql
--

COMMENT ON FUNCTION af_set_serie_aleatoire_multiserie_configuration(integer, integer[]) IS 'enregistre la configuration d''une serie aleatoire multiserie';


--
-- TOC entry 1555 (class 1255 OID 2596437)
-- Dependencies: 2983 5
-- Name: af_set_serie_aleatoire_multiserie_evaluations(integer, integer, integer, integer); Type: FUNCTION; Schema: contraintes; Owner: pgsql
--

CREATE FUNCTION af_set_serie_aleatoire_multiserie_evaluations(integer, integer, integer, integer) RETURNS boolean
    AS $_$-- $1 : serie
-- $2 : formation
-- $3 : parcours
-- $4 : individu
declare
rec record;
rec2 record;
precedent int4:=NULL;
nb_insert integer:=0;
nb_to_insert integer:=0;
begin
    -- Boucle sur la recuperation de la configuration
    for rec in 
	select * from contraintes.af_get_serie_aleatoire_series_associations($1) 
        as (serie int4,serie_source int4,nb_evaluation int4,type_evaluations int4)
    loop
	-- ici on recupere aleatoirement les evaluations de la serie source
	nb_to_insert:=nb_to_insert+rec.nb_evaluation;
	for rec2 in 
	    select id,id * 0 + random() as ordre 
	    from contraintes.af_get_serie_evaluations(rec.serie_source)
	    as (id int4, libelle varchar, serie int4, pere int4, commentaire varchar, bareme int4, chrono int4, points int4, type int4 )
	    
	    where type=rec.type_evaluations order by ordre limit rec.nb_evaluation	
	loop
	    insert into contraintes.serie_aleatoire_evaluations (serie,evaluation,formation,parcours,stagiaire,pere,source) 
	    values ($1,rec2.id,$2,$3,$4,precedent,rec.serie_source);
	    
	    if not found then
		RETURN FALSE;
	    else
		nb_insert:=nb_insert+1;
	    end if;
	    precedent:=rec2.id;
	end loop;

    end loop;

RAISE NOTICE '-------------fin de la fonction: % == %',nb_insert,nb_to_insert;
    return nb_insert=nb_to_insert;   

end; $_$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_set_serie_aleatoire_multiserie_evaluations(integer, integer, integer, integer) OWNER TO pgsql;

--
-- TOC entry 8637 (class 0 OID 0)
-- Dependencies: 1555
-- Name: FUNCTION af_set_serie_aleatoire_multiserie_evaluations(integer, integer, integer, integer); Type: COMMENT; Schema: contraintes; Owner: pgsql
--

COMMENT ON FUNCTION af_set_serie_aleatoire_multiserie_evaluations(integer, integer, integer, integer) IS 'rempli la table serie_aleatoire_evaluation pour une serie aleatoire multiserie';


--
-- TOC entry 1556 (class 1255 OID 2596438)
-- Dependencies: 2983 5
-- Name: af_set_serie_aleatoire_multitheme_configuration(integer, integer[]); Type: FUNCTION; Schema: contraintes; Owner: pgsql
--

CREATE FUNCTION af_set_serie_aleatoire_multitheme_configuration(integer, integer[]) RETURNS boolean
    AS $_$declare
i int4;
tmp int4:=NULL;
begin
 
for i in array_lower($2,1) .. array_upper($2,1)
loop
    IF ($2[i][1]!=tmp OR tmp IS NULL)THEN
	tmp:=$2[i][1];
	RAISE NOTICE 'enregistre nveau theme: %',tmp;
	PERFORM * from contraintes.af_set_categorie_element_theme(19,tmp,$1);
    ELSE
	RAISE NOTICE 'pas nveau theme: %',tmp;
    END IF;
	
    insert into contraintes.serie_aleatoire_multitheme values
    ($1,$2[i][1],$2[i][2],$2[i][3]);
end loop;
return true;
end;$_$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_set_serie_aleatoire_multitheme_configuration(integer, integer[]) OWNER TO pgsql;

--
-- TOC entry 8639 (class 0 OID 0)
-- Dependencies: 1556
-- Name: FUNCTION af_set_serie_aleatoire_multitheme_configuration(integer, integer[]); Type: COMMENT; Schema: contraintes; Owner: pgsql
--

COMMENT ON FUNCTION af_set_serie_aleatoire_multitheme_configuration(integer, integer[]) IS 'enregistre la configuration d''une serie aleatoire multitheme';


--
-- TOC entry 1557 (class 1255 OID 2596439)
-- Dependencies: 2983 5
-- Name: af_set_serie_aleatoire_multitheme_evaluations(integer, integer, integer, integer); Type: FUNCTION; Schema: contraintes; Owner: pgsql
--

CREATE FUNCTION af_set_serie_aleatoire_multitheme_evaluations(integer, integer, integer, integer) RETURNS boolean
    AS $_$-- $1 : serie
-- $2 : formation
-- $3 : parcours
-- $4 : individu
declare
rec record;
rec2 record;
precedent int4:=NULL;
ok bool:=true;
begin
    -- Boucle sur la recuperation de la configuration
    for rec in 
	select * from contraintes.af_get_serie_aleatoire_themes_associations($1) 
        as (serie int4,theme_source int4,nb_evaluation int4,type_evaluations int4)
    loop
	-- ici on recupere aleatoirement les evaluations du theme source
	for rec2 in 
	    select id,id * 0 + random() as ordre 
	    from contraintes.af_get_theme_evaluations(rec.theme_source)
	    as (id int4, type int4 )
	    
	    where type=rec.type_evaluations order by ordre limit rec.nb_evaluation	
	loop
	    insert into contraintes.serie_aleatoire_evaluations (serie,evaluation,formation,parcours,stagiaire,pere) 
	    values ($1,rec2.id,$2,$3,$4,precedent);
	    precedent:=rec2.id;
	    if not found then
		ok:=false;
	    end if;
	    
	end loop;

    end loop;

    return ok;   

end;$_$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_set_serie_aleatoire_multitheme_evaluations(integer, integer, integer, integer) OWNER TO pgsql;

--
-- TOC entry 8641 (class 0 OID 0)
-- Dependencies: 1557
-- Name: FUNCTION af_set_serie_aleatoire_multitheme_evaluations(integer, integer, integer, integer); Type: COMMENT; Schema: contraintes; Owner: pgsql
--

COMMENT ON FUNCTION af_set_serie_aleatoire_multitheme_evaluations(integer, integer, integer, integer) IS 'remplit la table serie_aleatoire pour une serie aleatoire multitheme';


--
-- TOC entry 1908 (class 1255 OID 2596440)
-- Dependencies: 2983 5
-- Name: af_set_serie_bloquante_configuration(integer, integer, integer, integer, integer, integer, boolean, boolean); Type: FUNCTION; Schema: contraintes; Owner: pgsql
--

CREATE FUNCTION af_set_serie_bloquante_configuration(integer, integer, integer, integer, integer, integer, boolean, boolean) RETURNS boolean
    AS $_$-- $1 : serie
-- $2 : formation
-- $3 : parcours
-- $4 : seuil
-- $5 : etape retour
-- $6 : tentative
-- $7 : correction
-- $8 : blocage parcours
begin
    insert into contraintes.serie_bloquante (serie,formation,parcours,seuil,etape_retour,tentatives,correction,blocage_parcours) 
    values($1,$2,$3,$4,$5,$6,$7,$8);
    return found;
end;$_$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_set_serie_bloquante_configuration(integer, integer, integer, integer, integer, integer, boolean, boolean) OWNER TO pgsql;

--
-- TOC entry 8643 (class 0 OID 0)
-- Dependencies: 1908
-- Name: FUNCTION af_set_serie_bloquante_configuration(integer, integer, integer, integer, integer, integer, boolean, boolean); Type: COMMENT; Schema: contraintes; Owner: pgsql
--

COMMENT ON FUNCTION af_set_serie_bloquante_configuration(integer, integer, integer, integer, integer, integer, boolean, boolean) IS 'enregistre la configuration d''une serie bloquante';


--
-- TOC entry 1909 (class 1255 OID 2596441)
-- Dependencies: 2983 5
-- Name: af_set_serie_evaluation(integer, integer, integer, character varying, integer, integer, integer); Type: FUNCTION; Schema: contraintes; Owner: pgsql
--

CREATE FUNCTION af_set_serie_evaluation(integer, integer, integer, character varying, integer, integer, integer) RETURNS integer
    AS $_$DECLARE
--$1 evaluation
--$2 serie
--$3 pere
--$4 commentaire
--$5 bareme
--$6 chrono
--$7 points

BEGIN
	INSERT INTO contraintes.serie_evaluations  (evaluation, serie,pere,commentaire,bareme,chrono, points)
	VALUES($1,$2,$3,$4,$5,$6,$7);

	RETURN $1;
END


$_$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_set_serie_evaluation(integer, integer, integer, character varying, integer, integer, integer) OWNER TO pgsql;

--
-- TOC entry 8645 (class 0 OID 0)
-- Dependencies: 1909
-- Name: FUNCTION af_set_serie_evaluation(integer, integer, integer, character varying, integer, integer, integer); Type: COMMENT; Schema: contraintes; Owner: pgsql
--

COMMENT ON FUNCTION af_set_serie_evaluation(integer, integer, integer, character varying, integer, integer, integer) IS 'Associe une evaluation à une série.';


--
-- TOC entry 1558 (class 1255 OID 2596442)
-- Dependencies: 2983 5
-- Name: af_set_sondage(character varying, integer, boolean, integer[], integer[]); Type: FUNCTION; Schema: contraintes; Owner: postgres
--

CREATE FUNCTION af_set_sondage(character varying, integer, boolean, integer[], integer[]) RETURNS integer
    AS $_$DECLARE
--$1 libelle
--$2 type
--$3 radio
--$4 questions
--$5 reponses

i integer;
b_value boolean;
val_id integer;
BEGIN	

	SELECT INTO val_id * FROM contraintes.af_set_question_reponse($1, $2, $3, $4,$5 );

	

	RETURN val_id;

END$_$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_set_sondage(character varying, integer, boolean, integer[], integer[]) OWNER TO postgres;

--
-- TOC entry 8647 (class 0 OID 0)
-- Dependencies: 1558
-- Name: FUNCTION af_set_sondage(character varying, integer, boolean, integer[], integer[]); Type: COMMENT; Schema: contraintes; Owner: postgres
--

COMMENT ON FUNCTION af_set_sondage(character varying, integer, boolean, integer[], integer[]) IS 'Créer un Sondage complet';


--
-- TOC entry 1559 (class 1255 OID 2596443)
-- Dependencies: 2983 5
-- Name: af_set_src(character varying, integer, character varying, boolean, integer[], integer[]); Type: FUNCTION; Schema: contraintes; Owner: pgsql
--

CREATE FUNCTION af_set_src(character varying, integer, character varying, boolean, integer[], integer[]) RETURNS integer
    AS $_$DECLARE
--$1 libelle
--$2 type (4 ou 5)
--$3 question commmune
--$4 radio?
--$5 questions
--$6 reponses
val_id int4;
BEGIN

	SELECT INTO val_id * FROM contraintes.af_set_question_reponse($1, $2, $4, $5,$6 );
	INSERT INTO contraintes.qsrc (id, question) VALUES (val_id, $3);

	RETURN val_id;
END$_$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_set_src(character varying, integer, character varying, boolean, integer[], integer[]) OWNER TO pgsql;

--
-- TOC entry 1560 (class 1255 OID 2596444)
-- Dependencies: 2983 5
-- Name: af_set_test(character varying, boolean, boolean, integer, integer, integer); Type: FUNCTION; Schema: contraintes; Owner: pgsql
--

CREATE FUNCTION af_set_test(character varying, boolean, boolean, integer, integer, integer) RETURNS integer
    AS $_$DECLARE
--$1 libelle
--$2 dynamique
--$3 continu
--$4 media
--$5 hauteur
--$6 largeur
res int4;
new_id int4;
BEGIN 
	INSERT INTO contraintes.etape(libelle, type) VALUES ($1, 4);
	GET DIAGNOSTICS new_id = RESULT_OID;
	
	SELECT INTO res id FROM contraintes.etape WHERE oid=new_id;
	
	INSERT INTO contraintes.liste (id, type) VALUES (res, 3);
	
	INSERT INTO contraintes.test(id, dynamique, continu) VALUES (res, $2, $3);

	IF $4 IS NOT NULL THEN
		INSERT INTO contraintes.media_test
		(test, media, hauteur, largeur)
		VALUES (res,$4, $5, $6);
	END IF;

	RETURN res;
END$_$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_set_test(character varying, boolean, boolean, integer, integer, integer) OWNER TO pgsql;

--
-- TOC entry 1561 (class 1255 OID 2596445)
-- Dependencies: 2983 5
-- Name: af_set_test_positionnement(integer, integer, integer); Type: FUNCTION; Schema: contraintes; Owner: pgsql
--

CREATE FUNCTION af_set_test_positionnement(integer, integer, integer) RETURNS boolean
    AS $_$DECLARE
--$1 test
--$2 positionnement
--$3 id du positionnement pere
BEGIN
	--INSERT INTO contraintes.test_positionnements (test, positionnement, pere)
	--VALUES ($1, $2, $3);
	--RAISE EXCEPTION '% % % ',$1, $2, $3;
	PERFORM * FROM contraintes.af_gen_set_element('contraintes.test_positionnements', 'positionnement', $3, $2, ', test ', ','||$1, ' AND test='||$1);
	RETURN FOUND;

END;$_$
    LANGUAGE plpgsql;


ALTER FUNCTION contraintes.af_set_test_positionnement(integer, integer, integer) OWNER TO pgsql;

--
-- TOC entry 1562 (class 1255 OID 2596446)
-- Dependencies: 2983 5
-- Name: af_set_theme(character varying, integer); Type: FUNCTION; Schema: contraintes; Owner: postgres
--

CREATE FUNCTION af_set_theme(character varying, integer) RETURNS integer
    AS $_$DECLARE
new_id int4;
res int4;
B