<?php
/*
	This file is part of Astairs.

    Astairs is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    any later version.

    Astairs is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Astairs.  If not, see <http://www.gnu.org/licenses/>.

	Copyright (C) 2006, 2007, 2008, 2009 AFIDE
    
	Auteurs:

	Said Ladjani <sladjani@yahoo.fr>
	Remi Cocquet <remi.cocquet@gmail.com>

*/

/**
*  Biblioth�que de fonctions pour le front et le back
*	@package root
*/

//--------------------------------------------------------------------------------------------
//          VARIABLES POUR FOAD ET PGR
//--------------------------------------------------------------------------------------------

// VARIABLES POUR L'AFFICHAGE FRONT OFFICE
$mode_defaut = 0;
$mode_titre = 1;
$mode_finpage = 2;

// VARIABLES POUR QCM ALEATOIRE
$monotheme = 1;
$multitheme = 2;

//--------------------------------------------------------------------------------------------
//              FONCTIONS POUR LES  SESSIONS
//--------------------------------------------------------------------------------------------
/**
 verification de l'identite par la session
*/
function verifSession($db, & $session) {
	// on recherche l'identification de la session
	//  afin de retrouver l'user_id du stagiaire ou
	//  du formateur.
	// 6heures d'authentification
	//	print $session;
	//	$session=$HTTP_COOKIE_VARS["session"];
	//	print "uuu".$session;
	$res = pg_exec($db, "select * from session where session='$session';");
	if (pg_numrows($res) != 1) {
		die("Erreur : vous n'�tes pas identifi�(e)");
		//		header("Location:www.interformation.net/cherbourg/login.php3?bad=1");
	}
	// +6heures
	setcookie("session", $session, time() + 20400);
	//	setcookie("session",$session,time()+20400,"/");

	return $res;
}

/**

*/
function verifier_session() {
	global $chemin_fo;
	global $server;
	global $nombase;
	global $s_ip_client;
	global $s_time;
	global $s_login;
	global $s_password;
	global $id_client;

	if ($s_login == "" || $s_password == ""){

		return (0);
        }
	if ($s_ip_client != get_ip()){

		return (0);
        }
	//lecture du fichier ayant pour nom le login et contenant l'ip_client + date de connexion
	$fp = fopen("$chemin_fo/connexion/$s_login", "r");
	//$val_ip=fgets($fp,1024);
	$info_client = fgets($fp, 1024);
	$tabinfo = explode("|", $info_client);
	$val_ip = $tabinfo[0];
	$val_time = $tabinfo[1];
	fclose($fp);
	if ($val_ip != $s_ip_client || $val_time != $s_time){

		return (0);
        }

	
		connectDB();

	

	//$res = pg_query("select * from UTILISATEURS where login='$s_login' and password='$s_password';");
	$res=get_individu($s_login,$s_password);
        //$res = pg_query("select * from UTILISATEURS where login like '$s_login' and password like '$s_password';");
	$cpt = pg_num_rows($res);

	pg_close($db);
	unset($db);
	unset($res);
       //echo "s_log='$s_login' et pass='$s_password' et nombase=$nombase et server=$server<br>";
	if ($cpt == 0){
            /*
            print("<script language=\"Javascript\">
                alert('coucou');
                </script>
                ");
            */
		return (0);
        }
	else{
		if(pg_fetch_result($res,0,0)>0)
			return (1);
		else
			return (0);
		
	}
}

/**

*/
function get_ip() {
	//On recupere l'IP dans le header
	$SimpleIP = (isset($REMOTE_ADDR) ? $REMOTE_ADDR : getenv("REMOTE_ADDR"));

	$TrueIP = (isset($HTTP_X_FORWARDED_FOR) ? $HTTP_X_FORWARDED_FOR : getenv("HTTP_X_FORWARDED_FOR"));
	if ($TrueIP == "")
		$TrueIP = (isset($HTTP_X_FORWARDED) ? $HTTP_X_FORWARDED : getenv("HTTP_X_FORWARDED"));
	if ($TrueIP == "")
		$TrueIP = (isset($HTTP_FORWARDED_FOR) ? $HTTP_FORWARDED_FOR : getenv("HTTP_FORWARDED_FOR"));
	if ($TrueIP == "")
		$TrueIP = (isset($HTTP_FORWARDED) ? $HTTP_FORWARDED : getenv("HTTP_FORWARDED"));
	$GetProxy = ($TrueIP == "" ? "0" : "1");

	if ($GetProxy == "0") {
		$TrueIP = (isset($HTTP_VIA) ? $HTTP_VIA : getenv("HTTP_VIA"));
		if ($TrueIP == "")
			$TrueIP = (isset($HTTP_X_COMING_FROM) ? $HTTP_X_COMING_FROM : getenv("HTTP_X_COMING_FROM"));
		if ($TrueIP == "")
			$TrueIP = (isset($HTTP_COMING_FROM) ? $HTTP_COMING_FROM : getenv("HTTP_COMING_FROM"));
		if ($TrueIP != "")
			$GetProxy = "2";
	};

	if ($TrueIP == $SimpleIP)
		$GetProxy = "0";

	//Recupere la veritable IP si trouvee, sinon  Return the true IP if found, else the proxy IP with a 'p' at the begining
	switch ($GetProxy) {
		case '0' :
			// Veritable IP sans le proxy
			$IP = $SimpleIP;
			break;
		case '1' :
			$b = ereg("^([0-9]{1,3}\.){3,3}[0-9]{1,3}", $TrueIP, $IP_array);
			if ($b && (count($IP_array) > 0)) {
				// Veritable IP derriere le proxy
				$IP = $IP_array[0];
			} else {
				// Proxy IP
				$IP = "p".$SimpleIP;
			};
			break;
		case '2' :
			// Proxy IP
			$IP = "p".$SimpleIP;
	};

	return $IP;
}



//--------------------------------------------------------------------------------------------
//              FONCTIONS POUR LA VERSION POSTGRES
//--------------------------------------------------------------------------------------------
function set_default_version($choix_version = "") {
    global $root;
   	$version_def=$root."/conf/generated/default_version.php";
    //Si le fichier default_lang.php3 n'existe pas
    if (!file_exists($version_def)) {
        //On definie VERSION pour le sch�ma public
        //$version_postgres=version_postgres();
        $version_public= version_postgres() +1;
        //$version_public .=".0.0";
		$version_public=round($version_public);
        $contenu = "<?php\n";
        $contenu.= "define(\"VERSION\",\"$version_public\");\n";
        $contenu.= "?>\n";
        $fp = @ fopen("$version_def", "w");
        if (!$fp)
            die("Erreur, impossible de cr&eacute;er le fichier default_version.php");
        fwrite($fp, $contenu);
        fclose($fp);
   }
   else {
        if ($choix_version != "") {
            //print "versuion CHOISIE<BR>";
            $contenu = "<"."?"."php\n";
            $contenu.= "define(\"VERSION\",\"$choix_version\");\n";
            $contenu.= "?".">\n";
            $fp = @ fopen("$version_def", "w");
            if (!$fp)
                die("Erreur, impossible de cr&eacute;er le fichier default_lang.php3");
            fwrite($fp, $contenu);
            fclose($fp);
        }
    }
}
function set_default_version_base(){
	global $root;
	$version_def=$root."/conf/generated/default_version_base.php";
	if(!file_exists($version_def)){
		$version_postgres=version_postgres();
		$version_postgres=round($version_postgres);
		$contenu="<?php\n";
		$contenu .="define(\"VERSION_BASE\",\"$version_postgres\");\n";
		$contenu .="?>\n";
		$fp=fopen("$version_def","w");
		if(!$fp)
			die("Erreur,impossibele de cr�er le fichier default_version_base.php");
		fwrite($fp,$contenu);
		fclose($fp);
	}
}


//--------------------------------------------------------------------------------------------
//              FONCTIONS POUR LE MULTILINGUE
//--------------------------------------------------------------------------------------------

/**
	LECTURE DU REPERTOIRE LANG POUR SAVOIR LES LANGUES DISPONIBLES
	Retourne un tableau contenant les chemins vers les langues disponibles
	@return array() un tableau contenant les chemins vers les langues disponibles
*/
function available_lang() {
	global $root;
	global $serverback;

	$lang_dispo = array();
	$badRep = array(".", "..");
	$lang_bo = $root."/langues/";

	if ($dirLang = opendir($lang_bo)) {
		$i = 0;
		while ($repLang = readdir($dirLang)) {
			$cheminRepLang = $lang_bo.$repLang;
			if (is_dir($cheminRepLang) && !in_array($repLang, $badRep)) {
				$lang_dispo[$i] = $repLang;
				//$lang_dispo[$i] = $repLang;
				$i ++;
			}
		}
	} else
		print die("Impossible de lire le r&eacute;pertoire des langues");

	return ($lang_dispo);
}

/**
	Met en place le fichier /lang/default_lang.php3
	Qui contient la variable MY_LANG precisant la langue a utiliser
	Si pas de parametre prend la premiere langue disponible
*/
function set_default_lang($choix_lang = "") {
	global $root;
	$lang_def = $root."langues/default_lang.php";
	//Si le fichier default_lang.php3 n'existe pas
	if (!file_exists($lang_def)) {
		//On recupere les langues disponibles
		$lang_dispo = available_lang();
		if (count($lang_dispo) > 0) {
			//print "LANGUE DEFAUT<BR>";
			//On prend la premiere langue disponible par defaut
			$contenu = "<?php\n";
			$contenu.= "define(\"MY_LANG\",\"$lang_dispo[0]\");\n";
			$contenu.= "?".">\n";
			$fp =  fopen("$lang_def", "w");
			if (!$fp)
				die("Erreur, impossible de cr&eacute;er le fichier default_lang.php");
			fwrite($fp, $contenu);
			fclose($fp);
		} else
			die("Erreur, il semble n'y avoir aucun fichier de langue");
	} else {
		if ($choix_lang != "") {
			//print "LANGUE CHOISIE<BR>";
			$contenu = "<"."?"."php\n";
			$contenu.= "define(\"MY_LANG\",\"$choix_lang\");\n";
			$contenu.= "?".">\n";
			$fp =  fopen("$lang_def", "w");
			if (!$fp)
				die("Erreur, impossible de cr&eacute;er le fichier default_lang.php");
			fwrite($fp, $contenu);
			fclose($fp);
		}

	}
}

/**
	LECTURE DU REPERTOIRE STYLE POUR SAVOIR LES STYLES DISPONIBLES
	Retourne un tableau contenant les chemins vers les styles disponibles
	@return array() un tableau contenant les chemins vers les style disponibles
*/
function available_style() {
	global $chemin_bo;
	global $serverback;

	$style_dispo = array();
	$badRep = array(".", "..");
	$style_bo = $chemin_bo."/styles/";
	if ($dirStyle = opendir($style_bo)) {
		$i = 0;
		while ($repStyle = readdir($dirStyle)) {
			$cheminRepStyle = $style_bo.$repStyle;
			if (is_dir($cheminRepStyle) && !in_array($repStyle, $badRep)) {
				$style_dispo[$i] = $repStyle;
				$i ++;
			}
		}
	} else
		print die("Impossible de lire le r&eacute;pertoire des styles");

	return ($style_dispo);
}

/**
	Met en place le fichier /lang/default_style.php
	Qui contient la variable MY_STYLE precisant le style a utiliser
	Si pas de parametre prend le premier style disponible
*/
function set_default_style($choix_style = "") {
	global $chemin_bo;
	$style_def = $chemin_bo."/style/default_style.php";
	//Si le fichier default_style.php3 n'existe pas
	if (!file_exists($style_def)) {
		//On recupere les langues disponibles
		$style_dispo = available_style();
		if (count($style_dispo) > 0) {
			//On prend le premier style disponible par defaut
			$contenu = "<?php\n";
			$contenu.= "define(\"MY_STYLE\",\"$style_dispo[0]\");\n";
			$contenu.= "?>\n";
			$fp = @ fopen("$style_def", "w");
			if (!$fp)
				die("Erreur, impossible de cr&eacute;er le fichier default_style.php");
			fwrite($fp, $contenu);
			fclose($fp);
		} else
			die("Erreur, il semble n'y avoir aucun fichier de style");
	} else {
		if ($choix_style != "") {
			$contenu = "<"."?"."php\n";
			$contenu.= "define(\"MY_STYLE\",\"$choix_style\");\n";
			$contenu.= "?".">\n";
			$fp = @ fopen("$style_def", "w");
			if (!$fp)
				die("Erreur, impossible de cr&eacute;er le fichier default_style.php");
			fwrite($fp, $contenu);
			fclose($fp);
		}

	}
}

/**
	fonction formater_date($tab,$langue,$annee='Y')
	renvoie la date format�e en fonction de la langue
*/
function formater_date($tab, $langue, $annee = 'Y') {
	//print_r($tab);
	if ($annee == 'y')
		$tab[0] = substr("$tab[0]", 2);
	switch ($langue) {
		case "french" :
		case 1 :
			$dt = $tab[2]."/".$tab[1]."/".$tab[0];
			break;
		case "english" :
		case 2 :
			$dt = $tab[1]."/".$tab[2]."/".$tab[0];
			break;
		default :
			$dt = $tab[1]."/".$tab[2]."/".$tab[0];
	}
	return $dt;
}

/**
	 renvoie la date format�e en fonction de la langue (sans l'ann�e)
*/
function formater_date_mini($tab, $langue) {
	//debug
	//echo "tab[2]=$tab[2] et tab[1]=$tab[1] et langue=$langue<br>";
	switch ($langue) {
		case "french" :
			$dt = $tab[2]."-".$tab[1];
			break;
		case "english" :
			$dt = $tab[1]."-".$tab[2];
			break;
		default :
			$dt = $tab[1]."-".$tab[2];
	}
	return $dt;
}

/**
	 fonction pour traduction de la langue
*/
function traduction($langue) {
	global $MSG_1594, $MSG_1595, $MSG_1596, $MSG_1597, $MSG_1598,$MSG_2175,$MSG_2176;
	switch ($langue) {
		case 'french' :
			$langue_option = $MSG_1594;
			break;
		case 'english' :
			$langue_option = $MSG_1595;
			break;
		case 'chinese' :
			$langue_option = $MSG_1596;
			break;
		case 'japanese' :
			$langue_option = $MSG_1597;
			break;
		case 'korean' :
			$langue_option = $MSG_1598;
			break;
            case 'russian' :
			$langue_option = $MSG_2175;
			break;
		case 'sudan' :
			$langue_option = $MSG_2176;
			break;
	}
	return $langue_option;
}

//-----------------------------------------------------------------------------------------
//              FONCTIONS POUR LES CLASSES ET FILIERES
// NOTE : Les 2 fonctions suivantes servent � la fonction de remplissage
//-----------------------------------------------------------------------------------------
/**
	 Fonction nom_du($num,$db,$libelle)
	Action : retourne le nom du groupe ou du cours suivant la valeur
		de $libelle ("groupe" ou "cours")
*/
function nom_du($num, $db, $libelle) {
	//initialisation des variables
	$gestab = "gestion"."$libelle";
	$gestchamp = "num_gest_"."$libelle";
	$adrtab = "adr"."$libelle";
	$res = pg_exec($db, "select * from $gestab where $gestchamp='$num';");
	$row = pg_fetch_row($res, 0);
	$nbchamp = pg_numfields($res);
	//recup de la feuille
	$indice = 0;
	while ($indice < $nbchamp) {
		if ($row[$indice] == 0)
			break;
		$indice ++;
	}
	$i = $indice -1;
	$restable = pg_exec($db, "select nomtable from $adrtab where niveau='$i';");
	$rowtable = pg_fetch_row($restable, 0);
	//info table
	$resinfo = pg_exec($db, "select * from $rowtable[0];");
	$rowinfo = pg_fetch_row($resinfo, 0);
	$champ_num = pg_fieldname($resinfo, 0);
	$champ_libelle = pg_fieldname($resinfo, 1);
	$resnom = pg_exec($db, "select $champ_libelle from $rowtable[0] where $champ_num='$row[$i]';");
	$rownom = pg_fetch_row($resnom, 0);
	return $rownom[0];
}

/**
 	Fonction niveau_du($num,$db,$libelle)
 	Action : retourne le niveau du groupe ou du cours suivant la valeur
	de $libelle ("groupe" ou "cours")
*/
function niveau_du($num, $db, $libelle) {
	//init
	$gestab = "gestion"."$libelle";
	$gestchamp = "num_gest_"."$libelle";
	$res = pg_exec($db, "select * from $gestab where $gestchamp='$num';");
	$row = pg_fetch_row($res, 0);
	$nbchamp = pg_numfields($res);
	//recup de la feuille
	$indice = 0;
	while ($indice < $nbchamp) {
		if ($row[$indice] == 0)
			break;
		$indice ++;
	}
	$i = $indice -1;
	return $i;
}

/**
 	Fonction groupe_en_format

	Action : retourne vrai si le groupe est en formation faux sinon
*/
function groupe_en_formation($gestgp, $base="") {
	echo "groupe_en_formation($gestgp, $base): requete a modifier!!!!!!<br>";
	//$resgp_parcours = pg_exec($db, "select distinct gp_num_groupe from gestionparcours where gp_num_groupe='$gestgp';");
        $resgp_parcours = pg_query("select distinct g_num_gest_g from gestionnaire where g_num_gest_g='$gestgp';");
	if (pg_numrows($resgp_parcours) == 0) {
		//il faut tester si un de ses sous-groupe est en formation
		$res =  pg_query( "select * from classe where id_pere='$gestgp';");
		while ($row = pg_fetch_array($res)) {
			$gestgp = $row["id"];
			return (groupe_en_formation($gestgp));
		}
		return false;

	} else
		return true;
}

/**
 * Teste si 1 classe est supprimable
 * Condition : la classe ni aucun de ses fils ne sont en formation
 * @param integer : classe
 * @return bool : true si supprimable,false sinon
 */
 function is_classe_supprimable($classe){
 	if(!fk_finder('classe','id',$classe)){
 	
 		// boucle sur les classes fils et test si supprimable
 		
 		$res_classe_fils=get_classe_fils($classe);
 		$nb=pg_num_rows($res_classe_fils);
 		//echo "nb=$nb<br>";
 		for($i=0;$i<$nb;$i++){
 			$row=pg_fetch_row($res_classe_fils,$i);
 			if(fk_finder('classe','id',$row[0]))
 				return false;
 				
 			
 		}
 		return true;
 	}
 	return false;
 	
 	
 }

/**
 	Fonction libelle($num,$db,$table)
 	Action : retourne le nom du groupe ou du cours suivant la valeur
	de $table ("classe" ou "filiere")
	@deprecated 
*/
function libelle($num, $db, $table) {
	print("La fonction libelle() du fichier dbpostgres fonction est d�pr�ci�!");
	$parent = $num;
	while ($parent != 0) {
		$req = "select * from $table where id='$parent' ";
		//$res=pg_exec($db,"select * from $table where id='$parent' ;");
		$res = pg_query($req);
		//debug

		$row = pg_fetch_row($res, 0);

		$tab[] = $row[1];
		$parent = $row[2];
	}
	//$tab1=array_reverse($tab,TRUE);
	$tab1 = array_reverse($tab);
	//$libelle=implode("/",$tab1);
	return (implode("/", $tab1));

}

/**
 	Fonction numero_du($libelle,$table)
 	Action : retourne le numero  du groupe ou du cours
 	@param string $libelle est de la forme AFIDE/Comptable .... ou Comtable
	@param string classe ou filiere
	@return integer le numero  du groupe ou du cours
*/
function numero_du($libelle, $table) {
	$tablib = explode("/", $libelle);
	$sz = sizeof($tablib);
	$ind = $sz -1;
	$nom = $tablib[$ind];
	$req = "select id from $table where nom like '%$nom%'";
	$res = pg_exec($req);
	$row = pg_fetch_row($res, 0);
	$num = $row[0];
	return $num;
}

/**
 	Fonction niveau($num,$db,$table)
 	Action : retourne le niveau de la classe ou filiere
	@return integer le niveau de la classe ou filiere
*/
function niveau($num, $db, $table) {
	$parent = $num;
	while ($parent != 0) {
		$res = pg_exec($db, "select * from $table where id='$parent';");
		$row = pg_fetch_row($res, 0);
		$tab[] = $row[1];
		$parent = $row[2];
	}
	$niv = sizeof($tab);
	return $niv;
}

/**
 	Fonction niveau_max($num,$db,$table)
 	Action : retourne le niveau max de la table classe ou filiere
*/
function niveau_max($parent, $db, $table, $max) {
	$res = pg_exec($db, "select * from $table where id_pere='$parent' order by nom;");
	while ($row = pg_fetch_array($res)) {
		$num = $row["id"];
		$rang = niveau($num, $db, $table);
		if ($rang > $max)
			$max = $rang;
		$max = niveau_max($num, $db, $table, $max);
	}
	return $max;
}

/**
	Fonction supprime($num,$db,$table)
	Action : supprime une filiere (ou une classe) et sa descendance

*/
function supprime($num, $db, $table) {
	//suppression du pere courant
	$del = pg_exec($db, "delete from $table where id='$num';");
	if ($table == "classe") {
		$del = pg_exec($db, "delete from gestionutil where gu_num_gest_gr='$num';");
		$del = pg_exec($db, "delete from placegroupe where num_gest_groupe='$num';");
	}
	//recup de ses fils
	$res = pg_exec($db, "select * from $table where id_pere='$num';");
	while ($row = pg_fetch_array($res)) {
		$num = $row["id"];
		supprime($num, $db, $table);
	}
}

/**
	Fonction insertion_classe_filiere($pere,$table,$libelle)
	Action : insert une filiere (ou une classe)
*/
function insertion_classe_filiere($pere, $table, $libelle) {
	// test si on a saisi un nom
	if ($libelle != "") {
		// les noms � la racine en majuscule
		if ($pere == 0)
			$libelle = strtoupper($libelle);
		else
			$libelle = ucwords($libelle);
		$libelle = addslashes($libelle);
		// test doublon
		$req = "select * from $table where id_pere='$pere' and nom='$libelle'";
		$res = pg_exec($req);
		if (pg_numrows($res) == 0) {
			// insertion
			$req = "insert into $table (nom,id_pere) values('$libelle','$pere')";
			$ins = pg_exec($req);
			// recup du dernier n� ins�r�
			$req = "select max(id) from $table";
			$res = pg_exec($req);
			$row = pg_fetch_row($res, 0);
			return $row[0];
		} else
			return (-1);
	} else
		return (-2);
}

/**

*/
function affiche_select($name, $type, $option = "", $pere = 0, $niveau = 0) {
	global $$name;

	if ($type == 'classe' || $name == 'cours')
		$msg = "$MSG_1294 $name";
	else
		$msg = " $MSG_1295 $name";

	//   Fonction qui affiche un �l�ment de formulaire select contenant l'arborescence compl�te, soit des classe, soit des fillieres 
	//  Utilisation : affiche_select('nom_du_select','classe') ou affiche_select('nom_du_select','filiere')  
	if ($niveau == 0) {
		echo '<select name="'.$name.'" '.$option.'>';
		echo "<option>$msg</option>";
		echo "<option></option>";
	}

	$sql = "SELECT id,nom
											                  FROM $type
											                  WHERE id_pere=$pere
											                  ORDER BY nom";
	$result = pg_exec($sql);
	for ($i = 0; $i < $niveau; $i ++)
		$space.= '&nbsp;&nbsp;';
	while ($row = pg_fetch_array($result)) {
		$id = $row["id"];
		$nom = $row["nom"];

		print ("
																						                <option value=\"$id\"");
		if ($id == $$name)
			print (" Selected");
		print (">$space $nom</option>");
		affiche_select($name, $type, '', $id, $niveau +1);
		if ($niveau == 0)
			print ("<option value=\"\">&nbsp;&nbsp;-------------&nbsp;&nbsp;</option>");
	}
	if ($niveau == 0)
		print ("</select>");
}

/**

*/
function select_cours_parcours($name, $type, $option = "", $pere = 0, $niveau = 0) {
	global $$name, $MSG_167;
	//   Fonction qui affiche un �l�ment de formulaire slect contenant l'arborescence compl�te, soit des classe, soit des fillieres 
	//  Utilisation : affiche_select('nom_du_select','classe') ou affiche_select('nom_du_select','filiere')  

	if ($niveau == 0)
		echo '<select name="'.$name.'" '.$option.'><option value="">'.$MSG_167.'</option>';
	//$rescours=pg_exec($db,"select distinct num_c_q_e_d from gestparcours where num_etape=1;");
	//$nbcours=pg_numrows($rescours);

	$sql = "SELECT id,nom
											                  FROM $type
											                  WHERE id_pere=$pere ORDER BY nom";
	$result = pg_exec($sql);

	for ($i = 0; $i < $niveau; $i ++)
		$space.= '&nbsp;&nbsp;';
	while ($row = pg_fetch_array($result)) {
		$id = $row["id"];
		$nom = $row["nom"];

		print ("
																						                <option value=\"$id\"");
		if ($id == $$name)
			echo ' Selected';
		echo '>'.$space.' '.$nom.'</option>';

		select_cours_parcours($name, $type, '', $id, $niveau +1);
		if ($niveau == 0)
			echo '<option value="">&nbsp;&nbsp;-------------&nbsp;&nbsp;</option>';

	}
	if ($niveau == 0)
		echo '</select>';
}

/**

*/
function select_groupe_formateur($name, $type, $option = "", $formateur, $pere = 0, $niveau = 0) {
	global $$name;
	if ($niveau == 0)
		echo '<select name="'.$name.'" '.$option.'>';
	$sql = "select id,nom
											                        from $type
											                        where id_pere=$pere and id in
											                        (select distinct g_num_gest_g from gestionnaire where g_num_user='$formateur')
											                        order by nom";
	$result = pg_exec($sql);
	for ($i = 0; $i < $niveau; $i ++)
		$space.= '&nbsp;&nbsp;';
	while ($row = pg_fetch_array($result)) {
		$id = $row["id"];
		$nom = $row["nom"];

		print ("
																						                <option value=\"$id\"");
		if ($id == $$name)
			echo ' Selected';
		echo '>'.$space.' '.$nom.'</option>';
		select_groupe_formateur($name, $type, '', $formateur, $id, $niveau +1);
		if ($niveau == 0)
			echo '<option value="">&nbsp;&nbsp;-------------&nbsp;&nbsp;</option>';
	}
	if ($niveau == 0)
		echo '</select>';
}

//-----------------------------------------------------------------------------------------
//              FONCTIONS POUR LES PARCOURS
//-----------------------------------------------------------------------------------------
/**
 	fonction qui retourne le max de point pour un parcours
	Note : Pour l'instant on ne g�re que les qcm
 	Plus tard on int�grera le "remplir le blancs" "compr�hension ecrite et orale" ...
*/
function maxpoint_parcours($parcours, $db) {
	static $max = 0;
	//recup des etapes du parcours parc
	$resetape = pg_exec($db, "select * from gestparcours where g_num_parcours='$parcours' order by num_etape;");
	$nbetape = pg_numrows($resetape);
	for ($i = 0; $i < $nbetape; $i ++) {
		$rowetape = pg_fetch_row($resetape, $i);
		if ($rowetape[7] != 0 && $rowetape[2] == 'T')
			maxpoint_parcours($rowetape[7], $db);
		//appel recursif
		if ($rowetape[2] == 'Q')
			$max += maxpoint_questionnaire($rowetape[4], $db);
	}
	return $max;
}

/**
 	Fonction parcours en formation($parcours)
 	Action : retourne un tableau contenant les n� de formation si le parcours (ou son pere ou grandpere ..)
              est dans une ou plusieurs formations
 	Donn�es re�ues : $parcours et un tableau vide
*/
//function parcours_en_formation($parcours, &$tabform) {
//	// test si le parcours est ds la table gestionnaire
//	/*
//	$req = "select distinct g_num_cal from gestionnaire where g_num_parcours='$parcours'";
//	$res = pg_exec($req);
//	*/
//	$res=get_parcours_formations($parcours);
//	$cnt = pg_numrows($res);
//	// on stocke les n� de formation ds la table
//	for ($i = 0; $i < $cnt; $i ++) {
//		$row = pg_fetch_row($res, $i);
//		if (!in_array("$row[0]", $tabform))
//			$tabform[] = $row[0];
//	}
//
//	// test si le parcours est un parcours attach�
//	/*
//	$req = "select g_num_parcours from gestparcours where attach_parcours='$parcours' and type_etape='T'";
//	$res = pg_exec($req);
//	*/
//	$res=get_parcours_parcours_pere($parcours);
//	$cnt = pg_numrows($res);
//	for ($i = 0; $i < $cnt; $i ++) {
//		$row = pg_fetch_row($res, $i);
//		parcours_en_formation($row[0], $tabform);
//	}
//	// tester si le parcours est un sousparcours d'un parcours en formation
//	/*
//	$req = "select * from config_orientation";
//	$res = pg_exec($req);
//	*/
//	$res=get_plateforme_sous_parcours();
//	$cnt = pg_numrows($res);
//	for ($i = 0; $i < $cnt; $i ++) {
//		$row = pg_fetch_row($res, $i);
//		$tab = explode(",", $row[2]);
//		if (in_array("$parcours", $tab))
//			parcours_en_formation($row[0], $tabform);
//	}
//
//	return $tabform;
//}

/**
 	Fonction existe_parcours($gestcour,$db)
 	Action : retourne vrai si le cours (ou fils) poss�de un parcours
*/
function existe_parcours($gestcour, $db) {
	
	print("La fonction existe_parcours() est d�pr�ci�e. <br> Utiliser is_filiere_utilise().");
	return is_filiere_utilise($gestcour);
//	$respar = pg_exec($db, "select * from gestparcours where num_c_q_e_d='$gestcour'  and num_etape=1;");
//	if (pg_numrows($respar) == 0) {
//		//il faut tester si un de ses sous-cours poss�de un parcours
//		$res = pg_exec($db, "select * from filiere where id_pere='$gestcour';");
//		while ($row = pg_fetch_array($res)) {
//			$gestcour = $row["id"];
//			return (existe_parcours($gestcour, $db));
//		}
//		return false;
//
//	} else
//		return true;
}
//-----------------------------------------------------------------------------------------
//              FONCTIONS POUR LES SERIES  et liste
//-----------------------------------------------------------------------------------------
/**
 	Fonction existe_serie($numparc)
 	Action : retourne vrai si le parcours (ou parcours attach�) poss�de au moins une serie
*/
function existe_serie($numparc) {
	// recup des etapes du parcours
	$req = "select * from gestparcours where g_num_parcours='$numparc'";
	$res = pg_exec($req);
	$nbetape = pg_numrows($res);
	for ($i = 0; $i < $nbetape; $i ++) {
		$rowetape = pg_fetch_row($res, $i);
		if ($rowetape[2] == 'B' || $rowetape[2] == 'C') {
			// prise en compte des serie monotheme ou multitheme
			return true;
		}
		if ($rowetape[7] != 0 && $rowetape[2] == 'T')
			return existe_serie($rowetape[7]);
	}
	return false;
}

/**
 	fonction qui test si une s�rie est al�atoire
	Retourne 1 si al�atoire
*/
function test_serie_aleatoire($serie, & $mode_aleatoire, $type_etape = "") {
	global $s_numcal, $s_numparc, $s_numstag;
	$aleatoire = 0;
	// 1 - test si serie existante en mode al�atoire
	$sql = "select * from gestserie where num_serie=$serie and num_cal=$s_numcal and aleatoire='t'";
	//debug
	//echo "sql=$sql<br>";
	$res = pg_query($sql);
	if (pg_numrows($res) == 1) {
		$mode_aleatoire = 0;
		return 1;
	}
	// 2 - test si serie aleatoire monotheme ou multitheme
	$sql = "select distinct mode from serie_aleatoire where num_serie=$serie";
	$res = pg_query($sql);
	if (pg_numrows($res) == 1) {
		$row = pg_fetch_row($res, 0);
		$mode_aleatoire = $row[0];
		return 1;
	}
	// 3 - Test si serie g�n�r�e par un test de positionnement
	// recup du type d'etape
	$sql = "select distinct type_etape from gestparcours where g_num_parcours=$s_numparc and num_c_q_e_d=$serie";
	$restype = pg_query($sql);
	$rowtype = @pg_fetch_row($restype, 0);
	if ($rowtype[0] == 'C') {
		$sql = "select * from asso_exo_serie_aleatoire where id_serie=$serie and num_user=$s_numstag and num_cal=$s_numcal";
		$res = pg_query($sql);
		if (pg_numrows($res) >= 0) {
			$mode_aleatoire = 3;
			return 1;
		}
	}

	return 0;
}
/**
Retourne le statut d'une s�rie
	1: non commenc�e
	2: en cours
	3: interrompue
	4: r�activ�e
	5: finie
*/
function get_serie_statut($id_stag, $id_form, $id_serie) {

	// test si al�atoire
	$aleatoire = test_serie_aleatoire($id_serie, $mode_aleatoire);
	// debug
	//echo "alea=$aleatoire et mode=$mode_aleatoire<br>";
	$sql = "SELECT score FROM res_serie WHERE id_stag=$id_stag AND id_formation=$id_form AND id_serie=$id_serie";
	$result = pg_query($sql);
	if (pg_num_rows($result) == 0) {
		//s�rie non commenc�e

		// si serie aleatoire g�n�r�e par un test de positionnement
		//  alors on v�rifie qu'il ya des exo pour cette serie
		//		if($aleatoire==1 && $mode_aleatoire==3){
		//		     $sql="SELECT * FROM  asso_exo_serie_aleatoire WHERE id_serie=$id_serie and num_user=$id_stag";
		//		     $restest=pg_query($sql);
		//		     $nb=pg_numrows($restest);
		//		     echo "nb=$nb<br>";
		//		     if(pg_numrows($restest)==0)
		//		        return(5);
		//		
		//		}
		//		
		return (1);
	} else {
		$score = pg_result($result, 0);
		if ($score < 0) {
			$var = 's_current_'.$id_serie;
			if (session_is_registered($var)) {
				// serie en cours
				return (2);
			} else {
				// s�rie interrompue
				return (3);
			}
		} else {
			// on r�cup�e le nombre d'�tapes dans la s�rie

			if ($aleatoire == 1 && $mode_aleatoire > 0)
				$sql = "SELECT count(*) FROM  asso_exo_serie_aleatoire WHERE id_serie=$id_serie and num_user=$id_stag and num_cal=$id_form";
			else
				$sql = "SELECT count(*) FROM  asso_exo_serie WHERE id_serie=$id_serie";
			$result = pg_query($sql);
			$nb_etape = pg_result($result, 0);

			// on r�cup�re le nombre d'�tapes d�j� effectu�s.
			$sql = "SELECT count(*) FROM  res_serie_exo WHERE id_serie=$id_serie AND id_stag=$id_stag AND id_formation=$id_form";
			$result = pg_query($sql);
			$nb_done = pg_result($result, 0);
			//echo "nb_done=$nb_done - nb_etape=$nb_etape<br>";
			if ($nb_done == $nb_etape) {
				// s�rie termin�e
				return (5);
			} else {
				// s�rie r�activ�e
				return (4);
			}
		}
	}
}

/**
Retourne le statut d'une liste
	1: non commenc�e
	2: en cours
	3: interrompue
	4: r�activ�e
	5: finie
*/
function get_liste_statut($id_stag, $id_form, $id_liste) {

	$sql = "SELECT score FROM res_liste WHERE id_stag=$id_stag AND id_formation=$id_form AND id_liste=$id_liste";
	$result = pg_query($sql);
	if (pg_num_rows($result) == 0) {
		//liste non commenc�e
		return (1);
	} else {
		$score = pg_result($result, 0);
		if ($score < 0) {
			$var = 's_current_'.$id_liste;
			if (session_is_registered($var)) {
				// serie en cours
				return (2);
			} else {
				// s�rie interrompue
				return (3);
			}
		} else {
			// on r�cup�e le nombre de test dans la liste
			// test si al�atoire
			$aleatoire = 0;
			//$aleatoire=test_serie_aleatoire($id_serie,$mode_aleatoire);
			if ($aleatoire == 1 && $mode_aleatoire > 0)
				$sql = "SELECT count(*) FROM  asso_exo_serie_aleatoire WHERE id_serie=$id_serie and num_user=$id_stag";
			else
				$sql = "SELECT count(*) FROM  asso_liste_test WHERE id_liste_test=$id_liste";
			$result = pg_query($sql);
			$nb_etape = pg_result($result, 0);
			// on r�cup�re le nombre d'�tapes d�j� effectu�s.
			$sql = "SELECT count(*) FROM  res_liste_test WHERE id_liste=$id_liste AND id_stag=$id_stag AND id_formation=$id_form group by ordre_etape";
			$result = pg_query($sql);
			//$nb_done=pg_result($result,0);
			$nb_done = pg_numrows($result);
			//echo "nb_done=$nb_done - nb_etape=$nb_etape<br>";
			if ($nb_done == $nb_etape) {
				// s�rie termin�e
				return (5);
			} else {
				// s�rie r�activ�e
				return (4);
			}
		}
	}
}

/** 
	fonction qui retourne le status d'une �tape contenu SCORM
 	1 non commenc�
	 2 en cours
	 3 finie
*/
function get_scorm_statut($num_user, $num_cal, $num_paquet) {
	$sql = "select distinct cmi_core_lesson_status from scorm_sco_users where userid=$num_user and scormid=$num_paquet and num_cal=$num_cal";
	$res = pg_query($sql);
	$nb = pg_numrows($res);
	if ($nb == 0)
		return (1);
	if ($nb > 1)
		return (2);
	$row = pg_fetch_row($res, 0);
	if ($row[0] == "not attempted")
		return (1);
	if ($row[0] == "completed")
		return (3);

}

//----------------------------------------------------------------------------------------
//              FONCTIONS POUR LES QCM
//----------------------------------------------------------------------------------------
/**
	fonction qui retourne le nb de points max pour 1 question
 	Note : utilisation du poids en tant que coefficient
*/
function maxpoint_question($questionnaire, $question, $bareme, $poids) {
	// note : le bareme et le poids appatiennent au questionnaire
	// recup des param de la question
	$req = "select * from elaborqstn where eq_num_qstaire='$questionnaire' and eq_num_question='$question'";
	$res = pg_exec($req);
	$row = pg_fetch_row($res, 0);
	if ($row[6] > 0)
		$bareme = $row[6];
	if ($row[3] > 0)
		$poids = $row[3];
	//recup de la valeur juste du bareme
	$req = "select repok from bareme where num_bareme='$bareme'";
	$res = @ pg_exec($req);
	$row = @ pg_fetch_row($res, 0);
	$valjuste = $row[0];
	if ($valjuste < 1)
		$valjuste = 1;
	if ($poids < 1)
		$poids = 1;
	// nb de reponse juste pour la question
	$req = "select * from quest_rep where qr_num_question='$question' and juste='t'";
	$res = pg_exec($req);
	$nbrep = pg_numrows($res);
	return $valjuste * $nbrep * $poids;
}

/** 
	function qui retourne le nb de point max pour un questionnaire
	Note : utilisation du poids en tant que coefficient
*/
function maxpoint_questionnaire($questionnaire, $db) {
	// recup des parametres du questionnaire
	$req = "select * from questionnaire where num_qstaire='$questionnaire'";
	$res = pg_exec($req);
	$row = pg_fetch_row($res, 0);
	$bareme = $row[2];
	$poids = $row[3];
	// recup du nb de question
	$req = "select * from elaborqstn where eq_num_qstaire='$questionnaire'";
	$res = pg_exec($req);
	$nbquestion = pg_numrows($res);
	//echo "nbquestion=$nbquestion<br>";
	$max = 0;
	for ($i = 0; $i < $nbquestion; $i ++) {
		$row = pg_fetch_row($res, $i);
		$num_question = $row[1];
		// calcul du nb de points max pour une question

		$max += maxpoint_question($questionnaire, $num_question, $bareme, $poids);
		//echo "max=$max<br>";
	}
	return $max;
}

/**
	Fonction existe_qcm($numparc)
	Action : retourne vrai si le parcours (ou parcours attach�) poss�de au moins un qcm
*/
function existe_qcm($numparc) {
	// recup des etapes du parcours
	$req = "select * from gestparcours where g_num_parcours='$numparc'";
	$res = pg_exec($req);
	$nbetape = pg_numrows($res);
	for ($i = 0; $i < $nbetape; $i ++) {
		$rowetape = pg_fetch_row($res, $i);
		if ($rowetape[2] == 'Q')
			return true;
		if ($rowetape[7] != 0 && $rowetape[2] == 'T')
			return existe_qcm($rowetape[7]);
	}
	return false;
}
//----------------------------------------------------------------------------------------
//              FONCTIONS D'AFFICHAGE
//----------------------------------------------------------------------------------------
/**
	CORPS POUR UN AFFICHAGE PAR PAGE
*/
function affiche_par_page($url_page, $lien, $nbparpages, $nb_truc, $nb_truc_tot, $function_affiche) {
	global $debut, $MSG_1757, $MSG_1758;
	$save_debut = $debut;
	if ($debut == "")
		$debut = 0;

	// nombre de truc par page
	$nbparpages;
	// nombre de truc � afficher
	$nb_truc;
	// nombre de truc total
	$nb_truc_tot;
	$i = 1;
	// boucle d'impression
	while ($i <= $nb_truc) {
		$function_affiche ($i);
		$i ++;
	}

	// affichage des num�ros de page sous la forme <precedent [ 1 - 2 - 3 ] suivant>

	$page = ceil($save_debut / $nbparpages) + 1;
	$nb_pages = ceil($nb_truc_tot / $nbparpages);
	if ($nb_pages > 1) {
		if ($page > 1) {
			$debut = ($page -2) * $nbparpages;
			$navi_texte = "&lt;&nbsp;<a href=\"$url_page?debut=$debut&$lien\">$MSG_1757</a>&nbsp;&nbsp;&nbsp;";
		} else
			$navi_texte.= "&lt;&nbsp;$MSG_1757&nbsp;&nbsp;&nbsp;";
		$navi_texte.= "[&nbsp;";

		$a = 1;
		while ($a <= $nb_pages) {
			$debut = ($a -1) * $nbparpages;
			if ($a == $page)
				$navi_texte.= "$a";
			else
				$navi_texte.= "<a href=\"$url_page?debut=$debut&$lien\">$a</a>";
			if ($a < $nb_pages)
				$navi_texte.= "&nbsp;-&nbsp;";
			$a ++;
		}

		$navi_texte.= "&nbsp;]";

		if ($page < $nb_pages) {
			$debut = $page * $nbparpages;
			$navi_texte.= "&nbsp;&nbsp;&nbsp;<a href=\"$url_page?debut=$debut&$lien\">$MSG_1758&nbsp;&gt;</a>&nbsp;&nbsp;&nbsp;";
		} else
			$navi_texte.= "&nbsp;&nbsp;&nbsp;$MSG_1758&nbsp;&gt;&nbsp;&nbsp;&nbsp;";
	}
	return $navi_texte;
}

/**

*/
function affiche_en_ligne($nbparlignes, $nb_truc, $function_affiche, $diff) {
	echo "<table border=\"0\" width=\"100%\" cellspacing=\"0\" cellpadding=\"0\">\n";
	$i = 1 + $diff;

	while ($i <= $nb_truc) {
		echo "<tr>\n";
		$a = 1;

		while ($a <= $nbparlignes) {
			echo "<td width=\"".ceil(100 / $nbparlignes)."%\" align=\"center\" valign=\"bottom\">\n";
			if ($i <= $nb_truc) {
				$function_affiche ($i);
			} else {
				echo "&nbsp;";
			}
			echo "</td>\n";

			$a ++;
			$i ++;
		}
		echo "</tr>\n";
	}
	echo "</table>\n";
}

/**
	Fonctions pour g�n�rer les ent�tes de l'interface formateur
*/
function IF_entete_commun() {
	global $MSG_37, $FORM_22, $s_stag, $serverfront;

	// Nom du script o� retourner
	global $page_precedente;

	// Si page precedente n'est pas d�finie, on fait comme avant
	if ($page_precedente == "")
		$page_precedente = "javascript:history.go(-1)";

	// echo "page_precedente = $page_precedente<br>" ;

	// Affichage de l'icone retour (affichage variable ne marche pas)
	echo "<table class=\"tableau_entete_popup\">
											                        ";

	// ON N'AFFICHE PAS L'IMAGE LIEN SI page_precedente EST EGAL A "stop"
	if ($page_precedente != "stop")
		print ("
																						        <td>
																						                &nbsp;&nbsp;&nbsp;&nbsp;
																						                        <a  href=\"$page_precedente\" onMouseOut=\"MM_swapImgRestore()\" onMouseOver=\"MM_swapImage(Image411,,$serverfront/data/images/retour2.gif,1)\">
																						                        <img name=\"Image411\" border=\"0\" src=\"http://$serverfront/data/images/retour.gif\" class=\"image_popup\" /></a>
																						        </td>
																						        <td>
																						                <span class=\"texte_image_popup\">$MSG_37</span>
																						        ");
	else
		print ("
																						                <td colspan=2>
																						                &nbsp;&nbsp;&nbsp;&nbsp;
																						                ");

	echo "</td>";

	// if($s_stag==1)

	// Affichage de l'icone fermer (affichage variable ne marche pas)
	echo '
											                <td>
											                        &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<a href="javascript:window.close()" onMouseOut="MM_swapImgRestore()" onMouseOver="MM_swapImage(\'Image311\',\'\',\'http://'.$serverfront.'/data/images/fermer2.gif\',1)"><img name="Image311" border="0" src="http://'.$serverfront.'/data/images/fermer.gif" class="image_popup"></a>
											                        
											                </td>
											                <td>
											                        <span class="texte_image_popup">'.$FORM_22.'</b></font>
											                </td>
											        ';

	echo '
											                        </tr>
											                  </table>';
}

/**

*/
function IF_entete($formation, $groupe = "", $util = "") {
		// $formation : nom de la formation
		// $groupe : nom du groupe
		//$util : nom/pr�nom de l'utilisateur

		// Si on n'a pas selectionn� de formation, il y a un vide dans l'affichage
	if ($formation == "")
		$formation = "Aucune formation selectionn�e";

	global $MSG_635, $MSG_682, $MSG_616, $s_stag;

	// Pour remplacer history(go -1) ;
	global $page_precedente;

	// debug
	//echo "s_stag=$s_stag<br>";
	/*$nb=6;
	if(empty($groupe))
	        $nb-=2;
	if(empty($util))
	        $nb-=2;*/
	$nb = 3;
	if (empty($groupe))
		$nb -= 1;
	if (empty($util))
		$nb -= 1;

	IF_entete_commun();

	// John modification de l'affichage le 30/10/2003
	// EN TETE DE PAGE
	print ("
											        <br>
											        <table class=\"tableau_contenu_popup\">
											        <tr>
											                <td colspan=$nb >
											                <hr/>
											                </td>
											        </tr>
											        <tr>");
	// print("<td><b>&nbsp;&nbsp; <!--<img src=\"/data/images/jaune.gif\" width=\"25\" height=\"25\" border=\"1\" vspace=\"0\" hspace=\"0\">--></b>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;</td>");

	//CALENDRIER
	print ("
											      <td >
											        <span class=\"texte_tableau_contenu_popup\">$MSG_635</span>
											      </td>");
	//"
	// GROUPE S'IL Y EN A UN
	if (!empty($groupe)) {
		/*echo'<td>&nbsp;&nbsp;&nbsp;&nbsp;<!-- <img src="/data/images/orange.gif" width="25" height="25" border="1" vspace="0" hspace="0">-->&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;</td>
		        <td>
		        <div align="center"><font size="4" face="Arial, Helvetica, sans-serif"><b>'.$MSG_682.'</b></font></div>
		        </td>';//"
		*/
		// Modification john
		print ("<td>
																						                        <span class=\"texte_tableau_contenu_popup\">$MSG_682</span>
																						                        </td>");
	}
	// UTILISATEUR
	if (!empty($util)) {
		/*echo'
		<td>&nbsp;&nbsp;&nbsp;&nbsp;<!-- <img src="/data/images/bleu.gif" width="25" height="25" border="1" vspace="0" hspace="0">-->&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;</td>
		<td>
		        <div align="center"><font size="4" face="Arial, Helvetica, sans-serif"><b>'.$MSG_616.'</b></font>&nbsp;&nbsp;</div>
		</td>';//''*/
		print ("
																						                <td>
																						                        <span class=\"texte_tableau_contenu_popup\">$MSG_616</span>
																						                </td>");
	}

	print ("
											    </tr>
											    <tr>");
	//echo "<td>&nbsp; </td>"; case vide
	// FORMATION
	print ("<td class=\"taille_texte_formation_contenu_popup\">
											        <span class=\"texte_formation_contenu_popup\">$formation</span>
											      </td>");

	// GROUPE
	if (!empty($groupe)) {
		//echo"<td>&nbsp; </td>"; case vide
		print ("
																						                <td>
																						                        <span class=\"texte_formation_contenu_popup\">$groupe</span>
																						                </td>");
	}

	// UTILISATEUR
	if (!empty($util)) {
		//echo"<td>&nbsp; </td>"; case vide
		print ("
																						                <td>
																						                         <span class=\"texte_formation_contenu_popup\">$util</span>
																						                </td>");
	}

	print ("
											    </tr>
											    <tr>
											      <td colspan=$nb>
											        <hr/>
											      </td>
											    </tr>
											  </table>");
}

/**
	fonction qui test si une page admet un affichage dynamique
	si oui ==> met la configuration dans un tableau et retourne 1
 	si non ==> retourne 0
 	 
    @param integer  $num_cal (N� calendrier)
    @param integer  $num_exo (qcm ou blanc )
	@param integer  $tab (pour la configuration)
	
	@return integer 1 si dynamique 0 sinon.
*/
function affichage_dynamique($num_cal, $num_exo = 0, & $tab, & $num_page) {
	global $SCRIPT_NAME, $site_heberge, $nombase;
	// debug
	//echo "script= $SCRIPT_NAME et num_cal=$num_cal<br>";
	//echo "num_exo=$num_exo<br>";
	if (empty($num_exo))
		$num_exo = 0;
	if ($site_heberge == 1) {
		$lg = strlen($nombase) + 1;
		$nom_script = substr($SCRIPT_NAME, $lg);
	} else
		$nom_script = $SCRIPT_NAME;
	//echo "nom_script=$nom_script<br>";
	$configuration_affichage = 0;
	// initialisation du tableau
	for ($i = 0; $i < 22; $i ++)
		$tab[] = 0;
	$req = "select num_page,configuration from configpage where num_page in
											    (select id from page where libelle_script like '%$nom_script%') and num_cal='$num_cal' and num_qcm='$num_exo'";
	//echo "$req";
	$res = pg_exec($req);
	if (pg_numrows($res) == 1) {
               //echo "coucou<br>";
		$configuration_affichage = 1;
		$row = pg_fetch_row($res, 0);
		$num_page = $row[0];
		// On met la configuration dans un tableau
		$tab = explode(",", $row[1]);
	}
	return $configuration_affichage;
}

//-----------------------------------------------------------------------------------------
//              FONCTIONS POUR LES CALENDRIERS
//-----------------------------------------------------------------------------------------
/**

*/
function get_nomcal($num) {
	/* retourne le nom du calendrier � partir de son num�ro */
	if ($num > 0) {
		$sql = "SELECT nom_cal
																						        FROM calendrier
																						        WHERE num_cal=$num";
		$result = pg_query($sql);
		return (pg_result($result, 0));
	}

}

/**

*/
function numcal_to_nomgrp($num) {
	/* renvoit le nom du groupe associ� � un num�rode calendrier */
	$sql = "SELECT nom
											          FROM classe
											          WHERE id IN ( SELECT DISTINCT g_num_gest_g
											                                FROM gestionnaire
											                                WHERE g_num_cal='$num')";
	$result = pg_query($sql);

	return (pg_result($result, 0));

}

//-----------------------------------------------------------------------------------------
//              FONCTIONS TEST DE SUPPRESSION
//-----------------------------------------------------------------------------------------
/** 
	function supprimable_espace($espace)
	Retourne vrai si l'espace est supprimable
*/
function supprimable_espace($espace) {
	// on regarde si l'espace est utilis�
	$req = "select * from ressource_gest where num_espace='$espace'";
	$res = pg_exec($req);
	if (pg_numrows($res) == 0)
		return true;
	else
		return false;
}
/**
	function supprimable_secton($section)
	Retourne vrai si la section est supprimable
*/
function supprimable_section($section) {
	// on regarde si l'espace est utilis�
	$req = "select * from ressource_gest where num_section='$section'";
	$res = pg_exec($req);
	if (pg_numrows($res) == 0)
		return true;
	else
		return false;
}

/** 
	fonction qui test si un stagiaire est supprimable
*/
function supprimable($user) {
	// test si formateur par defaut
	$req = "select login,password  from utilisateurs where num_user='$user'";
	$res = pg_exec($req);
	$row = pg_fetch_row($res);
	// on ne supprime pas l'admin du chat
	if ($row[0] == "admin" || $row[1] == "admin")
		return false;
	if ($row[0] == "temporaire" || $row[1] == "temporaire")
		return false;
	// test si formateur
	$req = "select distinct g_num_cal from gestionnaire where g_num_user='$user'";
	$res = pg_exec($req);
	if (pg_numrows($res) > 0)
		return false;
	// test si stagiaire appartient � un groupe
	$req = "select distinct gu_num_gest_gr from gestionutil where gu_num_user='$user'";
	$res = pg_exec($req);
	if (pg_numrows($res) > 0)
		return false;
	else
		return true;
}

//-----------------------------------------------------------------------------------------
//              FONCTIONS DIVERSES
//-----------------------------------------------------------------------------------------
// fonction qui retourne le sch�ma utilis� sur prod


/**

*/
function CopyLeft() {
	$str = "<font size=2 face=\"Arial, Helvetica, sans-serif\"><div align=right>&copy; AFIDE 2001</div></font>";
	return $str;
}

/**

*/
function is_alphanum($text) {
	$validchars = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ1234567890_";
	$longueurtext = strlen($text);
	for ($i = 0; $i < $longueurtext; $i ++) {
		$lettre = substr($text, $i, 1);
		$pos = strpos($validchars, $lettre);
		if ($pos === FALSE) {
			return false;
		}
	}
	return true;
}

/**
 	fonction qui retourne le type de page o� se trouve le user
 	$page est de la forme /var/www/html/index.php3
*/
function recup_page_courante($page) {
	$tabpage = explode("/", $page);
	$pagetab = array_reverse($tabpage);
	$type_page = "";
    // debug
    //echo "pagetab[0]=$pagetab[0]<br>";
	switch ($pagetab[0]) {
		case 'parcours.php3' :
			$type_page = "parcours";
			break;
		case 'carton.php3' :
		case 'notation.php3' :
			$type_page = "presentiel";
			break;
		case 'global_test.php3' :
			$type_page = "stats";
			break;
		case 'do_serie_test.php' :
			$type_page = "series";
			break;
		case 'do_serie.php' :
			$type_page = "series";
			break;
		case 'do_liste.php' :
			$type_page = "series";
			break;
		case 'playscorm.php' :
			$type_page = "playscorm";
			break;
		default :
			$type_page = $pagetab[1];
	}
	return $type_page;
}

/**
 	mise � jour de la date de d�connexion
*/
function maj_deconnexion() {
	global $s_numuser;

	$da = date("Y-m-d H:i:s");
	$da.= "+02";
	$req = "update connexion set date_deconnexion = '$da' where num_user='$s_numuser' and date_connexion in
											               (select max(date_connexion) from connexion where num_user='$s_numuser') ";

	$maj = pg_query($req);
}

/**
	Retourne le resultat d'une requete sous forme de tableau.
	Le resultat de la requete est trait� par une boucle et la fonction pg_fetch_array()
	afin de retourner un tableau dont chacune des lignes est une ligne du resulat
	de la colonne, c'est � dire un tableau contenant chacunes de colonnes de la
	ligne de resultat.
	
	Ainsi le tableau retourn� est de la forme:
	
			| colonne0	| colonne1	|	colonne2	| ....	| colonne n 	|
	--------------------------------------------------------------------------------|
	ligne0	|					|					|					|		|					|
	--------------------------------------------------------------------------------|
	ligne1	|					|					|					|		|					|
	--------------------------------------------------------------------------------|
	ligne2	|					|					|					|		|					|
	--------------------------------------------------------------------------------|
	..... 	|					|					|					|		|					|
	--------------------------------------------------------------------------------|
	ligne n	|					|					|					|		|					|
	
	@param integer entier resultat de la requete
	@return array()	resultat de la requete sous forme de tableau
*/
function pg_super_fetch_array($resultat) {

	$tab = array();

	while ($row = @pg_fetch_array($resultat)) {
		$tab[] = $row;
	}

	return $tab;
}
//--------------------------------------------------------------------------------------------
//              FONCTIONS POUR LES DATES ET HEURES
//--------------------------------------------------------------------------------------------
/**

*/
function date_en_seconde($date_timestamp) {
	// separation date et temps (+ decalage)
	list ($date, $temps_decalage) = explode(" ", $date_timestamp);
	// recup de l'ann�e,du mois et du jour
	list ($annee, $mois, $jour) = explode("-", $date);
	// separation du temps et d�calage
	list ($temps, $decalage) = explode("+", $temps_decalage);
	// recup heure minute seconde
	list ($heure, $minute, $seconde) = explode(":", $temps);
	$date_seconde = mktime($heure, $minute, $seconde, $mois, $jour, $annee, - $decalage);
	return $date_seconde;
}

/** 
	fonction qui calcule le temps entre deux dates
 	Les param�tres sont de la forme : 2004-01-22 22:14:25+02
*/
function compte_temps($date_actuelle, $date_precedente) {
	// il faut faire le calcul suivant : $temps=$date_actuelle - $date_precedente (en seconde)
	// conversion de la date en secondes

	$date_actuelle_seconde = date_en_seconde($date_actuelle);
	// debug
	//echo "date_actuelle_seconde=$date_actuelle_seconde<br>";

	$date_precedente_seconde = date_en_seconde($date_precedente);
	//echo "date_precedente_seconde=$date_precedente_seconde<br>";
	$temps = $date_actuelle_seconde - $date_precedente_seconde;
	//echo "temps=$temps<br>";
	// debug
	//$temps=60;
	// calcul a suivre ....

	return $temps;
}

/**

*/
function sec_to_txt($nb_seconde) {

	//$txt =$nb_seconde;

	$time = get_hms($nb_seconde);
	if ($time["heure"] > 0)
		$txt.= ' '.$time["heure"].' '.MSG_263;

	if ($time["minute"] > 0)
		$txt.= ' '.$time["minute"].' '.MSG_262;

	if ($time["seconde"] > 0)
		$txt.= ' '.$time["seconde"].' '.MSG_261;

	return ($txt);

}

/**

*/
function get_hms($nb_secondes) {
	
	if(!is_int($nb_secondes)||$nb_secondes<0){
//		die("get_hms(): Le nombre de secondes doit etre un entier positif.");
	}
	$tab["heure"] = floor($nb_secondes / 3600);
	$tab["minute"] = floor(($nb_secondes - $tab["heure"] * 60 * 60) / 60);
	$tab["seconde"] = $nb_secondes - $tab["heure"] * 60 * 60 - $tab["minute"] * 60;

	return ($tab);
}

function seconde_to_hms($nbseconde,$tab){
     // nb heure
   $h=floor($nbseconde/3600);
   // les minute
   $m=floor(($nbseconde - ($h*3600)) / 60);
   // les seconde
   $s=$nbseconde - ($h*3600) - ($m*60);
   $tab[]=$h;
   $tab[]=$m;
   $tab[]=$s;
    return $tab;
}


/**
 *  fonction qui retourne des heures minute et secondes en secondes
 * donn�e re�ue : $tab ($tab[0] => Heures $tab[1] => Minutes et $tab[2] => Secondes
 */
function hms_to_secondes($tab){
    $seconde=0;
    $seconde +=($tab[0]*3600);
    $seconde +=($tab[1]*60);
    $seconde +=$tab[2];
    return $seconde;
}

/**
 * Fonction qui decoupe un timestamp dans un tableau
 */
function decoupedbstamp($dbdate){
	$dbdate=strtr($dbdate," ","-");
	$dbdate=strtr($dbdate,":","-");
	$dbdate=strtr($dbdate,"+","-");
	$t=explode("-",$dbdate);
	return $t;// array_chunk($t,3);
}

/**
 * Function qui ecrit le time timestamp en mktime
 */
function dbstamp2tstamp($dbstamp){
	$t=decoupedbstamp($dbstamp);
	return (mktime($t[3],$t[4],$t[5],$t[1],$t[2],$t[0]));
}


//-----------------------------------------------------------------------------------------
//        FONCTIONS POUR L'AVANCEMENT DANS LE PARCOURS
//-----------------------------------------------------------------------------------------
/** 
	fonction qui g�re l'avancement du stagiaire ds le parcours
 	Donn�es re�ues : $liste_avance ==> liste des etapes obligatoire (vide si etape libre)
                              $numexo ==> N� de qcm ou exotlc ou ...
                              $type_etape ==> F (forum) R (ressource) ...
*/
function gestion_avancement($obligation, $numexo, $type_etape, $db, $etape_reelle = 0) {
	global $s_numparc, $s_numcal, $s_numstag, $s_groupe, $numetape;
	global $s_liste_avance;
	//print("<script>alert('obligation=".$obligation."')</script>");
	if ($obligation == 'o') {
		//recup des etape obligatoire
		$stock = explode(":", $s_liste_avance);
		//recup de l'avancement du parcours en base de donn�es.
		$resavance = pg_exec($db, "select avancement from gestionparcours
																						        where gp_num_parcours='$s_numparc' and gp_num_groupe='$s_groupe' and gp_num_user='$s_numstag' and num_cal='$s_numcal';");
		$rowavance = pg_fetch_row($resavance, 0);
		$val_avance = $rowavance[0];
		//echo "val_avance=$val_avance et numetape=$numetape<br>";
		switch ($type_etape) {

			case 'F' :
			case 'P' :
			case 'R' :
			case 'S' : // modif du 22/10/03 (Pb avancement
				//if($numetape>=$val_avance){
				if ($numetape > $val_avance) {

					//balayage de stock
					reset($stock);
					$maj = 0;
					while (list ($cle, $val) = each($stock)) {
						if ($cle > 0 && $val == 0) {
							//derniere etape
							$lastval = max($stock) + 1;
							//echo "lastval=$lastval<br>";
							$maj = pg_exec($db, "update gestionparcours set avancement='$lastval'
																																																																													                                            where  gp_num_parcours='$s_numparc' and gp_num_groupe='$s_groupe' and gp_num_user='$s_numstag' and num_cal='$s_numcal';");
						} else
							if ($val > $val_avance) {
								//echo "val=$val et val_avance=$val_avance<br>";
								$maj = pg_exec($db, "update gestionparcours set avancement='$val'
																																																																																								                                                where  gp_num_parcours='$s_numparc' and gp_num_groupe='$s_groupe' and gp_num_user='$s_numstag' and num_cal='$s_numcal';");
								break;
							}
					}
					//if($maj==0){
					//$maj=pg_exec($db,"update gestionparcours set avancement='$val' where  gp_num_parcours='$s_numparc' and gp_num_groupe='$s_groupe' and gp_num_user='$s_numstag';");
				}
				break;
			case 'B' :
			case 'C' :
			case 'Q' :
			case 'A' :
			case 'Z' :
			case 'L' : //balayage de stock_avance
				reset($stock);
				while (list ($cle, $val) = each($stock)) {
					//echo "cle=$cle et val=$val<br>";
					if ($cle > 0 && $val == 0) {
						//derniere etape
						$lastval = max($stock) + 1;
						$maj = pg_exec($db, "update gestionparcours set avancement='$lastval'
																																																																		                                        where  gp_num_parcours='$s_numparc' and gp_num_groupe='$s_groupe' and gp_num_user='$s_numstag' and num_cal='$s_numcal';");
					} else {
						//echo "val=$val et val_avance=$val_avance<br>";
						if ($val > $val_avance) {

							$maj = pg_exec($db, "update gestionparcours set avancement='$val'
																																																																													                                            where  gp_num_parcours='$s_numparc' and gp_num_groupe='$s_groupe' and gp_num_user='$s_numstag' and num_cal='$s_numcal';");
							break;
						}
					}
				}
				break;
			case 'E' :
				if ($numetape > $val_avance) {
					//balayage de stock
					reset($stock);
					$maj = 0;
					while (list ($cle, $val) = each($stock)) {
						if ($cle > 0 && $val == 0) {
							//derniere etape
							$lastval = max($stock) + 1;
							//echo "lastval=$lastval<br>";
							$maj = pg_exec($db, "update gestionparcours set avancement='$lastval'
																																																																													                                            where  gp_num_parcours='$s_numparc' and gp_num_groupe='$s_groupe' and gp_num_user='$s_numstag' and num_cal='$s_numcal';");
						} else
							if ($val > $val_avance) {
								//echo "val=$val et val_avance=$val_avance<br>";
								$maj = pg_exec($db, "update gestionparcours set avancement='$val'
																																																																																								                                                where  gp_num_parcours='$s_numparc' and gp_num_groupe='$s_groupe' and gp_num_user='$s_numstag' and num_cal='$s_numcal';");
								break;
							}
					}
					//if($maj==0){
					//$maj=pg_exec($db,"update gestionparcours set avancement='$val' where  gp_num_parcours='$s_numparc' and gp_num_groupe='$s_groupe' and gp_num_user='$s_numstag';");
				}
				break;
				// traiter le type L a suivre

		}

	} else {
		//echo "cocucou<br>";
		//gestion des etapes libres
		switch ($type_etape) {
			case 'F' :
			case 'P' :
			case 'R' :
			case 'S' :
				$texte = $type_etape.$etape_reelle;
				break;

			case 'Q' :
			case 'A' :
			case 'E' :
			case 'B' :
			case 'C' :
				$texte = $type_etape.$numexo;
				break;
		}
		//recup des etapes libres dans gestionparcours
		//debug
		//echo "num_parc=$num_parc et groupe=$groupe et rowstag[0]=$rowstag[0] et num_cal=$num_cal<br>";
		$reslibre = pg_exec($db, "select etape_libre from gestionparcours
																						        where gp_num_parcours='$s_numparc' and gp_num_groupe='$s_groupe' and gp_num_user='$s_numstag' and num_cal='$s_numcal';");
		$rowlibre = pg_fetch_row($reslibre, 0);
		$stock_libre = explode(",", $rowlibre[0]);
		//on verifie si l'etape est deja en base
		$existe = 0;
		while (list ($cle, $val) = each($stock_libre)) {
			if ($val == $texte) {
				//debug
				//echo "val=$val et val_etape=$val_etape et numetape=$numetape<br>";
				$existe = 1;
				break;
			}
		}
		if ($existe == 0) {
			$stock_libre[] = $texte;
			$liste_libre = implode(",", $stock_libre);
			$maj = pg_exec($db, "update gestionparcours set etape_libre='$liste_libre'
																																	            where gp_num_parcours='$s_numparc' and gp_num_user='$s_numstag' and num_cal='$s_numcal';");
		}
	}
}
/** 
	fonction qui retourne vrai si le media est une image
	les extension test�es :jpg gif jpe jpeg
*/
function est_image($image) {
	if (strtolower(substr($image, -3)) == "jpg" || strtolower(substr($image, -3)) == "gif" || strtolower(substr($image, -3)) == "jpe" || strtolower(substr($image, -4)) == "jpeg")
		return true;
	return false;

}
//-----------------------------------------------------------------------------------------
//              FONCTIONS POUR LES OBJETS
//-----------------------------------------------------------------------------------------

/**
	Cette fonction permet de r�cup�r� un objet � partir d'une URL.
	Les op�rations suivantes sont effectu�es:
		urldecode->stripslashes->unserialize
	@deprecated version - Mar 31, 2008
	@param string: la chaine repr�sentant l'objet � extraire d'une URL
	@return object: l'objet extrait
*/
function importObjet($imported) {
//	
//	$serialized = stripslashes(urldecode($imported));
//	$object = unserialize($serialized);
//
//	return $object;
	return importObject($imported);
}

/**
	Cette fonction permet de transformer un objet en une chaine
	pour le passer dans une URL.
	Les op�rations suivantes sont effectu�es:
		serialize->urlencode
	@deprecated version - Mar 31, 2008
	@param object: l'objet � transformer
	@return string: la chaine repr�sentant l'objet � passer dans une URL
*/
function exportObjet($objet) {
//
////	$serialized = addslashes(serialize($objet));
//	$serialized = serialize($objet);
//	$exported = urlencode($serialized);
//
//	return $exported;
	return exportObject($objet);
}

function exportedObject($object_unique_identifier) {
	global $sess,$obj_module;

	if(!is_object($obj_module)){
//		print_rr($obj_module);
//		die("Erreur exportedObject($object_unique_identifier): le module est inexistant (\$obj_module==null)");
		return false;
	}
	if(isset($obj_module->session_objects[$object_unique_identifier])){
		return true;
	}else{
		return false;
	}
}

function unexportObject($object_unique_identifier) {
	global $sess,$obj_module;

	if(!is_object($obj_module)){
//		print_rr($obj_module);
//		die("Erreur exportedObject($object_unique_identifier): le module est inexistant (\$obj_module==null)");
		return false;
	}
	if(isset($obj_module->session_objects[$object_unique_identifier])){
		unset($obj_module->session_objects[$object_unique_identifier]);
		return true;
	}else{
		return false;
	}
}

/**
	Cette fonction permet de r�cup�rer un objet stock� en session � partir de son identifiant unique.
	L'objet, une fois r�cup�r�, est supprim� de la session.
	@param string: l'identifiant unique de l'objet
	@return object: l'objet stock� en session
*/
function importObject($object_unique_identifier) {
//	echo "importObject($object_unique_identifier)";
	global $sess,$obj_module;
//	print_rr($sess);
//print_rr($obj_module->session_objects);
	if(!is_object($obj_module)){
//		print_rr($obj_module);
//		die("Erreur importObject($object_unique_identifier): le module est inexistant (\$obj_module==null)");
	}
	if(empty($obj_module->session_objects[$object_unique_identifier])){
//		print_rr($obj_module);
//		print_rr($obj_module->session_objects);
//		die("Erreur importObject($object_unique_identifier): il n'y a pas d'objet correspondant a cet identifiant");
	}else{
//		echo"importObject($object_unique_identifier)<br>";
		$imported=$obj_module->session_objects[$object_unique_identifier];
//		unset($obj_module->session_objects[$object_unique_identifier]);
	}
	$serialized = stripslashes(urldecode($imported));
	$object = unserialize($serialized);

	return $object;
}

/**
	Cette fonction stocke en session l'objet pass� en parametre et retourne un identifiant unique.
	Cet objet peu etre ensuite r�cup�r� par la fonction importObject() en lui fournissant l'identifiant unique.
	@param object: l'objet a stocker
	@return string: l'identifiant unique de l'objet
*/
function exportObject($objet, $aso_uid=null) {
	global $sess,$obj_module;
	if(!is_object($obj_module)){
//		print_rr($objet);
//		die("Erreur exportObject(\$objet, $aso_uid): le module est inexistant (\$obj_module==null)");
	}
	if(!is_array($obj_module->session_objects))$session_objects=Array();
	$serialized = serialize($objet);
	if(empty($aso_uid)){
		$object_unique_identifier=uniqid ('astairs_sess_object_');
	}else{
		$object_unique_identifier=$aso_uid;
	}
	$obj_module->session_objects[$object_unique_identifier]=$serialized;
	//if(!$sess->is_registered('obj_module'))$sess->register('obj_module');
//		print_rr($sess);
//	print_rr($obj_module);
//	print_rr($_SESSION);
	return $object_unique_identifier;
}

//-----------------------------------------------------------------------------------------
//              FONCTIONS POUR LE DEBUG
//-----------------------------------------------------------------------------------------

/*
define("MSG_DEBUG","1");
define("MSG_INFO","2");
define("MSG_NOTICE","3");
define("MSG_WARNING","4");
define("MSG_ERROR","5");
define("MSG_LOG","6");
define("MSG_FATAL","7");
define("MSG_PANIC","8"); 
 */
/**
	Affiche un message d'erreur en fonction d'un niveau de debug.

	Si la variable globale $NIVEAU_DEBUG est �gale � 1, affiche le message,
	n'affiche rien sinon.
	@param String $message_debug le message d'erreur � afficher
	@param integer $niveau (Facultatif) Indique un niveau de message de debug pour lequel ce message doit apparaitre.
*/
function messageDebug($message_debug, $niveau_force="") {
	global $NIVEAU_DEBUG;
	if(empty($niveau_force)){
		$niveau_courant=$NIVEAU_DEBUG;
	}else{
		$niveau_courant=$niveau_force;
	}
	switch ($niveau_courant) {
		case 0: 
			break;
		case MSG_PANIC:
		case MSG_FATAL:
		case MSG_LOG:
		case MSG_ERROR:
		case MSG_WARNING:
		case MSG_NOTICE:
		case MSG_INFO:
		case MSG_DEBUG:
			print ("$message_debug<BR>");
		default:
			
	}
}

/**
	Affiche un message d'erreur suivit d'un tableau en fonction d'un niveau de debug.
	Si la variable globale $NIVEAU_DEBUG est a 1, affiche le message,
	n'affiche rien sinon.
	@param String : le message d'erreur a afficher
	@param Array le tableau � afficher apres le message
*/
function messageDebugR($message_debug, $tableau) {
	global $NIVEAU_DEBUG;
	if ($NIVEAU_DEBUG == 1) {
		print ("$message_debug<BR>\n<pre>");
		print_r($tableau);
		print ("</pre><BR>");
	}
}

/**
	Affiche les variables pass�es � un script par un formulaire.

	Si la variable globale $NIVEAU_DEBUG est egale a 1, affiche les variables re�ues
	par la page (contenu de $HTTP_POST_VARS), n'affiche rien sinon.

*/
function httpPostVariables() {
	global $NIVEAU_DEBUG;
	global $_POST;

	if ($NIVEAU_DEBUG == 1 ) {
		reset($_POST);
		print("<PRE>");
		print_r($_POST);
		print("</PRE>");
	}
}

/**
        Parse un fichier pour convertir les entities html et les caract�res sp�ciaux de iso-8859-15 vers l'UTF-8 ou vice versa....
        @param fichier � traiter ;
*/
function parse_unicode($fichier,$oldCharset,$newCharset){
	
	print("La fonction parse_unicode($fichier,$oldCharset,$newCharset) est d�pr�ci�e.");
	return parse_encoding($fichier,$oldCharset,$newCharset);
	//    $currentCharset=CHARSET ;
	//    // ATTENTION : Ne Pas Modifier ni l'ordre ni les caract�res sp�ciaux de l'UTF-8... Trop gal�re � retapper apres...
	//    $latin = array("ISO-8859-15","�","�","�","�","�","�","�","�","�","�","�","�","�","�","�","�","oe");
	//    $ascii = array($currentCharset,"&agrave;","&acircg;","&auml;","&eacute;","&egrave;","&ecirc;","&euml;","&icirc;","&iuml;","&ocirc;","&ouml;","&ugrave;","&ucirc;","&uuml;","&ccedil;","&aelig;","&oelig;");
	//
	//    $unicode = array("UTF-8","à","â","ä","é","è","ê","ë","î","ï","ô","ö","ù","û","ü","ç","æ","�");
	//
	//    if( ! $read = @fopen($fichier,'rb')) $result= "Impossible d'ouvrir le fichier";
	//    else {
	//        if(! $lang = @fread($read, filesize($fichier))) $result = "Impossible de lire le fichier";
	//        else {
	//
	//                $lang = str_replace($ascii,$$newCharset,$lang);
	//                $lang = str_replace($$oldCharset,$$newCharset,$lang);
	//                $lang=str_replace($$oldCharset,$$newCharset,$lang);
	//                $taille = strlen($lang);
	//                fclose($read);
	//                if( ! $fp = @fopen($fichier,'w')) $result = "Impossible d'ouvrir le fichier";
	//                else {
	//                    fwrite($fp,$lang,$taille);
	//                    fclose($fp);
	//                }
	//
	//        }
	//    }
}

/**
 * Change un document d'encodage et si elle trouve le charset, le remplace par le nouveau
 * @param string: fichier � lire
 * @param string: charset source
 * @param string: charset destination
*/
function parse_encoding ($fichier,$oldCharset,$newCharset){
if( ! $read = @fopen($fichier,'rb')){
		$result= "Impossible d'ouvrir le fichier";
	} else {
		if(! $contenu = @fread($read, filesize($fichier))) {
			$result = "Impossible de lire le fichier";
		} else {
			//converti le document de l'ancien charset au nouveau charset
			$str = mb_convert_encoding($contenu, $newCharset,$oldCharset);
			
			//remplace la chaine de l'ancien charset par celle du nouveau charset
			$str = str_replace($oldCharset,$newCharset,$str);
			
			$taille = strlen($str);
			fclose($read);
			if( ! $fp = @fopen($fichier,'w')) $result = "Impossible d'ouvrir le fichier en ecriture";
			else {
				//reecriture du fichier avec le nouvel encidage
				fwrite($fp,$str,$taille);
				fclose($fp);
				$result = "changement de charset ok sur ".$fichier;
			}
		}
	}
	return $result;
}


/**
 * Retourne le temps en microsecondes.
 * Appell�e une premiere puis une seconde fois, la diff�rence
 * des r�sultats des 2 appels donne le temps d'execution du code
 * entre situ� entre eux.
 * @return integer le temps en microsecondes.  
 */
function calcul_execution() {
     list($msec, $sec) = explode(' ', microtime());
     return ((float) $sec + (float) $msec) * 1000000;
}


function astairsinfo(){
	global $IP, $repertoire, $nom_site_back,$nom_site_front, $is_site_heberge,  $plateforme, $nom_site_front,$nom_site_back,$serverfront,$serverback,$chemin_fo,$chemin_bo;
	global $adressebase,$nombase, $base_ref,$login,$adressebase_archive,$nombase_archive,$login_archive,$style_par_defaut,$langue_par_defaut,$server;
	global $MSG_2589,$MSG_2590,$MSG_2591,$MSG_2569,$MSG_2561,$MSG_246,$MSG_2592,$MSG_2593,$MSG_2594;
print("
<br/><h1>$MSG_2589 <!--Variables detectees--> :</h1>
<table border=\"1\" style=\"text-align:left;\">
	<tr>
		<td style=\"background-color: #ccccff; font-weight: bold; color: #000000;\">$MSG_2593 <!--IP detectee--></td><td style=\"background-color: #cccccc; color: #000000;\">$IP</td>
	</tr>
	<tr>
		<td style=\"background-color: #ccccff; font-weight: bold; color: #000000;\">$MSG_2592 <!--Repertoire detecte--></td><td style=\"background-color: #cccccc; color: #000000;\">$repertoire</td>
	</tr>
	<tr>
		<td style=\"background-color: #ccccff; font-weight: bold; color: #000000;\">BACK OFFICE</td><td style=\"background-color: #cccccc; color: #000000;\">$nom_site_back</td>
	</tr>
	<tr>
		<td style=\"background-color: #ccccff; font-weight: bold; color: #000000;\">FRONT OFFICE</td><td style=\"background-color: #cccccc; color: #000000;\">$nom_site_front</td>
	</tr>
	<tr>
		<td style=\"background-color: #ccccff; font-weight: bold; color: #000000;\">$MSG_2594 <!--Identifiant plateforme--></td><td style=\"background-color: #cccccc; color: #000000;\">$plateforme</td>
	</tr>
</table>

<br/><h1>$MSG_2590 <!--Variables configurees--> :</h1>
<table border=\"1\" style=\"text-align:left;\">
	<tr style=\"background-color: #9999cc; font-weight: bold; color: #000000;\">
		<th>$MSG_2561 <!--Variable--></th><th>$MSG_246 <!--Valeur--></th>
	</tr>
	<tr>
		<td style=\"background-color: #ccccff; font-weight: bold; color: #000000;\">\$nom_site_front</td><td style=\"background-color: #cccccc; color: #000000;\">$nom_site_front</td>
	</tr>
	<tr>
		<td style=\"background-color: #ccccff; font-weight: bold; color: #000000;\">\$nom_site_back</td><td style=\"background-color: #cccccc; color: #000000;\">$nom_site_back</td>
	</tr>
	<tr>
		<td style=\"background-color: #ccccff; font-weight: bold; color: #000000;\">\$server</td><td style=\"background-color: #cccccc; color: #000000;\">$server</td>
	</tr>
	<tr>
		<td style=\"background-color: #ccccff; font-weight: bold; color: #000000;\">\$serverfront</td><td style=\"background-color: #cccccc; color: #000000;\">$serverfront</td>
	</tr>
	<tr>
		<td style=\"background-color: #ccccff; font-weight: bold; color: #000000;\">\$serverback</td><td style=\"background-color: #cccccc; color: #000000;\">$serverback</td>
	</tr>
	<tr>
		<td style=\"background-color: #ccccff; font-weight: bold; color: #000000;\">\$chemin_fo</td><td style=\"background-color: #cccccc; color: #000000;\">$chemin_fo</td>
	</tr>
	<tr>
		<td style=\"background-color: #ccccff; font-weight: bold; color: #000000;\">\$chemin_bo</td><td style=\"background-color: #cccccc; color: #000000;\">$chemin_bo</td>
	</tr>
	<tr>
		<td style=\"background-color: #ccccff; font-weight: bold; color: #000000;\">\$adressebase</td><td style=\"background-color: #cccccc; color: #000000;\">$adressebase</td>
	</tr>
	<tr>
		<td style=\"background-color: #ccccff; font-weight: bold; color: #000000;\">\$nombase</td><td style=\"background-color: #cccccc; color: #000000;\">$nombase</td>
	</tr>
	<tr>
		<td style=\"background-color: #ccccff; font-weight: bold; color: #000000;\">\$base_ref</td><td style=\"background-color: #cccccc; color: #000000;\">$base_ref</td>
	</tr>
	<tr>
		<td style=\"background-color: #ccccff; font-weight: bold; color: #000000;\">\$login</td><td style=\"background-color: #cccccc; color: #000000;\">$login</td>
	</tr>
	<tr>
		<td style=\"background-color: #ccccff; font-weight: bold; color: #000000;\">\$adressebase_archive</td><td style=\"background-color: #cccccc; color: #000000;\">$adressebase_archive</td>
	</tr>
	<tr>
		<td style=\"background-color: #ccccff; font-weight: bold; color: #000000;\">\$nombase_archive</td><td style=\"background-color: #cccccc; color: #000000;\">$nombase_archive</td>
	</tr>
	<tr>
		<td style=\"background-color: #ccccff; font-weight: bold; color: #000000;\">\$login_archive</td><td style=\"background-color: #cccccc; color: #000000;\">$login_archive</td>
	</tr>
</table>

<br/><h1>$MSG_2591 <!--Parametres personalises--> :</h1>
<table border=\"1\" style=\"text-align:left;\">
	<tr style=\"background-color: #9999cc; font-weight: bold; color: #000000;\">
		<th>$MSG_2561 <!--Variable--></th><th>$MSG_246 <!--Valeur--></th>
	</tr>
	<tr>
		<td style=\"background-color: #ccccff; font-weight: bold; color: #000000;\">\$langue_par_defaut</td><td style=\"background-color: #cccccc; color: #000000;\">$langue_par_defaut</td>
	</tr>
	<tr>
		<td style=\"background-color: #ccccff; font-weight: bold; color: #000000;\">MY_LANG (langue actuelle)</td><td style=\"background-color: #cccccc; color: #000000;\">".MY_LANG."</td>
	</tr>
	<tr>
		<td style=\"background-color: #ccccff; font-weight: bold; color: #000000;\">\$style_par_defaut</td><td style=\"background-color: #cccccc; color: #000000;\">$style_par_defaut</td>
	</tr>
	<tr>
		<td style=\"background-color: #ccccff; font-weight: bold; color: #000000;\">MY_STYLE (style actuel)</td><td style=\"background-color: #cccccc; color: #000000;\">".MY_STYLE."</td>
	</tr>
	<tr>
		<td style=\"background-color: #ccccff; font-weight: bold; color: #000000;\">VERSION_BASE (BDD defaut)</td><td style=\"background-color: #cccccc; color: #000000;\">".VERSION_BASE."</td>
	</tr>
	<tr>
		<td style=\"background-color: #ccccff; font-weight: bold; color: #000000;\">VERSION (BDD actuelle)</td><td style=\"background-color: #cccccc; color: #000000;\">".VERSION."</td>
	</tr>
</table>

<br/><h1>$MSG_2569 <!--Modules--> :</h1>
<table border=\"1\" style=\"text-align:left;\">
	<tr style=\"background-color: #9999cc; font-weight: bold; color: #000000;\">
		<th>$MSG_2561 <!--Variable--></th><th>$MSG_246 <!--Valeur--></th>
	</tr>
	<tr>
		<td style=\"background-color: #ccccff; font-weight: bold; color: #000000;\">M_Chat</td><td style=\"background-color: #cccccc; color: #000000;\">".M_Chat."</td>
	</tr>
	<tr>
		<td style=\"background-color: #ccccff; font-weight: bold; color: #000000;\">M_Forum</td><td style=\"background-color: #cccccc; color: #000000;\">".M_Forum."</td>
	</tr>
	<tr>
		<td style=\"background-color: #ccccff; font-weight: bold; color: #000000;\">M_Stats</td><td style=\"background-color: #cccccc; color: #000000;\">".M_Stats."</td>
	</tr>
	<tr>
		<td style=\"background-color: #ccccff; font-weight: bold; color: #000000;\">M_RessDocs</td><td style=\"background-color: #cccccc; color: #000000;\">".M_RessDocs."</td>
	</tr>
</table>");
}

/**
 * Affiche un objet (ou un tableau).
 * Equivaut � print_r() entre balise <pre></pre>.
 * 
 * @param mixed $objet L'objet(ou le tableau) � afficher
 */
function print_rr($objet){
	echo "<pre>";
	print_r($objet);
	echo "</pre>";
}

/**
 * Obtenir le code pays principal � partir d'un code pays conforme � la norme ISO 3166.
 * Un code pays conforme � la norme ISO 3166 est de la forme primary_SUB (ex: fr_FR).
 * @param $country_code string Code pays � la norme ISO 3166.
 * @return string Le code pays principal.
 */
function get_country_code_primary($country_code){
	if(substr_count($country_code,"_")!=1){
		die("get_country_code_primary($country_code): $country_code n'est pas un code de pays conforme.");
	}
	$country_code=explode("_",$country_code);
	return $country_code[0];
}

/**
 * Obtenir le code pays auxiliaire � partir d'un code pays conforme � la norme ISO 3166.
 * Un code pays conforme � la norme ISO 3166 est de la forme primary_SUB (ex: fr_FR).
 * @param $country_code string Code pays � la norme ISO 3166.
 * @return string Le code pays auxiliaire.
 */
function get_country_code_sub($country_code){
	if(substr_count($country_code,"_")!=1){
		die("get_country_code_sub($country_code): $country_code n'est pas un code de pays conforme.");
	}
	$country_code=explode("_",$country_code);
	return $country_code[1];
}

/**
 * Liste les fichiers d'un repertoire
 * @param string $dir
 */
function list_file ($dir){
	// on vire un eventuel slash mis par l'utilisateur de la fonction a droite du repertoire
	$dir = rtrim ($dir, '/');

	// si c'est un repertoire
	if (is_dir($dir)){
		// on l'ouvre
		$dh = opendir ($dir);
	}else{
		// sinon on sort! Appel de fonction non valide
		$error = $dir.", n'est pas un repertoire valide";
		return $error;
		exit;
	}
	//boucle pour parcourir le repertoire
	while (($file = readdir ($dh)) !== false ){
		if ($file !== '.' && $file !== '..' ) {
			if (!is_dir($dir."/".$file)) {
				$list_file []["$dir"] = $file;
			}
		}
	}
	closedir ($dh); // on ferme le repertoire courant
	return $list_file;
}

/**
 * Retourne des entiers jusqu'� une valeur max avec un pas
 * @param integer : pas
 * @param integer : max
 * @return res req
 */
 function gen_get_int_values($pas=null,$max=null){
 	$sql="select * from contraintes.af_gen_get_int_values($pas,$max) as (id integer)";
 	return pg_query($sql);
 }
 
 /**
 * Transforme un tableau PHP contenant des entiers en une chaine PHP pour eval.
 * La chaine retourn�e est au format utilisable chaine dans eval.
 * 
 * @param array : un tableau PHP d'entiers
 * @return string : une chaine PHP contenant les �l�ments du tableau au format PHP
 */
function int_array_to_php_array($array){
	if(!is_array($array)){
		die ("ici La fonction int_array_to_php_array($array) requiert un tableau en argument");
	}
	//pour r�indexer le tableau
	$array=(array_values($array));
	
	$chaine="Array  (";
	$nb=count($array);
	for($i=0; $i<$nb-1; $i++){
		$chaine.="$array[$i],";
	}
	if($nb>0)$chaine.=$array[$nb-1];
	$chaine.=") ";
	return $chaine;
}

function nl2br2($string) {
$string = str_replace(array("\r\n", "\r", "\n"), "<br />", $string);
return $string;
}



/**
 * Compare 2 tableaux
 * 
 * Retrourne true si les tablaux contiennent exactement les m�mes �l�ments
 * (valeurs, ordres, cl�es, etc,...)
 * 
 * @param array un tableau
 * @param array un autre tableau
 * @return bool true si les tableaux sont exactement identiques, false sinon
 * 
 */
function array_compare($t1,$t2){
	if(count($t1) != count($t2))
		return false;
	for($i=0;$i<count($t1);$i++){
		if($t1[$i]!=$t2[$i])
			return false;
			
	}
	return true;
	
}

/**
 * Evalue une chaine de caract�re contenant uniquement des messages de langue s�par�s par un d�limiteur.
 * 
 * @param string Une chaine de messages de langue s�par�s par un d�limiteur
 * @return string La chaine �valu�e avec le meme d�limiteur
 */
function eval_string_langues_messages($string,$separator=','){
	$final_string="";
	$string_array=explode($separator,$string);
	$i=count($string_array)-1;
	foreach($string_array as $k => $langue_message){
		$final_string.=eval('return '.$langue_message.';');
		if($k<$i){
			$final_string.=$separator;
		}
	}
	return $final_string;
}

?>