<?php
/*
	This file is part of Astairs.

    Astairs is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    any later version.

    Astairs is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Astairs.  If not, see <http://www.gnu.org/licenses/>.

	Copyright (C) 2006, 2007, 2008, 2009 AFIDE
    
	Auteurs:

	Said Ladjani <sladjani@yahoo.fr>
	Remi Cocquet <remi.cocquet@gmail.com>

*/

/**
 * Affichage de la page d'accueil du Backoffice. 
 * Cet affichage est compose d'une AstaitsPage (pag_dev), qui contient 2 PageComponent: un debut de page (debut)
 * et un contenu de page (contenu).
 */

//$NIVEAU_DEBUG=1;
$dbpath="../..";  //le dbpath sert a maintenir les inclusions apartir du $root

//-----------------------------------------------
//        		INCLUSIONS
//-----------------------------------------------
include("$dbpath/en_tete.php"); //contient les traitements communs a l'ensemble du FrameWork Astairs
$load_accueil=true;

//TODO rmi important: cette inclusion est ncessaire pour les messages envoys par le framework (drivs auth)
//cependant si on la fait on ne peu plus changer de langue avec les drapeaux.
//include("$root/langues/$langue_par_defaut/lang.php");

include("../en_tete_back.php"); //contient les traitements communs a l'ensemble du BackOffice Astairs
include("./includes.php"); //inclusions des librairies du module

//-----------------------------------------------
//        		ELEMENT DE PAGES
//-----------------------------------------------
$page_builder->setModuleRoot("$chemin_bo/accueil/templates/tpl");

$style_files[$style_file_path][]="bo_modules_rh.css";	 //styles des ressources humaines
$style_files[$style_file_path][]="bo_modules_ra.css";	//styles des ressources administratives
$style_files[$style_file_path][]="bo_modules_ro.css";	//styles des outils
$style_files[$style_file_path][]="bo_modules_rp.css"; //styles des ressources pédagogiques
messageDebugR("Fichier CSS charges:",$style_files);	
	
//les fichiers javascripts
messageDebugR("Fichier javascript charges:",$javascript_files);	

//le javascript interne
//$javascript_internal_code='';
messageDebug("Code javascript charge:<br>$javascript_internal_code");	

//la page
$page=new AccueilBoPage("Administration Astairs <i>version 2.0 alpha</i>",MSG_37,"../accueil/accueil.php","Retourner a l'accueil'",$page_builder, array('page_dev' => 'accueil_bo_page.tpl'),$style_files,$javascript_files,$javascript_internal_code,MENU_1);

//creation des elements pour la page
$page_debut=new AccueilBoPageDebut("Menu principal",$page_builder->getModuleRoot(),array('debut' => 'accueil_bo_page_debut.tpl'));
$page_contenu=new AccueilBoPageContenu('contenu',new ModuleBuilder(),new AccueilBoMenuStruct(),$page_builder->getModuleRoot(),array('contenu' => 'accueil_bo_page_contenu.tpl'));

//affectation des elements
$page->setComponent('debut', $page_debut);
$page->setComponent('contenu', $page_contenu);

//on parse
$page->parse();

//print_rr($page);

//on affiche
$page->p();


include("$dbpath/pied_page.php");
?>