<?php
/*
	This file is part of Astairs.

    Astairs is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    any later version.

    Astairs is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Astairs.  If not, see <http://www.gnu.org/licenses/>.

	Copyright (C) 2006, 2007, 2008, 2009 AFIDE
    
	Auteurs:

	Said Ladjani <sladjani@yahoo.fr>
	Remi Cocquet <remi.cocquet@gmail.com>

*/

/**
 * Affichage d'une AstairsPage de Back-office sp�cifique � l'accueil.
 * Affiche un titre de page uniquement: le valeurs n�c�ssaires � l'affichage du lien retour sont nulles.
 */ 
class AccueilBoPage extends AstairsPage{
	
	/**
	 * Constructeur.
	 * Appel du constructeur p�re (AstairsPageBO) avec les valeurs n�c�ssaires � l'affichage du lien retour � null.
	 * @param string $astairs_titre Titre � afficher 
	 * @param string $astairs_retour_libelle Libell� du lien retour � afficher
	 * @param string $astairs_retour_url URL du lien retour � afficher 
	 * @param string $astairs_retour_title Message sur le title du retour ( un retour par exemple)
	 * @param object PageBuilder $pageBuilder L'objet permettant de cr�er une page
	 * @param Array $templates Les templates � utiliser pour la cr�ation de la page
	 * @param Array $style_files Les feuilles de style
	 * @param Array $javascript_files Les fichiers javascript
	 * @param string $javascript_internal_code Le code javascript interne
	 */
	function AccueilBoPage($astairs_titre, $astairs_retour_libelle,$astairs_retour_url,$astairs_retour_title,$pageBuilder,$templates,$style_files,$javascript_files,$javascript_internal_code,$page_titre){
		global $chemin_bo,$dbpath,$obj_module;
		$javascript_files["$dbpath/lib_graphique/javascript"][]="bulles.js";
		$javascript_files["$dbpath/bo/templates/script"][]="javascript_back.js";
		$javascript_files["../module/templates/script"][]="select_module_droits_javascript.js";
		$javascript_internal_code.=get_module_individus_types_droits_tableau_javascript($obj_module->getId());
		parent::AstairsPage($pageBuilder,$templates,$style_files, $javascript_files,$javascript_internal_code);
		
		if($obj_module->have_perm('ADMIN')){
       		$this->page_droits=new guiBoModuleIndividusTypesDroits('page_droits',$obj_module,"$chemin_bo/module/templates/tpl",array('page_droits'=>'gui_bo_module_individus_types_droits.tpl'));
       		$this->setComponent('page_droits', $this->page_droits);
		}
		
		//cr�ation des �l�ments de la page
		$this->page_debut=new AstairsPageBoDebutAccueil("$chemin_bo/templates/tpl",array('page_header' => 'astairs_page_bo_debut_accueil.tpl'),$astairs_titre,null,null,null,$page_titre);
		$this->page_fin=new AstairsPageBoFin("$chemin_bo/templates/tpl",array('page_footer' => 'astairs_page_bo_fin.tpl'));

		//affectation des �l�ments
		$this->setComponent('page_header', $this->page_debut);
		$this->setComponent('page_footer', $this->page_fin);

		$val ['PAGE_TITLE'] = $page_titre;
		$val ['PAGE_DESCRIPTION']= 'description courte de la page';
		$val ['PAGE_KEYWORD']= 'liste des mots cles';
		$val ['PAGE_SUBJECT']= 'sujet de la page';
		$val ['PAGE_FAVICO']= ''; 
		$this->set_var($val);
		
	}
}
?>
