<?php
/*
	This file is part of Astairs.

    Astairs is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    any later version.

    Astairs is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Astairs.  If not, see <http://www.gnu.org/licenses/>.

	Copyright (C) 2006, 2007, 2008, 2009 AFIDE
    
	Auteurs:

	Said Ladjani <sladjani@yahoo.fr>
	Remi Cocquet <remi.cocquet@gmail.com>

*/

/**
 * Affichage du contenu de la page d'Accueil.
 * Obtient les modules de la plate-forme 
 * @param block_target {contenu}
 */
class AccueilBoPageContenu extends PageComponent{
	
	/**
	 * Constructeur.
	 * @param string $block_target Nom du bloc dans lequel on affiche ce PageComponent
	 * @param Object ModuleBuilder $moduleBuilder Objet permettant le chargement des modules
	 * @param Object AccueilBoMenuStruct $structure Objet qui fourni une structure pour l'organisation des menus
	 * @param string $module_root Chemin racine des fichiers de templates (TPL)
	 * @param string $templates Les fichiers de Templates
	 */
	function AccueilBoPageContenu($block_target,$moduleBuilder,$structure,$module_root=null,$templates=null){
		global $chemin_bo,$auth;
		parent::PageComponent($module_root,$templates);
	

		//recuperation des modules
		$moduleBuilder->loadModulesActifs();
		$moduleBuilder->buildModulesActifs();
		$modules=&$moduleBuilder->getModulesActifs();
		
//		print_rr($modules);
		
		//creation des sous menus, entites definies par $structure
		parent::set_block($block_target,'block','bloc_menus');
		$modules_menus=$structure->getModuleMenus();
		foreach($modules_menus as $ind_menu => $module_menu){	
//			print_rr($module_menu);		
			$module_menu_modules=$module_menu->getModules($modules);
//			print_rr($module_menu_modules);	
			if($module_menu->perm_check($auth->getUserId())&&count($module_menu_modules)>0){//
				$component=new guiBoAccueilModuleMenu('block_line',$module_menu,$module_menu_modules,"$chemin_bo/accueil/templates/tpl",array('block_line' => 'gui_bo_accueil_module_menu.tpl'));
				$this->setComponent('block_line', $component,true,'block','bloc_menus');
			}
		}
		//special: le root accde au menu du framework
		if($auth->is_root()){
			$module_menu_fw=new ModuleMenu('fw', 'Installation Astairs');
			$component=new guiBoAccueilModuleMenu('block_line',$module_menu_fw,$module_menu_fw->getModules($modules),"$chemin_bo/accueil/templates/tpl",array('block_line' => 'gui_bo_accueil_module_menu.tpl'));
			$this->setComponent('block_line', $component,true,'block','bloc_menus');
		}
	}
}
?>