<?php
/*
	This file is part of Astairs.

    Astairs is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    any later version.

    Astairs is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Astairs.  If not, see <http://www.gnu.org/licenses/>.

	Copyright (C) 2006, 2007, 2008, 2009 AFIDE
    
	Auteurs:

	Said Ladjani <sladjani@yahoo.fr>
	Remi Cocquet <remi.cocquet@gmail.com>

*/

/**
 * Class qui affiche l'ensemble du contenu de l'accueil dont la plupart des titres et les selects.
 * 
 * @package accueil
 */ 
class IndexPageContenu extends PageComponent{
	
	
	var $redirection_urls;
	
	/**
	 * Affiche les titres, les selects et le bouton de validation.
	 * 
	 * @param string $module_root Le chemin du dossier contenant les tpl requis
 	 * @param string[] $templates Le tableau contenant la variable de destination et le tpl requis pour l'objet
 	 */
	function IndexPageContenu($block_target,$redirection_urls,$module_root=null,$templates=null){
		
		global $auth;
		parent::PageComponent($module_root,$templates);
		
		$this->redirection_urls=$redirection_urls;
		$val ['INDEX_SELECTION_OFFICE'] = MSG_2713;
		$val ['MSG_538']=MSG_538;
		$val ['MSG_2361']=MSG_2361;
		$val ['WARN_115']=WARN_115;
		$val ['WARN_118']=WARN_118;
		$val ['INDEX_SELECTION_OFFICE_DEFAUT']=MSG_217; 
		$val ['INDEX_SELECTION_OFFICE_VALIDATION']=FORM_6;
//		$val ['ACCUEIL_USER_ID']=$auth->getUserId();
//		$val ['ACCUEIL_USER_UID']=$auth->getUid();  
		
		$this->set_block($block_target, 'urls', 'bloc_urls');
		foreach($redirection_urls as $code => $redirection_url){
			parent::set_var('INDEX_SELECTION_OFFICE_CODE',$code);
			parent::set_var('INDEX_SELECTION_OFFICE_LIB',$redirection_url[1]);
			Template::parse('bloc_urls', 'urls', true);
		}
		parent::set_var($val);
	}

	function submit($post){
		global $auth,$dbpath;

		if(isset($post['office'])){
//			$auth_uid=$auth->auth['uid'];
//		print_rr($auth);
//			$auth->unauth();
//			$auth->auth_reauth();
//			print("location:".$this->redirection_urls[$post['office']][1]."?uid=".$auth_uid);
			header("location:".$this->redirection_urls[$post['office']][2]);//."?uid=".$auth_uid);
			include("$dbpath/pied_page.php");
			exit();
		}else{
			AstairsTemplate::setPageMessage(ERROR_145,MSG_ERROR);			
			header("location:index.php");
			include("$dbpath/pied_page.php");
			exit();
//			header("location:index.php?uid=".$auth->auth['uid']);
		}
	}
}
?>