<?php
/*
	This file is part of Astairs.

    Astairs is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    any later version.

    Astairs is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Astairs.  If not, see <http://www.gnu.org/licenses/>.

	Copyright (C) 2006, 2007, 2008, 2009 AFIDE
    
	Auteurs:

	Said Ladjani <sladjani@yahoo.fr>
	Remi Cocquet <remi.cocquet@gmail.com>

*/

/**
 * Affichage d'un ModuleMenu pour l'accueil.
 * Il s'agit ici d'afficher le lib�ll� du ModuleMenu et les guiBoAccueilModuleMenuModule correspondants aux modules qui le composent.
 * 
 * @param var {MODULE_MENU_LIBELLE}
 * @param bloc {accueil_langues}
 */
class guiBoAccueilModuleMenu extends PageComponent{
	
	
	/**
	 * Constructeur.
	 * @param string $block_target Nom du bloc dans lequel on affiche ce PageComponent
	 * @param object ModuleMenu $module_menu Objet de d�finition de la structure de module � afficher
	 * @param object[] Module $modules Ensemble de modules pour lesquels on veut afficher un menu
	 * @param string $module_root Chemin racine des fichiers de templates (TPL)
	 * @param string $templates Les fichiers de Templates
	 */
	function guiBoAccueilModuleMenu($block_target,$module_menu,$modules,$module_root=null,$templates=null){
		global $chemin_bo;
//		print_rr($module_menu);
//		print_rr($modules);
		parent::PageComponent($module_root,$templates);
		parent::set_var('ACCUEIL_MODULE_MENU_CODE', strtolower('_'.$module_menu->getCode()));
		parent::set_var('ACCUEIL_MODULE_MENU_LIBELLE', $module_menu->getLibelle());
		
		//cr�ation des sous menus, entit�s d�finies par $structure
		parent::set_block($block_target,'block','bloc_submenus');
		foreach($modules as $ind_module => $module){
			
				if($module->have_perm()){		
//					print_rr($module);
					$component=new guiBoAccueilModuleMenuModule('module',$module,$module_root,array('block_line' => 'gui_bo_accueil_module_menu_module.tpl'),2,3);
					$this->setComponent('block_line', $component,true,'block','bloc_submenus');
				}
//				else{
//					echo "no perm ".$module->getLibelle()."<br>";
//				}
		}
					
	}
}
?>