<?php
/*
	This file is part of Astairs.

    Astairs is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    any later version.

    Astairs is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Astairs.  If not, see <http://www.gnu.org/licenses/>.

	Copyright (C) 2006, 2007, 2008, 2009 AFIDE
    
	Auteurs:

	Said Ladjani <sladjani@yahoo.fr>
	Remi Cocquet <remi.cocquet@gmail.com>

*/

/**
 * Affichage d'un Module et de ses composants dans un menu pour l'accueil.
 * 
 * @param block_target 'module'
 */
class guiBoAccueilModuleMenuModule extends PageComponent{
	
	
	/**
	 * Constructeur.
	 * @param string $block_target Nom du bloc dans lequel on affiche ce PageComponent
	 * @param Module $module Le Module � partir duquel on souhaite cr�er l'affichage
	 * @param string $module_root Chemin racine des fichiers de templates (TPL)
	 * @param string $templates Les fichiers de Templates
	 * @param integer $niveau_submenu Le niveau de sous-menu. Par d�fault � 2.Permet de gerer le style en fonction du niveau. (ex: <h$niveau_submenu>, class="menu_$niveau_submenu", ...)
	 * @param integer $niveau_submenu_max Le niveau de sous-menu maximum pour lequel on traite les sous menus (d�roulage des sous menus).Par d�faut � 3.
	 */
	function guiBoAccueilModuleMenuModule($block_target,$module,$module_root=null,$templates=null, $niveau_submenu=2,$niveau_submenu_max=3){
		parent::PageComponent($module_root,$templates);
		$module->loadSubModules();
		$module->loadPages();
		$pages=$module->getPages(); 
		$submodules=$module->getSubModules();
		
		//Si le module ne contient pas de sous modules,
		//on affiche les liens vers le module ou vers les pages
		if(count($submodules)==0){
			
			//Si le module ne contient pas de sous modules et qu'il ne contient pas de pages,
			// ou que l'on a atteind le niveau de sous menu maximal.
			//on affiche un lien avec le libell� du module. 
			if(count($pages)==0 || ($niveau_submenu==$niveau_submenu_max)){
				$module_no_submodule_no_page=new guiBoAccueilModuleMenuModuleLien($module,$module_root,array($block_target => 'gui_bo_accueil_module_menu_module_lien.tpl'), $niveau_submenu,$niveau_submenu_max);
				$this->setComponent($block_target,$module_no_submodule_no_page,true);
			}
			//Si le module ne contient pas de sous modules et qu'il contient des pages,
			//on affiche le libell� du module et les liens vers les pages
			else{
				$module_no_submodule_pages=new guiBoAccueilModuleMenuModulePages($block_target,$module,$pages,$module_root,array($block_target => 'gui_bo_accueil_module_menu_module_pages.tpl'), $niveau_submenu,$niveau_submenu_max);
				$this->setComponent($block_target,$module_no_submodule_pages,true);
			}
		}
		//Si le module contient des sous modules, 
		//on affiche les liens vers les sous modules 
		else{
			
			//Si le module contient des sous modules et qu'il ne contient pas de pages,
			//on affiche le libell� du module et des liens avec les libell�s des sous modules. 
			if(count($pages)==0){
				$module_submodules_no_pages=new guiBoAccueilModuleMenuModuleModules($block_target,$module,$submodules,$module_root,array($block_target => 'gui_bo_accueil_module_menu_module_modules.tpl'), $niveau_submenu,$niveau_submenu_max);
				$this->setComponent($block_target,$module_submodules_no_pages,true);
			}
			//Si le module contient des sous modules et qu'il contient des pages,
			//on affiche un lien avec le libell� du module. 
			else{
//				print_rr($module);				
				$module_no_submodule_no_pages=new guiBoAccueilModuleMenuModuleLien($module,$module_root,array($block_target => 'gui_bo_accueil_module_menu_module_lien.tpl'), $niveau_submenu,$niveau_submenu_max);
				$this->setComponent($block_target,$module_no_submodule_no_pages,true);
			}
			
		}		
	}
}
?>