<?php
/*
	This file is part of Astairs.

    Astairs is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    any later version.

    Astairs is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Astairs.  If not, see <http://www.gnu.org/licenses/>.

	Copyright (C) 2006, 2007, 2008, 2009 AFIDE
    
	Auteurs:

	Said Ladjani <sladjani@yahoo.fr>
	Remi Cocquet <remi.cocquet@gmail.com>

*/

/**
 * Affichage d'un Module.
 * Affiche un titre avec lien
 * 
 * @param var {MODULE_MENU_MODULE_LIBELLE}
 * @param var {MODULE_MENU_MODULE_URL}
 * @param var {MODULE_MENU_MODULE_BULLE}
 * @param var {MODULE_MENU_MODULE_NIVEAU}
 */
class guiBoAccueilModuleMenuModuleLien extends PageComponent{
	
	
	/**
	 * Constructeur.
	 * @param Module $module Le Module � partir duquel on souhaite cr�er l'affichage
	 * @param string $module_root Chemin racine des fichiers de templates (TPL)
	 * @param string $templates Les fichiers de Templates
	 * @param integer $niveau_submenu Le niveau de sous-menu. Par d�fault � 2.Permet de gerer le style en fonction du niveau. (ex: <h$niveau_submenu>, class="menu_$niveau_submenu", ...)
	 * @param integer $niveau_submenu_max Le niveau de sous-menu maximum pour lequel on traite les sous menus (d�roulage des sous menus).Par d�faut � 3.
	 */
	function guiBoAccueilModuleMenuModuleLien($module,$module_root=null,$templates=null, $niveau_submenu=2,$niveau_submenu_max=3){
		parent::PageComponent($module_root,$templates);
		global $root ,$s_langue;
//		require("$root/langues/".$s_langue."/lang.php");
//		print_rr($module);
		//on reduit au maximum l'objet pour qu'il puisse passer dans l'URL. (ie6)
		$module->unloadSubModules();
		$module->unloadPages();
		//le niveau, tr�s utile pour faire varier les styles en fonction des niveaux
		parent::set_var('MODULE_MENU_MODULE_NIVEAU',$niveau_submenu);
		parent::set_var('MODULE_MENU_MODULE_BULLE', eval('return '.$module->getDescription().';'));
		parent::set_var('MODULE_MENU_MODULE_LIBELLE', $module->getLibelle());
//		print_rr($module);
		parent::set_var('MODULE_MENU_MODULE_URL', "../module_menu/module_menu.php?sz_obj_module=".exportObject($module,$module->getId()));
			
	}
}
?>