<?php
/*
	This file is part of Astairs.

    Astairs is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    any later version.

    Astairs is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Astairs.  If not, see <http://www.gnu.org/licenses/>.

	Copyright (C) 2006, 2007, 2008, 2009 AFIDE
    
	Auteurs:

	Said Ladjani <sladjani@yahoo.fr>
	Remi Cocquet <remi.cocquet@gmail.com>

*/

/**
 * Affichage d'un Module.
 * Affiche un titre ainsi que ses sous modules.
 * 
 * @param var {MODULE_MENU_MODULE_NIVEAU}
 * @param var {MODULE_MENU_MODULE_LIBELLE}
 * @param block_target {$block_target}
 */
class guiBoAccueilModuleMenuModuleModules extends PageComponent{
	
	
	/**
	 * Constructeur.
	 * @param string $block_target Bloc cible dans lequel on veut afficher ce PageComponent
	 * @param object Module $module Le Module  partir duquel on souhaite crer l'affichage
	 * @param object[] Module $module Les sous Modules du Module
	 * @param string $module_root Chemin racine des fichiers de templates (TPL)
	 * @param string $templates Les fichiers de Templates
	 * @param integer $niveau_submenu Le niveau de sous-menu. Par dfault  2.Permet de gerer le style en fonction du niveau. (ex: <h$niveau_submenu>, class="menu_$niveau_submenu", ...)
	 * @param integer $niveau_submenu_max Le niveau de sous-menu maximum pour lequel on traite les sous menus (droulage des sous menus).Par dfaut  3.
	 */
	function guiBoAccueilModuleMenuModuleModules($block_target,$module,$submodules,$module_root=null,$templates=null, $niveau_submenu=2,$niveau_submenu_max=3){
		parent::PageComponent($module_root,$templates);
		
		//le niveau, trs utile pour faire varier les styles en fonction des niveaux
		parent::set_var('MODULE_MENU_MODULE_NIVEAU',$niveau_submenu);
		
		parent::set_var('MODULE_MENU_MODULE_LIBELLE', $module->getLibelle());
		
		//cration des sous menus, entits dfinies par $structure
		parent::set_block($block_target,'block','bloc_submenus');
		foreach($submodules as $ind_module => $module){
			$submodules=$module->getSubModules();
//			print_rr($module);
			if(count($submodules)==0){
				$component=new guiBoAccueilModuleMenuModule($block_target,$module,$module_root,array('block_line' => 'gui_bo_accueil_module_menu_module.tpl'), $niveau_submenu+1,$niveau_submenu_max);
				$this->setComponent('block_line', $component,true,'block','bloc_submenus');
			}
		}
	}
}
?>