<?php
/*
	This file is part of Astairs.

    Astairs is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    any later version.

    Astairs is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Astairs.  If not, see <http://www.gnu.org/licenses/>.

	Copyright (C) 2006, 2007, 2008, 2009 AFIDE
    
	Auteurs:

	Said Ladjani <sladjani@yahoo.fr>
	Remi Cocquet <remi.cocquet@gmail.com>

*/

/**
    Gestion de l'archivage
    @package archive
*/

/*--------------------------------------------------------------*/
//          IDENTIFICATION
/*--------------------------------------------------------------*/
require('../dbpostgres.php3');
$nombase_archive=$nombase."_archive";
$db=pg_connect($server,"","","","$nombase_archive");
require("$chemin_bo/lib/lib_formation.php");
require("$chemin_bo/lib/obj_formation.php");
require("../fonctions_archivage.php");
include('./sup_cal.php3');

/*--------------------------------------------------------------*/
//          AFFICHAGE ENTETE
/*--------------------------------------------------------------*/
function entete($groupe, $prec, $nomgroup, $nompage, $titre, $page_precedente, $reload) {

    global $s_numcal;
    global $site_heberge;
    global $s_admin;
    global $s_serverback;
    global $serverback;
    global $IP;
    global $chemin_bo;
    global $MSG_9, $MSG_10, $MSG_11, $MSG_12, $MSG_13, $MSG_14, $ERROR_5 , $WARN_9, $WARN_21;

    // variables ncessaires pour faire fonctionner la fonction javascript testMax
    global $nbstaggp, $nbplacemax ;

    //pour rafraichir la frame de gauche
    //if($reload==1)$fonctionONLOAD="reloadMenu()";

    $path = "..";
    $javascriptFILE = "./javascript_archive.php";
    $styleCSS = "../style/".MY_STYLE."/ressourcesAdministratives.css";

    include ('../entete.php3');
}

switch ($action_archive) {

    case "lister" :
        switch($mode_selection){
            case 'formateur' :
                $res=get_formateurs_formations();
                $option_value=$MSG_198;
                $colonne_deux=$MSG_184;
            break;
        }
        $nb=pg_numrows($res);
        entete($gestgp, $prec, $nomgroupe, MENU_10, "Gestions des archives", $page_precedente, $reload);
        print("
        <br>
        <center>
        <table border=0>
        <tr>
        <form name=\"formu\">
        <td>$MSG_217</td><td><select name=\"num\" onchange=\"valide_select();\">
        <option value=\"\">$option_value
        ");
        for($i=0;$i<$nb;$i++){
            $row=pg_fetch_row($res,$i);
            if($row[0]==$num)
                print("
                <option value=\"$row[0]\" selected>$row[1] $row[2]</option>
                ");
            else
                print("
                <option value=\"$row[0]\">$row[1] $row[2]</option>
                ");
        }
        print("
        </select>
        </td>
        </tr>
        <input type=hidden name=\"action_archive\" value=\"$action_archive\">
        <input type=hidden name=\"mode_selection\" value=\"$mode_selection\">
        </form>
        </table>
        </center>
        ");
        if($num!=""){
            print("
            <br>
            <!--
                <a href=\"#ancienne\">$MSG_1285</a>&nbsp;|
                <a href=\"#actuelle\">$MSG_1284</a>&nbsp;|
                <a href=\"#future\">$MSG_1286</a>
            <br><br>
            -->
            <table class=\"tableau_espace\">
                <caption>$MSG_680</caption>
                <tr>
                    <th>$MSG_2410</th>
                    <th>$colonne_deux</th>
                    <th>$MSG_2370</th>
                    <th>$FORM_1</th>
                </tr>
            ");
            if($mode_selection=="formateur")
                print("
                <form name=\"suppForm\" method=\"post\">
                ");
            $one=0;
            $today=date("Y-m-d");
            $nbSuppPossible=0;
            $typeTab=array();
            for($p=0;$p<3;$p++){
                $periode=$p + 1;
                switch($periode){
                    case 1:
                        $condition=" AND D2.jour < '$today' ";
                    break;
                    case 2:
                        $condition=" AND NOT (D1.jour > '$today' OR D2.jour < '$today') ";
                    break;
                    case 3:
                        $condition=" AND D1.jour > '$today' ";
                    break;
                }
                // la requte en fonction du mode de slection
                switch($mode_selection){
                    /*
                    case "theme" :
                        $result=get_formations_theme_periode($num,$periode);
                    break;
                    case "groupe" :
                        $result=get_formations_groupe_periode($num,$periode);
                    break;
                    */
                    case "formateur" :
                        $result=get_formations_formateur_periode($num,$periode,"ASC",0);
                    break;
                    /*
                    case "stagiaire" :
                        $result=get_formations_stagiaire_periode($num,$periode);
                    break;
                    */
                }
                //$result=pg_query($sql);
                $nb=pg_numrows($result);
                if($nb>0)
                    $typeTab[]=$result;
                else
                    $typeTab[]=-1;
            }
            if(sizeof($typeTab)>0){
                for($i=0;$i<sizeof($typeTab);$i++){
                    if($typeTab[$i] != -1){
                        $res=$typeTab[$i];
                        switch($i){
                            case 0 :
                                $libelle=$MSG_1213;
                                $ancre="ancienne";
                            break;
                            case 1 :
                                $libelle=$MSG_1214;
                                $ancre="actuelle";
                            break;
                            case 2 :
                                $libelle=$MSG_1286;
                                $ancre="future";
                            break;
                        }
                        $one++;
                        print("<tr class=\"couleur1\"><td colspan=\"4\" align=\"center\" height=\"50\" valign=\"middle\"><a name=\"$ancre\"></a><b>$libelle</b></td></tr>");
                        $countcolor=0;

                        while($row=pg_fetch_array($res)){
                            //formatage date
                            $tabdeb=explode("-",$row["debut"]);
                            $deb=formater_date($tabdeb,MY_LANG);
                            $tabfin=explode("-",$row["fin"]);
                            $fin=formater_date($tabfin,MY_LANG);

                            $classcolor=($countcolor%2==0||$countcolor==0?"couleur2":"couleur3");

                            print("
                            <tr class=\"$classcolor\">
                            <td>$row[formation]</td>
                            ");
                            if($mode_selection=="groupe")
                                print("
                                <td><font size=\"2\">$row[0]&nbsp;$row[1]</font></td>
                                ");
                            else
                                print("
                                <td><font size=\"2\">".libelle($row[g_num_gest_g],$database,"classe")."</font></td>
                                ");
                            print("
                            <td><font size=\"2\">$MSG_135 $deb $MSG_136 $fin</font></td>
                            <td>
                            <!--<a class=\"action\" href=\"archive.php?action_archive=detail&num_cal=$row[num_cal]\">$MSG_649</a><br>-->
                            ");
                            if($mode_selection=="formateur")
                                print("
                                <!--<a href=\"editcal.php?num_cal=".$row["num_cal"]."&theme=$theme\">$FORM_2</a><br>-->
                                <!--<a class=\"action\" href=\"editcal.php?num_cal=".$row["num_formation"]."&theme=$theme\">$FORM_2</a><br>-->
                                <!--
                                <a class=\"action\" OnClick=\"if(document.suppForm.supp$row[num_cal].checked==true) document.suppForm.supp$row[num_cal].checked = false ; else document.suppForm.supp$row[num_cal].checked = true ;\">$FORM_4</a>
                                <input type=\"checkbox\" name=\"supp$row[num_cal]\">
                                -->
                                <!--
                                <a class=\"action\" OnClick=\"if(document.suppForm.supp$row[num_formation].checked==true) document.suppForm.supp$row[num_formation].checked = false ; else document.suppForm.supp$row[num_formation].checked = true ;\">$FORM_4</a>
                                <input type=\"checkbox\" name=\"supp$row[num_formation]\">
                                -->
                                <a class=\"action\" href=\"./archive.php?action_archive=restaurer&num_cal=".$row["num_cal"]."\">Restauration</a>
                            </td>
                            </tr>
                            ");
                            $countcolor++;
                            $nbSuppPossible++;
                        }
                    }
                }
            }


            /*
            print("
            </table>
            <br>
            <A HREF=\"#ancienne\">$MSG_1285</a>&nbsp;|
            <A HREF=\"#actuelle\">$MSG_1284</a>&nbsp;|
            <A HREF=\"#future\">$MSG_1286</a>
            <br>
            ");
            */
            /*
            if($mode_selection=="formateur")
                print("<br>
                <table class=\"tableau_message\">
                    <tr>
                        <td>
                            <input type=\"button\" name=\"cocher\" value=\"Tout cocher\" onClick=\"toutselect($nbSuppPossible)\">
                            <input type=\"button\" name=\"decocher\" value=\"Tout dcocher\" onClick=\"toutselect(".(-$nbSuppPossible).")\"><br><br>
                            <input type=\"submit\" value=\"suppression\" name=\"suppression\">
                        </td>

                    </tr>

                </table>");
            */
            print("</form></table>");


        }

    break;
    break;

    case 'restaurer' :
        //entete($gestgp, $prec, $nomgroupe, MENU_10, "Restauration", $page_precedente, $reload);
        include('./restaurer_archive.php');
    break;

    default :
        entete($gestgp, $prec, $nomgroupe, MENU_10, "Gestions des archives", $page_precedente, $reload);
        include('./menuArchive.php');
    break;

}


include('../piedpage.php3');

?>