<?php
/*
	This file is part of Astairs.

    Astairs is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    any later version.

    Astairs is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Astairs.  If not, see <http://www.gnu.org/licenses/>.

	Copyright (C) 2006, 2007, 2008, 2009 AFIDE
    
	Auteurs:

	Said Ladjani <sladjani@yahoo.fr>
	Remi Cocquet <remi.cocquet@gmail.com>

*/

/*------------------------------------------------------*/
//      Fichier sup_cal.php3
//      Auteur : S.Ladjani
//      Action : sauvegarde des rsultats
//                    suppresion d'un calendrier
//                    mise  jour des tables  (faisant rfrence au n de calendrier)
//      Donnes reues : $num_cal ==> N de calendrier
/*------------------------------------------------------*/
/*require('../dbpostgres.php3');
$db = pg_Connect("$server", "", "", "", "$nombase");
if(!$db){
        print "<B>Impossible d'acc&eacute;der &agrave; la base de donn&eacute;es.</B><BR>";
        exit;
}
*/
/*------------------------------------------------------*/
//              FONCTIONS PHP  (pour les sauvegardes)
/*------------------------------------------------------*/
// fonction de sauvegarde du theme
function sauvegarde_theme($num_theme){
    // test si le theme existe dej ds la table suavegarde_theme
    $req="select * from sauvegarde_theme where num_theme='$num_theme'";
    $res=pg_query($req);
    if(pg_numrows($res)==0){
        $req="select nom_theme from themedir where num_themedir='$num_theme'";
        $res=pg_query($req);
        $row=pg_fetch_row($res,0);
        $req="insert into sauvegarde_theme values('$num_theme','$row[0]')";
        $ins=pg_query($req);
    }

}
/*------------------------------------------------------*/
// fonction de sauvegarde des valuation (qcm,exotlc ...)
function sauvegarde_evaluation($num_cal,$num_exo,$type){
    switch($type){
        case 'Q' : // sauvegarde d'un nom de questionnaire
            // test si existe ds la table sauvegarde_evaluation
            $req="select * from sauvegarde_evaluation where num_exo='$num_exo' and type='$type'";
            $res=pg_query($req);
            if(pg_numrows($res)==0){
                $req="select libelle_qstaire,theme from questionnaire where num_qstaire='$num_exo'";
                $resqstaire=pg_query($req);
                $rowqstaire=pg_fetch_row($resqstaire,0);
                $req="insert into sauvegarde_evaluation values('$num_exo','$rowqstaire[0]','$type','$rowqstaire[1]')";
                $ins=pg_query($req);
                // sauvegarde du theme
                sauvegarde_theme($rowqstaire[1]);
            }
        break;
        case 'B' : // sauvegarde du nom de la serie (remplir les blancs)
            // test si existe ds la table sauvegarde_evaluation
            $req="select * from sauvegarde_evaluation where num_exo='$num_exo' and type='$type'";
            $res=pg_query($req);
            if(pg_numrows($res)==0){
                $req="select titre,theme from serie_exo where id='$num_exo'";
                $resblanc=pg_query($req);
                $rowblanc=pg_fetch_row($resblanc,0);
                $req="insert into sauvegarde_evaluation values('$num_exo','$rowblanc[0]','$type','$rowblanc[1]')";
                $ins=pg_query($req);
                sauvegarde_theme($rowblanc[1]);
            }
        break;
        case 'E' : // sauvegarde du nom de l'exotlc
            // test si existe ds la table sauvegarde_evaluation
            $req="select * from sauvegarde_evaluation where num_exo='$num_exo' and type='$type'";
            $res=pg_query($req);
            if(pg_numrows($res)==0){
                $req="select titre from exotlc where num_exo='$num_exo'";
                $resexo=pg_query($req);
                $rowexo=pg_fetch_row($resexo,0);
                $titre=addslashes($rowexo[0]);
                // recup du theme de l'exo
                $req="select distinct num_themedir,nom_theme from themedir where num_themedir in
                (select distinct num_themedir from fictlc where num_fic in (select gestfic_num_fic from gestfic where gestfic_num_exo='$num_exo'))";
                $res=pg_query($req);
                $row=pg_fetch_row($res,0);
                $req="insert into sauvegarde_evaluation values('$num_exo','$titre','$type','$row[0]')";
                $ins=pg_query($req);
                // sauvegarde du theme
                sauvegarde_theme($row[0]);
            }

        break;
        case 'G' : // sauvegarde du nom de la grille (presentiel)
             // test si existe ds la table sauvegarde_evaluation
            $req="select * from sauvegarde_evaluation where num_exo='$num_exo' and type='$type'";
            $res=pg_query($req);
            if(pg_numrows($res)==0){
                $req="select libelle_grille,theme from grille where num_grille='$num_exo'";
                $resgrille=pg_query($req);
                $rowgrille=pg_fetch_row($resgrille,0);
                $nomexo=addslashes($rowgrille[0]);
                $req="insert into sauvegarde_evaluation values('$num_exo','$nomexo','$type','$rowgrille[1]')";
                $ins=pg_query($req);
                // sauvegarde du theme
                sauvegarde_theme($rowgrille[1]);
            }
        break;

        case 'T' : // sauvegarde du nom du titre de capacite (presentiel)
             // test si existe ds la table sauvegarde_evaluation
            $req="select * from sauvegarde_evaluation where num_exo='$num_exo' and type='$type'";
            $res=pg_query($req);
            if(pg_numrows($res)==0){
                $req="select libelle_titrecapacite,theme from titrecapacite where num_titrecapacite='$num_exo'";
                $restitrecapacite=pg_query($req);
                $rowtitrecapacite=pg_fetch_row($restitrecapacite,0);
                $req="insert into sauvegarde_evaluation values('$num_exo','$rowtitrecapacite[0]','$type','$rowtitrecapacite[1]')";
                $ins=pg_query($req);
                // sauvegarde du theme
                sauvegarde_theme($rowtitrecapacite[1]);
            }
        break;
        case 'C' : // sauvegarde du nom de la capacite (presentiel)
             // test si existe ds la table sauvegarde_evaluation
            $req="select * from sauvegarde_evaluation where num_exo='$num_exo' and type='$type'";
            $res=pg_query($req);
            if(pg_numrows($res)==0){
                $req="select libelle_capacite,theme from capacite where num_capacite='$num_exo'";
                $rescapacite=pg_query($req);
                $rowcapacite=pg_fetch_row($rescapacite,0);
                $req="insert into sauvegarde_evaluation values('$num_exo','$rowcapacite[0]','$type','$rowcapacite[1]')";
                $ins=pg_query($req);
                // sauvegarde du theme
                sauvegarde_theme($rowcapacite[1]);
            }
        break;
        case 'R' : // sauvegarde du nom de rubrique (exotlc)
            // test si existe
            $req="select * from sauvegarde_evaluation where num_exo='$num_exo' and type='$type'";
            $res=pg_query($req);
            if(pg_numrows($res)==0){
                $req="select libelle_rub,rub_numtheme from rubrique where num_rub='$num_exo'";
                $resrub=pg_query($req);
                $rowrub=pg_fetch_row($resrub);
                $req="insert into sauvegarde_evaluation values('$num_exo','$rowrub[0]','$type','$rowrub[1]')";
                $ins=pg_query($req);
                // sauvegarde du theme
                sauvegarde_theme($rowrub[1]);
            }

        break;
        case 'SR' : // sauvegarde du nom de sous rubrique (exotlc)
        // test si existe
            $req="select * from sauvegarde_evaluation where num_exo='$num_exo' and type='$type'";
            $res=pg_query($req);
            if(pg_numrows($res)==0){
                $req="select libelle_srub,srub_numtheme from sousrubrique where num_srub='$num_exo'";
                $ressrub=pg_query($req);
                $rowsrub=pg_fetch_row($ressrub);
                $req="insert into sauvegarde_evaluation values('$num_exo','$rowsrub[0]','$type','$rowsrub[1]')";
                $ins=pg_query($req);
                // sauvegarde du theme
                sauvegarde_theme($rowsrub[1]);
            }

        break;
    }

}
/*------------------------------------------------------*/
// fonction de sauvegarde des dates
function sauvegarde_date($tab){
    $sz=sizeof($tab);
    for($i=0;$i<$sz;$i++){
        //recup de la date dans dates
        $req="select jour from dates where num_date='$tab[$i]'";
        $res=pg_query($req);
        $row=pg_fetch_row($res,0);
        // test si la date existe dej
        $req="select * from sauvegarde_date where num_date='$tab[$i]'";
        $restest=pg_query($req);
        if(pg_numrows($restest)==0){
            $req="insert into sauvegarde_date values('$tab[$i]','$row[0]')";
            $ins=pg_query($req);
            // debug
            //echo "req=$req<br>";
        }
    }

}
/*------------------------------------------------------*/
// function de sauvegarde du calendrier  et des dates (presentiel,synchrone et asynchrone)
function sauvegarde_calendrier($num_cal){
    global $db;
     // recup du nom et des dates du calendrier
    $req="select nom_cal,datedeb,datefin from calendrier where num_cal='$num_cal'";
    $res=pg_query($req);
    $row=pg_fetch_row($res,0);
    $nomcal=$row[0];
    // date de debut
    $req="select jour from dates where num_date='$row[1]'";
    $resdeb=pg_query($req);
    $rowdeb=pg_fetch_row($resdeb,0);
    $datedeb=$rowdeb[0];
    // date de fin
    $req="select jour from dates where num_date='$row[2]'";
    $resfin=pg_query($req);
    $rowfin=pg_fetch_row($resfin,0);
    $datefin=$rowfin[0];
    // recup des dates presentiel,synchrone et asynchrone (s'il y en a)
    $req="select distinct num_date from gest_cal where gnum_cal='$num_cal' and numtype='3'";
    $res=pg_query($req);
    $cnt=pg_numrows($res);
    if($cnt>0){
        $tab=array();
        for($i=0;$i<$cnt;$i++){
            $row=pg_fetch_row($res,$i);
            $tab[]=$row[0];
        }
        $date_presentiel=implode(",",$tab);
        // sauvegarde des dates
        sauvegarde_date($tab);
    }
    else
        $date_presentiel="";
    $req="select distinct num_date from gest_cal where gnum_cal='$num_cal' and numtype='1'";
    $res=pg_query($req);
    $cnt=pg_numrows($res);
    if($cnt>0){
        $tab=array();
        for($i=0;$i<$cnt;$i++){
            $row=pg_fetch_row($res,$i);
            $tab[]=$row[0];
        }
        $date_synchrone=implode(",",$tab);
        // sauvegarde des dates
        sauvegarde_date($tab);
    }
    else
        $date_synchrone="";
    $req="select distinct num_date from gest_cal where gnum_cal='$num_cal' and numtype='2'";
    $res=pg_query($req);
    $cnt=pg_numrows($res);
    if($cnt>0){
        $tab=array();
        for($i=0;$i<$cnt;$i++){
            $row=pg_fetch_row($res,$i);
            $tab[]=$row[0];
        }
        $date_asynchrone=implode(",",$tab);
        // sauvegarde des dates
        sauvegarde_date($tab);
    }
    else
        $date_asynchrone="";
    // recup du numero de la filiere suivie
    $req="select num_c_q_e_d from gestparcours where g_num_parcours in (select g_num_parcours from gestionnaire where g_num_cal='$num_cal') and
    num_etape='1'";
    $res=pg_query($req);
    $row=pg_fetch_row($res,0);
    $numcours=$row[0];
    $nomfiliere=libelle($numcours,$db,"filiere");
    // recup de la taille du groupe
    $req="select distinct gu_num_user  from gestionutil where gu_num_gest_gr in (select g_num_gest_g from gestionnaire where g_num_cal='$num_cal')";
    $res=pg_query($req);
    $taille_groupe=pg_numrows($res);
    // debug
    /*
    print("
    nomcal=$nomcal<br>datedeb=$datedeb<br>datefin=$datefin<br>date_presentiel=$date_presentiel<br>
    date_synchrone=$date_synchrone<br>date_asynchrone=$date_asynchrone<br>nom_filiere=$nomfiliere<br>taille_groupe=$taille_groupe
    ");
    */

    // insertion dans la table sauvegarde_calendrier
    $req="insert into sauvegarde_calendrier values('$num_cal','$nomcal','$datedeb','$datefin','$date_presentiel','$date_synchrone','$date_asynchrone','$nomfiliere','$taille_groupe')";
    $ins=pg_query($req);
}
/*------------------------------------------------------*/
// fonction de sauvegarde des notes des exotlc par rubriques et sous rubriques
function sauvegarde_exorubrique($num_exo,$num_cal){
    $req="select * from gestexotlc where gesttlc_exo='$num_exo' and num_cal='$num_cal'";
    $res=pg_query($req);
    $cnt=pg_numrows($res);
    if($cnt>0){
        for($i=0;$i<$cnt;$i++){
            $row=pg_fetch_row($res,$i);
            // ramne la note sur 20
            $notesur20=($row[5]*20)/$row[6];
            // arrondi
            $notesur20 *=100;
            $notesur20 =round($notesur20);
            $notesur20 /=100;
            // insertion dans la table sauvegarde_exorubrique
            $req="insert into sauvegarde_exorubrique values('$num_cal','$row[4]','$row[1]','$row[2]','$row[3]','$notesur20')";
            $ins=pg_query($req);
            // sauvegarde des evaluation (rubrique et sous rubrique)
            $type='R';
            sauvegarde_evaluation($num_cal,$row[2],$type);
            if($row[3]>0){
                $type='SR';
                sauvegarde_evaluation($num_cal,$row[3],$type);
            }
        }

    }
}
/*------------------------------------------------------*/
// fonction de sauvegarde des rsultats propres  un calendrier
function sauvegarde_resultat($num_cal){
    // y a t il des qcm ?
    $req="select * from gestionqstn where num_cal='$num_cal'";
    $res=pg_query($req);
    $cnt=pg_numrows($res);
    if($cnt>0){
        $type='Q';
        for($i=0;$i<$cnt;$i++){
            $row=pg_fetch_row($res,$i);
            // on calcule la note sur 20
            if($row[7]>0){
                $notesur20=($row[3]*20)/$row[7];
                // arrondi
                $notesur20 *=100;
                $notesur20 =round($notesur20);
                $notesur20 /=100;
            }
            else
                $notesur20="";

            // insertion dans la table sauvegarde_resultat
            $req="insert into sauvegarde_resultat values('$num_cal','$row[0]','$row[1]','$notesur20','$row[6]','$type')";
            $ins=pg_query($req);
            // sauvegarde du qcm
            sauvegarde_evaluation($num_cal,$row[1],$type);

        }
    }
    // y a t il des exotlc ?
    $req="select * from resexouser where num_cal='$num_cal'";
    $res=pg_query($req);
    $cnt=pg_numrows($res);
    if($cnt>0){
        $type='E';
        for($i=0;$i<$cnt;$i++){
             $row=pg_fetch_row($res,$i);
            // on calcule la note sur 20
            $notesur20=($row[5]*20)/$row[4];
            // arrondi
            $notesur20 *=100;
            $notesur20 =round($notesur20);
            $notesur20 /=100;

            // insertion dans la table sauvegarde_resultat
            $req="insert into sauvegarde_resultat values('$num_cal','$row[1]','$row[2]','$notesur20','$row[6]','$type')";
            $ins=pg_query($req);
            sauvegarde_evaluation($num_cal,$row[2],$type);
            // pour chaque exo on sauvegarde les notes par rubriques et sousrubrique
            sauvegarde_exorubrique($row[2],$num_cal);

        }
    }
    // y a t il des grille notes ?
    // voir sauvegarde_presentiel
    // a suivre remplir les blancs ...
    // sauvegarde des sries
    $req="select * from res_serie where id_formation='$num_cal'";
    $res=pg_query($req);
    $cnt=pg_numrows($res);
    if($cnt>0){
        $type='B';
        for($i=0;$i<$cnt;$i++){
            $row=pg_fetch_row($res,$i);
            // insertion
            $req="insert into sauvegarde_resultat(num_cal,num_user,num_exo,notesurvingt,type) values('$num_cal','$row[0]','$row[2]','$row[3]','$type')";
            $ins=pg_query($req);
            sauvegarde_evaluation($num_cal,$row[2],$type);
        }
    }

}
/*------------------------------------------------------*/
// fonction de sauvegarde du suivi presentiel
function sauvegarde_presentiel($num_cal){
    $req="select * from notation where num_cal='$num_cal'";
    $res=pg_query($req);
    $cnt=pg_numrows($res);
    if($cnt>0){
        for($i=0;$i<$cnt;$i++){
            $row=pg_fetch_row($res,$i);
            $req="insert into sauvegarde_presentiel values('$row[0]','$row[1]','$row[2]','$row[3]','$row[4]','$row[5]')";
            // sauvegarde des grilles,titrecapacites et capacites
            $type='G';
            sauvegarde_evaluation($num_cal,$row[2],$type);
            $type='T';
            sauvegarde_evaluation($num_cal,$row[3],$type);
            $type='C';
            sauvegarde_evaluation($num_cal,$row[4],$type);
            $ins=pg_query($req);
            // recup des notes/date de la capacite
            $req="select num_date,note,notesur from comment_presentiel where num_cal='$row[0]' and num_user='$row[1]' and num_grille='$row[2]' and
            num_titrecapacite='$row[3]' and num_capacite='$row[4]'";
            $resnote=pg_query($req);
            $nbnote=pg_numrows($resnote);
            //echo "nbnote=$nbnote<br>";
            if($nbnote>0){
                $liste_note="";
                for($j=0;$j<$nbnote;$j++){
                    $rownote=pg_fetch_row($resnote,$j);
                    if($rownote[2]>0){
                        // ramne la note sur 20
                        $notecapa=($rownote[1]*20)/$rownote[2];
                        // arrondi
                        $notecapa *=100;
                        $notecapa =round($notecapa);
                        $notecapa /=100;
                    }
                    else
                        $notecapa=" ";
                    //test si dernier
                    if($j==$nbnote-1)
                        $liste_note .=$rownote[0].":".$notecapa;
                    else
                        $liste_note .=$rownote[0].":".$notecapa."-";
                }
                $req="update sauvegarde_presentiel set notesurvingt='$liste_note' where num_cal='$row[0]' and num_user='$row[1]' and num_grille='$row[2]' and
                num_titrecapacite='$row[3]' and num_capacite='$row[4]'";
                $maj=pg_query($req);

            }

        }
    }

}
// transformation de cette partie (DelCal) en fonction pour pouvoir supprimer plusieurs formations d'un coup
function DelCal($num_cal,$archive=0){
            /*------------------------------------------------------*/
            //              SAUVEGARDE  (si $archive==0)
            /*------------------------------------------------------*/
            if($archive==0){
                // sauvegarde du calendrier
                sauvegarde_calendrier($num_cal);

                // sauvegarde resultats  (qcm,exotlc)
                sauvegarde_resultat($num_cal);

                // sauvegarde presentiel (notation)
                sauvegarde_presentiel($num_cal);
            }

            /*------------------------------------------------------*/
            //              SUPPRESSION
            /*------------------------------------------------------*/
            // en commentaire pour le moment

            // arcticles (forum)
            // recup du n de forum pour le n de calendrier (formation)
            $res=pg_query("select numforum from gestforum where numformation='$num_cal';");
            if(pg_numrows($res)==1){
            $row=pg_fetch_row($res,0);
            $del=pg_query("delete from articles where forum='$row[0]';");
            }
            // gestforum
            $del=pg_query("delete from gestforum where numformation='$num_cal';");
            // commentairepage
            $del=pg_query("delete from commentairepage where num_cal='$num_cal';");
            // configpage
            $del=pg_query("delete from configpage where num_cal='$num_cal';");
            // gestqcm  et gestserie
            $del=pg_query("delete from gestqcm where num_cal='$num_cal';");
            $del=pg_query("delete from gestserie where num_cal='$num_cal';");
            // qcm_bloquant  et serie_bloquante
            $del=pg_query("delete from qcm_bloquant where num_cal='$num_cal';");
            $del=pg_query("delete from serie_bloquante where num_cal='$num_cal';");
            // series aleatoires
            $del=pg_query("delete from asso_exo_serie_aleatoire where num_cal='$num_cal';");
            // titrepage
            $del=pg_query("delete from titrepage where num_cal='$num_cal';");
            // ressource_gest ,ressource_fic,ressource_sec,ressource_esp
            $res=pg_query("select num_fic,num_section,num_espace from ressource_gest where num_cal='$num_cal';");
            $del=pg_query("delete from ressource_gest where num_cal='$num_cal';");
            // commentuserrub
            $del=pg_query("delete from commentuserrub where num_cal='$num_cal';");
            // gestionparcours
            // NOTE IMPORTANTE : Cette table n'a pas de rfrence directe au n de calendrier et
            //                                       dans la table gestionnaire le couple "groupe / parcours" peut
            //                                       tre associ  plusieurs calendrier.
            // La question est : Pourquoi un groupe suivrait-il le mme parcours dans des formations diffrentes ?
            // On supprimera donc le couple "groupe / parcours" de gestion parcours si et seulement si il est
            // associ  un seul calendrier dans la table gestionnaire.
            // NOTE IMPORTANTE : (11-02-2003) Il est prvu d'ajouter un champ num_cal  la table gestionparcours
            // recup du groupe et du parcours
            $resgrparc=pg_query("select distinct g_num_gest_g,g_num_parcours from gestionnaire where g_num_cal='$num_cal';");
            $rowgrparc=pg_fetch_row($resgrparc,0);
            // debug
            //echo "groupe=$rowgrparc[0] et parcours=$rowgrparc[1]<br>";
            // test si unique  (si oui alors suppression)
            $restest=pg_query("select distinct g_num_cal from gestionnaire where g_num_gest_g='$rowgrparc[0]' and g_num_parcours='$rowgrparc[1]';");
            if(pg_numrows($restest)==1)
            $del=pg_query("delete from gestionparcours where gp_num_groupe='$rowgrparc[0]' and gp_num_parcours='$rowgrparc[1]';");
            else
            $del=pg_query("delete from gestionparcours where gp_num_groupe='$rowgrparc[0]' and gp_num_parcours='$rowgrparc[1]' and num_cal='$num_cal';");

            // calendrier
            $del=pg_query("delete from calendrier where num_cal='$num_cal';");
            // date
            //on peut supprime toutes les dates < min(datedeb) et >max(datefin)
            //recup de min(datedeb) et max(datefin)
            $resdate=pg_query("select min(datedeb),max(datefin) from calendrier;");
            $rowdate=pg_fetch_row($resdate,0);
            $min=$rowdate[0];
            $max=$rowdate[1];
            //$del=pg_query("delete from dates where num_date<$min;");
            //$del=pg_query("delete from dates where num_date>$max;");
            // gest_cal
            $del=pg_query("delete from gest_cal  where gnum_cal='$num_cal';");
            // gestionnaire
            $del=pg_query("delete from gestionnaire where g_num_cal='$num_cal';");
            // gestionqstn et res_serie
            $del=pg_query("delete from gestionqstn where num_cal='$num_cal';");
            $del=pg_query("delete from res_serie where id_formation='$num_cal';");
            // gestionqst et res_serie_exo
            $del=pg_query("delete from gestionqst where num_cal='$num_cal';");
            $del=pg_query("delete from res_serie_exo where id_formation='$num_cal';");
            // res_liste et res_liste_test
            $del=pg_query("delete from res_liste where id_formation='$num_cal';");
            $del=pg_query("delete from res_liste_test where id_formation='$num_cal';");
            // notation
            $del=pg_query("delete from notation where num_cal='$num_cal';");
            //gestexotlc
            $del=pg_query("delete from gestexotlc where num_cal='$num_cal';");
            // resexouser
            $del=pg_query("delete from resexouser where num_cal='$num_cal';");
            // stockresultqcm et stockresultserie
            $del=pg_query("delete from stockresultqcm where num_cal='$num_cal';");
            $del=pg_query("delete from stockresultserie where num_cal='$num_cal';");
            // comment_presentiel
            $del=pg_query("delete from comment_presentiel where num_cal='$num_cal';");
            // config_ressource
            $del=pg_query("delete from config_ressource where num_cal='$num_cal';");
            // alert
            $del=pg_query("delete from alert where num_cal='$num_cal';");

            // reception des exotlc
            $del=pg_query("delete from reception_exostlc where num_cal='$num_cal';");
            // config grille / utilisateurs
            $del=pg_query("delete from config_grille where num_cal='$num_cal';");

            // session
            $del=pg_query("delete from session where num_cal='$num_cal';");


            //header("location:$pageretour");
}

?>