<?php
/*
	This file is part of Astairs.

    Astairs is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    any later version.

    Astairs is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Astairs.  If not, see <http://www.gnu.org/licenses/>.

	Copyright (C) 2006, 2007, 2008, 2009 AFIDE
    
	Auteurs:

	Said Ladjani <sladjani@yahoo.fr>
	Remi Cocquet <remi.cocquet@gmail.com>

*/
                              
/**
      Crer un nouveau groupe

      Ce script prsente un formulaire et son validateur pour la
      cration d'un nouveau groupe.

      @param integer: gestgp
       @param integer: numero du groupe pere

      @package groupe_commun
*/

$perm->check('ADD,CONF');
//---------------------------------------------------------------------------
//          SOUMISSION FORMULAIRE
//---------------------------------------------------------------------------
if(isset($subgp)){
	if(empty($cregroupe)){
		$err=1;
	}
	else{
		//test sur max et min
		if (testminmax($min, $max, $nbusergp)) {
			$err=0;
			//formatage
			$cregroupe=addslashes($cregroupe);
			if($pere==0)
				$cregroupe=strtoupper($cregroupe);
			else
				$cregroupe=ucwords($cregroupe);
			//$ins=set_groupe( $cregroupe, $pere, $min, $max);
			$ins=set_classe( $cregroupe, $pere, $min, $max);
		}
		else
			$err=3;
	}
	//echo "err=$err<br>";
	if($err==0&&isset($ins)&&$ins!=0){
		header("location:$lien_source?niv=$niv&gestgp=$gestgp&err=$err&num_cregroupe=$ins&reload=1");
		include("$dbpath/pied_page.php");
		exit();
	}
    else{
		if($err!=1&&$err!=3)
			$err=2;
		unset($subgp);
		header("location:$lien_source?action_groupe=$action_groupe&niv=$niv&gestgp=$gestgp&err=$err");
		include("$dbpath/pied_page.php");
		exit();
	}
}


//---------------------------------------------------------------------------
//          				INITIATISATIONS
//---------------------------------------------------------------------------

//on recupere le niveau du pre
if(!empty($gestgp)){
	//$niv=get_niveau_groupe($gestgp);
	$niv=get_classe_niveau($gestgp);
}
else 
	$niv=1;
// debug
//echo "niv=$niv<br>";
//si le pere est le groupe courrant, c'est que l'on cree un sous groupe ($niv+1)
if($pere==$gestgp){
	$niv++;
}

//---------------------------------------------------------------------------
//         						AFFICHAGE
//---------------------------------------------------------------------------

//messages d'erreurs
if(!empty($err)){
    if($err==0)print("<font color=\"#00ff00\">Groupe cr.</font>");
    if($err==1)print("<font color=\"#ff0000\">Veuillez saisir un nom</font>");
    if($err==2)print("<font color=\"#ff0000\">Ce nom existe dj</font>");
    if($err==3)print("<font color=\"#ff0000\">Le nombre de places est incorrect</font>");
}

//formulaire
print("
	<br/>
    <table class=\"tableau_normal\">
        <tr class=\"couleur1\" align=\"center\">
            <td>
                <form name=\"adgp\" methode=\"get\" action=\"$lien_source\">
                <b>$MSG_44 $niv : </b>
            </td>
        </tr>
        <tr class=\"couleur2\" align=\"center\">
            <td>
                <input type=text name=\"cregroupe\" size=\"30\">
            </td>
        </tr>
        <tr class=\"couleur1\" align=\"center\">
            <td>
                <b>$MSG_88 :</b>
            </td>
        </tr>
        <tr class=\"couleur2\" align=\"center\">
            <td>
                <select name=\"min\">
                <option value=\"0\">$MSG_615 $MSG_155
");
for($p=1;$p<21;$p++){
		print("
			<option value=\"$p\">$p</option>
			");
}
print("
</select>
&nbsp;&nbsp;
<select name=\"max\">
<option value=\"0\">$MSG_615 $MSG_156
");
for($p=1;$p<21;$p++){
		print("
			<option value=\"$p\">$p</option>
			");
}
print("
</select>
</td></tr>
<tr class=\"couleur1\" align=\"center\">
    <td>
        <input type=hidden name=\"gestgp\" value=\"$gestgp\">
        <input type=hidden name=\"pere\" value=\"$pere\">
        <input type=hidden name=\"prec\" value=\"$prec\">
        <input type=hidden name=\"action_groupe\" value=\"$action_groupe\">
        <input type=hidden name=\"niv\" value=\"$niv\">
        <input type=hidden name=\"tab\" value=\"$rowtab[0]\">
        <input type=hidden name=\"champnom\" value=\"$champnom\">
        <input type=hidden name=\"champid\" value=\"$champid\">
        <input type=submit name=\"subgp\" value=\"$FORM_6\">
    </td>
    </form>
</tr>
</table><br>             
");


?>
