<?php
/*
	This file is part of Astairs.

    Astairs is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    any later version.

    Astairs is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Astairs.  If not, see <http://www.gnu.org/licenses/>.

	Copyright (C) 2006, 2007, 2008, 2009 AFIDE
    
	Auteurs:

	Said Ladjani <sladjani@yahoo.fr>
	Remi Cocquet <remi.cocquet@gmail.com>

*/

/**
    Fichier de template pour l'interface de gestion des groupes en front office.

    @package groupe
*/
//-----------------------------------------------
//          IDENTIFICATION
//-----------------------------------------------

//inclusions
$dbpath="../..";  //le dbpath sert  maintenir les inclusions  partir du $chemin_bo
include("$dbpath/en_tete.php"); //contient les traitements communs  l'ensemble du FrameWork Astairs
include("../en_tete_back.php"); //contient les traitements communs  l'ensemble du BackOffice Astairs


$perm->check('GEST');


require('includes.php');


// SOUMISSIONS
if($subetape){

	$perm->check('DEL');
		
	// recup des etape pour raz
	$etapes=array();
	$parcours=array();
	while(list($cle,$val)=each($_GET)){
		if(substr($cle,0,5)=='check' && $val>0){
			//echo "val=$val<br>";
			$etapes[]=$val;
			// recup parcours
			$chaine=substr($cle,5);
//			echo "chaine=$chaine<br>";
			$tab=explode("-",$chaine);
			$parcours[]=$tab[1];
		}
			
	}
	if(sizeof($etapes)>0)
//		print_rr($etapes);
//		print_rr($parcours);
		del_etape_resultat_individu($s_numcal,$user,$etapes,$parcours);
		// si serie bloquante  suivre ...
		//del_etape_resultat_tentative_individu($s_numcal,$user,$etapes,$parcours); 
	
	header("location:suivi.php?action_groupe=avancement&user=$user&parcours=$parcours&gestgp=$gestgp&s_numcal=$s_numcal&prec=$prec");
	include("$dbpath/pied_page.php");
	exit();
	
}


//-----------------------------------------------
//              INITIALISATION
//-----------------------------------------------

//recup du groupe en fonction du calendrier
//echo "numcal=$s_numcal<br>";
if (!isset($gestgp)&&!empty($s_numcal)) {
	//$gestgp = get_numero_groupe($s_numcal);
	$resgp= get_formation_classe($s_numcal);
	$rowgp=pg_fetch_row($resgp,0);
	$gestgp=$rowgp[0];
}

//le groupe en cours devient le nouveau groupe
if(!empty($num_cregroupe))
	$gestgp=$num_cregroupe;

if(!empty($gestgp)){
	//$infosgroupe = get_infos_groupe($gestgp);
	$infosgroupe = get_classe($gestgp);
	
	$rowinfosgroupe = pg_fetch_row($infosgroupe);
	$nomgroupe = $rowinfosgroupe[1];
	if(empty($pere)){
		$pere = $rowinfosgroupe[2];
		
	}
}
// debug
//echo "pere=$pere<br>";
//pour le retour
if (!isset($action) || !isset($vue)) {
	$action = "Classe";
	$vue = "Classe";
}

//-----------------------------------------------
//AFFICHAGE ENTETE
//-----------------------------------------------

function entete($groupe, $prec, $nomgroup, $nompage, $titre, $page_precedente, $reload) {

	global $s_numcal;
	global $site_heberge;
	global $s_admin;
	global $chemin_bo;
	global $s_serverback;
	global $serverback;
	global $IP;
	global $MSG_9, $MSG_10, $MSG_11, $MSG_12, $MSG_13, $MSG_14, $ERROR_5 , $WARN_9, $WARN_21;
       global $MSG_1752,$MSG_1753; 
       // variables ncessaires pour faire fonctionner la fonction javascript testMax
       global $nbstaggp, $nbplacemax ;
		
	//pour rafraichir la frame de gauche
	if($reload==1)$fonctionONLOAD="reloadMenu()";
	
	$path = ".";
	$javascriptFILE = "./commun/javascript_groupe.php";
	$styleCSS = "../style/".MY_STYLE."/ressourcesHumaines.css";
	
	include ('../entete.php3');


}

//-----------------------------------------------
//              PARCOURS DES FICHIERS
//-----------------------------------------------
//la page de retour par default
if($prec==1){
	$page_precedente = "suivi.php?gestgp=$gestgp&prec=$prec";
}
else {
	$page_precedente="stop";
	$prec=0;
}

//----------------------------------------
//       TRAITEMENT ACTION 
//----------------------------------------
$lien_source="../classe_suivi/suivi.php";
$lien_action="../classe_suivi";
$lien_retour="<a class=\"retour\" href=\"$lien_source\">".MSG_37."</a>";

switch ($action_groupe) {

	//avancement stagiaire
	case "avancement" :
		$page_precedente = "$lien_source?gestgp=$gestgp&prec=$prec";
		//echo "s_numcal=$s_numcal";
		if (!isset($submit))
			entete($gestgp, $prec, $nomgroupe, MSG_2072, MSG_2718." ".$nomgroupe, $page_precedente, 0);
		//include ("./commun/avance_groupe.php");
		include ("$lien_action/commun/avancement_groupe.php");
		print "<a class=\"retour\" href=\"./$lien_source?gestgp=$gestgp&prec=$prec\">".MSG_37."</a>";
		break;
	// gestion etapes	
	case "etape" :
		 entete($gestgp, $prec, $nomgroupe,  MSG_38,  MSG_2261, $page_precedente, 0);
		include ("$lien_action/commun/gestion_etape.php");
		print "<a class=\"retour\" href=\"./$lien_source?action_groupe=avancement&gestgp=$gestgp&prec=$prec&s_numcal=$s_numcal\">".MSG_37."</a>";
	break;
	// gestion evaluations
	case "evaluation" :
		 entete($gestgp, $prec, $nomgroupe,  MSG_38,  MSG_2262, $page_precedente, 0);
		include ("$lien_action/commun/gestion_evaluation.php");
		print "<a class=\"retour\" href=\"./$lien_source?action_groupe=etape&gestgp=$gestgp&prec=$prec&s_numcal=$s_numcal&user=$user&etape=$etape&parcours=$parcours\">".MSG_37."</a>";
	break;

		//interface gestion du groupe
	case "groupe" :
		entete($gestgp, $prec, $nomgroupe,  MSG_38,  MSG_1747, $page_precedente, 0);
		include ("$lien_action/commun/lstUser.php");
		print("<br><a class=\"retour\" href=\"$lien_source?gestgp=$gestgp&prec=$prec\">".MSG_37."</a>");
       break;

	default :

		//$page_precedente = "../interface_formateur/fenetre_formateur.php?action=$action&vue=$vue";


		entete($gestgp, $prec, $nomgroupe, MENU_10, MSG_70, $page_precedente, $reload);
		include ("$lien_action/lstFormations.php");
        break ;

}
require ('../piedpage.php3');
include("$dbpath/pied_page.php");
?>
