<?php
/*
	This file is part of Astairs.

    Astairs is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    any later version.

    Astairs is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Astairs.  If not, see <http://www.gnu.org/licenses/>.

	Copyright (C) 2006, 2007, 2008, 2009 AFIDE
    
	Auteurs:

	Said Ladjani <sladjani@yahoo.fr>
	Remi Cocquet <remi.cocquet@gmail.com>

*/

/**
 * Cette class affiche e formulaire de configuration du framework
 * 
 * @package configuration_framework
 */
class guiBoConfigureINI extends PageComponent{
	/**
	 * @param string $message Un texte d'erreur ou de validation d'enregistrement.
	 * @param string $block_target Variable du tpl p�re ou sont stock�s les �l�ments pour l'affichage de la boucle.
	 * @param string $organisme Le libelle de l'organisme d'un individu.
	 * @param string $action_individu 
	 * @param string $type Le type de l'individu exemple "f = formateur", "u = utilisateur" ou "i = intervenant".
 	 * @param string $module_root Le chemin du dossier contenant les tpl requis.
 	 * @param string[] $templates Le tableau contenant la variable de destination et le tpl requis pour l'objet
	 */	
	function guiBoConfigureINI($block_target,$module_root=null,$templates=null){
		
		global $chemin_bo,$dbpath,$root;

		// Le fichier
//		$file=$root."/conf/generated/test.ini";
		$file=$root.'/conf/generated/config.ini';
		
		
		if(file_exists($file)){
			//echo "coucou";
			$nom_plateforme=ReadIniValue($file, 'Plateforme', 'nom');	
			
			$place_max=ReadIniValue($file, 'Ressources humaines', 'nbPlacesMax');
			$currentLang=ReadIniValue($file,'Langues', 'langueParDefaut');
				
			$dureeSessionFront=ReadIniValue($file,'Session front office','dureeSessionFront');
			$dureeMaxInactifFront=ReadIniValue($file,'Session front office','dureeMaxInactifFront');
			
			$dureeSessionBack=ReadIniValue($file,'Session back office','dureeSessionBack');
			$dureeMaxInactifBack=ReadIniValue($file,'Session back office','dureeMaxInactifBack');
			
			$currentStyle=ReadIniValue($file,'Affichage', 'styleParDefaut');
			$charset=ReadIniValue($file,'Affichage', 'charset');
			
			$ip_back_office=ReadIniValue($file,'Serveurs', 'serverBack');
			$ip_front_office=ReadIniValue($file,'Serveurs', 'serverFront');
			
			$chemin_root=ReadIniValue($file,'Chemins', 'baseCheminRoot');
			$chemin_back_office=ReadIniValue($file,'Chemins', 'baseCheminBo');
			$chemin_front_office=ReadIniValue($file,'Chemins', 'baseCheminFo');	
					
			$adresse_base=ReadIniValue($file,'Db', 'baseadress');	
			$port_base=ReadIniValue($file,'Db', 'baseport');
			$reference_base=ReadIniValue($file,'Db', 'baseref');
			$nom_base=ReadIniValue($file,'Db', 'basename');
			$user_base=ReadIniValue($file,'Db', 'baseuser');	
			$pass_base=ReadIniValue($file,'Db', 'basepass');	
			
			$phrase_magique=ReadIniValue($file,'Securite', 'magicPassPhrase');
			
		}
		parent::PageComponent($module_root,$templates);
		
		// nom plateforme
		$val['LIBELLE_PLATEFORME']=MSG_1244;
		$val['PATEFORME_INPUT_NAME']="nom_plateforme";
		$val['PATEFORME_INPUT_SIZE']=50;
		$val['PATEFORME_INPUT_VALUE']=$nom_plateforme;
		
		// ressources humaines (nb place max)
		$val['LIBELLE_RESSOURCES_HUMAINES']=MSG_2507;
		$val['RESSOURCES_HUMAINES_INPUT_NAME']="place_max";
		$val['RESSOURCES_HUMAINES_INPUT_SIZE']=2;
		$val['RESSOURCES_HUMAINES_INPUT_VALUE']=$place_max;
		
		// langue
		$val['LIBELLE_LANGUE']=MSG_967;
		$val['LANGUE_SELECT_NAME']="langue";
		$val['LANGUE_DEFAULT_OPTION_VALUE']="selectionnez";
		//$val['']=$MSG_
		//$tab_lang=available_lang();
		$tab_lang=get_langues_installees();
		$nb_langue=sizeof($tab_lang);
		//print_rr($tab_lang);
		
		parent::set_block($block_target,'block_langue','bloc_select_langue');
		for($i=0;$i<$nb_langue;$i++){
			if($currentLang==$tab_lang[$i][0])
				$selected='selected';
			else
				$selected='';
			parent::set_var('LANGUE_VALUE',$tab_lang[$i][0]);	
			parent::set_var('LANGUE_SELECTED',$selected);	
			parent::set_var('LANGUE_LIBELLE',$tab_lang[$i][1]);
			Template::parse('bloc_select_langue','block_langue',true);
		}
		
		//-----------------------------------------
		//		SESSION FRONT
		//-----------------------------------------
		
		// duree session
		$val['LIBELLE_DUREE_SESSION_FO']=MSG_1765."(fo)";
		
		// tableau pour stockage heure/minute/seconde
		$tabhms=array("0","0","0");
		if($dureeSessionFront){
			$tabhms=get_hms($dureeSessionFront);
//			print_rr($tabhms);
		}
		//print_rr($tabhms);
		// heure
		$val['HEURE_DUREE_SESSION_FO_SELECT_NAME']="h_session";
		parent::set_block($block_target,'block_heure_duree_session_fo','bloc_heure_duree_session_fo');
		
		for($i=0;$i<20;$i++){
			if($i==$tabhms['heure'])
				$selected='selected';
			else
				$selected='';
			
			parent::set_var('HEURE_DUREE_SESSION_FO_VALUE',$i);	
			parent::set_var('HEURE_DUREE_SESSION_FO_SELECTED',$selected);	
			parent::set_var('HEURE_DUREE_SESSION_FO_LIBELLE',$i);
			Template::parse('bloc_heure_duree_session_fo','block_heure_duree_session_fo',true);
		}
		// minute
		$val['MINUTE_DUREE_SESSION_FO_SELECT_NAME']="m_session";
		parent::set_block($block_target,'block_minute_duree_session_fo','bloc_minute_duree_session_fo');
		for($i=0;$i<60;$i++){
			if($i==$tabhms['minute'])
				$selected='selected';
			else
				$selected='';	
			parent::set_var('MINUTE_DUREE_SESSION_FO_VALUE',$i);	
			parent::set_var('MINUTE_DUREE_SESSION_FO_SELECTED',$selected);	
			parent::set_var('MINUTE_DUREE_SESSION_FO_LIBELLE',$i);
			Template::parse('bloc_minute_duree_session_fo','block_minute_duree_session_fo',true);
		}
		// seconde
		$val['SECONDE_DUREE_SESSION_FO_SELECT_NAME']="s_session";
		parent::set_block($block_target,'block_seconde_duree_session_fo','bloc_seconde_duree_session_fo');
		for($i=0;$i<60;$i++){
			if($i==$tabhms['seconde'])
				$selected='selected';
			else
				$selected='';
			parent::set_var('SECONDE_DUREE_SESSION_FO_VALUE',$i);	
			parent::set_var('SECONDE_DUREE_SESSION_FO_SELECTED',$selected);	
			parent::set_var('SECONDE_DUREE_SESSION_FO_LIBELLE',$i);
			Template::parse('bloc_seconde_duree_session_fo','block_seconde_duree_session_fo',true);
		}
		
		
		// duree d'inactivite
		$val['LIBELLE_DUREE_MAX_INACTIF_SESSION_FO']=MSG_1766."(fo)";
		// tableau pour stockage heure/minute/seconde
		$tabhms=array("0","0","0");
		if($dureeMaxInactifFront){
			$tabhms=get_hms($dureeMaxInactifFront);
//			print_rr($tabhms);
		}
		// heure
		$val['HEURE_DUREE_MAX_INACTIF_SESSION_FO_SELECT_NAME']="h_inactif";
		parent::set_block($block_target,'block_heure_duree_max_inactif_session_fo','bloc_heure_duree_max_inactif_session_fo');
		for($i=0;$i<20;$i++){
			if($i==$tabhms['heure'])
				$selected='selected';
			else
				$selected='';
			parent::set_var('HEURE_DUREE_MAX_INACTIF_SESSION_FO_VALUE',$i);	
			parent::set_var('HEURE_DUREE_MAX_INACTIF_SESSION_FO_SELECTED',$selected);	
			parent::set_var('HEURE_DUREE_MAX_INACTIF_SESSION_FO_LIBELLE',$i);
			Template::parse('bloc_heure_duree_max_inactif_session_fo','block_heure_duree_max_inactif_session_fo',true);
		}
		// minute
		$val['MINUTE_DUREE_MAX_INACTIF_SESSION_FO_SELECT_NAME']="m_inactif";
		parent::set_block($block_target,'block_minute_duree_max_inactif_session_fo','bloc_minute_duree_max_inactif_session_fo');
		for($i=0;$i<60;$i++){
			if($i==$tabhms['minute'])
				$selected='selected';
			else
				$selected='';
			parent::set_var('MINUTE_DUREE_MAX_INACTIF_SESSION_FO_VALUE',$i);	
			parent::set_var('MINUTE_DUREE_MAX_INACTIF_SESSION_FO_SELECTED',$selected);	
			parent::set_var('MINUTE_DUREE_MAX_INACTIF_SESSION_FO_LIBELLE',$i);
			Template::parse('bloc_minute_duree_max_inactif_session_fo','block_minute_duree_max_inactif_session_fo',true);
		}
		// seconde
		$val['SECONDE_DUREE_MAX_INACTIF_SESSION_FO_SELECT_NAME']="s_inactif";
		parent::set_block($block_target,'block_seconde_duree_max_inactif_session_fo','bloc_seconde_duree_max_inactif_session_fo');
		for($i=0;$i<60;$i++){
			if($i==$tabhms['seconde'])
				$selected='selected';
			else
				$selected='';
			parent::set_var('SECONDE_DUREE_MAX_INACTIF_SESSION_FO_VALUE',$i);	
			parent::set_var('SECONDE_DUREE_MAX_INACTIF_SESSION_FO_SELECTED',$selected);	
			parent::set_var('SECONDE_DUREE_MAX_INACTIF_SESSION_FO_LIBELLE',$i);
			Template::parse('bloc_seconde_duree_max_inactif_session_fo','block_seconde_duree_max_inactif_session_fo',true);
		}
		
		//-----------------------------------------
		//		SESSION BACK
		//-----------------------------------------
		
		// duree session
		$val['LIBELLE_DUREE_SESSION_BO']=MSG_1765."(bo)";
		
		// tableau pour stockage heure/minute/seconde
		$tabhms=array("0","0","0");
		if($dureeSessionBack){
			$tabhms=get_hms($dureeSessionBack);
//			print_rr($tabhms);
		}
		//print_rr($tabhms);
		// heure
		$val['HEURE_DUREE_SESSION_BO_SELECT_NAME']="bh_session";
		parent::set_block($block_target,'block_heure_duree_session_bo','bloc_heure_duree_session_bo');
		
		for($i=0;$i<20;$i++){
			if($i==$tabhms['heure'])
				$selected='selected';
			else
				$selected='';
			
			parent::set_var('HEURE_DUREE_SESSION_BO_VALUE',$i);	
			parent::set_var('HEURE_DUREE_SESSION_BO_SELECTED',$selected);	
			parent::set_var('HEURE_DUREE_SESSION_BO_LIBELLE',$i);
			Template::parse('bloc_heure_duree_session_bo','block_heure_duree_session_bo',true);
		}
		// minute
		$val['MINUTE_DUREE_SESSION_BO_SELECT_NAME']="bm_session";
		parent::set_block($block_target,'block_minute_duree_session_bo','bloc_minute_duree_session_bo');
		for($i=0;$i<60;$i++){
			if($i==$tabhms['minute'])
				$selected='selected';
			else
				$selected='';	
			parent::set_var('MINUTE_DUREE_SESSION_BO_VALUE',$i);	
			parent::set_var('MINUTE_DUREE_SESSION_BO_SELECTED',$selected);	
			parent::set_var('MINUTE_DUREE_SESSION_BO_LIBELLE',$i);
			Template::parse('bloc_minute_duree_session_bo','block_minute_duree_session_bo',true);
		}
		// seconde
		$val['SECONDE_DUREE_SESSION_BO_SELECT_NAME']="bs_session";
		parent::set_block($block_target,'block_seconde_duree_session_bo','bloc_seconde_duree_session_bo');
		for($i=0;$i<60;$i++){
			if($i==$tabhms['seconde'])
				$selected='selected';
			else
				$selected='';
			parent::set_var('SECONDE_DUREE_SESSION_BO_VALUE',$i);	
			parent::set_var('SECONDE_DUREE_SESSION_BO_SELECTED',$selected);	
			parent::set_var('SECONDE_DUREE_SESSION_BO_LIBELLE',$i);
			Template::parse('bloc_seconde_duree_session_bo','block_seconde_duree_session_bo',true);
		}
		
		
		// duree d'inactivite
		$val['LIBELLE_DUREE_MAX_INACTIF_SESSION_BO']=MSG_1766."(bo)";
		// tableau pour stockage heure/minute/seconde
		$tabhms=array("0","0","0");
		if($dureeMaxInactifBack){
			$tabhms=get_hms($dureeMaxInactifBack);
//			print_rr($tabhms);
		}
		// heure
		$val['HEURE_DUREE_MAX_INACTIF_SESSION_BO_SELECT_NAME']="bh_inactif";
		parent::set_block($block_target,'block_heure_duree_max_inactif_session_bo','bloc_heure_duree_max_inactif_session_bo');
		for($i=0;$i<20;$i++){
			if($i==$tabhms['heure'])
				$selected='selected';
			else
				$selected='';
			parent::set_var('HEURE_DUREE_MAX_INACTIF_SESSION_BO_VALUE',$i);	
			parent::set_var('HEURE_DUREE_MAX_INACTIF_SESSION_BO_SELECTED',$selected);	
			parent::set_var('HEURE_DUREE_MAX_INACTIF_SESSION_BO_LIBELLE',$i);
			Template::parse('bloc_heure_duree_max_inactif_session_bo','block_heure_duree_max_inactif_session_bo',true);
		}
		// minute
		$val['MINUTE_DUREE_MAX_INACTIF_SESSION_BO_SELECT_NAME']="bm_inactif";
		parent::set_block($block_target,'block_minute_duree_max_inactif_session_bo','bloc_minute_duree_max_inactif_session_bo');
		for($i=0;$i<60;$i++){
			if($i==$tabhms['minute'])
				$selected='selected';
			else
				$selected='';
			parent::set_var('MINUTE_DUREE_MAX_INACTIF_SESSION_BO_VALUE',$i);	
			parent::set_var('MINUTE_DUREE_MAX_INACTIF_SESSION_BO_SELECTED',$selected);	
			parent::set_var('MINUTE_DUREE_MAX_INACTIF_SESSION_BO_LIBELLE',$i);
			Template::parse('bloc_minute_duree_max_inactif_session_bo','block_minute_duree_max_inactif_session_bo',true);
		}
		// seconde
		$val['SECONDE_DUREE_MAX_INACTIF_SESSION_BO_SELECT_NAME']="bs_inactif";
		parent::set_block($block_target,'block_seconde_duree_max_inactif_session_bo','bloc_seconde_duree_max_inactif_session_bo');
		for($i=0;$i<60;$i++){
			if($i==$tabhms['seconde'])
				$selected='selected';
			else
				$selected='';
			parent::set_var('SECONDE_DUREE_MAX_INACTIF_SESSION_BO_VALUE',$i);	
			parent::set_var('SECONDE_DUREE_MAX_INACTIF_SESSION_BO_SELECTED',$selected);	
			parent::set_var('SECONDE_DUREE_MAX_INACTIF_SESSION_BO_LIBELLE',$i);
			Template::parse('bloc_seconde_duree_max_inactif_session_bo','block_seconde_duree_max_inactif_session_bo',true);
		}
		
		
		
		// style
		$val['LIBELLE_STYLE']=MSG_2508;
		$val['STYLE_SELECT_NAME']="style";
		$val['STYLE_DEFAULT_OPTION_VALUE']="selectionnez";
		$tab_style=available_style();
		$nb_style=sizeof($tab_style);
		parent::set_block($block_target,'block_style','bloc_select_style');
		for($i=0;$i<$nb_style;$i++){
			if($tab_style[$i]==$currentStyle)
				$selected='selected';
			else
				$selected='';
			parent::set_var('STYLE_VALUE',$tab_style[$i]);	
			parent::set_var('STYLE_SELECTED',$selected);	
			parent::set_var('STYLE_LIBELLE',$tab_style[$i]);
			Template::parse('bloc_select_style','block_style',true);	
		}
		
		// charset
		$val['LIBELLE_CHARSET']=MSG_2509;
		$val['CHARSET_INPUT_NAME']="charset";
		$val['CHARSET_INPUT_SIZE']=40;
		$val['CHARSET_INPUT_VALUE']=$charset;
		
		
		// IP
		$val['LIBELLE_IP_BO']="IP ".MSG_2510;
		$val['IP_BO_INPUT_NAME']="ip_back_office";
		$val['IP_BO_INPUT_SIZE']=20;
		$val['IP_BO_INPUT_VALUE']=$ip_back_office;
		
		$val['LIBELLE_IP_FO']="IP ".MSG_2511;
		$val['IP_FO_INPUT_NAME']="ip_front_office";
		$val['IP_FO_INPUT_SIZE']=20;
		$val['IP_FO_INPUT_VALUE']=$ip_front_office;
		

		// chemin
		$val['LIBELLE_CHEMIN_BO']=MSG_2510;
		$val['CHEMIN_BO_INPUT_NAME']="chemin_back_office";
		$val['CHEMIN_BO_INPUT_VALUE']=$chemin_back_office;
		$val['CHEMIN_BO_INPUT_SIZE']=30;
		
		$val['LIBELLE_CHEMIN_FO']=MSG_2511;
		$val['CHEMIN_FO_INPUT_NAME']="chemin_front_office";
		$val['CHEMIN_FO_INPUT_VALUE']=$chemin_front_office;
		$val['CHEMIN_FO_INPUT_SIZE']=30;

		$val['LIBELLE_CHEMIN_ROOT']='root';
		$val['CHEMIN_ROOT_INPUT_NAME']="chemin_root";
		$val['CHEMIN_ROOT_INPUT_VALUE']=$chemin_root;
		$val['CHEMIN_ROOT_INPUT_SIZE']=30;
		
				
		// bdd
		$val['LIBELLE_BASE']=MSG_2512;
		// adresse base
		$val['LIBELLE_ADRESSE_BASE']=MSG_9;
		$val['ADRESSE_BASE_INPUT_NAME']="adresse_base";
		$val['ADRESSE_BASE_INPUT_SIZE']=20;
		$val['ADRESSE_BASE_INPUT_VALUE']=$adresse_base;
		// port
		$val['LIBELLE_PORT_BASE']=MSG_2513;
		$val['PORT_BASE_INPUT_NAME']="port_base";
		$val['PORT_BASE_INPUT_SIZE']=20;
		$val['PORT_BASE_INPUT_VALUE']=$port_base;
		// reference
		$val['LIBELLE_REFERENCE_BASE']=MSG_2514;
		$val['REFERENCE_BASE_INPUT_NAME']="reference_base";
		$val['REFERENCE_BASE_INPUT_SIZE']=20;
		$val['REFERENCE_BASE_INPUT_VALUE']=$reference_base;
		// nom base
		$val['LIBELLE_NAME_BASE']=MSG_7;
		$val['NAME_BASE_INPUT_NAME']="nom_base";
		$val['NAME_BASE_INPUT_SIZE']=20;
		$val['NAME_BASE_INPUT_VALUE']=$nom_base;
		// utilisateur
		$val['LIBELLE_USER_BASE']=MSG_18;
		$val['USER_BASE_INPUT_NAME']="user_base";
		$val['USER_BASE_INPUT_SIZE']=20;
		$val['USER_BASE_INPUT_VALUE']=$user_base;
		// mot de passe
		$val['LIBELLE_PASS_BASE']=MSG_6;
		$val['PASS_BASE_INPUT_NAME']="pass_base";
		$val['PASS_BASE_INPUT_SIZE']=20;
		$val['PASS_BASE_INPUT_VALUE']=$pass_base;
		// phrase magique
		$val['LIBELLE_PHRASE_MAGIQUE']=MSG_955;
		$val['PHRASE_MAGIQUE_INPUT_NAME']="phrase_magique";
		$val['PHRASE_MAGIQUE_INPUT_SIZE']=50; 
		$val['PHRASE_MAGIQUE_INPUT_VALUE']=$phrase_magique; 
		
		// submit
		$val['SUBMIT_NAME']="submit_config";
		$val['SUBMIT_VALUE']=FORM_6;
		
		
		parent::set_var($val);
	}
}
?>