<?php
/*
	This file is part of Astairs.

    Astairs is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    any later version.

    Astairs is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Astairs.  If not, see <http://www.gnu.org/licenses/>.

	Copyright (C) 2006, 2007, 2008, 2009 AFIDE
    
	Auteurs:

	Said Ladjani <sladjani@yahoo.fr>
	Remi Cocquet <remi.cocquet@gmail.com>

*/

/**
 * Classe de gestion de l'authentification.
 * $lifetime Temps maximum autorisé avant que l'authentification expire désactivé (0)
 * $nobody Autorise l'existancez de l'utilisateur nobody
 * Classe de gestion de base de données : DbPgsqlAstairs
 * Table de base de donnée: contraintes.fw_individu
 */
class AstairsAuth extends Auth {
  var $classname      = "AstairsAuth";
  var $lifetime = 15;             ## Max allowed idle time before
                                  ## reauthentication is necessary.
                                  ## If set to 0, auth never expires.
  
  var $refresh = 0;               ## Refresh interval in minutes. 
                                  ## When expires auth data is refreshed
                                  ## from db using auth_refreshlogin()
                                  ## method. Set to 0 to disable refresh

  var $nobody = false;
  var $database_class = "DbPgsqlAstairs";
  var $database_table = "contraintes.fw_individu I, contraintes.fw_individu_types IT,contraintes.fw_individu_type T";
  
  function AstairsAuth(){
  	global 	$langue_par_defaut,$s_langue,$sess,$root;
  
//  	//Comme c'est le seul moyen de choisir une langue, on prend la langue par defaut de la plate_forme
//	$s_langue=pg_fetch_result(get_langue($langue_par_defaut),0,0);
//	if(empty($s_langue))die("Erreur, la langue par d�faut est introuvable dans la base de donn�es.");
//	$sess->register("s_langue");
//
//	//chargement fichier de langue associé
//	include("$root/langues/$s_langue/lang.php");
//	echo "$root/langues/$s_langue/lang.php";
  
  }
  
  function auth_loginform($message_erreur="") {
    global $sess;
    global $_PHPLIB;
    global $chemin_bo,$root;
    global $chemin_fo,$nom_site_front,$dbpath,$langue_par_defaut,$style_par_defaut;

//	//Comme c'est le seul moyen de choisir une langue, on prend la langue par defaut de la plate_forme
//	$s_langue=pg_fetch_result(get_langue($langue_par_defaut),0,0);
//	if(empty($s_langue))die("Erreur, la langue par d�faut est introuvable dans la base de donn�es.");
//	$sess->register("s_langue");
//
//	//chargement fichier de langue associé
	require_once("$root/langues/$langue_par_defaut/lang.php");
//	echo "$root/langues/$langue_par_defaut/lang.php";
	
    //Définition des variables
	$page_lang = "fr";
	$page_encoding = CHARSET;
	$page_style_path = "$dbpath/fo/styles/".$style_par_defaut;
	$page_javascript_path = "$dbpath/javascript";
	$page_resolution = 'res_800x600';

	//les templates de base
	$base_templates = array(
		'structure' => 'structure_xhtml11.tpl',
		'meta' => 'meta.tpl',
		'style' => 'style.tpl',
		'javascript' => 'javascript.tpl',
		'internal_javascript' => 'internal_javascript.tpl',
		'content' => 'content.tpl');
	
	//le constructeur de page g�n�rique
	$page_builder=new PageBuilder(
							$root."lib/framework/templates/tpl",
							$base_templates,
							$page_lang,
							$page_encoding,
							$page_style_path,
							$page_javascript_path,
							$page_resolution,
							"$chemin_bo/connexion/templates/tpl");
							
	//les styles
	$style_files=array();
	$style_files[$dbpath.'/fo/styles/'.$style_par_defaut][]='style_globale.css';
	$style_files[$dbpath.'/fo/styles/'.$style_par_defaut][]='login.css';		
	messageDebugR("Fichier CSS charg�s:",$style_files);	
		
	//les fichiers javascripts
	$javascript_files=array();
	$javascript_files["$dbpath/lib_graphique/javascript/"][]="global.js";
	messageDebugR("Fichier javascript charg�s:",$javascript_files);	
	
	//le javascript interne
	$javascript_internal_code="";
	messageDebug("Code javascript charg�:<br>$javascript_internal_code");	
	
	//les �l�ments pour la page
	$page_debut=new ConnexionPageDebut($page_builder->getModuleRoot(),array('debut' => 'debut_connexion.tpl'));
	$page_contenu=new ConnexionPageContenu($page_builder->getModuleRoot(),array('contenu' => 'contenu_connexion.tpl'));
	$page_fin=new ConnexionPageFin($page_builder->getModuleRoot(),array('fin' => 'fin_connexion.tpl'));
	
	//la page sp�cifique
	$page=new ConnexionPage($page_builder, array('page_dev' => 'connexion.tpl'),$style_files,$javascript_files,$javascript_internal_code);
	
	//affectation des �l�ments
	$page->setComponent('DEBUT', $page_debut);
	$page->setComponent('CONTENU', $page_contenu);
	$page->setComponent('FIN',$page_fin);
	
	//on parse
	$page->parse();

	//on affiche
	$page->p();
  }
  
  /**
   * Traitement de validation de l'authentification.
   * V�rifie que le login et le mot de passe correspondent � 
   * un utilisateur valide dans la table $database_table, et retourne son uid.
   * En cas d'echec, car l'utilisateur n'existe pas, retourne null et affecte � la variable de session MSG_ERROR
   * un message d'erreur adapt�.
   * 
   * @return string $uid L'UID de l'utilisateur authentifi�.
   */
  function auth_validatelogin() {
    global $HTTP_POST_VARS;
 	global $sess, $root,$user_id,$langue_par_defaut,$s_langue;

    $uid = false;
    require_once("$root/langues/$langue_par_defaut/lang.php");
    
//    chargement fichier de langue
//    if(!$s_langue)$lang=$langue_par_defaut;
//    else $lang=$s_langue;
//	include("$root/langues/$lang/lang.php");
	
	
    //This provides access for "loginform.ihtml"
    if(isset($HTTP_POST_VARS["user"])) {
      $this->auth["uname"] = $HTTP_POST_VARS["user"];
    }
    
   //recupération des informations d'authentification correspondant aux user et mdp passés en $_GET
   if((isset($HTTP_POST_VARS["user"]))&&(isset($HTTP_POST_VARS["mdp"]))){
    	$this->db->query(sprintf("select I.id, identifiant_md5 , T.code ".
                             "        from %s ".
                             "       where login = '%s' ".
                             "         and password = '%s'" .
                             "			and I.id=IT.individu" .
                             "			and IT.type=T.id",
                          $this->database_table,
                          addslashes($HTTP_POST_VARS["user"]),
                          addslashes($HTTP_POST_VARS["mdp"])));
        //affectations des valeurs
	    while($this->db->next_record()) {
			$user_id=$this->db->f("id");
			$tmp_types_individus[]=$this->db->f("code");
//			$this->auth["perm"][]=$this->db->f("code");
			$db_uid = $this->db->f("identifiant_md5");
	    }
	    //si pas informations d'authentification, les mdp et user ne forment pas un compte valide
	    if($this->db->num_rows()==0){
	    	AstairsTemplate::setPageMessage(FW_3,MSG_ERROR);
		}
		else{
			$this->auth["perm"] = implode(',',$tmp_types_individus);
			$this->auth["user_id"]=$user_id;
			$uid=$db_uid;
			//###ici, on est alors connecté a condition de bien retourner l'uid
			if($user_id!='nobody'){
				
				//creation d'un conteneur pour le stockage de session
				$t=new AstairsCtSql(); 
				$t->ac_start();
				//avec lequel on supprime les éventuelles autres sessions de l'utilisateur
				if($t->ac_unregister_user($this->auth["user_id"])){
					AstairsTemplate::setPageMessage(FW_4,MSG_WARNING);
				}else{
					AstairsTemplate::setPageMessage(FW_1,MSG_CONFIRM);
				}
			}else{
				die("nobody!"); //le cas du nobody reste  traiter
				AstairsTemplate::setPageMessage(null);    	
			}
	    }
    }else{
    	AstairsTemplate::setPageMessage(FW_5,MSG_WARNING);
    }
    return $uid;
  }
  
  	function url() {

		$tmp_url=parent::url();
		$pseparateur=strpos($tmp_url,'?');
		$url_ss_query=substr($tmp_url,0,$pseparateur);
		$query=substr($tmp_url,$pseparateur,strlen($tmp_url));
		if(strpos($query,'uid=')){
			return $url_ss_query;
		}
		return $tmp_url;
	}
	/**
	 * Méthode de pré authentification.
	 * Cette méthode est appelée juste avant auth_loginform().
	 * Si le $_GET contient un uid valide, l'utilisateur correspondant est authentifié, comme s'il l'avait fait avec auth_loginform().
	 * Cette méthode est appelée lorsqu'un utilisateur passe d'un gestionnaire de session à l'autre (AstairsBackSession,AstairsFrontSession,AstairsPageSession)
	 */
	function auth_preauth() { 
   		global $sess,$_GET,$_POST,$root,$s_langue,$langue_par_defaut;

//   	 	//chargement fichier de langue
//	    if(!$s_langue)$lang=$langue_par_defaut;
//	    else $lang=$s_langue;
//		include("$root/langues/$lang/lang.php");
	
   		//si on n'a pas d'uid, la pré authentification est impossible
   		if(empty($_GET['uid'])){
   			if(empty($_POST['uid'])){
   				return false;
   			}else{
   				$get_uid=$_POST['uid'];
   			}
   		}else{
   			$get_uid=$_GET['uid'];
   		}
		$uid=false;
		//recupération des informations d'authentification correspondant à l'uid passé en parametre
	 	$this->db->query(sprintf("select  I.id, login,identifiant_md5 , T.code ".
                     "        from %s ".
                     "       where identifiant_md5 = '%s'" .
                     "			and I.id=IT.individu" .
                     "			and IT.type=T.id" ,
                  $this->database_table,
                 	$get_uid));
        
	    while($this->db->next_record()) {
			$user_id=$this->db->f("id");
			$tmp_types_individus[]=$this->db->f("code");
			$db_uid = $this->db->f("identifiant_md5");
			$login=$this->db->f("login");
	    }
			    
	    //si l'uid ne correspond pas à un compte valide, erreur
	    if($this->db->num_rows()==0){
	    	AstairsTemplate::setPageMessage(FW_6,MSG_ERROR);
	    	return false;
		}else{
					
			//creation d'un conteneur pour le stockage de session
			$t=new AstairsCtSql(); 
			$t->ac_start();
			//avec lequel on supprime la session ayant permis la connexion par préauthentification
			$sess_page_deleted=$t->ac_unregister_user_session($user_id,'AstairsPageSession');
					
			//si une session a bien été supprimée, tout est ok
			$this->auth["user_id"]=$user_id;
			$this->auth["uname"]=$login;
			$this->auth["perm"] = implode(',',$tmp_types_individus);

			//###ici, on est alors connecté a condition de bien retourner l'uid
			$uid=$db_uid;						
						
			//on supprime les eventuelles autres session 	
			if($t->ac_unregister_user($this->auth["user_id"])){
				AstairsTemplate::setPageMessage(FW_4,MSG_WARNING);
			}
			else{
				AstairsTemplate::setPageMessage(FW_2,MSG_CONFIRM);
			}
		}
		return $uid;
   }
   
   	function is_root() {
	    $exploded_perms=explode(',',$this->auth["perm"]);
	    if ($this->auth["uname"]=='root'||in_array('root',$exploded_perms)) {
			return true;
	    }
		return false;
	}
   
  /**
   * Obtenir l'identifiant de l'utilisateur connect�
   */
  function getUserId(){
  	return $this->auth["user_id"];
  }
  
   /**
   * Obtenir le nom de  l'utilisateur connect�
   */
  function getUname(){
  	return $this->auth["uname"];
  }
   /**
   * Obtenir les permissions de l'utilisateur connect�
   */
  function getPerm(){
  	return $this->auth["perm"];
  }
  
  function getUid(){
  	return  $this->auth["uid"] ;
  }

   /**
   * Obtenir temps que ??? l'utilisateur connect�
   * time() + (60 * $this->lifetime)
   */
  function getExp(){
  	return $this->auth["exp"];
  }
   /**
    * Temps maximal avant que les informations de l'authentification soient relues dans la base de données.
    * Pour la relecture, on utilise  auth_refreshlogin().
    * 0 indique que lecture des informations ne se fait qu'a la connexion. 
    * time() + (60 * $this->refresh)
    * @return integer Le temps en minutes
   */
  function getRefresh(){
  	return $this->auth["refresh"];
  }
}
?>