<?php
/*
	This file is part of Astairs.

    Astairs is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    any later version.

    Astairs is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Astairs.  If not, see <http://www.gnu.org/licenses/>.

	Copyright (C) 2006, 2007, 2008, 2009 AFIDE
    
	Auteurs:

	Said Ladjani <sladjani@yahoo.fr>
	Remi Cocquet <remi.cocquet@gmail.com>

*/

/**
 * Classe de gestion de l'authentification.
 * $lifetime Temps maximum autorisé avant que l'authentification expire désactivé (0)
 * $nobody Autorise l'existancez de l'utilisateur nobody
 * Classe de gestion de base de données : DbPgsqlAstairs
 * Table de base de donnée: contraintes.fw_individu
 */
class AstairsFrontAuth extends AstairsAuth {
  var $classname      = "AstairsFrontAuth";
  var $database_table = "contraintes.fw_individu I,contraintes.individu_droits ID, contraintes.droit D,contraintes.formation_participants FP";
  
  function AstairsFrontAuth(){
  	return parent::AstairsAuth();
  }
  
  /**
   * Traitement de validation de l'authentification.
   * V�rifie que le login et le mot de passe correspondent � 
   * un utilisateur valide dans la table $database_table, et retourne son uid.
   * En cas d'echec, car l'utilisateur n'existe pas, retourne null et affecte � la variable de session MSG_ERROR
   * un message d'erreur adapt�.
   * Cette méthode est appelée après soumission du formulaire d'authentification et après l'appel à la méthode auth_reauth() de la classe mère.
   * 
   * @return string $uid L'UID de l'utilisateur authentifi�.
   */
  function auth_validatelogin() {
    global $HTTP_POST_VARS,$auth,$root;
 	global $sess, $user_id, $obj_DoFormation, $s_langue,$langue_par_defaut;
    
//    //chargement fichier de langue
//    if(!$s_langue)$lang=$langue_par_defaut;
//    else $lang=$s_langue;
	require_once("$root/langues/$langue_par_defaut/lang.php");
		
    $uid = false;
    if(!is_object($obj_DoFormation)){
    	$this->database_table  = "contraintes.fw_individu I, contraintes.fw_individu_types IT,contraintes.fw_individu_type T";
//    	die('auth_validatelogin');
    	return parent::auth_validatelogin();
    }
       
    //This provides access for "loginform.ihtml"
    if(isset($HTTP_POST_VARS["user"])) {
      $this->auth["uname"] = $HTTP_POST_VARS["user"];
    }
    
   //recupération des informations d'authentification correspondant aux user et mdp passés en $_GET
   if((isset($HTTP_POST_VARS["user"]))&&(isset($HTTP_POST_VARS["mdp"]))){
    	$this->db->query(sprintf("select I.id, identifiant_md5 , D.code ".
                             "        from %s ".
                             "       where  FP.formation = %s " .
                             "       	and login = '%s' ".
                             "         	and password = '%s'" .
                             "         	and ID.individu = I.id" .
                             "			and FP.classe=ID.classe" .
                             "			and ID.droit=D.id",
                          $this->database_table,
                          $obj_DoFormation->getFormation(),
                          addslashes($HTTP_POST_VARS["user"]),
                          addslashes($HTTP_POST_VARS["mdp"])));
                          
        //affectations des valeurs
	    while($this->db->next_record()) {
			$user_id=$this->db->f("id");
			$tmp_droits[]=$this->db->f("code");
			$db_uid = $this->db->f("identifiant_md5");
	    }
	    //si pas informations d'authentification, les mdp et user ne forment pas un compte valide
	    if($this->db->num_rows()==0){
	    	AstairsTemplate::setPageMessage(FW_7,MSG_ERROR);
		}
		else{
			$this->auth["perm"] = implode(',',$tmp_droits);
			$this->auth["user_id"]=$user_id;
			$uid=$db_uid;
			//on passe ici quand on se reconnecte apres expiration de la duree d'inactivit�'.
			
			//###ici, on est alors connecté a condition de bien retourner l'uid
			if($this->auth["user_id"]!='nobody'){
				
				//creation d'un conteneur pour le stockage de session 
				$t=new AstairsCtSql(); 
				$t->ac_start();
				//avec lequel on supprime les éventuelles autres sessions de l'utilisateur
				if($t->ac_unregister_user($this->auth["user_id"])){
					AstairsTemplate::setPageMessage(FW_4,MSG_WARNING);
				}
				else{
					AstairsTemplate::setPageMessage(FW_8,MSG_CONFIRM);
				}
			}else{
				die("nobody!");
				AstairsTemplate::setPageMessage(null);    	
			}
	    }
    }else{
    	AstairsTemplate::setPageMessage(FW_5,MSG_WARNING);
    }
    //duree d'inactivit propre  la formation
    $res=get_formation_session($obj_DoFormation->getFormation());
	$duree=pg_fetch_result($res,0,1);
	//die($duree);
	if(!empty($duree)){
	    $sess->setDureeInactifMax(((int)sql_interval_to_secondes($duree)/60));
	}
    return $uid;
  }
  
	/**
	 * Méthode de pré authentification.
	 * Cette méthode est appelée juste avant auth_loginform().
	 * Si le $_GET contient un uid valide, l'utilisateur correspondant est authentifié, comme s'il l'avait fait avec auth_loginform().
	 * Cette méthode est appelée lorsqu'un utilisateur passe d'un gestionnaire de session à l'autre (AstairsBackSession,AstairsFrontSession,AstairsPageSession)
	 */
	function auth_preauth() { 
   		global $sess,$_GET,$_POST,$obj_DoFormation,$s_langue,$langue_par_defaut;
   		
   		//chargement fichier de langue
//	    if(!$s_langue)$lang=$langue_par_defaut;
//	    else $lang=$s_langue;
//		require_once("$root/langues/$lang/lang.php");
//		
   		if(!is_object($obj_DoFormation)){
   			
//	 	    	$this->db->query(sprintf("select distinct I.id, I.login ,identifiant_md5 , D.code ".
//                     "        from %s ".
//                     "       where  " .
//                     "       	identifiant_md5 = '%s' ".
//                     "         	and ID.individu = I.id" .
//                     "			and ID.droit=D.id and D.defaut IS TRUE",
//                  $this->database_table,
//                  $get_uid));
//			    while($this->db->next_record()) {
//					$user_id=$this->db->f("id");
//					$tmp_doits[]=$this->db->f("code");
//					$db_uid = $this->db->f("identifiant_md5");
//					$login=$this->db->f("login");
//			    }
//			    //si l'uid ne correspond pas à un compte valide, erreur
//			    if($this->db->num_rows()==0){
////			    	echo $this->db->num_rows();
//			    	AstairsTemplate::setPageMessage('Accs apprenant non autoris',MSG_ERROR);
//			    	return false;
//				}else{
////					echo "toto";
//					//creation d'un conteneur pour le stockage de session
//					$t=new AstairsCtSql(); ,$s_langue,$langue_par_defaut;
   		
//   		//chargement fichier de langue
//	    if(!$s_langue)$lang=$langue_par_defaut;
//	    else $lang=$s_langue;
//		require_once("$root/langues/$lang/lang.php");
//					$t->ac_start();
//					//avec lequel on supprime la session ayant permis la connexion par préauthentification
//					$sess_page_deleted=$t->ac_unregister_user_session($user_id,'AstairsPageSession');
//					
////					si une session a bien été supprimée, tout est ok
//					if($sess_page_deleted){
//						$this->auth["user_id"]=$user_id;
//						$this->auth["uname"]=$login;
//						$this->auth["perm"] = implode(',',$tmp_doits);
//						$uid=$db_uid;
//						
//						//###ici, on est alors connecté a condition de bien retourner l'uid
//						//on supprime les eventuelles autres session 	
//						if($t->ac_unregister_user($this->auth["user_id"])){
//							//AstairsTemplate::setPageMessage('FoVous avez été déconnecté d\'une session précédente.',MSG_WARNING);
//						}
////						
//					}else{
//						//??
//						AstairsTemplate::setPageMessage('Erreur connexion Front-Office: perte de la session de connexion',MSG_ERROR);
//						return false;
//					}
//				}
//			AstairsTemplate::setPageMessage('aaa',MSG_ERROR);
//			return $uid;



    }else{
		//si on a une session de backoffice ou de front office
//		if($sess->name=='AstairsBackSession'||$sess->name=='AstairsFrontSession'){

			 	    	$this->db->query(sprintf("select I.id, I.login ,identifiant_md5 , D.code ".
                             "        from %s ".
                             "       where  FP.formation = %s " .
                             "       	and I.id = %s ".
                             "         	and ID.individu = I.id" .
                             "			and FP.classe=ID.classe" .
                             "			and ID.droit=D.id",
                          $this->database_table,
                          $obj_DoFormation->getFormation(),
                          $obj_DoFormation->getIndividu()));
                          
			    while($this->db->next_record()) {
					$user_id=$this->db->f("id");
					$tmp_doits[]=$this->db->f("code");
					$db_uid = $this->db->f("identifiant_md5");
					$login=$this->db->f("login");
			    }

			    //si l'uid ne correspond pas à un compte valide, erreur
			    if($this->db->num_rows()==0){
			    	AstairsTemplate::setPageMessage(FW_7,MSG_ERROR);
			    	return false;
				}else{

					//creation d'un conteneur pour le stockage de session
					$t=new AstairsCtSql(); 
					$t->ac_start();
					
					$this->auth["user_id"]=$user_id;
					$this->auth["uname"]=$login;
					$this->auth["perm"] = implode(',',$tmp_doits);
					$uid=$db_uid;
					//###ici, on est alors connecté a condition de bien retourner l'uid
					
					//on supprime les eventuelles autres session 	
					if($t->ac_unregister_user($this->auth["user_id"])){
						AstairsTemplate::setPageMessage(FW_4,MSG_WARNING);
					}
					else{
						AstairsTemplate::setPageMessage(FW_8,MSG_CONFIRM);
					}
				}
			//duree d'inactivit propre  la formation
    		$res=get_formation_session($obj_DoFormation->getFormation());
			$duree=pg_fetch_result($res,0,1);
			if(!empty($duree)){
			    $sess->setDureeInactifMax(((int)sql_interval_to_secondes($duree)/60));
			}
			return $uid;
		}
//     }
	return false;
   }
   
   function auth_reauth(){
		global $sess,$obj_DoFormation,$s_langue,$langue_par_defaut;
   		
//   		//chargement fichier de langue
//	    if(!$s_langue)$lang=$langue_par_defaut;
//	    else $lang=$s_langue;
//		require_once("$root/langues/$lang/lang.php");;
		
		if(!is_object($obj_DoFormation)){
			AstairsTemplate::setPageMessage(FW_9,MSG_ERROR);
			return false;
		}
	   
		$this->db->query(sprintf("select I.id, I.login ,identifiant_md5 , D.code ".
                     "        from %s ".
                     "       where  FP.formation = %s " .
                     "       	and I.id = %s ".
                     "         	and ID.individu = I.id" .
                     "			and FP.classe=ID.classe" .
                     "			and ID.droit=D.id",
                  $this->database_table,
                  $obj_DoFormation->getFormation(),
                  $obj_DoFormation->getIndividu()));
                  
	    while($this->db->next_record()) {
			$user_id=$this->db->f("id");
			$tmp_doits[]=$this->db->f("code");
			$db_uid = $this->db->f("identifiant_md5");
			$login=$this->db->f("login");
	    }

	    //si l'uid ne correspond pas à un compte valide, erreur
	    if($this->db->num_rows()==0){
	    	$this->auth["perm"]="";
	    	AstairsTemplate::setPageMessage(FW_7,MSG_ERROR);
	    	return false;
		}else{

			//creation d'un conteneur pour le stockage de session
			$t=new AstairsCtSql(); 
			$t->ac_start();

			//affectation des variables obligatoires pour l'authentification				
			$this->auth["user_id"]=$user_id;
			$this->auth["uname"]=$login;
			$this->auth["perm"] = implode(',',$tmp_doits);
			$uid=$db_uid;
			//###ici, on est alors connecté a condition de bien retourner l'uid
				
					
			//on supprime les eventuelles anciennes session front office	
			if($t->ac_unregister_user($this->auth["user_id"])){
				AstairsTemplate::setPageMessage(FW_4,MSG_WARNING);
				
			}else{
				AstairsTemplate::setPageMessage(FW_8,MSG_CONFIRM);				
			}
		}
		//duree d'inactivit propre  la formation
		$res=get_formation_session($obj_DoFormation->getFormation());
		$duree=pg_fetch_result($res,0,1);
		if(!empty($duree)){
		    $sess->setDureeInactifMax(((int)sql_interval_to_secondes($duree)/60));
		}
		return $uid;
   } 
}
?>