<?php
/*
	This file is part of Astairs.

    Astairs is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    any later version.

    Astairs is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Astairs.  If not, see <http://www.gnu.org/licenses/>.

	Copyright (C) 2006, 2007, 2008, 2009 AFIDE
    
	Auteurs:

	Said Ladjani <sladjani@yahoo.fr>
	Remi Cocquet <remi.cocquet@gmail.com>

*/
      
/**
    Affiche les droits des individus d'un groupe

    Affiche les droits sur 3 niveaux
                 1 - Tous les droits communs
                 2 - Les droits qu'aucun utilisateur poss�de
                 3 - Les autres (non commun)

    @param integer : $numg numero du groupe
    @param integer : $database identifiant de la connexion a la base

    @package droits_commun
*/

//PERSMISSIONS REQUISES POUR AFFICHER LA PAGE
$perm->check('GEST');



echo "\n<!---debut-------------lstDroitGrp.php-------------->\n";

print("
<br><img src=\"../images/legende.gif\">
<br><br>");

//--------------------------------------------------------------------------------------
//                                                         REQUETES
//--------------------------------------------------------------------------------------

//Le libelle du Groupe (feuille) correspondant
//$libgroupe=libelle($numg,$database,"classe");
$libgroupe=get_classe_nom_entier($numg);

// recup du nb d'utilisateurs du groupe
//$res=pg_query("select distinct gu_num_user from GESTIONUTIL where gu_num_gest_gr=$numg;");
$res=get_classe_individus($numg,0,'desc');
$nbstags=pg_numrows($res);
//echo "nbstag=$nbstags<br>";
if($nbstags==0) {
    print " $ERROR_53 <!--Erreur dans la base de donn�es : aucun utilisateur dans ce groupe-->.";
    print "<BR><A HREF=\"lstGrp.php3\"><B>".$MSG_37."</B></A>";
    include('../piedpage.php3');
	include("$dbpath/pied_page.php");
    exit;
}


// recup de tous les droits des utilisateurs
//$res=pg_query("select num_droit from droit where type_droit='u';");
$res=get_plateforme_droits(2);
$nbdroit=pg_numrows($res);



// Droits poss�d�s par tous
//$res_tous=pg_query("select gu_num_droit from GESTIONUTIL where gu_num_gest_gr=$numg group by gu_num_droit having count(*)=$nbstags;");
$res_tous=get_classe_droits_communs($numg,$nbstags);
$nb_tous=pg_numrows($res_tous);

//if($nb_tous==0) {
//    print "$ERROR_51 <!--Aucun droit commun pour ce groupe-->";
//}


// Droit que personne ne poss�de
/*
$res_nobody=pg_query("select num_droit from droit where type_droit='u' and num_droit not in  
(select distinct gu_num_droit from gestionutil where gu_num_gest_gr='$numg')  ;");
*/
$res_nobody=get_classe_droits_non_affilies($numg);

$nb_nobody=pg_numrows($res_nobody);


//--------------------------------------------------------------------------------------"
//                        TRAITEMENTS PHP
//-----------------------------------------------------------------------"
$stockdroit=array();
$stockutil=array();

// stockage des droits dans un tableau
for($d=0;$d<$nbdroit;$d++){
    $row=pg_fetch_row($res,$d);
    $stockdroit[$d]=$row[0];
}

//--------------------------------------------------------------------------------------"
//                             AFFICHAGE
//-----------------------------------------------------------------------"

print("
<br>
<table class=\"tableau_message\">
<tr>
<td>
$MSG_682 : <b>$libgroupe</b><br>
$MSG_684 : <b>$nbdroit</b>
</td>
</tr>
</table>
<br>
");

print("
<br>
<table class=\"tableau_espace\">
<tr>
<th>$MSG_831</th>
<th>$MSG_685</th>
<th>$FORM_1</th>
</tr>
");

//droits   poss�d�s par tous
$val="";
$classcolor="couleur2";

for($i=0;$i<$nb_tous;$i++) {

    $row=pg_fetch_row($res_tous,$i);
    // stockage
    $stockutil[]=$row[0];
    //concat�nation
    if($i==$nb_tous-1)
        $val .="$row[0]";
    else
        $val .="$row[0],";

    $classcolor=($classcolor=="couleur2"?"couleur1":"couleur2");

    //$resd=pg_query("select libelle_droit from DROIT where num_droit=$row[0];");
	$resd=get_droit($row[0]);
    $d=pg_fetch_row($resd,0);
    print "<tr class=\"$classcolor\">
                    <!--<td bgcolor=\"#d6def8\" height=56>-->
                    <td align=\"center\"><img src=\"../images/dattribue.gif\"></td>
                    <td><b>$d[1]</b></td>";

    $libdroit=ereg_replace(" ","_",$d[1]);


    print ("     <td align=\"center\">
                     ");
    if($perm->have_perm('DEL')){                 
		print ("<a href=\"porte_bo.php?numd=$row[0]&numg=$numg&vers=supprimer\"
                                    OnClick=\"return(Question('$WARN_58'))\">
                            $FORM_4
                       </a>");  
    }    
   print("
                    </td>
            </tr>");
}


// Droit que personne ne poss�de
for($i=0;$i<$nb_nobody;$i++) {

    $classcolor=($classcolor=="couleur2"?"couleur1":"couleur2");

    $row=pg_fetch_row($res_nobody,$i);
    $stockutil[]=$row[0];

    $row=pg_fetch_row($res_nobody,$i);
    //$resd=pg_query("select libelle_droit from DROIT where num_droit=$row[0];");
	$resd=get_droit($row[0]);
    $d=pg_fetch_row($resd,0);
    print "<tr class=\"$classcolor\">
                    <td align=\"center\"><img src=\"../images/dnonattrib.gif\"></td>
                    <td><b>$d[1]</b></td>";
    $libdroit=ereg_replace(" ","_",$d[1]);
       print ("     <td align=\"center\">
                     ");
    if($perm->have_perm('ADD')){                 
		print ("<a class=\"action\" href=\"porte_bo.php?numg=$numg&numd=$row[0]&vers=ajouter\"> $MSG_688</a>");  
    }    
   print("
                    </td>
            </tr>");
}

// les droits nom communs
$sz=sizeof($stockdroit);
for($u=0;$u<$sz;$u++){

    $classcolor=($classcolor=="couleur2"?"couleur1":"couleur2");

    if(!in_array("$stockdroit[$u]",$stockutil)){

        //$resd=pg_query("select libelle_droit from DROIT where num_droit=$stockdroit[$u];");
		$resd=get_droit($stockdroit[$u]);
        $d=pg_fetch_row($resd,0);
        $dr=$stockdroit[$u];

         print "<tr class=\"$classcolor\">
                    <td align=\"center\"><a href=\"javascript:pop_user('fenetre_droits.php?numg=$numg&droit=$dr')\">
                            <img src=\"../images/droitlimite.gif\" alt=\"Voir les users\" border=0></a>
                    </td>
                    <td>
                            <b>$d[1]</b>
                    </td>";

         $libdroit=ereg_replace(" ","_",$d[1]);

        print ("    <td align=\"center\">&nbsp;</td>
            </tr>");

    }
}

print "</table>";

if($val=="")
    $val=0;


echo "\n<!---fin-------------lstDroitGrp.php-------------->\n";

?>
