<?php
/*
	This file is part of Astairs.

    Astairs is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    any later version.

    Astairs is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Astairs.  If not, see <http://www.gnu.org/licenses/>.

	Copyright (C) 2006, 2007, 2008, 2009 AFIDE
    
	Auteurs:

	Said Ladjani <sladjani@yahoo.fr>
	Remi Cocquet <remi.cocquet@gmail.com>

*/
                   
/**
    Affiche la liste des droits pour un utilisateur.

    Affiche la liste des droits pour un utilisateur, et
    permet l'ajout ou la suppression de chacuns de ces droits.

    @package droits_commun
*/

//PERMISSIONS REQUISES POUR AFFICHER LA PAGE
$perm->check('GEST');


if(empty($num_stag)||empty($numg)){
	die("Erreur: parametres manquants");
}
  
echo "\n<!---debut-------------lstDroitUtil.php-------------->\n";

//---------------------------------------------------------------------//
//              FONCTIONS PHP
//---------------------------------------------------------------------//
/**
*   Formate une chaine de caract�re pour un affichage html.
*
*   Les caract�res '/' sont utilis�s comme separateur, tout est affich� en noir
*   sauf  le dernier bloc qui est affich� en bleu. Les '/' sont conserv�s.
*
*   @param string : la chaine a formater
*   @return string : la chaine format�e
*/
function formate_texte($chaine){
    $texte="";
    $tab=explode("/",$chaine);
    $sz=sizeof($tab);
    if($sz>1){
        $texte .="<i><font color=\"#000000\" size=2>";
        for($i=0;$i<$sz -1;$i++)
            $texte .=$tab[$i]." / ";
        $texte .="<font></i>";

    }
    $texte .="<b><font color=\"#0000ff\" size=2>".$tab[$sz -1]."</font></b>";
    return $texte;

}
//-----------------------------------------------------------------------------------------//
//                              INITIALISATION
//-----------------------------------------------------------------------------------------//
// stockage des droits dans un tableau
/*
$req="select num_droit,libelle_droit from droit where type_droit='u' order by libelle_droit;";
$resdroit=pg_query($req);
*/
$resdroit=get_plateforme_droits(2);
$nbdroit=pg_numrows($resdroit);
$stockdroit=array();
for($d=0;$d<$nbdroit;$d++){
    $rowdroit=pg_fetch_row($resdroit,$d);
    $stockdroit[$rowdroit[0]]=$rowdroit[1];
}

// stockage des droits de l'utilisateur dans un tableau
$res=get_individu_droits_classe($num_stag,$numg);
$nb=pg_numrows($res);
$stockutil=array();
for($d=0;$d<$nb;$d++){
    $row=pg_fetch_row($res,$d);
    $stockutil[]=$row[0];
}
// nom du groupe
//$libgroupe=libelle($numg,$db,"classe");
$libgroupe=get_classe_nom_entier($numg);
$libgroupe=formate_texte($libgroupe);
// nom de l'utilisateur


$resuser=get_individu_nom_prenom($num_stag);
$rowuser=pg_fetch_row($resuser,0);
//-----------------------------------------------------------------------------------------//
//                              AFFICHAGE ENTETE
//-----------------------------------------------------------------------------------------//

print("
<br>
<table class=\"tableau_message\">
<tr>
<td>
$MSG_682 : <b>$libgroupe</b><br>
$MSG_18 : <b>$rowuser[1] $rowuser[2]</b><br>
$MSG_684 : <b>$nbdroit</b>
</td>
</tr>
</table>
<br>

");
//-----------------------------------------------------------------------------------------//
//                              AFFICHAGE DEBUT TABLEAU
//-----------------------------------------------------------------------------------------//
print("
<br>
<table class=\"tableau_espace\">
<tr>
    <th>$MSG_816 $MSG_831</th>
    <th>$MSG_685</th>
    <th>$FORM_1</th>
</tr>
");
// boucle sur le nombre de droits
$cpt_color=0;
while(list($num_droit,$libelle_droit)=each($stockdroit)){
    $classcolor=($cpt_color%2==0||$cpt_color==0?"couleur1":"couleur2");
    $cpt_color++;
    print("
    <tr class=\"$classcolor\">
    <!--<td align=\"center\" width=\"20%\" bgcolor=\"ddddff\">-->
    <td align=\"center\" width=\"20%\">
    ");
    if(in_array($num_droit,$stockutil)){
        $droit_existe=1;
        print("
        <img src=\"../images/dattr1.gif\">
        ");
    }
    else {
        $droit_existe=0;
        print("
        <img src=\"../images/dnonatt1.gif\">
        ");
    }
    print("
    </td>
    <td><b>$libelle_droit</b></td>
    <td align=\"center\">
    ");
    if($droit_existe){
     	
     	if($perm->have_perm('DEL')){
	    	if($nb>1)
	            print("
	            <a class=\"action\" href=\"porte_bo.php?user=$num_stag&numg=$numg&droit=$num_droit&num_cal=$num_cal&vers=supprimerU\">
	            $MSG_687</a>
	            ");
	        else
	            print(MSG_1593);
     	}
    }else{
    	if($perm->have_perm('ADD')){
	        print("
	        <a class=\"action\" href=\"porte_bo.php?user=$num_stag&numg=$numg&droit=$num_droit&num_cal=$num_cal&vers=ajouterU\">
	         $FORM_11</a>
	        ");
    	}
	}
    print("
    </td></tr>
    ");

}
print("
</table>
");
echo "\n<!---fin-------------lstDroitUtil.php-------------->\n";
?>