<?php
/*
	This file is part of Astairs.

    Astairs is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    any later version.

    Astairs is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Astairs.  If not, see <http://www.gnu.org/licenses/>.

	Copyright (C) 2006, 2007, 2008, 2009 AFIDE
    
	Auteurs:

	Said Ladjani <sladjani@yahoo.fr>
	Remi Cocquet <remi.cocquet@gmail.com>

*/

//-----------------------------------------------
//        		LIBRAIRIES DE BACK OFFICE
//			(communes à tout le back office)
//----------------------------------------------
require_once("$chemin_bo/includes.php");

//-----------------------------------------------
//        		TEMPLATES DE BACK OFFICE
//			(communs à tout le back office)
//----------------------------------------------
$list_tpl = array(
	'structure' => 'structure_xhtml11.tpl',
	'meta' => 'meta.tpl',
	'style' => 'style.tpl',
	'javascript' => 'javascript.tpl',
	'internal_javascript' => 'internal_javascript.tpl',
	'content' => 'content_back.tpl');

//-----------------------------------------------
//        		OUVERTURE DE SESSION 
//					BACK OFFICE
//----------------------------------------------
page_open(
         array("sess" => "AstairsBackSession",
               "auth" => "AstairsAuth",
               "perm" => "AstairsPerm"));

//-----------------------------------------------
//        			LANGUES
//----------------------------------------------
//changement de langue               
PlateformeLangues::submit($_GET);

//inclusion du fichier de langue
require_once("$root/langues/".$s_langue."/lang.php");

//-----------------------------------------------
//        	LE CONSTRUCTION DE PAGES
//	(pour toutes les pages de back office -AstairsPageBO-)
//----------------------------------------------
//constructeur de page
$page_builder=new PageBuilder("$root/lib/framework/templates/tpl",$list_tpl,$page_lang,CHARSET,"../../bo/styles/$style_par_defaut",$page_javascript_path, $page_resolution);

//-----------------------------------------------
//        		CHARGEMENT DU MODULE
//					BACK OFFICE
//----------------------------------------------

if(!empty($_POST['obj_list_add_remove'])){
//	echo "guiBoModuleIndividusTypesDroits::submit";
	guiBoModuleIndividusTypesDroits::submit($_POST);
}

//include("../module_menu/register_module.php");
include("$dbpath/bo/module_menu/register_module.php");


//-----------------------------------------------
//       VERIFICATION DU PATH
//----------------------------------------------

if(!$no_path_verify&&!$obj_module->isDirectoryValid()){
	header("location:$dbpath");
	include("$dbpath/pied_page.php");
	exit();
}
//-----------------------------------------------
//        			LES CSS
//		(communes à tout le back office)
//----------------------------------------------
$style_file_path=$page_builder->getStylePath();		//le repertoire des feuilles de style
$style_files[$style_file_path][]="global.css";		//styles communs à toute la plateforme
$style_files[$style_file_path][]="back_office.css";						//styles communs à tout le back office
if(is_object($obj_module)){
	
	$style_files[$style_file_path][]="bo_modules_".strtolower($obj_module->getType()).".css"; //styles des ressources pédagogiques/humaines/administatives ou outlils
	$style_files[$style_file_path][]="bo_module_".strtolower($obj_module->getCode()).".css"; //styles du module
	
}

//pour les langues ams
if(strtolower($obj_module->getType())!='fw'){
	include_once("$chemin_bo/templates/obj/AstairsPageBoDebut.php");
	AstairsPageBoDebut::submit($_POST);
}
//require_once("$chemin_bo/includes.php");
//
//
//$list_tpl = array(
//	'structure' => 'structure_xhtml11.tpl',
//	'meta' => 'meta.tpl',
//	'style' => 'style.tpl',
//	'javascript' => 'javascript.tpl',
//	'internal_javascript' => 'internal_javascript.tpl',
//	'content' => 'content_back.tpl');
//
//page_open(
//         array("sess" => "AstairsBackSession",
//               "auth" => "AstairsAuth",
//               "perm" => "AstairsPerm"));
//
////changement de langue               
//PlateformeLangues::submit($_GET);
//
////inclusion du fichier de langue
//require_once("$root/langues/".$s_langue."/lang.php");
////echo "$root/langues/".$s_langue."/lang.php";
////constructeur de page
//$page_builder=new PageBuilder("$root/lib/framework/templates/tpl",$list_tpl,$page_lang,$page_encoding,"../../bo/styles/afide",$page_javascript_path, $page_resolution);
//
//
?>