<?php
/*
	This file is part of Astairs.

    Astairs is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    any later version.

    Astairs is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Astairs.  If not, see <http://www.gnu.org/licenses/>.

	Copyright (C) 2006, 2007, 2008, 2009 AFIDE
    
	Auteurs:

	Said Ladjani <sladjani@yahoo.fr>
	Remi Cocquet <remi.cocquet@gmail.com>

*/

/*-------------------------------------------------------*/
//  Fichier alert.php
// Action : Propose la saisie d'une alerte pour les stagiaire en front office
// Donnes reues : $date (ex 2003-02-28) et $num_cal
/*-------------------------------------------------------*/
//inclusions
$dbpath="../..";  //le dbpath sert  maintenir les inclusions  partir du $chemin_bo
include("$dbpath/en_tete.php"); //contient les traitements communs  l'ensemble du FrameWork Astairs
include("../en_tete_back.php"); //contient les traitements communs  l'ensemble du BackOffice Astairs

//$db = pg_Connect("$server", "", "", "", "$nombase");
require("$root/lib/lib_formation.php");
require("$root/lib/obj_formation.php");
require("$chemin_bo/evenement/fonctions_evenement.php");
$styleCSS = "../style/" . MY_STYLE . "/ressourcesPedagogiques.css";
// debug
//echo "nous sommes le ".date("m-d-Y");
//echo "num_cal=$num_cal et date=$date<br>";
/*-------------------------------------------------------*/
//          FONCTIONS PHP
/*-------------------------------------------------------*/
// fonction qui retourne la periode max disponible
function calcul_periode($num_cal,$date){
    //recup des jours > $date
   
    $periode=get_alerte_periode_max($num_cal,$date);
    
	if($periode>15 || empty($periode))
		$periode=15;
    return $periode;
}
// fonction de mise  jours des periodes prcdentes
// ex : si le 15/03/2003 il y a une alerte pour 15 jours
//        et qu'on met une alerte le 25/03/2003 alors
//        il faut reduire la periode  9 jours
function maj_periode($num_cal,$num_date){
    // recup de la date de num_date
    /*
    $req="select jour from dates where num_date='$num_date'";
    $res=pg_exec($req);
    */
    $res=get_date_jour($num_date);
    $row=pg_fetch_row($res,0);
    $date=$row[0];
    //recup des jours < $date
    /*
    $req="select jour,num_date from dates where num_date in
    (select num_date from alert where num_cal='$num_cal') and jour<'$date' order by jour desc";
    $res=pg_exec($req);
    */
    $res=get_alerte_jours_avant_date($num_cal,$date);
    if(pg_numrows($res)>0){
        //recup du jour precedent
        $row=pg_fetch_row($res,0);
        //print_r($row);

        // recup de la periode de ce jour
        /*
        $req="select periode from alert where num_cal='$num_cal' and num_date='$row[1]'";
        $resperiode=pg_exec($req);
        */
        $resperiode=get_alerte_periode($num_cal,$row[1]);
        $rowperiode=pg_fetch_row($resperiode,0);
        $periode=$rowperiode[0];
        $tabjour=explode("-",$row[0]);
        $tabdate=explode("-",$date);
        $jour = mktime( 0, 0, 0, $tabjour[1], $tabjour[2], $tabjour[0] );
        $dt = mktime( 0, 0, 0, $tabdate[1], $tabdate[2], $tabdate[0] );
        $dif=($dt -$jour) / (60*60*24);
        //echo "periode=$periode et dif=$dif<br>";
        if($periode>=$dif){
            $periode=$dif -1;
            /*
            $req="update alert set periode='$periode' where num_cal='$num_cal' and num_date='$row[1]'";
            $res=pg_exec($req);
            */
            $res=maj_alerte_periode($num_cal,$row[1],$periode);
        }
    }
}
/*-------------------------------------------------------*/
//          SOUMISSION FORMULAIRE
/*-------------------------------------------------------*/
if(isset($subalert)){
    //print_r($_GET);
    // debug
    //echo "date=$date <br>num_cal=$num_cal<br>alert=$alert<br>periode=$periode<br>titre=$titre<br>num_date=$num_date";
    if($periode=="")
        $periode='NULL';
    //$alert=addslashes($alert);
    //$alert=nl2br($alert);
    //$titre=addslashes($titre);
    // test si alerte pour ce jour de formation
	$resalert=get_formation_alerte($num_cal,$date);
	$rowalert=pg_fetch_row($resalert,0);
	if(empty($rowalert[0]) ){
        /*
        $sql="insert into alert (num_cal,num_date,periode,intitule,texte) values($num_cal,$num_date,$periode,'$titre','$alert');";
        echo "sql=$sql<br>";
        $ins=pg_exec($db,"insert into alert (num_cal,num_date,periode,intitule,texte) values($num_cal,$num_date,$periode,'$titre','$alert');");
        */
        $ins=set_alerte($num_cal,$date,$periode,set_ams_libelle($titre),set_ams_libelle(nl2br2($alert)));
        $mesg=MSG_1313;
    }
    else {
        
        $maj=maj_alerte($rowalert[0],$periode,set_ams_libelle($titre),set_ams_libelle(nl2br2($alert)));
        $mesg=MSG_2660;
    }
    // mise  jour des periodes prcdentes
    //maj_periode($num_cal,$num_date);
}
/*-------------------------------------------------------*/
//          FONCTIONS JAVASCRIPT
/*-------------------------------------------------------*/
print("
<script language=\"javascript\">
function validealert(){
    document.formalert.submit();
}
</script>
");
// debug
//echo "alert=$selalert<br>";

//$date_du_jour=fr_txt_date($date,MY_LANG);
echo "date=$date<br>";
$date_du_jour=fr_txt_date($date,$s_langue);

//$num_date=get_num_date($date);
// Affichage entete

print("
<html>
<HEAD>
<TITLE>alert.php</TITLE>
");
print "<META HTTP-EQUIV=\"CONTENT-TYPE\" CONTENT=\"TEXT/HTML; CHARSET=" . CHARSET . "\">";
print("
<body bgcolor=\"#ffffff\">
");
$styleCSS = "../style/".MY_STYLE."/ressourcesPedagogiques.css";
if(isset($styleCSS)&&$styleCSS!=""){
    //echo "coucou $styleCSS $fileconf<br>";
    print ("<meta http-equiv=Content-Style-Type content=\"text/css;\">\n");
    print ("<link rel=\"stylesheet\" href=\"$styleCSS\" type=\"text/css\">");
}


if(isset($mesg)){
print("
<center>
<font face=\"Arial,Helvetica\" size=2 color=\"#ff0000\">$mesg</font><br>
<form>
<input type=\"button\" value=\"$FORM_22\" onclick='javascript:window.close()'>
</form>
</center>
");
reload_father('evenement.php');
}
else {
print("
<form name=\"formalert\" action=\"alert.php\">
<table class=\"tableau_normal2\">
<tr class=\"couleur1\">
<td><b>$MSG_650 :</b></td>
<td>$date_du_jour</td>
</tr>
");
// recup des alert en fonction du formateur
/*
$req="select * from alert where num_cal in
(select distinct g_num_cal from gestionnaire where g_num_user='$num_formateur')";
$resalert=pg_exec($req);
*/
//$resalert=get_formateur_alertes($num_formateur);
$resalert=get_formation_alertes($num_cal);
$nbalert=pg_numrows($resalert);
if($nbalert>0){
    print("
    <tr class=\"couleur2\"><td><font face=\"Arial,Helvetica\" size=2>
    <!--Slection d'une alerte-->$MSG_1549 :</font></td><td><font face=\"Arial,Helvetica\" size=2><select name=\"selalert\" onchange=\"validealert();\">
    <option value=\"\">$MSG_217 <!--Slectionnez-->
    ");
    for($a=0;$a<$nbalert;$a++){
        $rowalert=pg_fetch_row($resalert,$a);
		$tmp_alerte=get_ams_libelles($rowalert[1]);
        $rowalert[1]=get_ams_libelle($tmp_alerte,50);
        if($selalert==$rowalert[0])
            print("
            <option value=\"$rowalert[0]\" selected>$rowalert[1]</option>
            ");
        else
             print("
            <option value=\"$rowalert[0]\">$rowalert[1]</option>
            ");

    }
    print("
    </select></td></tr>
    ");
}
if($selalert>0){
    unset($periode);
    //recup des valeurs
    /*
    $req="select * from alert where num_alert='$selalert'";
    $res=pg_exec($req);
    */
    $res=get_alerte($selalert);
    $row=pg_fetch_row($res,0);
      $row[5]=str_replace("<br />","","$row[5]");
    // debug
    //echo "selalert=$selalert<br>row[3]=$row[3]<br>periode=$periode";


}
// calcul de la priode disponible  raison de 15 jours max
$maxperiode=0;
$maxperiode=calcul_periode($num_cal,$date);
//debug
//echo "maxperiode=$maxperiode<br>";
print("
<tr class=\"couleur2\"><td colspan=2><hr></td></tr>
<tr class=\"couleur2\"><td colspan=2><!--Ou crer une alerte-->$MSG_1551</td></tr>
<tr class=\"couleur2\"><td>$MSG_590 : </td>
<!--<td><input type=text name=\"titre\" size=50 value=\"$row[1]\"></td>-->
<td>".get_gui_libelle_input('titre',$row[1])."</td>
</tr>
<tr class=\"couleur2\"><td>$MSG_1360 : </td>
<!--<td><textarea name=\"alert\" rows=3 cols=30>$row[5]</textarea></td>-->
<td>".get_gui_libelle_textearea('alert',$row[5])."</td>
</tr>
<tr class=\"couleur2\"><td><!--Valable ce jour ou pendant-->$MSG_1552 :</td><td align=center>
<select name=\"periode\">
<option value=\"\">$MSG_217 <!--Slectionnez--></option>
");


for($i=1;$i<$maxperiode+1;$i++){
    if($i==$periode || $i==$row[4])
        print("
        <option value=\"$i\" selected>$i jour(s)</option>
        ");
    else
        print("
        <option value=\"$i\">$i jour(s)</option>
        ");
}
print("
</select></td></tr>
<input type=hidden name=\"date\" value=\"$date\">
<input type=hidden name=\"num_cal\" value=\"$num_cal\">
<tr class=\"couleur2\"><td colspan=2><hr></td></tr>
<input type=hidden name=\"num_date\" value=\"$num_date\">
<input type=hidden name=\"num_formateur\" value=\"$num_formateur\">
<tr class=\"couleur2\"><td colspan=2 align=center>
<input type=submit name=\"subalert\" value=\"$FORM_6\"></td>
</tr>
");
/*
if(isset($selalert))
	print("
	<input type=hidden name=\"selalert\" value=\"$selalert\">
	");
*/

print("
</table>
</form>
");
}
print("
</body>
</html>
");
include("$dbpath/pied_page.php");
?>