<?php
/*
	This file is part of Astairs.

    Astairs is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    any later version.

    Astairs is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Astairs.  If not, see <http://www.gnu.org/licenses/>.

	Copyright (C) 2006, 2007, 2008, 2009 AFIDE
    
	Auteurs:

	Said Ladjani <sladjani@yahoo.fr>
	Remi Cocquet <remi.cocquet@gmail.com>

*/

/**
 Affiche la correction d'un exercice d'un stagiaire

 Cette page permet d'afficher une correction.
 Elle propose en des liens vers la modification, la suppression et
 une correction  partir de ce modele, si la variable $edition==1

 NOTE: elle est appelle par correction.php
 @package exotlc_commun
*/
echo "<!--debut--showCorrExoStag.php-->\n";
$NIVEAU_DEBUG = 0;

//----------------------------------------------------------------
//	AFFICHAGE
//----------------------------------------------------------------

// debug
//echo "num_cam=$num_cal et exo=$exo et numuser=$numuser et parcours=$parcours<br>";
// 1- Recup de l'identifiant de resultat
$res=get_resultat_etape($num_cal,$numuser,$parcours,$exo);
$id_resultat=pg_fetch_result($res,0,0);
//echo "id_res=$id_resultat<br>";
// recup des sous criteres 
$verifdejapresent=get_resultat_exotlc_sous_criteres($id_resultat);
$numcols = pg_num_rows($verifdejapresent);
//echo "numcols=$numcols<br>";
// recup des rubriques pour ce resultat
$resrub=get_resultat_exotlc_criteres($id_resultat);
$numrub = pg_num_rows($resrub);
//echo "numrub=$numrub<br>";
// stockage des criteres
$tabrub = array();
for ($i = 0; $i < $numrub; $i ++) {
	$rowrub = pg_fetch_row($resrub, $i);
	if (!in_array("$rowrub[1]", $tabrub)) {
		$tabrub[] = $rowrub[1];
		messageDebug("Ajoute ".$rowrub[1]." aux rubriques  traiter.");
	}
}
// debug
//print_rr($tabrub);

print ("
<BR><BR>

<TABLE class=tableau_information align=\"center\" COLS=\"$numcols\"  WIDTH=\"80%\">

");

print "\n<TR >";
// boucle sur les criteres
for ($i = 0; $i < sizeof($tabrub); $i ++){
	$rub = $tabrub[$i];
	//On compte le nombre de sous rubriques pour une rubrique courante
	/*
	$rescols = pg_query("select distinct gesttlc_srub from GESTEXOTLC where
			gesttlc_rub='$rub'and gesttlc_exo='$exo' and gesttlc_user='$numuser' and num_cal='$num_cal' ;");
	*/
	$rescols=get_resultat_exotlc_critere_sous_criteres($id_resultat,$rub);		
	$nbcols = pg_num_rows($rescols);
    //echo "nbcols=$nbcols<br>";
	$k = $i +1;
	if ($nbcols == 0) {
		print "<TD><span class=titre_information>".MSG_784." $k </span><BR>\n";
		

		//On rucupere le libelle
		//$lib = pg_query("select libelle_rub from RUBRIQUE where num_rub='$rub';");
		//$lib = pg_fetch_row($lib, 0);
		$reslib=get_critere($rub);
		$lib=pg_fetch_result($reslib,0,1);
		print "<span class=valeur_information>";
		echo get_gui_libelle($lib);
		//echo $lib;
		print "</span>";
		print "</TD>";
	} 
	else {
		print "<TD COLSPAN=\"$nbcols\" ALIGN=CENTER><span class=titre_information>".MSG_784." $k</span><BR>\n";
		//On rucupere le libelle
		//$sql = "select libelle_rub from RUBRIQUE where num_rub='$rub';";
		messageDebug($sql);
		//$lib = pg_query($sql);
		//$lib = pg_fetch_row($lib, 0);
		$reslib=get_critere($rub);
		$lib=pg_fetch_result($reslib,0,1);
		print "<span class=valeur_information>";
		//echo htmlentities($lib);
		echo get_gui_libelle($lib,false);
		print "</span>";
		print "</TD>";
	}
}
print "\n</TR>";

print "<TR >";
//La ligne des libelles de sous rubriques
for ($i = 0; $i < sizeof($tabrub); $i ++) {
	//On boucle sur les numeros de rubriques
	$rub = $tabrub[$i];
	//$ressrub=pg_fetch_row($resrub,$i);
	//On compte le nombre de sous rubriques pour une rubrique courante
	/*
	$sql = "select gesttlc_srub from GESTEXOTLC where
		        gesttlc_rub='$rub' and gesttlc_exo='$exo' and gesttlc_user='$numuser' and num_cal='$num_cal' and gesttlc_srub!=0;";
	messageDebug($sql."<br>");
	$rescols = pg_query($sql);
	$nbcols = pg_numrows($rescols);
	*/
	$rescols=get_resultat_exotlc_critere_sous_criteres($id_resultat,$rub);		
	$nbcols = pg_num_rows($rescols);
	messageDebug("pour la rubrique $rub on a $nbcols sous rubriques");

	$k = $i +1;

	if ($nbcols == 0 ) {
		print "<TD class=ligne_information2 >&nbsp;</TD>\n";
	} 
	else {
		//on ajoute au row span final les colones suppl\x{00E9}mentaires
		$numcols=$numcols-1+$nbcols;
		
		$rowcol = pg_fetch_row($rescols, 0);
		for ($j = 0; $j < $nbcols; $j ++) {
			$k = $j +1;
			$rowcol = pg_fetch_row($rescols, $j);
			print "<TD class=ligne_information2>\n";
			print "<span class=titre_information>".MSG_785." $k </span><BR>\n";
			//On rucupere le libelle
			/*
			$lib = get_critere($rowcol[0], -1);
			$lib = pg_fetch_row($lib, 0);
			*/
			//$reslib=get_critere($rub);
			$reslib=get_critere($rowcol[2]);
			$lib=pg_fetch_result($reslib,0,1);
			print "<span class=valeur_information>";
			//echo htmlentities($lib);
			echo get_gui_libelle($lib,false);
			print "</span>";
			print "</TD>";
		}
	}
}
print "</TR>";

//La ligne des notes par sous rubrique
print "\n<TR>\n";
for ($i = 0; $i < sizeof($tabrub); $i ++) {
	//On boucle sur les numeros de rubriques
	//$ressrub=pg_fetch_row($resrub,$i);
	$rub = $tabrub[$i];
	//On recupere les notes de chaque rubrique
	/*
	$rescols = pg_query("select resultat,notesur from GESTEXOTLC where gesttlc_rub='$rub'and
			gesttlc_exo='$exo' and gesttlc_user='$numuser' and num_cal='$num_cal';");
	$nbcols = pg_numrows($rescols);
	*/
	$rescols=get_resultat_exotlc_critere_sous_criteres($id_resultat,$rub);		
	$nbcols = pg_num_rows($rescols);

	if ($nbcols == 0) {
		$resnote=get_resultat_exotlc_critere($id_resultat,$rub);
		$rownote=pg_fetch_row($resnote,0);
		//$rownote = pg_fetch_row($rescols, 0);
		print "<TD class=ligne_information1><span class=titre_information>".MSG_2531."</span> : ";
		print "<span class=valeur_information>$rownote[2] / $rownote[3]</span></TD>\n";
	}

	for ($j = 0; $j < $nbcols; $j ++) {
		$rownote = pg_fetch_row($rescols, $j);
		print "<TD class=ligne_information1>".MSG_2531." : ";
		print "$rownote[4] / $rownote[5]</TD>\n";
	}
}
print "</TR>\n";

//Ligne pour le commentaire gnral du formateur (par rubrique)
print "<TR >";
for ($i = 0; $i < sizeof($tabrub); $i ++) {
	//On boucle sur les numeros de rubriques
	$rub = $tabrub[$i];
	//$ressrub=pg_fetch_row($resrub,$i);
	//On comptabilise le nombre de colonnes pour une rubrique
	/*
	$rescols = pg_query("select resultat,notesur from GESTEXOTLC where gesttlc_rub='$rub'and
			gesttlc_exo='$exo' and gesttlc_user='$numuser' and num_cal='$num_cal';");
	$nbcols = pg_numrows($rescols);
	*/
	$rescols=get_resultat_exotlc_critere_sous_criteres($id_resultat,$rub);		
	$nbcols = pg_num_rows($rescols);
	// recup commentaire critere
	$rescomment=get_resultat_exotlc_critere($id_resultat,$rub);
    $rowcomment = pg_fetch_row($rescomment, 0);
    //print_rr($rowcomment);
	$comment = $rowcomment[4];
	if ($nbcols == 0) {
		/*
		$rescomment = pg_query("select commentaire from commentuserrub
						where num_user='$numuser' and num_exo='$exo' and num_rub='$rub' and num_cal='$num_cal';");
		$rowcomment = pg_fetch_row($rescomment, 0);
		$comment = htmlentities($rowcomment[0]);
		*/
		print "<TD class=ligne_information1><span class=titre_information>".MSG_789." :</span> <span class=valeur_information>".get_gui_libelle($comment)."</span>";
		print "</TD>\n";
	} 
	else {
		/*
		$rescomment = pg_query("select commentaire from commentuserrub
						where num_user='$numuser' and num_exo='$exo' and num_rub='$rub' and num_cal='$num_cal';");

		$rowcomment = pg_fetch_row($rescomment, 0);
		*/
		print "<TD class=ligne_information1 COLSPAN=\"$nbcols\">\n";
		//$comment = htmlentities($rowcomment[0]);
		print "<span class=titre_information>".MSG_789." :</span> <span class=valeur_information>".get_gui_libelle($comment)."</span>";
		print "</TD>\n";

	}
}
print "</TR>\n";

//Commentaire gnral de fin et note globale
print "<TR ><TD class=ligne_information2 COLSPAN=\"$numcols\">&nbsp;</TD></TR>\n";
/*
//echo "user=$numuser et exo=$exo<br>";
$notegen = pg_query("select commentaire,surtotal,score,corrige from resexouser
where num_user='$numuser' and num_exo='$exo' and num_cal='$num_cal';");
if ($notegen) {
	$notegen = pg_fetch_row($notegen, 0);
	//echo "notegen[1]=$notegen[1]<br>notegen[2]=$notegen[2]";
	$note = (20 * $notegen[2]) / $notegen[1];
	//echo "score = $notegen[2] <br> surtotal = $notegen[1]";
	$note = sprintf("%01.2f", $note);
	$commentgen = htmlentities($notegen[0]);
	$corrige = $notegen[3];
}
*/
$rescomment=get_resultat_exotlc($id_resultat);
$commentgen=pg_fetch_result($rescomment,0,7);

$corrige=pg_fetch_result($rescomment,0,8);
// recup de la note general (sur 20)
$resnotegen=get_resultat_exotlc_moyenne($id_resultat);
$note=pg_fetch_result($resnotegen,0,0);
 $note = sprintf("%01.2f", $note);
print "<TR >
        <TD class=ligne_information1 COLSPAN=\"$numcols\">
            <span class=titre_information>".MSG_783." :</span>
            <span class=valeur_information>$note / 20</span>
        </TD>
        </TR>\n";
print "<TR >
            <TD class=ligne_information2 COLSPAN=\"$numcols\">&nbsp;</TD>
        </TR>\n";
print "<TR >
            <TD class=ligne_information1 COLSPAN=\"$numcols\">
            <span class=titre_information>".MSG_788." :</span>
            <span class=valeur_information>".get_gui_libelle($commentgen)."</span></TD>
        </TR>\n";
print "<TR >
            <TD class=ligne_information2 COLSPAN=\"$numcols\">&nbsp;</TD>
        </TR>\n";
if ($corrige == 'f') {
	print "<TR >
	            <TD class=ligne_information1 COLSPAN=\"$numcols\">
	            <span class=valeur_information>".MSG_1731."</span></TD>
	        </TR>\n";
} else
	if ($corrige == 't') {
		$fic_corr = "select distinct fic_correction from gestfic where gestfic_num_exo=$exo";
		$res_fic_corr = pg_query($fic_corr);
		$nb_fic_corr = pg_num_rows($res_fic_corr);
		print "<TR >
		            <TD class=ligne_information1 COLSPAN=\"$numcols\">
		            <span class=valeur_information>".MSG_1730."<br>
		            <font size=2><i>";
		for ($z = 0; $z < $nb_fic_corr; $z ++) {
			$row_fic_corr = pg_fetch_row($res_fic_corr);
			if ($row_fic_corr[0] != "")
				print "($row_fic_corr[0]) ";
		}
		print "</i></font>
		             </span></TD>
		        </TR>\n";
	} else {
		print "<TR >
		                <TD class=ligne_information1 COLSPAN=\"$numcols\">
		                <span class=valeur_information>".MSG_1729."</span></TD>
		                </TR>\n";
	}

print "</TABLE>\n";

//----------------------------------------------------------------
//	LIENS + PIED PAGE
//----------------------------------------------------------------

//si on arrive directement sur cette page on ne peu que voir et non modifier
if ($edition == 1) {

	//on affiche les liens pour l'interface formateur ou le suivi individuel
	if ($interface == "parcours")
		$page = "fenetre_correction.php";
	else
		$page = "correction.php";

	print ("<DIV>
		<BR>
		<TABLE  BORDER=0 WIDTH=\"80%\">
		 <!--proposition de correction a partir de ce modele-->
		<tr >
		  <td ALIGN=center colspan=3>
		       <A HREF=\"$page?interface=$interface&numexo=$exo&numstag=$numuser&num_cal=$num_cal&numform=$nomcal&numgrp=$numGroupe&action=addCorrExoTemplate.php&mode=$mode\">
		        <span class=liensretour> ".MSG_2305."</span></A>
		  </td
		</tr>
		
		<!--modification de la correction-->
		<TR><TD ALIGN=left>&nbsp;</TD>
		<TD ALIGN=CENTER><A HREF=\"$page?parcours_vers=$parcours_vers&interface=$interface&numexo=$exo&numuser=$numuser&num_cal=$num_cal&nomcal=$nomcal&action=edtCorrExoStag.php&mode=$mode&edition=$edition\">
		<span class=liensretour>".MSG_786."</span></A></TD>");

	if ($interface != "parcours")
		print ("<!--suppression de la correction-->
				<TD ALIGN=center><A HREF=\"$page?interface=$interface&numexo=$exo&numuser=$numuser&done=0&num_cal=$num_cal&action=delCorrExoStag.php&mode=$mode\" OnClick=\"return(Question('$WARN_36'));\">
				<span class=liensretour>".MSG_787."</span></A></TD>
				");

	print ("
			</TR>
		</TABLE>
		");

}
echo "<!--fin--showCorrExoStag.php-->\n";
?>
