<?php
/*
	This file is part of Astairs.

    Astairs is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    any later version.

    Astairs is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Astairs.  If not, see <http://www.gnu.org/licenses/>.

	Copyright (C) 2006, 2007, 2008, 2009 AFIDE
    
	Auteurs:

	Said Ladjani <sladjani@yahoo.fr>
	Remi Cocquet <remi.cocquet@gmail.com>

*/
                             
/**
      Crer une nouvelle filiere

      Ce script prsente un formulaire et son validateur pour la
      cration d'une nouvelle filiere.

      @param integer: $gestcours numero de la filiere
      @param integer: $pere numero de la filiere pere

      @package filiere
*/
$perm->check('ADD');

//---------------------------------------------------------------------------
//          SOUMISSION FORMULAIRE
//---------------------------------------------------------------------------
if(isset($subcours)){
    if(empty($crefiliere))
        $err=true;
    else{
        $err=false;
        $crefiliere=addslashes($crefiliere);
        if($pere==0||$pere=="NULL")
            $crefiliere=strtoupper($crefiliere);
        else
            $crefiliere=ucwords($crefiliere);
        
        //test du libelle
		$ok = is_filiere_libelle_ok($pere, $crefiliere);
		if ($ok != "t")$err = true;
		else{
			//insertion
			$ins=set_filiere(set_ams_libelle($crefiliere), $pere);
			if (!$ins=="t")$err = true;
		}
    }
	
	//redirection
    if(!$err){
		//ok     	
       	header("location:$lien_source?niv=$niv&gestcours=$gestcours&num_crefiliere=$ins&reload=1");
		include("$dbpath/pied_page.php");
		exit;
    }
    else{
    	//erreur
        unset($subcours);
        header("location:$lien_source?action_filiere=$action_filiere&niv=$niv&gestcours=$gestcours&err=$err&pere=$pere&crefiliere=$crefiliere");
		include("$dbpath/pied_page.php");
		exit;
    }
	include("$dbpath/pied_page.php");
    exit();
}

//---------------------------------------------------------------------------
//                          INITIATISATIONS
//---------------------------------------------------------------------------

//on recupere le niveau du pre
if(!empty($gestcours))
    $niv=get_filiere_niveau($gestcours);
else
    $niv=1;

//si le pere est la filiere courrante, c'est que l'on cree une sous filiere ($niv+1)
if($pere==$gestcours){
    $niv++;
}
//echo "niv=$niv et pere=$pere et gestcours=$gestcours<br>";
//---------------------------------------------------------------------------
//                              AFFICHAGE
//---------------------------------------------------------------------------

//messages d'erreurs
if(isset($err)){
	if($err)print("<span class=\"tableau_message\">$MSG_2192</span><br/>");
}

// Formulaire
print ("
<br>
<table class=\"tableau_normal\">
<form name=\"adcours\" methode=\"get\" action=\"$lien_source\">
");

print ("
<tr class=\"couleur1\">
<td align=\"center\">
    <b><!--Ou bien crer une nouvelle filire-->$MSG_2602 $niv :</b>
</td>
</tr>
<tr class=\"couleur2\">
<td align=\"center\">
    <!--<input type=\"text\" name=\"crefiliere\" size=\"30\" value=\"$crefiliere\">-->
	".get_gui_libelle_input('crefiliere',$crefiliere)."
</td>
</tr>
<tr class=\"couleur1\">
<td align=\"center\">
    <input type=hidden name=\"gestcours\" value=\"$gestcours\">
    <input type=hidden name=\"pere\" value=\"$pere\">
    <input type=hidden name=\"prec\" value=\"$prec\">
    <input type=hidden name=\"action_filiere\" value=\"$action_filiere\">
    <input type=hidden name=\"niv\" value=\"$niv\">
    <input type=submit name=\"subcours\" value=$FORM_6>
</td>
</tr>
</form>
</table>
<br><br>

");

?>
