<?php
/*
	This file is part of Astairs.

    Astairs is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    any later version.

    Astairs is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Astairs.  If not, see <http://www.gnu.org/licenses/>.

	Copyright (C) 2006, 2007, 2008, 2009 AFIDE
    
	Auteurs:

	Said Ladjani <sladjani@yahoo.fr>
	Remi Cocquet <remi.cocquet@gmail.com>

*/


/**
   Formulaire pour la modification du nom d'une filiere

   Le nouveau nom est format et l'on verifie qu'une filiere de
   meme niveau n'existe pas.
   En cas d'erreur un message d'erreur est affich et l'on reste
   sur le formulaire, sinon, on est redirig sur la page appelante.
   Contient la validation du formulaire, et renvoie au fichier filiere.php.

   @package filiere

*/
$perm->check('MOD');
//-----------------------------------------------
//             VALIDATION FORMULAIRE
//-----------------------------------------------
if (isset ($modifier)) {

	//test si libelle non vide
	if (empty ($new_nom)) {
		$err = true;
	} else {
		$err = false;
		//formatage
		$new_nom = addslashes($new_nom);
		if ($pere == 0 || $pere == "NULL")
			$new_nom = strtoupper($new_nom);
		else
			$new_nom = ucwords($new_nom);

		//test du libelle
		$ok = is_filiere_libelle_ok($pere, $new_nom);
		if ($ok != "t")$err = true;
		else{
			//mise a jour
			$ok = maj_filiere($gestcours, set_ams_libelle($new_nom), $pere);
			if (!$ok=="t")
				$err = true;
		}
	}
	unset ($modifier);
	//redirection
	if ($err) {
		echo "erreur";
		//erreur
		header("Location:$lien_source?action_filiere=modification&gestcours=$gestcours&niv=$niv&prec=$prec&err=$err&new_nom=$new_nom");
		include("$dbpath/pied_page.php");
		exit();
	} else {
		//ok
		header("Location:$lien_source?niv=$niv&gestcours=$gestcours&prec=$prec&reload=1&err=$err");
		include("$dbpath/pied_page.php");
		exit();
	}
	exit ();
}
//-----------------------------------------------
//              AFFICHAGE
//-----------------------------------------------
//messages d'erreurs
if (isset ($err)) {
	if(!$err)print("<span class=\"tableau_message\">$MSG_2193</span><br/>");
	else print("<span class=\"tableau_message\">$MSG_2192</span><br/>");
}
// recup info filiere
$res=get_filiere($gestcours);
$nomfiliere=pg_fetch_result($res,0,1);
print ("
<br>
<table class=\"tableau_normal\">
<form name=\"modif_nom_filiere\" action=\"$lien_source\" >
<tr class=\"couleur1\">
<td align=\"center\"><b>$MSG_606 :</b></td>
</tr>
<tr class=\"couleur2\">
<!--<td align=\"center\"><input type=\"text\" name=\"new_nom\" value=\"$new_nom\" size=\"50\"></td>-->
<!--<td align=\"center\"><input type=\"text\" name=\"new_nom\" value=\"$nomfiliere\" size=\"50\"></td>-->
<td>
".get_gui_libelle_input('new_nom',$nomfiliere)."
</td>
</tr>
<tr class=\"couleur1\">
<td align=\"center\">
    <input type=\"hidden\" name=\"niv\" value=\"$niv\">
    <input type=\"hidden\" name=\"prec\" value=\"$prec\">
    <input type=\"hidden\" name=\"pere\" value=\"$pere\">
    <input type=\"hidden\" name=\"gestcours\" value=\"$gestcours\">
    <input type=\"hidden\" name=\"nom\" value=\"$nomfiliere\">
    <input type=\"hidden\" name=\"action_filiere\" value=\"$action_filiere\">
    <input type=\"submit\" name=\"modifier\" value=\"$FORM_8\">
</td>
</tr>
</form>
</table>
<br><br>
");
?>