<?php
/*
	This file is part of Astairs.

    Astairs is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    any later version.

    Astairs is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Astairs.  If not, see <http://www.gnu.org/licenses/>.

	Copyright (C) 2006, 2007, 2008, 2009 AFIDE
    
	Auteurs:

	Said Ladjani <sladjani@yahoo.fr>
	Remi Cocquet <remi.cocquet@gmail.com>

*/

/**
 * Creation d'une formation.
 * Ce script permet la saisie du libell de la formation, le choix de ses dates de dbut et de fin,
 * le formateur,  la classe et le choix d'un modele de formation.
 * Si il n'y a pas de modele selectionn, le choix de la filiere, du parcours principal, de la langue par dfaut et des langues disponibles est propos.
 * Si un modele est choisi, ces informations sont extraites du modele.
 * Dans ce dernier cas, on associe les ressources du modele  la nouvelle formation
 * 
 * @package formation
 */

//-----------------------------------------------------------
//				INITIALISATIONS
//-----------------------------------------------------------
/*
$dbpath="../..";

require("$dbpath/dbpostgres.php");
require("$dbpath/lib/lib_formation.php");
include("./includes.php"); //inclusions des librairies du module
*/
//connecteDB();

//inclusions

$dbpath="../..";  //le dbpath sert  maintenir les inclusions  partir du $chemin_bo
include("$dbpath/en_tete.php"); //contient les traitements communs  l'ensemble du FrameWork Astairs
include("../en_tete_back.php"); //contient les traitements communs  l'ensemble du BackOffice Astairs

$perm->check('ADD');

include("./includes.php"); //inclusions des librairies du module


//les fichiers javascripts

$javascript_files=array();
$javascript_files["$dbpath/bo/formation/templates/script/"][]="javascript_formation.js";

messageDebugR("Fichier javascript chargs:",$javascript_files);	

$titre=MSG_2353;
	$styleCSS = "../style/".MY_STYLE."/ressourcesPedagogiques.css";


/*
$nompage="/formation/creation_formation.php";
$titre="$MSG_2353";
$styleCSS="../style/".MY_STYLE."/ressourcesPedagogiques.css";
$javascriptFILE="./javascript_formation.php";
*/



//---------------------------------------------------------------
// 			SOUMISSION FORMULAIRE
//---------------------------------------------------------------
//validation du libelle de la formation
if(isset($subcal)){
    if(!empty($nomcal)){
//        if(check_formation_nom($nomcal)){
//            unset($nomcal);
//            $mesg=$MSG_1439;    //"Ce nom existe dj !";
//        }
    }
    else{
    	unset($nomcal);
    	AstairsTemplate::setPageMessage(MSG_2158,MSG_ERROR) ;	
    }
}

// date deb et fin, groupe et formateur
// Note : on testera les conflits suivants :
//      date de formation pour le groupe et stagiaire
if(isset($subdate)){
	unset($mesg);
    if($jourdeb<10)
        $jourdeb=sprintf("0%d",$jourdeb);
    if($moisdeb<10)
        $moisdeb=sprintf("0%d",$moisdeb);
    if($jourfin<10)
        $jourfin=sprintf("0%d",$jourfin);
    if($moisfin<10)
        $moisfin=sprintf("0%d",$moisfin);

    //test la validit des dates
    $valdeb="$andeb"."$moisdeb"."$jourdeb";
    $valfin="$anfin"."$moisfin"."$jourfin";
    
    //dates de debut et fin compatibles, on continue les tests
    if($valfin>=$valdeb){
        if(!checkdate($moisdeb,$jourdeb,$andeb)){
            //$mesg.="$MSG_981<br>";     //La date de dbut est invalide
            $msg=1;
            AstairsTemplate::setPageMessage(MSG_981,MSG_ERROR) ;	
        }
        if(!checkdate($moisfin,$jourfin,$anfin)){
            $mesg.="$MSG_982<br>";     //La date de fin est invalide
            $msg=1;
            AstairsTemplate::setPageMessage(MSG_982,MSG_ERROR) ;	
        }
    }
    //dates incompatibles, on met la date de fin  la date de dbut
    else {
        $mesg=$MSG_2425;    //"Dates invalides !";
        $anfin=$andeb;
        $moisfin=$moisdeb;
        $jourfin=$jourdeb;
        $msg=1;
        AstairsTemplate::setPageMessage(MSG_2425,MSG_ERROR) ;	
    }
    
    //test sur les groupes
    if($groupe=="" || $groupe=="NULL"){
        //$mesg .=$MSG_1301;  //"Groupe absent !";
        $msg=1;
        AstairsTemplate::setPageMessage(MSG_1301,MSG_ERROR) ;	
    }
    
    // test si selection formateur
    if($formateur=="" || $formateur=="NULL"){
    	$msg=1;
    	 AstairsTemplate::setPageMessage(WARN_77,MSG_ERROR) ;		
    }
	
	// Cration  partir d'un modele de formation
	if(empty($msg) && !empty($formation_modele)){
		
		// recup infos formation modele et preparation donne pour la soumission finale
		$res_formation_modele=get_formation($formation_modele);
		
		// les langues de la formation modle
		$res_lang=get_formation_langues($formation_modele);
		$n=pg_num_rows($res_lang);
		for($i=0;$i<$n;$i++){
			$row=pg_fetch_row($res_lang);
			$lang[]=$row[0];
		}
		//la langue par defaut
		$lang_def=pg_fetch_result($res_formation_modele,0,5);
		
		// le parcours
		$parc=pg_fetch_result($res_formation_modele,0,2);
		

		//les ressources
		$res_ressource=get_formation_ressources($formation_modele);
		$nbres=pg_num_rows($res_ressource);
		
		$subfinal=true;
	}
}
//soumission finale
if(isset($subfinal)){
	// test si parcours selectionn
	if(!isset($parc) || empty($parc)){
		$msg=1;
		AstairsTemplate::setPageMessage(WARN_76,MSG_ERROR) ;	
	}
	else{

	//formatage des donnes
	//$nomcal=addslashes($nomcal);
	$date_debut=$andeb."-".$moisdeb."-".$jourdeb;
	$date_fin=$anfin."-".$moisfin."-".$jourfin;

	//insertion en base
		if(!isset($lang) || count($lang)==0)
			$lang=array();
		$formation=set_formation(set_ams_libelle($nomcal), $date_debut, $date_fin, $groupe, $formateur, $parc, $lang_def, $lang);
		if($formation){
			//$mesg.="La formation '$nomcal'  bien t cre.<br>Les droits par dfaut ont t attribus au formateur<br>";
			AstairsTemplate::setPageMessage(MSG_2727,MSG_CONFIRM) ;	
		}
		
	

	//INSERTION DES informations supplmentaires  inserer en cas de cration a partir d'un modele
	/*
	if(!empty($formation_modele)){
		
		//les langues, la langue par defaut et  le parcours sont deja copis
		
		//les ressources
		for($r=0;$r<$nbres;$r++){
			$row=pg_fetch_row($res_ressource,$r);
			set_formation_ressource($formation,$row[0],$row[1],$row[2],$date_debut,$date_fin,1,$row[7]);
		}
		$mesg.="$r ressources de formation ont t copies du modle<br>";
		
		// Gestion des ressources si creation  partir d'un modele de formation
		if(isset($formation_modele) && !empty($formation_modele)){
			$res_ressource=get_formation_ressources($formation_modele);
			$nbres=pg_num_rows($res_ressource);
			for($r=0;$r<$nbres;$r++){
				$row=pg_fetch_row($res_ressource,$r);
				set_formation_ressource($formation,$row[0],$row[1],$row[2],$date_debut,$date_fin,1,$row[7]);
			}
			
			// si le parcours modele est configur (ressource)
			$res_p=get_parcours_ressources_old($parc,$formation_modele);
			$nb=pg_num_rows($res_p);
			for($k=0;$k<$nb;$k++){
				$row=pg_fetch_row($res_p,$k);
				$row_etape=get_parcours_etape($parc,$row[4], 'R');
				set_parcours_ressource($formation,$rowp[1],$rowp[2],$rowp[3],$rowp[4],$tabparc[0],$rowp[6]);
			}
		}
	}
	*/
		header("location:../evenement/evenement.php?action_evenement=detail&num_cal=$formation&mesg=".urlencode($mesg));
		include("$dbpath/pied_page.php");
		exit();
	}
	
}

//---------------------------------------------------------------
// 						AFFICHAGE
//---------------------------------------------------------------
//SAISIE CALENDRIER
if(!isset($nomcal)){
	
 	include('../entete.php3');
 	
 	//MESSAGE
	if(isset($mesg)&&$mesg!=""){
	print("
	<table class=\"tableau_message\">
	    <tr>
	        <td><i>$mesg<i></td>
	    </tr>
	</table>
	<br>");
	}   
	
    print("
<form name=\"formform\" action=\"creation_formation.php\" method=\"POST\">
    <table class=\"tableau_espace\">
    	<tr class=\"couleur1\">
	    	<td><b>$MSG_635 :</b></td>
	   	 	<td><input type=\"text\" name=\"nomcal\" size=\"40\">
			<!--<td>".get_gui_libelle_input('nomcal',$nomcal)."-->
	    		<input type=\"submit\" name=\"subcal\" value=\"$FORM_6\"></td>
    	</tr>
	</table>
</form>");

}
//-----------------------------------------------------------------------------------------------------------------------
// 												SELECTION DEBUT ET FIN FORMATION, CLASSE ET FORMATEUR
//													OU CREATION A PARTIR D'UN MODELE
//-----------------------------------------------------------------------------------------------------------------------
else {
	
	//---------------------------------------------------------------
	// 						INITIALISATIONS
	//---------------------------------------------------------------

	//recup date
    $date=date("dmY");
    $jour_courant=substr("$date",0,2);
    $mois_courant=substr("$date",2,2);
    $an_courant=substr("$date",4,7);
    
    //recup du formateur par defaut
//    $resformdef=get_plateforme_formateur_defaut($logform,$pasform);
//    $rowformdef=pg_fetch_row($resformdef,0);
//    $numform_def=$rowformdef[0];
//    $nomform_def=$rowformdef[4];
//    $prenomform_def=$rowform[5];
	
	//recup des classes
	$resgp=get_plateforme_classes();
    $nbgp=pg_num_rows($resgp);
    
    //recup des formateurs
    //$resform=get_plateforme_individus(1, 'ASC', 'FALSE');
    $resform=get_plateforme_formateurs();
    $nbform=pg_num_rows($resform);
    
	// recup des formations
	$req=get_plateforme_formations();
	
	//---------------------------------------------------------------
	// 						AFFICHAGE
	//--------------------------------------------------------------    
	include('../entete.php3');
	
	//MESSAGE
	if(isset($mesg)&&$mesg!=""){
	print("
	<table class=\"tableau_message\">
	    <tr>
	        <td><i>$mesg<i></td>
	    </tr>
	</table>
	<br>");
	}

    print("
	<table class=\"tableau_espace2\">
		<tr class=\"couleur1\">
			<td><b>$MSG_635 :</b></td>
			<td colspan=\"2\"><b><i>$nomcal</i></b></td>
		</tr>");
		
    //DATE DEBUT DE LA FORMATION
    print("
    <form name=\"formform2\" action=\"creation_formation.php\" method=\"POST\">
    	<tr class=\"couleur2\">
    		<td>$MSG_135&nbsp;&nbsp;");
    		
	$jma_select_jour_name="jourdeb";
	if(empty($jourdeb))
	$jma_select_jour_value=$jour_courant;	
	else $jma_select_jour_value=$jourdeb;			
	$jma_select_mois_name="moisdeb";
	if(empty($moisdeb))
	$jma_select_mois_value=$mois_courant;	
	else $jma_select_mois_value=$moisdeb;	
	$jma_select_annee_name="andeb";
	if(empty($andeb))
	$jma_select_annee_value=$an_courant;	
	else $jma_select_annee_value=$andeb;
	
	$jma_select_annee_min=$an_courant;
	$jma_select_annee_max=$an_courant+20;
	$jma_columns=false;
	include("$root/lib_graphique/selects/selectJMA.php");
			
	//DATE FIN DE LA FORMATION
	print("
			<BR>$MSG_136&nbsp;&nbsp;");
				    
	$jma_select_jour_name="jourfin";
	$jma_select_jour_value=$jour_courant;			
	$jma_select_mois_name="moisfin";
	$jma_select_mois_value=$mois_courant;
	$jma_select_annee_name="anfin";
	$jma_select_annee_value=$an_courant;
	
	$jma_select_jour_name="jourfin";
	if(empty($jourfin))
	$jma_select_jour_value=$jour_courant;	
	else $jma_select_jour_value=$jourfin;			
	$jma_select_mois_name="moisfin";
	if(empty($moisfin))
	$jma_select_mois_value=$mois_courant;	
	else $jma_select_mois_value=$moisfin;	
	$jma_select_annee_name="anfin";
	if(empty($anfin))
	$jma_select_annee_value=$an_courant;	
	else $jma_select_annee_value=$anfin;
	
	$jma_select_annee_min=$an_courant;
	$jma_select_annee_max=$an_courant+20;
	$jma_columns=false;
	include("$root/lib_graphique/selects/selectJMA.php");

	//SELECTION DE LA CLASSE VIRTUELLE  
    print("
			<td align=\"center\"><b>$MSG_682 :</b><br>
	");
	$resgp=get_classe_peres_fils();
    $nbgp=pg_num_rows($resgp);
    $name="groupe";
    $onchange="";	
	include("$root/lib_graphique/selects/selectArborescenceGroupe.php");
				
	print("
			</select>
			</td>
	");
    
	//SELECTION DU FORMATEUR  
    print("
			<td align=\"center\"><b>$MSG_17 :</b><br>
				<select name=\"formateur\">
					<option value=\"$numform_def\">".MSG_217."</option>");
    for($f=0;$f<$nbform;$f++){
        $rowform=pg_fetch_row($resform,$f);
        if($rowform[0]==$formateur)$selected="selected";
        else $selected="";
		print("
					<option value=\"$rowform[0]\" $selected>$rowform[1] $rowform[2]</option>");
    }
    print("
				</select>
			</td>
		</tr>");
		
		
	/*
	//SELECTION MODELE DE FORMATION	
	print("
		<tr class=\"couleur2\">
			<td colspan=\"3\" align=\"center\"><b>$MSG_1717</b> : 
				<select name=\"formation_modele\">
					<option value=\"\">$MSG_217</option>");

	if(($nb=pg_num_rows($req))>0){
		for($i=0 ; $i < $nb ; $i++){
			$row=pg_fetch_row($req,$i) ;
			$tmp_form=get_ams_libelles($row[1]);
			$row[1]=get_ams_libelle($tmp_form);
			print("
					<option value=\"$row[0]\">$row[1]</option>");
		}
	}
    print("
				</select>
			</td>
		</tr>");
	*/
	
	//VARIABLES DU FORMULAIRE	
	print("
			<input type=\"hidden\" name=\"nomcal\" value=\"$nomcal\">");

	//BOUTONS SOUMISSION
	print("
			<tr class=\"couleur1\">
				<td colspan=\"3\" align=\"center\">");
    if(empty($msg)&&empty($subdate))
        print("
        		<input type=\"submit\" name=\"subdate\" value=\"$FORM_6\">");
    else
        print("
        		<input type=\"submit\" name=\"subdate\" value=\"$FORM_8\">");
    print("
			</td>
		</tr>");
	
	//-----------------------------------------------------------------------------------------------------------------------
	// 												SELECTION DE LA FILIERE
	//-----------------------------------------------------------------------------------------------------------------------
    if((!empty($subdate) && empty($msg))||!empty($cours)){

		//---------------------------------------------------------------
		// 						INITIALISATIONS
		//---------------------------------------------------------------


        //recup des filires ayant des parcours
        $rescours=get_plateforme_filieres_parcours();
        $nbcours=pg_num_rows($rescours);
		

        
        //---------------------------------------------------------------
		// 						AFFICHAGE
		//-------------------------------------------------------------- 
		$name="cours";
		$onchange="javascript:document.formform2.submit();";
		print("
				<tr  class=\"couleur2\">
				<td align=\"center\" valign=\"top\"><b>$MSG_2388 :</b><br><br>
		");
		include("$root/lib_graphique/selects/selectArborescenceFiliere.php");		
    	print("
				</select>");
		
		//variables du formulaire			
        print("
		<input type=\"hidden\" name=\"subdate\" value=\"$subdate\">");
	
		//-----------------------------------------------------------------------------------------------------------------------
		// 												SELECTION DU PARCOURS ET DES LANGUES
		//-----------------------------------------------------------------------------------------------------------------------
        if(!empty($cours)&&$cours!='NULL'){
			//---------------------------------------------------------------
			// 						INITIALISATIONS
			//---------------------------------------------------------------
            
            //recup des parcours associs  la filiere selectionn
            $resparc=get_filiere_parcourss($cours);
            $nbparc=pg_num_rows($resparc);
            
            //langue par defaut
            $def_lang=MY_LANG;
            //$tablang=get_plateforme_langues_disponibles();
            $tablang=get_langues_installees();
            $nb_langues=count($tablang);
        	//---------------------------------------------------------------
			// 						AFFICHAGE
			//--------------------------------------------------------------            
            
            //PARCOURS
            print("
            <td align=\"left\" valign=\"top\">
            	<b><center>$MSG_727 :</b></center><br>
            ");
            if($nbparc!=0){
                for($p=0;$p<$nbparc;$p++){
                    $rowparc=pg_fetch_row($resparc,$p);
                    $tmp_parcours=get_ams_libelles($rowparc[1]);
        			$rowparc[1]=get_ams_libelle($tmp_parcours,50);
                    if($parc==$rowparc[0])$checked="checked";
                    else $checked="";
                    print("
                    <input type=\"radio\" name=\"parc\" value=\"$rowparc[0]\" $checked>&nbsp;$rowparc[1]<br>");
                }
            }
            else{
                print("<br><i>$ERROR_15</i>");
                
            }
            print("
            </td>");
            
			//LANGUES           
            print("
            <td align=\"left\" valign=\"top\">
            	<b><center>$MSG_969 :</center></b><br>");

			//langue par defaut	
        	print("
            	<b>$MSG_967 : </b>
				<input type=\"hidden\" name=\"old_lang_def\" value=\"$def_lang\"/>
            	<select name=\"lang_def\" onChange=\"javascript:selectLangueDispoDefaut(this.value);\">");
            
            		for($i=0;$i<$nb_langues;$i++){
                    	if($def_lang==$tablang[$i][2])$selected="selected";
                    	else $selected="";
						
						print("
					<option value=\"".$tablang[$i][0]."\" $selected>");
					eval("echo \"".$tablang[$i][1]."\";");
					print("</option>");
            		}
           
            print("
				</select>");
			
			//langues disponibles pour le front-office 	
			print("	
				<br><br>
            	<b>$MSG_968 :</b>
				<br><br>");
			
            for($l=0;$l<$nb_langues;$l++){
            	if($def_lang==$tablang[$l][2]||$lang[$l]==$tablang[$l][0])$checked="checked";
                else $checked="";
						
				print("
					<input type=\"checkbox\" name=\"lang[$l]\" value=\"".$tablang[$l][0]."\" $checked>");
					eval("echo \"".$tablang[$l][1]."\";");
					print("<br>");
            }		

			print("
			</td>
		</tr>");
		
		//variables du formulaire
		print("
            <input type=\"hidden\" name=\"nomcal\" value=\"$nomcal\">
            <input type=\"hidden\" name=\"subdate\" value=\"$subdate\">
			<input type=\"hidden\" name=\"nb_langues\" value=\"$nb_langues\">");
            
        print("
			<tr class=\"couleur1\">
				<td colspan=\"3\" align=\"center\">
					<input type=\"submit\" name=\"subfinal\" value=\"$MSG_978\">
				</td>
			</tr>
		</form>");
        }
        else //filiere non selectionnee
            print("
				<td>&nbsp;</td>
				<td>&nbsp;</td>
			</tr>");
    }
}
print("
</table>
<br>
");
//GESTION DU LIEN RETOUR
//if(!empty($nomcal)){
//    unset($nomcal);
//    print("
//<a class=\"retour\" href=\"creation_formation.php\">$MSG_37</a>");
//}
//else{
//	/*
//	print("
//<a class=\"retour\" href=\"../menu_principal.php\">$MSG_37</a>");
//*/
//print("
//<a class=\"retour\" href=\"../module_menu/module_menu.php\">$MSG_475</a>
//");
//}

//PIED PAGE

include('../piedpage.php3');
include("$dbpath/pied_page.php");
?>