<?php
/*
	This file is part of Astairs.

    Astairs is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    any later version.

    Astairs is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Astairs.  If not, see <http://www.gnu.org/licenses/>.

	Copyright (C) 2006, 2007, 2008, 2009 AFIDE
    
	Auteurs:

	Said Ladjani <sladjani@yahoo.fr>
	Remi Cocquet <remi.cocquet@gmail.com>

*/

/**
	Association formation ressource
	@package ressource
*/

//-------------------------------------------------------------
// javascript pour la g�n�ration automatique des menus d�roulants
// selections themes et glossaire
//--------------------------------------------------------------  
function themes_glossaire_javascript(){
	print ("<SCRIPT LANGUAGE=\"JavaScript\"><!--\n");	
	// recup des themes de glossaire
	$restheme_glossaire=get_plateforme_themes_ressource_glossaire();
	$nb_theme_glossaire=pg_num_rows($restheme_glossaire);
	print ("var tab_theme_glossaire = new Array();\n");
	for($i=0;$i<$nb_theme_glossaire;$i++){
		print ("tab_theme_glossaire[$i] = new Array();\n");
		$row_theme_glossaire=pg_fetch_row($restheme_glossaire,$i);
		// recup des glossaire pour le theme courant
		$res_glossaire=get_theme_glossaires($row_theme_glossaire[0]);	
		$nb_glossaire=pg_num_rows($res_glossaire);
		for($j=0;$j<$nb_glossaire;$j++){
			print ("tab_theme_glossaire[$i][$j] = new Array(");	
			$row_glossaire=pg_fetch_row($res_glossaire,$j);
			$tmp_glossaire=get_ams_libelles($row_glossaire[1]);
			$row_glossaire[1]=get_ams_libelle($tmp_glossaire,50);
			print ("\"$row_glossaire[0]\", \"$row_glossaire[1]\");\n");
		}
	}
	print("

//-->
</SCRIPT>
");
}
 

//-------------------------------------------------------------
//	Initialisation
//-------------------------------------------------------------

// recup info formation
$resformation=get_formation($num_cal);
$libelle_formation=pg_fetch_result($resformation,0,1);
$datedebut=pg_fetch_result($resformation,0,3);
$datefin=pg_fetch_result($resformation,0,4);
list($anneedebut,$moisdebut,$jourdebut) = explode('-',$datedebut);
list($anneefin,$moisfin, $jourfin) = explode('-',$datefin);



/*---------------------------------------------------------------------------------------
	Formulaire type de ressource (fichier,texte,scenario et scenario dynamique)
----------------------------------------------------------------------------------------*/
// Peut �tre ecrire une fonction de recup�ration des types de ressources (A suivre....)
// TODO  
//Ajouter le type glossaire 
$tabtype=array("1"=>MSG_2607,"7"=>MSG_2608,"26"=>MSG_2609,"59"=>MSG_2626,"66"=>MSG_2728);
print("
<br/>
<table class=\"tableau_normal\">
<caption>".MSG_2532." (<i>".get_gui_libelle($libelle_formation,false)."</i>)</caption>
<form name=\"formtype\" method=\"POST\">
<tr class=\"couleur1\">
<td><b>".MSG_608."</b></td>
<td>
<select name=\"type\" onchange=\"validetype();valide_section()\">
<option value=\"\">".MSG_217."</option>
");
while(list($numtype,$libelle_type)=each($tabtype)){
	if($type==$numtype)
		print("
		<option value=\"$numtype\" selected>$libelle_type</option>
		");
	else
		print("
		<option value=\"$numtype\">$libelle_type</option>
		");
}
print("
</select></td></tr>
<input type=hidden name=\"num_cal\" value=\"$num_cal\">
<input type=hidden name=\"theme\" value=\"$theme\">
</form>
");


/*---------------------------------------------------------------------------------------
	Formulaire th�me
----------------------------------------------------------------------------------------*/

print("
<form name=\"formtheme\" method=\"POST\">
<tr class=\"couleur2\">
<td><b>".MSG_117."</b></td>
<td>
<select name=\"theme\" onchange=\"validetheme()\">>
<option value=\"\">".MSG_217."</option>
");
// recup des themes des ressource pour le type
if(isset($type) && !empty($type)){
	switch($type){
		case 1 : $restheme=get_plateforme_themes_ressource_scenario();
		break;
		case 7 : $restheme=get_plateforme_themes_ressource_fichier();
		break;
		case 26 : $restheme=get_plateforme_themes_ressource_texte();
		break;
		case 59 : $restheme=get_plateforme_themes_ressource_scenario_dynamique();
		break;
		case 66 : $restheme=get_plateforme_themes_ressource_glossaire();
		break;
		
	}
}
$nb_theme=0;
if($restheme)
	$nb_theme=pg_num_rows($restheme);
for($i=0;$i<$nb_theme;$i++){
	$rowtheme=pg_fetch_row($restheme,$i);
	$tmp_theme=get_ams_libelles($rowtheme[1]);
	$rowtheme[1]=get_ams_libelle($tmp_theme);
	if($theme==$rowtheme[0])
		print("
		<option value=\"$rowtheme[0]\" selected>$rowtheme[1]</option>
		");
	else
		print("
		<option value=\"$rowtheme[0]\">$rowtheme[1]</option>
		");
}
print("
</select></td></tr>
<input type=hidden name=\"num_cal\" value=\"$num_cal\">

<input type =hidden name=\"type\" value=\"$type\">
</form>
");
$nb_ressource=0;
//echo "theme=$theme et type=$type<br>";
if(isset($theme) && !empty($theme) && !empty($type)){
	// recup des ressources disponibles pour le theme et le type
	// TODO : recup des ressources dispo pour le theme,le type et la formation pour �viter les doublons(formation/fichier_ressource)  impossible ds la table formation_ressource
	switch($type){
		case 1 : $res_ressource=get_theme_ressources_scenario($theme);
		break;
		case 7 : $res_ressource=get_theme_ressources_fichier($theme);
		break;
		case 26 : $res_ressource=get_theme_ressources_texte($theme);
		break;
		case 59 : $res_ressource=get_theme_ressources_scenario_dynamique($theme);
		break;
		case 66 : $res_ressource=get_theme_ressources_glossaire($theme);
		break;
	}
	$nb_ressource=pg_num_rows($res_ressource);
		
}
/*-----------------------------------------------------------------------------------------
	Formulaire ressources en fonction du type et du theme
------------------------------------------------------------------------------------------*/

print("
<form name=\"formressource\" method=\"POST\">
<tr class=\"couleur1\">
<td><b>".MSG_2421."</b></td>
<td>
<select name=\"ressource\">
		<option value=\"\" selected>".MSG_217."</option>
");
for($i=0;$i<$nb_ressource;$i++){
	$row_ressource=pg_fetch_row($res_ressource,$i);
	// gestion ams
	$tmp_ressource=get_ams_libelles($row_ressource[1]);
	$row_ressource[1]=get_ams_libelle($tmp_ressource);
	if($row_ressource==$ressource)
		print("
		<option value=\"$row_ressource[0]\" selected>$row_ressource[1]</option>
		");
	else
		print("
		<option value=\"$row_ressource[0]\">$row_ressource[1]</option>
		");
}
print("
</select></td></tr>

");

/*--------------------------------------------------------------------------------------------------
	Formulaire (configuration dates,nouveat�,espace et section)
----------------------------------------------------------------------------------------------------*/

// debut et fin 
// compte le nombre de jour entre les deux dates
$nbjour = mktime(0,0,0,$moisfin, $jourfin, $anneefin) - mktime(0,0,0,$moisdebut, $jourdebut, $anneedebut);
$nbjour = ($nbjour / 24 / 60 / 60) + 1;
// Select de date d�but
$stringSelectDeb = "<select name=\"datedeb\">";
//On recup�re les dates
for($i=0;$i<$nbjour;$i++) {
	// calcule la date suivante
	$datenext = date ("d/m/Y", mktime (0,0,0,$moisdebut,$jourdebut+$i,$anneedebut));
	$datenextbase =  date ("Y-m-d", mktime (0,0,0,$moisdebut,$jourdebut+$i,$anneedebut));
	if($datenext==$datedebut_ressource)
		$texte_selected="selected";
	else
		$texte_selected="";
	$stringSelectDeb .= "<option value=\"$datenextbase \" $texte_selected>$datenext</option>";
}
$stringSelectDeb .="</select>";
// Select de date fin
$stringSelectFin = "<select name=\"datefin\">";
//On recup�re les dates sauf la derniere
for($i=0;$i<$nbjour;$i++) {
	// calcule la date suivante
	$datenext = date ("d/m/Y", mktime (0,0,0,$moisdebut,$jourdebut+$i,$anneedebut));
	$datenextbase =  date ("Y-m-d", mktime (0,0,0,$moisdebut,$jourdebut+$i,$anneedebut));
	if((!empty($datefin_ressource)&&$datenext==$datefin_ressource)||$i==$nbjour-1)
		$texte_selected="selected";
	else
		$texte_selected="";
	$stringSelectFin .= "<option value=\"$datenextbase\" $texte_selected>$datenext</option>";
}
$stringSelectFin .= "</select>"; 
print("
<tr class=\"couleur1\">
<td><b>".MSG_537." :</b></td>
<td>$stringSelectDeb</td>
</tr>
<tr class=\"couleur2\">
<td><b>".MSG_232." :</b></td>
<td>$stringSelectFin</td>
</tr>
<tr class=\"couleur1\">
<td><b>".MSG_137." :</b></td>
<td>
<select name=\"datenouv\">
");
for($i=1;$i<$nbjour+1;$i++) {
	if($nouveau==$i)
		$texte_selected="selected";
	else
		$texte_selected="";
	print "<option value=\"$i\" $texte_selected>$i ".MSG_138."</option>";
}
print ("
</select>
</td>
</tr>
");

// Si type == scenario dynamique => ajout radio pour g�n�ration automatique des mot cl�s en fonction du glossaire choisi
if($type==TYPE_CATEGORIE_FICHIER_SCENARIO_DYNAMIQUE){
	themes_glossaire_javascript();
print("
 <tr class=\"couleur1\">
    <td><b>Mot clefs</b></td>
    <td>
    &nbsp;&nbsp;<input type=radio name=\"auto_manuel\" value=\"1\" checked onClick=\"afficheform()\">".MSG_2732."</input>
    &nbsp;&nbsp;<input type=radio name=\"auto_manuel\" value=\"2\"  onClick=\"afficheform()\">".MSG_2733."</input>
    </td>
    </tr>
	<tr class=\"couleur2\"><td colspan=2>&nbsp;</td></tr>
");
}


// les mots cles
print("
<tr class=\"couleur1\">
	<td colspan=2><div id=\"div_fic1\">
	<table width=100%>
	<tr><td align=left><b>".MSG_143." :</b></td>
	<td align=left>
	<textarea name=\"motcle\" wrap=\"physical\" cols=\"40\" rows=\"2\">
");
	if(!empty($ressource))
		print("$mot_cle");
	else
		print("mot1;mot2");
	print("</textarea><br>".MSG_2400."
	</td>
	</tr>
	</table>
	</div></td>
</tr>
");
if($type==TYPE_CATEGORIE_FICHIER_SCENARIO_DYNAMIQUE){
print("
<tr class=\"couleur1\">
	<td colspan=2><div id=\"div_fic2\">
	<table width=100%>
	<caption>Choix du glossaire pour la generation automatique des mot clefs</caption>
	<tr><td align=left>".MSG_117."</td>
	<td><select name=\"theme_glossaire\" onChange=\"chargeGlossaire()\">
	<option value=\"\">selectionnez un theme</option>
	");
	$res_theme_glossaire=get_plateforme_themes_ressource_glossaire();
	$nb_theme_glossaire=pg_num_rows($res_theme_glossaire);
	for($i=0;$i<$nb_theme_glossaire;$i++){
		$row_theme_glossaire=pg_fetch_row($res_theme_glossaire,$i);
		$tmp_glossaire=get_ams_libelles($row_theme_glossaire[1]);
		$row_theme_glossaire[1]=get_ams_libelle($tmp_glossaire,50);
		print("<option value=\"$row_theme_glossaire[0]\">$row_theme_glossaire[1]</option>");
	}
	print("
	</select></td></tr>
	<tr><td align=left>".MSG_2728."</td>
	<td><select name=\"glossaire\">
	<option value=\"\">".MSG_2729."</option>
	</select></td></tr>
	</table>
	</div></td>
</tr>


");
}


// espace et section
print("
<tr class=\"couleur1\">
<td><b>".MSG_139." : </b></td>
<td><select name=\"numespace\">
");
//On recup�re les espaces
$resesp=get_espaces();
$nb_espace=pg_numrows($resesp);
for($i=0;$i<$nb_espace;$i++) {
	$rowesp=pg_fetch_row($resesp,$i);
	$tmp_espace=get_ams_libelles($rowesp[1]);
	$rowesp[1]=get_ams_libelle($tmp_espace);
	if ($id_espace==$rowesp[0]){
		$texte_selected=" selected";
	}
	else{
		$texte_selected="";
	}
	print "<option value=\"$rowesp[0]\"$texte_selected>$rowesp[1]</option>";
}
print ("
</select></td></tr>
<tr class=\"couleur2\">
<td><b>".MSG_141." : </b></td>
<td><select name=\"numsection\">
");
//On recup�re les sections
$ressec=get_sections();
$nb_sec=pg_num_rows($ressec);
for($i=0;$i<$nb_sec;$i++) {
	$rowsec=pg_fetch_row($ressec,$i);
	$tmp_section=get_ams_libelles($rowsec[1]);
	$rowsec[1]=get_ams_libelle($tmp_section);
	if ($id_section==$rowsec[0]){
		$texte_selected=" selected";
	}
	else{
		$texte_selected="";
	}
	print "<option value=\"$rowsec[0]\"$texte_selected>$rowsec[1]</option>";
}
print ("
</select></td></tr>
");
// submit
print("
<tr class=\"couleur1\">
<td colspan=\"2\" align=\"center\">
<input type=\"submit\" name=\"subassociation\" value=\"".FORM_6."\">
</td>
</tr>
");
// hidden
print("
<input type=hidden name=\"num_cal\" value=\"$num_cal\">
<input type=hidden name=\"theme\" value=\"$theme\">
<input type=hidden name=\"theme\" value=\"$theme\">


");
print("
</form>
</table>
");
print("<script language=\"javascript\">afficheform();</script>");
// retour

?>