<?php
/*
	This file is part of Astairs.

    Astairs is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    any later version.

    Astairs is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Astairs.  If not, see <http://www.gnu.org/licenses/>.

	Copyright (C) 2006, 2007, 2008, 2009 AFIDE
    
	Auteurs:

	Said Ladjani <sladjani@yahoo.fr>
	Remi Cocquet <remi.cocquet@gmail.com>

*/
 
/**
 * Cration d'un theme.
 * 
 * @package gestionnaire_contenus
 */
 
$perm->check('GEST,ADD');
$err = false;
$messtmp = "";
if ($nom == "") {
	$messtmp.= "$MSG_1937";
	$err = true;
} else {

	// On stocke les message d'erreur dans une variable
	ob_start();
	pg_query("begin");

	//INSERTION EN BASE
	$obj_theme = new Theme($nom);
	$id=$obj_theme->insertToDB();
	if( ( $id_rep == "NULL" ) ||  empty($id )  ){
		$messtmp.= "$MSG_1904";
		$err = true;
	} else {
		$messtmp.= "$MSG_1938 <b>".$obj_theme->getLibelle()."</b> $MSG_1939";

		//acces direct apres creation?	   
		if ($access) {
			$oid = "?obj_theme=".exportObject($obj_theme)."&niv=1";
		}
	}

	//CREATION DES REPERTOIRES
	if($err==false){
		// Rcupration du repertoire du theme
		$dir_theme = $racine.$obj_theme->getId();
		//creation
		if (file_exists($dir_theme) && is_dir($dir_theme)) {
			$messtmp.= " $MSG_1940 <br>";
			$err = true;
		} else {
			$err = !mkdir($dir_theme, 0775);
		}
	
		// Rcupration des categories qui sont des repertoires  creer dans le theme et cration
		$objs_categories = obj_get_plateforme_categories();
		$nb_objs_categories = count($objs_categories);
		
		for ($id_cat = 0; $id_cat < $nb_objs_categories; $id_cat ++) {
			$cur_obj_categorie = $objs_categories[$id_cat];
			$cur_dir = $dir_theme."/".$cur_obj_categorie->getId();
			if (file_exists($cur_dir) && is_dir($cur_dir)) {
				$messtmp.= " $MSG_1940 1<br>";
				$err = true;
			} else {
				$err = !mkdir($cur_dir, 0775);
			}
		}
	}
	//on recupere les messages d'erreur
	$message_erreur = ob_get_contents();

	//on vide les messages stockes
	ob_end_clean();

	//on commit ou non si l'upload c'est bien passe
	if (empty($message_erreur) && ($err == false)) {
		pg_query(" commit ");
	} else {
		pg_query(" rollback ");
		print("Operations de base de donnes annulees");
		$err = true;
	}
}


$messtmp.= $message_erreur."<br><br> <a href = \" index.php \">$MSG_1932</a>";
if ($err == false) {
	header("Location:index.php$oid");
	exit;
}
include ($hautpage);
echo "<br><br><table class=\"tableau_message\"><tr><td>";
echo "$messtmp";
echo "</td></tr></table>\n";

?>