<?PHP
/*
	This file is part of Astairs.

    Astairs is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    any later version.

    Astairs is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Astairs.  If not, see <http://www.gnu.org/licenses/>.

	Copyright (C) 2006, 2007, 2008, 2009 AFIDE
    
	Auteurs:

	Said Ladjani <sladjani@yahoo.fr>
	Remi Cocquet <remi.cocquet@gmail.com>

*/

/**
 * Supprime une liste de fichiers.
 * 
 * @param String $obj_theme: objet theme srialis.
 * @param String $obj_categorie: objet categorie srialis.
 * @param Array $check: tableau contenant les identifiants des fichiers.
 * @param String $racine : chemin racine du repertoire o sont stocks les contenus.
 * 
 * @package gestionnaire_contenus
 */
  $perm->check('DEL');
//INITIALISATIONS

//objets theme et categorie
$obj_theme = importObject($obj_theme);
$obj_categorie = importObject($obj_categorie);
//chemin du fichier
$destination = $racine.$obj_theme->getId()."/".$obj_categorie->getId()."/".$ams_langue;

//print_r($check);
$messtmp="";
//suppression d'un seul element: on cree une liste avec l'identifiant du fichier
if(empty($check)){
	$check[$fichier]=$lib_fic;
}
while (list ($fic, $val) = each($check)) {
	//fichier en base
	$db_fic_to_delete = get_fichier($fic);

	//libelle du fichier
	$lib_fic = pg_fetch_result($db_fic_to_delete, 0, 1);

	//on recupere l'extention du fichier
	$extention = get_fichier_extension($lib_fic);

	//chemin complet du fichier  supprimer
	$fichier_a_supprimer = "$destination/$fic.$extention";

	//SUPPRESSION DU FICHIER EN BASE

	// On stocke les message d'erreur dans une variable
	ob_start();
	pg_query("begin");

	//suppression en base
	$obj_categorie->delFichier($fic);

	//on recupere les messages d'erreur
	$message_erreur = ob_get_contents();

	//on vide les messages stockes
	ob_end_clean();

	//on commit ou non si l'upload c'est bien pass
	if (!empty ($message_erreur)) {
		die($message_erreur);
		pg_query("rollback");
		$err = true;
		$messtmp .= "Une erreur est survenue lors de la suppression du fichier <b>$lib_fic</b> : Il n'est probablement pas dconnt.<br>$message_erreur<br>";
	} else {

		//fichier classique uniquement
		if ($obj_categorie->getId() != 26) {
			//SUPPRESSION DU FICHIER DU DISQUE
			if (!file_exists($fichier_a_supprimer)) {
				$messtmp .= "Le fichier <b>$lib_fic</b> n'est plus prsent sur la plateforme.<br>";
				$err = false;
				pg_query("commit");
			}else{
				if (unlink($fichier_a_supprimer)) {
					$err = false;
					$messtmp .= "Le fichier <b>$lib_fic</b>  bien t supprim<br>";
					pg_query("commit");
				} else{
					$err = true;
					$messtmp .= "Erreur: Le fichier <b>$lib_fic</b> n' pu tre supprim<br>";
					pg_query("rollback");
				}
			}
		}
		//fichier scorm??
		elseif($obj_categorie->getId()==8){
			//on supprime aussi le repertoire du contenu du zip
			if (del_repertoire("$destination/$fic")) {
				$err = false;
				$messtmp .= "Le fichier <b>$lib_fic</b>  bien t supprim<br>";
				pg_query("commit");
			} else{
				$err = true;
				$messtmp .= "Erreur: Le fichier <b>$lib_fic</b> n' pu tre supprim<br>";
				pg_query("rollback");
			}
		}else {
			pg_query("commit");
			$messtmp .= "$MSG_2491 <b>$lib_fic</b>  bien t supprim<br>";
		}
	}
}
//AFFICHAGE
include ($hautpage);
echo "<center>\n";
$mime = $MSG_2000;
$what = $info_rep[0];
$lien_non = "";
$lien_oui = "&rep=$rep";

$messtmp .= "$message<br>";
$messtmp .= "$message<br>";
$messtmp .= "<br><br><a href=\"index.php?rep=$rep&niv=2&obj_theme=".exportObject($obj_theme,'content_manager_current_theme')."&obj_categorie=".exportObject($obj_categorie,'content_manager_current_categorie')."\">$MSG_1932</a>";

print ("<table class=\"tableau_message\">
	<tr>
			<td>
	$messtmp				
			<td>
			</tr>		
	</table>\n
	</center>\n");
?>