<?php
/*
	This file is part of Astairs.

    Astairs is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    any later version.

    Astairs is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Astairs.  If not, see <http://www.gnu.org/licenses/>.

	Copyright (C) 2006, 2007, 2008, 2009 AFIDE
    
	Auteurs:

	Said Ladjani <sladjani@yahoo.fr>
	Remi Cocquet <remi.cocquet@gmail.com>

*/

/**
 * Partager un Theme.
 * 
 * @param String $obj_theme: objet theme srialis.
 * @param String $obj_categorie: objet categorie srialis.
 * 
 * @package gestionnaire_contenus
 */
 $perm->check('GEST');
$obj_theme = importObject($obj_theme);

// On stocke les message d'erreur dans une variable
$err == false;
pg_query("begin");

if($sharing){
	$ok=$obj_theme->share();
	$msg=MSG_1938." ".get_gui_libelle($obj_theme->getLibelle(),false)." est maintenant public. Il est donc visible de tous.";
}else{
	$ok=$obj_theme->unshare();
	$msg=MSG_1938." ".get_gui_libelle($obj_theme->getLibelle(),false)." est maintenant priv. Il n'est donc visible que par vous.";
}
$msg_error="Erreur lors de la modification de l'accs au thme.";

//on commit ou non si l'upload c'est bien passe
if ($ok) {
	pg_query("commit");
	AstairsTemplate::setPageMessage($msg,MSG_CONFIRM);
} else {
	pg_query("rollback");
	AstairsTemplate::setPageMessage($msg_error,MSG_ERROR);
}
header("location:./index.php");
include("$dbpath/pied_page.php");
?>