<?php
/*
	This file is part of Astairs.

    Astairs is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    any later version.

    Astairs is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Astairs.  If not, see <http://www.gnu.org/licenses/>.

	Copyright (C) 2006, 2007, 2008, 2009 AFIDE
    
	Auteurs:

	Said Ladjani <sladjani@yahoo.fr>
	Remi Cocquet <remi.cocquet@gmail.com>

*/

/**
 * Validation du formulaire de copie de fichiers.
 * Ce script va creer une copie d'un fichier d'un theme  un autre.
 * Si le libelle du fichier existe dej, le libell est inserer avec "(x)" en suffixe, o
 * x est la valeur +1 du plus grand suffixe de libelle dej existant pour ce meme nom de fichier. (toto.txt , toto(1).txt , toto(2).txt, toto(4).txt...)
 * Si le fichier est une tape, l'etape est elle aussi mise a jour.
 * 
 * @param String $obj_theme: objet theme srialis.
 * @param String $obj_categorie: objet categorie srialis.
 * @param integer $dest: numero du theme de destination.
 * @param Array $check: tableau contenant les identifiants des fichiers.
 * 
 * @package gestionnaire_contenus
 */
$perm->check('ADD');
 
$obj_theme = importObject($obj_theme);
$obj_categorie = importObject($obj_categorie);

//theme de destination:
$obj_dest = new Theme($dest);

// recuperation des repertoires
$check = unserialize(urldecode($check));
print_rr($check);
//copie des fichiers
while ((list ($fic, $val) = each($check) )&&!$err) {
	// On stocke les message d'erreur dans une variable
	$err == false;
//	ob_start();
//	pg_query("begin");

	//modifie le nom du fichier si besoin
	echo "\$val=$val<br>";
	$userfile_name = $obj_categorie->getFichierUniqueName(addslashes($val), $obj_dest->getId());
	echo "\$userfile_name=$userfile_name<br>";
	//cree le lien en base
	$id_fic = $obj_categorie->setFichier($userfile_name, 'FALSE', $obj_dest->getId());

	//on recupere l'extention du fichier
	$extention = get_fichier_extension($userfile_name);

if( $obj_categorie->getId()!=TYPE_CATEGORIE_FICHIER_SCENARIO_DYNAMIQUE_BLOC && $obj_categorie->getId()!=TYPE_CATEGORIE_FICHIER_SCENARIO_DYNAMIQUE_SLIDE){
	$destination = $racine . $obj_dest->getId() . "/" . $obj_categorie->getId() . "/" .$ams_langue."/". $id_fic . "." . $extention;

	if(!is_dir($racine . $obj_dest->getId() . "/" . $obj_categorie->getId() )){
		mkdir($racine . $obj_dest->getId() . "/" . $obj_categorie->getId() );
	}	
	if(!is_dir($racine . $obj_dest->getId() . "/" . $obj_categorie->getId() . "/" .$ams_langue)){
		mkdir($racine . $obj_dest->getId() . "/" . $obj_categorie->getId() . "/" .$ams_langue);
	}
}
else{
	$destination = $racine . $obj_dest->getId() . "/" . $obj_categorie->getId() . "/". $id_fic . "." . $extention;

	if(!is_dir($racine . $obj_dest->getId() . "/" . $obj_categorie->getId() )){
		mkdir($racine . $obj_dest->getId() . "/" . $obj_categorie->getId() );
	}	
}

	$source = $racine . $obj_theme->getId() . "/" . $obj_categorie->getId() . "/" .$ams_langue."/". $fic . "." . $extention;
	echo "\$source=$source<br>";
	//on copie si le fichier existe
	if (file_exists($source)) {

		//copie le fichier
		if (!copy($source, $destination)) {
			$err = true;
		}

		//fichier scorm??
		if ($obj_categorie->getId() == 8) {
			if (!scorm_install($racine . $obj_dest->getId() . "/" . $obj_categorie->getId()."/".$ams_langue, "$id_fic." . $extention, $obj_dest->getId())) {
				$err = true;
			} 
		}

	} //s'il n'existe pas c'est un fichier texte (lien)
	else {
		
		$err=true;
		//modifie le nom du fichier si besoin
//		$userfile_name = $obj_categorie->getFichierTexteUniqueName($val, $obj_dest->getId());
//		$db_fichier = get_fichier_texte($fic);
//		$obj_fichier = pg_fetch_object($db_fichier, 0);
//		$id_fic = $obj_categorie->setFichierTexte($userfile_name, $obj_fichier->titre, $obj_fichier->lien, $obj_remibackfichier->description, $obj_fichier->mise_en_forme, $obj_fichier->connecte, $obj_dest->getId());
//		if(!$id_fic)$err = true;
	}

	//TRAITEMENT DES CATEGORIES D'ETAPES
	if ($obj_categorie->isEtape()) {

		//si la categorie est une ressource on spcifie la bonne table
		if($obj_categorie->isEtape()){
			$table_cible=$obj_categorie->getTableEtape();
		}
		
		//obtenir l'etape correspondant au fichier source et meme chose pour destination
		$etape_fichier_src = get_etapes_fichiers('_int4 \'{' . $fic . '}\'', $table_cible);
		$etape_fichier_dest = get_etapes_fichiers('_int4 \'{' . $id_fic . '}\'', $table_cible);

		$tab_fic = array ();
		$tab_fic[$etape_fichier_dest[$id_fic][0]] = $etape_fichier_src[$fic][1];
		maj_etapes_libelles($tab_fic, $table_cible);
	}
	//on recupere les messages d'erreur
//	$message_erreur = ob_get_contents();

	//on vide les messages stockes
//	ob_end_clean();

	//DEBUG
	/*print("Fichier source: $fic (etape: ".$etape_fichier_src[$fic][0]." libelle: ".$etape_fichier_src[$fic][1].")<br>" .
			" Nouveau fichier: $id_fic(etape: ".$etape_fichier_dest[$id_fic][0]." libelle: ".$etape_fichier_dest[$id_fic][1].")<br>");
	*/
	//on commit ou non si l'upload c'est bien passe
	if (empty ($message_erreur) && $err == false) {
//		pg_query("commit");
		if ($userfile_name != $val)
			$messtmp2 .= $val . " <b>-></b> " . $userfile_name . "<br>";
		else
			$messtmp1 .= $val . "<br>";
	} else {
//		pg_query("rollback");
	}

}
$messtmp = "<table class=\"tableau_message\"><tr><td><b>" . $MSG_2006 . "</b>" . $messtmp1 . "<br>";
$messtmp .= "<b>Les fichiers suivants ont ete renommes:</b><br>" . $messtmp2;
$messtmp .= "</td></tr></table><br>" . $message_erreur . "<br><a class=\"retour\" href=\"index.php?obj_theme=" . exportObject($obj_theme,'content_manager_current_theme') . "&obj_categorie=" . exportObjet($obj_categorie,'content_manager_current_categorie') . "&sens=$sens&ordre=$ordre&niv=2\">$MSG_1932</a>";

include ($hautpage);
echo "<br><br>";
echo "$messtmp";
echo "</center>\n";
include("../piedpage.php3");
include("$dbpath/pied_page.php");
exit;
?>