<?php
/*
	This file is part of Astairs.

    Astairs is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    any later version.

    Astairs is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Astairs.  If not, see <http://www.gnu.org/licenses/>.

	Copyright (C) 2006, 2007, 2008, 2009 AFIDE
    
	Auteurs:

	Said Ladjani <sladjani@yahoo.fr>
	Remi Cocquet <remi.cocquet@gmail.com>

*/

/**
 * Fichier d'upload pour inserer ou remplacer un fichier dans un theme et une categorie donnes.
 * 
 *	Le fichier est insere en base, on recupere l'identifiant, puis le fichier
 *	est enregistre sur la plateforme avec l'identifiant pour nom. L'extension
 *	du fichier est conserve.
 *	Le nom original du fichier est enregistr en base.
 *	
 * @param String $obj_theme: objet theme srialis.
 * @param String $obj_categorie: objet categorie srialis.
 * @param String $userfile_name: nom du fichier  uploader.
 * @param String $userfile : chemin du fichier a uploader
 * @param integer $idfile_to_replace : identifiant du fichier  remplacer.
 * @param String $ordre: (facultatif) pour conserver un odre de tris
 * @param String $sens: (facultatif) pour conserver un sens de tris
 * @param String $messtmp: message   afficher.
 * @param bool $autoconnect: pr-cocher la case de connection ou non.
 * 
 * @package gestionnaire_contenus
 */
//$NIVEAU_DEBUG=1;
//INITIALISATIONS
$obj_theme = importObject($obj_theme);
$obj_categorie = importObject($obj_categorie);

$messtmp = "";
$message = "";

//connection automatique?
if ($autoconnect) {
	$autoconnect_db = "TRUE";
} else {
	$autoconnect_db = "FALSE";
}

	if (!$err) {
		$destination = $racine.$obj_theme->getId()."/".$obj_categorie->getId()."/".$ams_langue;
		if(!is_dir($destination)){
			mkdir($destination);
		}
		// On stocke les message d'erreur dans une variable pour
		//faire un rollback en cas d'erreur de copie du fichier
		ob_start();
		pg_query("begin");

		//CREATION LIEN EN BASE
		//nouveau fichier
		if (empty ($idfile_to_replace)) {
			//modifie le nom du fichier si besoin
//			$userfile_name = $obj_categorie->getFichierUniqueName($userfile_name, $obj_theme->getId());
			$id_fic = $obj_categorie->setFichier($userfile_name, $autoconnect_db, $obj_theme->getId());
			$id_fic=$fichier;
		//remplacement
		} else {
			//modifie le nom du fichier si besoin
//			$userfile_name = $obj_categorie->getFichierUniqueName($userfile_name, $obj_theme->getId(), $idfile_to_replace);

//			$id_fic = $idfile_to_replace;
			$id_fic=$fichier;
			$db_fic_to_replace = get_fichier($id_fic);
			$obj_fic_to_replace = pg_fetch_object($db_fic_to_replace, 0);
			if (sql2Bool($obj_fic_to_replace->connecte)) {
				$con = true;
			} else {
				$con = false;
			}
			$obj_categorie->majFichier($obj_fic_to_replace->id, $userfile_name, $obj_fic_to_replace->type, bool2Sql($con));
		}

		//on recupere les messages d'erreur
		$message_erreur = ob_get_contents();
		//on vide les messages stockes
		ob_end_clean();
		
		//on copie le fichier si pas d'erreur de requete
		if (empty ($message_erreur)) {
			
			//remplacement
			if (!empty ($obj_fic_to_replace)) {
				//suppression de l'ancien fichier
				unlink($destination."/".$obj_fic_to_replace->id.".".get_fichier_extension($obj_fic_to_replace->libelle));
				
				//fichier scorm??
				if($obj_categorie->getId() ==8){
					//on supprime en plus le repertoire du contenu du zip
					del_repertoire("$destination/".$obj_fic_to_replace->id);
				}
			}
			//extension
			$extension=get_fichier_extension($userfile_name);
			
			//nouveau fichier
			$msg_upload=uploadFichier($userfile, $userfile_name, $userfile_size, $id_fic.".".$extension, $destination);	
			if (!empty($msg_upload)) {	
			//if (!(copy($userfile, "$destination/$id_fic.".$extension))) {
				//erreur copie
				$message_erreur .= $msg_upload;
				$err = true;
			} else {
				//copie ok
				if (empty ($idfile_to_replace)) { //nouveau fichier
					$message = "Le sous titre <b>$userfile_name</b> $MSG_1935 <b>".$obj_theme->getLibelle()."/".$obj_categorie->getLibelle()."</b>";
				} else { //remplacer
					$message = "Le sous titre <b>".$namefile_to_replace."</b>  t remplac par le fichier <b>$userfile_name</b>";
				}

				$err = false;

			}
		}
		//on recupere de nouveau les messages d'erreur
		//$message_erreur = ob_get_contents();
		
		//on vide les messages stockes
		//ob_end_clean();

		//on commit ou non si la copie du fichier s'est bien pass
		if (empty ($message_erreur) && $err == false) {
			pg_query("commit");
		} else {
			pg_query("rollback");
			$err = true;
		}
	}


$messtmp .= "$message<br>".$message_erreur;

//affiche erreur au debut du message si besoin
if ($err) {
	$messtmp = $ERROR_0." : ".$messtmp;
}else{
	$messtmp=$message;
}
//echo $messtmp;
// Le message sera affiche la ou on a fait l'upload
$messtmp = htmlentities(urlencode($messtmp));

header("Location:index.php?gestionnaire_cont=FALSE&action=default&obj_theme=".exportObject($obj_theme,'content_manager_current_theme')."&obj_categorie=".exportObject($obj_categorie,'content_manager_current_categorie')."&niv=2&ordre=$ordre&sens=$sens&&messtmp=$messtmp&autoconnect=$autoconnect&oldfic=$namefile_to_replace");
include("$dbpath/pied_page.php");
exit();
?>