<?php
/*
	This file is part of Astairs.

    Astairs is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    any later version.

    Astairs is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Astairs.  If not, see <http://www.gnu.org/licenses/>.

	Copyright (C) 2006, 2007, 2008, 2009 AFIDE
    
	Auteurs:

	Said Ladjani <sladjani@yahoo.fr>
	Remi Cocquet <remi.cocquet@gmail.com>

*/

/**
    Gestion grille
    @package grille
*/
// pour test en schma contraintes
//define("VERSION","7.0.0");
//------------------------------------------------------------------
//          IDENTIFICATION
//------------------------------------------------------------------
//inclusions
$dbpath="../..";  //le dbpath sert  maintenir les inclusions  partir du $chemin_bo
include("$dbpath/en_tete.php"); //contient les traitements communs  l'ensemble du FrameWork Astairs
include("../en_tete_back.php"); //contient les traitements communs  l'ensemble du BackOffice Astairs

//$db=pg_connect("$server","","","","$nombase") or die("$ERROR_89");
require("$root/lib/lib_grille.php");
//include('./fonctions_grille.inc.php3');

//------------------------------------------------------------------
//  SOUMISSION DES FORMULAIRES (CREATION)
//------------------------------------------------------------------
include('./soumission_formulaires.php');

//------------------------------------------------------------------
//          AFFICHAGE ENTETE (Fonction)
//------------------------------------------------------------------
function entete($grille, $prec, $nomgrille, $nompage, $titre, $page_precedente, $reload=1) {

    global $MSG_9, $MSG_10, $MSG_11, $MSG_12, $MSG_13, $MSG_14, $ERROR_5 , $WARN_9, $WARN_21;
    global $chemin_bo;
    global $s_numcal;
    global $site_heberge;
    global $s_admin;
    global $s_serverback;
    global $serverback;
    global $IP;
	 //pour rafraichir la frame de gauche
    if($reload==1)
        $fonctionONLOAD="reloadMenu()";

    $path = "..";
    $javascriptFILE = "./javascript_grille.php";
    $styleCSS = "../style/".MY_STYLE."/ressourcesPedagogiques.css";
    include ('../entete.php3');
}

//------------------------------------------------------------------
//          TRAITEMENT ACTION SUR GRILLE
//------------------------------------------------------------------
switch($action_grille){
    // creation d'un libelle grille, titre de capacite ou capacite
    case "ajout_nom" :
        switch($nom){
            case "grille" :
                $titre=$MSG_222;
            break;
            case "titrecapacite" :
                $titre=$MSG_503;
            break;
            case "capacite" :
                $titre=$MSG_505;
            break;
        }
        if(!isset($subnom)){
            entete($grille, $prec, $nomgrille, $nompage, $titre, $page_precedente, 0);
            //include("$chemin_bo/lib_graphique/tables/infoBox.php");
        }
        // choix du theme
        if(!isset($numtheme)){
            include("./selectTheme.php");

        }
        else
            include("./ajout_modification_nom.php");
        //print("<br><a class=\"retour\" href=\"./grille.php\">$MSG_37</a>");
    break;
    // modification d'un libelle grille, titre de capacite ou capacite
    case "modification_nom" :
        switch($nom){
            case "grille" :
                $titre=$MSG_1140;
            break;
            case "titrecapacite" :
                $titre=$MSG_1142;
            break;
            case "capacite" :
                $titre=$MSG_1141;
            break;
        }
        if(!isset($subnom)){
            entete($grille, $prec, $nomgrille, $nompage, $titre, $page_precedente, 0);
            //include("$chemin_bo/lib_graphique/tables/infoBox.php");
        }
       include("./ajout_modification_nom.php");
        //print("<br><a class=\"retour\" href=\"./grille.php\">$MSG_37</a>");
    break;
    // Liste des libelles grille, titre de capacite ou capacite
    case "lister_nom" :
        switch($nom){
            case "grille" :
                $titre=$MSG_444;
            break;
            case "titrecapacite" :
                $titre=$MSG_502;
            break;
            case "capacite" :
                $titre=$MSG_442;
            break;
        }
        entete($grille, $prec, $nomgrille, $nompage, $titre, $page_precedente, 0);
        //include("$chemin_bo/lib_graphique/tables/infoBox.php");
        include("./selectTheme.php");
        if(isset($numtheme))
            include("./lstNom.php");
        //print("<br><a class=\"retour\" href=\"./grille.php\">$MSG_37</a>");
    break;
    // Suppression d'un libelle grille, titre de capacite ou capacite
    case "suppression_nom" :
        include("./suppression_nom.php");
    break;
    // Suppression d'une grille (association [grille / titres de capacite]) ou d'un titre de capacite (association [titre de capacite / capacites])
    case "remove_nom" :
        include('./remove_nom.php');
    break;
    // Cration d'une grille (association [grille / titres de capacite] [titre de capacite / capacites])
    case "creation_modification_grille" :
        $titre=$MSG_483;
        entete($grille, $prec, $nomgrille, $nompage, $titre, $page_precedente, 0);
        //include("$chemin_bo/lib_graphique/tables/infoBox.php");
         // choix du theme
        if(!isset($numtheme)){        	
            include("./selectTheme.php");
        }
        else{
        	include('./creation_modification_grille.php');
        }
        //print("<br><a class=\"retour\" href=\"./grille.php\">$MSG_37</a>");

    break;
    // Cration d'un titre de capacite (association [titre de capacite / capacites])
    case "creation_modification_titrecapacite" :
         $titre=$MSG_213;
        entete($grille, $prec, $nomgrille, $nompage, $titre, $page_precedente, 0);
        //include("$chemin_bo/lib_graphique/tables/infoBox.php");
        // choix du theme
        if(!isset($numtheme)){
            include('./selectTheme.php');
        }
        else{

        include('./creation_modification_titrecapacite.php');
        }
        //print("<br><a class=\"retour\" href=\"./grille.php\">$MSG_37</a>");

    break;
    // Lister les grilles (association [grille / titres de capacite] [titre de capacite / capacites])
    case "lister_grille" :
        $titre=$MSG_477;
        entete($grille, $prec, $nomgrille, $nompage, $titre, $page_precedente, 0);
        //include("$chemin_bo/lib_graphique/tables/infoBox.php");
		$nom='grille_titrecapacites';
        include('./selectTheme.php');
        if(isset($numtheme))
            include('./lstGrille.php');
        //print("<br><a class=\"retour\" href=\"./grille.php\">$MSG_37</a>");

    break;
    // Lister les titres de capacite (association [titre de capacite / capacites])
    case "lister_titrecapacite" :
        $titre=$MSG_2352;
        entete($grille, $prec, $nomgrille, $nompage, $titre, $page_precedente, 0);
        //include("$chemin_bo/lib_graphique/tables/infoBox.php");
		$nom='titrecapacite_capacites';
        include('./selectTheme.php');
        if(isset($numtheme))
            include('./lstTitrecapacite.php');
        //print("<br><a class=\"retour\" href=\"./grille.php\">$MSG_37</a>");
    break;
    // Retirer un titre de capacite d'une grille ou un capacite d'un titre de capacite
    case "retirer_element" :
        include('./retire_element.php');
    break;
    // Ajoute un titre de capacite  une grille ou une capacite  un titre de capacite
    case "ajout_capacite" :
         $titre="Ajouter une capacit  un titre";
         //$ret="grille.php?action_grille=$page_retour&numtheme=$numtheme";


         entete($grille, $prec, $nomgrille, $nompage, $titre, $page_precedente, 0);
         //include("$chemin_bo/lib_graphique/tables/infoBox.php");
        include('./ajout_capacite.php');
         //print("<br><a class=\"retour\" href=\"./$ret\">$MSG_37</a>");
    break;

    default :
        header("Location:".$obj_module->getReturnPage($dbpath));
}
print("
<a class=\"retour\" href=\"../module_menu/module_menu.php\">$MSG_37</a>
");
include('../piedpage.php3');
include("$dbpath/pied_page.php");
                    

?>