<?php
/*
	This file is part of Astairs.

    Astairs is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    any later version.

    Astairs is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Astairs.  If not, see <http://www.gnu.org/licenses/>.

	Copyright (C) 2006, 2007, 2008, 2009 AFIDE
    
	Auteurs:

	Said Ladjani <sladjani@yahoo.fr>
	Remi Cocquet <remi.cocquet@gmail.com>

*/
    
/**
    Liste des libelles grille,titrecapacite et capacite
    @package grille
*/

/*------------------------------------------------------------*/
//                  INITIALISATION
/*------------------------------------------------------------*/
switch($nom){
    case "grille" :
        // recup des grilles pour le theme selectionn
        $res=get_theme_grilles($numtheme);
        $entite="Grille";
        $msg_nombre=$MSG_480;
        $msg_add=$MSG_437;
        $msg_alert=$WARN_39;
        $nom_nom=$MSG_226;
    break;
    case "titrecapacite" :
        // recup des titres de capacit pour le theme selectionn
        $res=get_theme_titrecapacites($numtheme);
        $entite="Titrecapacite";
        $msg_nombre=$MSG_485;
        $msg_add=$MSG_441;
        $msg_alert=$WARN_68;
        $nom_nom=$MSG_219;
    break;
    case "capacite" :
        // recup des capacits pour le theme selectionn
        //$res=get_libelle_capacites($numtheme);
		$res=get_theme_capacites($numtheme);
        $entite="Capacite";
        $msg_nombre=$MSG_2340;
        $msg_add=$MSG_443;
        $msg_alert=$WARN_40;
        $nom_nom=$MSG_220;
    break;
}
$nb=pg_numrows($res);

/*------------------------------------------------------------*/
//                  AFFICHAGE
/*------------------------------------------------------------*/
print ("
<table class=\"tableau_message\"><tr><td>
<a href=\"./grille.php?action_grille=ajout_nom&nom=$nom&numtheme=$numtheme\">$msg_add</a></td></tr></table>
<br><br>$msg_nombre  : <b>$nb</b>
");
if($nb == 0)
    print "<br><b>$ERROR_33</b><br>";
else {
    print("
    <br><br>
    <table class=\"tableau_espace\">
        <tr>
            <th>$nom_nom</th>
            <th>$FORM_1</th>
        </tr>
    ");
    for($i=0;$i<$nb;$i++){
        $row=pg_fetch_row($res,$i);

        $classcolor=($i%2==0||$i==0?"couleur1":"couleur2");
        print("
        <tr class=\"$classcolor\">
            <td>".get_gui_libelle($row[1],true)."</td>
            <td align=\"center\">
                <a class=\"action\" href=\"./grille.php?action_grille=modification_nom&nom=$nom&num_entite=$row[0]&numtheme=$numtheme\">$FORM_2</a>
                ");
                // test si supprimable
                if(supprimable_libelle($nom,$row[0]))
                    print("
                    <br>
                    <a class=\"action\" href=\"./grille.php?action_grille=suppression_nom&nom=$nom&num_entite=$row[0]&numtheme=$numtheme\" OnClick=\"return(Question('$msg_alert'))\">$FORM_4</a>
                    ");
                    print("
            </td>
        </tr>");
    }
    print "</table><br>";

}


?>