<?php
/*
	This file is part of Astairs.

    Astairs is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    any later version.

    Astairs is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Astairs.  If not, see <http://www.gnu.org/licenses/>.

	Copyright (C) 2006, 2007, 2008, 2009 AFIDE
    
	Auteurs:

	Said Ladjani <sladjani@yahoo.fr>
	Remi Cocquet <remi.cocquet@gmail.com>

*/

/**
* Import / Export
* @package import_export
*/

//------------------------------------------------------------------
//          IDENTIFICATION
//------------------------------------------------------------------
include('../dbpostgres.php3');
require_once ("$chemin_bo/lib/obj_question.php");
require_once ("$chemin_bo/lib/obj_reponse.php");
require_once ("$chemin_bo/lib/obj_qcm.php");
require("$chemin_bo/lib/lib_front_office.php");
require("$chemin_bo/lib/lib_import_export.php");


connecteDB();
pg_query("begin");

//----------------------------------------------------
//				IMPORT
//----------------------------------------------------
//Cration de l'ImportFile
$currentImportFile=ImportFileCsvFactory::create(TYPE_EVALUATION_QCM,"/usr/local/www/data/foad/plateforme/interformation.net/formation/data/csv/qcm/modeleQCM.csv");

//Cration de sa structure
$currentImportFile->analyse();


//----------------------------------------------------
//				EXPORT
//----------------------------------------------------

//Cration de l'ExportFile
$currentExportFile=ExportAstairsFactory::create(TYPE_EVALUATION_QCM);


//----------------------------------------------------
//				TRANSFER
//----------------------------------------------------

//Cration du TransfertBuilder
$currentTransfertBuilder=new TransfertBuilderCsvAstairsQcm();

//Affecte l'ImportFile
$currentTransfertBuilder->setImportFile($currentImportFile);

//Affecte l'ExportFile
$currentTransfertBuilder->setExportFile($currentExportFile);

//Cration de la stucture de corrlation
$currentTransfertBuilder->correlate();

//Cration des donnes
$currentTransfertBuilder->create();

pg_query("rollback");
?>