<?php
/*
	This file is part of Astairs.

    Astairs is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    any later version.

    Astairs is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Astairs.  If not, see <http://www.gnu.org/licenses/>.

	Copyright (C) 2006, 2007, 2008, 2009 AFIDE
    
	Auteurs:

	Said Ladjani <sladjani@yahoo.fr>
	Remi Cocquet <remi.cocquet@gmail.com>

*/

/**
* Import / Export
* @package import_export
*/

//------------------------------------------------------------------
//          IDENTIFICATION
//------------------------------------------------------------------
//inclusions
$dbpath="../..";  //le dbpath sert  maintenir les inclusions  partir du $chemin_bo
include("$dbpath/dbpostgres.php");
include("$root/conf/generated/default_version_base.php");
require("$root/lib/lib_import_export.php");
require("$root/lib/lib_front_office.php");
require("$root/lib/lib_langue.php");

//------------------------------------------------------------------
//          LANGUE DE CONTENU
//------------------------------------------------------------------
// en franais
$ams_langue=1;
// en portugais
$ams_langue=8;

//connecteDB();
$db=pg_connect("$server", "", "", "", "$nombase");

echo "<br>Debut importation<br>";
// Obtention de la categorie de donne
function get_categorie_data($repertoire){
	$categorie_data=0;
	switch($repertoire){
		case 'qcm' :
			
		case 'sondage' :
			
		case 'qrc' :
			
		case 'src' :
			
		case 'ftb' :
			$categorie_data=TYPE_CATEGORIE_EVALUATION;
		break;
		case 'ressource' :
			$categorie_data=TYPE_CATEGORIE_ETAPE;
		break;
		case 'glossaire' :
			$categorie_data=TYPE_CATEGORIE_RESSOURCE_GLOSSAIRE;
		break;
	}
	return $categorie_data;
}

// Conversion des nom de repertoire en type d'evaluation
function get_repertoire_type($repertoire){
	$type=0;
	switch($repertoire){
		case 'qcm' :
			$type=TYPE_EVALUATION_QCM;
		break;
		case 'sondage' :
			$type=TYPE_EVALUATION_SONDAGE;
		break;
		case 'qrc' :
			$type=TYPE_EVALUATION_QRC;
		break;
		case 'src' :
			$type=TYPE_EVALUATION_SRC;
		break;
		case 'ftb' :
			$type=TYPE_EVALUATION_FTB;
		break;
		case 'ressource' :
			$type=TYPE_ETAPE_RESSOURCE;
		break;
		case 'glossaire' :
			$type=TYPE_CATEGORIE_RESSOURCE_GLOSSAIRE;
	}
	return $type;
}

/*
NOTE :
Gre uniquement le rpertoire CSV dans le thme demo
*/
// Le rpertoire  lire : $repertoireCsv
if (VERSION_BASE > VERSION) 
	$repertoireCsv="$chemin_fo/data/csv/";
else
	 $repertoireCsv="$chemin_fo/data/csv_public/";
// Les repertoires indesirables
$badrep=array(".","..");

// lecture du repertoire csv et de ses sous repertoires
if($dircsv=opendir($repertoireCsv)){
	while($rep=readdir($dircsv)){
		$chemin_rep=$repertoireCsv.$rep;
		if(is_dir($chemin_rep) && !in_array($rep,$badrep)){
			// lecture repertoire courant
			if($dirrep=opendir($chemin_rep)){
				while($repCourant=readdir($dirrep)){
					if(!in_array($repCourant,$badrep)){
						$chemin_rep_courant=$chemin_rep."/".$repCourant;
						if(is_file($chemin_rep_courant)){
							// on determine la categorie du type de donne en fonction du rep
							$categorie_data=get_categorie_data($rep);
							// on dtermine le type de donne en fonction du rep
							$type=get_repertoire_type($rep);
							
							// On ne traite que les qcm pour l'instant
							//if($type==TYPE_EVALUATION_QCM ){
							
							//if($type==TYPE_ETAPE_RESSOURCE){
							// Traitement glossaire
							if($type==TYPE_CATEGORIE_RESSOURCE_GLOSSAIRE){
							//if($type){
								echo "\tImportation des donnees de type : $type(rep=$rep)<br>\tFichier:$chemin_rep_courant<br><br>";
								/*
								$currentImportFile=ImportFileCsvFactory::create($type,$chemin_rep_courant);
								$currentImportFile->analyse();
								// debug affichage de l'attribut importStruct
								//print_rr($currentImportFile->importStruct);
								$currentImportFile->parse();
								$data=$currentImportFile->getReadData();
								while($data){
									
									$currentImportFile->parse();
									$data=$currentImportFile->getReadData();		
								}
								print_rr($data);
								*/
								pg_query("begin");

								//----------------------------------------------------
								//				IMPORT
								//----------------------------------------------------
								//Cration de l'ImportFile
								switch($categorie_data){
									case TYPE_CATEGORIE_EVALUATION :
									case TYPE_CATEGORIE_RESSOURCE_GLOSSAIRE :
										$currentImportFile=ImportFileCsvFactory::create($type,$chemin_rep_courant);
										//print_rr($currentImportFile);
									break;
									case TYPE_CATEGORIE_ETAPE :
										$currentImportFile=ImportFileCsvEtapeFactory::create($type,$chemin_rep_courant);
									break;
								}

								//Cration de sa structure
								$currentImportFile->analyse();

								//----------------------------------------------------
								//				EXPORT
								//----------------------------------------------------
								//Cration de l'ExportFile
								switch($categorie_data){
									case TYPE_CATEGORIE_EVALUATION :
									case TYPE_CATEGORIE_RESSOURCE_GLOSSAIRE :
										$currentExportFile=ExportAstairsFactory::create($type);
                                    break;
									case TYPE_CATEGORIE_ETAPE :
										$currentExportFile=ExportAstairsEtapeFactory::create($type);
									break;
								}
								//----------------------------------------------------
								//				TRANSFER
								//----------------------------------------------------
								//Cration du TransfertBuilder
								switch($categorie_data){
									case TYPE_CATEGORIE_EVALUATION :
										switch($type){
											case TYPE_EVALUATION_QCM :
												$currentTransfertBuilder=new TransfertBuilderCsvAstairsQcm();
											break;
											case TYPE_EVALUATION_SONDAGE :
												$currentTransfertBuilder=new TransfertBuilderCsvAstairsSondage();
											break;
											case TYPE_EVALUATION_QRC :
												$currentTransfertBuilder=new TransfertBuilderCsvAstairsQrc();
											break;
											case TYPE_EVALUATION_SRC :
												$currentTransfertBuilder=new TransfertBuilderCsvAstairsSrc();
											break;
											case TYPE_EVALUATION_FTB :
												$currentTransfertBuilder=new TransfertBuilderCsvAstairsFtb();
											break;
											
										}
									break;
									case TYPE_CATEGORIE_ETAPE :
										switch($type){
											case TYPE_ETAPE_RESSOURCE :
												$currentTransfertBuilder=new TransfertBuilderCsvAstairsRessource();
											break;
										}
									break;
									case TYPE_CATEGORIE_RESSOURCE_GLOSSAIRE :
												$currentTransfertBuilder=new TransfertBuilderCsvAstairsGlossaire();
									break;
									
                                }
								//Affecte l'ImportFile
								$currentTransfertBuilder->setImportFile($currentImportFile);
                                 //print_rr($currentTransfertBuilder);
								//Affecte l'ExportFile
								$currentTransfertBuilder->setExportFile($currentExportFile);

								//Cration de la stucture de corrlation
								$currentTransfertBuilder->correlate();

								//Cration des donnes
								
								$currentTransfertBuilder->create();

								//pg_query("rollback");
								pg_query("commit");		
							}
						}
					}
				}
			}
			else{
				die("Impossible de lire le repertoire courant");
			}
		}
	}
}
else{
	die("Impossible de lire le repertoire csv");
}
echo "<br>Fin importation<br>";
?>