<?php
/*
	This file is part of Astairs.

    Astairs is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    any later version.

    Astairs is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Astairs.  If not, see <http://www.gnu.org/licenses/>.

	Copyright (C) 2006, 2007, 2008, 2009 AFIDE
    
	Auteurs:

	Said Ladjani <sladjani@yahoo.fr>
	Remi Cocquet <remi.cocquet@gmail.com>

*/

/**
	affichage des tapes du parcours
	@package parcours
*/
//----------------------------------------------------------
//					INCLUSIONS
//----------------------------------------------------------
//EN TETE DE LA PAGE
$dbpath="../..";
include("$dbpath/en_tete.php");
include("../en_tete_back.php");

//PERSMISSIONS REQUISES POUR AFFICHER LA PAGE
$perm->check("MOD");
  	
  	
//OBJETS DE LA PAGE
include ("$chemin_bo/individu/includes.php");
//print_rr($obj_module);

//$start=calcul_execution();


//----------------------------------------------------------
//             AFFICHAGE
//----------------------------------------------------------

$page_builder->setModuleRoot("$chemin_bo/individu/templates/tpl");	
//les styles
//$style_files['../../bo/styles/afide'][]='bo_module_individu_edition.css';	
messageDebugR("Fichier CSS chargs:",$style_files);	
	
//les fichiers javascripts
$javascript_files=array();
$javascript_files["./templates/script"][]="javascript_individu.js";
messageDebugR("Fichier javascript chargs:",$javascript_files);	

//le javascript interne
//$javascript_internal_code="";
messageDebug("Code javascript charg:<br>$javascript_internal_code");	



//------------------------------------------------------------
// 		TRAITEMENT FORMULAIRE
//------------------------------------------------------------
//Recuperation des valeurs
//$individu = $obj_DoFormation->getIndividu();
$individu=$auth->auth['user_id'];
$droit_utilisateur = 0;
$droit_detail = 0;
$pass = $_POST[$timestamp];
$confirm_pass = $_POST[$confirm];

//Condition d'envoi
if($submit){
	
	if($pass != $confirm_pass || empty($pass) || empty($confirm_pass)  || empty($nom) || empty($prenom)){
		PageComponent::setPageMessage("Vous devez remplir les champs obligatoires!!",MSG_WARNING);
	
	}else{
		$erreur_etoile = false;		
		$nom=strtoupper($nom);
		$prenom=strtolower($prenom);
		$prenom=ucwords($prenom);
		
		$suppression_photo = $_POST['del_photo'];
		pg_query('begin');
		//-----------------------------------------------------------
		//					UPLOAD PHOTO
		//----------------------------------------------------------- 
		if(count($_FILES)>0){
			$err=false;
			$type_message=MSG_ERROR;
			$userfile_name=$_FILES['photo']['name'];
			$userfile_size=$_FILES['photo']['size'];
			$userfile=$_FILES['photo']['tmp_name'];
			
			$userfile_name=get_fichier_disk_name($userfile_name);	
			if(!empty($userfile_name)){
				
				//vrif de la taille du fichier fourni par le stagiaire
				if($userfile_size>(((int)MAX_PHOTO_SIZE)*1024)){
					$err=true;
					$message=WARN_80;
					$type_message=MSG_WARNING;
				}
				
				//verif des dimmensions de l'image
				list($width, $height, $type, $attr) = getimagesize($userfile);
				if($width>MAX_PHOTO_WIDTH || $height>MAX_PHOTO_HEIGHT){
					$err=true;
					$message='L\'image doit avoir des dimensions maximales de '.MAX_PHOTO_WIDTH.'px * '.MAX_PHOTO_HEIGHT.'px';
					$type_message=MSG_WARNING;
				}
				if(!$err){
					$id_photo=set_fichier_photo($userfile_name);
				}
			}
		}
		//chemin photo
		$chemin_photo=$astairs_directories['PRIVATE_USER_DATA_DIR'];
		$chemin_photo=$chemin_photo.$individu.'/';
		
		//recup ancienne photo
		$old_photo=pg_fetch_result(get_individu($individu),0,14);

		//suppression photo 
		if($suppression_photo ){
			$keep_old_photo=false;
		}else{
			//pas de changemement de photo
			if(empty($id_photo)){
				$id_photo=$old_photo; //on ne change pas la photo 
				$keep_old_photo=true;
			}
			//changemement de photo
			else{
				$keep_old_photo=false;
			}
		}
						
		$res=maj_individu_fo(int2Sql($individu),string2Sql($pass),string2Sql($nom),string2Sql($prenom),string2Sql($adr),string2Sql($code),string2Sql($ville),string2Sql($mail),string2Sql($telfixe),string2Sql($telport),int2Sql($langue),int2Sql($id_photo));
		//upload
		if(!empty($id_photo)&&!empty($userfile_name)){
			if(!is_dir($chemin_photo)){//si le repertoire de l'individu n'existe pas au sein du repertoire, on le cre
				mkdir($chemin_photo,0777);
			}
			$msg_upload=uploadFichier($userfile, $userfile_name, $userfile_size, $userfile_name, $chemin_photo);
		}	
		if(!$keep_old_photo){	
			//suppression ancienne photo
			if($old_photo){
				$old_photo_name=pg_fetch_result(get_fichier($old_photo),0,1);
				$del_db=del_fichier_db($old_photo);
				if($del_db)$del_fichier_disque=del_fichier($chemin_photo.$old_photo_name);
				else $err=true;	
				
				if(!$del_fichier_disque)$err=true;
			}
		}
	    //erreur upload
	    if (!empty($msg_upload)){
			$message=$msg_upload;
			$err=true;
			pg_query('rollback');
	    }else{
	    	pg_query('commit');
	    }
	    //message
		if($err){
			PageComponent::setPageMessage($message,$type_message);
		}else{
			if($res)
				PageComponent::setPageMessage("Vos modifications ont bien ete prises en compte",MSG_CONFIRM);
			else 
				PageComponent::setPageMessage("Erreur modifications utilisateur",MSG_ERROR);
		}
	}
}


//------------------------------------------------------------
// LA PAGE
//------------------------------------------------------------

$contenu = new guiFoIndividuFormulaire($individu,"$chemin_fo/individu/templates/tpl",array('page_contenu' => 'gui_fo_individu_formulaire.tpl'));


//la page spcifique	
$page=new guiBoIndividuPage($page_builder, array('page_dev' => 'gui_bo_individu_page.tpl'),$style_files,$javascript_files,$javascript_internal_code,'');


//les lments pour la page
$page->setComponent('page_contenu',$contenu);


//on parse
$page->parse();

//on affiche
$page->p();

include("$dbpath/pied_page.php");
//print("execut en ".(calcul_execution()-$start)." microsecondes");
?>