<?php
/*
	This file is part of Astairs.

    Astairs is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    any later version.

    Astairs is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Astairs.  If not, see <http://www.gnu.org/licenses/>.

	Copyright (C) 2006, 2007, 2008, 2009 AFIDE
    
	Auteurs:

	Said Ladjani <sladjani@yahoo.fr>
	Remi Cocquet <remi.cocquet@gmail.com>

*/

/**
 * Cette class affiche le detail d'un individu
 * 
 * @package individu
 */
class guiBoDetailIndividu extends PageComponent{
	/**
 	 * @param integer $individu L'identifiant de l'individu
 	 * @param string $organisme Le libelle de l'organisme 
 	 * @param string $module_root Le chemin du dossier contenant les tpl requis
 	 * @param string[] $templates Le tableau contenant la variable de destination et le tpl requis pour l'objet
	 */	
	function guiBoDetailIndividu($block_target,$organisme,$individu,$module_root=null,$templates=null){
		global $chemin_fo,$serverfront,$chemin_bo,$astairs_directories;
		parent::PageComponent($module_root,$templates);
		$resul=get_individu($individu);
		if($resul) {
			$cnt = pg_NumRows($resul);
			if($cnt != 1) 
				parent::setPageMessage(ERROR_11,MSG_ERROR);	
			else{
				$val['LIBELLE_CHAMPS'] = MSG_78;
				$val['LIBELLE_VALEUR'] = MSG_79;
			}
			
			$row=pg_fetch_row($resul,0);
			if($organisme){
				$resorg=get_organisme($organisme);
				$roworg=pg_fetch_row($resorg,0);
//				print_rr($roworg);
				$nom_org=$roworg[1];
			}
			else
				$nom_org=MSG_2537;
				
			$val['LIBELLE_TITRE_ORGANISME'] = MSG_71;
			$val['LIBELLE_ORGANISME'] = $nom_org;
			
			$tab=get_individu_types_formates($individu);
//			echo "bobo";
//			print_rr($tab);
			$val['LIBELLE_TITRE_CATEGORIE'] = MSG_16;

			parent::set_block($block_target,'block','bloc_valeur');
			while(list($cle,$valeur_val)=each($tab)){
				parent::set_var ('LIBELLE_CATEGORIE',$valeur_val);
				Template::parse('bloc_valeur','block',true);
			}
			
			$val['LIBELLE_TITRE_INDIVIDU'] = MSG_80.":";
			$val['LIBELLE_INDIVIDU'] = $individu;
			
			$val['LIBELLE_TITRE_LOGIN'] = MSG_5.":";
			$val['LIBELLE_LOGIN'] = $row[2];
			
			$val['LIBELLE_TITRE_MDP'] = MSG_6.":";
			$val['LIBELLE_MDP'] = $row[3];
			
			$val['LIBELLE_TITRE_NOM'] = MSG_7.":";
			$val['LIBELLE_NOM'] = $row[4];
			
			$val['LIBELLE_TITRE_PRENOM'] = MSG_8.":";
			$val['LIBELLE_PRENOM'] = $row[5];
						
			$val['LIBELLE_TITRE_ADRESSE'] = MSG_9.":";
			$val['LIBELLE_ADRESSE'] = $row[6];
			
			$val['LIBELLE_TITRE_CP'] = MSG_10.":";
			$val['LIBELLE_CP'] = $row[7];
			
			$val['LIBELLE_TITRE_VILLE'] = MSG_11.":";
			$val['LIBELLE_VILLE'] = $row[8];
			
			$val['LIBELLE_TITRE_MAIL'] = MSG_12.":";
			$val['LIBELLE_MAIL'] = $row[9];
			
			$val['LIBELLE_TITRE_TEL_FIXE'] = MSG_13.":";
			$val['LIBELLE_TEL_FIXE'] = $row[10];
			
			$val['LIBELLE_TITRE_TEL_PORT'] = MSG_14.":";
			$val['LIBELLE_TEL_PORT'] = $row[11];
			
			if(empty($row[14])){
				$val['PHOTO_URL'] =DEFAULT_PHOTO_PATH;
			}else{
				$val['PHOTO_URL'] =$astairs_directories['PRIVATE_USER_DATA_DIR'].$individu.'/';
			}
			$val['PHOTO_ALT'] = MSG_15. $row[2];
			$val['PHOTO_TITLE'] = MSG_15. $row[2];
			
			$res_langue=get_langue($row[12]);
				$nom_langue=pg_fetch_result($res_langue,0,1);
				eval("\$nom_langue=\"$nom_langue\";");
				
			$val['LIBELLE_TITRE_LANGUE'] = MSG_1030.":";
			$val['LIBELLE_LANGUE'] = $nom_langue;
			
			parent::set_var($val);
		}
	}
}
?>