<?php
/*
	This file is part of Astairs.

    Astairs is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    any later version.

    Astairs is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Astairs.  If not, see <http://www.gnu.org/licenses/>.

	Copyright (C) 2006, 2007, 2008, 2009 AFIDE
    
	Auteurs:

	Said Ladjani <sladjani@yahoo.fr>
	Remi Cocquet <remi.cocquet@gmail.com>

*/

/**
 * Cette class construit l'affichage de faon gnrique d'un formulaire ou le detail sur un individu
 * 
 * @package individu
 */
class guiBoIndividu extends PageComponent{
	
	var $select_organisme;
	var $gui_fo_individu;
	var $select_categorie;
	
	/**
	 * Constructeur
	 * 
	 * @param integer $individu L'identifiant de l'individu
	 * @param string $module_root Le chemin du dossier contenant les tpl requis
 	 * @param string[] $templates Le tableau contenant la variable de destination et le tpl requis pour l'objet
	 */
	function guiBoIndividu($individu,$module_root=null,$templates=null,$type=null){
		global $perm,$chemin_bo,$chemin_fo,$FORM_6,$root;
		global $MSG_2613,$MSG_2614;
		parent::PageComponent($module_root,$templates);
		
		//Affichage du select qui permet de choisir l'organisme.
		$this->select_organisme = new guiBoSelectOrganisme('select_organisme',$individu,"$chemin_bo/individu/templates/tpl",array('select_organisme'=>'gui_bo_select_organisme.tpl'));
		$this->setComponent('select_organisme',$this->select_organisme);
		
		//Affichage de l'ensemble des champs de saisie du formulaire ainsi que les selects qui permettent de choisir la photo et la langue d'un individu.
		$this->gui_fo_individu = new guiFoIndividu($individu,"$chemin_fo/individu/templates/tpl",array('champs_formulaire' => 'gui_fo_individu.tpl'),false);
		$this->setComponent('champs_formulaire',$this->gui_fo_individu );
		
		//Affichage du select qui permet de choisir la categorie.
//		$this->select_categorie = new guiBoSelectCategorie('select_categorie',$individu,"$chemin_bo/individu/templates/tpl",array('select_categorie'=>'gui_bo_select_categorie.tpl'));
//		$this->setComponent('select_categorie',$this->select_categorie);

//		$val['SELECT_CATEGORIE']=get_individu_type($individu);

		//dition
		if($individu){
			if($perm->have_perm('GEST')){
//				echo "ok";
				//IN
				//$in=new SelectListIn("get_individu_types($individu)",'Profils de l\'individu','select_in','',"set_individu_individus_types($individu,##element##)","del_individu_individus_types($individu,##element##)");
				$msg=stripslashes($MSG_2613);
	//			echo "msg=$msg et msg_2613=$MSG_2613<br>";
				$in=new SelectListIn("get_individu_types($individu)",$msg,'select_in','',"set_individu_individus_types($individu,##element##)","del_individu_individus_types($individu,##element##)");
				
				
				//OUT
				//$out=new SelectListOut('get_plateforme_individus_types()','Profils disponibles','select_out','',$in);
				$out=new SelectListOut('get_plateforme_individus_types()',$MSG_2614,'select_out','',$in);
				
				$selectListAddRemove=new SelectListAddRemove($in,$out);
				$categorie=new guiSelectListAddRemove('select_categorie',$selectListAddRemove,$root."lib_graphique/selects/selectAddRemove/templates/tpl",array('select_categorie' => 'gui_select_list_add_remove.tpl'));
				$this->setComponent('select_categorie',$categorie);
			}
			else{
				$res_type=get_individu_types($individu);
				if(pg_num_rows($res_type)==1){
					$val['SELECT_CATEGORIE']=eval ('return '.pg_fetch_result($res_type,0,1).';');
				}else{
					$this->select_categorie = new guiBoSelectCategorie('select_categorie',$individu,"$chemin_bo/individu/templates/tpl",array('select_categorie'=>'gui_bo_select_categorie.tpl'),$type);
					$this->setComponent('select_categorie',$this->select_categorie);
				}
			}
		//cration	
		}else{
			//echo "type=$type<br>";
			//utilisateur ou formateur
			//if($type!=0){
				//Affichage du select qui permet de choisir la categorie.
				$this->select_categorie = new guiBoSelectCategorie('select_categorie',$individu,"$chemin_bo/individu/templates/tpl",array('select_categorie'=>'gui_bo_select_categorie.tpl'),$type);
				$this->setComponent('select_categorie',$this->select_categorie);
		//	}
			//autres utilisateurs
//			else{
//				if($perm->have_perm('GEST')){
//					//IN
//					//$in=new SelectListIn("get_individu_types($individu)",'Profils de l\'individu','select_in','',"set_individu_individus_types($individu,##element##)","del_individu_individus_types($individu,##element##)");
//					$msg=stripslashes($MSG_2613);
//		//			echo "msg=$msg et msg_2613=$MSG_2613<br>";
//					$in=new SelectListIn("get_individu_types(NULL)",$msg,'select_in','',"set_individu_individus_types($individu,##element##)","del_individu_individus_types($individu,##element##)");
//					
//					
//					//OUT
//					//$out=new SelectListOut('get_plateforme_individus_types()','Profils disponibles','select_out','',$in);
//					$out=new SelectListOut('get_plateforme_individus_types()',$MSG_2614,'select_out','',$in);
//					
//					$selectListAddRemove=new SelectListAddRemove($in,$out);
//					$categorie=new guiSelectListAddRemove('select_categorie',$selectListAddRemove,$root."lib_graphique/selects/selectAddRemove/templates/tpl",array('select_categorie' => 'gui_select_list_add_remove.tpl'));
//					$this->setComponent('select_categorie',$categorie);
//				}
//				else{
//					$val['SELECT_CATEGORIE']=eval ('return '.pg_fetch_result(get_individu_types($individu),0,1).';');
//				}

//			}
		}

		$val['$FORM_6']=FORM_6;
		parent::set_var($val);
	}
	
	/**
	 * Traitement de la soumission formulaire
	 * @param array : le tableau $_POST
	 * @return mixed : true ou false si update,le n individu si insert 
	 */
	function submit($post){
		global $_GET,$_FILES,$astairs_directories;	
		
		//Recuperation des variable de formulaire
		$individu=$post['individu'];
		$old_log=$post['old_log'];
		$log = $post['log'];
		$pass = $post [$post["timestamp"]];
		$confirm_pass = $post[$post["confirm"]];
		$nom=$post['nom'];
		$prenom=$post['prenom'];
		$adr=$post['adr'];
		$code=$post['code'];
		$ville=$post['ville'];
		$mail=$post['mail'];
		$telfixe=$post['telfixe'];
		$telport=$post['telport'];
		$langue=$post['langue'];
		$org=$post['org'];
		$individu = $_GET['idv'];
		$type = $post['categorie'];
		$suppression_photo = $post['del_photo'];
		
		if($org==0)$org=null;
		
		//On traite le Formulaire
		if($post["submit"]){
			//On verifie si les champs obligatoires sont remplis
			
			if($pass != $confirm_pass || empty($pass) || empty($log) || empty($confirm_pass)  || empty($nom) || empty($prenom)){
				//$contenu = new guiBoIndividu($droit_detail,$droit_utilisateur,$type,$message,$erreur_etoile,$individu,"$chemin_bo/individu/templates/tpl",array('page_contenu' => 'gui_bo_individu.tpl'));
				//echo "pass=$pass et conf_pass=$confirm_pass<br>";
				PageComponent::setPageMessage("Vous devez remplir les champs obligatoires",MSG_WARNING);
			}
			else{
				if(empty($message)){
		
					// Prparation des donnes
					//$log=addslashes($log);
					//$pass=addslashes($pass);
					$nom=strtoupper($nom);
					//$nom=addslashes($nom);
					if($post['prenom']=="")
						$prenom="";
					else{
						$prenom=strtolower($prenom);
						$prenom=ucwords($prenom);
					}
					
					pg_query('begin');
					//repertoire de destination des photos
					$chemin_photo=$astairs_directories['PRIVATE_USER_DATA_DIR'];
							
					//-----------------------------------------------------------
					//					UPLOAD PHOTO
					//----------------------------------------------------------- 
					if(count($_FILES)>0){
						
						$err=false;
						$type_message=MSG_ERROR;
						$userfile_name=$_FILES['photo']['name'];
						$userfile_size=$_FILES['photo']['size'];
						$userfile=$_FILES['photo']['tmp_name'];
						
						if(!empty($userfile_name)){

							$userfile_name=get_fichier_disk_name($userfile_name);							
							//vrif de la taille du fichier fourni par le stagiaire
							if($userfile_size>(((int)MAX_PHOTO_SIZE)*1024)){
								$err=true;
								$message=WARN_80;
								$type_message=MSG_WARNING;
							}
							
							//verif des dimmensions de l'image
							list($width, $height, $type, $attr) = getimagesize($userfile);
							if($width>MAX_PHOTO_WIDTH || $height>MAX_PHOTO_HEIGHT){
								$err=true;
								$message='L\'image doit avoir des dimensions maximales de '.MAX_PHOTO_WIDTH.'px * '.MAX_PHOTO_HEIGHT.'px';
								$type_message=MSG_WARNING;
							}
							if(!$err){
								$id_photo=set_fichier_photo($userfile_name);
							}
						}
					}
					
					if($post['mode_formulaire']==1 || $post['mode_formulaire']==3){
						
						
						//insert
						$token=md5(uniqid(rand()));
						$new_id=set_individu(string2Sql($token),string2Sql($log),string2Sql($pass),string2Sql($nom),string2Sql($prenom),string2Sql($adr),string2Sql($code),string2Sql($ville),string2Sql($mail),string2Sql($telfixe),string2Sql($telport),int2Sql($langue),int2Sql($org),int_array_to_plpgsql_array(Array($type)),'NULL','NULL','NULL',int2Sql($id_photo));
						
						//chemin photo
						$chemin_photo=$chemin_photo.$new_id.'/';
						
						//upload
						if(!is_dir($chemin_photo)){//si le repertoire de l'individu n'existe pas au sein du repertoire, on le cre
							mkdir($chemin_photo,0777);
						}
						if(!empty($id_photo))$msg_upload=uploadFichier($userfile, $userfile_name, $userfile_size, $userfile_name, $chemin_photo);
					    //erreur upload
					    if (!empty($msg_upload)){
							$message=$msg_upload;
							$err=true;
							pg_query('rollback');
					    }else{
					    	pg_query('commit');
					    }
					    //message
						if($err){
							PageComponent::setPageMessage($message,$type_message);
						}else{
							if($new_id)
								PageComponent::setPageMessage("L'utilisateur $nom $prenom  bien t cr",MSG_CONFIRM);
							else 
								PageComponent::setPageMessage("Erreur cration utilisateur",MSG_ERROR);
						}
						
					}
					else{	
						//chemin photo
						$chemin_photo=$chemin_photo.$individu.'/';
						
						//recup ancienne photo
						$old_photo=pg_fetch_result(get_individu($individu),0,14);

						//suppression photo 
						if($suppression_photo ){
							$keep_old_photo=false;
						}else{
							//pas de changemement de photo
							if(empty($id_photo)){
								$id_photo=$old_photo; //on ne change pas la photo 
								$keep_old_photo=true;
							}
							//changemement de photo
							else{
								$keep_old_photo=false;
							}
						}
						//maj
						$res=maj_individu($individu,string2Sql($log),string2Sql($pass),string2Sql($nom),string2Sql($prenom),string2Sql($adr),string2Sql($code),string2Sql($ville),string2Sql($mail),string2Sql($telfixe),string2Sql($telport),int2Sql($langue),int2Sql($org),null,int2Sql($id_photo));
						// Si le login a t modifi mise  jour des tables du forum
						if($log!=$old_log){
							$res=maj_individu_login_forum($old_log,$log);
						}
						if($type){
							set_individu_individus_types($individu,array($type));
						}

						//upload
						if(!empty($id_photo)&&!empty($userfile_name)){
							if(!is_dir($chemin_photo)){//si le repertoire de l'individu n'existe pas au sein du repertoire, on le cre
								mkdir($chemin_photo,0777);
							}
							$msg_upload=uploadFichier($userfile, $userfile_name, $userfile_size, $userfile_name, $chemin_photo);
						}	
						if(!$keep_old_photo){	
							//suppression ancienne photo
							if($old_photo){
								$old_photo_name=pg_fetch_result(get_fichier($old_photo),0,1);
								$del_db=del_fichier_db($old_photo);
								if($del_db)$del_fichier_disque=del_fichier($chemin_photo.$old_photo_name);
								else $err=true;	
								
								if(!$del_fichier_disque)$err=true;
							}
						}
					    //erreur upload
					    if (!empty($msg_upload)){
							$message=$msg_upload;
							$err=true;
							pg_query('rollback');
					    }else{
					    	pg_query('commit');
					    }
					    //message
						if($err){
							PageComponent::setPageMessage($message,$type_message);
						}else{
							if($res)
								PageComponent::setPageMessage("Vos modifications ont bien ete prises en compte",MSG_CONFIRM);
							else 
								PageComponent::setPageMessage("Erreur modifications utilisateur",MSG_ERROR);
						}
					}
				}
			}
		}
		return $new_id;	
	}
}
?>