<?php
/*
	This file is part of Astairs.

    Astairs is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    any later version.

    Astairs is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Astairs.  If not, see <http://www.gnu.org/licenses/>.

	Copyright (C) 2006, 2007, 2008, 2009 AFIDE
    
	Auteurs:

	Said Ladjani <sladjani@yahoo.fr>
	Remi Cocquet <remi.cocquet@gmail.com>

*/

/**
 * Cette class affiche les champs de saisie pour modifier les renseignement d'un individu, observer le detail ou creer un individu.  
 * 
 * @package individu
 */
class guiBoIndividuBase extends PageComponent{
	/**
	 * @param integer $individu L'identifiant de l'individu
	 * @param string $module_root Le chemin du dossier contenant les tpl requis
 	 * @param string[] $templates Le tableau contenant la variable de destination et le tpl requis pour l'objet
	 */	
//	function guiBoInfosTexte($droit_detail,$droit_utilisateur,$type,$message,$erreur_etoile,$individu,$module_root=null,$templates=null){
	function guiBoIndividuBase($individu,$module_root=null,$templates=null,$keep_login=true){	
		global $perm,$astairs_directories;
		global $chemin_fo,$chemin_bo;
		parent::PageComponent($module_root,$templates);
		
		
		//=============================
		//   Traitement si il y a l'identifiant d'un individu   |
		//=============================
		//Si le numero d'individu n'est pas vide
		//echo "ici individu=$individu<br>";
		if(!empty($individu)){
			//On recupere les infos sur l'individu			
			$resindividu=get_individu($individu);
			$rowindividu=pg_fetch_row($resindividu,0);
			
			//Attribution des libelles
			$libelle_nom = sql2String($rowindividu[4]);
			$libelle_prenom = sql2String($rowindividu[5]) ;
			$libelle_adresse = sql2String($rowindividu[6]) ;
			$libelle_code = sql2String($rowindividu[7]);
			$libelle_ville = sql2String($rowindividu[8]) ;
			$libelle_mail = sql2String($rowindividu[9]);
			$libelle_telfixe = sql2String($rowindividu[10]);
			$libelle_telport = sql2String($rowindividu[11]);
			
			//photo
			if(!empty($rowindividu[14])){
				$nom_photo=pg_fetch_result(get_fichier($rowindividu[14]),0,1);
				$photo_url=$astairs_directories['PRIVATE_USER_DATA_URL'].$individu.'/'.$nom_photo;	
			}
			//Attribution du libelle categorie
			$tab=get_individu_types_formates($individu);
			
			
			$mode_formulaire = 2;			
		}
		else 
			$mode_formulaire = 1;
		
		//On creer le select pour la selection de la photo.
		$select_photo = new guiBoSelectPhoto('select_photo',$photo_url,$rowindividu[2] ,"$chemin_bo/individu/templates/tpl",array('select_photo'=>'gui_bo_select_photo.tpl'));
		$this->setComponent('select_photo',$select_photo);
		
		//=============================
		//             Calcul du de la variable alatoire            |
		//=============================
		$pass_timestamp = "pass_".time();
		$confirmation_pass_timestamp="confirm_pass_".time();
		
		
		//=============================
		// Affichage de l'etoile rouge si il y a une erreur  |
		//=============================
		$recuperation_code_message = parent::getPageMessage();
		$code_message = $recuperation_code_message['MSG_CODE'];
		
		if ($code_message == MSG_CONFIRM){
			$etoile = "";			
		}else if ($code_message == MSG_WARNING){
			$etoile= "<font color=\"re$nom_photod\">*</font>";			
//			unset($rowindividu[3]);
		}

		
		//=============================
		//       Traitement sur les droits de l'individu          |
		//=============================
		//Condition des droits de l'individu pour les differentes modifications		
		if(true){		
			$libelle_titre_login = MSG_5;
			$libelle_titre_password = MSG_6;
			$libelle_titre_confirm_password = MSG_2568;
			if(!$keep_login)$champs_text_login = "<input type=\"text\"  name=\"log\"  value=\"$rowindividu[2]\" size=\"15\" maxlen=\"8\">$etoile";
			else $champs_text_login=$rowindividu[2];
			if($_GET['action_individu'] == "detail_individu"){
				//On boucle sur les types l'individu	
				if(!empty($tab))			
					while(list($cle,$valeur_val)=each($tab)){
						$vale=eval('return '.$valeur_val.';');
						$val['LIBELLES_TYPES'] .= $vale." ";
					}
				else
					$val['LIBELLES_TYPES']=MSG_835;	
				
				//Attribution du libelle identifiant	
				$libelle_identifiant=$rowindividu[0];				
				$champs_text_login=$rowindividu[2];
				
				//On recupere la langu$nom_photoe
				$num_langue = $rowindividu[12];
				$reslangue = get_langue($num_langue);
				$rowlangue = pg_fetch_row($reslangue);

				//Attribution du libelle langue
				$libelle_langue = $rowlangue[1];
				eval("\$libelle_langue=$libelle_langue;");
				
				//Attribution du libelle Organisme
				if(!empty($rowindividu[13])){
					$libelle_organisme = pg_fetch_result(get_organisme($rowindividu[13]),0,1);
				}
				//Si il n y a pas de libelle organisme, alors on affiche par defaut
				else{
					$libelle_organisme = MSG_2537;
				}
					
				//Recuperation de la photo de l'individu
				$chemin_photo = "http://$serverfront/fo/data/photos";
				if(empty($rowindividu[14]))
					$rowindividu[14]="vide.gif";
				$url_chemin_photo = $chemin_photo."/".$rowindividu[14];
					
			}
			$champs_text_password = $rowindividu[3] ;
			$champs_text_confirm_password = $champs_text_password;
		}else{
			$libelle_titre_password = MSG_6;
			//$libelle_titre_confirm_password = "Confirmation du mot de passe";
			$libelle_titre_confirm_password = MSG_2568;
			$champs_text_password = $rowindividu[3];
			$champs_text_confirm_password =$champs_text_password;
		}
		
		
		//==============================
		//   Affichage de l'ensemble des champs textes    |
		//==============================
		//Affichage de l'organisme
		$val['LIBELLE_TITRE_ORGANISME'] = MSG_71;
		$val['LIBELLE_ORGANISME'] = $libelle_organisme;
		
		//Affichage de l'identifiant de l'individu
		$val['LIBELLE_TITRE_IDENTIFIANT'] =MSG_80 ;
		$val['NUMERO_IDENTIFIANT'] = $individu;
		
		//Affichage de la categorie de 'lindividu
		$val['LIBELLE_TITRE_CATEGORIE'] =MSG_16;
		
		//Affichage de l'etoile rouge(elle se place a cote du champ 
		//de saisie quand il y a une erreur de saisie ou un oublie d 
		// un champ obligatoire).
		$val['PASS_ERREUR_ETOILE'] =$etoile; 
		
		//Affichage du login de l'individu
		$val['LIBELLE_TITRE_LOGIN']=$libelle_titre_login;
		$val['LIBELLE_LOGIN']=$champs_text_login;	
		
		//Affichage du mot de passe de l'individu				
		$val['LIBELLE_TITRE_MDP']=$libelle_titre_password;
		$val['PASS_TIMESTAMP']=$pass_timestamp;
		$val['LIBELLE_PASS']=$champs_text_password;
		
		//Affichage de la confirmation du mot de passe d'un individu	
		$val['LIBELLE_TITRE_CONFIRMATION_PASS']=$libelle_titre_confirm_password;
		$val['CONFIRME_PASS_TIMESTAMP']= $confirmation_pass_timestamp;
		$val['LIBELLE_CONFIRMATION_PASS']=$champs_text_confirm_password;
		
		//Affichage du nom de l'individu
		$val['LIBELLE_TITRE_NOM']=MSG_7 ;
		$val['LIBELLE_NOM']= $libelle_nom;
		
		//Affichage du prenom de l'individu
		$val['LIBELLE_TITRE_PRENOM']=MSG_8 ;
		$val['LIBELLE_PRENOM']= $libelle_prenom;
		
		//Affichage de l'adresse de l'individu
		$val['LIBELLE_TITRE_ADRESSE']=MSG_9 ;
		$val['LIBELLE_ADR']= $libelle_adresse;
		
		//Affichage du code postal de l'individu
		$val['LIBELLE_TITRE_CP']=MSG_10;
		$val['LIBELLE_CODE']= $libelle_code;
		
		//Affichage de la ville de l'individu
		$val['LIBELLE_TITRE_VILLE']=MSG_11;
		$val['LIBELLE_VILLE']=$libelle_ville;
		
		//Affichage du mail de l'individu'
		$val['LIBELLE_TITRE_MAIL']=MSG_12;
		$val['LIBELLE_MAIL']= $libelle_mail;
		
		//Affichage du numro de tlphone de l'individu
		$val['LIBELLE_TITRE_TEL_FIXE']=MSG_13;
		$val['LIBELLE_TELFIXE']=$libelle_telfixe ;
		
		//Affichage du numro de tlphone portable de l'individu
		$val['LIBELLE_TITRE_TEL_PORT']=MSG_14;
		$val['LIBELLE_TELPORT']= $libelle_telport;
		
		//Affichage de la variable contenant le mot de passe lors de l'envoie du formulaire(dans le hidden)
		$val['TIMESTAMP']="timestamp";
		$val['VALEUR_TIMESTAMP']="pass_".time();
		
		//Affichage de la variable contenant la confirmation du mot de passe lors de l'envoie du formulaire(dans le hidden)
		$val['CONFIRM']="confirm";
		$val['CONFIRM_PASS_TIMESTAMP']="confirm_pass_".time();
		
		//L'identifiant de l'individu(dans le hidden)
		$val['INDIVIDU_NAME'] = "individu";
		$val['INDIVIDU_VALEUR'] = $individu;
		
		//L'identifiant du mode de formulaire
		$val['FORMULAIRE_NAME']="mode_formulaire";
		$val['FORMULAIRE_NUMBER'] = $mode_formulaire;
		
		//Affichage de l'ancien login de l'individu(dans le hidden pour la recuperation)
		$val['OLD_LOGIN_NAME']="old_log";
		$val['OLD_LOGIN_VALEUR'] = $rowindividu[2];
		
		//Affichage du type de l'individu(dans le hidden pour recuperation)
		$val['TYPE']="t";
		$val['VALEUR_TYPE'] = $_GET['t'];
		
		//Affichage de la photo de l'individu(pour le module "Detail")
		$val['LIBELLE_TITRE_PHOTO']=MSG_15;
		$val['URL_CHEMIN_PHOTO']=$url_chemin_photo;
		
		if(empty($rowindividu[14])){
			$val['PHOTO_URL'] =DEFAULT_PHOTO_PATH;
		}else{
			$val['PHOTO_URL'] =$photo_url;
		}
		$val['PHOTO_ALT'] = MSG_15.' '.$champs_text_login;
		$val['PHOTO_TITLE'] = MSG_15.' '.$champs_text_login;
					
		//Affichage de la langue de l'individu(pour le module "Detail")
		$val['LIBELLE_TITRE_LANGUE'] = MSG_1030;
		$val['LIBELLE_LANGUE'] = $libelle_langue;
		
		parent::set_var($val);
	}
}
?>