<?php
/*
	This file is part of Astairs.

    Astairs is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    any later version.

    Astairs is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Astairs.  If not, see <http://www.gnu.org/licenses/>.

	Copyright (C) 2006, 2007, 2008, 2009 AFIDE
    
	Auteurs:

	Said Ladjani <sladjani@yahoo.fr>
	Remi Cocquet <remi.cocquet@gmail.com>

*/

/**
 * Class qui affiche le nom et prenom de l'individu connct et le lien qui envoi vers un formulaire de modification.
 */
class guiBoIndividuEdition extends PageComponent{
	/**
	 * Affichage du libelle nom et prenom ainsi que le lien de direction vers le formulaire de modification.
	 * 
	 * @param object[] $obj_DoFormation Objet contenant toutes les informations de la formation.
	 * @param string $module_root Le chemin du dossier contenant les tpl requis.
 	 * @param string[] $templates Le tableau contenant la variable de destination et le tpl requis pour l'objet.
 	 */
	function guiBoIndividuEdition($id_individu,$module_root=null, $templates=null){
		global $chemin_bo,$root;
		parent::PageComponent($module_root,$templates);
		
		//On recupere le nom et prenom de l individu
		$req_individu = get_individu_nom_prenom($id_individu);
		$row = pg_fetch_array($req_individu);
		
		$val['MODULE_NOM'] = $row[1];
		$val['MODULE_PRENOM']=$row[2];
		$val['LIBELLE_MODIFIER'] = MSG_513;
		$val['LIEN_URL_MODIFIER'] = "../individu/informations_personnelles.php"; 
//		$val['LIEN_URL_MODIFIER'] = "#";
		parent::set_var($val);
	}
}
?>