<?php
/*
	This file is part of Astairs.

    Astairs is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    any later version.

    Astairs is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Astairs.  If not, see <http://www.gnu.org/licenses/>.

	Copyright (C) 2006, 2007, 2008, 2009 AFIDE
    
	Auteurs:

	Said Ladjani <sladjani@yahoo.fr>
	Remi Cocquet <remi.cocquet@gmail.com>

*/

/**
 * Cette class affiche la liste des individu selon leur categorie
 * 
 * @package individu
 */
class guiBoListeIndividu extends PageComponent{
	/**
	 * @param string $message Un texte d'erreur ou de validation d'enregistrement.
	 * @param string $block_target Variable du tpl pre ou sont stocks les lments pour l'affichage de la boucle.
	 * @param string $organisme Le libelle de l'organisme d'un individu.
	 * @param string $action_individu 
	 * @param string $type Le type de l'individu exemple "f = formateur", "u = utilisateur" ou "i = intervenant".
 	 * @param string $module_root Le chemin du dossier contenant les tpl requis.
 	 * @param string[] $templates Le tableau contenant la variable de destination et le tpl requis pour l'objet
	 */	
	function guiBoListeIndividu($block_target,$organisme,$type,$module_root=null,$templates=null){
		
		global $root,$chemin_bo,$t;
		global $MSG_53,$MSG_86,$MSG_266,$MSG_1163,$MSG_51,$MSG_23,$MSG_83,$MSG_7,$MSG_8 ,$MSG_5,$MSG_6;
		global $ERROR_9,$ERROR_10;
		global $FORM_1,$FORM_2,$FORM_3,$FORM_4;
		global $WARN_14,$WARN_18;
		
		//$type=$t;
		parent::PageComponent($module_root,$templates);
		
		$component=new guiSelectOrganisme('selection_organisme',"$root/lib_graphique/selects/selectOrganisme/templates/tpl",array('selection_organisme'=>'gui_select_organisme.tpl'),$organisme,false,'valideorganisme()');
		$this->setComponent('selection_organisme',$component);
			
		
		$val['LIBELLE_TEXTE'] = $MSG_266.": ".$MSG_1163;
		
		$val['TYPE_HIDDEN_1']="<input type=hidden name=\"t\" value=\"$type\">";
		$val['TYPE_HIDDEN_2']="<input type=hidden name=\"action_individu\" value=\"".$_GET['action_individu']."\">";
		
		if($organisme==0)$organisme=null;
		// recup du nom de l'organisme
		if(!empty($organisme)){
		$resorg=get_organisme(int2Sql($organisme));
			if(pg_num_rows($resorg)==1){
				$roworg=pg_fetch_row($resorg,0);
				$row1[1]=$roworg[1];
			}
		}
		else 
			$organisme=0;
		
		if($type==1)
			$liste=$MSG_51;
		else
			$liste=$MSG_23;
			//echo "\$type=$type";
		/*	
		if($type==1)
			$resul=get_organisme_individus(int2Sql($organisme),"ASC",2,'false');
		elseif($type==2)
			$resul=get_organisme_individus(int2Sql($organisme),"ASC",2,'false');
		else
			$resul=get_organisme_individus(int2Sql($organisme),"ASC",0,'false');
		*/
		
		$resul=get_organisme_individus(int2Sql($organisme),"ASC",$type,'false');
		//nombre d'inscrits
		$cnt = pg_NumRows($resul);
		
		//titres des colonnes de tableau
		$val['LIBELLE_TITRE_NOM_PRENOM']="$MSG_7-$MSG_8 ($MSG_5/$MSG_6)";
		$val['LIBELLE_ACTION']=$FORM_1;
			
		if($cnt>0){
			$component=new guiBoListeIndividuElements('liste_individu_elements',$resul,$type,"$chemin_bo/individu/templates/tpl",array('liste_individu_elements'=>'gui_bo_liste_individu_elements.tpl'));
			$this->setComponent('liste_individu_elements',$component);
		}else{
			$val['LIBELLE_TITRE_LISTE']=$ERROR_9;
		}
		$this->set_var($val);
	}
}
?>