<?php
/*
	This file is part of Astairs.

    Astairs is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    any later version.

    Astairs is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Astairs.  If not, see <http://www.gnu.org/licenses/>.

	Copyright (C) 2006, 2007, 2008, 2009 AFIDE
    
	Auteurs:

	Said Ladjani <sladjani@yahoo.fr>
	Remi Cocquet <remi.cocquet@gmail.com>

*/

/**
 * Cette class affiche la liste des individu selon leur categorie
 * 
 * @package individu
 */
class guiBoListeIndividuElements extends PageComponent{
	/**
	 * @param string $message Un texte d'erreur ou de validation d'enregistrement.
	 * @param string $block_target Variable du tpl pre ou sont stocks les lments pour l'affichage de la boucle.
	 * @param string $organisme Le libelle de l'organisme d'un individu.
	 * @param string $action_individu 
	 * @param string $type Le type de l'individu exemple "f = formateur", "u = utilisateur" ou "i = intervenant".
 	 * @param string $module_root Le chemin du dossier contenant les tpl requis.
 	 * @param string[] $templates Le tableau contenant la variable de destination et le tpl requis pour l'objet
	 */	
	function guiBoListeIndividuElements($block_target,$resultat_elements,$type,$module_root=null,$templates=null){
		
		global $chemin_bo, $perm;
		global $MSG_53,$MSG_86,$MSG_266,$MSG_1163,$MSG_51,$MSG_23,$MSG_83,$MSG_7,$MSG_8 ,$MSG_5,$MSG_6;
		global $ERROR_9,$ERROR_10;
		global $FORM_1,$FORM_2,$FORM_3,$FORM_4;
		global $auth;
		
		parent::PageComponent($module_root,$templates);
		
		
		$cnt = pg_NumRows($resultat_elements);
		
		$show_login_infos=$auth->is_root();
				
		$this->set_block($block_target,'block','bloc_nom_prenom');
		for($i=0; $i<$cnt; $i++) {
			$row = pg_fetch_row($resultat_elements, $i);
			$this->set_block_var('LIBELLE_NOM_PRENOM',$row[1] ." ".$row[2]);
			
			if($show_login_infos)$this->set_block_var('LIBELLE_LOGIN_PWD',"($row[3] / $row[4])");
			
			if($perm->have_perm('MOD')){	
				$lienaddmodif="individu.php?action_individu=ajout_modification_individu&idv=$row[0]&t=$type";
				$this->set_block_var('URL_EDITION',$lienaddmodif);
				$this->set_block_var('LIBELLE_EDITION',$FORM_2);
			}
			
			$liendetail="individu.php?action_individu=detail_individu&idv=$row[0]&t=$type";
			
			$this->set_block_var('URL_DETAILS',$liendetail);
			$this->set_block_var('LIBELLE_DETAILS',$FORM_3);

			$this->set_block_var('INDICE_LIGNE',($i%2)+1);

			if(sql2Bool(check_individu_supprimable($row[0]))&&$perm->have_perm('DEL')){
				if($type==2){
					$msg=WARN_14;
				}else{
					$msg=WARN_18;
				}
				$this->set_block_var('JAVASCRIPT_SUPPRESSION',"return Question('$msg');");
				$this->set_block_var('URL_SUPPRESSION',"individu.php?action_individu=suppression_individu&idv=$row[0]&t=$type");
				$this->set_block_var('LIBELLE_SUPPRESSION',$FORM_4);
			}
			else{
				$this->set_block_var('LIBELLE_SUPPRESSION',"");
				$this->set_block_var('JAVASCRIPT_SUPPRESSION',"");
				$this->set_block_var('URL_SUPPRESSION',"");
			}
		}
		
	}
}
?>