<?php
/*
	This file is part of Astairs.

    Astairs is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    any later version.

    Astairs is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Astairs.  If not, see <http://www.gnu.org/licenses/>.

	Copyright (C) 2006, 2007, 2008, 2009 AFIDE
    
	Auteurs:

	Said Ladjani <sladjani@yahoo.fr>
	Remi Cocquet <remi.cocquet@gmail.com>

*/

/**
 * Cette class affiche le select qui permet la selection de la photo que souhaite s'attribuer l'individu.
 * 
 * @package individu
 */
 class guiBoSelectPhoto extends PageComponent{
 	/**
 	 * @param integer $individu L'identifiant de l'individu
 	 * @param string $block_target Variable du tpl pre ou sont stocks les lments pour l'affichage de la boucle 
 	 * @param string $module_root Le chemin du dossier contenant les tpl requis
 	 * @param string[] $templates Le tableau contenant la variable de destination et le tpl requis pour l'objet
	 */
 	function guiBoSelectPhoto ($block_target,$individu_photo_url,$individu_photo_title,$module_root=null , $templates=null){
 		global $astairs_directories, $root,$style_par_defaut,$serverfront;
 		parent::PageComponent($module_root,$templates);
 		
		if(!empty($individu)){ 		
 			$resindividu=get_individu($individu);
			$rowindividu=pg_fetch_row($resindividu,0);
//			print_rr($rowindividu);
		}

		$photo_url=DEFAULT_PHOTO_PATH;
		if(!empty($individu_photo_url)){
			$photo_url=$individu_photo_url;
		}
		
//		$texte_photo=MSG_15.$rowindividu[1];
 		$this->set_var('PHOTO_ALT',$individu_photo_title);
 		$this->set_var('PHOTO_TITLE',$individu_photo_title);
 		$this->set_var('PHOTO_URL',$photo_url);
 		$this->set_var('DEL_PHOTO_LABEL',FORM_4);

		//Le select pour la selection de la photo.
		$this->select_photo = new guiSelectFile('select_photo_file',"$root/lib_graphique/selects/selectFile/templates/tpl/",array('select_photo_file'=>'gui_select_file.tpl'),'photo','',false,'',20);
		$this->setComponent('select_photo_file',$this->select_photo);
		$this->set_var('PHOTO_INFOS','La photo doit avoir une taille maximale de 15Ko, avec des dimensions maximales de 100px * 100px');
 	}
 }
?>